/***************************************************************************
    $Id: smbfilter.cpp,v 1.1 1999/09/14 00:26:29 wdl Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: smbfilter.cpp,v $
    Revision 1.1  1999/09/14 00:26:29  wdl
    Restructuring of directories

    Revision 1.1  1999/09/12 10:26:54  stephan
    Added a filter handler for smb hosts

    Revision 1.2  1999/08/27 16:21:21  wdl
    Standard Headers

 ***************************************************************************/

#include "smbfilter.h"

SMBfilter::SMBfilter(apsfilter &apsCfg,const char *_s_machine,const char *_s_service,const char *_user=0,const char *_pwd=0){
	apsfilterName = apsCfg.getFilterName();
	Filterpath = apsCfg.getPathToFilter();
	ServiceMachine = _s_machine; Service = _s_service; User = _user; Password = _pwd;
}

SMBfilter::~SMBfilter(){
}

void SMBfilter::setup()
{
	QFile *t_file = new QFile(Filterpath + "/smbfilter");
	t_file->open(IO_WriteOnly);
	QTextStream *t_stream = new QTextStream(t_file);
	*t_stream << "#!/bin/sh -x" << endl;
	*t_stream << "(" << endl;
	*t_stream << "cat" << endl << "echo \"print -\"" << endl << ") | " << apsfilterName.data();
	*t_stream << " | smbclient \"\\\\" << ServiceMachine.data() << "\\" << Service.data() << "\"" << Password.data() << " -U ";
	*t_stream << User.data() << " -N -P >> " << Filterpath + "/smblog" <<  "\"" << endl;
	t_file->flush();
	t_file->close();
	delete(t_file);
}

const char *SMBfilter::getFilterName(){
	return Filterpath + "/smbfilter";
}

bool SMBfilter::check()
{
	bool conf;
	conf = false;
	#warning SAMBA check needs heavy improvements
	if(system("which smbclient") != 0) return false;
	QFile *t_file = new QFile("/etc/smb.conf");
	if(t_file->exists()) conf = true;
	delete(t_file);
	if(!conf) return false;
	return true;
}

QList<QString> SMBfilter::browse(const char *host,const char *ip=0){
	QList<QString> t_lst;
	t_lst.clear();
	return t_lst;
}


