/***************************************************************************
    $Id: apsfilter.cpp,v 1.1 1999/09/14 00:26:24 wdl Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: apsfilter.cpp,v $
    Revision 1.1  1999/09/14 00:26:24  wdl
    Restructuring of directories

    Revision 1.6  1999/09/12 10:28:11  stephan
    Bugfixes and some changes for the shared lib

    Revision 1.5  1999/09/09 06:01:57  stephan
    Added OO style spool handling (by using KpcSpool)

    Revision 1.4  1999/08/27 16:43:00  wdl
    Standard Headers

 ***************************************************************************/
#include "apsfilter.h"

apsfilter::apsfilter( const char *pathToAps){
	setPathToAPS(pathToAps);
}

apsfilter::~apsfilter(){
}

bool apsfilter::setup(apsfilterConfig &cfg){
	QString *linkName = new QString("aps");
	QString *tmpStr = new QString;
	QString *t_Str = new QString;
	*tmpStr = cfg.getGSDriver();
  if(tmpStr->isEmpty()) return false;
	linkName->append("-");
	linkName->append(cfg.getGSDriver());

	*tmpStr = cfg.getPaperSize();
	if(!tmpStr->isEmpty()) {
		linkName->append("-");
		linkName->append(cfg.getPaperSize());
	} else { linkName->append("-default"); }

	*tmpStr = cfg.getTypeRecognition();
	if(tmpStr->isEmpty()) return false;
	linkName->append("-");
	linkName->append(cfg.getTypeRecognition());

	if(cfg.isEnableColor()) {
			linkName->append("-");
		  linkName->append("color");
  } else {
			linkName->append("-");
			linkName->append("mono");
	}

	*tmpStr = cfg.getResolution();
	if(!tmpStr->isEmpty()) {
			linkName->append("-");
			linkName->append(cfg.getResolution());
	}
	FltName = *linkName;
	linkName->prepend("/");
  linkName->prepend(cfg.getFilterDir());
	FilterName = *linkName;
	printf("\nFilterName = %s\n",FilterName.data());
	linkName->prepend("/apsfilter ");
  linkName->prepend(PathToAPS.data());
	linkName->prepend("ln -s ");	
	if(system(linkName->data()) != 0) return false;
	*t_Str = "chmod +x ";
	t_Str->append(FilterName.data());
	if(system(t_Str->data()) !=0) return false;
	*tmpStr = cfg.getGSoptions();
	if(!tmpStr->isEmpty()) {
		QString *tempStr = new QString("/etc/apsfilterrc.");
		tempStr->append(cfg.getGSDriver());
		QFile *devAPSfile = new QFile(PathToFilter + "/kpc.cfg");
		QTextStream *strm = new QTextStream( devAPSfile );
		devAPSfile->open( IO_WriteOnly );
		*strm << "GS_FEATURES=" << cfg.getGSoptions() << endl;
		devAPSfile->close();
		delete(strm);
		delete(devAPSfile);
		delete(tempStr);
	}
	delete(linkName);
	delete(tmpStr);
	delete(t_Str);
	return true;	
}









