/***************************************************************************
    $Id: printerselection.cpp,v 1.2 1999/09/30 20:46:46 wdl Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: printerselection.cpp,v $
    Revision 1.2  1999/09/30 20:46:46  wdl
    fixed some things with pointers in kpclib for removeprinter

    Revision 1.1  1999/09/19 13:46:45  wdl
    First verion of kcmkpc with 2 extra dialogs printerselection and printerconfig

 ***************************************************************************/

#include "kpcwizard.h"
#include "printerselection.h"
#include "printerconfig.h"
#include "kpcapi.h"

PrinterSelection::PrinterSelection(QWidget *parent, const char *name) : QDialog(parent,name){
	KTreeListItem *tmpTreeItem;

	KpcAPI *t_kpcAPI = new KpcAPI;
	QList<QString> *tmpInstalledPrinters = new QList<QString>;
	QString *tmpPrinter = new QString;

	initDialog();
	connect( btnOk, SIGNAL(clicked()), SLOT(OkClicked()));
	connect( btnAdd, SIGNAL(clicked()), SLOT(AddClicked()));
	connect( btnModify, SIGNAL(clicked()), SLOT(ModifyClicked()));

	*tmpInstalledPrinters = t_kpcAPI->getInstalledPrinters(KpcPrinter::local);

	tmpTreeItem = new KTreeListItem;
	tmpTreeItem->setText(i18n("Local"));
	tmpTreeItem->setPixmap(new QPixmap(kapp->kde_icondir() + "/mini/folder.xpm"));
	for(tmpPrinter = tmpInstalledPrinters->first(); tmpPrinter !=0; tmpPrinter = tmpInstalledPrinters->next()){
		tmpTreeItem->appendChild(new KTreeListItem(tmpPrinter->data(), new QPixmap(kapp->kde_icondir() + "/mini/printer.xpm")));
	}
	printerTreeView->insertItem(tmpTreeItem);

	tmpTreeItem = new KTreeListItem;
	tmpTreeItem->setText(i18n("Network"));
	tmpTreeItem->setPixmap(new QPixmap(kapp->kde_icondir() + "/mini/folder.xpm"));

	*tmpInstalledPrinters = t_kpcAPI->getInstalledPrinters(KpcPrinter::lpd);
	for(tmpPrinter = tmpInstalledPrinters->first(); tmpPrinter !=0; tmpPrinter = tmpInstalledPrinters->next()){
		tmpTreeItem->appendChild(new KTreeListItem(tmpPrinter->data(), new QPixmap(kapp->kde_icondir() + "/mini/printer.xpm")));
	}
	*tmpInstalledPrinters = t_kpcAPI->getInstalledPrinters(KpcPrinter::smb);
	for(tmpPrinter = tmpInstalledPrinters->first(); tmpPrinter !=0; tmpPrinter = tmpInstalledPrinters->next()){
		tmpTreeItem->appendChild(new KTreeListItem(tmpPrinter->data(), new QPixmap(kapp->kde_icondir() + "/mini/printer.xpm")));
	}
	printerTreeView->insertItem(tmpTreeItem);

}

void PrinterSelection::OkClicked(){
	kapp->quit();
}

void PrinterSelection::AddClicked(){
  KpcWizard *kpcwizard = new KpcWizard(this, "KpcWizard", true);
  kpcwizard->exec();
}

void PrinterSelection::ModifyClicked(){
	PrinterConfig *printerconfig = new PrinterConfig(this, "PrinterConfig", true);
	printerconfig->exec();
}

void PrinterSelection::RemoveClicked() {
	KpcAPI *t_kpcAPI = new KpcAPI;
	KpcPrinter *t_prt = new KpcPrinter();
	QString *t_str = new QString(printerTreeView->getCurrentItem()->getText());
	QString *t_man_str = new QString;
	QString *t_model_str = new QString;

	*t_man_str = *t_str;
	t_man_str->truncate(t_str->find(" "));
	*t_model_str = *t_str;

	printf("\ndbName(wizard): %s | %s\n",t_model_str->replace(QRegExp(*t_man_str + " "),"").data(),t_man_str->data());
	t_prt->setModel(t_model_str->replace(QRegExp(*t_man_str + " "),"").data());
	t_prt->setDbName(t_model_str->replace(QRegExp(*t_man_str + " "),"").data());
	t_prt->setManufactor(t_man_str->data());
	t_kpcAPI->removePrinter(t_prt);

	printerTreeView->removeItem(printerTreeView->itemIndex(printerTreeView->getCurrentItem()));
}

PrinterSelection::~PrinterSelection(){
}






















