/************************************************************************
 * kinst - KDE Application Installer - libverchk.cpp                    *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "libverchk.h"

long int str2val(char* string)
{
  int i, w, k;
  long int result;

  result = 0;
  k = 0;

  if((strlen(string) == 0) || (string == NULL)) return(0);

  for(i = strlen(string) -1;i >= 0;i--)
    {
      switch(string[i])
	{
	case '0': w = 0;
	  break;
	case '1': w = 1;
	  break;
	case '2': w = 2;
	  break;
	case '3': w = 3;
	  break;
	case '4': w = 4;
	  break;
	case '5': w = 5;
	  break;
	case '6': w = 6;
	  break;
	case '7': w = 7;
	  break;
	case '8': w = 8;
	  break;
	case '9': w = 9;
	  break;
	default: w = 0;
	  i++;
	  k--;
	  break;
	}

      result += w * (long int) pow(10, k);
      k++;
    }

  return(result);
}

int libversioncheck(char* filename1, char* filename2)
{
  char *temp;
  char fileversion1[65535];
  char fileversion2[65535];
  int ver_maj, ver_min1, ver_min2;
  int need_maj, need_min1, need_min2;
  char s_ver_maj[100];
  char s_ver_min1[100];
  char s_ver_min2[100];
  long int i, w, start;

  ver_maj = 0;
  ver_min1 = 0;
  ver_min2 = 0;

  need_maj = 0;
  need_min1 = 0;
  need_min2 = 0;

  if(strlen(filename1) > 65534) return(2);
  if(strlen(filename2) > 65534) return(2);

  temp = strstr(filename1, ".so.");
  if(temp != NULL) strcpy(fileversion1, temp + 4);
  else return(2);

  temp = strstr(filename2, ".so.");
  if(temp != NULL) strcpy(fileversion2, temp + 4);
  else return(2);

  // -- ver
  start = 0;
  w = 0;
  strcpy(s_ver_maj, "");
  for(i = start;i <= (long int) strlen(fileversion1);i++)
    {
      if(fileversion1[i] == 0)
	{
	  s_ver_maj[w] = 0;
	  i = strlen(fileversion1);
	  start = strlen(fileversion1);
	}
      else
	if(fileversion1[i] != '.')
	  {
	    s_ver_maj[w] = fileversion1[i];
	    w++;
	  }
	else
	  {
	    s_ver_maj[w] = 0;
	    start = i + 1;
	    i = strlen(fileversion1);
	  }
    }
  ver_maj = str2val(s_ver_maj);

  w = 0;
  strcpy(s_ver_min1, "");
  for(i = start;i <= (long int) strlen(fileversion1);i++)
    {
      if(fileversion1[i] == 0)
	{
	  s_ver_min1[w] = 0;
	  i = strlen(fileversion1);
	  start = strlen(fileversion1);
	}
      else
	if(fileversion1[i] != '.')
	  {
	    s_ver_min1[w] = fileversion1[i];
	    w++;
	  }
	else
	  {
	    s_ver_min1[w] = 0;
	    start = i + 1;
	    i = strlen(fileversion1);
	  }
    }
  ver_min1 = str2val(s_ver_min1);

  w = 0;
  strcpy(s_ver_min2, "");
  for(i = start;i <= (long int) strlen(fileversion1);i++)
    {
      if(fileversion1[i] == 0)
	{
	  s_ver_min2[w] = 0;
	  i = strlen(fileversion1);
	  start = strlen(fileversion1);
	}
      else
	if(fileversion1[i] != '.')
	  {
	    s_ver_min2[w] = fileversion1[i];
	    w++;
	  }
	else
	  {
	    s_ver_min2[w] = 0;
	    start = i + 1;
	    i = strlen(fileversion1);
	  }
    }
  ver_min2 = str2val(s_ver_min2);

  // -- need
  start = 0;
  w = 0;
  strcpy(s_ver_maj, "");
  for(i = start;i <= (long int) strlen(fileversion2);i++)
    {
      if(fileversion2[i] == 0)
	{
	  s_ver_maj[w] = 0;
	  i = strlen(fileversion2);
	  start = strlen(fileversion2);
	}
      else
	if(fileversion2[i] != '.')
	  {
	    s_ver_maj[w] = fileversion2[i];
	    w++;
	  }
	else
	  {
	    s_ver_maj[w] = 0;
	    start = i + 1;
	    i = strlen(fileversion2);
	  }
    }
  need_maj = str2val(s_ver_maj);

  w = 0;
  strcpy(s_ver_min1, "");
  for(i = start;i <= (long int) strlen(fileversion2);i++)
    {
      if(fileversion2[i] == 0)
	{
	  s_ver_min1[w] = 0;
	  i = strlen(fileversion2);
	  start = strlen(fileversion2);
	}
      else
	if(fileversion2[i] != '.')
	  {
	    s_ver_min1[w] = fileversion2[i];
	    w++;
	  }
	else
	  {
	    s_ver_min1[w] = 0;
	    start = i + 1;
	    i = strlen(fileversion2);
	  }
    }
  need_min1 = str2val(s_ver_min1);

  w = 0;
  strcpy(s_ver_min2, "");
  for(i = start;i <= (long int) strlen(fileversion2);i++)
    {
      if(fileversion2[i] == 0)
	{
	  s_ver_min2[w] = 0;
	  i = strlen(fileversion2);
	  start = strlen(fileversion2);
	}
      else
	if(fileversion2[i] != '.')
	  {
	    s_ver_min2[w] = fileversion2[i];
	    w++;
	  }
	else
	  {
	    s_ver_min2[w] = 0;
	    start = i + 1;
	    i = strlen(fileversion2);
	  }
    }
  need_min2 = str2val(s_ver_min2);

#ifdef _DEBUG_
  printf("libverchk:  Actual Version : %i.%i.%i\n", ver_maj, ver_min1,
	 ver_min2);
  printf("libverchk:  Needed Version : %i.%i.%i\n", need_maj, need_min1,
	 need_min2);
#endif

  if(ver_maj > need_maj)
    {
#ifdef _DEBUG_
      printf("libverchk:  library version is OK.\n");
#endif
      return(1);
    }

  if(ver_maj < need_maj)
    {
#ifdef _DEBUG_
      printf("libverchk:  library version is insufficient!\n");
#endif
      return(0);
    }

  if(ver_min1 > need_min1)
    {
#ifdef _DEBUG_
      printf("libverchk:  library version is OK.\n");
#endif
      return(1);
    }

  if(ver_min1 < need_min1)
    {
#ifdef _DEBUG_
      printf("libverchk:  library version is insufficient!\n");
#endif
      return(0);
    }

  if(ver_min2 > need_min2)
    {
#ifdef _DEBUG_
      printf("libverchk:  library version is OK.\n");
#endif
      return(1);
    }

  if(ver_min2 < need_min2)
    {
#ifdef _DEBUG_
      printf("libverchk:  library version is insufficient!\n");
#endif
      return(0);
    }

#ifdef _DEBUG_
  printf("libverchk:  library version is OK.\n");
#endif

  return(1);
}
