#include "KServerSheet.h"
#include <qradiobt.h>
#include <qlined.h>
#include <qbttngrp.h>

#include "KServerSheet.moc"

KServerSheet::KServerSheet() : KSheet("Choose server path") {
  QButtonGroup* grp = new QButtonGroup(this);
  
  m_pInternal = new QRadioButton("internal", grp);
  m_pTCP = new QRadioButton("/usr/sbin/tcpd", grp);
  m_pOther = new QRadioButton("other", grp);
  m_pEdit = new QLineEdit(grp);

  connect(m_pInternal, SIGNAL(clicked()), SLOT(buttonPressed()));
  connect(m_pTCP, SIGNAL(clicked()), SLOT(buttonPressed()));
  connect(m_pOther, SIGNAL(clicked()), SLOT(buttonPressed()));
  connect(m_pEdit, SIGNAL(textChanged(const char*)), SLOT(editChanged(const char*)));
  m_pInternal->setGeometry(5, 5, 100, 25);
  m_pTCP->setGeometry(5, 30, 100, 25);
  m_pOther->setGeometry(5, 55, 100, 25);
  m_pEdit->setGeometry(10, 80, 90, 25);
  grp->setGeometry(10, 10, 160, 120);

  m_pInternal->show();
  m_pTCP->show();
  m_pOther->show();
  m_pEdit->show();
  grp->show();
  m_pTCP->setChecked(TRUE);
  m_pEdit->setEnabled(FALSE);
  resize(170, 130);
}

bool KServerSheet::allowNext() {
  if(m_pInternal->isChecked())
    return FALSE;
  else if(m_pOther->isChecked()) {
    if(m_pEdit->text() && *m_pEdit->text())
      return TRUE;
    return FALSE;
  } else { // TCP wrapper chosen
    return TRUE;
  }
}

bool KServerSheet::allowFinish() {
  return  m_pInternal->isChecked();
}

void KServerSheet::buttonPressed() {
  if(m_pInternal->isChecked()) {
    emit disableNext();
    emit enableFinish();
    m_pEdit->setEnabled(FALSE);
  } else if(m_pOther->isChecked()) {
    if(m_pEdit->text() && *m_pEdit->text())
      emit enableNext();
    else
      emit disableNext();
    emit disableFinish();
    m_pEdit->setEnabled(TRUE);
  } else { // TCP Wrapper clicked
    emit disableFinish();
    emit enableNext();
    m_pEdit->setEnabled(FALSE);
  }
}

void KServerSheet::editChanged(const char* txt) {
  if(txt && *txt)
    emit enableNext();
  else
    emit disableNext();
}

QString KServerSheet::getAnswer() {
  if(m_pTCP->isChecked())
    return QString(m_pTCP->text());
  else if(m_pInternal->isChecked())
    return QString(m_pInternal->text());
  else
    return QString(m_pEdit->text());
}
