/***************************************************************************
                          khLMprofile.cpp  -  description
                             -------------------
    begin                : Tue Aug 31 1999
    copyright            : (C) 1999 by Ruediger Anlauf
    email                : Ruediger.Anlauf@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

extern "C" {
#include <stdlib.h>
}
#include "khlmprofile.h"


KHLMProfile::KHLMProfile( sensors_chip_name chipname ) : KHFeatureProfile( chipname ) {
	parseFeatures();
}

KHLMProfile::~KHLMProfile(){
}

SensorId *KHLMProfile::storeFeature( sensors_feature_data feature ){
  static SensorId sid;
	char *buffer = 0;
	ChipType chiptype;

	// if the entry is valid ( valid label exists ), do the job

	if ( !sensors_get_label( chipname, feature.number, &buffer ) ){
		debug( "%i\t%s", feature.number, buffer );
  	if ( QString( buffer ) == "fan1" ) sid = Fan1; else
		if ( QString( buffer ) == "fan2" ) sid = Fan2; else
		if ( QString( buffer ) == "fan3" ) sid = Fan3; else
		if ( ( QString( buffer ) == "temp1" ) || ( QString( buffer ) == "temp" ) ) sid = Temp1; else
		if ( QString( buffer ) == "temp2" ) sid = Temp2; else
		if ( QString( buffer ) == "temp3" ) sid = Temp3; else
		if ( QString( buffer ) == "VCore 1" ) sid = VCore; else
		if ( QString( buffer ) == "VCore 2" ) sid = VCore2; else
		if ( QString( buffer ) == "+3.3V" ) sid = V33; else
		if ( QString( buffer ) == "+5V" ) sid = V5;	else
		if ( QString( buffer ) == "-5V" ) sid = Vm5; else
		if ( QString( buffer ) == "+12V" ) sid = V12; else
		if ( QString( buffer ) == "-12V" ) sid = Vm12; else
		if ( QString( buffer ) == "sensor1" ) sid = Sensor1; else
		if ( QString( buffer ) == "sensor2" ) sid = Sensor2; else
		if ( QString( buffer ) == "sensor3" ) sid = Sensor3; else
		if ( QString( buffer ) == "beeps" ) sid = BeepControl; else
		if ( QString( buffer ) == "beep_enable" ) sid = GlobalBeep; else
		if ( QString( buffer ) == "vid" ) sid = VID;
		else {
			free( buffer );
			return 0;
		}
  	profile[sid].number = feature.number;
		profile[sid].enabled = true;
		profile[sid].Name = buffer;
		if ( ( sid >= Fan1 ) && ( sid <= VID ) ) count++;
		debug( "enabling %i", sid );

		// correlate the feature with its alarm binding

		if ( QString( chipname.prefix ) == "w83781d" ) chiptype = w83781d; else
		if ( QString( chipname.prefix ) == "w83782d" ) chiptype = w83782d; else
		if ( QString( chipname.prefix ) == "w83783s" ) chiptype = w83783s; else
		if ( QString( chipname.prefix ) == "lm75" ) chiptype = LM7X; else
   	if ( QString( chipname.prefix ) == "lm78" ) chiptype = LM7X; else
	 	if ( QString( chipname.prefix ) == "lm78-j" ) chiptype = LM7X; else
	 	if ( QString( chipname.prefix ) == "lm79" ) chiptype = LM7X; else
 	 	if ( QString( chipname.prefix ) == "lm80" ) chiptype = LM80; else
		{
			debug ( "Couldn't determine chip type" );
			free ( buffer );
			return 0;
		}

  	if ( QString( feature.name ) == "in0" ) profile[sid].alarm = alarmBindings[chiptype][in0]; else
		if ( QString( feature.name ) == "in1" ) profile[sid].alarm = alarmBindings[chiptype][in1]; else
		if ( QString( feature.name ) == "in2" ) profile[sid].alarm = alarmBindings[chiptype][in2]; else
		if ( QString( feature.name ) == "in3" ) profile[sid].alarm = alarmBindings[chiptype][in3]; else
		if ( QString( feature.name ) == "in4" ) profile[sid].alarm = alarmBindings[chiptype][in4]; else
		if ( QString( feature.name ) == "in5" ) profile[sid].alarm = alarmBindings[chiptype][in5]; else
		if ( QString( feature.name ) == "in6" ) profile[sid].alarm = alarmBindings[chiptype][in6]; else
		if ( QString( feature.name ) == "in7" ) profile[sid].alarm = alarmBindings[chiptype][in7]; else
		if ( QString( feature.name ) == "in8" ) profile[sid].alarm = alarmBindings[chiptype][in8]; else
		if ( QString( feature.name ) == "fan1" ) profile[sid].alarm = alarmBindings[chiptype][fan1]; else
		if ( QString( feature.name ) == "fan2" ) profile[sid].alarm = alarmBindings[chiptype][fan2]; else
		if ( QString( feature.name ) == "fan3" ) profile[sid].alarm = alarmBindings[chiptype][fan3]; else
		if ( ( QString( feature.name ) == "temp1" ) || ( QString( feature.name ) == "temp" ) ) profile[sid].alarm = alarmBindings[chiptype][temp1]; else
		if ( QString( feature.name ) == "temp2" ) profile[sid].alarm = alarmBindings[chiptype][temp2]; else
		if ( QString( feature.name ) == "temp3" ) profile[sid].alarm = alarmBindings[chiptype][temp3]; else
		if ( QString( feature.name ) == "chass" ) profile[sid].alarm = alarmBindings[chiptype][chass]; else
		debug( "KHFeatureProfile: couldn't determine alarm binding: %s", feature.name );
	
		debug( "alarm: %i", profile[sid].alarm );

		free( buffer );
		return &sid;
	}
	return 0;
}