/***************************************************************************
                          khconfigitem.h  -  description                              
                             -------------------                                         
    begin                : Wed Sep 29 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KHCONFIGITEM_H
#define KHCONFIGITEM_H

#include "sensorid.h"
#include <qwidget.h>

class QGridLayout;
class QCheckBox;
class QGroupBox;
class QLabel;
class KHButtonPair;
class KHTab1;

/**
  *@author Ruediger Anlauf
  */

class KHConfigItem : public QWidget  {

   Q_OBJECT

public:
	KHConfigItem( SensorId sid, QWidget *parent=0, const char *name=0 );
	~KHConfigItem();
  /**  */
  void setEnableButton( bool enabled );
  /**  */
  void setFaultsButton( int value );
  /**  */
  void setBeepButton( bool pressed );
  /**  */
  bool beepIsActivated();
  /**  */
  bool enableIsActivated();
  /**  */
  bool hasBeepButton();
  /**  */
	static void setLayout( QGridLayout *grid );

public:
	enum ButtonId { ButtonEnable = 1, ButtonFaultsLeft = 2, ButtonFaultsRight = 3, ButtonBeep = 4 };

protected:
	QCheckBox *enable;
	KHButtonPair *faults;
	QCheckBox *beep;
	QLabel *label;
	static int itemCount;
	static QGridLayout *grid;

private slots: // Private slots
  /**  */
  void forwardClick();

signals: // Signals
  /**  */
  void clicked( KHConfigItem::ButtonId );
};

#endif













































