/***************************************************************************
                          khbuttonpair.h  -  description
                             -------------------                                         
    begin                : Wed Aug 4 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KHBUTTONPAIR_H
#define KHBUTTONPAIR_H

#include <qbutton.h>

class QWidget;
class QLayout;
class QGridLayout;
class QBoxLayout;
class QCheckBox;
class QButtonGroup;

/** Creates a pair of checkboxes and adds them to an existing grid layout.
	* The buttons are exclusive, so there can only be one button down at a time.
  * @author Ruediger Anlauf
	* @short a widget providing two horizontal buttons
  */

class KHButtonPair : public QButton {

Q_OBJECT

public:
	/** constructor: creates a pair of checkboxes in a horizontal layout, which have
		* parent as their parent. The horizontal box layout is added to the parent grid
		* layout as a sublayout at the position designated by row and col.
		* @param parent the parent widget for the buttons
		* @param parentLayout the parent grid layout to add the buttons to
		* @param row row where the buttons are added
		* @param col column where the buttons are added		
		*/	
	KHButtonPair( QWidget* parent = 0, const char* name = 0 );

	/** destructor */
	~KHButtonPair();

	/** returns whether the left of the right button is pressed */
	bool leftPressed();

	/** returns the horizontal box layout this widget uses internally for proper positioning */
	QLayout *layout();
  /**  */
  QSize size();

protected:
  /** the left button of the widget */
  QCheckBox *lb;

  /** the right button of the widget */
  QCheckBox *rb;

	/** the horizontal box layout */
	QBoxLayout* hbox;

	/** a button group; for internal use only */
	QButtonGroup *bbox;

	/** the button that is actually pressed */
	int pressedButton;

	int spacing;

public slots:
	/** if true, sets the left button down
		*
		*
		* if false, sets the right button down
		*
		*
		* there can only be one button down at a time
		*/
	void setLeftButtonDown( bool value );

private slots:
	/** emits pressed when a button is pressed and sets pressedButton
		*to the appropriate number ( 0 for left, 1 for right );
		*internal use only
		*/
	void emitPressed( int button );

	/** emits released when a button is pressed and sets pressedButton
		* to the appropriate number ( 0 for left, 1 for right );
		* internal use only
		*/
	void emitReleased( int button );

	/** emits clicked when a button is clicked
    * internal use only
		*/
	void emitClicked( int button );
	
signals:
	/** emitted when a button is pressed */
	void pressed();

	/** emitted when a button is released */
	void released();

	/** emitted when a button is clicked */
	void clicked();

};

#endif

























