#include "editentry.moc"


// -- class EditEntry implementation

EditEntry::EditEntry(bool _syscron, CronRow *row, QWidget *parent,
                     const char *name)
 : QWidget(parent, name)
{
  setupArrays();
  activatedMonth = activatedDays = 0;
  syscron  = _syscron;
  editRow  = row;
  editMode = (editRow) ? TRUE : FALSE;

  if (!editRow)
    setCaption(i18n("New crontab entry"));
  else
  {
    setCaption(i18n("Edit crontab entry"));
    editRow->setIsEdited(TRUE);
  }

  labCommand = new QLabel(this, "labCommand");
  labCommand->setGeometry(10, 10, 100, 20);
  labCommand->setText(i18n("&Command"));
  labCommand->setAlignment(AlignLeft | AlignVCenter);
  labCommand->setMargin(-1);

  leCommand = new QLineEdit(this, "leCommand");
  leCommand->setGeometry(10, 30, 424, 30);
  leCommand->setMaxLength(100);
  leCommand->setFrame(TRUE);
  labCommand->setBuddy(leCommand);

  dropZone = new KDNDDropZone(leCommand, DndURL);
  connect(dropZone, SIGNAL(dropAction(KDNDDropZone *)),
          this, SLOT(slotDropAction(KDNDDropZone *)));


  labComment = new QLabel(this, "labComment");
  labComment->setGeometry(10, 64, 100, 20);
  labComment->setText(i18n("C&omment"));
  labComment->setAlignment(AlignLeft | AlignVCenter);
  labComment->setMargin(-1);

  leComment = new QLineEdit(this, "leComment");
  leComment->setGeometry(10, 84, 424, 30);
  leComment->setMaxLength(100);
  leComment->setFrame(TRUE);
  labComment->setBuddy(leComment);


  labUser = new QLabel(this, "labUser");
  labUser->setGeometry(10, 118, 100, 20);
  labUser->setText(i18n("U&ser"));
  labUser->setAlignment(AlignLeft | AlignVCenter);
  labUser->setMargin(-1);
  
  qbUserList = new QComboBox(FALSE, this, "qbUserList");
  qbUserList->setGeometry(10, 138, 170, 30);
  qbUserList->setEnabled(syscron);
  labUser->setBuddy(qbUserList);


  labHour = new QLabel(this, "labHour");
  labHour->setGeometry(10, 172, 80, 20);
  labHour->setText(i18n("Ho&ur"));
  labHour->setAlignment(AlignLeft | AlignVCenter);
  labHour->setMargin(-1);

  leHour = new QLineEdit(this, "leHour");
  leHour->setGeometry(10, 192, 80, 30);
  leHour->setMaxLength(100);
  leHour->setFrame(TRUE);
  leHour->setValidator(new CronValidator(0, 23));
  labHour->setBuddy(leHour);


  labMinute = new QLabel(this, "labMinute");
  labMinute->setGeometry(100, 172, 80, 20);
  labMinute->setText(i18n("&Minute"));
  labMinute->setAlignment(AlignLeft | AlignVCenter);
  labMinute->setMargin(-1);

  leMinute = new QLineEdit(this, "leMinute");
  leMinute->setGeometry(100, 192, 80, 30);
  leMinute->setMaxLength(100);
  leMinute->setFrame(TRUE);
  leMinute->setValidator(new CronValidator(0, 59));
  labMinute->setBuddy(leMinute);


  labDay = new QLabel(this, "labDay");
  labDay->setGeometry(190, 118, 100, 20);
  labDay->setText(i18n("&Day"));
  labDay->setAlignment(AlignLeft | AlignVCenter);
  labDay->setMargin(-1);

  ntDay = new NumTbl(8, 31, this, "ntDay");
  ntDay->move(190, 138);
  labDay->setBuddy(ntDay);

  
  labWeekday = new QLabel(this, "labWeekday");
  labWeekday->setGeometry(10, 226, 100, 20);
  labWeekday->setText(i18n("&Weekday"));
  labWeekday->setAlignment(AlignLeft | AlignVCenter);
  labWeekday->setMargin(-1);

  frWeekday = new QFrame(this, "frWeekday");
  frWeekday->setGeometry(10, 246, 170, 260);
  frWeekday->setFrameStyle(QFrame::Box | QFrame::Sunken);

  for (int i = 0; i < 7; i++)
  {
    cbWeekday[i] = new QCheckBox(this);
    cbWeekday[i]->setText(weekdays[i]);
    cbWeekday[i]->setGeometry(20, i * 30 + 256 , 100, 30);
    connect(cbWeekday[i], SIGNAL(toggled(bool)),
            SLOT(slotWeekdaySelected(bool)));
  }
  labWeekday->setBuddy(cbWeekday[0]);

  rbEveryWeekday = new QRadioButton(this, "rbEveryWeekday");
  rbEveryWeekday->setGeometry(20, 466, 150, 30);
  rbEveryWeekday->setText(i18n ("Every Day"));
  connect(rbEveryWeekday, SIGNAL(clicked()), SLOT (slotEveryWeekday()));


  labMonth = new QLabel(this, "labWeekday");
  labMonth->setGeometry(190, 226, 100, 20);
  labMonth->setText(i18n("Mo&nth"));
  labMonth->setAlignment(AlignLeft | AlignVCenter);
  labMonth->setMargin(-1);

  frMonth = new QFrame(this, "frMonth");
  frMonth->setGeometry(190, 246, 244, 260);
  frMonth->setFrameStyle(QFrame::Box | QFrame::Sunken);

  for (int i = 0; i < 12; i++)
  {
    cbMonth[i] = new QCheckBox(this);
    cbMonth[i]->setText(months[i]);

    if (i < 7)
      cbMonth[i]->setGeometry(200, i * 30 + 256 , 100, 30 );
    else
      cbMonth[i]->setGeometry(310, (i - 7) * 30 + 256 , 100, 30);

    connect(cbMonth[i], SIGNAL(toggled(bool)),
            SLOT(slotMonthSelected(bool)));
  }
  labMonth->setBuddy(cbMonth[0]);

  rbEveryMonth = new QRadioButton(this, "rbEveryMonth");
  rbEveryMonth->setGeometry(200, 466, 220, 30);
  rbEveryMonth->setText(i18n("Every Month"));
  connect(rbEveryMonth, SIGNAL(clicked()), SLOT(slotEveryMonth()));


  frButtons = new QFrame(this, "frButtons");
  frButtons->setGeometry(10, 510, 424, 50);
  frButtons->setFrameStyle(QFrame::Box | QFrame::Sunken);

  pbOk = new QPushButton(this, "pbOk");
  pbOk->setGeometry(20, 520, 100, 30);
  pbOk->setText(i18n("OK"));
  connect(pbOk, SIGNAL(clicked()), SLOT(slotOk()));

  pbCancel = new QPushButton(this, "pbCancel");
  pbCancel->setGeometry(130, 520, 100, 30);
  pbCancel->setText(i18n("Cancel"));
  connect(pbCancel, SIGNAL(clicked()), SLOT(slotCancel()));

  pbHelp2 = new QPushButton(this);
  pbHelp2->setGeometry(324, 520, 100, 30);
  pbHelp2->setText(i18n("Help"));
  connect(pbHelp2, SIGNAL(clicked()), SLOT(slotHelp()));

  accel = new QAccel(this);
  accel->connectItem(accel->insertItem(Key_F1), this, SLOT(slotHelp()));
  accel->connectItem(accel->insertItem(Key_Return), this, SLOT(slotOk()));
  accel->connectItem(accel->insertItem(Key_Escape), this, SLOT(slotCancel()));

  setFixedSize(444, 570);

  setWidgets();
  leCommand->setFocus();
}

EditEntry::~EditEntry()
{
}

void EditEntry::setUser(QStrList *_userList, QString user)
{
  QString temp = user;

  if (syscron && editRow) temp = editRow->getUser();

  qbUserList->clear();
  qbUserList->insertStrList(_userList);
  
  for (int i = 0; i < qbUserList->count(); i++)
    if (qbUserList->text(i) == temp)
      qbUserList->setCurrentItem(i);
}

void EditEntry::setupArrays()
{
  weekdays[0] = i18n("Sunday");
  weekdays[1] = i18n("Monday");
  weekdays[2] = i18n("Tuesday");
  weekdays[3] = i18n("Wednesday");
  weekdays[4] = i18n("Thursday");
  weekdays[5] = i18n("Friday");
  weekdays[6] = i18n("Saturday");

  months[0]  = i18n("January");
  months[1]  = i18n("February");
  months[2]  = i18n("March");
  months[3]  = i18n("April");
  months[4]  = i18n("May");
  months[5]  = i18n("June");
  months[6]  = i18n("July");
  months[7]  = i18n("August");
  months[8]  = i18n("September");
  months[9]  = i18n("October");
  months[10] = i18n("November");
  months[11] = i18n("December");
}

void EditEntry::setWidgets()
{
  bool *sel;

  rbEveryWeekday->setChecked(TRUE);
  rbEveryMonth->setChecked(TRUE);

  if (editRow)
  {
    leCommand->setText(editRow->getCommand());
    leComment->setText(editRow->getComment());
    leHour->setText(editRow->getHour());
    leMinute->setText(editRow->getMinute());

    if (editRow->getDOM() != "*")
    {
      sel = parse(editRow->getDOM(), 1, 31);
         ntDay->setSelection(sel);
         delete[] sel;
    }

    if (editRow->getDOW() != "*")
    {
      sel = parse(editRow->getDOW(), 0, 6);
      for (int i = 0; i < 7; i++)
        if (sel[i])
        {
          cbWeekday[i]->setChecked(TRUE);
          rbEveryWeekday->setChecked(FALSE);
        }
      delete[] sel;
    }

    if (editRow->getMonth() != "*")
    {
      sel = parse(editRow->getMonth(), 1, 12);
      for (int i = 0; i < 12; i++)
        if (sel[i])
        {
          cbMonth[i]->setChecked(TRUE);
          rbEveryMonth->setChecked(FALSE);
        }
      delete[] sel;
    }
  }
  else
  {
    leCommand->setText("");
    leHour->setText("");
    leMinute->setText("");
  }
}

/* ********************************************************************* */

void EditEntry::closeEvent(QCloseEvent *e)
{
  if (editRow)
    editRow->setIsEdited(FALSE);
  QWidget::closeEvent(e);
}

void EditEntry::slotDropAction(KDNDDropZone *dropzone)
{
  QStrList urls = dropzone->getURLList();
  QString  url  = urls.first();

  if (url.left(5) == "file:")
    leCommand->setText(url.right(url.length() - 5));
}

void EditEntry::slotMonthSelected(bool on)
{
  if (on)
  {		
    rbEveryMonth->setChecked(FALSE);
    activatedMonth++;
 }
 else
   if (!--activatedMonth)
     rbEveryMonth->setChecked(TRUE);
}

void EditEntry::slotEveryMonth()
{
  for (int i = 0; i < 12; i++)
    cbMonth[i]->setChecked(FALSE);
}

void EditEntry::slotWeekdaySelected(bool on)
{
  if (on)
  {		
    rbEveryWeekday->setChecked(FALSE);
    activatedDays++;
  }
  else
    if (!--activatedDays)
      rbEveryWeekday->setChecked(TRUE);
}

void EditEntry::slotEveryWeekday()
{
  for (int i = 0; i < 7; i++)
    cbWeekday[i]->setChecked(FALSE);
}

void EditEntry::slotOk()
{
  QValidator *val;
  QString    tmp;
  int        pos         = 0;
  int        secondEntry = FALSE;

  // Read data from Command line edit

  tmp = leCommand->text();
  if (tmp.isEmpty())
  {
    QMessageBox::warning(this, kapp->appName(),
	                 i18n("Enter the command "
                         "to be issued."));
    leCommand->setFocus();
    return;
  }

  QString command = tmp;

  // Read data from Hour line edit
 
  val = leHour->validator();
  tmp = leHour->text();

  if (tmp.isEmpty())
    tmp = "*";
  else
    if (val->validate(tmp, pos) != QValidator::Acceptable)
    {
      QMessageBox::warning(this, kapp->appName(),
                           i18n("Hour not valid."));
      leHour->setFocus();
      return;
    }
 
  QString hour = tmp;

  // Read data from Minute line edit

  val = leMinute->validator();
  tmp = leMinute->text (); 
 
  if (val->validate(tmp, pos) != QValidator::Acceptable)
  {
    QMessageBox::warning(this, kapp->appName(),
                         i18n("Minute not valid."));
    leMinute->setFocus();
    return;
  }

  QString minute = tmp;

  // Read data from Day NumTbl

  tmp = ntDay->selection();

  if (tmp.isEmpty())
    tmp = "*";
 
  QString DOM = tmp;
 
  // Read data from the Weekday buttons

  secondEntry = FALSE;
  tmp         = "";

  if (rbEveryWeekday->isChecked ())
    tmp = "*";
  else 
    for (int i = 0; i < 7; i++)
    {
      if (cbWeekday[i]->isChecked())
      {
        if (!secondEntry)
        {
          secondEntry = TRUE;
          tmp.sprintf("%d", i);
        }
        else
          tmp.sprintf("%s,%d", tmp.data(), i);
      }
    }
	
  QString DOW = tmp;

  // Read data from the Month buttons

  secondEntry = FALSE;
  tmp         = "";

  if (rbEveryMonth->isChecked())
    tmp = "*";
  else 
    for (int i = 0; i < 12; i++)
    {
         if (cbMonth[i]->isChecked())
      {
           if (!secondEntry)
        {
             secondEntry = TRUE;
             tmp.sprintf ("%d", i + 1);
        }
        else
          tmp.sprintf("%s,%d", tmp.data(), i + 1);
      }
    }

  QString month = tmp;

 
  if (editRow == 0)
  {
    editRow = new CronRow;
    editRow->setEnabled(TRUE);
  }

  editRow->setMinute(minute);
  editRow->setHour(hour);
  editRow->setDOM(DOM);
  editRow->setMonth(month);
  editRow->setDOW(DOW);
  editRow->setUser(qbUserList->text(qbUserList->currentItem()));
  editRow->setCommand(command);
  editRow->setComment(leComment->text());

  emit newEntry(editRow, editMode);
  close();
}

void EditEntry::slotCancel()
{
  close();
}

void EditEntry::slotHelp()
{
  kapp->invokeHTMLHelp("kcrontab/3.2.html", "");
}

/* ********************************************************************* */

bool *EditEntry::parse(QString entry, int min, int max)
{
  QString tmp = preParse(entry);
  char    *buf;
  QString buf2;
  int     num, num2, step;

  int  count = max - min + 1;
  bool *selected = new bool[count];
  for (int i = 0; i < count; i++)
    selected[i] = FALSE;

  buf = strtok(tmp.data(), ",");
  while (buf)
  {
    buf2 = buf;

    if (buf2.contains("-"))
    {
      num  = atoi(strtok(buf2.data(), "-"));
      num2 = atoi(strtok(0, "/"));

      char *test = strtok (0, "");
      if (test)
        step = atoi (test);
      else
        step = 1;

      if (num > num2)
      {
        for (int i = num; i <= max; i += step)
          selected[i - min] = TRUE;

        while (num >= max)
          num = (num + step) % (max - min + 1);
      }

      for (int i = num; i <= num2; i += step)
        selected[i - min] = TRUE;
    }
    else if (buf2.contains('/'))
    {
      strtok(buf2.data(), "/");
      step = atoi(strtok(0, ""));

      for (int i = min; i <= max; i += step)
        selected[i - min] = TRUE;
    }
    else
    {
      num = atoi(buf2.data());
      selected[num - min] = TRUE;
    }


  buf = strtok(0, ",");
  }

  return selected;
}

QString EditEntry::preParse(QString entry)
{
  char monthName[12][4]  = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
                            "Aug", "Sep", "Oct", "Nov", "Dec"};
  char weekdayName[7][4] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};

  QString check, tmp, ret = "";
  char    *buf;

  for (buf = entry.data(); *buf; buf++)
  {
    if (isalpha(*buf))
    {
      check = "";
      while (isalpha(*buf))
        check += *(buf++);
      buf--;

      for (int i = 0; i < 12; i++)
        if ((stricmp(check.data(), monthName[i])) == 0)
        {
          tmp.setNum(i);
          ret += tmp;
          break;
        }
        else
          if (i < 7 && (stricmp(check.data(), weekdayName[i])) == 0)
          {
            tmp.setNum(i);
            ret += tmp;
            break;
          }
    }
    else
      ret += *buf;
  }

  return ret;
}
