#ifndef _BIND_
#define _BIND_

#include <qwidget.h>
#include <qframe.h>
#include <qlabel.h>
#include <qtabdlg.h>
#include <qpushbt.h>
#include <qtimer.h>
#include <qlist.h>
#include <qlistbox.h>
#include <qlined.h>
#include <qstrlist.h>

#include <kapp.h>
#include <ktopwidget.h>
#include <ktablistbox.h>

#define no_recursion 	1
#define no_fetch_glue	2
#define query_log	4
#define forward_only	8
#define fake_iquery	16

#define TYPE_A     1
#define TYPE_CNAME 5
#define TYPE_HINFO 13
#define TYPE_MB    7
#define TYPE_MG    8
#define TYPE_MINFO 14
#define TYPE_MR    9
#define TYPE_MX    15
#define TYPE_NS    2
#define TYPE_PTR   12
#define TYPE_SOA   6
#define TYPE_TXT   16
#define TYPE_WKS   11
#define TYPE_AFSDB 18
#define TYPE_ISDN  20
#define TYPE_RP    17
#define TYPE_RT    21
#define TYPE_X25   19

/* I hope thats all ... */

class records {
public:
  int type;
  int TTL;   /* is it really used ??? */
  int i;
  QString owner;
  QString st1;
  QString st2;
};

class primaryDomain {
public:
   primaryDomain(QString dom, QString f) {domain=dom;file=f;}
   QList<records> *data;   
   QString domain;
   QString org;
   QString cl;
   QString file;
   QString ns;
   QString rp;
   int serial;
   int refresh;
   int retry;
   int expire;
   int TTL;
};

class secondaryDomain {
public:
  QString domain;
  QString file;
  QStrList *ip;
  int count;
};


class KBindWidget : public KTopLevelWidget
{
  Q_OBJECT;

public:

  KBindWidget();
  
private:
  QLabel *testlabel,*pl1,*pl2,*sl1,*sl2,*ml1,*ml2,*ml3;
  QWidget *primary, *second,*misc,*forward,*xfer,*bogus,*simplestats,*detailstats;  
  QListBox *plist, *slist,*flist,*xlist,*blist,*simplestatlist;
  QLineEdit *diredit;
  QLineEdit *cacheedit;  
  KTabListBox *statlist;
  
  QString *directory;  
  QString *cache;
  int options;

  QStrList *forwarders;
  QStrList *xfrnets;
  QStrList *bogusns;
  
  QPushButton *delp;

  QList<primaryDomain> *primaryList;
  
  QList<secondaryDomain> *secondaryList;
  void  parseboot();
  void  readStat();
  void  displaySettings();
  void  readSOA(primaryDomain *pl,QString path);
  bool  isIP(QString ip);
  int   todel;
public slots:

private slots:
  void primaryClick(const char * a);
  void secondaryClick(const char * a);
  void pnewclicked();
  void pdelclicked();
  void listsel(int);
};


#endif
