/***************************************************************************
                          medit.cpp  -  description                              
                             -------------------                                         
    begin                : Fri Apr 30 1999                                           
    copyright            : (C) 1999 by Hugo Santos                         
    email                : hugo_santos@bigfoot.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "medit.h"

MEdit::MEdit(_KInstall *parent, const char *name ) : KDialog(parent,name,true) {
	ki = parent;
	btn_save = new QPushButton(BTN_SAVE,this);
	btn_close = new QPushButton(BTN_CLOSE,this);
	mle_mf = new QMultiLineEdit(this);
	connect(btn_save,SIGNAL(clicked()),this,SLOT(saveM()));
	connect(btn_close,SIGNAL(clicked()),this,SLOT(close()));
}
MEdit::~MEdit(){
	saveM();
}

void MEdit::resizeEvent( QResizeEvent * ){
	btn_save->setGeometry(5, height()-35,70,30);
	btn_close->setGeometry(80,height()-35,70,30);
	mle_mf->setGeometry(5,5,width()-10,height()-45);
}

void MEdit::loadM( const char *file ){
	f.setName(file);
	if ( !f.open( IO_ReadWrite ) )
		return;
	_file=file;
	mle_mf->setAutoUpdate( FALSE );
	mle_mf->clear();
	QTextStream t(&f);
	while ( !t.eof() ) {
		QString s = t.readLine();
		mle_mf->append( s );}
  f.close();
	mle_mf->setAutoUpdate( TRUE );
}

void MEdit::saveM(){
	if (!f.open( IO_ReadWrite ) )
		return;
	f.writeBlock(mle_mf->text(),strlen(mle_mf->text()));
	f.flush();
	f.close();
}
void MEdit::close(){saveM();accept();}