/***************************************************************************
                          ki.cpp  -  Re-implementation of _KInstall for the end-user
                             -------------------                                         
    begin                : Sat Apr 10 1999                                           
    copyright            : (C) 1999 by Hugo Santos                         
    email                : hugo_santos@bigfoot.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "ki.h"

KI::KI() : _KInstall(){
	KMsgBox *mb;
	KFileDialog *fd;
	if(mb->yesNo(this,"KInstall",i18n("Welcome to KInstall!\n\nKInstall will now show a File Dialog\n so you can choose the file to install."),1,i18n("OK"),i18n("Exit"))==1){
	QString s=fd->getOpenFileName("/","*",this);
	if (s!=0&&s!=""){
		launch(s);
		return;
	}
	else {
		kapp->quit();
		exit(0);
	}}
	else exit(0);
}

void KI::launch(QString fich){
	p1 = 0; p2 = 0; p3 = 0; p4 = 0; p5 = 0;
	QFile f( fich );
	if (f.exists()){
	extrPackage( fich );
	verifyPackage();
	setMinimumHeight(305);
	setMaximumHeight(305);
	setMinimumWidth(500);
	inst.name = resoInstName( fich );
	inst.argv = fich;
	setCaption(KINSTALL);
	setButtonOk(BTN_FINISH);
	setButtonOkEnabled(false);
	setButtonCancel(BTN_CANCEL);
	setButtonHelp(BTN_HELP);
	setButtonBack(BTN_PREV);
	setButtonNext(BTN_NEXT);
	// this is commented because tere aren't still any pics to draw
	//QString img;
	//img.sprintf("%s/kinstall/pics/1.jpg",(const char *)kapp->kde_datadir());
	//setImage( QPixmap( img ) );
	connect(this,SIGNAL(cancelclicked()),SLOT(slotCancelClicked()));
	connect(this,SIGNAL(helpclicked()),SLOT(slotHelpClicked()));
	if (inst.type==2)
		slotGotoPage3();	
	else
		slotGotoPage1();}
	else errorForceQuit(ERR_01);
}
KI::~KI(){
}

void KI::slotFinishedAbout(){
	kapp->quit();
}

void KI::slotGotoPage1(){
	p1 = new Page1(this);
	p1->show();
	setPage( p1 );
	connect(p1,SIGNAL(finished()),this,SLOT(slotGotoPage2()));
}	

QString KI::resoInstName( QString argv ){
	int f = argv.findRev('/',strlen(argv),false);
	if (f!=-1)
		argv.remove(0,f+1);
	int g_1 = argv.find(".tar",0,false);
	if (g_1!=-1){
		argv.remove(g_1,strlen(argv));
		return argv;}
	int g_2 = argv.find(".gz",0,false);
	if (g_2!=-1){
		argv.remove(g_2,strlen(argv));
		return argv;}
	int g_3 = argv.find(".tgz",0,false);
	if (g_3!=-1){
		argv.remove(g_3,strlen(argv));
		return argv;}
}

void KI::extrPackage( QString archive ){
	QString foo_tmp="", foo_tmp_kitemp="", foo_undec="", fin_args="";
	QDir tmp("/tmp");
	QDir tmp_kitemp("/tmp/ki_temp");
	if (!tmp.exists())
		foo_tmp="mkdir /tmp;";
	if (!tmp_kitemp.exists())
		foo_tmp_kitemp="mkdir /tmp/ki_temp;";
	else
		foo_tmp_kitemp="rm -rf /tmp/ki_temp;mkdir /tmp/ki_temp;";
	if (QDir::match("*.tar",archive))
		foo_undec="tar -xf " + archive + ";";
	else if (QDir::match("*.tgz",archive))
		foo_undec="tar -zxf " + archive + ";";
	else if (QDir::match("*.gz",archive)&&QDir::match("*.tar*",archive))
		foo_undec="tar -zxf " + archive + ";";
	else if (QDir::match("*.gz",archive)&&!QDir::match("*.tar*",archive))
		foo_undec="gunzip " + archive + ";";
	else if (QDir::match("*.rpm",archive))
		errorForceQuit(ERR_03);
	else
		errorForceQuit(ERR_02);
	fin_args=foo_tmp+foo_tmp_kitemp+"cd /tmp/ki_temp;"+foo_undec;
	KShellProcess p;
	p << fin_args;
	p.start(KProcess::Block,KProcess::AllOutput);
}

void KI::verifyPackage(){
	bool Makefile,Makefile_cvs,configure,Makefile_dist;
	Makefile_cvs =QFile::exists("/tmp/ki_temp/Makefile.cvs");
	configure    =QFile::exists("/tmp/ki_temp/configure");
	Makefile_dist=QFile::exists("/tmp/ki_temp/Makefile.dist");
	Makefile     =QFile::exists("/tmp/ki_temp/Makefile");
	if (!Makefile_cvs&&!configure&&!Makefile_dist&&!Makefile){
		QDir d("/tmp/ki_temp");
		d.setFilter( QDir::Dirs | QDir::NoSymLinks );
		d.setSorting( QDir::Reversed );
		const QFileInfoList *list = d.entryInfoList();
		QFileInfoListIterator it( *list );
		QFileInfo *fi;
		fi=it.current();
		QString a,aa,aaa,aaaa;
		a.sprintf("/tmp/ki_temp/%s/Makefile.cvs",fi->fileName().data());
		aa.sprintf("/tmp/ki_temp/%s/configure",fi->fileName().data());
		aaa.sprintf("/tmp/ki_temp/%s/Makefile.dist",fi->fileName().data());
		aaaa.sprintf("/tmp/ki_temp/%s/Makefile",fi->fileName().data());
		Makefile_cvs =QFile::exists(a);
		configure    =QFile::exists(aa);
		Makefile_dist=QFile::exists(aaa);
		Makefile     =QFile::exists(aaaa);
		if (!Makefile_cvs&&!configure&&!Makefile_dist&&!Makefile)
			errorForceQuit(ERR_04);
		else{
			if (Makefile_cvs&&!configure)
				inst.type=1;
			else if (Makefile&&!configure)
				inst.type=2;
			else if (Makefile_dist&&!configure)
				inst.type=3;
			else if (configure)
				inst.type=4;
			inst.inside_tempdir=fi->fileName().data();
		}
	}
	else{
			if (Makefile_cvs&&!configure)
				inst.type=1;
			else if (Makefile&&!configure)
				inst.type=2;
			else if (Makefile_dist&&!configure)
				inst.type=3;
			else if (configure)
				inst.type=4;
			inst.inside_tempdir=0;
	}
}

void KI::slotHelpClicked(){
  KApplication::getKApplication()->invokeHTMLHelp ("","");
}

void KI::slotCancelClicked(){
	KMsgBox *mb;
	if (mb->yesNo(this,"KInstall",MSG_01,8,BTN_YES,BTN_NO)==1){slotCleanDirs();kapp->exit();}
}

void KI::slotGotoPage2(){
	if (p1!=0){
		delete p1;p1=0;}
	p2 = new Page2(this);
	p2->show();
	setPage( p2 );
	connect(p2,SIGNAL(finished()),this,SLOT(slotGotoPage3()));
	connect(p2,SIGNAL(finished2()),this,SLOT(slotGotoPage1()));
}
void KI::slotGotoPage3(){
	if (p2!=0){
		delete p2;p2=0;}
	p3 = new Page3(this);
	p3->show();
	setPage( p3 );
	connect(p3,SIGNAL(finished()),this,SLOT(slotGotoPage4()));
	connect(p3,SIGNAL(finished2()),this,SLOT(slotGotoPage2()));
}
void KI::slotGotoPage4(){
	if (p3!=0){
		delete p3;p3=0;}
	p4 = new Page4(this);
	p4->show();
	setPage( p4 );
	connect(p4,SIGNAL(finished()),this,SLOT(slotGotoPage5()));
	connect(p4,SIGNAL(finished2()),this,SLOT(slotGotoPage3()));
}
void KI::slotGotoPage5(){
	if (p4!=0){
		delete p4;p4=0;}
	p5 = new Page5(this);
	p5->show();
	setPage( p5 );
	connect(p5,SIGNAL(finished()),this,SLOT(slotFinishInstallation()));
}

void KI::slotFinishInstallation(){
	slotCleanDirs();
	exit(0);
}
void KI::slotCleanDirs(){
	KShellProcess p;
	QDir d("/tmp/ki_temp");
	p << "rm -rf /tmp/ki_temp";
	QString s1;
	s1.sprintf("KInstall: %s\n\n",MSG_02);
	printf(s1);
	p.start(KProcess::Block,KProcess::AllOutput);
	if (d.exists()){
		QString s2;
		s2.sprintf("KInstall: %s!\n\n",ERR_05);
		printf(s2);}
	else {
		QString s3;
		s3.sprintf("KInstall: %s!\n\n",MSG_03);
		printf(s3);}
}

