/***************************************************************************
                          karaMainWidget.cpp  -  description                              
                             -------------------                                         
    begin                : Sun May 2 1999                                           
    copyright            : (C) 1999 by Hugo Santos                         
    email                : hugo_santos@bigfoot.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "karaMainWidget.h"

karamMainWidget::karamMainWidget(QWidget *parent, const char *name ) : QWidget(parent,name) {
	setMinimumSize(400,450);
	frm_add           = new QFrame(this);
	frm_remove        = new QFrame(this);
	btn_install       = new QPushButton(i18n("Add..."),this);
	btn_uninstall     = new QPushButton(i18n("Remove"),this);
	lbl_exp_install   = new QLabel(this);
	lbl_exp_uninstall = new QLabel(this);
	lst_uninstall     = new QListView(this);
    lst_uninstall->addColumn( i18n("Name") );
    lst_uninstall->setColumnWidth(0,100);
    lst_uninstall->addColumn( i18n("Comment") );
    lst_uninstall->setColumnWidthMode(1,QListView::Maximum);
    lst_uninstall->header()->hide();
		lst_uninstall->setFrameStyle( QFrame::WinPanel | QFrame::Sunken );
	frm_add->setFrameStyle( QFrame::Box | QFrame::Sunken );
	frm_remove->setFrameStyle( QFrame::Box | QFrame::Sunken );
	lbl_exp_install->setText(i18n("   If you wish to install a file you downloaded from the Internet or \ngot from a cd magazine press 'Add...' and you'll be prompted to \nchoose that file, then KInstall will quide the rest of the process."));
	lbl_exp_uninstall->setText(i18n("   Below, there's a list of all KDE applications installed in your \nsystem. If you wish to remove any, selected it and press 'Remove'.\nNote: This process of uninstallation is irreversible."));
	QString s(kapp->kde_appsdir());
	fillMeOfApps(s);
	connect( btn_install, SIGNAL(clicked()), this, SLOT(launchKInstall()));
	connect( btn_uninstall, SIGNAL(clicked()), this, SLOT(removeSelectedApp()));
}
karamMainWidget::~karamMainWidget(){
}

void karamMainWidget::launchKInstall(){
	KShellProcess p;
	p << "karam -i";
	p.start(KProcess::DontCare,KProcess::AllOutput);
}

// This function is from KUninstaller v0.3
// KUninstaller is copyrighted to Geri House <ge_ha@yahoo.com>
void karamMainWidget::fillMeOfApps(QString str, QListViewItem *parentItem){
	QDir dir(str);
	if (dir.exists()) {
		dir.setFilter(QDir::Dirs |  QDir::Files);
		const QFileInfoList *strList = dir.entryInfoList();
		QFileInfo *f=strList->first();
		QListViewItem * newItem=0;
		while (f!=0) {
			if (f->fileName()!="." && f->fileName()!="..")  {
	  			if (parentItem!=0) {
	  				KSimpleConfig kconfig(f->absFilePath(), true);
	  				kconfig.setGroup("KDE Desktop Entry");
	  				QString tmpStr(" ");
	  				tmpStr+=f->baseName();
	  				QString commStr=kconfig.readEntry("Comment");
						newItem= new QListViewItem(parentItem,tmpStr, commStr);
	  				QString pixStr = kconfig.readEntry("MiniIcon");
	  				QPixmap pix;
	  				if (!pixStr.isEmpty()) {
					   	pix=kapp->getIconLoader()->loadApplicationMiniIcon(pixStr);
  					}
  					else {
							pixStr = kconfig.readEntry("Icon");
							if (!pixStr.isEmpty()) {
						  	pix=kapp->getIconLoader()->loadApplicationIcon(pixStr);
						  	pix.resize(16,16);
 					  	}
 					  	else	
					   		pix=kapp->getIconLoader()->loadApplicationMiniIcon("unknown.xpm");
  					}
  					newItem->setPixmap(0,pix);
				}	
				else if (f->isDir()==TRUE && f->fileName()!="Settings"){
					QString str=f->absFilePath();
					str+="/";
					str+=".directory";
	  			KSimpleConfig kconfig(str, true);					
	  			kconfig.setGroup("KDE Desktop Entry");
	  			QString name=kconfig.readEntry("Name");
	  			if (name.isEmpty()==true)
	  				name=f->fileName();
					QCheckListItem  * newMenue= new QCheckListItem(lst_uninstall,name);
					fillMeOfApps((const char *)f->absFilePath(), newMenue);
					newMenue->setOpen(true);
				}	
			}
			f=strList->next();
		}
	}					
}					

void karamMainWidget::resizeEvent( QResizeEvent * ){
	frm_add->setGeometry(5,5,width()-10,100);
	frm_remove->setGeometry(5,110,width()-10,height()-115);
	btn_install->setGeometry(width()-85,70,70,25);
	btn_uninstall->setGeometry(width()-85,height()-40,70,25);
	lbl_exp_install->setGeometry(10,10,width()-20,60);
	lbl_exp_uninstall->setGeometry(10,115,width()-20,55);
	lst_uninstall->setGeometry(10,175,width()-20,height()-220);
}

void karamMainWidget::removeSelectedApp(){
	KMsgBox::message(this,"KARAM","The Remove function is still in the development.",1,"Ok");
}

