/*
  Copyright (c) 2015-2019 Montel Laurent <montel@kde.org>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "kactionmenuchangecasetest.h"
#include "../src/pimcommon/widgets/kactionmenuchangecase.h"
#include <qtest.h>
#include <QSignalSpy>
#include <QMenu>
using namespace PimCommon;
KActionMenuChangeCaseTest::KActionMenuChangeCaseTest(QObject *parent)
    : QObject(parent)
{
}

KActionMenuChangeCaseTest::~KActionMenuChangeCaseTest()
{
}

void KActionMenuChangeCaseTest::shouldHaveDefaultValue()
{
    KActionMenuChangeCase menu;
    QVERIFY(menu.upperCaseAction());
    QVERIFY(menu.sentenceCaseAction());
    QVERIFY(menu.lowerCaseAction());
    QVERIFY(menu.reverseCaseAction());
    QCOMPARE(menu.menu()->actions().count(), 4);
}

void KActionMenuChangeCaseTest::shouldEmitSignals()
{
    KActionMenuChangeCase menu;
    QSignalSpy spyUpper(&menu, &KActionMenuChangeCase::upperCase);
    QSignalSpy spyLower(&menu, &KActionMenuChangeCase::lowerCase);
    QSignalSpy spySentence(&menu, &KActionMenuChangeCase::sentenceCase);
    QSignalSpy spyReverse(&menu, &KActionMenuChangeCase::reverseCase);
    menu.upperCaseAction()->trigger();
    menu.lowerCaseAction()->trigger();
    menu.sentenceCaseAction()->trigger();
    menu.reverseCaseAction()->trigger();
    QCOMPARE(spyUpper.count(), 1);
    QCOMPARE(spyLower.count(), 1);
    QCOMPARE(spySentence.count(), 1);
    QCOMPARE(spyReverse.count(), 1);
}

QTEST_MAIN(KActionMenuChangeCaseTest)
