/*
 * This code is auto-generated from Wikidata data. Licensed under CC0.
 */

#include "airportdb.h"
#include "airportdb_p.h"

#include <cmath>
#include <limits>

namespace AirportDb {

// sorted table of all iata codes
// the corresponding index is used to acces data from all following tables
static constexpr IataCode iata_table[] = {
    IataCode{"AAA"}, // Anaa Airport
    IataCode{"AAB"}, // Arrabury Airport
    IataCode{"AAC"}, // El Arish International Airport
    IataCode{"AAE"}, // Rabah Bitat Airport
    IataCode{"AAF"}, // Apalachicola Regional Airport
    IataCode{"AAG"}, // Arapoti Airport
    IataCode{"AAI"}, // Arraias Airport
    IataCode{"AAJ"}, // Cayana Airstrip
    IataCode{"AAK"}, // Aranuka Airport
    IataCode{"AAL"}, // Aalborg Airport
    IataCode{"AAM"}, // Mala Mala Airport
    IataCode{"AAN"}, // Al Ain International Airport
    IataCode{"AAO"}, // Anaco Airport
    IataCode{"AAP"}, // Andrau Airpark
    IataCode{"AAQ"}, // Anapa Airport
    IataCode{"AAR"}, // Aarhus Airport
    IataCode{"AAS"}, // Apalapsili Airport
    IataCode{"AAT"}, // Altay Airport
    IataCode{"AAU"}, // Asau Airport
    IataCode{"AAV"}, // Allah Valley Airport
    IataCode{"AAW"}, // Abbottabad Airport
    IataCode{"AAX"}, // Araxá Airport
    IataCode{"AAY"}, // Al Ghaydah Airport
    IataCode{"AAZ"}, // Aeropuerto Internacional Los Altos
    IataCode{"ABA"}, // Abakan International Airport
    IataCode{"ABB"}, // Asaba International Airport
    IataCode{"ABC"}, // Albacete Airport
    IataCode{"ABD"}, // Abadan Airport
    IataCode{"ABE"}, // Lehigh Valley International Airport
    IataCode{"ABF"}, // Abaiang Atoll Airport
    IataCode{"ABG"}, // Abingdon Airport
    IataCode{"ABH"}, // Alpha Airport
    IataCode{"ABI"}, // Abilene Regional Airport
    IataCode{"ABJ"}, // Port Bouet Airport
    IataCode{"ABK"}, // Kabri Dar Airport
    IataCode{"ABL"}, // Ambler Airport
    IataCode{"ABM"}, // Northern Peninsula Airport
    IataCode{"ABN"}, // Albina Airstrip
    IataCode{"ABO"}, // Aboisso Airport
    IataCode{"ABP"}, // Atkamba Airport
    IataCode{"ABQ"}, // Albuquerque International Sunport
    IataCode{"ABR"}, // Aberdeen Regional Airport
    IataCode{"ABS"}, // Abu Simbel Airport
    IataCode{"ABT"}, // Al-Baha Domestic Airport
    IataCode{"ABU"}, // Haliwen Airport
    IataCode{"ABV"}, // Nnamdi Azikiwe International Airport
    IataCode{"ABW"}, // Abau Airport
    IataCode{"ABX"}, // Albury Airport
    IataCode{"ABY"}, // Southwest Georgia Regional Airport
    IataCode{"ABZ"}, // Aberdeen Airport
    IataCode{"ACA"}, // General Juan N. Álvarez International Airport
    IataCode{"ACB"}, // Antrim County Airport
    IataCode{"ACC"}, // Kotoka International Airport
    IataCode{"ACD"}, // Alcides Fernández Airport
    IataCode{"ACE"}, // Lanzarote Airport
    IataCode{"ACH"}, // St. Gallen-Altenrhein Airport
    IataCode{"ACI"}, // Alderney Airport
    IataCode{"ACJ"}, // SLAF Anuradhapura
    IataCode{"ACK"}, // Nantucket Memorial Airport
    IataCode{"ACL"}, // Aguaclara Airport
    IataCode{"ACN"}, // Ciudad Acuña International Airport
    IataCode{"ACP"}, // Sahand Airport
    IataCode{"ACQ"}, // Waseca Municipal Airport
    IataCode{"ACR"}, // Araracuara Airport
    IataCode{"ACS"}, // Achinsk Airport
    IataCode{"ACT"}, // Waco Regional Airport
    IataCode{"ACU"}, // Achutupo Airport
    IataCode{"ACV"}, // Arcata-Eureka Airport
    IataCode{"ACX"}, // Xingyi Wanfenglin Airport
    IataCode{"ACY"}, // Atlantic City International Airport
    IataCode{"ACZ"}, // Zabol Airport
    IataCode{"ADA"}, // Adana Şakirpaşa Airport
    IataCode{"ADB"}, // Adnan Menderes Airport
    IataCode{"ADC"}, // Andakombe Airport
    IataCode{"ADD"}, // Addis Ababa Bole International Airport
    IataCode{"ADE"}, // Aden International Airport
    IataCode{"ADF"}, // Adıyaman Airport
    IataCode{"ADG"}, // Lenawee County Airport
    IataCode{"ADH"}, // Aldan Airport
    IataCode{"ADI"}, // Arandis Airport
    IataCode{"ADJ"}, // Amman Civil Airport
    IataCode{"ADK"}, // Adak Airport
    IataCode{"ADL"}, // Adelaide Airport
    IataCode{"ADM"}, // Ardmore Municipal Airport
    IataCode{"ADO"}, // Andamooka Airport
    IataCode{"ADP"}, // SLAF Ampara
    IataCode{"ADQ"}, // Kodiak Airport
    IataCode{"ADR"}, // Robert F. Swinnie Airport
    IataCode{"ADS"}, // Addison Airport
    IataCode{"ADT"}, // Ada Municipal Airport
    IataCode{"ADU"}, // Ardabil Airport
    IataCode{"ADV"}, // Ed Daein Airport
    IataCode{"ADY"}, // Alldays Airport
    IataCode{"ADZ"}, // Gustavo Rojas Pinilla International Airport
    IataCode{"AEA"}, // Abemama Atoll Airport
    IataCode{"AEB"}, // Baise Bama Airport
    IataCode{"AEG"}, // Aek Godang Airport
    IataCode{"AEH"}, // Abéché Airport
    IataCode{"AEI"}, // Algeciras Heliport
    IataCode{"AEL"}, // Albert Lea Municipal Airport
    IataCode{"AEO"}, // Aioun el Atrouss Airport
    IataCode{"AEP"}, // Aeroparque Jorge Newbery
    IataCode{"AER"}, // Sochi International Airport
    IataCode{"AES"}, // Ålesund Airport, Vigra
    IataCode{"AET"}, // Allakaket Airport
    IataCode{"AEU"}, // Abu Musa Airport
    IataCode{"AEX"}, // Alexandria International Airport
    IataCode{"AEY"}, // Akureyri Airport
    IataCode{"AFA"}, // San Rafael Airport
    IataCode{"AFD"}, // Port Alfred Airport
    IataCode{"AFE"}, // Kake Airport
    IataCode{"AFI"}, // Amalfi Airport
    IataCode{"AFK"}, // Nebraska City Municipal Airport
    IataCode{"AFL"}, // Alta Floresta Airport
    IataCode{"AFN"}, // Jaffrey Airport – Silver Ranch Airpark
    IataCode{"AFO"}, // Afton Municipal Airport
    IataCode{"AFP"}, // Anson County Airport
    IataCode{"AFS"}, // Zarafshan Airport
    IataCode{"AFT"}, // Afutara Airport
    IataCode{"AFW"}, // Fort Worth Alliance Airport
    IataCode{"AFY"}, // Afyon Airport
    IataCode{"AFZ"}, // Sabzevar Airport
    IataCode{"AGA"}, // Agadir–Al Massira Airport
    IataCode{"AGC"}, // Allegheny County Airport
    IataCode{"AGD"}, // Anggi Airport
    IataCode{"AGF"}, // Agen La Garenne Airport
    IataCode{"AGH"}, // Ängelholm-Helsingborg Airport
    IataCode{"AGI"}, // Wageningen Airstrip
    IataCode{"AGJ"}, // Aguni Airport
    IataCode{"AGL"}, // Wanigela Airport
    IataCode{"AGN"}, // Angoon Seaplane Base
    IataCode{"AGO"}, // Magnolia Municipal Airport
    IataCode{"AGP"}, // Málaga Airport
    IataCode{"AGQ"}, // Agrinion Airport
    IataCode{"AGS"}, // Augusta Regional Airport
    IataCode{"AGT"}, // Guaraní International Airport
    IataCode{"AGU"}, // Lic. Jesús Terán Peredo International Airport
    IataCode{"AGV"}, // Oswaldo Guevara Mujica Airport
    IataCode{"AGW"}, // Agnew Airport
    IataCode{"AGX"}, // Agatti Aerodrome
    IataCode{"AGY"}, // Argyle Downs Airport
    IataCode{"AGZ"}, // Aggeneys Airport
    IataCode{"AHB"}, // Abha Regional Airport
    IataCode{"AHD"}, // Ardmore Downtown Executive Airport
    IataCode{"AHE"}, // Ahe Airport
    IataCode{"AHF"}, // Arapahoe Municipal Airport
    IataCode{"AHH"}, // Amery Municipal Airport
    IataCode{"AHI"}, // Amahai Airport
    IataCode{"AHJ"}, // Hongyuan Airport
    IataCode{"AHL"}, // Aishalton Airport
    IataCode{"AHM"}, // Ashland Municipal Airport
    IataCode{"AHN"}, // Athens Ben Epps Airport
    IataCode{"AHO"}, // Aeroporto di Alghero-Fertilia
    IataCode{"AHQ"}, // Wahoo Municipal Airport
    IataCode{"AHS"}, // Ahuas Airport
    IataCode{"AHU"}, // Cherif Al Idrissi Airport
    IataCode{"AHY"}, // Amabatolahy Airport
    IataCode{"AHZ"}, // Alpe d'Huez Airport
    IataCode{"AIA"}, // Alliance Municipal Airport
    IataCode{"AIC"}, // Airok Airport
    IataCode{"AID"}, // Anderson Municipal Airport
    IataCode{"AIE"}, // Aiome Airport
    IataCode{"AIF"}, // Assis Airport
    IataCode{"AIG"}, // Yalinga Airport
    IataCode{"AIH"}, // Aiambak Airport
    IataCode{"AII"}, // Ali-Sabieh Airport
    IataCode{"AIK"}, // Aiken Municipal Airport
    IataCode{"AIL"}, // Ailigandí Airport
    IataCode{"AIM"}, // Ailuk Airport
    IataCode{"AIN"}, // Wainwright Airport
    IataCode{"AIO"}, // Atlantic Municipal Airport
    IataCode{"AIR"}, // Aripuanã Airport
    IataCode{"AIS"}, // Arorae Island Airport
    IataCode{"AIT"}, // Aitutaki Airport
    IataCode{"AIU"}, // Enua Airport
    IataCode{"AIV"}, // George Downer Airport
    IataCode{"AIY"}, // Bader Field
    IataCode{"AIZ"}, // Lee C. Fine Memorial Airport
    IataCode{"AJA"}, // Ajaccio Napoleon Bonaparte Airport
    IataCode{"AJF"}, // Al-Jawf Domestic Airport
    IataCode{"AJI"}, // Ağrı Airport
    IataCode{"AJJ"}, // Akjoujt Airport
    IataCode{"AJK"}, // Arak Airport
    IataCode{"AJL"}, // Lengpui Airport
    IataCode{"AJN"}, // Ouani Airport
    IataCode{"AJO"}, // Corona Municipal Airport
    IataCode{"AJR"}, // Arvidsjaur Airport
    IataCode{"AJS"}, // Punta Abreojos Airstrip
    IataCode{"AJU"}, // Santa Maria Airport
    IataCode{"AJY"}, // Mano Dayak International Airport
    IataCode{"AKA"}, // Ankang Wulipu Airport
    IataCode{"AKB"}, // Atka Airport
    IataCode{"AKC"}, // Akron Fulton International Airport
    IataCode{"AKD"}, // Akola Airport
    IataCode{"AKE"}, // Akieni Airport
    IataCode{"AKF"}, // Kufra Airport
    IataCode{"AKI"}, // Akiak Airport
    IataCode{"AKJ"}, // Asahikawa Airport
    IataCode{"AKK"}, // Akhiok Airport
    IataCode{"AKL"}, // Auckland Airport
    IataCode{"AKM"}, // Zakouma Airport
    IataCode{"AKN"}, // King Salmon Airport
    IataCode{"AKO"}, // Colorado Plains Regional Airport
    IataCode{"AKP"}, // Anaktuvuk Pass Airport
    IataCode{"AKQ"}, // Gunung Batin Airport
    IataCode{"AKR"}, // Akure Airport
    IataCode{"AKS"}, // Auki Gwaunaru'u Airport
    IataCode{"AKU"}, // Aksu Airport
    IataCode{"AKV"}, // Akulivik Airport
    IataCode{"AKW"}, // Aghajari Airport
    IataCode{"AKX"}, // Aktobe Airport
    IataCode{"AKY"}, // Sittwe Airport
    IataCode{"ALA"}, // Almaty International Airport
    IataCode{"ALB"}, // Albany International Airport
    IataCode{"ALC"}, // Alicante Airport
    IataCode{"ALD"}, // Alerta Airport
    IataCode{"ALE"}, // Alpine-Casparis Municipal Airport
    IataCode{"ALF"}, // Alta Airport
    IataCode{"ALG"}, // Houari Boumediene Airport
    IataCode{"ALH"}, // Albany Airport
    IataCode{"ALI"}, // Alice International Airport
    IataCode{"ALJ"}, // Alexander Bay Airport
    IataCode{"ALL"}, // Albenga Airport
    IataCode{"ALM"}, // Alamogordo–White Sands Regional Airport
    IataCode{"ALN"}, // St. Louis Regional Airport
    IataCode{"ALO"}, // Waterloo Regional Airport
    IataCode{"ALP"}, // Aleppo International Airport
    IataCode{"ALQ"}, // Alegrete Airport
    IataCode{"ALR"}, // Alexandra Aerodrome
    IataCode{"ALS"}, // San Luis Valley Regional Airport
    IataCode{"ALU"}, // Alula Airport
    IataCode{"ALV"}, // Andorra la Vella Heliport
    IataCode{"ALW"}, // Walla Walla Regional Airport
    IataCode{"ALX"}, // Thomas C. Russell Field
    IataCode{"ALY"}, // Alexandria International Airport
    IataCode{"ALZ"}, // Alitak Seaplane Base
    IataCode{"AMA"}, // Rick Husband Amarillo International Airport
    IataCode{"AMB"}, // Ambilobe Airport
    IataCode{"AMC"}, // Am Timan Airport
    IataCode{"AMD"}, // Sardar Vallabhbhai Patel International Airport
    IataCode{"AMH"}, // Arba Minch Airport
    IataCode{"AMI"}, // Selaparang Airport
    IataCode{"AMK"}, // Animas Air Park
    IataCode{"AMM"}, // Queen Alia International Airport
    IataCode{"AMN"}, // Gratiot Community Airport
    IataCode{"AMO"}, // Mao Airport
    IataCode{"AMP"}, // Ampanihy Airport
    IataCode{"AMQ"}, // Pattimura Airport
    IataCode{"AMS"}, // Amsterdam Airport Schiphol
    IataCode{"AMV"}, // Amderma Airport
    IataCode{"AMW"}, // Ames Municipal Airport
    IataCode{"AMY"}, // Ambatomainty Airport
    IataCode{"AMZ"}, // Ardmore Airport, New Zealand
    IataCode{"ANB"}, // Anniston Regional Airport
    IataCode{"ANC"}, // Ted Stevens Anchorage International Airport
    IataCode{"AND"}, // Anderson Regional Airport
    IataCode{"ANE"}, // Angers – Loire Airport
    IataCode{"ANF"}, // Andrés Sabella Airport
    IataCode{"ANG"}, // Angoulême – Brie – Champniers Airport
    IataCode{"ANI"}, // Aniak Airport
    IataCode{"ANJ"}, // Zanaga Airport
    IataCode{"ANL"}, // Andulo Airport
    IataCode{"ANM"}, // Antsirabato Airport
    IataCode{"ANN"}, // Annette Island Airport
    IataCode{"ANO"}, // Angoche Airport
    IataCode{"ANP"}, // Lee Airport
    IataCode{"ANQ"}, // Tri-State Steuben County Airport
    IataCode{"ANR"}, // Antwerp International Airport
    IataCode{"ANS"}, // Andahuaylas Airport
    IataCode{"ANU"}, // V. C. Bird International Airport
    IataCode{"ANV"}, // Anvik Airport
    IataCode{"ANW"}, // Ainsworth Regional Airport
    IataCode{"ANX"}, // Andøya Airport
    IataCode{"ANY"}, // Anthony Municipal Airport
    IataCode{"AOD"}, // Abou-Deïa Airport
    IataCode{"AOE"}, // Anadolu Airport
    IataCode{"AOG"}, // Anshan Teng'ao Airport
    IataCode{"AOH"}, // Lima Allen County Airport
    IataCode{"AOI"}, // Falconara Airport
    IataCode{"AOJ"}, // Aomori Airport
    IataCode{"AOK"}, // Karpathos Island National Airport
    IataCode{"AOL"}, // Paso de los Libres Airport
    IataCode{"AOM"}, // Adam Airport
    IataCode{"AOO"}, // Altoona–Blair County Airport
    IataCode{"AOP"}, // Alférez FAP Alfredo Vladimir Sara Bauer Airport
    IataCode{"AOR"}, // Sultan Abdul Halim Airport
    IataCode{"AOS"}, // Amook Bay Seaplane Base
    IataCode{"AOT"}, // Aosta Airport
    IataCode{"AOU"}, // Attapeu International Airport
    IataCode{"APA"}, // Centennial Airport
    IataCode{"APB"}, // Apolo Airport
    IataCode{"APC"}, // Napa County Airport
    IataCode{"APF"}, // Naples Municipal Airport
    IataCode{"APK"}, // Apataki Airport
    IataCode{"APL"}, // Nampula Airport
    IataCode{"APN"}, // Alpena County Regional Airport
    IataCode{"APO"}, // Antonio Roldán Betancourt Airport
    IataCode{"APQ"}, // Arapiraca Airport
    IataCode{"APS"}, // Anápolis Airport
    IataCode{"APT"}, // Marion County Airport
    IataCode{"APU"}, // Apucarana Airport
    IataCode{"APV"}, // Apple Valley Airport
    IataCode{"APW"}, // Faleolo International Airport
    IataCode{"APX"}, // Arapongas Airport
    IataCode{"APY"}, // Alto Parnaiba Airport
    IataCode{"APZ"}, // Zapala Airport
    IataCode{"AQA"}, // Araraquara Airport
    IataCode{"AQB"}, // Quiché Airport
    IataCode{"AQC"}, // Klawock Seaplane Base
    IataCode{"AQG"}, // Anqing Tianzhushan Airport
    IataCode{"AQI"}, // Qaisumah Domestic Airport
    IataCode{"AQJ"}, // King Hussein International Airport
    IataCode{"AQM"}, // Nova Vida Airport
    IataCode{"AQO"}, // Llano Municipal Airport
    IataCode{"AQP"}, // Rodríguez Ballón International Airport
    IataCode{"AQW"}, // Harriman-and-West Airport
    IataCode{"AQY"}, // Girdwood Airport
    IataCode{"ARA"}, // Acadiana Regional Airport
    IataCode{"ARB"}, // Ann Arbor Municipal Airport
    IataCode{"ARC"}, // Arctic Village Airport
    IataCode{"ARD"}, // Alor Island Airport
    IataCode{"ARE"}, // Antonio (Nery) Juarbe Pol Airport
    IataCode{"ARG"}, // Walnut Ridge Regional Airport
    IataCode{"ARH"}, // Talagi Airport
    IataCode{"ARI"}, // Chacalluta International Airport
    IataCode{"ARJ"}, // Arso Airport
    IataCode{"ARK"}, // Arusha Airport
    IataCode{"ARL"}, // Arly Airport
    IataCode{"ARM"}, // Armidale Airport
    IataCode{"ARN"}, // Stockholm Arlanda Airport
    IataCode{"ARQ"}, // El Troncal Airport
    IataCode{"ARR"}, // D. Casimiro Szlapelis Airport
    IataCode{"ART"}, // Watertown International Airport
    IataCode{"ARU"}, // Araçatuba Airport
    IataCode{"ARV"}, // Lakeland Airport
    IataCode{"ARW"}, // Arad International Airport
    IataCode{"ARY"}, // Ararat airport
    IataCode{"ARZ"}, // N'zeto Airport
    IataCode{"ASA"}, // Assab International Airport
    IataCode{"ASB"}, // Ashgabat International Airport
    IataCode{"ASC"}, // Ascencion De Guarayos Airport
    IataCode{"ASD"}, // Andros Town International Airport
    IataCode{"ASE"}, // Aspen–Pitkin County Airport
    IataCode{"ASF"}, // Narimanovo Airport
    IataCode{"ASG"}, // Ashburton Aerodrome
    IataCode{"ASH"}, // Nashua Municipal Airport
    IataCode{"ASJ"}, // Amami Airport
    IataCode{"ASK"}, // Yamoussoukro Airport
    IataCode{"ASL"}, // Harrison County Airport
    IataCode{"ASM"}, // Asmara International Airport
    IataCode{"ASN"}, // Talladega Municipal Airport
    IataCode{"ASO"}, // Asosa Airport
    IataCode{"ASP"}, // Alice Springs Airport
    IataCode{"ASQ"}, // Austin Airport
    IataCode{"ASR"}, // Erkilet International Airport
    IataCode{"AST"}, // Astoria Regional Airport
    IataCode{"ASU"}, // Silvio Pettirossi International Airport
    IataCode{"ASV"}, // Amboseli Airport
    IataCode{"ASW"}, // Aswan International Airport
    IataCode{"ASX"}, // John F. Kennedy Memorial Airport
    IataCode{"ASY"}, // Ashley Municipal Airport
    IataCode{"ATA"}, // Comandante FAP Germán Arias Graziani Airport
    IataCode{"ATB"}, // Atbara Airport
    IataCode{"ATC"}, // Arthur's Town Airport
    IataCode{"ATD"}, // Uru Harbour Airport
    IataCode{"ATE"}, // Antlers Municipal Airport
    IataCode{"ATF"}, // Chachoan Airport
    IataCode{"ATG"}, // Tnte. Gral. Gerardo Pérez Pinedo Airport
    IataCode{"ATH"}, // Athens International Airport
    IataCode{"ATI"}, // Artigas Airport
    IataCode{"ATJ"}, // Antsirabe Airport
    IataCode{"ATK"}, // Atqasuk Edward Burnell Sr. Memorial Airport
    IataCode{"ATL"}, // Hartsfield–Jackson Atlanta International Airport
    IataCode{"ATM"}, // Altamira Airport
    IataCode{"ATN"}, // Namatanai Airport
    IataCode{"ATO"}, // Ohio University Airport
    IataCode{"ATP"}, // Aitape Airport
    IataCode{"ATQ"}, // Sri Guru Ram Dass Jee International Airport
    IataCode{"ATR"}, // Atar International Airport
    IataCode{"ATS"}, // Artesia Municipal Airport
    IataCode{"ATT"}, // Atmautluak Airport
    IataCode{"ATU"}, // Casco Cove Coast Guard Station
    IataCode{"ATV"}, // Ati Airport
    IataCode{"ATW"}, // Appleton International Airport
    IataCode{"ATX"}, // Atbasar Airport
    IataCode{"ATY"}, // Watertown Regional Airport
    IataCode{"ATZ"}, // Assiut Airport
    IataCode{"AUA"}, // Queen Beatrix International Airport
    IataCode{"AUB"}, // Itauba Airport
    IataCode{"AUC"}, // Santiago Pérez Quiroz Airport
    IataCode{"AUE"}, // Abu Rudeis Airport
    IataCode{"AUF"}, // Auxerre – Branches Aerodrome
    IataCode{"AUG"}, // Augusta State Airport
    IataCode{"AUH"}, // Abu Dhabi International Airport
    IataCode{"AUK"}, // Alakanuk Airport
    IataCode{"AUL"}, // Aur Airport
    IataCode{"AUM"}, // Austin Municipal Airport
    IataCode{"AUN"}, // Auburn Municipal Airport
    IataCode{"AUO"}, // Auburn University Regional Airport
    IataCode{"AUP"}, // Agaun Airport
    IataCode{"AUQ"}, // Atuona Airport
    IataCode{"AUR"}, // Aurillac Airport
    IataCode{"AUS"}, // Austin-Bergstrom International Airport
    IataCode{"AUU"}, // Aurukun Airport
    IataCode{"AUW"}, // Wausau Downtown Airport
    IataCode{"AUX"}, // Araguaína Airport
    IataCode{"AUY"}, // Anatom Airport
    IataCode{"AUZ"}, // Aurora Municipal Airport
    IataCode{"AVA"}, // Anshun Huangguoshu Airport
    IataCode{"AVI"}, // Máximo Gómez Airport
    IataCode{"AVK"}, // Arvaikheer Airport
    IataCode{"AVL"}, // Asheville Regional Airport
    IataCode{"AVN"}, // Avignon – Caumont Airport
    IataCode{"AVO"}, // Avon Park Executive Airport
    IataCode{"AVP"}, // Wilkes-Barre/Scranton International Airport
    IataCode{"AVU"}, // Avu Avu Airport
    IataCode{"AVV"}, // Avalon Airport
    IataCode{"AVW"}, // Marana Regional Airport
    IataCode{"AVX"}, // Catalina Airport
    IataCode{"AWA"}, // Awasa Airport
    IataCode{"AWB"}, // Awaba Airport
    IataCode{"AWD"}, // Aniwa Airport
    IataCode{"AWK"}, // Wake Island Airfield
    IataCode{"AWM"}, // West Memphis Municipal Airport
    IataCode{"AWO"}, // Arlington Municipal Airport
    IataCode{"AWZ"}, // Ahwaz International Airport
    IataCode{"AXA"}, // Clayton J. Lloyd International Airport
    IataCode{"AXB"}, // Maxson Airfield
    IataCode{"AXC"}, // Aramac Airport
    IataCode{"AXD"}, // Alexandroupolis International Airport
    IataCode{"AXE"}, // Xanxerê Airport
    IataCode{"AXF"}, // Alxa Left Banner Bayanhot Airport
    IataCode{"AXG"}, // Algona Municipal Airport
    IataCode{"AXH"}, // Houston Southwest Airport
    IataCode{"AXJ"}, // Amakusa Airfield
    IataCode{"AXK"}, // Ataq Airport
    IataCode{"AXM"}, // El Edén International Airport
    IataCode{"AXN"}, // Alexandria Municipal Airport
    IataCode{"AXP"}, // Spring Point Airport
    IataCode{"AXQ"}, // Clarion County Airport
    IataCode{"AXS"}, // Altus/Quartz Mountain Regional Airport
    IataCode{"AXT"}, // Akita Airport
    IataCode{"AXU"}, // Axum Airport
    IataCode{"AXV"}, // Neil Armstrong Airport
    IataCode{"AYA"}, // Ayapel Airport
    IataCode{"AYK"}, // Arkalyk Airport
    IataCode{"AYN"}, // Anyang Yudongbei Airport
    IataCode{"AYO"}, // Juan de Ayolas Airport
    IataCode{"AYP"}, // Coronel FAP Alfredo Mendívil Duarte Airport
    IataCode{"AYQ"}, // Ayers Rock Airport
    IataCode{"AYR"}, // Ayr Airport
    IataCode{"AYS"}, // Waycross-Ware County Airport
    IataCode{"AYT"}, // Antalya International Airport
    IataCode{"AYU"}, // Aiyura Airport
    IataCode{"AYW"}, // Ayawasi Airport
    IataCode{"AYZ"}, // Zahn's Airport
    IataCode{"AZA"}, // Phoenix–Mesa Gateway Airport
    IataCode{"AZC"}, // Colorado City Municipal Airport
    IataCode{"AZD"}, // Shahid Sadooghi Airport
    IataCode{"AZI"}, // Al Bateen Executive Airport
    IataCode{"AZN"}, // Andizhan Airport
    IataCode{"AZO"}, // Kalamazoo/Battle Creek International Airport
    IataCode{"AZR"}, // Touat-Cheikh Sidi Mohamed Belkebir Airport
    IataCode{"AZS"}, // Samaná El Catey International Airport
    IataCode{"AZZ"}, // Ambriz Airport
    IataCode{"BAE"}, // Barcelonnette – Saint-Pons Airport
    IataCode{"BAF"}, // Barnes Municipal Airport
    IataCode{"BAG"}, // Loakan Airport
    IataCode{"BAH"}, // Bahrain International Airport
    IataCode{"BAI"}, // Buenos Aires Airport, Costa Rica
    IataCode{"BAM"}, // Battle Mountain Airport
    IataCode{"BAN"}, // Basongo Airport
    IataCode{"BAQ"}, // Ernesto Cortissoz International Airport
    IataCode{"BAR"}, // Qionghai Bo'ao Airport
    IataCode{"BAS"}, // Balalae Airport
    IataCode{"BAT"}, // Barretos Airport
    IataCode{"BAU"}, // Bauru Airport
    IataCode{"BAV"}, // Baotou Erliban Airport
    IataCode{"BAX"}, // Barnaul Airport
    IataCode{"BAY"}, // Maramures International Airport
    IataCode{"BAZ"}, // Barcelos Airport
    IataCode{"BBA"}, // Balmaceda Airport
    IataCode{"BBB"}, // Benson Municipal Airport
    IataCode{"BBC"}, // Bay City Municipal Airport
    IataCode{"BBD"}, // Curtis Field
    IataCode{"BBG"}, // Butaritari Atoll Airport
    IataCode{"BBH"}, // Stralsund Barth Airport
    IataCode{"BBI"}, // Biju Patnaik Airport
    IataCode{"BBK"}, // Kasane Airport
    IataCode{"BBL"}, // Ballera Airport
    IataCode{"BBM"}, // Battambang Airport
    IataCode{"BBN"}, // Bario Airport
    IataCode{"BBO"}, // Berbera Airport
    IataCode{"BBP"}, // Bembridge Airport
    IataCode{"BBQ"}, // Codrington Airport
    IataCode{"BBR"}, // Baillif Airport
    IataCode{"BBS"}, // Blackbushe Airport
    IataCode{"BBT"}, // Berbérati Airport
    IataCode{"BBU"}, // Aurel Vlaicu International Airport
    IataCode{"BBV"}, // Nero-Mer Airport
    IataCode{"BBW"}, // Broken Bow Municipal Airport
    IataCode{"BBX"}, // Wings Field
    IataCode{"BBY"}, // Bambari Airport
    IataCode{"BBZ"}, // Zambezi Airport
    IataCode{"BCA"}, // Gustavo Rizo Airport
    IataCode{"BCB"}, // Virginia Tech Montgomery Executive Airport
    IataCode{"BCC"}, // Bear Creek 3 Airport
    IataCode{"BCD"}, // Bacolod-Silay International Airport
    IataCode{"BCE"}, // Bryce Canyon Airport
    IataCode{"BCF"}, // Bouca Airport
    IataCode{"BCH"}, // Baucau Airport
    IataCode{"BCI"}, // Barcaldine Airport
    IataCode{"BCK"}, // Black River Falls Area Airport
    IataCode{"BCL"}, // Barra del Colorado Airport
    IataCode{"BCM"}, // Bacău International Airport
    IataCode{"BCN"}, // Barcelona–El Prat Airport
    IataCode{"BCO"}, // Baco Airport
    IataCode{"BCQ"}, // Brak Airport
    IataCode{"BCR"}, // Bela Crkva Airport
    IataCode{"BCS"}, // Southern Seaplane Airport
    IataCode{"BCT"}, // Boca Raton Airport
    IataCode{"BCU"}, // Bauchi State Airport
    IataCode{"BCV"}, // Hector Silva Airstrip
    IataCode{"BCW"}, // Benguera Island Airport
    IataCode{"BDA"}, // L.F. Wade International Airport
    IataCode{"BDB"}, // Bundaberg Airport
    IataCode{"BDC"}, // Barra do Corda Airport
    IataCode{"BDD"}, // Badu Island Airport
    IataCode{"BDE"}, // Baudette International Airport
    IataCode{"BDG"}, // Blanding Municipal Airport
    IataCode{"BDH"}, // Bandar Lengeh Airport
    IataCode{"BDI"}, // Bird Island Airport
    IataCode{"BDJ"}, // Syamsudin Noor Airport
    IataCode{"BDK"}, // Soko Airport
    IataCode{"BDL"}, // Bradley International Airport
    IataCode{"BDN"}, // Bend Municipal Airport
    IataCode{"BDO"}, // Husein Sastranegara International Airport
    IataCode{"BDP"}, // Bhadrapur Airport
    IataCode{"BDQ"}, // Vadodara Airport
    IataCode{"BDR"}, // Sikorsky Memorial Airport
    IataCode{"BDS"}, // Brindisi – Salento Airport
    IataCode{"BDT"}, // Gbadolite Airport
    IataCode{"BDU"}, // Bardufoss Airport
    IataCode{"BDV"}, // Moba Airport
    IataCode{"BDX"}, // Broadus Airport
    IataCode{"BDY"}, // Bandon State Airport
    IataCode{"BEB"}, // Benbecula Airport
    IataCode{"BEC"}, // Beech Factory Airport
    IataCode{"BED"}, // Hanscom Field
    IataCode{"BEF"}, // Bluefields Airport
    IataCode{"BEG"}, // Belgrade Nikola Tesla Airport
    IataCode{"BEH"}, // Southwest Michigan Regional Airport
    IataCode{"BEI"}, // Beica Airport
    IataCode{"BEJ"}, // Kalimarau Airport
    IataCode{"BEK"}, // Bareilly Airport
    IataCode{"BEL"}, // Val de Cans International Airport
    IataCode{"BEM"}, // Bossembélé Airport
    IataCode{"BEN"}, // Benina International Airport
    IataCode{"BEO"}, // Belmont Airport
    IataCode{"BEP"}, // Bellary Airport
    IataCode{"BER"}, // Berlin Brandenburg Airport
    IataCode{"BES"}, // Brest Bretagne Airport
    IataCode{"BET"}, // Bethel Airport
    IataCode{"BEU"}, // Bedourie Airport
    IataCode{"BEV"}, // Be'er Sheva Airport
    IataCode{"BEW"}, // Beira Airport
    IataCode{"BEY"}, // Beirut–Rafic Hariri International Airport
    IataCode{"BEZ"}, // Beru Island Airport
    IataCode{"BFD"}, // Bradford Regional Airport
    IataCode{"BFF"}, // Western Nebraska Regional Airport
    IataCode{"BFG"}, // Bullfrog Basin Airport
    IataCode{"BFH"}, // Bacacheri Airport
    IataCode{"BFI"}, // Boeing Field
    IataCode{"BFJ"}, // Bijie Feixiong Airport
    IataCode{"BFK"}, // Buffalo Municipal Airport
    IataCode{"BFL"}, // Meadows Field Airport
    IataCode{"BFM"}, // Mobile Downtown Airport
    IataCode{"BFN"}, // Bloemfontein Airport
    IataCode{"BFO"}, // Buffalo Range Airport
    IataCode{"BFP"}, // Beaver County Airport
    IataCode{"BFQ"}, // Bahía Piña Airport
    IataCode{"BFR"}, // Virgil I. Grissom Municipal Airport
    IataCode{"BFS"}, // Belfast International Airport
    IataCode{"BFT"}, // Beaufort County Airport
    IataCode{"BFU"}, // Bengbu Airport
    IataCode{"BFV"}, // Buriram Airport
    IataCode{"BFW"}, // Sidi Bel Abbes Airport
    IataCode{"BFX"}, // Bafoussam Airport
    IataCode{"BGA"}, // Palonegro International Airport
    IataCode{"BGB"}, // Booué Airport
    IataCode{"BGC"}, // Bragança Airport
    IataCode{"BGD"}, // Hutchinson County Airport
    IataCode{"BGE"}, // Decatur County Industrial Air Park
    IataCode{"BGF"}, // Bangui M'Poko International Airport
    IataCode{"BGG"}, // Bingöl Airport
    IataCode{"BGH"}, // Abbaye Airport
    IataCode{"BGI"}, // Grantley Adams International Airport
    IataCode{"BGK"}, // Big Creek Airport
    IataCode{"BGM"}, // Greater Binghamton Airport
    IataCode{"BGN"}, // Belaya Gora Airport
    IataCode{"BGO"}, // Bergen Airport
    IataCode{"BGQ"}, // Big Lake Airport
    IataCode{"BGR"}, // Bangor International Airport
    IataCode{"BGT"}, // Bagdad Airport
    IataCode{"BGU"}, // Bangassou Airport
    IataCode{"BGV"}, // Bento Gonçalves Airport
    IataCode{"BGW"}, // Baghdad International Airport
    IataCode{"BGX"}, // Comandante Gustavo Kraemer Airport
    IataCode{"BGY"}, // Il Caravaggio International Airport
    IataCode{"BGZ"}, // Braga Airport
    IataCode{"BHA"}, // Los Perales Airport
    IataCode{"BHB"}, // Hancock County-Bar Harbor Airport
    IataCode{"BHD"}, // George Best Belfast City Airport
    IataCode{"BHE"}, // Woodbourne Airport
    IataCode{"BHG"}, // Brus Laguna Airport
    IataCode{"BHH"}, // Bisha Domestic Airport
    IataCode{"BHI"}, // Comandante Espora Airport
    IataCode{"BHJ"}, // Bhuj Airport
    IataCode{"BHK"}, // Bukhara International Airport
    IataCode{"BHL"}, // Bahía de los Ángeles Airport
    IataCode{"BHM"}, // Birmingham-Shuttlesworth International Airport
    IataCode{"BHN"}, // Beihan Airport
    IataCode{"BHO"}, // Raja Bhoj Airport
    IataCode{"BHP"}, // Bhojpur Airport
    IataCode{"BHQ"}, // Broken Hill Airport
    IataCode{"BHR"}, // Bharatpur Airport
    IataCode{"BHS"}, // Bathurst Airport
    IataCode{"BHU"}, // Bhavnagar Airport
    IataCode{"BHV"}, // Bahawalpur Airport
    IataCode{"BHX"}, // Birmingham Airport
    IataCode{"BHY"}, // Beihai Fucheng Airport
    IataCode{"BIA"}, // Bastia – Poretta Airport
    IataCode{"BIB"}, // Baidoa Airport
    IataCode{"BID"}, // Block Island State Airport
    IataCode{"BII"}, // Bikini Atoll Airport
    IataCode{"BIK"}, // Frans Kaisiepo Airport
    IataCode{"BIL"}, // Billings Logan International Airport
    IataCode{"BIM"}, // South Bimini Airport
    IataCode{"BIN"}, // Bamyan Airport
    IataCode{"BIO"}, // Bilbao Airport
    IataCode{"BIQ"}, // Biarritz – Anglet – Bayonne Airport
    IataCode{"BIR"}, // Biratnagar Airport
    IataCode{"BIS"}, // Bismarck Municipal Airport
    IataCode{"BIU"}, // Bíldudalur Airport
    IataCode{"BIV"}, // Bria Airport
    IataCode{"BIY"}, // Bisho Airport
    IataCode{"BJA"}, // Soummam – Abane Ramdane Airport
    IataCode{"BJB"}, // Bojnord Airport
    IataCode{"BJC"}, // Rocky Mountain Metropolitan Airport
    IataCode{"BJD"}, // Bakkafjörður Airport
    IataCode{"BJF"}, // Båtsfjord Airport
    IataCode{"BJG"}, // Bolaang Airport
    IataCode{"BJH"}, // Bajhang Airport
    IataCode{"BJI"}, // Bemidji Regional Airport
    IataCode{"BJJ"}, // Wayne County Airport
    IataCode{"BJK"}, // Benjina Airport
    IataCode{"BJL"}, // Banjul International Airport
    IataCode{"BJM"}, // Bujumbura International Airport
    IataCode{"BJO"}, // Bermejo Airport
    IataCode{"BJP"}, // Bragança Paulista Airport
    IataCode{"BJR"}, // Bahir Dar Airport
    IataCode{"BJT"}, // Bentota River Airport
    IataCode{"BJU"}, // Bajura Airport
    IataCode{"BJV"}, // Milas-Bodrum Airport
    IataCode{"BJW"}, // Bajawa Soa Airport
    IataCode{"BJX"}, // Del Bajío International Airport
    IataCode{"BJZ"}, // Badajoz Airport
    IataCode{"BKA"}, // Bykovo Airport
    IataCode{"BKB"}, // Nal Airport
    IataCode{"BKC"}, // Buckland Airport
    IataCode{"BKE"}, // Baker City Municipal Airport
    IataCode{"BKF"}, // Lake Brooks Seaplane Base
    IataCode{"BKG"}, // Branson Airport
    IataCode{"BKH"}, // Pacific Missile Range Facility
    IataCode{"BKI"}, // Kota Kinabalu International Airport
    IataCode{"BKJ"}, // Boké Baralande Airport
    IataCode{"BKK"}, // Suvarnabhumi Airport
    IataCode{"BKL"}, // Cleveland Burke Lakefront Airport
    IataCode{"BKM"}, // Ba'kelalan Airport
    IataCode{"BKN"}, // Balkanabat Airport
    IataCode{"BKO"}, // Bamako-Sénou International Airport
    IataCode{"BKQ"}, // Blackall Airport
    IataCode{"BKR"}, // Bokoro Airport
    IataCode{"BKS"}, // Fatmawati Soekarno Airport
    IataCode{"BKV"}, // Brooksville–Tampa Bay Regional Airport
    IataCode{"BKW"}, // Raleigh County Memorial Airport
    IataCode{"BKX"}, // Brookings Regional Airport
    IataCode{"BKY"}, // Kavumu Airport
    IataCode{"BKZ"}, // Bukoba Airport
    IataCode{"BLA"}, // General José Antonio Anzoátegui International Airport
    IataCode{"BLB"}, // Panamá Pacífico International Airport
    IataCode{"BLC"}, // Bali Airport
    IataCode{"BLD"}, // Boulder City Municipal Airport
    IataCode{"BLE"}, // Dala Airport
    IataCode{"BLF"}, // Mercer County Airport
    IataCode{"BLG"}, // Belaga Airport
    IataCode{"BLH"}, // Blythe Airport
    IataCode{"BLJ"}, // Mostépha Ben Boulaid Airport
    IataCode{"BLK"}, // Blackpool International Airport
    IataCode{"BLL"}, // Billund Airport
    IataCode{"BLM"}, // Monmouth Executive Airport
    IataCode{"BLN"}, // Benalla Airport
    IataCode{"BLO"}, // Blönduós Airport
    IataCode{"BLQ"}, // Bologna Guglielmo Marconi Airport
    IataCode{"BLR"}, // Kempegowda International Airport
    IataCode{"BLT"}, // Blackwater Airport
    IataCode{"BLU"}, // Blue Canyon–Nyack Airport
    IataCode{"BLX"}, // Belluno Airport
    IataCode{"BLY"}, // Belmullet Aerodrome
    IataCode{"BLZ"}, // Chileka International Airport
    IataCode{"BMA"}, // Stockholm Bromma Airport
    IataCode{"BMB"}, // Bumba Airport
    IataCode{"BMC"}, // Brigham City Airport
    IataCode{"BMD"}, // Belo sur Tsiribihina Airport
    IataCode{"BME"}, // Broome International Airport
    IataCode{"BMF"}, // Bakouma Airport
    IataCode{"BMG"}, // Monroe County Airport
    IataCode{"BMI"}, // Central Illinois Regional Airport
    IataCode{"BMJ"}, // Baramita Airport
    IataCode{"BMK"}, // Borkum Airfield
    IataCode{"BML"}, // Berlin Regional Airport
    IataCode{"BMM"}, // Bitam Airport
    IataCode{"BMO"}, // Bhamo Airport
    IataCode{"BMP"}, // Berhampur Airport
    IataCode{"BMQ"}, // Bamburi Airport
    IataCode{"BMR"}, // Baltrum Airport
    IataCode{"BMS"}, // Brumado Airport
    IataCode{"BMT"}, // Beaumont Municipal Airport
    IataCode{"BMU"}, // Bima Airport
    IataCode{"BMV"}, // Buon Ma Thuot Airport
    IataCode{"BMW"}, // Bordj Mokhtar Airport
    IataCode{"BMY"}, // Île Art – Waala Airport
    IataCode{"BNA"}, // Nashville International Airport
    IataCode{"BNB"}, // Boende Airport
    IataCode{"BNC"}, // Beni Airport
    IataCode{"BND"}, // Bandar Abbas International Airport
    IataCode{"BNE"}, // Brisbane Airport
    IataCode{"BNG"}, // Banning Municipal Airport
    IataCode{"BNI"}, // Benin Airport
    IataCode{"BNJ"}, // Bonn/Hangelar Airport
    IataCode{"BNK"}, // Ballina Byron Gateway Airport
    IataCode{"BNL"}, // Barnwell Regional Airport
    IataCode{"BNN"}, // Brønnøysund Airport, Brønnøy
    IataCode{"BNO"}, // Burns Municipal Airport
    IataCode{"BNP"}, // Bannu Airport
    IataCode{"BNR"}, // Banfora Airport
    IataCode{"BNS"}, // Barinas Airport
    IataCode{"BNU"}, // Blumenau Airport
    IataCode{"BNW"}, // Boone Municipal Airport
    IataCode{"BNX"}, // Banja Luka International Airport
    IataCode{"BNY"}, // Bellona/Anua Airport
    IataCode{"BOA"}, // Boma Airport
    IataCode{"BOB"}, // Bora Bora Airport
    IataCode{"BOC"}, // Bocas del Toro "Isla Colón" International Airport
    IataCode{"BOD"}, // Bordeaux–Mérignac Airport
    IataCode{"BOE"}, // Boundji Airport
    IataCode{"BOG"}, // El Dorado International Airport
    IataCode{"BOH"}, // Bournemouth Airport
    IataCode{"BOI"}, // Boise Airport
    IataCode{"BOJ"}, // Burgas Airport
    IataCode{"BOK"}, // Brookings Airport
    IataCode{"BOM"}, // Chhatrapati Shivaji International Airport
    IataCode{"BON"}, // Flamingo International Airport
    IataCode{"BOO"}, // Bodø Airport
    IataCode{"BOP"}, // Bouar Airport
    IataCode{"BOS"}, // Logan International Airport
    IataCode{"BOT"}, // Bosset Airport
    IataCode{"BOU"}, // Bourges Airport
    IataCode{"BOW"}, // Bartow Municipal Airport
    IataCode{"BOX"}, // Borroloola Airport
    IataCode{"BOY"}, // Bobo Dioulasso Airport
    IataCode{"BOZ"}, // Bozoum Airport
    IataCode{"BPC"}, // Bamenda Airport
    IataCode{"BPE"}, // Qinhuangdao Beidaihe Airport
    IataCode{"BPF"}, // Batuna Airport
    IataCode{"BPG"}, // Barra do Garças Airport
    IataCode{"BPH"}, // Bislig Airport
    IataCode{"BPI"}, // Miley Memorial Field
    IataCode{"BPK"}, // Biangabip Airport
    IataCode{"BPL"}, // Bole Alashankou Airport
    IataCode{"BPM"}, // Begumpet Airport
    IataCode{"BPN"}, // Sultan Aji Muhammad Sulaiman Airport
    IataCode{"BPR"}, // Borongan Airport
    IataCode{"BPS"}, // Porto Seguro Airport
    IataCode{"BPT"}, // Jack Brooks Regional Airport
    IataCode{"BPX"}, // Qamdo Bamda Airport
    IataCode{"BPY"}, // Besalampy Airport
    IataCode{"BQA"}, // Dr. Juan C. Angara Airport
    IataCode{"BQB"}, // Busselton Regional Airport
    IataCode{"BQE"}, // Bubaque Airport
    IataCode{"BQG"}, // Bogorodskoye Airport
    IataCode{"BQH"}, // London Biggin Hill Airport
    IataCode{"BQJ"}, // Batagay Airport
    IataCode{"BQK"}, // Brunswick Golden Isles Airport
    IataCode{"BQL"}, // Boulia Airport
    IataCode{"BQN"}, // Rafael Hernández Airport
    IataCode{"BQO"}, // Tehini Airport
    IataCode{"BQQ"}, // Barra Airport
    IataCode{"BQR"}, // Buffalo-Lancaster Regional Airport
    IataCode{"BQS"}, // Ignatyevo Airport
    IataCode{"BQT"}, // Brest Airport
    IataCode{"BQU"}, // J. F. Mitchell Airport
    IataCode{"BQW"}, // Balgo Hill Airport
    IataCode{"BRA"}, // Barreiras Airport
    IataCode{"BRB"}, // Barreirinhas Airport
    IataCode{"BRC"}, // San Carlos de Bariloche Airport
    IataCode{"BRD"}, // Brainerd Lakes Regional Airport
    IataCode{"BRE"}, // Bremen Airport
    IataCode{"BRI"}, // Bari Karol Wojtyła Airport
    IataCode{"BRK"}, // Bourke Airport
    IataCode{"BRL"}, // Southeast Iowa Regional Airport
    IataCode{"BRM"}, // Jacinto Lara International Airport
    IataCode{"BRN"}, // Bern Airport
    IataCode{"BRO"}, // Brownsville/South Padre Island International Airport
    IataCode{"BRQ"}, // Brno-Tuřany Airport
    IataCode{"BRR"}, // Barra Airport
    IataCode{"BRS"}, // Bristol Airport
    IataCode{"BRT"}, // Bathurst Island Airport
    IataCode{"BRU"}, // Brussels Airport
    IataCode{"BRV"}, // Braşov Airport
    IataCode{"BRW"}, // Wiley Post–Will Rogers Memorial Airport
    IataCode{"BRX"}, // María Montez International Airport
    IataCode{"BRY"}, // Samuels Field
    IataCode{"BSA"}, // Bender Qassim International Airport
    IataCode{"BSB"}, // Brasília International Airport
    IataCode{"BSC"}, // José Celestino Mutis Airport
    IataCode{"BSD"}, // Baoshan Yunduan Airport
    IataCode{"BSE"}, // Sematan Airport
    IataCode{"BSG"}, // Bata Airport
    IataCode{"BSJ"}, // Bairnsdale Airport
    IataCode{"BSK"}, // Biskra Airport
    IataCode{"BSL"}, // EuroAirport Basel-Mulhouse-Freiburg
    IataCode{"BSN"}, // Bossangoa Airport
    IataCode{"BSO"}, // Basco Airport
    IataCode{"BSP"}, // Bensbach Airport
    IataCode{"BSQ"}, // Bisbee Municipal Airport
    IataCode{"BSR"}, // Basra International Airport
    IataCode{"BSS"}, // Balsas Airport
    IataCode{"BST"}, // Bost Airport
    IataCode{"BSU"}, // Basankusu Airport
    IataCode{"BSW"}, // Boswell Bay Airport
    IataCode{"BSX"}, // Pathein Airport
    IataCode{"BSY"}, // Bardera Airport
    IataCode{"BTA"}, // Bertoua Airport
    IataCode{"BTB"}, // Bétou Airport
    IataCode{"BTE"}, // Sherbro International Airport
    IataCode{"BTF"}, // Skypark Airport
    IataCode{"BTG"}, // Batangafo Airport
    IataCode{"BTH"}, // Hang Nadim Airport
    IataCode{"BTI"}, // Barter Island LRRS Airport
    IataCode{"BTJ"}, // Sultan Iskandar Muda Airport
    IataCode{"BTK"}, // Bratsk Airport
    IataCode{"BTL"}, // W. K. Kellogg Airport
    IataCode{"BTM"}, // Bert Mooney Airport
    IataCode{"BTN"}, // Marlboro County Jetport
    IataCode{"BTO"}, // Botopassi Airstrip
    IataCode{"BTP"}, // Butler County Airport
    IataCode{"BTQ"}, // Butare Airport
    IataCode{"BTR"}, // Baton Rouge Metropolitan Airport
    IataCode{"BTS"}, // M. R. Štefánik Airport
    IataCode{"BTT"}, // Bettles Airport
    IataCode{"BTU"}, // Bintulu Airport
    IataCode{"BTV"}, // Burlington International Airport
    IataCode{"BTW"}, // Batu Licin Airport
    IataCode{"BTY"}, // Beatty Airport
    IataCode{"BUA"}, // Buka Airport
    IataCode{"BUC"}, // Burketown Airport
    IataCode{"BUD"}, // Budapest Ferenc Liszt International Airport
    IataCode{"BUF"}, // Buffalo Niagara International Airport
    IataCode{"BUG"}, // Benguela Airport
    IataCode{"BUI"}, // Bokondini Airport
    IataCode{"BUJ"}, // Ain Eddis Airport
    IataCode{"BUK"}, // Albuq Airport
    IataCode{"BUL"}, // Bulolo Airport
    IataCode{"BUN"}, // Gerardo Tobar López Airport
    IataCode{"BUO"}, // Burao Airport
    IataCode{"BUP"}, // Bathinda Airport
    IataCode{"BUQ"}, // Joshua Mqabuko Nkomo International Airport
    IataCode{"BUR"}, // Bob Hope Airport
    IataCode{"BUS"}, // Batumi International Airport
    IataCode{"BUT"}, // Bathpalathang Airport
    IataCode{"BUU"}, // Burlington Municipal Airport
    IataCode{"BUV"}, // Placeres Airport
    IataCode{"BUW"}, // Betoambari Airport
    IataCode{"BUX"}, // Bunia Airport
    IataCode{"BUY"}, // Bunbury Airport
    IataCode{"BUZ"}, // Bushehr Airport
    IataCode{"BVA"}, // Beauvais-Tillé Airport
    IataCode{"BVB"}, // Boa Vista International Airport
    IataCode{"BVC"}, // Aristides Pereira International Airport
    IataCode{"BVE"}, // Brive – Souillac Airport
    IataCode{"BVG"}, // Berlevåg Airport
    IataCode{"BVH"}, // Vilhena Airport
    IataCode{"BVI"}, // Birdsville Airport
    IataCode{"BVK"}, // Huacaraje Airport
    IataCode{"BVL"}, // Baures Airport
    IataCode{"BVN"}, // Albion Municipal Airport
    IataCode{"BVO"}, // Bartlesville Municipal Airport
    IataCode{"BVR"}, // Esperadinha Airport
    IataCode{"BVU"}, // Beluga Airport
    IataCode{"BVV"}, // Burevestnik Airport
    IataCode{"BVW"}, // Batavia Downs Airport
    IataCode{"BVX"}, // Batesville Regional Airport
    IataCode{"BVY"}, // Beverly Municipal Airport
    IataCode{"BWA"}, // Gautam Buddha Airport
    IataCode{"BWB"}, // Barrow Island Airport
    IataCode{"BWC"}, // Brawley Municipal Airport
    IataCode{"BWD"}, // Brownwood Regional Airport
    IataCode{"BWE"}, // Braunschweig Airport
    IataCode{"BWF"}, // Barrow/Walney Island Airport
    IataCode{"BWG"}, // Bowling Green-Warren County Regional Airport
    IataCode{"BWH"}, // RMAF Butterworth
    IataCode{"BWI"}, // Baltimore/Washington International Thurgood Marshall Airport
    IataCode{"BWK"}, // Bol Airport
    IataCode{"BWL"}, // Blackwell–Tonkawa Municipal Airport
    IataCode{"BWM"}, // Bowman Municipal Airport
    IataCode{"BWN"}, // Brunei International Airport
    IataCode{"BWO"}, // Balakovo Airport
    IataCode{"BWQ"}, // Brewarrina Airport
    IataCode{"BWS"}, // Blaine Municipal Airport
    IataCode{"BWT"}, // Burnie Airport
    IataCode{"BWU"}, // Bankstown Airport
    IataCode{"BWW"}, // Las Brujas Airport
    IataCode{"BWX"}, // Blimbingsari Airport
    IataCode{"BXB"}, // Babo Airport
    IataCode{"BXD"}, // Bade Airport
    IataCode{"BXE"}, // Bakel Airport
    IataCode{"BXG"}, // Bendigo Airport
    IataCode{"BXH"}, // Balkhash Airport
    IataCode{"BXI"}, // Boundiali Airport
    IataCode{"BXJ"}, // Boraldai Airport
    IataCode{"BXK"}, // Buckeye Municipal Airport
    IataCode{"BXM"}, // Batom Airport
    IataCode{"BXN"}, // Bodrum-Imsik Airport
    IataCode{"BXO"}, // Buochs Airport
    IataCode{"BXP"}, // Biała Podlaska Airport
    IataCode{"BXR"}, // Bam Airport
    IataCode{"BXS"}, // Borrego Valley Airport
    IataCode{"BXT"}, // Bontang Airport
    IataCode{"BXU"}, // Bancasi Airport
    IataCode{"BXV"}, // Breiðdalsvík Airport
    IataCode{"BXW"}, // Bawean Airport
    IataCode{"BXX"}, // Boorama Airport
    IataCode{"BYB"}, // Dibba Airport
    IataCode{"BYC"}, // Yacuiba Airport
    IataCode{"BYD"}, // Al Bayda' Airport
    IataCode{"BYF"}, // Albert – Picardie Airport
    IataCode{"BYH"}, // Arkansas International Airport
    IataCode{"BYI"}, // Burley Municipal Airport
    IataCode{"BYJ"}, // Beja Airport
    IataCode{"BYK"}, // Bouaké Airport
    IataCode{"BYM"}, // Carlos Manuel de Céspedes Airport
    IataCode{"BYN"}, // Bayankhongor Airport
    IataCode{"BYO"}, // Bonito Airport
    IataCode{"BYP"}, // Barimunya Airport
    IataCode{"BYQ"}, // Bunyu Airport
    IataCode{"BYR"}, // Læsø Airport
    IataCode{"BYT"}, // Bantry Aerodrome
    IataCode{"BZA"}, // San Pedro Airport
    IataCode{"BZB"}, // Bazaruto Island Airport
    IataCode{"BZC"}, // Armação dos Búzios Airport
    IataCode{"BZD"}, // Balranald Airport
    IataCode{"BZE"}, // Philip S. W. Goldson International Airport
    IataCode{"BZF"}, // Benton Field
    IataCode{"BZG"}, // Bydgoszcz Ignacy Jan Paderewski Airport
    IataCode{"BZK"}, // Bryansk International Airport
    IataCode{"BZL"}, // Barisal Airport
    IataCode{"BZN"}, // Bozeman Yellowstone International Airport
    IataCode{"BZO"}, // Bolzano airport
    IataCode{"BZR"}, // Béziers Cap d'Agde Airport
    IataCode{"BZU"}, // Buta Zega Airport
    IataCode{"BZV"}, // Maya-Maya Airport
    IataCode{"BZY"}, // Bălți International Airport
    IataCode{"CAA"}, // El Aguacate Airport
    IataCode{"CAB"}, // Cabinda Airport
    IataCode{"CAC"}, // Cascavel Airport
    IataCode{"CAD"}, // Wexford County Airport
    IataCode{"CAE"}, // Columbia Metropolitan Airport
    IataCode{"CAF"}, // Carauari Airport
    IataCode{"CAG"}, // Cagliari Elmas Airport
    IataCode{"CAH"}, // Cà Mau Airport
    IataCode{"CAI"}, // Cairo International Airport
    IataCode{"CAJ"}, // Canaima Airport
    IataCode{"CAK"}, // Akron-Canton Airport
    IataCode{"CAL"}, // Campbeltown Airport
    IataCode{"CAM"}, // Camiri Airport
    IataCode{"CAN"}, // Guangzhou Baiyun International Airport
    IataCode{"CAO"}, // Clayton Municipal Airpark
    IataCode{"CAP"}, // Cap-Haitien International Airport
    IataCode{"CAQ"}, // Juan H. White Airport
    IataCode{"CAR"}, // Caribou Municipal Airport
    IataCode{"CAS"}, // Casablanca-Anfa Airport
    IataCode{"CAT"}, // Cascais Municipal Aerodrome
    IataCode{"CAU"}, // Caruaru Airport
    IataCode{"CAV"}, // Cazombo Airport
    IataCode{"CAW"}, // Bartolomeu Lysandro Airport
    IataCode{"CAX"}, // Carlisle Lake District Airport
    IataCode{"CAY"}, // Cayenne – Félix Eboué Airport
    IataCode{"CAZ"}, // Cobar Airport
    IataCode{"CBA"}, // Chabelley Airport
    IataCode{"CBB"}, // Jorge Wilstermann International Airport
    IataCode{"CBE"}, // Greater Cumberland Regional Airport
    IataCode{"CBF"}, // Council Bluffs Municipal Airport
    IataCode{"CBG"}, // Cambridge Airport
    IataCode{"CBH"}, // Boudghene Ben Ali Lotfi Airport
    IataCode{"CBJ"}, // Cabo Rojo Airport
    IataCode{"CBK"}, // Colby Municipal Airport
    IataCode{"CBL"}, // Tomás de Heres Airport
    IataCode{"CBN"}, // Penggung Airport
    IataCode{"CBO"}, // Awang Airport
    IataCode{"CBP"}, // Coimbra Airport
    IataCode{"CBQ"}, // Margaret Ekpo International Airport
    IataCode{"CBR"}, // Canberra International Airport
    IataCode{"CBS"}, // Oro Negro Airport
    IataCode{"CBT"}, // Catumbela Airport
    IataCode{"CBU"}, // Cottbus-Drewitz Airport
    IataCode{"CBV"}, // Cobán Airport
    IataCode{"CBW"}, // Campo Mourão Airport
    IataCode{"CBX"}, // Condobolin Airport
    IataCode{"CCA"}, // Chimore Airport
    IataCode{"CCB"}, // Cable Airport
    IataCode{"CCC"}, // Jardines del Rey Airport
    IataCode{"CCF"}, // Carcassonne Airport
    IataCode{"CCH"}, // Chile Chico Airport
    IataCode{"CCI"}, // Concórdia Airport
    IataCode{"CCJ"}, // Calicut International Airport
    IataCode{"CCK"}, // Cocos (Keeling) Islands Airport
    IataCode{"CCL"}, // Chinchilla Airport
    IataCode{"CCM"}, // Diomício Freitas Airport
    IataCode{"CCN"}, // Chaghcharan Airport
    IataCode{"CCO"}, // Carimagua Airport
    IataCode{"CCP"}, // Carriel Sur International Airport
    IataCode{"CCR"}, // Buchanan Field Airport
    IataCode{"CCS"}, // Simón Bolívar International Airport
    IataCode{"CCT"}, // Colonia Catriel Airport
    IataCode{"CCU"}, // Netaji Subhas Chandra Bose International Airport
    IataCode{"CCV"}, // Craig Cove Airport
    IataCode{"CCW"}, // Cowell Airport
    IataCode{"CCX"}, // Cáceres Airport
    IataCode{"CCY"}, // Northeast Iowa Regional Airport
    IataCode{"CCZ"}, // Chub Cay International Airport
    IataCode{"CDB"}, // Cold Bay Airport
    IataCode{"CDC"}, // Cedar City Regional Airport
    IataCode{"CDD"}, // Cauquira Airport
    IataCode{"CDE"}, // Chengde Airport
    IataCode{"CDF"}, // Cortina Airport
    IataCode{"CDG"}, // Paris-Charles de Gaulle Airport
    IataCode{"CDH"}, // Harrell Field
    IataCode{"CDI"}, // Cachoeiro de Itapemirim Airport
    IataCode{"CDJ"}, // Conceição do Araguaia Airport
    IataCode{"CDK"}, // George T. Lewis Airport
    IataCode{"CDN"}, // Woodward Field (airport)
    IataCode{"CDP"}, // Cuddapah Airport
    IataCode{"CDR"}, // Chadron Municipal Airport
    IataCode{"CDS"}, // Childress Municipal Airport
    IataCode{"CDT"}, // Castellón Airport
    IataCode{"CDU"}, // Camden Airport
    IataCode{"CDV"}, // Merle K. (Mudhole) Smith Airport
    IataCode{"CDW"}, // Essex County Airport
    IataCode{"CDY"}, // Cagayan de Sulu Airport
    IataCode{"CEA"}, // Cessna Aircraft Field
    IataCode{"CEB"}, // Mactan–Cebu International Airport
    IataCode{"CEC"}, // Del Norte County Airport
    IataCode{"CED"}, // Ceduna Airport
    IataCode{"CEE"}, // Cherepovets Airport
    IataCode{"CEF"}, // Westover Metropolitan Airport
    IataCode{"CEG"}, // Hawarden Airport
    IataCode{"CEH"}, // Chelinda Airport
    IataCode{"CEI"}, // Mae Fah Luang – Chiang Rai International Airport
    IataCode{"CEJ"}, // Chernihiv Shestovitsa Airport
    IataCode{"CEK"}, // Chelyabinsk Airport
    IataCode{"CEL"}, // Cape Eleuthera Airport
    IataCode{"CEM"}, // Central Airport
    IataCode{"CEN"}, // Ciudad Obregón International Airport
    IataCode{"CEO"}, // Waco Kungo Airport
    IataCode{"CEP"}, // Concepcion Airport
    IataCode{"CEQ"}, // Cannes – Mandelieu Airport
    IataCode{"CER"}, // Cherbourg – Maupertus Airport
    IataCode{"CES"}, // Cessnock Airport
    IataCode{"CET"}, // Cholet - The Pontreau Aerodrome
    IataCode{"CEU"}, // Oconee County Regional Airport
    IataCode{"CEV"}, // Mettel Field
    IataCode{"CEW"}, // Bob Sikes Airport
    IataCode{"CEY"}, // Murray-Calloway County Airport
    IataCode{"CEZ"}, // Cortez Municipal Airport
    IataCode{"CFB"}, // Cabo Frio International Airport
    IataCode{"CFC"}, // Caçador Airport
    IataCode{"CFD"}, // Coulter Field
    IataCode{"CFE"}, // Clermont-Ferrand Auvergne Airport
    IataCode{"CFF"}, // Cafunfo Airport
    IataCode{"CFG"}, // Jaime González Airport
    IataCode{"CFN"}, // Donegal Airport
    IataCode{"CFO"}, // Confresa Airport
    IataCode{"CFQ"}, // Creston Aerodrome
    IataCode{"CFR"}, // Caen – Carpiquet Airport
    IataCode{"CFS"}, // Coffs Harbour Airport
    IataCode{"CFT"}, // Greenlee County Airport
    IataCode{"CFU"}, // Corfu International Airport
    IataCode{"CFV"}, // Coffeyville Municipal Airport
    IataCode{"CGA"}, // Craig Seaplane Base
    IataCode{"CGB"}, // Marechal Rondon International Airport
    IataCode{"CGC"}, // Cape Gloucester Airport
    IataCode{"CGD"}, // Changde Taohuayuan Airport
    IataCode{"CGE"}, // Cambridge–Dorchester Airport
    IataCode{"CGF"}, // Cuyahoga County Airport
    IataCode{"CGH"}, // Congonhas-São Paulo Airport
    IataCode{"CGI"}, // Cape Girardeau Regional Airport
    IataCode{"CGJ"}, // Kasompe Airport
    IataCode{"CGK"}, // Soekarno–Hatta International Airport
    IataCode{"CGM"}, // Camiguin Airport
    IataCode{"CGN"}, // Cologne Bonn Airport
    IataCode{"CGO"}, // Zhengzhou Xinzheng International Airport
    IataCode{"CGP"}, // Shah Amanat International Airport
    IataCode{"CGQ"}, // Dafangshen Airport
    IataCode{"CGR"}, // Campo Grande International Airport
    IataCode{"CGS"}, // College Park Airport
    IataCode{"CGY"}, // Laguindingan International Airport
    IataCode{"CGZ"}, // Casa Grande Municipal Airport
    IataCode{"CHA"}, // Chattanooga Metropolitan Airport
    IataCode{"CHB"}, // Chilas Airport
    IataCode{"CHC"}, // Christchurch International Airport
    IataCode{"CHD"}, // Chandler Municipal Airport
    IataCode{"CHF"}, // Jinhae Airport
    IataCode{"CHG"}, // Chaoyang Airport
    IataCode{"CHH"}, // Chachapoyas Airport
    IataCode{"CHJ"}, // Chipinge Airport
    IataCode{"CHK"}, // Chickasha Municipal Airport
    IataCode{"CHL"}, // Challis Airport
    IataCode{"CHM"}, // Tnte. FAP Jaime Montreuil Morales Airport
    IataCode{"CHN"}, // Jeonju Airport
    IataCode{"CHO"}, // Charlottesville Albemarle Airport
    IataCode{"CHP"}, // Circle Hot Springs Airport
    IataCode{"CHQ"}, // Chania International Airport
    IataCode{"CHR"}, // Châteauroux-Centre "Marcel Dassault" Airport
    IataCode{"CHS"}, // Charleston International Airport
    IataCode{"CHT"}, // Chatham Islands / Tuuta Airport
    IataCode{"CHU"}, // Chuathbaluk Airport
    IataCode{"CHV"}, // Q17508643
    IataCode{"CHX"}, // Changuinola "Capitán Manuel Niño" International Airport
    IataCode{"CHY"}, // Choiseul Bay Airport
    IataCode{"CHZ"}, // Chiloquin State Airport
    IataCode{"CIA"}, // Ciampino–G.B. Pastine International Airport
    IataCode{"CIC"}, // Chico Municipal Airport
    IataCode{"CID"}, // The Eastern Iowa Airport
    IataCode{"CIF"}, // Chifeng Yulong Airport
    IataCode{"CIG"}, // Craig–Moffat Airport
    IataCode{"CIH"}, // Changzhi Wangcun Airport
    IataCode{"CII"}, // Choteau Airport
    IataCode{"CIJ"}, // Captain Aníbal Arab Airport
    IataCode{"CIK"}, // Chalkyitsik Airport
    IataCode{"CIL"}, // Council Airport
    IataCode{"CIM"}, // Cimitarra Airport
    IataCode{"CIN"}, // Arthur N. Neu Airport
    IataCode{"CIO"}, // Teniente Coronel Carmelo Peralta Airport
    IataCode{"CIP"}, // Chipata Airport
    IataCode{"CIQ"}, // Chiquimula Airport
    IataCode{"CIS"}, // Canton Island Airport
    IataCode{"CIT"}, // Shymkent International Airport
    IataCode{"CIU"}, // Chippewa County International Airport
    IataCode{"CIW"}, // Canouan Airport
    IataCode{"CIX"}, // Cap. FAP José A. Quiñones Gonzáles International Airport
    IataCode{"CIY"}, // Comiso Airport
    IataCode{"CIZ"}, // Coari Airport
    IataCode{"CJA"}, // Mayor General FAP Armando Revoredo Iglesias Airport
    IataCode{"CJB"}, // Coimbatore Airport
    IataCode{"CJC"}, // El Loa Airport
    IataCode{"CJF"}, // Coondewanna Airport
    IataCode{"CJH"}, // Chilko Lake (Tsylos Park Lodge) Aerodrome
    IataCode{"CJJ"}, // Cheongju International Airport
    IataCode{"CJL"}, // Chitral Airport
    IataCode{"CJM"}, // Chumphon Airport
    IataCode{"CJN"}, // Nusawiru Airport
    IataCode{"CJR"}, // Culpeper Regional Airport
    IataCode{"CJS"}, // Abraham González International Airport
    IataCode{"CJT"}, // Comitán Airport
    IataCode{"CJU"}, // Jeju International Airport
    IataCode{"CJZ"}, // Cajazeiras Airport
    IataCode{"CKB"}, // North Central West Virginia Airport
    IataCode{"CKC"}, // Cherkasy International Airport
    IataCode{"CKD"}, // Crooked Creek Airport
    IataCode{"CKE"}, // Lampson Field
    IataCode{"CKF"}, // Crisp County-Cordele Airport
    IataCode{"CKG"}, // Chongqing Jiangbei International Airport
    IataCode{"CKH"}, // Chokurdakh Airport
    IataCode{"CKI"}, // Croker Island Airport
    IataCode{"CKL"}, // Chkalovsky Airport
    IataCode{"CKM"}, // Fletcher Field Airport
    IataCode{"CKN"}, // Crookston Municipal Airport
    IataCode{"CKO"}, // Cornélio Procópio Airport
    IataCode{"CKS"}, // Carajás Airport
    IataCode{"CKT"}, // Sarakhs Airport
    IataCode{"CKU"}, // Cordova Municipal Airport
    IataCode{"CKV"}, // Clarksville-Montgomery County Regional Airport
    IataCode{"CKW"}, // Graeme Rowley Aerodrome
    IataCode{"CKX"}, // Chicken Airport
    IataCode{"CKY"}, // Conakry International Airport
    IataCode{"CKZ"}, // Pennridge Airport
    IataCode{"CLA"}, // Comilla Airport
    IataCode{"CLD"}, // McClellan–Palomar Airport
    IataCode{"CLE"}, // Cleveland Hopkins International Airport
    IataCode{"CLG"}, // New Coalinga Municipal Airport
    IataCode{"CLH"}, // Coolah Airport
    IataCode{"CLI"}, // Clintonville Municipal Airport
    IataCode{"CLJ"}, // Cluj International Airport
    IataCode{"CLK"}, // Clinton Regional Airport
    IataCode{"CLL"}, // Easterwood Airport
    IataCode{"CLM"}, // William R. Fairchild International Airport
    IataCode{"CLN"}, // Carolina Airport
    IataCode{"CLO"}, // Alfonso Bonilla Aragón International Airport
    IataCode{"CLP"}, // Clarks Point Airport
    IataCode{"CLQ"}, // Lic. Miguel de la Madrid Airport
    IataCode{"CLR"}, // Cliff Hatfield Memorial Airport
    IataCode{"CLS"}, // Chehalis–Centralia Airport
    IataCode{"CLU"}, // Columbus Municipal Airport
    IataCode{"CLV"}, // Caldas Novas Airport
    IataCode{"CLW"}, // Clearwater Air Park
    IataCode{"CLX"}, // Clorinda Airport
    IataCode{"CLY"}, // Calvi – Sainte-Catherine Airport
    IataCode{"CLZ"}, // Calabozo Airport
    IataCode{"CMA"}, // Cunnamulla Airport
    IataCode{"CMB"}, // Bandaranaike International Airport
    IataCode{"CMD"}, // Cootamundra Airport
    IataCode{"CME"}, // Ciudad del Carmen International Airport
    IataCode{"CMF"}, // Chambéry Airport
    IataCode{"CMG"}, // Corumbá International Airport
    IataCode{"CMH"}, // John Glenn Columbus International Airport
    IataCode{"CMI"}, // University of Illinois Willard Airport
    IataCode{"CMJ"}, // Qimei Airport
    IataCode{"CMK"}, // Club Makokola Airport
    IataCode{"CML"}, // Camooweal Airport
    IataCode{"CMM"}, // Carmelita Airport
    IataCode{"CMN"}, // Mohammed V International Airport
    IataCode{"CMO"}, // Obbia Airport
    IataCode{"CMP"}, // Santana do Araguaia Airport
    IataCode{"CMQ"}, // Clermont Airport
    IataCode{"CMR"}, // Colmar Airport
    IataCode{"CMS"}, // Scusciuban Airport
    IataCode{"CMU"}, // Chimbu Airport
    IataCode{"CMV"}, // Coromandel Aerodrome
    IataCode{"CMW"}, // Ignacio Agramonte International Airport
    IataCode{"CMX"}, // Houghton County Memorial Airport
    IataCode{"CMY"}, // Sparta/Fort McCoy Airport
    IataCode{"CNA"}, // Cananea Airport
    IataCode{"CNB"}, // Coonamble Airport
    IataCode{"CNC"}, // Coconut Island Airport
    IataCode{"CND"}, // Mihail Kogălniceanu International Airport
    IataCode{"CNF"}, // Tancredo Neves International Airport
    IataCode{"CNH"}, // Claremont Municipal Airport
    IataCode{"CNI"}, // Changhai Airport
    IataCode{"CNJ"}, // Cloncurry Airport
    IataCode{"CNK"}, // Blosser Municipal Airport
    IataCode{"CNL"}, // Sindal Airport
    IataCode{"CNM"}, // Cavern City Air Terminal
    IataCode{"CNO"}, // Chino Airport
    IataCode{"CNP"}, // Nerlerit Inaat Airport
    IataCode{"CNQ"}, // Doctor Fernando Piragine Niveyro International Airport
    IataCode{"CNR"}, // Chanaral Airport
    IataCode{"CNS"}, // Cairns Airport
    IataCode{"CNU"}, // Chanute Martin Johnson Airport
    IataCode{"CNW"}, // TSTC Waco Airport
    IataCode{"CNX"}, // Chiang Mai International Airport
    IataCode{"CNY"}, // Canyonlands Field
    IataCode{"CNZ"}, // Cangamba Airport
    IataCode{"COA"}, // Columbia Airport
    IataCode{"COC"}, // Comodoro Pierrestegui Airport
    IataCode{"COD"}, // Yellowstone Regional Airport
    IataCode{"COE"}, // Coeur d'Alene Airport
    IataCode{"COG"}, // Mandinga Airport
    IataCode{"COH"}, // Cooch Behar Airport
    IataCode{"COI"}, // Merritt Island Airport
    IataCode{"COJ"}, // Coonabarabran Airport
    IataCode{"COK"}, // Cochin International Airport
    IataCode{"COL"}, // Coll Airport
    IataCode{"COM"}, // Coleman Municipal Airport
    IataCode{"CON"}, // Concord Municipal Airport
    IataCode{"COO"}, // Cadjehoun Airport
    IataCode{"COP"}, // Cooperstown-Westville Airport
    IataCode{"COQ"}, // Choibalsan Airport
    IataCode{"COR"}, // Ingeniero Aeronáutico Ambrosio L.V. Taravella International Airport
    IataCode{"COS"}, // Colorado Springs Airport
    IataCode{"COT"}, // Cotulla–La Salle County Airport
    IataCode{"COU"}, // Columbia Regional Airport
    IataCode{"COV"}, // Covilhã Airport
    IataCode{"COX"}, // Congo Town Airport
    IataCode{"COY"}, // Coolawanyah Station Airport
    IataCode{"COZ"}, // Constanza Airport
    IataCode{"CPA"}, // Cape Palmas Airport
    IataCode{"CPB"}, // Capurganá Airport
    IataCode{"CPC"}, // Aviador Carlos Campos Airport
    IataCode{"CPD"}, // Coober Pedy Airport
    IataCode{"CPE"}, // Ing. Alberto Acuña Ongay International Airport
    IataCode{"CPF"}, // Ngloram Airport
    IataCode{"CPH"}, // Copenhagen Airport
    IataCode{"CPK"}, // Chesapeake Regional Airport
    IataCode{"CPL"}, // General Navas Pardo Airport
    IataCode{"CPM"}, // Compton/Woodley Airport
    IataCode{"CPO"}, // Desierto de Atacama Airport
    IataCode{"CPQ"}, // Campo dos Amarais Airport
    IataCode{"CPR"}, // Casper–Natrona County International Airport
    IataCode{"CPS"}, // St. Louis Downtown Airport
    IataCode{"CPT"}, // Cape Town International Airport
    IataCode{"CPU"}, // Cururupu Airport
    IataCode{"CPV"}, // Campina Grande Airport
    IataCode{"CPX"}, // Benjamín Rivera Noriega Airport
    IataCode{"CQA"}, // Canarana Airport
    IataCode{"CQB"}, // Chandler Regional Airport
    IataCode{"CQD"}, // Shahrekord Airport
    IataCode{"CQF"}, // Calais–Dunkerque Airport
    IataCode{"CQM"}, // Ciudad Real Central Airport
    IataCode{"CQX"}, // Chatham Municipal Airport
    IataCode{"CRA"}, // Craiova Airport
    IataCode{"CRB"}, // Collarenebri Airport
    IataCode{"CRC"}, // Santa Ana Airport
    IataCode{"CRD"}, // General Enrique Mosconi International Airport
    IataCode{"CRE"}, // Grand Strand Airport
    IataCode{"CRF"}, // Carnot Airport
    IataCode{"CRG"}, // Jacksonville Executive at Craig Airport
    IataCode{"CRI"}, // Colonel Hill Airport
    IataCode{"CRK"}, // Clark International Airport
    IataCode{"CRL"}, // Brussels South Charleroi Airport
    IataCode{"CRM"}, // Catarman National Airport
    IataCode{"CRO"}, // Corcoran Airport
    IataCode{"CRP"}, // Corpus Christi International Airport
    IataCode{"CRQ"}, // Caravelas Airport
    IataCode{"CRR"}, // Ceres Airport
    IataCode{"CRS"}, // C. David Campbell Field
    IataCode{"CRT"}, // Z. M. Jack Stell Field
    IataCode{"CRU"}, // Lauriston Airport
    IataCode{"CRV"}, // Crotone Airport
    IataCode{"CRW"}, // Yeager Airport
    IataCode{"CRX"}, // Roscoe Turner Airport
    IataCode{"CRZ"}, // Turkmenabat Airport
    IataCode{"CSA"}, // Colonsay Airport
    IataCode{"CSB"}, // Caransebeș Airport
    IataCode{"CSC"}, // Codela Airport
    IataCode{"CSG"}, // Columbus Airport
    IataCode{"CSH"}, // Solovki Airport
    IataCode{"CSI"}, // Casino Airport
    IataCode{"CSK"}, // Cap Skirring Airport
    IataCode{"CSL"}, // Cabo San Lucas International Airport
    IataCode{"CSM"}, // Clinton-Sherman Industrial Airpark
    IataCode{"CSN"}, // Carson Airport
    IataCode{"CSO"}, // Magdeburg-Cochstedt Airport
    IataCode{"CSQ"}, // Creston Municipal Airport
    IataCode{"CSS"}, // Cassilândia Airport
    IataCode{"CSU"}, // Santa Cruz do Sul Airport
    IataCode{"CSX"}, // Changsha Huanghua International Airport
    IataCode{"CSY"}, // Cheboksary Airport
    IataCode{"CTA"}, // Catania-Fontanarossa Airport
    IataCode{"CTB"}, // Cut Bank Municipal Airport
    IataCode{"CTC"}, // Coronel Felipe Varela International Airport
    IataCode{"CTD"}, // Chitré Alonso Valderrama Airport
    IataCode{"CTE"}, // Cartí Airport
    IataCode{"CTF"}, // Coatepeque Airport
    IataCode{"CTG"}, // Rafael Núñez International Airport
    IataCode{"CTH"}, // Chester County G. O. Carlson Airport
    IataCode{"CTI"}, // Cuito Cuanavale Airport
    IataCode{"CTJ"}, // West Georgia Regional Airport
    IataCode{"CTK"}, // Ingersoll Airport
    IataCode{"CTL"}, // Charleville Airport
    IataCode{"CTM"}, // Chetumal International Airport
    IataCode{"CTN"}, // Cooktown Airport
    IataCode{"CTO"}, // Calverton Executive Airpark
    IataCode{"CTQ"}, // Santa Vitória do Palmar Airport
    IataCode{"CTS"}, // New Chitose Airport
    IataCode{"CTT"}, // Le Castellet airport
    IataCode{"CTU"}, // Chengdu Shuangliu International Airport
    IataCode{"CTV"}, // Rancho Santa Inés Airstrip
    IataCode{"CTX"}, // Cortland County Airport
    IataCode{"CTY"}, // Cross City Airport
    IataCode{"CTZ"}, // Clinton-Sampson County Airport
    IataCode{"CUA"}, // Ciudad Constitución Airport
    IataCode{"CUB"}, // Jim Hamilton – L.B. Owens Airport
    IataCode{"CUC"}, // Camilo Daza International Airport
    IataCode{"CUD"}, // Caloundra Airport
    IataCode{"CUE"}, // Mariscal Lamar International Airport
    IataCode{"CUF"}, // Cuneo International Airport
    IataCode{"CUH"}, // Cushing Municipal Airport
    IataCode{"CUK"}, // Caye Caulker Airport
    IataCode{"CUL"}, // Federal de Bachigualato International Airport
    IataCode{"CUM"}, // Antonio José de Sucre Airport
    IataCode{"CUN"}, // Cancún International Airport
    IataCode{"CUO"}, // Carurú Airport
    IataCode{"CUP"}, // General José Francisco Bermúdez Airport
    IataCode{"CUQ"}, // Coen Airport
    IataCode{"CUR"}, // Hato International Airport
    IataCode{"CUS"}, // Columbus Municipal Airport
    IataCode{"CUT"}, // Cutral Có Airport
    IataCode{"CUU"}, // General Roberto Fierro Villalobos International Airport
    IataCode{"CUV"}, // El Cubo Airport
    IataCode{"CUY"}, // Cue Airport
    IataCode{"CUZ"}, // Tnte Fap Alejandro Velazco Ast Airport
    IataCode{"CVC"}, // Cleve Airport
    IataCode{"CVE"}, // Coveñas Airport
    IataCode{"CVF"}, // Courchevel Airport
    IataCode{"CVG"}, // Cincinnati/Northern Kentucky International Airport
    IataCode{"CVH"}, // Caviahue Airport
    IataCode{"CVJ"}, // General Mariano Matamoros Airport
    IataCode{"CVK"}, // Sharp County Regional Airport
    IataCode{"CVM"}, // General Pedro J. Méndez International Airport
    IataCode{"CVN"}, // Clovis Municipal Airport
    IataCode{"CVO"}, // Corvallis Municipal Airport
    IataCode{"CVQ"}, // Carnarvon Airport
    IataCode{"CVT"}, // Coventry Airport
    IataCode{"CVU"}, // Corvo Airport
    IataCode{"CVX"}, // Charlevoix Municipal Airport
    IataCode{"CWA"}, // Central Wisconsin Airport
    IataCode{"CWB"}, // Afonso Pena International Airport
    IataCode{"CWC"}, // Chernivtsi International Airport
    IataCode{"CWF"}, // Chennault International Airport
    IataCode{"CWI"}, // Clinton Municipal Airport
    IataCode{"CWJ"}, // Cangyuan Washan Airport
    IataCode{"CWL"}, // Cardiff Airport
    IataCode{"CWS"}, // Center Island Airport
    IataCode{"CWT"}, // Cowra Airport
    IataCode{"CWW"}, // Corowa Airport
    IataCode{"CWX"}, // Cochise County Airport
    IataCode{"CXA"}, // Caicara del Orinoco Airport
    IataCode{"CXB"}, // Cox's Bazar Airport
    IataCode{"CXF"}, // Coldfoot Airport
    IataCode{"CXH"}, // Vancouver Harbour Water Airport
    IataCode{"CXI"}, // Cassidy International Airport
    IataCode{"CXJ"}, // Caxias do Sul Airport
    IataCode{"CXL"}, // Calexico International Airport
    IataCode{"CXM"}, // Camaxilo Airport
    IataCode{"CXN"}, // Candala Airport
    IataCode{"CXO"}, // Lone Star Executive Airport
    IataCode{"CXP"}, // Tunggul Wulung Airport
    IataCode{"CXQ"}, // Christmas Creek Airport
    IataCode{"CXR"}, // Cam Ranh International Airport
    IataCode{"CXT"}, // Charters Towers Airport
    IataCode{"CXW"}, // Conway Airport at Cantrell Field
    IataCode{"CXY"}, // Cat Cay Airport
    IataCode{"CYA"}, // Antoine-Simon Airport
    IataCode{"CYB"}, // Gerrard Smith International Airport
    IataCode{"CYC"}, // Caye Chapel Airport
    IataCode{"CYF"}, // Chefornak Airport
    IataCode{"CYG"}, // Corryong Airport
    IataCode{"CYI"}, // Chiayi Airport
    IataCode{"CYL"}, // Coyoles Airport
    IataCode{"CYM"}, // Chatham Seaplane Base
    IataCode{"CYO"}, // Vilo Acuña Airport
    IataCode{"CYP"}, // Calbayog Airport
    IataCode{"CYR"}, // Colonia Airport
    IataCode{"CYS"}, // Cheyenne Regional Airport
    IataCode{"CYT"}, // Yakataga Airport
    IataCode{"CYU"}, // Cuyo Airport
    IataCode{"CYW"}, // Captain Rogelio Castillo National Airport
    IataCode{"CYX"}, // Chersky Airport
    IataCode{"CYZ"}, // Cauayan Airport
    IataCode{"CZA"}, // Chichen Itza International Airport
    IataCode{"CZC"}, // Copper Center Airport
    IataCode{"CZE"}, // José Leonardo Chirino Airport
    IataCode{"CZF"}, // Cape Romanzof LRRS Airport
    IataCode{"CZG"}, // Tri-Cities Airport (New York)
    IataCode{"CZH"}, // Corozal Airport
    IataCode{"CZJ"}, // Corazón de Jesús Airport
    IataCode{"CZK"}, // Cascade Locks State Airport
    IataCode{"CZL"}, // Mohamed Boudiaf International Airport
    IataCode{"CZM"}, // Cozumel International Airport
    IataCode{"CZN"}, // Chisana Airport
    IataCode{"CZS"}, // Cruzeiro do Sul International Airport
    IataCode{"CZU"}, // Las Brujas Airport
    IataCode{"CZW"}, // Rudniki, EPCH Airport
    IataCode{"CZX"}, // Changzhou Benniu Airport
    IataCode{"DAB"}, // Daytona Beach International Airport
    IataCode{"DAC"}, // Shahjalal International Airport
    IataCode{"DAD"}, // Da Nang International Airport
    IataCode{"DAG"}, // Barstow-Daggett Airport
    IataCode{"DAK"}, // Dakhla Oasis Airport
    IataCode{"DAL"}, // Dallas Love Field
    IataCode{"DAM"}, // Damascus International Airport
    IataCode{"DAN"}, // Danville Regional Airport
    IataCode{"DAR"}, // Julius Nyerere International Airport
    IataCode{"DAS"}, // Great Bear Lake Airport
    IataCode{"DAT"}, // Datong Yungang Airport
    IataCode{"DAU"}, // Daru Airport
    IataCode{"DAV"}, // Enrique Malek International Airport
    IataCode{"DAW"}, // Skyhaven Airport
    IataCode{"DAX"}, // Dazhou Heshi Airport
    IataCode{"DAY"}, // Dayton International Airport
    IataCode{"DAZ"}, // Darwaz Airport
    IataCode{"DBA"}, // Dalbandin Airport
    IataCode{"DBB"}, // El Alamein International Airport
    IataCode{"DBC"}, // Baicheng Chang'an Airport
    IataCode{"DBD"}, // Dhanbad Airport
    IataCode{"DBM"}, // Debre Marqos Airport
    IataCode{"DBN"}, // W. H. 'Bud' Barron Airport
    IataCode{"DBO"}, // Dubbo City Airport
    IataCode{"DBQ"}, // Dubuque Regional Airport
    IataCode{"DBT"}, // Debre Tabor Airport
    IataCode{"DBV"}, // Dubrovnik Airport
    IataCode{"DBY"}, // Dalby Airport
    IataCode{"DCA"}, // Ronald Reagan Washington National Airport
    IataCode{"DCF"}, // Canefield Airport
    IataCode{"DCK"}, // Dahl Creek Airport
    IataCode{"DCM"}, // Castres–Mazamet Airport
    IataCode{"DCR"}, // Decatur Hi-Way Airport
    IataCode{"DCT"}, // Duncan Town Airport
    IataCode{"DCU"}, // Pryor Field Regional Airport
    IataCode{"DCY"}, // Daocheng Yading Airport
    IataCode{"DDC"}, // Dodge City Regional Airport
    IataCode{"DDG"}, // Dandong Langtou Airport
    IataCode{"DDH"}, // William H. Morse State Airport
    IataCode{"DDP"}, // Dorado Airport
    IataCode{"DEA"}, // Dera Ghazi Khan International Airport
    IataCode{"DEB"}, // Debrecen International Airport
    IataCode{"DEC"}, // Decatur Airport
    IataCode{"DED"}, // Jolly Grant Airport
    IataCode{"DEE"}, // Mendeleevo Airport
    IataCode{"DEF"}, // Dezful Airport
    IataCode{"DEH"}, // Decorah Municipal Airport
    IataCode{"DEI"}, // Denis Island Airport
    IataCode{"DEL"}, // Indira Gandhi International Airport
    IataCode{"DEM"}, // Dembidolo Airport
    IataCode{"DEN"}, // Denver International Airport
    IataCode{"DEP"}, // Daporijo Airport
    IataCode{"DEQ"}, // J. Lynn Helms Sevier County Airport
    IataCode{"DES"}, // Desroches Airport
    IataCode{"DET"}, // Coleman A. Young International Airport
    IataCode{"DEW"}, // Deer Park Airport
    IataCode{"DEZ"}, // Deir ez-Zor Airport
    IataCode{"DFI"}, // Defiance Memorial Airport
    IataCode{"DFW"}, // Dallas/Fort Worth International Airport
    IataCode{"DGA"}, // Dangriga Airport
    IataCode{"DGE"}, // Mudgee Airport
    IataCode{"DGF"}, // Douglas Lake Airport
    IataCode{"DGL"}, // Douglas Municipal Airport
    IataCode{"DGO"}, // General Guadalupe Victoria International Airport
    IataCode{"DGP"}, // Daugavpils International Airport
    IataCode{"DGR"}, // Dargaville Aerodrome
    IataCode{"DGT"}, // Sibulan Airport
    IataCode{"DGU"}, // Dedougou Airport
    IataCode{"DGW"}, // Converse County Airport
    IataCode{"DGX"}, // MOD St Athan
    IataCode{"DHA"}, // Dhahran Airfield
    IataCode{"DHI"}, // Dhangadhi Airport
    IataCode{"DHM"}, // Gaggal Airport
    IataCode{"DHN"}, // Sagar Airport
    IataCode{"DHR"}, // De Kooy Airfield
    IataCode{"DHT"}, // Dalhart Municipal Airport
    IataCode{"DIB"}, // Dibrugarh Airport
    IataCode{"DIE"}, // Arrachart Airport
    IataCode{"DIG"}, // Dêqên Shangri-La Airport
    IataCode{"DIJ"}, // Driggs-Reed Memorial Airport
    IataCode{"DIK"}, // Dickinson Theodore Roosevelt Regional Airport
    IataCode{"DIL"}, // Presidente Nicolau Lobato International Airport
    IataCode{"DIM"}, // Dimbokro Airport
    IataCode{"DIN"}, // Dien Bien Phu Airport
    IataCode{"DIP"}, // Diapaga Airport
    IataCode{"DIQ"}, // Divinópolis Airport
    IataCode{"DIR"}, // Aba Tenna Dejazmach Yilma International Airport
    IataCode{"DIS"}, // Dolisie Airport
    IataCode{"DIU"}, // Diu Airport
    IataCode{"DIV"}, // Divo Airport
    IataCode{"DIY"}, // Diyarbakır Airport
    IataCode{"DJA"}, // Djougou Airport
    IataCode{"DJB"}, // Sultan Thaha Airport
    IataCode{"DJE"}, // Djerba–Zarzis International Airport
    IataCode{"DJG"}, // Djanet Inedbirene Airport
    IataCode{"DJJ"}, // Sentani Airport
    IataCode{"DJM"}, // Djambala Airport
    IataCode{"DJN"}, // Delta Junction Airport
    IataCode{"DJO"}, // Daloa Airport
    IataCode{"DJU"}, // Djúpivogur Airport
    IataCode{"DKA"}, // Katsina Airport
    IataCode{"DKI"}, // Dunk Island Airport
    IataCode{"DKK"}, // Chautauqua County/Dunkirk Airport
    IataCode{"DKR"}, // Léopold Sédar Senghor International Airport
    IataCode{"DKS"}, // Dikson Airport
    IataCode{"DKX"}, // Knoxville Downtown Island Airport
    IataCode{"DLA"}, // Douala International Airport
    IataCode{"DLC"}, // Dalian Zhoushuizi International Airport
    IataCode{"DLD"}, // Geilo Airport
    IataCode{"DLE"}, // Dole–Jura Airport
    IataCode{"DLG"}, // Dillingham Airport
    IataCode{"DLH"}, // Duluth International Airport
    IataCode{"DLI"}, // Lien Khuong Airport
    IataCode{"DLL"}, // Dillon County Airport
    IataCode{"DLM"}, // Dalaman Airport
    IataCode{"DLN"}, // Dillon Airport
    IataCode{"DLO"}, // Delano Municipal Airport
    IataCode{"DLS"}, // Columbia Gorge Regional Airport
    IataCode{"DLU"}, // Dali Airport
    IataCode{"DLY"}, // Dillon's Bay Airport
    IataCode{"DLZ"}, // Dalanzadgad Airport
    IataCode{"DMB"}, // Taraz Airport
    IataCode{"DMD"}, // Doomadgee Airport
    IataCode{"DME"}, // Domodedovo International Airport
    IataCode{"DMK"}, // Don Mueang International Airport
    IataCode{"DMM"}, // King Fahd International Airport
    IataCode{"DMN"}, // Deming Municipal Airport
    IataCode{"DMO"}, // Sedalia Regional Airport
    IataCode{"DMT"}, // Diamantino Airport
    IataCode{"DMU"}, // Dimapur Airport
    IataCode{"DMW"}, // Carroll County Regional Airport
    IataCode{"DND"}, // Dundee Airport
    IataCode{"DNH"}, // Dunhuang Airport
    IataCode{"DNI"}, // Wad Medani Airport
    IataCode{"DNK"}, // Dnipropetrovsk International Airport
    IataCode{"DNL"}, // Daniel Field
    IataCode{"DNN"}, // Dalton Municipal Airport
    IataCode{"DNP"}, // Tribhuvannagar Airport
    IataCode{"DNQ"}, // Deniliquin Airport
    IataCode{"DNR"}, // Dinard–Pleurtuit–Saint-Malo Airport
    IataCode{"DNS"}, // Denison Municipal Airport
    IataCode{"DNV"}, // Vermilion Regional Airport
    IataCode{"DNX"}, // Galegu Airport
    IataCode{"DOB"}, // Dobo Airport
    IataCode{"DOD"}, // Dodoma Airport
    IataCode{"DOE"}, // Djoemoe Airstrip
    IataCode{"DOG"}, // Dongola Airport
    IataCode{"DOH"}, // Hamad International Airport
    IataCode{"DOK"}, // Donetsk International Airport
    IataCode{"DOL"}, // Deauville – Saint-Gatien Airport
    IataCode{"DOM"}, // Douglas–Charles Airport
    IataCode{"DON"}, // Dos Lagunas Airport
    IataCode{"DOP"}, // Dolpa Airport
    IataCode{"DOR"}, // Dori Airport
    IataCode{"DOU"}, // Dourados Airport
    IataCode{"DOY"}, // Dongying Shengli Airport
    IataCode{"DPA"}, // DuPage Airport
    IataCode{"DPE"}, // Dieppe - Saint-Aubin Airport
    IataCode{"DPL"}, // Dipolog Airport
    IataCode{"DPO"}, // Devonport Airport
    IataCode{"DPS"}, // Ngurah Rai International Airport
    IataCode{"DPT"}, // Deputatsky Airport
    IataCode{"DQA"}, // Daqing Sartu Airport
    IataCode{"DQH"}, // Alpine Airstrip
    IataCode{"DRA"}, // Desert Rock Airport
    IataCode{"DRB"}, // Derby Airport
    IataCode{"DRC"}, // Dirico Airport
    IataCode{"DRE"}, // Drummond Island Airport
    IataCode{"DRG"}, // Deering Airport
    IataCode{"DRH"}, // Dabra Airport
    IataCode{"DRI"}, // Beauregard Regional Airport
    IataCode{"DRJ"}, // Drietabbetje Airstrip
    IataCode{"DRK"}, // Drake Bay Airport
    IataCode{"DRN"}, // Dirranbandi Airport
    IataCode{"DRO"}, // Durango–La Plata County Airport
    IataCode{"DRS"}, // Dresden Airport
    IataCode{"DRT"}, // Del Rio International Airport
    IataCode{"DRV"}, // Dharavandhoo Airport
    IataCode{"DSA"}, // Doncaster Sheffield Airport
    IataCode{"DSC"}, // Dschang Airport
    IataCode{"DSD"}, // La Désirade Airport
    IataCode{"DSE"}, // Combolcha Airport
    IataCode{"DSI"}, // Destin Executive Airport
    IataCode{"DSK"}, // Dera Ismail Khan Airport
    IataCode{"DSM"}, // Des Moines International Airport
    IataCode{"DSN"}, // Ordos Ejin Horo Airport
    IataCode{"DSO"}, // Sondok Airport
    IataCode{"DSR"}, // Sunrise Dam Airport
    IataCode{"DSS"}, // Blaise Diagne International Airport
    IataCode{"DSV"}, // Dansville Municipal Airport
    IataCode{"DSX"}, // Dongsha Island Airport
    IataCode{"DTA"}, // Delta Municipal Airport
    IataCode{"DTB"}, // Silangit Airport
    IataCode{"DTD"}, // Datadawai Airport
    IataCode{"DTE"}, // Bagasbas Airport
    IataCode{"DTH"}, // Furnace Creek Airport
    IataCode{"DTI"}, // Diamantina Airport
    IataCode{"DTL"}, // Detroit Lakes Airport
    IataCode{"DTM"}, // Dortmund Airport
    IataCode{"DTN"}, // Shreveport Downtown Airport
    IataCode{"DTO"}, // Denton Municipal Airport
    IataCode{"DTW"}, // Detroit Metropolitan Wayne County Airport
    IataCode{"DUA"}, // Durant Regional Airport – Eaker Field
    IataCode{"DUB"}, // Dublin Airport
    IataCode{"DUC"}, // Halliburton Field (airport)
    IataCode{"DUD"}, // Dunedin International Airport
    IataCode{"DUE"}, // Dundo Airport
    IataCode{"DUF"}, // Pine Island Airport
    IataCode{"DUG"}, // Bisbee-Douglas International Airport
    IataCode{"DUH"}, // Toledo Suburban Airport
    IataCode{"DUJ"}, // DuBois Regional Airport
    IataCode{"DUM"}, // Pinang Kampai Airport
    IataCode{"DUQ"}, // Duncan Airport
    IataCode{"DUR"}, // King Shaka International Airport
    IataCode{"DUS"}, // Düsseldorf International Airport
    IataCode{"DUT"}, // Unalaska Airport
    IataCode{"DVD"}, // Andavadoaka Airport
    IataCode{"DVK"}, // Diavik Airport
    IataCode{"DVL"}, // Devils Lake Regional Airport
    IataCode{"DVN"}, // Davenport Municipal Airport
    IataCode{"DVO"}, // Francisco Bangoy International Airport
    IataCode{"DVT"}, // Phoenix Deer Valley Airport
    IataCode{"DWA"}, // Dwangwa Airport
    IataCode{"DWB"}, // Soalala Airport
    IataCode{"DWC"}, // Al Maktoum International Airport
    IataCode{"DWD"}, // Dawadmi Domestic Airport
    IataCode{"DWH"}, // David Wayne Hooks Memorial Airport
    IataCode{"DWS"}, // Walt Disney World Airport
    IataCode{"DWU"}, // Ashland Regional Airport
    IataCode{"DXB"}, // Dubai International Airport
    IataCode{"DXE"}, // Bruce Campbell Field
    IataCode{"DXR"}, // Danbury Municipal Airport
    IataCode{"DYA"}, // Dysart Airport
    IataCode{"DYG"}, // Zhangjiajie Hehua Airport
    IataCode{"DYL"}, // Doylestown Airport
    IataCode{"DYR"}, // Ugolny Airport
    IataCode{"DYT"}, // Sky Harbor Airport & Seaplane Base
    IataCode{"DYU"}, // Dushanbe International Airport
    IataCode{"DZA"}, // Dzaoudzi Pamandzi International Airport
    IataCode{"DZJ"}, // Blairsville Airport
    IataCode{"DZN"}, // Zhezkazgan Airport
    IataCode{"DZO"}, // Santa Bernardina International Airport
    IataCode{"EAA"}, // Eagle Airport
    IataCode{"EAB"}, // Abbs Airport
    IataCode{"EAE"}, // Siwo Airport
    IataCode{"EAL"}, // Elenak Airport
    IataCode{"EAM"}, // Najran Domestic Airport
    IataCode{"EAP"}, // EuroAirport Basel-Mulhouse-Freiburg
    IataCode{"EAR"}, // Kearney Regional Airport
    IataCode{"EAS"}, // San Sebastián Airport
    IataCode{"EAT"}, // Pangborn Memorial Airport
    IataCode{"EAU"}, // Chippewa Valley Regional Airport
    IataCode{"EBA"}, // Marina di Campo Airport
    IataCode{"EBB"}, // Entebbe International Airport
    IataCode{"EBD"}, // El Obeid Airport
    IataCode{"EBG"}, // El Bagre Airport
    IataCode{"EBJ"}, // Esbjerg Airport
    IataCode{"EBL"}, // Erbil International Airport
    IataCode{"EBO"}, // Ebon Airport
    IataCode{"EBS"}, // Webster City Municipal Airport
    IataCode{"EBU"}, // Saint-Étienne – Bouthéon Airport
    IataCode{"EBW"}, // Ebolowa Airport
    IataCode{"ECG"}, // Elizabeth City Regional Airport
    IataCode{"ECH"}, // Echuca Airport
    IataCode{"ECI"}, // Costa Esmeralda Airport
    IataCode{"ECN"}, // Ercan International Airport
    IataCode{"ECP"}, // Northwest Florida Beaches International Airport
    IataCode{"ECR"}, // El Charco Airport
    IataCode{"ECV"}, // Cuatro Vientos Airport
    IataCode{"EDB"}, // El Debba Airport
    IataCode{"EDC"}, // Austin Executive Airport
    IataCode{"EDE"}, // Northeastern Regional Airport
    IataCode{"EDI"}, // Edinburgh Airport
    IataCode{"EDJ"}, // Bellefontaine Regional Airport
    IataCode{"EDK"}, // Captain Jack Thomas/El Dorado Airport
    IataCode{"EDL"}, // Eldoret International Airport
    IataCode{"EDM"}, // La Roche-sur-Yon - Les Ajoncs Airport
    IataCode{"EDO"}, // Balıkesir Koca Seyit Airport
    IataCode{"EDQ"}, // Erandique Airport
    IataCode{"EDR"}, // Edward River Airport
    IataCode{"EDU"}, // University Airport
    IataCode{"EED"}, // Needles Airport
    IataCode{"EEK"}, // Eek Airport
    IataCode{"EEN"}, // Dillant–Hopkins Airport
    IataCode{"EET"}, // Shelby County Airport
    IataCode{"EFD"}, // Ellington International Airport
    IataCode{"EFG"}, // Efogi Airport
    IataCode{"EFK"}, // Newport State Airport (Vermont)
    IataCode{"EFL"}, // Cephalonia International Airport
    IataCode{"EGC"}, // Bergerac Dordogne Périgord Airport
    IataCode{"EGE"}, // Eagle County Regional Airport
    IataCode{"EGH"}, // El Gora Airport
    IataCode{"EGI"}, // Duke Field
    IataCode{"EGL"}, // Neghelle Airport
    IataCode{"EGM"}, // Seghe Airport
    IataCode{"EGN"}, // Geneina Airport
    IataCode{"EGO"}, // Belgorod International Airport
    IataCode{"EGP"}, // Maverick County Memorial International Airport
    IataCode{"EGS"}, // Egilsstaðir Airport
    IataCode{"EGT"}, // Wellington Municipal Airport
    IataCode{"EGV"}, // Eagle River Union Airport
    IataCode{"EGX"}, // Egegik Airport
    IataCode{"EHA"}, // Elkhart–Morton County Airport
    IataCode{"EHL"}, // AeroClub El Bolson
    IataCode{"EHM"}, // Cape Newenham LRRS Airport
    IataCode{"EHO"}, // Shelby-Cleveland County Regional Airport
    IataCode{"EHR"}, // Henderson City-County Airport
    IataCode{"EIB"}, // Eisenach-Kindel Airport
    IataCode{"EIE"}, // Yeniseysk Airport
    IataCode{"EIK"}, // Eisk Airport
    IataCode{"EIN"}, // Eindhoven Airport
    IataCode{"EIS"}, // Terrance B. Lettsome International Airport
    IataCode{"EIY"}, // Ein Yahav Airfield
    IataCode{"EJA"}, // Yariguíes Airport
    IataCode{"EJH"}, // Al Wajh Domestic Airport
    IataCode{"EJN"}, // Ejin Banner Taolai Airport
    IataCode{"EJT"}, // Enejit Airport
    IataCode{"EKA"}, // Murray Field
    IataCode{"EKB"}, // Ekibastuz Airport
    IataCode{"EKI"}, // Elkhart Municipal Airport
    IataCode{"EKO"}, // Elko Regional Airport
    IataCode{"EKQ"}, // Wayne County Airport
    IataCode{"EKS"}, // Big Sky Airport
    IataCode{"EKT"}, // Eskilstuna Airport
    IataCode{"EKX"}, // Elizabethtown Regional Airport
    IataCode{"EKY"}, // Bessemer Airport
    IataCode{"ELB"}, // Las Flores Airport
    IataCode{"ELC"}, // Elcho Island Airport
    IataCode{"ELD"}, // South Arkansas Regional Airport at Goodwin Field
    IataCode{"ELE"}, // El Real Airport
    IataCode{"ELF"}, // El Fasher Airport
    IataCode{"ELG"}, // El Golea Airport
    IataCode{"ELH"}, // North Eleuthera Airport
    IataCode{"ELI"}, // Elim Airport
    IataCode{"ELK"}, // Elk City Regional Business Airport
    IataCode{"ELM"}, // Elmira Corning Regional Airport
    IataCode{"ELN"}, // Bowers Airport
    IataCode{"ELO"}, // El Dorado Airport, Argentina
    IataCode{"ELP"}, // El Paso International Airport
    IataCode{"ELQ"}, // Prince Nayef bin Abdulaziz Regional Airport
    IataCode{"ELS"}, // East London Airport
    IataCode{"ELT"}, // El Tor Airport
    IataCode{"ELU"}, // Guemar Airport
    IataCode{"ELV"}, // Elfin Cove Seaplane Base
    IataCode{"ELX"}, // El Tigre Airport
    IataCode{"ELY"}, // Ely Airport
    IataCode{"ELZ"}, // Wellsville Municipal Airport
    IataCode{"EMA"}, // East Midlands Airport
    IataCode{"EMD"}, // Emerald Airport
    IataCode{"EME"}, // Emden Airport
    IataCode{"EMI"}, // Emirau Airport
    IataCode{"EMK"}, // Emmonak Airport
    IataCode{"EMM"}, // Kemmerer Municipal Airport
    IataCode{"EMN"}, // Néma Airport
    IataCode{"EMP"}, // Emporia Municipal Airport
    IataCode{"EMT"}, // San Gabriel Valley Airport
    IataCode{"EMX"}, // El Maitén Airport
    IataCode{"ENA"}, // Kenai Municipal Airport
    IataCode{"ENC"}, // Nancy-Essey Airport
    IataCode{"ENE"}, // H. Hasan Aroeboesman Airport
    IataCode{"ENF"}, // Enontekiö Airport
    IataCode{"ENH"}, // Enshi Xujiaping Airport
    IataCode{"ENI"}, // El Nido Airport
    IataCode{"ENJ"}, // El Naranjo Airport
    IataCode{"ENK"}, // Enniskillen/St Angelo Airport
    IataCode{"ENL"}, // Centralia Municipal Airport
    IataCode{"ENN"}, // Nenana Municipal Airport
    IataCode{"ENO"}, // Teniente Amin Ayub Gonzalez Airport
    IataCode{"ENS"}, // Enschede Airport Twente
    IataCode{"ENT"}, // Enewetak Auxiliary Airfield
    IataCode{"ENU"}, // Akanu Ibiam International Airport
    IataCode{"ENV"}, // Wendover Airport
    IataCode{"ENW"}, // Kenosha Regional Airport
    IataCode{"ENY"}, // Yan'an Ershilipu Airport
    IataCode{"EOE"}, // Newberry County Airport
    IataCode{"EOH"}, // Enrique Olaya Herrera Airport
    IataCode{"EOI"}, // Eday Airport
    IataCode{"EOK"}, // Keokuk Municipal Airport
    IataCode{"EOP"}, // Pike County Airport
    IataCode{"EOR"}, // El Dorado Airport
    IataCode{"EOS"}, // Neosho Hugh Robinson Airport
    IataCode{"EOZ"}, // Elorza Airport
    IataCode{"EPA"}, // El Palomar Airport
    IataCode{"EPH"}, // Ephrata Municipal Airport
    IataCode{"EPL"}, // Épinal – Mirecourt Airport
    IataCode{"EPM"}, // Eastport Municipal Airport
    IataCode{"EPR"}, // Esperance Airport
    IataCode{"EPS"}, // Arroyo Barril Airport
    IataCode{"EPU"}, // Pärnu Airport
    IataCode{"EQS"}, // Esquel Airport
    IataCode{"EQY"}, // Charlotte-Monroe Executive Airport
    IataCode{"ERA"}, // Erigavo Airport
    IataCode{"ERC"}, // Erzincan Airport
    IataCode{"ERD"}, // Berdyansk Airport
    IataCode{"ERF"}, // Erfurt-Weimar Airport
    IataCode{"ERG"}, // Erbogachen Airport
    IataCode{"ERH"}, // Moulay Ali Cherif Airport
    IataCode{"ERI"}, // Erie International Airport
    IataCode{"ERL"}, // Erenhot Saiwusu International Airport
    IataCode{"ERM"}, // Erechim Airport
    IataCode{"ERN"}, // Eirunepé Airport
    IataCode{"ERQ"}, // Elrose Airport
    IataCode{"ERR"}, // Errol Airport
    IataCode{"ERS"}, // Eros Airport
    IataCode{"ERV"}, // Kerrville Municipal Airport
    IataCode{"ERY"}, // Luce County Airport
    IataCode{"ERZ"}, // Erzurum Airport
    IataCode{"ESB"}, // Esenboğa International Airport
    IataCode{"ESC"}, // Delta County Airport
    IataCode{"ESD"}, // Orcas Island Airport
    IataCode{"ESE"}, // Ensenada Airport
    IataCode{"ESG"}, // Dr. Luis María Argaña International Airport
    IataCode{"ESH"}, // Shoreham Airport
    IataCode{"ESK"}, // Eskişehir Airport
    IataCode{"ESL"}, // Elista Airport
    IataCode{"ESM"}, // Colonel Carlos Concha Torres Airport
    IataCode{"ESN"}, // Easton Airport
    IataCode{"ESO"}, // Ohkay Owingeh Airport
    IataCode{"ESP"}, // Stroudsburg-Pocono Airport
    IataCode{"ESR"}, // Ricardo García Posada Airport
    IataCode{"ESS"}, // Flughafen Essen/Mülheim
    IataCode{"ESU"}, // Mogador Airport
    IataCode{"ESW"}, // Easton State Airport
    IataCode{"ETB"}, // West Bend Municipal Airport
    IataCode{"ETH"}, // Eilat Airport
    IataCode{"ETR"}, // Santa Rosa Airport
    IataCode{"ETS"}, // Enterprise Municipal Airport
    IataCode{"ETZ"}, // Metz-Nancy-Lorraine Airport
    IataCode{"EUA"}, // 'Eua Airport
    IataCode{"EUC"}, // Eucla Airport
    IataCode{"EUE"}, // Eureka Airport
    IataCode{"EUF"}, // Weedon Field
    IataCode{"EUG"}, // Eugene Airport
    IataCode{"EUL"}, // Caldwell Industrial Airport
    IataCode{"EUN"}, // Hassan I Airport
    IataCode{"EUQ"}, // Evelio Javier Airport
    IataCode{"EUX"}, // F.D. Roosevelt Airport
    IataCode{"EVB"}, // New Smyrna Beach Municipal Airport
    IataCode{"EVE"}, // Harstad/Narvik Airport, Evenes
    IataCode{"EVG"}, // Härjedalen Sveg Airport
    IataCode{"EVH"}, // Evans Head Memorial Aerodrome
    IataCode{"EVN"}, // Zvartnots International Airport
    IataCode{"EVU"}, // Northwest Missouri Regional Airport
    IataCode{"EVV"}, // Evansville Regional Airport
    IataCode{"EVY"}, // Summit Airport
    IataCode{"EWB"}, // New Bedford Regional Airport
    IataCode{"EWE"}, // Ewer Airport
    IataCode{"EWI"}, // Enarotali Airport
    IataCode{"EWK"}, // Newton City/County Airport
    IataCode{"EWN"}, // Coastal Carolina Regional Airport
    IataCode{"EWO"}, // Ewo Airport
    IataCode{"EWR"}, // Newark Liberty International Airport
    IataCode{"EXI"}, // Excursion Inlet Seaplane Base
    IataCode{"EXT"}, // Exeter International Airport
    IataCode{"EXX"}, // Davidson County Airport
    IataCode{"EYF"}, // Curtis L. Brown Jr. Field
    IataCode{"EYK"}, // Beloyarsk Airport
    IataCode{"EYL"}, // Yélimané Airport
    IataCode{"EYP"}, // El Alcaraván Airport
    IataCode{"EYQ"}, // Weiser Air Park
    IataCode{"EYR"}, // Yerington Municipal Airport
    IataCode{"EYS"}, // Eliye Springs Airport
    IataCode{"EYW"}, // Key West International Airport
    IataCode{"EZE"}, // Ministro Pistarini International Airport
    IataCode{"EZS"}, // Elazığ Airport
    IataCode{"FAA"}, // Dunsfold Aerodrome
    IataCode{"FAB"}, // Farnborough Airport
    IataCode{"FAC"}, // Faaite Airport
    IataCode{"FAE"}, // Vágar Airport
    IataCode{"FAG"}, // Fagurhólsmýri Airport
    IataCode{"FAH"}, // Farah Airport
    IataCode{"FAI"}, // Fairbanks International Airport
    IataCode{"FAJ"}, // Diego Jiménez Torres Airport
    IataCode{"FAN"}, // Farsund Airport
    IataCode{"FAO"}, // Faro Airport
    IataCode{"FAQ"}, // Frieda River Airport
    IataCode{"FAR"}, // Hector International Airport
    IataCode{"FAS"}, // Fáskrúðsfjörður Airport
    IataCode{"FAT"}, // Fresno Yosemite International Airport
    IataCode{"FAU"}, // Fahud Airport Airport
    IataCode{"FAV"}, // Fakarava Airport
    IataCode{"FAY"}, // Fayetteville Regional Airport
    IataCode{"FAZ"}, // Fasa Airport
    IataCode{"FBA"}, // Fonte Boa Airport
    IataCode{"FBD"}, // Fayzabad Airport
    IataCode{"FBE"}, // Francisco Beltrão Airport
    IataCode{"FBM"}, // Lubumbashi International Airport
    IataCode{"FBS"}, // Friday Harbor Seaplane Base
    IataCode{"FCA"}, // Glacier Park International Airport
    IataCode{"FCB"}, // Ficksburg Sentraoes Airport
    IataCode{"FCH"}, // Fresno Chandler Executive Airport
    IataCode{"FCI"}, // Chesterfield County Airport
    IataCode{"FCM"}, // Flying Cloud Airport
    IataCode{"FCN"}, // Sea-Airport Cuxhaven/Nordholz
    IataCode{"FCO"}, // Leonardo da Vinci–Fiumicino Airport
    IataCode{"FCY"}, // Forrest City Municipal Airport
    IataCode{"FDE"}, // Førde Airport, Øyrane
    IataCode{"FDF"}, // Martinique Aimé Césaire International Airport
    IataCode{"FDH"}, // Friedrichshafen Airport
    IataCode{"FDK"}, // Frederick Municipal Airport
    IataCode{"FDO"}, // San Fernando Airport
    IataCode{"FDR"}, // Frederick Regional Airport
    IataCode{"FDU"}, // Bandundu Airport
    IataCode{"FDW"}, // Fairfield County Airport
    IataCode{"FDY"}, // Findlay Airport
    IataCode{"FEB"}, // Sanfebagar Airport
    IataCode{"FEC"}, // Feira de Santana Airport
    IataCode{"FEG"}, // Fergana International Airport
    IataCode{"FEJ"}, // Feijó Airport
    IataCode{"FEK"}, // Ferkessédougou Airport
    IataCode{"FEN"}, // Fernando de Noronha Airport
    IataCode{"FEP"}, // Albertus Airport
    IataCode{"FET"}, // Fremont Municipal Airport
    IataCode{"FEZ"}, // Fes-Saïss Airport
    IataCode{"FFA"}, // First Flight Airport
    IataCode{"FFC"}, // Atlanta Regional Airport
    IataCode{"FFL"}, // Fairfield Municipal Airport
    IataCode{"FFM"}, // Fergus Falls Municipal Airport
    IataCode{"FFT"}, // Capital City Airport
    IataCode{"FFU"}, // Futaleufu Airport
    IataCode{"FFX"}, // Fremont Municipal Airport
    IataCode{"FGD"}, // Fderik Airport
    IataCode{"FGI"}, // Fagali'i Airport
    IataCode{"FGL"}, // Fox Glacier Heliport
    IataCode{"FGU"}, // Fangatau Airport
    IataCode{"FGX"}, // Fleming-Mason Airport
    IataCode{"FHB"}, // Fernandina Beach Municipal Airport
    IataCode{"FHU"}, // Sierra Vista Municipal Airport
    IataCode{"FID"}, // Elizabeth Field
    IataCode{"FIE"}, // Fair Isle Airport
    IataCode{"FIG"}, // Fria Airport
    IataCode{"FIH"}, // N'djili Airport
    IataCode{"FIL"}, // Fillmore Municipal Airport
    IataCode{"FIN"}, // Finschhafen Airport
    IataCode{"FIT"}, // Fitchburg Municipal Airport
    IataCode{"FIZ"}, // Fitzroy Crossing Airport
    IataCode{"FJR"}, // Fujairah International Airport
    IataCode{"FKA"}, // Fillmore County Airport
    IataCode{"FKB"}, // Baden Airport
    IataCode{"FKI"}, // Bangoka International Airport
    IataCode{"FKJ"}, // Fukui Airport
    IataCode{"FKL"}, // Venango Regional Airport
    IataCode{"FKN"}, // Franklin Municipal-John Beverly Rose Airport
    IataCode{"FKQ"}, // Fakfak Airport
    IataCode{"FKS"}, // Fukushima Airport
    IataCode{"FLA"}, // Gustavo Artunduaga Paredes Airport
    IataCode{"FLB"}, // Floriano Airport
    IataCode{"FLD"}, // Fond du Lac County Airport
    IataCode{"FLF"}, // Schaferhaus Airport
    IataCode{"FLG"}, // Flagstaff Pulliam Airport
    IataCode{"FLL"}, // Fort Lauderdale–Hollywood International Airport
    IataCode{"FLM"}, // Filadelfia Airport
    IataCode{"FLN"}, // Hercílio Luz International Airport
    IataCode{"FLO"}, // Florence Regional Airport
    IataCode{"FLP"}, // Marion County Regional Airport
    IataCode{"FLR"}, // Florence Airport, Peretola
    IataCode{"FLS"}, // Flinders Island Airport
    IataCode{"FLT"}, // Phaeton Airport
    IataCode{"FLU"}, // Flushing Airport
    IataCode{"FLW"}, // Flores Airport
    IataCode{"FLX"}, // Fallon Municipal Airport
    IataCode{"FLY"}, // Meadow Lake Airport
    IataCode{"FMA"}, // Formosa International Airport
    IataCode{"FMC"}, // Five Mile Airport
    IataCode{"FME"}, // Tipton Airport
    IataCode{"FMI"}, // Kalemie Airport
    IataCode{"FMM"}, // Memmingen Airport
    IataCode{"FMN"}, // Four Corners Regional Airport
    IataCode{"FMO"}, // Münster Osnabrück International Airport
    IataCode{"FMU"}, // Florence Municipal Airport
    IataCode{"FMY"}, // Page Field
    IataCode{"FMZ"}, // Fairmont State Airfield
    IataCode{"FNA"}, // Lungi International Airport
    IataCode{"FNB"}, // Neubrandenburg Airport
    IataCode{"FNC"}, // Cristiano Ronaldo Airport
    IataCode{"FNE"}, // Fane Airport
    IataCode{"FNG"}, // Fada N'gourma Airport
    IataCode{"FNH"}, // Fincha Airport
    IataCode{"FNI"}, // Nîmes-Alès-Camargue-Cévennes Airport
    IataCode{"FNJ"}, // Pyongyang Sunan International Airport
    IataCode{"FNL"}, // Fort Collins–Loveland Municipal Airport
    IataCode{"FNR"}, // Funter Bay Seaplane Base
    IataCode{"FNT"}, // Bishop International Airport
    IataCode{"FNU"}, // Oristano-Fenosu Airport
    IataCode{"FOA"}, // Foula Airfield
    IataCode{"FOC"}, // Fuzhou Changle International Airport
    IataCode{"FOD"}, // Fort Dodge Regional Airport
    IataCode{"FOE"}, // Topeka Regional Airport
    IataCode{"FOG"}, // Foggia "Gino Lisa" Airport
    IataCode{"FOK"}, // Francis S. Gabreski Airport
    IataCode{"FOM"}, // Foumban Nkounja Airport
    IataCode{"FON"}, // Arenal Airport
    IataCode{"FOO"}, // Kornasoren Airport
    IataCode{"FOR"}, // Pinto Martins – Fortaleza International Airport
    IataCode{"FOS"}, // Forrest Airport
    IataCode{"FOT"}, // Forster (Wallis Island) Airport
    IataCode{"FOU"}, // Fougamou Airport
    IataCode{"FOY"}, // Foya Airport
    IataCode{"FPK"}, // Fitch H. Beach Airport
    IataCode{"FPO"}, // Grand Bahama International Airport
    IataCode{"FPR"}, // Treasure Coast International Airport
    IataCode{"FPY"}, // Perry-Foley Airport
    IataCode{"FRA"}, // Frankfurt Airport
    IataCode{"FRB"}, // Forbes Airport
    IataCode{"FRC"}, // Franca Airport
    IataCode{"FRD"}, // Friday Harbor Airport
    IataCode{"FRE"}, // Fera Airport
    IataCode{"FRG"}, // Republic Airport
    IataCode{"FRH"}, // French Lick Municipal Airport
    IataCode{"FRJ"}, // Frejus Airport
    IataCode{"FRK"}, // Frégate Island Airport
    IataCode{"FRL"}, // Forlì Airport
    IataCode{"FRM"}, // Fairmont Municipal Airport
    IataCode{"FRO"}, // Florø Airport
    IataCode{"FRR"}, // Front Royal-Warren County Airport
    IataCode{"FRS"}, // Mundo Maya International Airport
    IataCode{"FRT"}, // Frutillar Airport
    IataCode{"FRU"}, // Manas International Airport
    IataCode{"FRW"}, // Francistown Airport
    IataCode{"FRY"}, // Eastern Slopes Regional Airport
    IataCode{"FSC"}, // Figari Sud-Corse Airport
    IataCode{"FSD"}, // Sioux Falls Regional Airport
    IataCode{"FSK"}, // Fort Scott Municipal Airport
    IataCode{"FSM"}, // Fort Smith Regional Airport
    IataCode{"FSO"}, // Franklin County State Airport
    IataCode{"FSP"}, // Saint-Pierre Airport
    IataCode{"FST"}, // Fort Stockton-Pecos County Airport
    IataCode{"FSU"}, // Fort Sumner Municipal Airport
    IataCode{"FSZ"}, // Shizuoka Airport
    IataCode{"FTA"}, // Futuna Airport
    IataCode{"FTE"}, // Comandante Armando Tola International Airport
    IataCode{"FTG"}, // Front Range Airport
    IataCode{"FTI"}, // Fitiuta Airport
    IataCode{"FTU"}, // Tôlanaro Airport
    IataCode{"FTW"}, // Fort Worth Meacham International Airport
    IataCode{"FTX"}, // Owando Airport
    IataCode{"FTY"}, // Fulton County Airport
    IataCode{"FUE"}, // Fuerteventura Airport
    IataCode{"FUG"}, // Fuyang Xiguan Airport
    IataCode{"FUJ"}, // Fukue Airport
    IataCode{"FUK"}, // Fukuoka Airport
    IataCode{"FUL"}, // Fullerton Municipal Airport
    IataCode{"FUN"}, // Funafuti International Airport
    IataCode{"FUO"}, // Foshan Shadi Airport
    IataCode{"FUT"}, // Pointe Vele Airport
    IataCode{"FVM"}, // Fuvahmulah Airport
    IataCode{"FWA"}, // Fort Wayne International Airport
    IataCode{"FWB"}, // Branson West Airport
    IataCode{"FWC"}, // Fairfield Municipal Airport
    IataCode{"FWN"}, // Sussex Airport
    IataCode{"FWQ"}, // Rostraver Airport
    IataCode{"FWS"}, // Fort Worth Spinks Airport
    IataCode{"FXE"}, // Fort Lauderdale Executive Airport
    IataCode{"FXO"}, // Cuamba Airport
    IataCode{"FXY"}, // Forest City Municipal Airport
    IataCode{"FYE"}, // Fayette County Airport
    IataCode{"FYJ"}, // Fuyuan Dongji Airport
    IataCode{"FYM"}, // Fayetteville Municipal Airport
    IataCode{"FYN"}, // Fuyun Koktokay Airport
    IataCode{"FYT"}, // Faya-Largeau Airport
    IataCode{"FYU"}, // Fort Yukon Airport
    IataCode{"FYV"}, // Drake Field
    IataCode{"FZI"}, // Fostoria Metropolitan Airport
    IataCode{"FZO"}, // Bristol Filton Airport
    IataCode{"FZU"}, // Luebo Airport
    IataCode{"FZY"}, // Oswego County Airport
    IataCode{"GAA"}, // Guaymaral Airport
    IataCode{"GAB"}, // Gabbs Airport
    IataCode{"GAC"}, // Celaque Airport
    IataCode{"GAD"}, // Northeast Alabama Regional Airport
    IataCode{"GAE"}, // Gabès – Matmata International Airport
    IataCode{"GAF"}, // Gafsa – Ksar International Airport
    IataCode{"GAG"}, // Gage Airport
    IataCode{"GAH"}, // Gayndah Airport
    IataCode{"GAI"}, // Montgomery County Airpark
    IataCode{"GAJ"}, // Yamagata Airport
    IataCode{"GAL"}, // Edward G. Pitka Sr. Airport
    IataCode{"GAM"}, // Gambell Airport
    IataCode{"GAN"}, // Gan International Airport
    IataCode{"GAO"}, // Mariana Grajales Airport
    IataCode{"GAP"}, // Gusap Airport
    IataCode{"GAQ"}, // Gao International Airport
    IataCode{"GAS"}, // Garissa Airport
    IataCode{"GAT"}, // Gap – Tallard Airport
    IataCode{"GAU"}, // Lokpriya Gopinath Bordoloi International Airport
    IataCode{"GAW"}, // Gawler Aerodrome
    IataCode{"GAX"}, // Gamba Airport
    IataCode{"GAY"}, // Gaya Airport
    IataCode{"GAZ"}, // Guasopa Airport
    IataCode{"GBA"}, // Cotswold Airport
    IataCode{"GBB"}, // Qabala Airport
    IataCode{"GBD"}, // Great Bend Municipal Airport
    IataCode{"GBE"}, // Sir Seretse Khama International Airport
    IataCode{"GBG"}, // Galesburg Municipal Airport
    IataCode{"GBH"}, // Galbraith Lake Airport
    IataCode{"GBI"}, // Grand Bahama Airport
    IataCode{"GBJ"}, // Marie-Galante Airport
    IataCode{"GBK"}, // Gbangbatok Airport
    IataCode{"GBL"}, // South Goulburn Island Airport
    IataCode{"GBM"}, // Garbaharey Airport
    IataCode{"GBR"}, // Walter J. Koladza Airport
    IataCode{"GBT"}, // Gorgan Airport
    IataCode{"GBU"}, // Khashm El Girba Airport
    IataCode{"GBV"}, // Gibb River Airport
    IataCode{"GBZ"}, // Great Barrier Aerodrome
    IataCode{"GCC"}, // Gillette–Campbell County Airport
    IataCode{"GCH"}, // Gachsaran Airport
    IataCode{"GCI"}, // Guernsey Airport
    IataCode{"GCJ"}, // Grand Central Airport
    IataCode{"GCK"}, // Garden City Regional Airport
    IataCode{"GCM"}, // Owen Roberts International Airport
    IataCode{"GCN"}, // Grand Canyon National Park Airport
    IataCode{"GCT"}, // Grand Canyon Bar 10 Airport
    IataCode{"GCW"}, // Grand Canyon West Airport
    IataCode{"GCY"}, // Greeneville-Greene County Municipal Airport
    IataCode{"GDA"}, // Gounda Airport
    IataCode{"GDB"}, // Granite Falls Municipal Airport
    IataCode{"GDC"}, // Donaldson Center Airport
    IataCode{"GDE"}, // Gode Airport
    IataCode{"GDG"}, // Magdagachi Airport
    IataCode{"GDI"}, // Gordil Airport
    IataCode{"GDJ"}, // Gandajika Airport
    IataCode{"GDL"}, // Guadalajara International Airport
    IataCode{"GDM"}, // Gardner Municipal Airport
    IataCode{"GDN"}, // Gdańsk Lech Wałęsa Airport
    IataCode{"GDO"}, // Guasdualito Airport
    IataCode{"GDP"}, // Guadalupe Airport
    IataCode{"GDQ"}, // Gondar Airport
    IataCode{"GDT"}, // JAGS McCartney International Airport
    IataCode{"GDV"}, // Dawson Community Airport
    IataCode{"GDW"}, // Gladwin Zettel Memorial Airport
    IataCode{"GDX"}, // Sokol Airport
    IataCode{"GDY"}, // Grundy Municipal Airport
    IataCode{"GDZ"}, // Gelendzhik Airport
    IataCode{"GEA"}, // Nouméa Magenta Airport
    IataCode{"GED"}, // Delaware Coastal Airport
    IataCode{"GEE"}, // George Town Aerodrome
    IataCode{"GEL"}, // Santo Ângelo Airport
    IataCode{"GEO"}, // Cheddi Jagan International Airport
    IataCode{"GER"}, // Rafael Cabrera Mustelier Airport
    IataCode{"GES"}, // General Santos International Airport
    IataCode{"GET"}, // Geraldton Airport
    IataCode{"GEU"}, // Glendale Municipal Airport
    IataCode{"GEV"}, // Gällivare Airport
    IataCode{"GEX"}, // Geelong Airport
    IataCode{"GEZ"}, // Shelbyville Municipal Airport
    IataCode{"GFD"}, // Pope Field
    IataCode{"GFF"}, // Griffith Airport
    IataCode{"GFK"}, // Grand Forks International Airport
    IataCode{"GFL"}, // Floyd Bennett Memorial Airport
    IataCode{"GFN"}, // Clarence Valley Regional Airport
    IataCode{"GFO"}, // Bartica Airport
    IataCode{"GFR"}, // Granville-Mont-Saint-Michel Airport
    IataCode{"GFY"}, // Grootfontein Airport
    IataCode{"GGC"}, // Lumbala Airport
    IataCode{"GGE"}, // Georgetown County Airport
    IataCode{"GGF"}, // Grant Municipal Airport
    IataCode{"GGG"}, // East Texas Regional Airport
    IataCode{"GGM"}, // Kakamega Airport
    IataCode{"GGN"}, // Gagnoa Airport
    IataCode{"GGO"}, // Guiglo Airport
    IataCode{"GGR"}, // Garowe International Airport
    IataCode{"GGS"}, // Gobernador Gregores Airport
    IataCode{"GGT"}, // Exuma International Airport
    IataCode{"GGW"}, // Glasgow Airport
    IataCode{"GHA"}, // Noumérat – Moufdi Zakaria Airport
    IataCode{"GHB"}, // Governor's Harbour Airport
    IataCode{"GHC"}, // Great Harbour Cay Airport
    IataCode{"GHE"}, // Garachiné Airport
    IataCode{"GHG"}, // Marshfield Municipal Airport
    IataCode{"GHK"}, // Gaza Airstrip
    IataCode{"GHM"}, // Centerville Municipal Airport
    IataCode{"GHN"}, // Kwanghan Airfield
    IataCode{"GHT"}, // Ghat Airport
    IataCode{"GHU"}, // Gualeguaychú Airport
    IataCode{"GIB"}, // Gibraltar International Airport
    IataCode{"GIC"}, // Boigu Island Airport
    IataCode{"GID"}, // Gitega Airport
    IataCode{"GIF"}, // Winter Haven's Gilbert Airport
    IataCode{"GIG"}, // Rio de Janeiro-Galeão International Airport
    IataCode{"GII"}, // Siguiri Airport
    IataCode{"GIL"}, // Gilgit Airport
    IataCode{"GIR"}, // Santiago Vila Airport
    IataCode{"GIS"}, // Gisborne Airport
    IataCode{"GIU"}, // Sigiriya Airport
    IataCode{"GIZ"}, // Jizan Regional Airport
    IataCode{"GJA"}, // Guanaja Airport
    IataCode{"GJL"}, // Jijel Ferhat Abbas Airport
    IataCode{"GJM"}, // Guajará-Mirim Airport
    IataCode{"GJR"}, // Gjögur Airport
    IataCode{"GJT"}, // Grand Junction Regional Airport
    IataCode{"GKA"}, // Goroka Airport
    IataCode{"GKD"}, // Gökçeada Airport
    IataCode{"GKK"}, // Kooddoo Airport
    IataCode{"GKN"}, // Gulkana Airport
    IataCode{"GKT"}, // Gatlinburg-Pigeon Forge Airport
    IataCode{"GKY"}, // Arlington Municipal Airport
    IataCode{"GLA"}, // Glasgow Airport
    IataCode{"GLB"}, // San Carlos Apache Airport
    IataCode{"GLD"}, // Goodland Municipal Airport
    IataCode{"GLE"}, // Gainesville Municipal Airport
    IataCode{"GLF"}, // Golfito Airport
    IataCode{"GLH"}, // Mid Delta Regional Airport
    IataCode{"GLI"}, // Glen Innes Airport
    IataCode{"GLK"}, // Abdullahi Yusuf International Airport
    IataCode{"GLL"}, // Gol Airport
    IataCode{"GLN"}, // Guelmim Airport
    IataCode{"GLO"}, // Gloucestershire Airport
    IataCode{"GLR"}, // Gaylord Regional Airport
    IataCode{"GLS"}, // Scholes International Airport at Galveston
    IataCode{"GLT"}, // Gladstone Airport
    IataCode{"GLU"}, // Gelephu Airport
    IataCode{"GLV"}, // Golovin Airport
    IataCode{"GLW"}, // Glasgow Municipal Airport
    IataCode{"GLX"}, // Garmalamo Airport
    IataCode{"GMA"}, // Gemena Airport
    IataCode{"GMB"}, // Gambela Airport
    IataCode{"GMD"}, // Ben Slimane Airport
    IataCode{"GME"}, // Gomel Airport
    IataCode{"GMI"}, // Gasmata Airport
    IataCode{"GMJ"}, // Grove Municipal Airport
    IataCode{"GML"}, // Gostomel Airport
    IataCode{"GMM"}, // Gamboma Airport
    IataCode{"GMN"}, // Greymouth Airport
    IataCode{"GMO"}, // Gombe Lawanti International Airport
    IataCode{"GMP"}, // Gimpo International Airport
    IataCode{"GMQ"}, // Golog Airport
    IataCode{"GMR"}, // Totegegie Airport
    IataCode{"GMU"}, // Greenville Downtown Airport
    IataCode{"GMZ"}, // La Gomera Airport
    IataCode{"GNA"}, // Hrodna Airport
    IataCode{"GNB"}, // Grenoble-Isère Airport
    IataCode{"GND"}, // Maurice Bishop International Airport
    IataCode{"GNF"}, // Gansner Field
    IataCode{"GNI"}, // Lyudao Airport
    IataCode{"GNK"}, // Zwartberg Airport
    IataCode{"GNM"}, // Guanambi Airport
    IataCode{"GNN"}, // Ghinnir Airport
    IataCode{"GNR"}, // Dr. Arturo Umberto Illia Airport
    IataCode{"GNS"}, // Binaka Airport
    IataCode{"GNT"}, // Grants-Milan Municipal Airport
    IataCode{"GNU"}, // Goodnews Airport
    IataCode{"GNV"}, // Gainesville Regional Airport
    IataCode{"GNY"}, // Şanlıurfa GAP Airport
    IataCode{"GNZ"}, // Ghanzi Airport
    IataCode{"GOA"}, // Genoa Cristoforo Colombo Airport
    IataCode{"GOB"}, // Robe Airport
    IataCode{"GOG"}, // Gobabis Airport
    IataCode{"GOH"}, // Nuuk Airport
    IataCode{"GOI"}, // Dabolim Airport
    IataCode{"GOJ"}, // Nizhny Novgorod International Airport
    IataCode{"GOK"}, // Guthrie–Edmond Regional Airport
    IataCode{"GOL"}, // Gold Beach Municipal Airport
    IataCode{"GOM"}, // Goma International Airport
    IataCode{"GOO"}, // Goondiwindi Airport
    IataCode{"GOP"}, // Gorakhpur Airport
    IataCode{"GOQ"}, // Golmud Airport
    IataCode{"GOR"}, // Gore Airport
    IataCode{"GOT"}, // Gothenburg-Landvetter Airport
    IataCode{"GOU"}, // Garoua International Airport
    IataCode{"GOV"}, // Gove Airport
    IataCode{"GOZ"}, // Gorna Oryahovitsa Airport
    IataCode{"GPA"}, // Araxos Airport
    IataCode{"GPB"}, // Guarapuava Airport
    IataCode{"GPD"}, // Mount Gordon Airport
    IataCode{"GPH"}, // Midwest National Air Center
    IataCode{"GPI"}, // Guapi Airport
    IataCode{"GPL"}, // Guápiles Airport
    IataCode{"GPM"}, // Grand Prairie Municipal Airport
    IataCode{"GPN"}, // Garden Point Airport
    IataCode{"GPO"}, // General Pico Airport
    IataCode{"GPS"}, // Seymour Airport
    IataCode{"GPT"}, // Gulfport-Biloxi International Airport
    IataCode{"GPZ"}, // Grand Rapids – Itasca County Airport
    IataCode{"GQQ"}, // Galion Municipal Airport
    IataCode{"GRB"}, // Green Bay–Austin Straubel International Airport
    IataCode{"GRD"}, // Greenwood County Airport
    IataCode{"GRE"}, // Greenville Airport
    IataCode{"GRG"}, // Gardez Airport
    IataCode{"GRI"}, // Central Nebraska Regional Airport
    IataCode{"GRJ"}, // George Airport
    IataCode{"GRK"}, // Killeen–Fort Hood Regional Airport
    IataCode{"GRM"}, // Grand Marais/Cook County Airport
    IataCode{"GRO"}, // Girona-Costa Brava Airport
    IataCode{"GRP"}, // Gurupi Airport
    IataCode{"GRQ"}, // Groningen Airport Eelde
    IataCode{"GRR"}, // Gerald R. Ford International Airport
    IataCode{"GRS"}, // Grosseto Airport
    IataCode{"GRU"}, // São Paulo-Guarulhos International Airport
    IataCode{"GRV"}, // Grozny Airport
    IataCode{"GRW"}, // Graciosa Airport
    IataCode{"GRX"}, // Federico García Lorca Airport
    IataCode{"GRY"}, // Grímsey Airport
    IataCode{"GRZ"}, // Graz Airport
    IataCode{"GSA"}, // Long Pasia Airport
    IataCode{"GSE"}, // Gothenburg City Airport
    IataCode{"GSH"}, // Goshen Municipal Airport
    IataCode{"GSI"}, // Grand-Santi Airport
    IataCode{"GSJ"}, // San José Airport
    IataCode{"GSL"}, // Taltheilei Narrows Airport
    IataCode{"GSM"}, // Dayrestan Airport
    IataCode{"GSO"}, // Piedmont Triad International Airport
    IataCode{"GSP"}, // Greenville-Spartanburg International Airport
    IataCode{"GSQ"}, // Sharq Al-Owainat Airport
    IataCode{"GSR"}, // Gardo Airport
    IataCode{"GST"}, // Gustavus Airport
    IataCode{"GSU"}, // Gedaref Airport
    IataCode{"GSW"}, // Greater Southwest International Airport
    IataCode{"GTA"}, // Gatokae Aerodrome
    IataCode{"GTB"}, // Genting Airport
    IataCode{"GTE"}, // Groote Eylandt Airport
    IataCode{"GTF"}, // Great Falls International Airport
    IataCode{"GTG"}, // Grantsburg Municipal Airport
    IataCode{"GTN"}, // Mount Cook Aerodrome
    IataCode{"GTO"}, // Jalaluddin Airport
    IataCode{"GTP"}, // Grants Pass Airport
    IataCode{"GTR"}, // Golden Triangle Regional Airport
    IataCode{"GTS"}, // The Granites Airport
    IataCode{"GTT"}, // Georgetown Airport
    IataCode{"GTU"}, // Georgetown Municipal Airport
    IataCode{"GTW"}, // Holesov
    IataCode{"GTY"}, // Gettysburg Regional Airport
    IataCode{"GUA"}, // La Aurora International Airport
    IataCode{"GUB"}, // Guerrero Negro Airport
    IataCode{"GUC"}, // Gunnison–Crested Butte Regional Airport
    IataCode{"GUD"}, // Goundam Airport
    IataCode{"GUF"}, // Jack Edwards Airport
    IataCode{"GUH"}, // Gunnedah Airport
    IataCode{"GUI"}, // Güiria Airport
    IataCode{"GUJ"}, // Guaratinguetá Airport
    IataCode{"GUL"}, // Goulburn Airport
    IataCode{"GUM"}, // Antonio B. Won Pat International Airport
    IataCode{"GUO"}, // Gualaco Airport
    IataCode{"GUP"}, // Gallup Municipal Airport
    IataCode{"GUQ"}, // Guanare Airport
    IataCode{"GUR"}, // Gurney Airport
    IataCode{"GUS"}, // Grissom Aeroplex
    IataCode{"GUU"}, // Grundarfjörður Airport
    IataCode{"GUW"}, // Atyrau Airport
    IataCode{"GUY"}, // Guymon Municipal Airport
    IataCode{"GUZ"}, // Guarapari Airport
    IataCode{"GVA"}, // Geneva International Airport
    IataCode{"GVL"}, // Lee Gilmer Memorial Airport
    IataCode{"GVQ"}, // Genesee County Airport
    IataCode{"GVR"}, // Governador Valadares Airport
    IataCode{"GVT"}, // Majors Airport
    IataCode{"GVW"}, // Richards-Gebaur Memorial Airport
    IataCode{"GVX"}, // Gävle-Sandviken Airport
    IataCode{"GWD"}, // Gwadar International Airport
    IataCode{"GWL"}, // Gwalior Airport
    IataCode{"GWO"}, // Greenwood-Leflore Airport
    IataCode{"GWT"}, // Sylt Airport
    IataCode{"GWW"}, // Wayne Executive Jetport
    IataCode{"GWY"}, // Galway Airport
    IataCode{"GXF"}, // Sayun Airport
    IataCode{"GXG"}, // Negage Airport
    IataCode{"GXH"}, // Gannan Xiahe Airport
    IataCode{"GXQ"}, // Teniente Vidal Airport
    IataCode{"GXX"}, // Yagoua Airport
    IataCode{"GXY"}, // Greeley–Weld County Airport
    IataCode{"GYA"}, // Guayaramerín Airport
    IataCode{"GYB"}, // Giddings-Lee County Airport
    IataCode{"GYD"}, // Heydar Aliyev International Airport
    IataCode{"GYE"}, // José Joaquín de Olmedo International Airport
    IataCode{"GYG"}, // Magan Airport
    IataCode{"GYI"}, // Gisenyi Airport
    IataCode{"GYL"}, // Argyle Airport
    IataCode{"GYM"}, // General José María Yáñez International Airport
    IataCode{"GYN"}, // Santa Genoveva Airport
    IataCode{"GYP"}, // Gympie Airport
    IataCode{"GYR"}, // Phoenix Goodyear Airport
    IataCode{"GYS"}, // Guangyuan Panlong Airport
    IataCode{"GYU"}, // Guyuan Liupanshan Airport
    IataCode{"GYY"}, // Gary/Chicago International Airport
    IataCode{"GZA"}, // Yasser Arafat International Airport
    IataCode{"GZH"}, // Middleton Field
    IataCode{"GZI"}, // Ghazni Airport
    IataCode{"GZL"}, // Stigler Regional Airport
    IataCode{"GZO"}, // Nusatupe Airport
    IataCode{"GZP"}, // Antalya Gazipasa-Alanya Airport
    IataCode{"GZS"}, // Abernathy Field
    IataCode{"GZT"}, // Oğuzeli Airport
    IataCode{"GZW"}, // Qazvin Airport
    IataCode{"HAA"}, // Hasvik Airport
    IataCode{"HAB"}, // Marion County – Rankin Fite Airport
    IataCode{"HAC"}, // Hachijojima Airport
    IataCode{"HAD"}, // Halmstad Airport
    IataCode{"HAE"}, // Haeju Airport
    IataCode{"HAF"}, // Half Moon Bay Airport
    IataCode{"HAH"}, // Prince Said Ibrahim International Airport
    IataCode{"HAJ"}, // Hannover Airport
    IataCode{"HAK"}, // Haikou Meilan International Airport
    IataCode{"HAL"}, // Halali Airport
    IataCode{"HAM"}, // Hamburg Airport
    IataCode{"HAN"}, // Noi Bai International Airport
    IataCode{"HAO"}, // Butler County Regional Airport
    IataCode{"HAQ"}, // Hanimaadhoo Airport
    IataCode{"HAR"}, // Capital City Airport
    IataCode{"HAS"}, // Ha'il Regional Airport
    IataCode{"HAU"}, // Haugesund Airport, Karmøy
    IataCode{"HAV"}, // José Martí International Airport
    IataCode{"HAW"}, // Haverfordwest Aerodrome
    IataCode{"HAX"}, // Hatbox Field
    IataCode{"HAY"}, // Haycock Airport
    IataCode{"HBA"}, // Hobart International Airport
    IataCode{"HBE"}, // Borg El Arab Airport
    IataCode{"HBG"}, // Hattiesburg Bobby L. Chain Municipal Airport
    IataCode{"HBI"}, // Asheboro Regional Airport
    IataCode{"HBK"}, // Holbrook Municipal Airport
    IataCode{"HBR"}, // Hobart Regional Airport
    IataCode{"HBU"}, // Bulgan Airport
    IataCode{"HBX"}, // Hubli Airport
    IataCode{"HCA"}, // Big Spring McMahon-Wrinkle Airport
    IataCode{"HCC"}, // Columbia County Airport
    IataCode{"HCD"}, // Hutchinson Municipal Airport
    IataCode{"HCJ"}, // Hechi Jinchengjiang Airport
    IataCode{"HCM"}, // Eyl Airport
    IataCode{"HCN"}, // Hengchun Airport
    IataCode{"HCQ"}, // Halls Creek Airport
    IataCode{"HCR"}, // Holy Cross Airport
    IataCode{"HCW"}, // Cheraw Municipal Airport
    IataCode{"HDA"}, // Ein Shemer Airfield
    IataCode{"HDC"}, // Hammond Northshore Regional Airport
    IataCode{"HDD"}, // Hyderabad Airport
    IataCode{"HDF"}, // Heringsdorf Airport
    IataCode{"HDG"}, // Handan Airport
    IataCode{"HDI"}, // Hardwick Field
    IataCode{"HDM"}, // Hamadan Airport
    IataCode{"HDN"}, // Yampa Valley Airport
    IataCode{"HDO"}, // South Texas Regional Airport at Hondo
    IataCode{"HDY"}, // Hat Yai International Airport
    IataCode{"HEA"}, // Herat International Airport
    IataCode{"HEE"}, // Thompson-Robbins Airport
    IataCode{"HEG"}, // Herlong Recreational Airport
    IataCode{"HEH"}, // Heho Airport
    IataCode{"HEI"}, // Hettinger Municipal Airport
    IataCode{"HEK"}, // Heihe Aihui Airport
    IataCode{"HEL"}, // Helsinki Airport
    IataCode{"HEN"}, // Hernesaari Heliport
    IataCode{"HEO"}, // Haelogo Airport
    IataCode{"HER"}, // Heraklion International Airport
    IataCode{"HES"}, // Hermiston Municipal Airport
    IataCode{"HET"}, // Hohhot Baita International Airport
    IataCode{"HEW"}, // Hellinikon Airport
    IataCode{"HEX"}, // Herrera International Airport
    IataCode{"HEZ"}, // Natchez-Adams County Airport
    IataCode{"HFA"}, // Haifa International Airport
    IataCode{"HFD"}, // Hartford-Brainard Airport
    IataCode{"HFE"}, // Hefei Xinqiao International Airport
    IataCode{"HFF"}, // Camp Mackall
    IataCode{"HFN"}, // Hornafjörður Airport
    IataCode{"HFS"}, // Hagfors Airport
    IataCode{"HFT"}, // Hammerfest Airport
    IataCode{"HGA"}, // Hargeisa International Airport
    IataCode{"HGD"}, // Hughenden Airport
    IataCode{"HGE"}, // Higuerote Airport
    IataCode{"HGH"}, // Hangzhou Xiaoshan International Airport
    IataCode{"HGI"}, // Paloich Airport
    IataCode{"HGL"}, // Heligoland Airport
    IataCode{"HGN"}, // Mae Hong Son Airport
    IataCode{"HGO"}, // Korhogo Airport
    IataCode{"HGR"}, // Hagerstown Regional Airport
    IataCode{"HGS"}, // Hastings Airport
    IataCode{"HGU"}, // Mount Hagen Airport
    IataCode{"HHH"}, // Hilton Head Airport
    IataCode{"HHN"}, // Frankfurt-Hahn Airport
    IataCode{"HHQ"}, // Hua Hin Airport
    IataCode{"HHR"}, // Hawthorne Municipal Airport
    IataCode{"HHZ"}, // Hikueru Airport
    IataCode{"HIA"}, // Huai'an Lianshui Airport
    IataCode{"HIB"}, // Range Regional Airport
    IataCode{"HID"}, // Horn Island Airport
    IataCode{"HIE"}, // Mount Washington Regional Airport
    IataCode{"HII"}, // Lake Havasu City Airport
    IataCode{"HIJ"}, // Hiroshima Airport
    IataCode{"HIL"}, // Shilavo Airport
    IataCode{"HIN"}, // Sacheon Airport
    IataCode{"HIO"}, // Hillsboro Airport
    IataCode{"HIR"}, // Honiara International Airport
    IataCode{"HIW"}, // Hiroshima-Nishi Airport
    IataCode{"HJJ"}, // Huaihua Zhijiang Airport
    IataCode{"HJO"}, // Hanford Municipal Airport
    IataCode{"HJR"}, // Khajuraho Airport
    IataCode{"HJT"}, // Khujirt Airport
    IataCode{"HKA"}, // Blytheville Municipal Airport
    IataCode{"HKB"}, // Healy Lake Airport
    IataCode{"HKD"}, // Hakodate Airport
    IataCode{"HKG"}, // Hong Kong International Airport
    IataCode{"HKK"}, // Hokitika Airport
    IataCode{"HKN"}, // Hoskins Airport
    IataCode{"HKO"}, // Rhamu Airport
    IataCode{"HKP"}, // Kaanapali Airport
    IataCode{"HKS"}, // Hawkins Field
    IataCode{"HKT"}, // Phuket International Airport
    IataCode{"HKY"}, // Hickory Regional Airport
    IataCode{"HLA"}, // Lanseria International Airport
    IataCode{"HLC"}, // Hill City Municipal Airport
    IataCode{"HLD"}, // Hulunbuir Hailar Airport
    IataCode{"HLE"}, // Saint Helena Airport
    IataCode{"HLF"}, // Hultsfred Airport
    IataCode{"HLG"}, // Wheeling Ohio County Airport
    IataCode{"HLH"}, // Ulanhot Airport
    IataCode{"HLI"}, // Hollister Municipal Airport
    IataCode{"HLJ"}, // Barysiai Airport
    IataCode{"HLM"}, // Park Township Airport
    IataCode{"HLN"}, // Helena Regional Airport
    IataCode{"HLP"}, // Halim Perdanakusuma Airport
    IataCode{"HLS"}, // St Helens Airport
    IataCode{"HLT"}, // Hamilton Airport
    IataCode{"HLW"}, // Hluhluwe Airport
    IataCode{"HLZ"}, // Hamilton International Airport
    IataCode{"HMA"}, // Khanty-Mansiysk Airport
    IataCode{"HMB"}, // Sohag International Airport
    IataCode{"HME"}, // Oued Irara–Krim Belkacem Airport
    IataCode{"HMI"}, // Hami Airport
    IataCode{"HMJ"}, // Khmelnytskyi Airport
    IataCode{"HMO"}, // General Ignacio Pesqueira García International Airport
    IataCode{"HMR"}, // Hamar Airport
    IataCode{"HMT"}, // Hemet-Ryan Airport
    IataCode{"HNA"}, // Hanamaki Airport
    IataCode{"HNB"}, // Huntingburg Airport
    IataCode{"HNC"}, // Billy Mitchell Airport
    IataCode{"HND"}, // Tokyo International Airport
    IataCode{"HNH"}, // Hoonah Airport
    IataCode{"HNL"}, // Honolulu International Airport
    IataCode{"HNM"}, // Hana Airport
    IataCode{"HNS"}, // Haines Airport
    IataCode{"HNY"}, // Hengyang Nanyue Airport
    IataCode{"HNZ"}, // Henderson-Oxford Airport
    IataCode{"HOA"}, // Hola Airport
    IataCode{"HOB"}, // Lea County Regional Airport
    IataCode{"HOD"}, // Hodeida International Airport
    IataCode{"HOE"}, // Ban Huoeisay Airport
    IataCode{"HOF"}, // Al-Ahsa Domestic Airport
    IataCode{"HOG"}, // Frank País Airport
    IataCode{"HOH"}, // Hohenems-Dornbirn Airport
    IataCode{"HOI"}, // Hao Airport
    IataCode{"HOK"}, // Hooker Creek Airport
    IataCode{"HOM"}, // Homer Airport
    IataCode{"HON"}, // Huron Regional Airport
    IataCode{"HOO"}, // Quang Tri Airport
    IataCode{"HOR"}, // Horta Airport
    IataCode{"HOS"}, // Chos Malal Airport
    IataCode{"HOT"}, // Memorial Field Airport
    IataCode{"HOU"}, // William P. Hobby Airport
    IataCode{"HOV"}, // Ørsta-Volda Airport
    IataCode{"HPA"}, // Lifuka Island Airport
    IataCode{"HPB"}, // Hooper Bay Airport
    IataCode{"HPG"}, // Shennongjia Airport
    IataCode{"HPH"}, // Cat Bi International Airport
    IataCode{"HPN"}, // Westchester County Airport
    IataCode{"HPV"}, // Princeville Airport
    IataCode{"HPX"}, // Água Boa Airport
    IataCode{"HPY"}, // Baytown Airport
    IataCode{"HQG"}, // Hugoton Municipal Airport
    IataCode{"HQM"}, // Bowerman Airport
    IataCode{"HQZ"}, // Mesquite Metro Airport
    IataCode{"HRB"}, // Harbin Taiping International Airport
    IataCode{"HRE"}, // Harare International Airport
    IataCode{"HRG"}, // Hurghada International Airport
    IataCode{"HRI"}, // Mattala Rajapaksa International Airport
    IataCode{"HRJ"}, // Chaurjhari Airport
    IataCode{"HRK"}, // Kharkiv International Airport
    IataCode{"HRL"}, // Valley International Airport
    IataCode{"HRM"}, // Hassi R'Mel Airport
    IataCode{"HRO"}, // Boone County Airport
    IataCode{"HRS"}, // Harrismith Airport
    IataCode{"HRU"}, // Herington Regional Airport
    IataCode{"HRZ"}, // Herzliya Airport
    IataCode{"HSA"}, // Stennis International Airport
    IataCode{"HSC"}, // Shaoguan Guitou Airport
    IataCode{"HSD"}, // Sundance Airpark
    IataCode{"HSG"}, // Saga Airport
    IataCode{"HSH"}, // Henderson Executive Airport
    IataCode{"HSI"}, // Hastings Municipal Airport
    IataCode{"HSK"}, // Huesca-Pirineos Airport
    IataCode{"HSL"}, // Huslia Airport
    IataCode{"HSM"}, // Horsham Airport
    IataCode{"HSN"}, // Zhoushan Putuoshan Airport
    IataCode{"HSR"}, // Hot Springs Municipal Airport
    IataCode{"HSS"}, // Hisar Airport
    IataCode{"HSV"}, // Huntsville International Airport
    IataCode{"HTA"}, // Kadala Airport
    IataCode{"HTF"}, // Hatfield Aerodrome
    IataCode{"HTG"}, // Khatanga Airport
    IataCode{"HTH"}, // Hawthorne Industrial Airport
    IataCode{"HTI"}, // Great Barrier Reef Airport
    IataCode{"HTL"}, // Roscommon County – Blodgett Memorial Airport
    IataCode{"HTM"}, // Khatgal Airport
    IataCode{"HTN"}, // Hotan Airport
    IataCode{"HTO"}, // East Hampton Airport
    IataCode{"HTR"}, // Hateruma Airport
    IataCode{"HTS"}, // Tri-State Airport
    IataCode{"HTT"}, // Huatugou Airport
    IataCode{"HTU"}, // Hopetoun Airport
    IataCode{"HTV"}, // Huntsville Regional Airport
    IataCode{"HTW"}, // Lawrence County Airpark
    IataCode{"HTY"}, // Hatay Airport
    IataCode{"HTZ"}, // Hato Corozal Airport
    IataCode{"HUB"}, // Humbert River Airport
    IataCode{"HUC"}, // Humacao Airport
    IataCode{"HUD"}, // Humboldt Municipal Airport
    IataCode{"HUE"}, // Humera Airport
    IataCode{"HUF"}, // Terre Haute International Airport
    IataCode{"HUG"}, // Huehuetenango Airport
    IataCode{"HUH"}, // Huahine – Fare Airport
    IataCode{"HUI"}, // Phu Bai International Airport
    IataCode{"HUJ"}, // Stan Stamper Municipal Airport
    IataCode{"HUK"}, // Hukuntsi Airport
    IataCode{"HUL"}, // Houlton International Airport
    IataCode{"HUM"}, // Houma-Terrebonne Airport
    IataCode{"HUN"}, // Hualien Airport
    IataCode{"HUQ"}, // Waddan Airport
    IataCode{"HUS"}, // Hughes Airport
    IataCode{"HUT"}, // Hutchinson Municipal Airport
    IataCode{"HUU"}, // Alférez FAP David Figueroa Fernandini Airport
    IataCode{"HUV"}, // Hudiksvall Airport
    IataCode{"HUW"}, // Humaitá Airport
    IataCode{"HUX"}, // Bahías de Huatulco International Airport
    IataCode{"HUY"}, // Humberside Airport
    IataCode{"HUZ"}, // Huizhou Airport
    IataCode{"HVA"}, // Analalava Airport
    IataCode{"HVB"}, // Hervey Bay Airport
    IataCode{"HVC"}, // Hopkinsville-Christian County Airport
    IataCode{"HVD"}, // Khovd Airport
    IataCode{"HVG"}, // Honningsvåg Airport, Valan
    IataCode{"HVK"}, // Hólmavík Airport
    IataCode{"HVN"}, // Tweed-New Haven Regional Airport
    IataCode{"HVR"}, // Havre City-County Airport
    IataCode{"HVS"}, // Hartsville Regional Airport
    IataCode{"HWM"}, // Kowanyama Airport
    IataCode{"HWN"}, // Hwange National Park Airport
    IataCode{"HWO"}, // North Perry Airport
    IataCode{"HWQ"}, // Wheatland County Airport
    IataCode{"HWY"}, // Warrenton-Fauquier Airport
    IataCode{"HXD"}, // Delingha Airport
    IataCode{"HXX"}, // Hay Airport
    IataCode{"HYA"}, // Barnstable Municipal Airport
    IataCode{"HYC"}, // Wycombe Air Park
    IataCode{"HYD"}, // Rajiv Gandhi International Airport
    IataCode{"HYG"}, // Hydaburg Seaplane Base
    IataCode{"HYI"}, // San Marcos Municipal Airport
    IataCode{"HYL"}, // Hollis Seaplane Base
    IataCode{"HYN"}, // Taizhou Luqiao Airport
    IataCode{"HYR"}, // Sawyer County Airport
    IataCode{"HYS"}, // Hays Regional Airport
    IataCode{"HYW"}, // Conway-Horry County Airport
    IataCode{"HYX"}, // Saginaw County H.W. Browne Airport
    IataCode{"HZB"}, // Merville – Calonne Airport
    IataCode{"HZD"}, // Carroll County Airport
    IataCode{"HZE"}, // Mercer County Regional Airport
    IataCode{"HZG"}, // Hanzhong Chenggu Airport
    IataCode{"HZH"}, // Liping Airport
    IataCode{"HZK"}, // Húsavík Airport
    IataCode{"HZL"}, // Hazleton Municipal Airport
    IataCode{"HZP"}, // Fort MacKay/Horizon Airport
    IataCode{"HZR"}, // False River Regional Airport
    IataCode{"IAA"}, // Igarka Airport
    IataCode{"IAD"}, // Washington Dulles International Airport
    IataCode{"IAG"}, // Niagara Falls International Airport
    IataCode{"IAH"}, // George Bush Intercontinental Airport
    IataCode{"IAM"}, // In Aménas Airport
    IataCode{"IAN"}, // Bob Baker Memorial Airport
    IataCode{"IAO"}, // Sayak Airport
    IataCode{"IAQ"}, // Bastak Airport
    IataCode{"IAR"}, // Tunoshna Airport
    IataCode{"IAS"}, // Iași International Airport
    IataCode{"IBA"}, // Ibadan Airport
    IataCode{"IBE"}, // Perales Airport
    IataCode{"IBL"}, // Indigo Bay Lodge Airport
    IataCode{"IBP"}, // Iberia Airport
    IataCode{"IBZ"}, // Ibiza Airport
    IataCode{"ICA"}, // Icabarú Airport
    IataCode{"ICC"}, // Andrés Miguel Salazar Marcano Airport
    IataCode{"ICI"}, // Cicia Airport
    IataCode{"ICK"}, // Majoor Henry Fernandes Airport
    IataCode{"ICN"}, // Incheon International Airport
    IataCode{"ICR"}, // Nicaro Airport
    IataCode{"ICT"}, // Wichita Dwight D. Eisenhower National Airport
    IataCode{"ICY"}, // Icy Bay Airport
    IataCode{"IDA"}, // Idaho Falls Regional Airport
    IataCode{"IDF"}, // Idiofa Airport
    IataCode{"IDH"}, // Idaho County Airport
    IataCode{"IDI"}, // Indiana County-Jimmy Stewart Airport
    IataCode{"IDL"}, // Indianola Municipal Airport
    IataCode{"IDP"}, // Independence Municipal Airport
    IataCode{"IDR"}, // Devi Ahilyabai Holkar Airport
    IataCode{"IDY"}, // Île d'Yeu Aerodrome
    IataCode{"IEG"}, // Zielona Góra Airport
    IataCode{"IEJ"}, // Iejima Airport
    IataCode{"IER"}, // Natchitoches Regional Airport
    IataCode{"IES"}, // Riesa-Göhlis Aerodrome
    IataCode{"IEV"}, // Kyiv Zhuliany International Airport
    IataCode{"IFJ"}, // Ísafjörður Airport
    IataCode{"IFL"}, // Innisfail Airport
    IataCode{"IFN"}, // Isfahan International Airport
    IataCode{"IFO"}, // Ivano-Frankivsk International Airport
    IataCode{"IFP"}, // Laughlin/Bullhead International Airport
    IataCode{"IGA"}, // Inagua Airport
    IataCode{"IGB"}, // Ingeniero Jacobacci Airport
    IataCode{"IGD"}, // Iğdır Airport
    IataCode{"IGE"}, // Tchongorove Airport
    IataCode{"IGG"}, // Igiugig Airport
    IataCode{"IGH"}, // Ingham Airport
    IataCode{"IGM"}, // Kingman Airport
    IataCode{"IGN"}, // Maria Cristina Airport
    IataCode{"IGO"}, // Jaime Ortíz Betancur Airport
    IataCode{"IGQ"}, // Lansing Municipal Airport
    IataCode{"IGR"}, // Cataratas del Iguazú International Airport
    IataCode{"IGS"}, // Ingolstadt Manching Airport
    IataCode{"IGT"}, // Magas Airport
    IataCode{"IGU"}, // Foz do Iguaçu International Airport
    IataCode{"IGX"}, // Horace Williams Airport
    IataCode{"IHC"}, // Inhaca Airport
    IataCode{"IHO"}, // Ihosy Airport
    IataCode{"IHR"}, // Iranshahr Airport
    IataCode{"IHU"}, // Ihu Airport
    IataCode{"IIA"}, // Inishmaan Aerodrome
    IataCode{"IIB"}, // Independence Municipal Airport
    IataCode{"IIL"}, // Ilam Airport
    IataCode{"IIS"}, // Nissan Island Airport
    IataCode{"IJD"}, // Windham Airport
    IataCode{"IJK"}, // Izhevsk Airport
    IataCode{"IJU"}, // Ijuí Airport
    IataCode{"IKA"}, // Tehran Imam Khomeini International Airport
    IataCode{"IKB"}, // Wilkes County Airport
    IataCode{"IKG"}, // Kleberg County Airport
    IataCode{"IKI"}, // Iki Airport
    IataCode{"IKK"}, // Greater Kankakee Airport
    IataCode{"IKL"}, // Ikela Airport
    IataCode{"IKS"}, // Tiksi Airport
    IataCode{"IKT"}, // International Airport Irkutsk
    IataCode{"IKU"}, // Tamchy Airport
    IataCode{"IKV"}, // Ankeny Regional Airport
    IataCode{"IKW"}, // Jack Barstow Municipal Airport
    IataCode{"ILB"}, // Solteira Island Airport
    IataCode{"ILD"}, // Lleida-Alguaire Airport
    IataCode{"ILE"}, // Skylark Field
    IataCode{"ILF"}, // Ilford Airport
    IataCode{"ILG"}, // New Castle Airport
    IataCode{"ILI"}, // Iliamna Airport
    IataCode{"ILK"}, // Atsinanana Airport
    IataCode{"ILL"}, // Willmar Municipal Airport
    IataCode{"ILM"}, // Wilmington International Airport
    IataCode{"ILN"}, // Airborne Airpark
    IataCode{"ILO"}, // Iloilo International Airport
    IataCode{"ILP"}, // Île des Pins Airport
    IataCode{"ILQ"}, // Ilo Airport
    IataCode{"ILR"}, // Ilorin International Airport
    IataCode{"ILS"}, // Ilopango International Airport
    IataCode{"ILU"}, // Kilaguni Airport
    IataCode{"ILY"}, // Islay Airport
    IataCode{"ILZ"}, // Žilina Airport
    IataCode{"IMB"}, // Imbaimadai Airport
    IataCode{"IMI"}, // Ine Airport
    IataCode{"IMK"}, // Simikot Airport
    IataCode{"IMM"}, // Immokalee Airport
    IataCode{"IMO"}, // Zemio Airport
    IataCode{"IMP"}, // Imperatriz Airport
    IataCode{"IMT"}, // Ford Airport
    IataCode{"INA"}, // Inta Airport
    IataCode{"INB"}, // Independence Airport (Belize)
    IataCode{"INC"}, // Yinchuan Hedong International Airport
    IataCode{"IND"}, // Indianapolis International Airport
    IataCode{"INF"}, // In Guezzam Airport
    IataCode{"ING"}, // Lago Argentino Airport
    IataCode{"INH"}, // Inhambane Airport
    IataCode{"INI"}, // Niš Constantine the Great Airport
    IataCode{"INJ"}, // Hillsboro Municipal Airport
    IataCode{"INK"}, // Winkler County Airport
    IataCode{"INL"}, // Falls International Airport
    IataCode{"INN"}, // Innsbruck Airport
    IataCode{"INO"}, // Inongo Airport
    IataCode{"INQ"}, // Inisheer Aerodrome
    IataCode{"INT"}, // Smith Reynolds Airport
    IataCode{"INU"}, // Nauru International Airport
    IataCode{"INV"}, // Inverness Airport
    IataCode{"INW"}, // Winslow-Lindbergh Regional Airport
    IataCode{"INZ"}, // In Salah Airport
    IataCode{"IOA"}, // Ioannina National Airport
    IataCode{"IOM"}, // Isle of Man Airport
    IataCode{"ION"}, // Impfondo Airport
    IataCode{"IOR"}, // Inishmore Aerodrome
    IataCode{"IOS"}, // Ilhéus Jorge Amado Airport
    IataCode{"IOW"}, // Iowa City Municipal Airport
    IataCode{"IPA"}, // Ipota Airport
    IataCode{"IPC"}, // Mataveri International Airport
    IataCode{"IPE"}, // Ipil Airport
    IataCode{"IPG"}, // Ipiranga Airport
    IataCode{"IPH"}, // Sultan Azlan Shah Airport
    IataCode{"IPI"}, // San Luis Airport
    IataCode{"IPJ"}, // Lincolnton-Lincoln County Regional Airport
    IataCode{"IPL"}, // Imperial County Airport
    IataCode{"IPN"}, // Usiminas Airport
    IataCode{"IPT"}, // Williamsport Regional Airport
    IataCode{"IQN"}, // Qingyang Airport
    IataCode{"IQQ"}, // Diego Aracena International Airport
    IataCode{"IQT"}, // Crnl. FAP Francisco Secada Vignetta International Airport
    IataCode{"IRA"}, // Kirakira Airport
    IataCode{"IRC"}, // Circle City Airport
    IataCode{"IRD"}, // Ishurdi Airport
    IataCode{"IRG"}, // Lockhart River Airport
    IataCode{"IRI"}, // Iringa Airport
    IataCode{"IRJ"}, // Capitán Vicente Almandos Almonacid Airport
    IataCode{"IRK"}, // Kirksville Regional Airport
    IataCode{"IRO"}, // Birao Airport
    IataCode{"IRP"}, // Matari Airport
    IataCode{"IRZ"}, // Tapuruquara Airport
    IataCode{"ISA"}, // Mount Isa Airport
    IataCode{"ISB"}, // Benazir Bhutto International Airport
    IataCode{"ISC"}, // St Mary's Airport
    IataCode{"ISE"}, // Isparta Süleyman Demirel Airport
    IataCode{"ISG"}, // New Ishigaki Airport
    IataCode{"ISI"}, // Isisford Airport
    IataCode{"ISJ"}, // Isla Mujeres Airport
    IataCode{"ISK"}, // Ozar Airport
    IataCode{"ISM"}, // Kissimmee Gateway Airport
    IataCode{"ISN"}, // Sloulin Field International Airport
    IataCode{"ISO"}, // Kinston Regional Jetport
    IataCode{"ISP"}, // Long Island MacArthur Airport
    IataCode{"ISQ"}, // Schoolcraft County Airport
    IataCode{"ISS"}, // Wiscasset Airport
    IataCode{"IST"}, // Atatürk International Airport
    IataCode{"ISU"}, // Sulaimaniyah International Airport
    IataCode{"ISW"}, // South Wood County Airport
    IataCode{"ISZ"}, // Cincinnati-Blue Ash Airport
    IataCode{"ITA"}, // Itacoatiara Airport
    IataCode{"ITB"}, // Itaituba Airport
    IataCode{"ITH"}, // Ithaca Tompkins Regional Airport
    IataCode{"ITM"}, // Osaka International Airport
    IataCode{"ITO"}, // Hilo International Airport
    IataCode{"ITP"}, // Itaperuna Airport
    IataCode{"ITQ"}, // Itaqui Airport
    IataCode{"ITR"}, // Itumbiara Airport
    IataCode{"ITU"}, // Iturup Airport
    IataCode{"IUE"}, // Niue International Airport
    IataCode{"IUS"}, // Inus Airport
    IataCode{"IVA"}, // Ampampamena Airport
    IataCode{"IVC"}, // Invercargill Airport
    IataCode{"IVG"}, // Dolac Airport
    IataCode{"IVL"}, // Ivalo Airport
    IataCode{"IVR"}, // Inverell Airport
    IataCode{"IWA"}, // Ivanovo Yuzhny Airport
    IataCode{"IWD"}, // Gogebic-Iron County Airport
    IataCode{"IWJ"}, // Iwami Airport
    IataCode{"IWS"}, // West Houston Airport
    IataCode{"IXA"}, // Agartala Airport
    IataCode{"IXB"}, // Bagdogra Airport
    IataCode{"IXC"}, // Chandigarh Airport
    IataCode{"IXD"}, // Allahabad Airport
    IataCode{"IXE"}, // Mangalore Airport
    IataCode{"IXG"}, // Rani chanama airport (Belagavi)
    IataCode{"IXH"}, // Kailashahar Airport
    IataCode{"IXI"}, // Lilabari Airport
    IataCode{"IXJ"}, // Jammu Airport
    IataCode{"IXK"}, // Keshod Airport
    IataCode{"IXL"}, // Kushok Bakula Rimpochee Airport
    IataCode{"IXM"}, // Madurai International Airport
    IataCode{"IXN"}, // Khowai Airport
    IataCode{"IXP"}, // Pathankot Airport
    IataCode{"IXQ"}, // Kamalpur Airport
    IataCode{"IXR"}, // Birsa Munda Airport
    IataCode{"IXS"}, // Silchar Airport
    IataCode{"IXT"}, // Pasighat Airport
    IataCode{"IXU"}, // Aurangabad Airport
    IataCode{"IXV"}, // Along Airport
    IataCode{"IXW"}, // Sonari Airport
    IataCode{"IXY"}, // Kandla Airport
    IataCode{"IXZ"}, // Veer Savarkar International Airport
    IataCode{"IYA"}, // Abbeville Chris Crusta Memorial Airport
    IataCode{"IYK"}, // Inyokern Airport
    IataCode{"IZA"}, // Zona da Mata Regional Airport
    IataCode{"IZO"}, // Izumo Airport
    IataCode{"IZT"}, // Ixtepec Airport
    IataCode{"JAA"}, // Jalalabad Airport
    IataCode{"JAB"}, // Jabiru Airport
    IataCode{"JAC"}, // Jackson Hole Airport
    IataCode{"JAD"}, // Jandakot Airport
    IataCode{"JAE"}, // Shumba Airport
    IataCode{"JAI"}, // Jaipur Airport
    IataCode{"JAK"}, // Jacmel Airport
    IataCode{"JAL"}, // El Lencero Airport
    IataCode{"JAN"}, // Jackson-Evers International Airport
    IataCode{"JAO"}, // Jagodina Airport
    IataCode{"JAP"}, // Chacarita Airport
    IataCode{"JAQ"}, // Jacquinot Bay Airport
    IataCode{"JAR"}, // Jahrom Airport
    IataCode{"JAT"}, // Jabot Airport
    IataCode{"JAU"}, // Francisco Carle Airport
    IataCode{"JAV"}, // Ilulissat Airport
    IataCode{"JAX"}, // Jacksonville International Airport
    IataCode{"JBB"}, // Notohadinegoro Airport
    IataCode{"JBQ"}, // La Isabela International Airport
    IataCode{"JBR"}, // Jonesboro Municipal Airport
    IataCode{"JBT"}, // Bethel Seaplane Base
    IataCode{"JCB"}, // Joaçaba Airport
    IataCode{"JCH"}, // Qasigiannguit Heliport
    IataCode{"JCI"}, // New Century AirCenter
    IataCode{"JCK"}, // Julia Creek Airport
    IataCode{"JCR"}, // Jacareacanga Airport
    IataCode{"JDA"}, // Grant County Regional Airport
    IataCode{"JDD"}, // Wood County Airport
    IataCode{"JDF"}, // Juiz de Fora Airport
    IataCode{"JDG"}, // Jungseok Airport
    IataCode{"JDH"}, // Jodhpur Airport
    IataCode{"JDN"}, // Jordan Airport
    IataCode{"JDO"}, // Juazeiro do Norte Airport
    IataCode{"JDR"}, // São João del-Rei Airport
    IataCode{"JDZ"}, // Jingdezhen Luojia Airport
    IataCode{"JED"}, // King Abdulaziz International Airport
    IataCode{"JEE"}, // Jérémie Airport
    IataCode{"JEF"}, // Jefferson City Memorial Airport
    IataCode{"JEG"}, // Aasiaat Airport
    IataCode{"JEJ"}, // Jeh Airport
    IataCode{"JEQ"}, // Jequié Airport
    IataCode{"JER"}, // Jersey Airport
    IataCode{"JES"}, // Jesup-Wayne County Airport
    IataCode{"JFK"}, // John F. Kennedy International Airport
    IataCode{"JFN"}, // Northeast Ohio Regional Airport
    IataCode{"JFR"}, // Paamiut Airport
    IataCode{"JFX"}, // Walker County Airport
    IataCode{"JGA"}, // Jamnagar Airport
    IataCode{"JGB"}, // Jagdalpur Airport
    IataCode{"JGD"}, // Jiagedaqi Airport
    IataCode{"JGN"}, // Jiayuguan Airport
    IataCode{"JGO"}, // Qeqertarsuaq Heliport
    IataCode{"JGS"}, // Jinggangshan Airport
    IataCode{"JHB"}, // Senai International Airport
    IataCode{"JHG"}, // Xishuangbanna Gasa Airport
    IataCode{"JHL"}, // Fort MacKay/Albian Aerodrome
    IataCode{"JHM"}, // Kapalua Airport
    IataCode{"JHN"}, // Stanton County Municipal Airport
    IataCode{"JHQ"}, // Whitsunday Airport
    IataCode{"JHS"}, // Sisimiut Airport
    IataCode{"JHW"}, // Chautauqua County-Jamestown Airport
    IataCode{"JIA"}, // Juína Airport
    IataCode{"JIB"}, // Djibouti-Ambouli International Airport
    IataCode{"JIC"}, // Jinchang Jinchuan Airport
    IataCode{"JIJ"}, // Jijiga Airport
    IataCode{"JIK"}, // Ikaria Island National Airport
    IataCode{"JIL"}, // Jilin Ertaizi Airport
    IataCode{"JIM"}, // Aba Segud Airport
    IataCode{"JIN"}, // Jinja Airport
    IataCode{"JIO"}, // Jos Orno Imsula Airport
    IataCode{"JIQ"}, // Qianjiang Wulingshan Airport
    IataCode{"JIU"}, // Jiujiang Lushan Airport
    IataCode{"JIW"}, // Jiwani Airport
    IataCode{"JJC"}, // Atizapan De Zaragoza Airport
    IataCode{"JJG"}, // Jaguaruna Regional Airport
    IataCode{"JJI"}, // Juanjuí Airport
    IataCode{"JJM"}, // Mulika Lodge Airport
    IataCode{"JJN"}, // Quanzhou Jinjiang Airport
    IataCode{"JKG"}, // Jönköping Airport
    IataCode{"JKH"}, // Chios Island National Airport
    IataCode{"JKL"}, // Kalymnos Island National Airport
    IataCode{"JKR"}, // Janakpur Airport
    IataCode{"JKV"}, // Cherokee County Airport
    IataCode{"JLN"}, // Joplin Regional Airport
    IataCode{"JLR"}, // Jabalpur Airport
    IataCode{"JMB"}, // Jamba Airport
    IataCode{"JMJ"}, // Lancang Airport
    IataCode{"JMK"}, // Mykonos Island National Airport
    IataCode{"JMO"}, // Jomsom Airport
    IataCode{"JMS"}, // Jamestown Regional Airport
    IataCode{"JMU"}, // Jiamusi Dongjiao Airport
    IataCode{"JNA"}, // Januaria Airport
    IataCode{"JNB"}, // OR Tambo International Airport
    IataCode{"JNG"}, // Jining Qufu Airport
    IataCode{"JNI"}, // Junín Airport
    IataCode{"JNJ"}, // Duqm Jaaluni Airport
    IataCode{"JNU"}, // Juneau International Airport
    IataCode{"JNX"}, // Naxos Island National Airport
    IataCode{"JNZ"}, // Jinzhou Bay Airport
    IataCode{"JOE"}, // Joensuu Airport
    IataCode{"JOG"}, // Adisucipto International Airport
    IataCode{"JOI"}, // Joinville-Lauro Carneiro de Loyola Airport
    IataCode{"JOJ"}, // Doris Lake Aerodrome
    IataCode{"JOK"}, // Yoshkar-Ola Airport
    IataCode{"JOL"}, // Jolo Airport
    IataCode{"JON"}, // Johnston Atoll Airport
    IataCode{"JOS"}, // Yakubu Gowon Airport
    IataCode{"JOT"}, // Joliet Regional Airport
    IataCode{"JPA"}, // Presidente Castro Pinto International Airport
    IataCode{"JPR"}, // Ji-Paraná Airport
    IataCode{"JQA"}, // Qaarsut Airport
    IataCode{"JQE"}, // Jaqué Airport
    IataCode{"JQF"}, // Concord Regional Airport
    IataCode{"JRF"}, // Kalaeloa Airport
    IataCode{"JRH"}, // Jorhat Airport
    IataCode{"JRN"}, // Juruena Airport
    IataCode{"JRO"}, // Kilimanjaro International Airport
    IataCode{"JRZ"}, // Benito Juárez Airport, Argentina
    IataCode{"JSA"}, // Jharsuguda Airport
    IataCode{"JSH"}, // Sitia Public Airport
    IataCode{"JSI"}, // Skiathos Island National Airport
    IataCode{"JSJ"}, // Jiansanjiang Airport
    IataCode{"JSM"}, // José de San Martín Airport
    IataCode{"JSR"}, // Jessore Airport
    IataCode{"JST"}, // Johnstown–Cambria County Airport
    IataCode{"JSU"}, // Maniitsoq Airport
    IataCode{"JSV"}, // Sallisaw Municipal Airport
    IataCode{"JSY"}, // Syros Island National Airport
    IataCode{"JTC"}, // Bauru-Arealva Airport
    IataCode{"JTI"}, // Jataí Airport
    IataCode{"JTR"}, // Santorini (Thira) National Airport
    IataCode{"JTY"}, // Astypalaia Island National Airport
    IataCode{"JUA"}, // Juara Airport
    IataCode{"JUB"}, // Juba International Airport
    IataCode{"JUH"}, // Chizhou Jiuhuashan Airport
    IataCode{"JUI"}, // Juist Airport
    IataCode{"JUJ"}, // Gobernador Horacio Guzmán International Airport
    IataCode{"JUL"}, // Inca Manco Cápac International Airport
    IataCode{"JUM"}, // Jumla Airport
    IataCode{"JUR"}, // Jurien Bay Airport
    IataCode{"JUS"}, // Aeroclub Argentino
    IataCode{"JUV"}, // Upernavik Airport
    IataCode{"JUZ"}, // Quzhou Airport
    IataCode{"JVA"}, // Ankavandra Airport
    IataCode{"JVI"}, // Central Jersey Regional Airport
    IataCode{"JVL"}, // Southern Wisconsin Regional Airport
    IataCode{"JVM"}, // Jonesville Mine Airport
    IataCode{"JVW"}, // John Bell Williams Airport
    IataCode{"JVY"}, // Clark Regional Airport
    IataCode{"JWA"}, // Jwaneng Airport
    IataCode{"JWG"}, // Watonga Regional Airport
    IataCode{"JWN"}, // Zanjan Airport
    IataCode{"JXA"}, // Jixi Xingkaihu Airport
    IataCode{"JXN"}, // Jackson County Airport
    IataCode{"JXS"}, // Jiaxing Airport
    IataCode{"JYM"}, // Hillsdale Municipal Airport
    IataCode{"JYO"}, // Leesburg Executive Airport
    IataCode{"JYR"}, // Jiroft Airport
    IataCode{"JYV"}, // Jyväskylä Airport
    IataCode{"JZH"}, // Jiuzhai Huanglong Airport
    IataCode{"JZI"}, // Charleston Executive Airport
    IataCode{"JZP"}, // Pickens County Airport
    IataCode{"KAA"}, // Kasama Airport
    IataCode{"KAB"}, // Kariba Airport
    IataCode{"KAC"}, // Qamishli Airport
    IataCode{"KAD"}, // Kaduna Airport
    IataCode{"KAE"}, // Kake Seaplane Base
    IataCode{"KAI"}, // Kaieteur International Airport
    IataCode{"KAJ"}, // Kajaani Airport
    IataCode{"KAL"}, // Kaltag Airport
    IataCode{"KAM"}, // Kamaran Airport
    IataCode{"KAN"}, // Mallam Aminu Kano International Airport
    IataCode{"KAO"}, // Kuusamo Airport
    IataCode{"KAP"}, // Kapanga Airport
    IataCode{"KAR"}, // Kamarang Airport
    IataCode{"KAS"}, // Karasburg Airport
    IataCode{"KAT"}, // Kaitaia Airport
    IataCode{"KAW"}, // Kawthaung Airport
    IataCode{"KAX"}, // Kalbarri Airport
    IataCode{"KBA"}, // Kabala Airport
    IataCode{"KBC"}, // Birch Creek Airport
    IataCode{"KBG"}, // Kabalega Falls Airport
    IataCode{"KBI"}, // Kribi Airport
    IataCode{"KBL"}, // Hamid Karzai International Airport
    IataCode{"KBN"}, // Tunta Airport
    IataCode{"KBO"}, // Kabalo Airport
    IataCode{"KBP"}, // Boryspil International Airport
    IataCode{"KBQ"}, // Kasungu Airport
    IataCode{"KBR"}, // Sultan Ismail Petra Airport
    IataCode{"KBS"}, // Bo Airport
    IataCode{"KBU"}, // Gusti Syamsir Alam Airport
    IataCode{"KBV"}, // Krabi Airport
    IataCode{"KBW"}, // Chignik Bay Seaplane Base
    IataCode{"KBY"}, // Streaky Bay Airport
    IataCode{"KBZ"}, // Kaikoura Aerodrome
    IataCode{"KCA"}, // Kuqa Qiuci Airport
    IataCode{"KCB"}, // Tepoe Airstrip
    IataCode{"KCC"}, // Coffman Cove Seaplane Base
    IataCode{"KCF"}, // Kadanwari Airport
    IataCode{"KCG"}, // Chignik Fisheries Airport
    IataCode{"KCH"}, // Kuching International Airport
    IataCode{"KCK"}, // Kirensk Airport
    IataCode{"KCL"}, // Chignik Lagoon Airport
    IataCode{"KCM"}, // Kahramanmaraş Airport
    IataCode{"KCQ"}, // Chignik Lake Airport
    IataCode{"KCT"}, // SLAF Koggala
    IataCode{"KCU"}, // Masindi Airport
    IataCode{"KCZ"}, // Kōchi Airport
    IataCode{"KDA"}, // Kolda North Airport
    IataCode{"KDB"}, // Kambalda Airport
    IataCode{"KDC"}, // Kandi Airport
    IataCode{"KDD"}, // Khuzdar Airport
    IataCode{"KDH"}, // Kandahar International Airport
    IataCode{"KDI"}, // Haluoleo Airport
    IataCode{"KDJ"}, // Ndjolé Ville Airport
    IataCode{"KDK"}, // Kodiak Municipal Airport
    IataCode{"KDL"}, // Kärdla Airport
    IataCode{"KDM"}, // Kaadedhdhoo Airport
    IataCode{"KDN"}, // Ndendé Airport
    IataCode{"KDO"}, // Kadhdhoo Airport
    IataCode{"KDR"}, // Kandrian Airport
    IataCode{"KDU"}, // Skardu Airport
    IataCode{"KDV"}, // Vunisea Airport
    IataCode{"KDX"}, // Kadugli Airport
    IataCode{"KDY"}, // Teply Klyuch Airport
    IataCode{"KEB"}, // Nanwalek Airport
    IataCode{"KED"}, // Kaédi Airport
    IataCode{"KEE"}, // Kelle Airport
    IataCode{"KEF"}, // Keflavík International Airport
    IataCode{"KEH"}, // Kenmore Air Harbor
    IataCode{"KEJ"}, // Kemerovo International Airport
    IataCode{"KEK"}, // Ekwok Airport
    IataCode{"KEM"}, // Kemi-Tornio Airport
    IataCode{"KEN"}, // Kenema Airport
    IataCode{"KEO"}, // Odienné Airport
    IataCode{"KEP"}, // Nepalgunj Airport
    IataCode{"KER"}, // Kerman Airport
    IataCode{"KES"}, // Kelsey Airport
    IataCode{"KET"}, // Kengtung Airport
    IataCode{"KEU"}, // Keekorok Airport
    IataCode{"KEW"}, // Keewaywin Airport
    IataCode{"KEY"}, // Kericho Airport
    IataCode{"KFA"}, // Kiffa Airport
    IataCode{"KFE"}, // Fortescue Dave Forrest Airport
    IataCode{"KFG"}, // Kalkgurung Airport
    IataCode{"KFP"}, // False Pass Airport
    IataCode{"KFS"}, // Kastamonu Airport
    IataCode{"KGA"}, // Kananga Airport
    IataCode{"KGC"}, // Kingscote Airport
    IataCode{"KGD"}, // Khrabrovo Airport
    IataCode{"KGE"}, // Kaghau Airport
    IataCode{"KGF"}, // Sary-Arka Airport
    IataCode{"KGG"}, // Kédougou Airport
    IataCode{"KGI"}, // Kalgoorlie-Boulder Airport
    IataCode{"KGJ"}, // Karonga Airport
    IataCode{"KGK"}, // Koliganek Airport
    IataCode{"KGL"}, // Kigali International Airport
    IataCode{"KGN"}, // Kasongo Lunda Airport
    IataCode{"KGP"}, // Kogalym International Airport
    IataCode{"KGS"}, // Kos Island International Airport
    IataCode{"KGT"}, // Kangding Airport
    IataCode{"KGU"}, // Keningau Airport
    IataCode{"KGX"}, // Grayling Airport
    IataCode{"KGY"}, // Kingaroy Airport
    IataCode{"KHC"}, // Kerch Airport
    IataCode{"KHD"}, // Khorramabad Airport
    IataCode{"KHE"}, // Kherson International Airport
    IataCode{"KHG"}, // Kashgar Airport
    IataCode{"KHH"}, // Kaohsiung International Airport
    IataCode{"KHI"}, // Jinnah International Airport
    IataCode{"KHK"}, // Khark Airport
    IataCode{"KHM"}, // Khamti Airport
    IataCode{"KHN"}, // Nanchang Changbei International Airport
    IataCode{"KHR"}, // Kharkhorin Airport
    IataCode{"KHS"}, // Khasab Airport
    IataCode{"KHT"}, // Khost Airfield
    IataCode{"KHU"}, // Kremenchuk Airport
    IataCode{"KHV"}, // Khabarovsk Novy Airport
    IataCode{"KHW"}, // Khwai River Airport
    IataCode{"KHY"}, // Khoy Airport
    IataCode{"KIC"}, // Mesa Del Rey Airport
    IataCode{"KID"}, // Kristianstad Airport
    IataCode{"KIE"}, // Kieta Airport
    IataCode{"KIF"}, // Kingfisher Lake Airport
    IataCode{"KIH"}, // Kish International Airport
    IataCode{"KIJ"}, // Niigata Airport
    IataCode{"KIM"}, // Kimberley Airport
    IataCode{"KIN"}, // Norman Manley International Airport
    IataCode{"KIO"}, // Kili Airport
    IataCode{"KIP"}, // Kickapoo Downtown Airport
    IataCode{"KIR"}, // Kerry Airport
    IataCode{"KIS"}, // Kisumu International Airport
    IataCode{"KIT"}, // Kithira Island National Airport "Alexandros Aristotelous Onassis"
    IataCode{"KIV"}, // Chișinău International Airport
    IataCode{"KIW"}, // Southdowns Airport
    IataCode{"KIX"}, // Kansai International Airport
    IataCode{"KIY"}, // Kilwa Masoko Airport
    IataCode{"KJA"}, // Khan Jahan Ali Airport
    IataCode{"KJH"}, // Kaili Huangping Airport
    IataCode{"KJI"}, // Kanas Airport
    IataCode{"KJK"}, // Kortrijk-Wevelgem International Airport
    IataCode{"KJP"}, // Kerama Airport
    IataCode{"KKA"}, // Koyuk Alfred Adams Airport
    IataCode{"KKB"}, // Kitoi Bay Seaplane Base
    IataCode{"KKC"}, // Khon Kaen Airport
    IataCode{"KKD"}, // Kokoda Airport
    IataCode{"KKE"}, // Kerikeri Airport
    IataCode{"KKH"}, // Kongiganak Airport
    IataCode{"KKI"}, // Akiachak Airport
    IataCode{"KKJ"}, // Kitakyushu Airport
    IataCode{"KKM"}, // Khok Kathiam Airport
    IataCode{"KKN"}, // Kirkenes Airport, Høybuktmoen
    IataCode{"KKO"}, // Kaikohe Aerodrome
    IataCode{"KKR"}, // Kaukura Airport
    IataCode{"KKT"}, // Kentland Municipal Airport
    IataCode{"KKW"}, // Kikwit Airport
    IataCode{"KKX"}, // Kikai Airport
    IataCode{"KKY"}, // Kilkenny Airport
    IataCode{"KKZ"}, // Koh Kong Airport
    IataCode{"KLA"}, // Kampala Airport
    IataCode{"KLB"}, // Kalabo Airport
    IataCode{"KLC"}, // Kaolack Airport
    IataCode{"KLD"}, // Migalovo
    IataCode{"KLE"}, // Kaélé Airport
    IataCode{"KLF"}, // "Kaluga" (Grabtsevo) Airport
    IataCode{"KLG"}, // Kalskag Airport
    IataCode{"KLH"}, // Kolhapur Airport
    IataCode{"KLJ"}, // Klaipėda Airport
    IataCode{"KLK"}, // Kalokol Airport
    IataCode{"KLL"}, // Levelock Airport
    IataCode{"KLM"}, // Kalaleh Airport
    IataCode{"KLN"}, // Larsen Bay Airport
    IataCode{"KLO"}, // Kalibo International Airport
    IataCode{"KLP"}, // Seruyan Kuala Pembuang Airport
    IataCode{"KLR"}, // Kalmar Airport
    IataCode{"KLS"}, // Southwest Washington Regional Airport
    IataCode{"KLU"}, // Klagenfurt Airport
    IataCode{"KLV"}, // Karlovy Vary Airport
    IataCode{"KLW"}, // Klawock Airport
    IataCode{"KLX"}, // Kalamata International Airport
    IataCode{"KLY"}, // Kinkungwa Airport
    IataCode{"KLZ"}, // Kleinzee Airport
    IataCode{"KMA"}, // Kerema Airport
    IataCode{"KMC"}, // Hafar Al-Batin Domestic Airport
    IataCode{"KME"}, // Kamembe Airport
    IataCode{"KMG"}, // Kunming Changshui International Airport
    IataCode{"KMH"}, // Johan Pienaar Airport
    IataCode{"KMI"}, // Miyazaki Airport
    IataCode{"KMJ"}, // Kumamoto Airport
    IataCode{"KMK"}, // Makabana Airport
    IataCode{"KMN"}, // Kamina Airport
    IataCode{"KMO"}, // Manokotak Airport
    IataCode{"KMP"}, // Keetmanshoop Airport
    IataCode{"KMQ"}, // Komatsu Airport
    IataCode{"KMS"}, // Kumasi Airport
    IataCode{"KMT"}, // Kampot Airport
    IataCode{"KMU"}, // Kismayo Airport
    IataCode{"KMV"}, // Kalaymyo Airport
    IataCode{"KMW"}, // Kostroma Airport
    IataCode{"KMY"}, // Moser Bay Seaplane Base
    IataCode{"KMZ"}, // Kaoma Airport
    IataCode{"KNA"}, // Viña del Mar Airport
    IataCode{"KNB"}, // Kanab Municipal Airport
    IataCode{"KND"}, // Kindu Airport
    IataCode{"KNG"}, // Kaimana Airport
    IataCode{"KNH"}, // Kinmen Airport
    IataCode{"KNI"}, // Katanning Airport
    IataCode{"KNJ"}, // Kindamba Airport
    IataCode{"KNK"}, // Kokhanok Airport
    IataCode{"KNM"}, // Kaniama Airport
    IataCode{"KNN"}, // Kankan Airport
    IataCode{"KNO"}, // Kuala Namu International Airport
    IataCode{"KNP"}, // Kapanda Airport
    IataCode{"KNQ"}, // Koné Airport
    IataCode{"KNS"}, // King Island Airport
    IataCode{"KNT"}, // Kennett Memorial Airport
    IataCode{"KNU"}, // Kanpur Airport
    IataCode{"KNW"}, // New Stuyahok Airport
    IataCode{"KNX"}, // Kununurra Airport
    IataCode{"KNZ"}, // Kéniéba Airport
    IataCode{"KOA"}, // Kona International Airport
    IataCode{"KOB"}, // Foumban Nkounja Airport
    IataCode{"KOC"}, // Koumac Airport
    IataCode{"KOE"}, // El Tari Airport
    IataCode{"KOI"}, // Kirkwall Airport
    IataCode{"KOJ"}, // Kagoshima Airport
    IataCode{"KOK"}, // Kokkola-Pietarsaari Airport
    IataCode{"KOL"}, // Koumala Airport
    IataCode{"KOO"}, // Kongolo Airport
    IataCode{"KOP"}, // Nakhon Phanom Airport
    IataCode{"KOQ"}, // Köthen Airport
    IataCode{"KOS"}, // Sihanoukville International Airport
    IataCode{"KOT"}, // Kotlik Airport
    IataCode{"KOU"}, // Koulamoutou Airport
    IataCode{"KOV"}, // Kokshetau Airport
    IataCode{"KOW"}, // Ganzhou Huangjin Airport
    IataCode{"KOY"}, // Olga Bay Seaplane Base
    IataCode{"KOZ"}, // Ouzinkie Airport
    IataCode{"KPB"}, // Point Baker Seaplane Base
    IataCode{"KPC"}, // Port Clarence Coast Guard Station
    IataCode{"KPI"}, // Kapit Airport
    IataCode{"KPN"}, // Kipnuk Airport
    IataCode{"KPO"}, // Pohang Airport
    IataCode{"KPR"}, // Port Williams Seaplane Base
    IataCode{"KPS"}, // Kempsey Airport
    IataCode{"KPT"}, // Jackpot Airport
    IataCode{"KPV"}, // Perryville Airport
    IataCode{"KPW"}, // Keperveyem Airport
    IataCode{"KPY"}, // Port Bailey Seaplane Base
    IataCode{"KQA"}, // Akutan Seaplane Base
    IataCode{"KQR"}, // Karara Airport
    IataCode{"KQT"}, // Qurghonteppa International Airport
    IataCode{"KRA"}, // Kerang Airport
    IataCode{"KRB"}, // Karumba Airport
    IataCode{"KRC"}, // Depati Parbo Airport
    IataCode{"KRE"}, // Kirundo Airport
    IataCode{"KRF"}, // Kramfors-Sollefteå Airport
    IataCode{"KRG"}, // Karasabai Airport
    IataCode{"KRH"}, // Redhill Aerodrome
    IataCode{"KRI"}, // Kikori Airport
    IataCode{"KRK"}, // John Paul II International Airport Kraków-Balice
    IataCode{"KRL"}, // Korla Airport
    IataCode{"KRM"}, // Karanambo Airport
    IataCode{"KRN"}, // Kiruna Airport
    IataCode{"KRO"}, // Kurgan Airport
    IataCode{"KRP"}, // Karup Airport
    IataCode{"KRR"}, // Krasnodar International Airport
    IataCode{"KRS"}, // Kristiansand Airport, Kjevik
    IataCode{"KRT"}, // Khartoum International Airport
    IataCode{"KRV"}, // Kimwarer Airport
    IataCode{"KRW"}, // Turkmenbashi Airport
    IataCode{"KRY"}, // Karamay Airport
    IataCode{"KRZ"}, // Basango Mboliasa Airport
    IataCode{"KSA"}, // Kosrae International Airport
    IataCode{"KSC"}, // Košice International Airport
    IataCode{"KSD"}, // Karlstad Airport
    IataCode{"KSE"}, // Kasese Airport
    IataCode{"KSF"}, // Kassel Airport
    IataCode{"KSH"}, // Kermanshah Airport
    IataCode{"KSI"}, // Kissidougou Airport
    IataCode{"KSJ"}, // Kassos Island Public Airport
    IataCode{"KSK"}, // Karlskoga Airport
    IataCode{"KSL"}, // Kassala Airport
    IataCode{"KSM"}, // St. Mary's Airport
    IataCode{"KSN"}, // Kostanay Airport
    IataCode{"KSO"}, // Kastoria National Airport
    IataCode{"KSQ"}, // Karshi Airport
    IataCode{"KSR"}, // H. Aroeppala Airport
    IataCode{"KSS"}, // Sikasso Airport
    IataCode{"KST"}, // Rabak Airport
    IataCode{"KSU"}, // Kristiansund Airport, Kvernberget
    IataCode{"KSV"}, // Springvale Airport
    IataCode{"KSY"}, // Kars Airport
    IataCode{"KSZ"}, // Kotlas Airport
    IataCode{"KTA"}, // Karratha Airport
    IataCode{"KTB"}, // Thorne Bay Seaplane Base
    IataCode{"KTC"}, // Katiola Airport
    IataCode{"KTD"}, // Kitadaito Airport
    IataCode{"KTE"}, // Kerteh Airport
    IataCode{"KTF"}, // Takaka Aerodrome
    IataCode{"KTG"}, // Ketapang Airport
    IataCode{"KTI"}, // Kratié Airport
    IataCode{"KTL"}, // Kitale Airport
    IataCode{"KTM"}, // Tribhuvan International Airport
    IataCode{"KTN"}, // Ketchikan International Airport
    IataCode{"KTO"}, // Kato Airport
    IataCode{"KTP"}, // Tinson Pen Aerodrome
    IataCode{"KTS"}, // Brevig Mission Airport
    IataCode{"KTT"}, // Kittilä Airport
    IataCode{"KTU"}, // Kota Airport
    IataCode{"KTV"}, // Kamarata Airport
    IataCode{"KTW"}, // Katowice International Airport
    IataCode{"KTX"}, // Koutiala Airport
    IataCode{"KUA"}, // Sultan Haji Ahmad Shah Airport
    IataCode{"KUC"}, // Kuria Airport
    IataCode{"KUD"}, // Kudat Airport
    IataCode{"KUE"}, // Kukudu Airport
    IataCode{"KUF"}, // Kurumoch International Airport
    IataCode{"KUG"}, // Kubin Airport
    IataCode{"KUH"}, // Kushiro Airport
    IataCode{"KUK"}, // Kasigluk Airport
    IataCode{"KUL"}, // Kuala Lumpur International Airport
    IataCode{"KUM"}, // Yakushima Airport
    IataCode{"KUN"}, // Kaunas Airport
    IataCode{"KUO"}, // Kuopio Airport
    IataCode{"KUR"}, // Razer Airport
    IataCode{"KUS"}, // Kulusuk Airport
    IataCode{"KUT"}, // Kutaisi International Airport
    IataCode{"KUU"}, // Bhuntar Airport
    IataCode{"KUV"}, // Gunsan Airport
    IataCode{"KUY"}, // Kamusi Airport
    IataCode{"KVA"}, // Kavala International Airport
    IataCode{"KVB"}, // Skövde Airport
    IataCode{"KVC"}, // King Cove Airport
    IataCode{"KVD"}, // Ganja International Airport
    IataCode{"KVG"}, // Kavieng Airport
    IataCode{"KVK"}, // Kirovsk-Apatity Airport
    IataCode{"KVL"}, // Kivalina Airport
    IataCode{"KVM"}, // Markovo Airport
    IataCode{"KVO"}, // Morava Airport
    IataCode{"KVS"}, // Kraljevo Sport Airport
    IataCode{"KVX"}, // Pobedilovo Airport
    IataCode{"KWB"}, // Dewadaru Airport
    IataCode{"KWE"}, // Guiyang Longdongbao International Airport
    IataCode{"KWF"}, // Waterfall Seaplane Base
    IataCode{"KWG"}, // Kryvyi Rih International Airport
    IataCode{"KWH"}, // Khwahan Airport
    IataCode{"KWI"}, // Kuwait International Airport
    IataCode{"KWJ"}, // Gwangju Airport
    IataCode{"KWK"}, // Kwigillingok Airport
    IataCode{"KWL"}, // Guilin Liangjiang International Airport
    IataCode{"KWN"}, // Quinhagak Airport
    IataCode{"KWP"}, // West Point Village Seaplane Base
    IataCode{"KWS"}, // Kiryat Shmona Airport
    IataCode{"KWT"}, // Kwethluk Airport
    IataCode{"KWY"}, // Kiwayu Airport
    IataCode{"KWZ"}, // Kolwezi Airport
    IataCode{"KXD"}, // Kondinskoye Airport
    IataCode{"KXF"}, // Koro Airport
    IataCode{"KXK"}, // Komsomolsk-on-Amur Airport
    IataCode{"KYD"}, // Lanyu Airport
    IataCode{"KYK"}, // Karluk Airport
    IataCode{"KYP"}, // Kyaukpyu Airport
    IataCode{"KYS"}, // Kayes Airport
    IataCode{"KYU"}, // Koyukuk Airport
    IataCode{"KYZ"}, // Kyzyl Airport
    IataCode{"KZB"}, // Zachar Bay Seaplane Base
    IataCode{"KZC"}, // Knjaževac Airport
    IataCode{"KZD"}, // Krakor Airport
    IataCode{"KZI"}, // Kozani National Airport
    IataCode{"KZK"}, // Kampong Cham Airport
    IataCode{"KZN"}, // Kazan International Airport
    IataCode{"KZO"}, // Kyzylorda Airport
    IataCode{"KZR"}, // Zafer Airport
    IataCode{"KZS"}, // Kastellorizo Airport
    IataCode{"LAA"}, // Lamar Municipal Airport (Colorado)
    IataCode{"LAC"}, // Layang-Layang Airport
    IataCode{"LAD"}, // Quatro de Fevereiro Airport
    IataCode{"LAE"}, // Lae Airfield
    IataCode{"LAF"}, // Purdue University Airport
    IataCode{"LAH"}, // Oesman Sadik Airport
    IataCode{"LAI"}, // Lannion – Côte de Granit Airport
    IataCode{"LAJ"}, // Lages Airport
    IataCode{"LAK"}, // Aklavik/Freddie Carmichael Airport
    IataCode{"LAL"}, // Lakeland Linder Regional Airport
    IataCode{"LAM"}, // Los Alamos County Airport
    IataCode{"LAN"}, // Capital Region International Airport
    IataCode{"LAO"}, // Laoag International Airport
    IataCode{"LAP"}, // Manuel Márquez de León International Airport
    IataCode{"LAQ"}, // Al Abraq International Airport
    IataCode{"LAR"}, // Laramie Regional Airport
    IataCode{"LAS"}, // McCarran International Airport
    IataCode{"LAU"}, // Manda Airport
    IataCode{"LAW"}, // Lawton–Fort Sill Regional Airport
    IataCode{"LAX"}, // Los Angeles International Airport
    IataCode{"LAY"}, // Ladysmith Airport
    IataCode{"LAZ"}, // Bom Jesus da Lapa Airport
    IataCode{"LBA"}, // Leeds Bradford International Airport
    IataCode{"LBB"}, // Lubbock Preston Smith International Airport
    IataCode{"LBC"}, // Lübeck Airport
    IataCode{"LBD"}, // Khujand Airport
    IataCode{"LBE"}, // Arnold Palmer Regional Airport
    IataCode{"LBF"}, // North Platte Regional Airport
    IataCode{"LBG"}, // Paris–Le Bourget Airport
    IataCode{"LBJ"}, // Komodo Airport
    IataCode{"LBK"}, // Liboi Airport
    IataCode{"LBL"}, // Liberal Mid-America Regional Airport
    IataCode{"LBN"}, // Lake Baringo Airport
    IataCode{"LBO"}, // Lusambo Airport
    IataCode{"LBP"}, // Long Banga Airport
    IataCode{"LBQ"}, // Lambaréné Airport
    IataCode{"LBR"}, // Lábrea Airport
    IataCode{"LBS"}, // Labasa Airport
    IataCode{"LBT"}, // Lumberton Municipal Airport
    IataCode{"LBU"}, // Labuan Airport
    IataCode{"LBV"}, // Libreville International Airport
    IataCode{"LBW"}, // Juvai Semaring Airport
    IataCode{"LBX"}, // Lubang Airport
    IataCode{"LBZ"}, // Lucapa Airport
    IataCode{"LCA"}, // Larnaca International Airport
    IataCode{"LCB"}, // Pontes e Lacerda Airport
    IataCode{"LCC"}, // Lecce Galatina Airport
    IataCode{"LCE"}, // Golosón International Airport
    IataCode{"LCF"}, // Río Dulce Airport
    IataCode{"LCG"}, // A Coruña Airport
    IataCode{"LCH"}, // Lake Charles Regional Airport
    IataCode{"LCI"}, // Laconia Municipal Airport
    IataCode{"LCJ"}, // Łódź Władysław Reymont Airport
    IataCode{"LCK"}, // Rickenbacker International Airport
    IataCode{"LCL"}, // La Coloma Airport
    IataCode{"LCM"}, // La Cumbre Airport
    IataCode{"LCO"}, // Lague Airport
    IataCode{"LCQ"}, // Lake City Gateway Airport
    IataCode{"LCR"}, // La Chorrera Airport
    IataCode{"LCV"}, // Lucca-Tassignano Airport
    IataCode{"LCX"}, // Longyan Guanzhishan Airport
    IataCode{"LCY"}, // London City Airport
    IataCode{"LDA"}, // Malda Airport
    IataCode{"LDB"}, // Londrina Airport
    IataCode{"LDE"}, // Tarbes-Lourdes-Pyrénées Airport
    IataCode{"LDG"}, // Leshukonskoye Airport
    IataCode{"LDH"}, // Lord Howe Island Airport
    IataCode{"LDI"}, // Lindi Airport
    IataCode{"LDJ"}, // Linden Airport
    IataCode{"LDK"}, // Lidköping-Hovby Airport
    IataCode{"LDM"}, // Mason County Airport
    IataCode{"LDN"}, // Lamidanda Airport
    IataCode{"LDO"}, // Laduani Airstrip
    IataCode{"LDS"}, // Yichun Lindu Airport
    IataCode{"LDU"}, // Lahad Datu Airport
    IataCode{"LDX"}, // Saint-Laurent-du-Maroni Airport
    IataCode{"LDY"}, // City of Derry Airport
    IataCode{"LEB"}, // Lebanon Municipal Airport
    IataCode{"LEC"}, // Lençóis Airport
    IataCode{"LED"}, // Pulkovo Airport
    IataCode{"LEE"}, // Leesburg International Airport
    IataCode{"LEF"}, // Lebakeng Airport
    IataCode{"LEH"}, // Le Havre – Octeville Airport
    IataCode{"LEI"}, // Almería Airport
    IataCode{"LEJ"}, // Leipzig/Halle Airport
    IataCode{"LEK"}, // Tata Airport
    IataCode{"LEL"}, // Lake Evella Airport
    IataCode{"LEN"}, // León Airport
    IataCode{"LEP"}, // Leopoldina Airport
    IataCode{"LEQ"}, // Land's End Airport
    IataCode{"LER"}, // Leinster Airport
    IataCode{"LES"}, // Leskovac Airport
    IataCode{"LET"}, // Alfredo Vásquez Cobo International Airport
    IataCode{"LEU"}, // La Seu d'Urgell Airport
    IataCode{"LEV"}, // Levuka Airfield
    IataCode{"LEW"}, // Auburn/Lewiston Municipal Airport
    IataCode{"LEX"}, // Blue Grass Airport
    IataCode{"LEY"}, // Lelystad Airport
    IataCode{"LEZ"}, // La Esperanza Airport
    IataCode{"LFB"}, // Lumbo Airport
    IataCode{"LFK"}, // Angelina County Airport
    IataCode{"LFM"}, // Lamerd Airport
    IataCode{"LFN"}, // Triangle North Executive Airport
    IataCode{"LFQ"}, // Linfen Qiaoli Airport
    IataCode{"LFR"}, // La Fría Airport
    IataCode{"LFT"}, // Lafayette Regional Airport
    IataCode{"LFW"}, // Lomé-Tokoin Airport
    IataCode{"LGA"}, // LaGuardia Airport
    IataCode{"LGB"}, // Long Beach Airport
    IataCode{"LGC"}, // LaGrange-Callaway Airport
    IataCode{"LGD"}, // La Grande/Union County Airport
    IataCode{"LGE"}, // Lake Gregory Airport
    IataCode{"LGG"}, // Liege Airport
    IataCode{"LGH"}, // Leigh Creek Airport
    IataCode{"LGI"}, // Deadman's Cay Airport
    IataCode{"LGK"}, // Langkawi International Airport
    IataCode{"LGL"}, // Long Lellang Airport
    IataCode{"LGM"}, // Lago Musters Airport
    IataCode{"LGO"}, // Langeoog Airport
    IataCode{"LGP"}, // Legazpi Airport
    IataCode{"LGQ"}, // Lago Agrio Airport
    IataCode{"LGR"}, // Cochrane, Chile Airport
    IataCode{"LGS"}, // Comodoro D. Ricardo Salomón Airport
    IataCode{"LGT"}, // Las Gaviotas Airport
    IataCode{"LGU"}, // Logan-Cache Airport
    IataCode{"LGW"}, // Gatwick Airport
    IataCode{"LGX"}, // Lugh Ganane Airport
    IataCode{"LHB"}, // Bruntingthorpe Aerodrome
    IataCode{"LHC"}, // Caballococha Airport
    IataCode{"LHD"}, // Lake Hood Seaplane Base
    IataCode{"LHE"}, // Allama Iqbal International Airport
    IataCode{"LHG"}, // Lightning Ridge Airport
    IataCode{"LHM"}, // Lincoln Regional Airport
    IataCode{"LHR"}, // Heathrow Airport
    IataCode{"LHS"}, // Colonia Las Heras Airport
    IataCode{"LHV"}, // William T. Piper Memorial Airport
    IataCode{"LHW"}, // Lanzhou Zhongchuan International Airport
    IataCode{"LHX"}, // La Junta Municipal Airport
    IataCode{"LIA"}, // Liangping Airport
    IataCode{"LIE"}, // Libenge Airport
    IataCode{"LIF"}, // Lifou Airport
    IataCode{"LIG"}, // Limoges – Bellegarde Airport
    IataCode{"LIH"}, // Lihue Airport
    IataCode{"LIK"}, // Likiep Airport
    IataCode{"LIL"}, // Lille Airport
    IataCode{"LIM"}, // Jorge Chávez International Airport
    IataCode{"LIN"}, // Linate Airport
    IataCode{"LIO"}, // Limón International Airport
    IataCode{"LIP"}, // Lins Airport
    IataCode{"LIQ"}, // Lisala Airport
    IataCode{"LIR"}, // Daniel Oduber Quirós International Airport
    IataCode{"LIS"}, // Lisbon Airport
    IataCode{"LIT"}, // Bill and Hillary Clinton National Airport
    IataCode{"LIU"}, // Littlefield Municipal Airport
    IataCode{"LIW"}, // Loikaw Airport
    IataCode{"LIX"}, // Likoma Airport
    IataCode{"LIZ"}, // Loring International Airport
    IataCode{"LJA"}, // Lodja Airport
    IataCode{"LJG"}, // Lijiang Sanyi Airport
    IataCode{"LJN"}, // Texas Gulf Coast Regional Airport
    IataCode{"LJU"}, // Ljubljana Jože Pučnik Airport
    IataCode{"LKA"}, // Gewayantana Airport
    IataCode{"LKB"}, // Lakeba Airport
    IataCode{"LKE"}, // Kenmore Air Harbor Seaplane Base
    IataCode{"LKG"}, // Lokichogio Airport
    IataCode{"LKH"}, // Long Akah Airport
    IataCode{"LKK"}, // Kulik Lake Airport
    IataCode{"LKL"}, // Station Group Banak
    IataCode{"LKN"}, // Leknes Airport
    IataCode{"LKO"}, // Chaudhary Charan Singh Airport
    IataCode{"LKP"}, // Lake Placid Airport
    IataCode{"LKR"}, // Lancaster County Airport
    IataCode{"LKV"}, // Lake County Airport
    IataCode{"LKW"}, // Lekhwair Airport
    IataCode{"LKY"}, // Lake Manyara Airport
    IataCode{"LLA"}, // Luleå Airport
    IataCode{"LLB"}, // Libo Airport
    IataCode{"LLE"}, // Malelane Airport
    IataCode{"LLF"}, // Yongzhou Lingling Airport
    IataCode{"LLG"}, // Silampari Airport
    IataCode{"LLH"}, // La Lima Airport
    IataCode{"LLI"}, // Lalibela Airport
    IataCode{"LLJ"}, // Lalmonirhat Airport
    IataCode{"LLK"}, // Lankaran International Airport
    IataCode{"LLO"}, // Palopo Lagaligo Airport
    IataCode{"LLQ"}, // Monticello Municipal Airport
    IataCode{"LLR"}, // Little River Airport
    IataCode{"LLS"}, // Alférez Armando Rodríguez Airport
    IataCode{"LLT"}, // Lobito Airport
    IataCode{"LLU"}, // Lamar Municipal Airport
    IataCode{"LLV"}, // Lüliang Airport
    IataCode{"LLW"}, // Lilongwe International Airport
    IataCode{"LLX"}, // Caledonia County Airport
    IataCode{"LLY"}, // South Jersey Regional Airport
    IataCode{"LMB"}, // Salima Airport
    IataCode{"LMC"}, // La Macarena Airport
    IataCode{"LME"}, // Airport Le Mans-Arnage
    IataCode{"LML"}, // Lae Airport
    IataCode{"LMM"}, // Valle del Fuerte Federal International Airport
    IataCode{"LMN"}, // Limbang Airport
    IataCode{"LMP"}, // Lampedusa Airport
    IataCode{"LMQ"}, // Marsa Brega Airport
    IataCode{"LMR"}, // Lime Acres Finsch Mine Airport
    IataCode{"LMS"}, // Louisville Winston County Airport
    IataCode{"LMT"}, // Klamath Falls Airport
    IataCode{"LMY"}, // Lake Murray Airport
    IataCode{"LNA"}, // Palm Beach County Park Airport
    IataCode{"LNB"}, // Lamen Bay Airport
    IataCode{"LNC"}, // Lancaster Airport
    IataCode{"LND"}, // Hunt Field
    IataCode{"LNE"}, // Lonorore Airport
    IataCode{"LNI"}, // Point Lonely Short Range Radar Site
    IataCode{"LNJ"}, // Lincang Airport
    IataCode{"LNL"}, // Kings Land O' Lakes Airport
    IataCode{"LNN"}, // Willoughby Lost Nation Municipal Airport
    IataCode{"LNO"}, // Leonora Airport
    IataCode{"LNP"}, // Lonesome Pine Airport
    IataCode{"LNR"}, // Tri-County Regional Airport
    IataCode{"LNS"}, // Lancaster Airport
    IataCode{"LNV"}, // Lihir Island Airport
    IataCode{"LNX"}, // Smolensk North Airport
    IataCode{"LNY"}, // Lanai Airport
    IataCode{"LNZ"}, // Linz Airport
    IataCode{"LOB"}, // San Rafael Airport (Chile)
    IataCode{"LOD"}, // Longana Airport
    IataCode{"LOE"}, // Loei Airport
    IataCode{"LOH"}, // Camilo Ponce Enríquez Airport - Ciudad de Catamayo
    IataCode{"LOI"}, // Lontras Airport
    IataCode{"LOK"}, // Lodwar Airport
    IataCode{"LOL"}, // Derby Field
    IataCode{"LOM"}, // Francisco Primo de Verdad National Airport
    IataCode{"LON"}, // Long Thanh International Airport
    IataCode{"LOO"}, // L'Mekrareg Airport
    IataCode{"LOP"}, // Lombok International Airport
    IataCode{"LOQ"}, // Lobatse Airport
    IataCode{"LOS"}, // Murtala Muhammed International Airport
    IataCode{"LOT"}, // Lewis University Airport
    IataCode{"LOU"}, // Bowman Field
    IataCode{"LOV"}, // Venustiano Carranza International Airport
    IataCode{"LOW"}, // Louisa County Airport
    IataCode{"LOY"}, // Loiyangalani Airport
    IataCode{"LOZ"}, // London-Corbin Airport
    IataCode{"LPA"}, // Gran Canaria Airport
    IataCode{"LPB"}, // El Alto International Airport
    IataCode{"LPC"}, // Lompoc Airport
    IataCode{"LPD"}, // La Pedrera Airport
    IataCode{"LPE"}, // La Primavera Airport
    IataCode{"LPF"}, // Liupanshui Yuezhao Airport
    IataCode{"LPG"}, // La Plata Airport
    IataCode{"LPI"}, // Linköping City Airport
    IataCode{"LPK"}, // Lipetsk Airport
    IataCode{"LPL"}, // Liverpool John Lennon Airport
    IataCode{"LPM"}, // Malekoula Airport
    IataCode{"LPO"}, // La Porte Municipal Airport
    IataCode{"LPP"}, // Lappeenranta Airport
    IataCode{"LPQ"}, // Luang Prabang International Airport
    IataCode{"LPR"}, // Lorain County Regional Airport
    IataCode{"LPS"}, // Fishermans Bay/LPS Seaplane Base
    IataCode{"LPT"}, // Lampang Airport
    IataCode{"LPU"}, // Long Apung Airport
    IataCode{"LPX"}, // Liepāja International Airport
    IataCode{"LPY"}, // Le Puy – Loudes Airport
    IataCode{"LQK"}, // Pickens County Airport
    IataCode{"LQM"}, // Caucayá Airport
    IataCode{"LQN"}, // Qala i Naw Airport
    IataCode{"LRA"}, // Larissa National Airport
    IataCode{"LRB"}, // Leribe Airport
    IataCode{"LRD"}, // Laredo International Airport
    IataCode{"LRE"}, // Longreach Airport
    IataCode{"LRG"}, // Lincoln Regional Airport
    IataCode{"LRH"}, // La Rochelle – Île de Ré Airport
    IataCode{"LRJ"}, // Le Mars Municipal Airport
    IataCode{"LRL"}, // Niamtougou International Airport
    IataCode{"LRM"}, // La Romana International Airport
    IataCode{"LRO"}, // Mount Pleasant Regional Airport
    IataCode{"LRQ"}, // Laurie River Airport
    IataCode{"LRR"}, // Larestan International Airport
    IataCode{"LRS"}, // Leros Island National Airport
    IataCode{"LRT"}, // Lorient South Brittany Airport
    IataCode{"LRU"}, // Las Cruces International Airport
    IataCode{"LRV"}, // Los Roques Airport
    IataCode{"LSA"}, // Losuia Airport
    IataCode{"LSC"}, // La Florida Airport
    IataCode{"LSE"}, // La Crosse Regional Airport
    IataCode{"LSH"}, // Lashio Airport
    IataCode{"LSI"}, // Sumburgh Airport
    IataCode{"LSL"}, // Los Chiles Airport
    IataCode{"LSM"}, // Long Semado Airport
    IataCode{"LSN"}, // Los Banos Municipal Airport
    IataCode{"LSO"}, // Sables-d'Olonne - Talmont Airport
    IataCode{"LSP"}, // Josefa Camejo International Airport
    IataCode{"LSQ"}, // María Dolores Airport
    IataCode{"LSR"}, // Lost River 1 Airport
    IataCode{"LSS"}, // Les Saintes Airport
    IataCode{"LST"}, // Launceston Airport
    IataCode{"LSU"}, // Long Sukang Airport
    IataCode{"LSW"}, // Malikus Saleh Airport
    IataCode{"LSY"}, // Lismore Airport
    IataCode{"LSZ"}, // Lošinj Airport
    IataCode{"LTA"}, // Tzaneen Airport
    IataCode{"LTC"}, // Laï Airport
    IataCode{"LTD"}, // Ghadames Airport
    IataCode{"LTI"}, // Altai Airport
    IataCode{"LTK"}, // Bassel Al-Assad International Airport
    IataCode{"LTL"}, // Lastourville Airport
    IataCode{"LTM"}, // Lethem Airport
    IataCode{"LTN"}, // Luton Airport
    IataCode{"LTO"}, // Loreto International Airport
    IataCode{"LTQ"}, // Le Touquet – Côte d'Opale Airport
    IataCode{"LTT"}, // La Môle – Saint-Tropez Airport
    IataCode{"LTU"}, // Latur Airport
    IataCode{"LTW"}, // St. Mary's County Regional Airport
    IataCode{"LTX"}, // Cotopaxi International Airport
    IataCode{"LTY"}, // Liberty County Airport
    IataCode{"LUA"}, // Tenzing-Hillary Airport
    IataCode{"LUB"}, // Lumid Pau Airport
    IataCode{"LUC"}, // Laucala Airport
    IataCode{"LUD"}, // Lüderitz Airport
    IataCode{"LUG"}, // Lugano Airport
    IataCode{"LUH"}, // Sahnewal Airport
    IataCode{"LUI"}, // La Unión Airport
    IataCode{"LUK"}, // Cincinnati Municipal Lunken Airport
    IataCode{"LUL"}, // Hesler-Noble Field
    IataCode{"LUM"}, // Dehong Mangshi Airport
    IataCode{"LUN"}, // Lusaka International Airport
    IataCode{"LUO"}, // Luena Airport
    IataCode{"LUP"}, // Kalaupapa Airport
    IataCode{"LUQ"}, // Brigadier Mayor César Raúl Ojeda Airport
    IataCode{"LUR"}, // Cape Lisburne LRRS Airport
    IataCode{"LUS"}, // Lusanga Airport
    IataCode{"LUU"}, // Laura Airport
    IataCode{"LUV"}, // Karel Sadsuitubun Airport
    IataCode{"LUW"}, // Syukuran Aminuddin Amir Airport
    IataCode{"LUX"}, // Luxembourg Airport
    IataCode{"LUZ"}, // Lublin Airport
    IataCode{"LVA"}, // Laval - Entrammes Airport
    IataCode{"LVB"}, // Santana do Livramento Airport
    IataCode{"LVI"}, // Harry Mwanga Nkumbula International Airport
    IataCode{"LVK"}, // Livermore Municipal Airport
    IataCode{"LVM"}, // Mission Field
    IataCode{"LVN"}, // Airlake Airport
    IataCode{"LVO"}, // Laverton Airport
    IataCode{"LVP"}, // Lavan Airport
    IataCode{"LVR"}, // Lucas do Rio Verde Airport
    IataCode{"LVS"}, // Las Vegas Municipal Airport
    IataCode{"LWB"}, // Greenbrier Valley Airport
    IataCode{"LWC"}, // Lawrence Municipal Airport
    IataCode{"LWE"}, // Wonopito Airport
    IataCode{"LWK"}, // Tingwall Airport
    IataCode{"LWL"}, // Wells Municipal Airport
    IataCode{"LWM"}, // Lawrence Municipal Airport
    IataCode{"LWN"}, // Shirak International Airport
    IataCode{"LWO"}, // Lviv Danylo Halytskyi International Airport
    IataCode{"LWS"}, // Lewiston – Nez Perce County Airport
    IataCode{"LWT"}, // Lewistown Municipal Airport
    IataCode{"LWV"}, // Lawrenceville-Vincennes International Airport
    IataCode{"LWY"}, // Lawas Airport
    IataCode{"LXA"}, // Lhasa Gonggar Airport
    IataCode{"LXG"}, // Louangnamtha Airport
    IataCode{"LXL"}, // Little Falls/Morrison County Airport
    IataCode{"LXN"}, // Jim Kelly Field
    IataCode{"LXR"}, // Luxor International Airport
    IataCode{"LXS"}, // Lemnos International Airport
    IataCode{"LXU"}, // Lukulu Airport
    IataCode{"LXV"}, // Lake County Airport
    IataCode{"LYA"}, // Luoyang Beijiao Airport
    IataCode{"LYB"}, // Edward Bodden Airfield
    IataCode{"LYC"}, // Lycksele Airport
    IataCode{"LYG"}, // Lianyungang Airport
    IataCode{"LYH"}, // Lynchburg Regional Airport
    IataCode{"LYI"}, // Linyi Shubuling Airport
    IataCode{"LYM"}, // Lympne Airport
    IataCode{"LYN"}, // Lyon-Bron Airport
    IataCode{"LYP"}, // Faisalabad International Airport
    IataCode{"LYR"}, // Svalbard Airport
    IataCode{"LYS"}, // Lyon-Saint Exupéry Airport
    IataCode{"LYU"}, // Ely Municipal Airport
    IataCode{"LYX"}, // Lydd Airport
    IataCode{"LZA"}, // Luiza Airport
    IataCode{"LZC"}, // Lázaro Cárdenas Airport
    IataCode{"LZD"}, // Danielson Airport
    IataCode{"LZH"}, // Liuzhou Bailian Airport
    IataCode{"LZM"}, // Luzamba Airport
    IataCode{"LZN"}, // Matsu Nangan Airport
    IataCode{"LZO"}, // Luzhou Lantian Airport
    IataCode{"LZR"}, // Lizard Island Airport
    IataCode{"LZU"}, // Gwinnett County Airport
    IataCode{"LZY"}, // Nyingchi Mainling Airport
    IataCode{"MAA"}, // Chennai International Airport
    IataCode{"MAB"}, // Marabá Airport
    IataCode{"MAC"}, // Macon Downtown Airport
    IataCode{"MAD"}, // Adolfo Suárez Madrid–Barajas Airport
    IataCode{"MAE"}, // Madera Municipal Airport
    IataCode{"MAF"}, // Midland International Airport
    IataCode{"MAG"}, // Madang Airport
    IataCode{"MAH"}, // Menorca Airport
    IataCode{"MAI"}, // Mangochi Airport
    IataCode{"MAJ"}, // Marshall Islands International Airport
    IataCode{"MAK"}, // Malakal Airport
    IataCode{"MAL"}, // Malone-Dufort Airport
    IataCode{"MAM"}, // General Servando Canales International Airport
    IataCode{"MAN"}, // Manchester Airport
    IataCode{"MAO"}, // Eduardo Gomes International Airport
    IataCode{"MAQ"}, // Mae Sot Airport
    IataCode{"MAR"}, // La Chinita International Airport
    IataCode{"MAS"}, // Momote Airport
    IataCode{"MAT"}, // Tshimpi Airport
    IataCode{"MAU"}, // Maupiti Airport
    IataCode{"MAV"}, // Maloelap Airport
    IataCode{"MAW"}, // Malden Regional Airport
    IataCode{"MAX"}, // Ouro Sogui Airport
    IataCode{"MAY"}, // Clarence A. Bain Airport
    IataCode{"MAZ"}, // Eugenio María de Hostos Airport
    IataCode{"MBA"}, // Moi International Airport
    IataCode{"MBC"}, // Mbigou Airport
    IataCode{"MBD"}, // Mafikeng Airport
    IataCode{"MBE"}, // Monbetsu Airport
    IataCode{"MBG"}, // Mobridge Municipal Airport
    IataCode{"MBH"}, // Maryborough Airport
    IataCode{"MBI"}, // Mbeya Airport
    IataCode{"MBJ"}, // Sangster International Airport
    IataCode{"MBK"}, // Matupá Airport
    IataCode{"MBL"}, // Manistee County Blacker Airport
    IataCode{"MBO"}, // Mamburao Airport
    IataCode{"MBP"}, // Moyobamba Airport
    IataCode{"MBQ"}, // Mbarara Airport
    IataCode{"MBS"}, // MBS International Airport
    IataCode{"MBT"}, // Moises R. Espinosa Airport
    IataCode{"MBU"}, // Mbambanakira Airport
    IataCode{"MBW"}, // Moorabbin Airport
    IataCode{"MBX"}, // Maribor Edvard Rusjan Airport
    IataCode{"MBY"}, // Malaybalay Airport
    IataCode{"MBZ"}, // Maués Airport
    IataCode{"MCA"}, // Macenta Airport
    IataCode{"MCB"}, // McComb-Pike County Airport
    IataCode{"MCC"}, // McClellan Airfield
    IataCode{"MCD"}, // Mackinac Island Airport
    IataCode{"MCE"}, // Merced Regional Airport
    IataCode{"MCG"}, // McGrath Airport
    IataCode{"MCH"}, // General Manuel Serrano Airport
    IataCode{"MCI"}, // Kansas City International Airport
    IataCode{"MCJ"}, // Jorge Isaacs Airport
    IataCode{"MCK"}, // McCook Ben Nelson Regional Airport
    IataCode{"MCL"}, // McKinley National Park Airport
    IataCode{"MCN"}, // Middle Georgia Regional Airport
    IataCode{"MCO"}, // Orlando International Airport
    IataCode{"MCP"}, // Macapá International Airport
    IataCode{"MCQ"}, // Miskolc Airport
    IataCode{"MCS"}, // Monte Caseros Airport
    IataCode{"MCT"}, // Muscat International Airport
    IataCode{"MCU"}, // Montluçon – Guéret Airport
    IataCode{"MCV"}, // McArthur River Mine Airport
    IataCode{"MCW"}, // Mason City Municipal Airport
    IataCode{"MCX"}, // Uytash Airport
    IataCode{"MCY"}, // Sunshine Coast Airport
    IataCode{"MCZ"}, // Zumbi dos Palmares International Airport
    IataCode{"MDB"}, // Melinda Airport
    IataCode{"MDC"}, // Sam Ratulangi International Airport
    IataCode{"MDD"}, // Midland Airpark
    IataCode{"MDE"}, // José María Córdova International Airport
    IataCode{"MDF"}, // Taylor County Airport
    IataCode{"MDG"}, // Mudanjiang Hailang International Airport
    IataCode{"MDH"}, // Southern Illinois Airport
    IataCode{"MDI"}, // Makurdi Airport
    IataCode{"MDJ"}, // Madras Municipal Airport
    IataCode{"MDK"}, // Mbandaka Airport
    IataCode{"MDL"}, // Mandalay International Airport
    IataCode{"MDN"}, // Madison Municipal Airport
    IataCode{"MDO"}, // Middleton Island Airport
    IataCode{"MDQ"}, // Astor Piazzolla International Airport
    IataCode{"MDS"}, // Middle Caicos Airport
    IataCode{"MDT"}, // Harrisburg International Airport
    IataCode{"MDU"}, // Mendi Airport
    IataCode{"MDV"}, // Médouneu Airport
    IataCode{"MDW"}, // Chicago Midway International Airport
    IataCode{"MDX"}, // Mercedes Airport
    IataCode{"MDY"}, // Henderson Field
    IataCode{"MDZ"}, // Governor Francisco Gabrielli International Airport
    IataCode{"MEA"}, // Mineiros Airport
    IataCode{"MEB"}, // Essendon Airport
    IataCode{"MEC"}, // Eloy Alfaro International Airport
    IataCode{"MED"}, // Prince Mohammad Bin Abdulaziz Airport
    IataCode{"MEE"}, // Maré Airport
    IataCode{"MEF"}, // Melfi Airport
    IataCode{"MEG"}, // Malanje Airport
    IataCode{"MEH"}, // Mehamn Airport
    IataCode{"MEI"}, // Meridian Regional Airport
    IataCode{"MEJ"}, // Port Meadville Airport
    IataCode{"MEL"}, // Melbourne Airport
    IataCode{"MEM"}, // Memphis International Airport
    IataCode{"MEN"}, // Mende - Brenoux Airport
    IataCode{"MEO"}, // Dare County Regional Airport
    IataCode{"MEP"}, // Mersing Airport
    IataCode{"MEQ"}, // Cut Nyak Dhien Airport
    IataCode{"MER"}, // Castle Airport
    IataCode{"MEU"}, // Monte Dourado Airport
    IataCode{"MEV"}, // Minden-Tahoe Airport
    IataCode{"MEW"}, // Mweka Airport
    IataCode{"MEX"}, // Mexico City International Airport
    IataCode{"MEY"}, // Meghauli Airport
    IataCode{"MEZ"}, // Mena Intermountain Municipal Airport
    IataCode{"MFA"}, // Mafia Airport
    IataCode{"MFC"}, // Mafeteng Airport
    IataCode{"MFD"}, // Mansfield Lahm Regional Airport
    IataCode{"MFE"}, // McAllen-Miller International Airport
    IataCode{"MFF"}, // Moanda Airport
    IataCode{"MFG"}, // Muzaffarabad Airport
    IataCode{"MFH"}, // Mesquite Airport
    IataCode{"MFI"}, // Marshfield Municipal Airport
    IataCode{"MFJ"}, // Moala Airport
    IataCode{"MFK"}, // Matsu Beigan Airport
    IataCode{"MFM"}, // Macau International Airport
    IataCode{"MFN"}, // Milford Sound Airport
    IataCode{"MFO"}, // Manguna Airport
    IataCode{"MFQ"}, // Maradi Airport
    IataCode{"MFR"}, // Rogue Valley International-Medford Airport
    IataCode{"MFS"}, // Miraflores Airport
    IataCode{"MFU"}, // Mfuwe Airport
    IataCode{"MFV"}, // Accomack County Airport
    IataCode{"MFX"}, // Méribel Airport
    IataCode{"MGA"}, // Augusto C. Sandino International Airport
    IataCode{"MGB"}, // Mount Gambier Airport
    IataCode{"MGC"}, // Michigan City Municipal Airport
    IataCode{"MGD"}, // Magdalena Airport
    IataCode{"MGE"}, // Baracoa Regional Airport
    IataCode{"MGF"}, // Maringá Regional Airport
    IataCode{"MGG"}, // Maple Lake Municipal Airport
    IataCode{"MGH"}, // Margate Airport
    IataCode{"MGI"}, // Martín García Island Airport
    IataCode{"MGJ"}, // Orange County Airport
    IataCode{"MGL"}, // Düsseldorf Mönchengladbach Airport
    IataCode{"MGM"}, // Montgomery Regional Airport
    IataCode{"MGN"}, // Baracoa Airport
    IataCode{"MGQ"}, // Aden Adde International Airport
    IataCode{"MGR"}, // Moultrie Municipal Airport
    IataCode{"MGT"}, // Milingimbi Airport
    IataCode{"MGV"}, // Margaret River Station Airport
    IataCode{"MGW"}, // Morgantown Municipal Airport
    IataCode{"MGX"}, // Moabi Airport
    IataCode{"MGY"}, // Dayton–Wright Brothers Airport
    IataCode{"MGZ"}, // Myeik Airport
    IataCode{"MHA"}, // Mahdia Airport
    IataCode{"MHC"}, // Mocopulli Airport
    IataCode{"MHD"}, // Mashhad International Airport
    IataCode{"MHE"}, // Mitchell Municipal Airport
    IataCode{"MHH"}, // Leonard M. Thompson International Airport
    IataCode{"MHI"}, // Moucha Airport
    IataCode{"MHK"}, // Manhattan Regional Airport
    IataCode{"MHL"}, // Marshall Memorial Municipal Airport
    IataCode{"MHM"}, // Minchumina Airport
    IataCode{"MHP"}, // Minsk-1 Airport
    IataCode{"MHQ"}, // Mariehamn Airport
    IataCode{"MHR"}, // Sacramento Mather Airport
    IataCode{"MHS"}, // Dunsmuir Municipal-Mott Airport
    IataCode{"MHT"}, // Manchester–Boston Regional Airport
    IataCode{"MHU"}, // Mount Hotham Airport
    IataCode{"MHV"}, // Mojave Air and Space Port
    IataCode{"MHW"}, // Monteagudo Airport
    IataCode{"MHX"}, // Manihiki Island Airport
    IataCode{"MIA"}, // Miami International Airport
    IataCode{"MIC"}, // Crystal Airport
    IataCode{"MID"}, // Manuel Crescencio Rejón International Airport
    IataCode{"MIE"}, // Delaware County Airport
    IataCode{"MIG"}, // Mianyang Nanjiao Airport
    IataCode{"MII"}, // Marília Airport
    IataCode{"MIJ"}, // Mili Airport
    IataCode{"MIK"}, // Mikkeli Airport
    IataCode{"MIM"}, // Merimbula Airport
    IataCode{"MIO"}, // Miami Municipal Airport
    IataCode{"MIP"}, // Mitzpe Ramon Airfield
    IataCode{"MIQ"}, // Millard Airport
    IataCode{"MIR"}, // Monastir Habib Bourguiba International Airport
    IataCode{"MIS"}, // Misima Airport
    IataCode{"MIT"}, // Shafter Airport
    IataCode{"MIU"}, // Maiduguri International Airport
    IataCode{"MIV"}, // Millville Municipal Airport
    IataCode{"MJA"}, // Manja Airport
    IataCode{"MJB"}, // Mejit Airport
    IataCode{"MJC"}, // Man Airport
    IataCode{"MJD"}, // Moenjodaro Airport
    IataCode{"MJE"}, // Majkin Airport
    IataCode{"MJF"}, // Mosjøen Airport
    IataCode{"MJI"}, // Mitiga International Airport
    IataCode{"MJK"}, // Shark Bay Airport
    IataCode{"MJL"}, // Mouila Airport
    IataCode{"MJM"}, // Mbuji Mayi Airport
    IataCode{"MJN"}, // Amborovy Airport
    IataCode{"MJO"}, // Mount Etjo Airport
    IataCode{"MJP"}, // Manjimup Airport
    IataCode{"MJQ"}, // Jackson Municipal Airport, Minnesota
    IataCode{"MJR"}, // Miramar Airport
    IataCode{"MJT"}, // Mytilene International Airport
    IataCode{"MJU"}, // Tampa Padang Airport
    IataCode{"MJV"}, // Murcia-San Javier Airport
    IataCode{"MJX"}, // Robert J. Miller Air Park
    IataCode{"MJZ"}, // Mirny Airport
    IataCode{"MKA"}, // Marianske Lazne Airport
    IataCode{"MKB"}, // Mékambo Airport
    IataCode{"MKC"}, // Charles B. Wheeler Downtown Airport
    IataCode{"MKE"}, // General Mitchell International Airport
    IataCode{"MKG"}, // Muskegon County Airport
    IataCode{"MKH"}, // Mokhotlong Airport
    IataCode{"MKI"}, // Poste Airport
    IataCode{"MKJ"}, // Makoua Airport
    IataCode{"MKK"}, // Molokai Airport
    IataCode{"MKL"}, // McKellar-Sipes Regional Airport
    IataCode{"MKM"}, // Mukah Airport
    IataCode{"MKN"}, // Comanche County-City Airport
    IataCode{"MKO"}, // Davis Field
    IataCode{"MKQ"}, // Mopah Airport
    IataCode{"MKR"}, // Meekatharra Airport
    IataCode{"MKS"}, // Mekane Selam Airport
    IataCode{"MKT"}, // Mankato Regional Airport
    IataCode{"MKU"}, // Makokou Airport
    IataCode{"MKW"}, // Rendani Airport
    IataCode{"MKY"}, // Mackay Airport
    IataCode{"MKZ"}, // Malacca International Airport
    IataCode{"MLA"}, // Malta International Airport
    IataCode{"MLB"}, // Melbourne International Airport
    IataCode{"MLC"}, // McAlester Regional Airport
    IataCode{"MLE"}, // Ibrahim Nasir International Airport
    IataCode{"MLG"}, // Abdul Rachman Saleh Airport
    IataCode{"MLH"}, // EuroAirport Basel-Mulhouse-Freiburg
    IataCode{"MLI"}, // Quad City International Airport
    IataCode{"MLJ"}, // Baldwin County Airport
    IataCode{"MLK"}, // Malta Airport (Montana)
    IataCode{"MLL"}, // Marshall Don Hunter Sr. Airport
    IataCode{"MLM"}, // General Francisco J. Mujica International Airport
    IataCode{"MLN"}, // Melilla Airport
    IataCode{"MLO"}, // Milos Island National Airport
    IataCode{"MLP"}, // Malabang Airport
    IataCode{"MLS"}, // Miles City Airport
    IataCode{"MLT"}, // Millinocket Municipal Airport
    IataCode{"MLU"}, // Monroe Regional Airport
    IataCode{"MLW"}, // Spriggs Payne Airport
    IataCode{"MLY"}, // Manley Hot Springs Airport
    IataCode{"MLZ"}, // Cerro Largo International Airport
    IataCode{"MMA"}, // Bulltofta Airport
    IataCode{"MMB"}, // Memanbetsu Airport
    IataCode{"MMC"}, // Ciudad Mante National Airport
    IataCode{"MMD"}, // Minami-Daito Airport
    IataCode{"MME"}, // Durham Tees Valley Airport
    IataCode{"MMF"}, // Mamfe Airport
    IataCode{"MMG"}, // Mount Magnet Airport
    IataCode{"MMH"}, // Mammoth Yosemite Airport
    IataCode{"MMI"}, // McMinn County Airport
    IataCode{"MMJ"}, // Matsumoto Airport
    IataCode{"MMK"}, // Murmansk Airport
    IataCode{"MML"}, // Southwest Minnesota Regional Airport
    IataCode{"MMM"}, // Middlemount Airport
    IataCode{"MMN"}, // Minute Man Air Field
    IataCode{"MMO"}, // Maio Airport
    IataCode{"MMP"}, // San Bernardo Airport
    IataCode{"MMQ"}, // Mbala Airport
    IataCode{"MMT"}, // McEntire Joint National Guard Base
    IataCode{"MMU"}, // Morristown Municipal Airport
    IataCode{"MMV"}, // McMinnville Municipal Airport
    IataCode{"MMX"}, // Malmö Airport
    IataCode{"MMY"}, // Miyako Airport
    IataCode{"MMZ"}, // Maimana Airfield
    IataCode{"MNA"}, // Melonguane Airport
    IataCode{"MNB"}, // Muanda Airport
    IataCode{"MNC"}, // Nacala Airport
    IataCode{"MNF"}, // Mana Island Airport
    IataCode{"MNG"}, // Maningrida Airport
    IataCode{"MNH"}, // SLAF Hingurakgoda
    IataCode{"MNI"}, // John A. Osborne Airport
    IataCode{"MNJ"}, // Mananjary Airport
    IataCode{"MNK"}, // Maiana Airport
    IataCode{"MNL"}, // Ninoy Aquino International Airport
    IataCode{"MNM"}, // Menominee-Marinette Twin County Airport
    IataCode{"MNN"}, // Marion Municipal Airport
    IataCode{"MNQ"}, // Monto Airport
    IataCode{"MNR"}, // Mongu Airport
    IataCode{"MNS"}, // Mansa Airport
    IataCode{"MNT"}, // Minto Al Wright Airport
    IataCode{"MNU"}, // Mawlamyaing Airport
    IataCode{"MNV"}, // Monroe County Airport
    IataCode{"MNX"}, // Manicoré Airport
    IataCode{"MNY"}, // Mono Airport
    IataCode{"MNZ"}, // Manassas Regional Airport
    IataCode{"MOA"}, // Orestes Acosta Airport
    IataCode{"MOB"}, // Mobile Regional Airport
    IataCode{"MOC"}, // Montes Claros Airport
    IataCode{"MOD"}, // Modesto City-County Airport
    IataCode{"MOE"}, // Momeik Airport
    IataCode{"MOF"}, // Frans Seda Airport
    IataCode{"MOG"}, // Monghsat Airport
    IataCode{"MOI"}, // Mitiaro Airport
    IataCode{"MOJ"}, // Moengo Airstrip
    IataCode{"MOL"}, // Molde Airport
    IataCode{"MOM"}, // Letfotar Airport
    IataCode{"MON"}, // Glentanner Aerodrome
    IataCode{"MOO"}, // Moomba Airport
    IataCode{"MOP"}, // Mount Pleasant Municipal Airport
    IataCode{"MOQ"}, // Morondava Airport
    IataCode{"MOR"}, // Morristown Regional Airport
    IataCode{"MOS"}, // Moses Point Airport
    IataCode{"MOT"}, // Minot International Airport
    IataCode{"MOU"}, // Mountain Village Airport
    IataCode{"MOV"}, // Moranbah Airport
    IataCode{"MOZ"}, // Moorea Airport
    IataCode{"MPA"}, // Katima Mulilo Airport
    IataCode{"MPB"}, // Miami Seaplane Base
    IataCode{"MPD"}, // Sindhri Airport
    IataCode{"MPE"}, // Griswold Airport
    IataCode{"MPG"}, // Marshall County Airport
    IataCode{"MPH"}, // Godofredo P. Ramos Airport
    IataCode{"MPJ"}, // Petit Jean Park Airport
    IataCode{"MPK"}, // Mokpo Airport
    IataCode{"MPL"}, // Montpellier – Méditerranée Airport
    IataCode{"MPM"}, // Maputo International Airport
    IataCode{"MPO"}, // Pocono Mountains Municipal Airport
    IataCode{"MPP"}, // Mulatupo Airport
    IataCode{"MPS"}, // Mount Pleasant Regional Airport (Texas)
    IataCode{"MPV"}, // Edward F. Knapp State Airport
    IataCode{"MPW"}, // Mariupol International Airport
    IataCode{"MPY"}, // Maripasoula Airport
    IataCode{"MPZ"}, // Mount Pleasant Municipal Airport
    IataCode{"MQB"}, // Macomb Municipal Airport
    IataCode{"MQC"}, // Miquelon Airport
    IataCode{"MQD"}, // Maquinchao Airport
    IataCode{"MQF"}, // Magnitogorsk International Airport
    IataCode{"MQH"}, // Minaçu Airport
    IataCode{"MQJ"}, // Moma Airport
    IataCode{"MQK"}, // San Matías Airport
    IataCode{"MQL"}, // Mildura Airport
    IataCode{"MQM"}, // Mardin Airport
    IataCode{"MQN"}, // Mo i Rana Airport
    IataCode{"MQP"}, // Kruger Mpumalanga International Airport
    IataCode{"MQQ"}, // Moundou Airport
    IataCode{"MQS"}, // Mustique Airport
    IataCode{"MQT"}, // Sawyer International Airport
    IataCode{"MQU"}, // Mariquita Airport
    IataCode{"MQV"}, // Mostaganem Airport
    IataCode{"MQW"}, // Telfair-Wheeler Airport
    IataCode{"MQX"}, // Alula Aba Nega Airport
    IataCode{"MQY"}, // Smyrna Airport
    IataCode{"MQZ"}, // Margaret River Airport
    IataCode{"MRA"}, // Misrata Airport
    IataCode{"MRB"}, // Eastern WV Regional Airport
    IataCode{"MRC"}, // Maury County Airport
    IataCode{"MRD"}, // Alberto Carnevalli Airport
    IataCode{"MRE"}, // Mara Serena Airport
    IataCode{"MRF"}, // Marfa Municipal Airport
    IataCode{"MRG"}, // Mareeba Airfield
    IataCode{"MRH"}, // Michael J. Smith Field
    IataCode{"MRI"}, // Merrill Field
    IataCode{"MRJ"}, // Marcala Airport
    IataCode{"MRK"}, // Marco Island Airport
    IataCode{"MRN"}, // Foothills Regional Airport
    IataCode{"MRO"}, // Hood Aerodrome
    IataCode{"MRQ"}, // Marinduque Airport
    IataCode{"MRR"}, // José María Velasco Ibarra Airport
    IataCode{"MRS"}, // Marseille Provence Airport
    IataCode{"MRT"}, // Union County Airport
    IataCode{"MRU"}, // Sir Seewoosagur Ramgoolam International Airport
    IataCode{"MRV"}, // Mineralnye Vody Airport
    IataCode{"MRW"}, // Lolland Falster Airport
    IataCode{"MRX"}, // Mahshahr Airport
    IataCode{"MRY"}, // Monterey Regional Airport
    IataCode{"MRZ"}, // Moree Airport
    IataCode{"MSA"}, // Muskrat Dam Airport
    IataCode{"MSC"}, // Falcon Field
    IataCode{"MSD"}, // Mount Pleasant Airport (Utah)
    IataCode{"MSE"}, // Manston Airport
    IataCode{"MSF"}, // Mount Swan Airport
    IataCode{"MSG"}, // Matsaile Airport
    IataCode{"MSJ"}, // Misawa Airport
    IataCode{"MSL"}, // Northwest Alabama Regional Airport
    IataCode{"MSM"}, // Masi-Manimba Airport
    IataCode{"MSN"}, // Panan-awan Airport
    IataCode{"MSO"}, // Missoula International Airport
    IataCode{"MSP"}, // Minneapolis–Saint Paul International Airport
    IataCode{"MSQ"}, // Minsk National Airport
    IataCode{"MSS"}, // Massena International Airport
    IataCode{"MST"}, // Maastricht Aachen Airport
    IataCode{"MSU"}, // Moshoeshoe I International Airport
    IataCode{"MSV"}, // Sullivan County International Airport
    IataCode{"MSW"}, // Massawa International Airport
    IataCode{"MSX"}, // Mossendjo Airport
    IataCode{"MSY"}, // Louis Armstrong New Orleans International Airport
    IataCode{"MSZ"}, // Namibe Airport
    IataCode{"MTA"}, // Matamata Airport
    IataCode{"MTB"}, // El Pindo Airport
    IataCode{"MTF"}, // Mizan Teferi Airport
    IataCode{"MTG"}, // Vila Bela da Santíssima Trindade Airport
    IataCode{"MTH"}, // Florida Keys Marathon Airport
    IataCode{"MTI"}, // Mosteiros Airport
    IataCode{"MTJ"}, // Montrose Regional Airport
    IataCode{"MTK"}, // Makin Airport
    IataCode{"MTL"}, // Maitland Airport
    IataCode{"MTM"}, // Metlakatla Seaplane Base
    IataCode{"MTN"}, // Martin State Airport
    IataCode{"MTO"}, // Coles County Memorial Airport
    IataCode{"MTP"}, // Montauk Airport
    IataCode{"MTQ"}, // Mitchell Airport
    IataCode{"MTR"}, // Los Garzones Airport
    IataCode{"MTS"}, // Matsapha Airport
    IataCode{"MTT"}, // Minatitlán/Coatzacoalcos National Airport
    IataCode{"MTV"}, // Mota Lava Airport
    IataCode{"MTW"}, // Manitowoc County Airport
    IataCode{"MTY"}, // Monterrey International Airport
    IataCode{"MTZ"}, // Bar Yehuda Airfield
    IataCode{"MUA"}, // Munda Airport
    IataCode{"MUB"}, // Maun Airport
    IataCode{"MUC"}, // Munich Airport
    IataCode{"MUD"}, // Mueda Airport
    IataCode{"MUE"}, // Waimea-Kohala Airport
    IataCode{"MUG"}, // Mulegé Airstrip
    IataCode{"MUH"}, // Marsa Matruh International Airport
    IataCode{"MUJ"}, // Mui Airport
    IataCode{"MUL"}, // Spence Airport
    IataCode{"MUN"}, // José Tadeo Monagas International Airport
    IataCode{"MUR"}, // Marudi Airport
    IataCode{"MUS"}, // Minami Torishima Airport
    IataCode{"MUT"}, // Muscatine Municipal Airport
    IataCode{"MUW"}, // Ghriss Airport
    IataCode{"MUX"}, // Multan International Airport
    IataCode{"MUY"}, // Mouyondzi Airport
    IataCode{"MUZ"}, // Musoma Airport
    IataCode{"MVA"}, // Mývatn Airport
    IataCode{"MVB"}, // M'Vengue El Hadj Omar Bongo Ondimba International Airport
    IataCode{"MVC"}, // Monroe County Airport
    IataCode{"MVD"}, // Carrasco International Airport
    IataCode{"MVE"}, // Montevideo–Chippewa County Airport
    IataCode{"MVF"}, // Mossoró Airport
    IataCode{"MVL"}, // Morrisville-Stowe State Airport
    IataCode{"MVM"}, // Kayenta Airport
    IataCode{"MVN"}, // Mount Vernon Airport
    IataCode{"MVO"}, // Mongo Airport
    IataCode{"MVP"}, // Fabio Alberto León Bentley Airport
    IataCode{"MVQ"}, // Mogilev Airport
    IataCode{"MVR"}, // Salak Airport
    IataCode{"MVS"}, // Mucuri Airport
    IataCode{"MVV"}, // Megève Aerodrome
    IataCode{"MVW"}, // Skagit Regional Airport
    IataCode{"MVX"}, // Minvoul Airport
    IataCode{"MVY"}, // Martha's Vineyard Airport
    IataCode{"MVZ"}, // Masvingo Airport
    IataCode{"MWA"}, // Williamson County Regional Airport
    IataCode{"MWB"}, // Morawa Airport
    IataCode{"MWC"}, // Lawrence J. Timmerman Airport
    IataCode{"MWE"}, // Merowe Airport
    IataCode{"MWF"}, // Maewo-Naone Airport
    IataCode{"MWH"}, // Grant County International Airport
    IataCode{"MWK"}, // Matak Airport
    IataCode{"MWL"}, // Mineral Wells Airport
    IataCode{"MWN"}, // Mwadui Airport
    IataCode{"MWO"}, // Middletown Regional Airport
    IataCode{"MWQ"}, // Magway Airport
    IataCode{"MWV"}, // Mondulkiri Airport
    IataCode{"MWX"}, // Muan International Airport
    IataCode{"MWZ"}, // Mwanza Airport
    IataCode{"MXA"}, // Manila Municipal Airport
    IataCode{"MXB"}, // Andi Jemma Airport
    IataCode{"MXC"}, // Monticello Airport
    IataCode{"MXE"}, // Laurinburg-Maxton Airport
    IataCode{"MXG"}, // Marlboro Airport
    IataCode{"MXH"}, // Moro Airport
    IataCode{"MXI"}, // Imelda R. Marcos Airport
    IataCode{"MXJ"}, // Minna Airport
    IataCode{"MXL"}, // General Rodolfo Sánchez Taboada International Airport
    IataCode{"MXM"}, // Morombe Airport
    IataCode{"MXN"}, // Morlaix – Ploujean Airport
    IataCode{"MXO"}, // Monticello Regional Airport
    IataCode{"MXP"}, // Milan–Malpensa Airport
    IataCode{"MXR"}, // Moussoro Airport
    IataCode{"MXS"}, // Maota Airport
    IataCode{"MXT"}, // Maintirano Airport
    IataCode{"MXU"}, // Mullewa Airport
    IataCode{"MXV"}, // Mörön Airport
    IataCode{"MXW"}, // Mandalgovi Airport
    IataCode{"MXX"}, // Mora-Siljan Airport
    IataCode{"MXY"}, // McCarthy Airport
    IataCode{"MXZ"}, // Meixian Airport
    IataCode{"MYA"}, // Moruya Airport
    IataCode{"MYB"}, // Mayumba Airport
    IataCode{"MYC"}, // Massenya Airport
    IataCode{"MYD"}, // Malindi Airport
    IataCode{"MYE"}, // Miyakejima Airport
    IataCode{"MYF"}, // Montgomery Field Airport
    IataCode{"MYG"}, // Mayaguana Airport
    IataCode{"MYH"}, // Marble Canyon Airport
    IataCode{"MYI"}, // Murray Island Airport
    IataCode{"MYJ"}, // Matsuyama Airport
    IataCode{"MYK"}, // May Creek Airport
    IataCode{"MYL"}, // McCall Municipal Airport
    IataCode{"MYM"}, // Monkey Mountain Airport
    IataCode{"MYN"}, // Marib Airport
    IataCode{"MYP"}, // Mary Airport
    IataCode{"MYQ"}, // Mysore Airport
    IataCode{"MYR"}, // Myrtle Beach International Airport
    IataCode{"MYT"}, // Myitkyina Airport
    IataCode{"MYU"}, // Mekoryuk Airport
    IataCode{"MYV"}, // Yuba County Airport
    IataCode{"MYW"}, // Mtwara Airport
    IataCode{"MYX"}, // Big Whale Cay Airport
    IataCode{"MYY"}, // Miri Airport
    IataCode{"MYZ"}, // Monkey Bay Airport
    IataCode{"MZA"}, // Manuel Prado Airport
    IataCode{"MZB"}, // Mocímboa da Praia Airport
    IataCode{"MZC"}, // Mitzic Airport
    IataCode{"MZE"}, // Manatee Airport
    IataCode{"MZI"}, // Mopti Airport
    IataCode{"MZJ"}, // Pinal Airpark
    IataCode{"MZK"}, // Marakei Airport
    IataCode{"MZL"}, // La Nubia Airport
    IataCode{"MZO"}, // Sierra Maestra Airport
    IataCode{"MZP"}, // Motueka Aerodrome
    IataCode{"MZR"}, // Mazar-i-Sharif Airport
    IataCode{"MZT"}, // General Rafael Buelna International Airport
    IataCode{"MZU"}, // Muzzafarpur Airport
    IataCode{"MZV"}, // Mulu Airport
    IataCode{"MZW"}, // Mécheria Airport
    IataCode{"MZZ"}, // Marion Municipal Airport
    IataCode{"NAA"}, // Narrabri Airport
    IataCode{"NAC"}, // Naracoorte Airport
    IataCode{"NAE"}, // Natitingou Airport
    IataCode{"NAG"}, // Dr. Babasaheb Ambedkar International Airport
    IataCode{"NAH"}, // Naha Airport
    IataCode{"NAI"}, // Annai Airport
    IataCode{"NAJ"}, // Nakhchivan Airport
    IataCode{"NAK"}, // Khorat Airport
    IataCode{"NAL"}, // Nalchik Airport
    IataCode{"NAM"}, // Namlea Airport
    IataCode{"NAN"}, // Nadi International Airport
    IataCode{"NAO"}, // Nanchong Gaoping Airport
    IataCode{"NAP"}, // Naples International Airport
    IataCode{"NAQ"}, // Qaanaaq Airport
    IataCode{"NAR"}, // Puerto Nare Airport
    IataCode{"NAS"}, // Lynden Pindling International Airport
    IataCode{"NAT"}, // Greater Natal International Airport
    IataCode{"NAU"}, // Napuka Airport
    IataCode{"NAV"}, // Nevşehir Kapadokya Airport
    IataCode{"NAW"}, // Narathiwat Airport
    IataCode{"NAY"}, // Beijing Nanyuan Airport
    IataCode{"NBB"}, // Barranco Minas Airport
    IataCode{"NBC"}, // Begishevo Airport
    IataCode{"NBE"}, // Enfidha – Hammamet International Airport
    IataCode{"NBL"}, // Wannukandi Airport
    IataCode{"NBN"}, // Annobon Airport
    IataCode{"NBO"}, // Jomo Kenyatta International Airport
    IataCode{"NBS"}, // Changbaishan Airport
    IataCode{"NBW"}, // Leeward Point Field
    IataCode{"NBX"}, // Nabire Airport
    IataCode{"NCA"}, // North Caicos Airport
    IataCode{"NCE"}, // Nice Côte d'Azur Airport
    IataCode{"NCG"}, // Nuevo Casas Grandes Airport
    IataCode{"NCH"}, // Nachingwea Airport
    IataCode{"NCI"}, // Necoclí Airport
    IataCode{"NCJ"}, // Sunchales Airport
    IataCode{"NCL"}, // Newcastle Airport
    IataCode{"NCN"}, // Chenega Bay Airport
    IataCode{"NCR"}, // San Carlos Airport
    IataCode{"NCS"}, // Newcastle Airport
    IataCode{"NCT"}, // Nicoya Guanacaste Airport
    IataCode{"NCU"}, // Nukus Airport
    IataCode{"NCY"}, // Annecy – Haute-Savoie – Mont Blanc Airport
    IataCode{"NDA"}, // Bandanaira Airport
    IataCode{"NDB"}, // Nouadhibou International Airport
    IataCode{"NDC"}, // Shri Guru Gobind Singh Ji Airport
    IataCode{"NDD"}, // Sumbe Airport
    IataCode{"NDE"}, // Mandera Airport
    IataCode{"NDF"}, // N'dalatando Airport
    IataCode{"NDG"}, // Qiqihar Sanjiazi Airport
    IataCode{"NDJ"}, // N'Djamena International Airport
    IataCode{"NDK"}, // Namorik Airport
    IataCode{"NDL"}, // N'Délé Airport
    IataCode{"NDR"}, // Nador International Airport
    IataCode{"NDU"}, // Rundu Airport
    IataCode{"NDY"}, // Sanday Airport
    IataCode{"NEC"}, // Necochea Airport
    IataCode{"NEF"}, // Neftekamsk Airport
    IataCode{"NEG"}, // Negril Aerodrome
    IataCode{"NEJ"}, // Nejjo Airport
    IataCode{"NEK"}, // Nekemte Airport
    IataCode{"NER"}, // Chulman Airport
    IataCode{"NEV"}, // Vance W. Amory International Airport
    IataCode{"NFG"}, // Nefteyugansk Airport
    IataCode{"NFO"}, // Mata'aho Airport
    IataCode{"NGA"}, // Young Airport
    IataCode{"NGB"}, // Ningbo Lishe International Airport
    IataCode{"NGD"}, // Auguste George Airport
    IataCode{"NGE"}, // Ngaoundéré Airport
    IataCode{"NGI"}, // Ngau Airport
    IataCode{"NGK"}, // Nogliki Airport
    IataCode{"NGO"}, // Chubu Centrair International Airport
    IataCode{"NGQ"}, // Ngari Gunsa Airport
    IataCode{"NGS"}, // Nagasaki Airport
    IataCode{"NGT"}, // Goliad County Industrial Airpark
    IataCode{"NGX"}, // Manang Airport
    IataCode{"NHF"}, // New Halfa Airport
    IataCode{"NHZ"}, // Brunswick Executive Airport
    IataCode{"NIA"}, // Nimba Airport
    IataCode{"NIB"}, // Nikolai Airport
    IataCode{"NIC"}, // Nicosia International Airport
    IataCode{"NIF"}, // Nifty Airport
    IataCode{"NIG"}, // Nikunau Airport
    IataCode{"NIK"}, // Niokolo-Koba Airport
    IataCode{"NIM"}, // Diori Hamani International Airport
    IataCode{"NIO"}, // Nioki Airport
    IataCode{"NIT"}, // Niort - Marais Poitevin Airport
    IataCode{"NIU"}, // Niau Airport
    IataCode{"NIX"}, // Nioro Airport
    IataCode{"NJC"}, // Nizhnevartovsk Airport
    IataCode{"NJF"}, // Al Najaf International Airport
    IataCode{"NKC"}, // Nouakchott–Oumtounsy International Airport
    IataCode{"NKG"}, // Nanjing Lukou International Airport
    IataCode{"NKL"}, // Nkolo-Fuma Airport
    IataCode{"NKM"}, // Nagoya Airfield
    IataCode{"NKS"}, // Nkongsamba Airport
    IataCode{"NKT"}, // Şırnak Airport
    IataCode{"NKU"}, // Nkaus Airport
    IataCode{"NKY"}, // Yokangassi Airport
    IataCode{"NLA"}, // Simon Mwansa Kapwepwe International Airport
    IataCode{"NLD"}, // Quetzalcóatl International Airport
    IataCode{"NLE"}, // Jerry Tyler Memorial Airport
    IataCode{"NLF"}, // Darnley Island Airport
    IataCode{"NLG"}, // Nelson Lagoon Airport
    IataCode{"NLH"}, // Lugu Lake Airport
    IataCode{"NLI"}, // Nikolayevsk-on-Amur Airport
    IataCode{"NLK"}, // Norfolk Island Airport
    IataCode{"NLN"}, // Kneeland Airport
    IataCode{"NLO"}, // N'Dolo Airport
    IataCode{"NLP"}, // Nelspruit Airport
    IataCode{"NLT"}, // Nalati Airport
    IataCode{"NLV"}, // Mykolaiv Airport
    IataCode{"NMA"}, // Namangan Airport
    IataCode{"NMB"}, // Daman Airport
    IataCode{"NMC"}, // Norman's Cay Airport
    IataCode{"NME"}, // Nightmute Airport
    IataCode{"NMG"}, // San Miguel Airport
    IataCode{"NML"}, // Fort McMurray/Mildred Lake Airport
    IataCode{"NMS"}, // Namsang Airport
    IataCode{"NNA"}, // Tourisme Airport
    IataCode{"NNB"}, // Santa Ana Airport
    IataCode{"NNG"}, // Nanning Wuxu International Airport
    IataCode{"NNI"}, // Namutoni Airport
    IataCode{"NNK"}, // Naknek Airport
    IataCode{"NNL"}, // Nondalton Airport
    IataCode{"NNM"}, // Naryan-Mar Airport
    IataCode{"NNN"}, // Sviatoshyn Airfield
    IataCode{"NNR"}, // Connemara Airport
    IataCode{"NNT"}, // Nan Nakhon Airport
    IataCode{"NNU"}, // Jorge Schieber Airport
    IataCode{"NNX"}, // Nunukan Airport
    IataCode{"NNY"}, // Nanyang Jiangying Airport
    IataCode{"NOB"}, // Nosara Airport
    IataCode{"NOC"}, // Ireland West Airport Knock
    IataCode{"NOD"}, // Norden-Norddeich Airport
    IataCode{"NOG"}, // Nogales International Airport (Mexico)
    IataCode{"NOJ"}, // Noyabrsk Airport
    IataCode{"NOK"}, // Nova Xavantina Airport
    IataCode{"NON"}, // Nonouti Airport
    IataCode{"NOP"}, // Sinop Airport
    IataCode{"NOR"}, // Norðfjörður Airport
    IataCode{"NOS"}, // Fascene Airport
    IataCode{"NOT"}, // Marin County Airport
    IataCode{"NOU"}, // La Tontouta International Airport
    IataCode{"NOV"}, // Albano Machado Airport
    IataCode{"NOZ"}, // Spichenkovo Airport
    IataCode{"NPE"}, // Hawke's Bay Airport
    IataCode{"NPL"}, // New Plymouth Airport
    IataCode{"NPO"}, // Nanga Pinoh Airport
    IataCode{"NPR"}, // Novo Progresso Airport
    IataCode{"NPT"}, // Newport State Airport
    IataCode{"NQA"}, // Millington Regional Jetport
    IataCode{"NQL"}, // Niquelândia Airport
    IataCode{"NQN"}, // Presidente Perón International Airport
    IataCode{"NQU"}, // Reyes Murillo Airport
    IataCode{"NQY"}, // Newquay Cornwall Airport
    IataCode{"NRA"}, // Narrandera Airport
    IataCode{"NRC"}, // NASA Crows Landing Airport
    IataCode{"NRD"}, // Norderney Airport
    IataCode{"NRE"}, // Namrole Airport
    IataCode{"NRG"}, // Narrogin Airport
    IataCode{"NRI"}, // Grand Lake Regional Airport
    IataCode{"NRK"}, // Norrköping Airport
    IataCode{"NRL"}, // North Ronaldsay Airport
    IataCode{"NRM"}, // Keibane Airport
    IataCode{"NRN"}, // Weeze Airport
    IataCode{"NRR"}, // José Aponte de la Torre Airport
    IataCode{"NRT"}, // Narita International Airport
    IataCode{"NSB"}, // North Bimini Airport
    IataCode{"NSH"}, // Noshahr Airport
    IataCode{"NSI"}, // Yaoundé Nsimalen International Airport
    IataCode{"NSK"}, // Alykel Airport
    IataCode{"NSM"}, // Norseman Airport
    IataCode{"NSN"}, // Nelson Airport, New Zealand
    IataCode{"NSO"}, // Scone Airport
    IataCode{"NST"}, // Nakhon Si Thammarat Airport
    IataCode{"NTB"}, // Notodden Airport
    IataCode{"NTE"}, // Nantes Atlantique Airport
    IataCode{"NTG"}, // Nantong Xingdong Airport
    IataCode{"NTN"}, // Normanton Airport
    IataCode{"NTQ"}, // Noto Airport
    IataCode{"NTR"}, // Del Norte International Airport
    IataCode{"NTT"}, // Niuatoputapu Airport
    IataCode{"NTX"}, // Ranai Airport
    IataCode{"NTY"}, // Pilanesberg International Airport
    IataCode{"NUB"}, // Numbulwar Airport
    IataCode{"NUD"}, // En Nahud Airport
    IataCode{"NUE"}, // Nuremberg Airport
    IataCode{"NUI"}, // Nuiqsut Airport
    IataCode{"NUK"}, // Nukutavake Airport
    IataCode{"NUL"}, // Nulato Airport
    IataCode{"NUN"}, // Saufley Field
    IataCode{"NUP"}, // Nunapitchuk Airport
    IataCode{"NUQ"}, // Moffett Federal Airfield
    IataCode{"NUS"}, // Norsup Airport
    IataCode{"NUU"}, // Nakuru Airport
    IataCode{"NUX"}, // Novy Urengoy Airport
    IataCode{"NVA"}, // Benito Salas Airport
    IataCode{"NVG"}, // Nueva Guinea Airport
    IataCode{"NVI"}, // Navoi International Airport
    IataCode{"NVJ"}, // Navojoa Airport
    IataCode{"NVK"}, // Narvik Airport, Framnes
    IataCode{"NVN"}, // Nervino Airport
    IataCode{"NVR"}, // Novgorod Airport
    IataCode{"NVS"}, // Nevers-Fourchambault Airport
    IataCode{"NVT"}, // Ministro Victor Konder International Airport
    IataCode{"NWA"}, // Mohéli Bandar Es Eslam Airport
    IataCode{"NWH"}, // Parlin Field
    IataCode{"NWI"}, // Norwich International Airport
    IataCode{"NXP"}, // Twentynine Palms Strategic Expeditionary Landing Field
    IataCode{"NYA"}, // Nyagan Airport
    IataCode{"NYE"}, // Nyeri Airport
    IataCode{"NYI"}, // Sunyani Airport
    IataCode{"NYK"}, // Nanyuki Airport
    IataCode{"NYM"}, // Nadym Airport
    IataCode{"NYN"}, // Nyngan Airport
    IataCode{"NYO"}, // Stockholm Skavsta Airport
    IataCode{"NYR"}, // Nyurba Airport
    IataCode{"NYT"}, // Naypyidaw Airport
    IataCode{"NYU"}, // Nyaung U Airport
    IataCode{"NZA"}, // Nzagi Airport
    IataCode{"NZC"}, // Maria Reiche Neuman Airport
    IataCode{"NZE"}, // Nzérékoré Airport
    IataCode{"NZH"}, // Manzhouli Xijiao Airport
    IataCode{"NZK"}, // Karamea Airport
    IataCode{"NZL"}, // Zhalantun Airport
    IataCode{"OAG"}, // Orange Airport
    IataCode{"OAJ"}, // Albert J. Ellis Airport
    IataCode{"OAK"}, // Oakland International Airport
    IataCode{"OAL"}, // Cacoal Airport
    IataCode{"OAM"}, // Oamaru Airport
    IataCode{"OAN"}, // El Arrayán Airport
    IataCode{"OAR"}, // Marina Municipal Airport
    IataCode{"OAS"}, // Sharana Airstrip
    IataCode{"OAX"}, // Xoxocotlán International Airport
    IataCode{"OBC"}, // Obock Airport
    IataCode{"OBE"}, // Okeechobee County Airport
    IataCode{"OBF"}, // Oberpfaffenhofen Airport
    IataCode{"OBI"}, // Tirios Airport
    IataCode{"OBN"}, // Oban Airport
    IataCode{"OBO"}, // Tokachi-Obihiro Airport
    IataCode{"OBS"}, // Aubenas Aerodrome
    IataCode{"OBU"}, // Kobuk Airport
    IataCode{"OBX"}, // Obo Airport
    IataCode{"OCA"}, // Ocean Reef Club Airport
    IataCode{"OCC"}, // Francisco de Orellana Airport
    IataCode{"OCE"}, // Ocean City Municipal Airport
    IataCode{"OCF"}, // Ocala International Airport
    IataCode{"OCJ"}, // Ian Fleming International Airport
    IataCode{"OCM"}, // Boolgeeda Airport
    IataCode{"OCN"}, // Oceanside Municipal Airport
    IataCode{"OCS"}, // Corisco International Airport
    IataCode{"OCV"}, // Aguas Claras Airport
    IataCode{"ODA"}, // Ouadda Airport
    IataCode{"ODB"}, // Córdoba Airport
    IataCode{"ODC"}, // Oakdale Airport
    IataCode{"ODE"}, // Hans Christian Andersen Airport
    IataCode{"ODJ"}, // Ouanda Djallé Airport
    IataCode{"ODM"}, // Garrett County Airport
    IataCode{"ODN"}, // Long Seridan Airport
    IataCode{"ODO"}, // Bodaybo Airport
    IataCode{"ODS"}, // Odessa International Airport
    IataCode{"ODW"}, // A.J. Eisenberg Airport
    IataCode{"ODY"}, // Oudomsay Airport
    IataCode{"OEA"}, // O'Neal Airport
    IataCode{"OEB"}, // Branch County Memorial Airport
    IataCode{"OEC"}, // Oecusse Airport
    IataCode{"OEL"}, // Oryol Yuzhny Airport
    IataCode{"OEM"}, // Vincent Fayks Airport
    IataCode{"OEO"}, // L.O. Simenstad Municipal Airport
    IataCode{"OER"}, // Örnsköldsvik Airport
    IataCode{"OES"}, // Antoine de Saint Exupéry Airport
    IataCode{"OET"}, // Thumamah Airport
    IataCode{"OFI"}, // Ouango Fitini Airport
    IataCode{"OFJ"}, // Ólafsfjörður Airport
    IataCode{"OFK"}, // Norfolk Regional Airport
    IataCode{"OFP"}, // Hanover County Municipal Airport
    IataCode{"OFU"}, // Ofu Airport
    IataCode{"OGB"}, // Orangeburg Municipal Airport
    IataCode{"OGD"}, // Ogden-Hinckley Airport
    IataCode{"OGG"}, // Kahului Airport
    IataCode{"OGL"}, // Eugene F. Correia International Airport - Ogle
    IataCode{"OGM"}, // Ustupu-Ogobsucum Airport
    IataCode{"OGN"}, // Yonaguni Airport
    IataCode{"OGO"}, // Abengourou Airport
    IataCode{"OGR"}, // Bongor Airport
    IataCode{"OGS"}, // Ogdensburg International Airport
    IataCode{"OGU"}, // Ordu Giresun Airport
    IataCode{"OGX"}, // Ain Beida Airport
    IataCode{"OGZ"}, // Beslan Airport
    IataCode{"OHA"}, // RNZAF Base Ohakea
    IataCode{"OHD"}, // Ohrid "St. Paul the Apostle" Airport
    IataCode{"OHE"}, // Mohe Gulian Airport
    IataCode{"OHH"}, // Okha Airport
    IataCode{"OHI"}, // Oshakati Airport
    IataCode{"OHS"}, // Sohar Airport
    IataCode{"OIA"}, // Ourilândia do Norte Airport
    IataCode{"OIC"}, // Lt. Warren Eaton Airport
    IataCode{"OIM"}, // Oshima Airport
    IataCode{"OIR"}, // Okushiri Airport
    IataCode{"OIT"}, // Oita Airport
    IataCode{"OJA"}, // Thomas P. Stafford Airport
    IataCode{"OJC"}, // Johnson County Executive Airport
    IataCode{"OKA"}, // Naha Airport
    IataCode{"OKC"}, // Will Rogers World Airport
    IataCode{"OKD"}, // Okadama Airport
    IataCode{"OKE"}, // Okinoerabu Airport
    IataCode{"OKF"}, // Okaukuejo Airport
    IataCode{"OKG"}, // Okoyo Airport
    IataCode{"OKI"}, // Oki Airport
    IataCode{"OKJ"}, // Okayama Airport
    IataCode{"OKK"}, // Kokomo Municipal Airport
    IataCode{"OKL"}, // Oksibil Airport
    IataCode{"OKM"}, // Okmulgee Regional Airport
    IataCode{"OKN"}, // Okondja Airport
    IataCode{"OKR"}, // Yorke Island Airport
    IataCode{"OKS"}, // Kōnan Airport
    IataCode{"OKT"}, // Oktyabrsky Airport
    IataCode{"OKU"}, // Mokuti Lodge Airport
    IataCode{"OLA"}, // Ørland Airport
    IataCode{"OLB"}, // Olbia Costa Smeralda Airport
    IataCode{"OLC"}, // São Paulo de Olivença Airport
    IataCode{"OLD"}, // Old Town Municipal Airport and Seaplane Base
    IataCode{"OLE"}, // Cattaraugus County-Olean Airport
    IataCode{"OLF"}, // L. M. Clayton Airport
    IataCode{"OLH"}, // Old Harbor Airport
    IataCode{"OLI"}, // Rif Airport
    IataCode{"OLJ"}, // Olpoi Airport
    IataCode{"OLL"}, // Oyo Ollombo Airport
    IataCode{"OLM"}, // Olympia Regional Airport
    IataCode{"OLN"}, // Sarmiento Airport
    IataCode{"OLO"}, // Olomouc Airport
    IataCode{"OLP"}, // Olympic Dam Airport
    IataCode{"OLS"}, // Nogales International Airport
    IataCode{"OLU"}, // Columbus Municipal Airport
    IataCode{"OLV"}, // Olive Branch Airport
    IataCode{"OLZ"}, // Olyokminsk Airport
    IataCode{"OMA"}, // Eppley Airfield
    IataCode{"OMB"}, // Omboué Hospital Airport
    IataCode{"OMC"}, // Ormoc Airport
    IataCode{"OMD"}, // Oranjemund Airport
    IataCode{"OME"}, // Nome Airport
    IataCode{"OMG"}, // Omega Airport
    IataCode{"OMH"}, // Urmia Airport
    IataCode{"OMK"}, // Omak Airport
    IataCode{"OMM"}, // Marmul, OOMX Airport
    IataCode{"OMN"}, // Osmanabad Airport
    IataCode{"OMO"}, // Mostar International Airport
    IataCode{"OMR"}, // Oradea International Airport
    IataCode{"OMS"}, // Omsk Tsentralny Airport
    IataCode{"OMY"}, // Thbeng Meanchey Airport
    IataCode{"ONA"}, // Winona Municipal Airport
    IataCode{"OND"}, // Ondangwa Airport
    IataCode{"ONG"}, // Mornington Island Airport
    IataCode{"ONH"}, // Oneonta Municipal Airport
    IataCode{"ONJ"}, // Odate-Noshiro Airport
    IataCode{"ONK"}, // Olenyok Airport
    IataCode{"ONL"}, // O'Neill Municipal Airport
    IataCode{"ONO"}, // Ontario Municipal Airport
    IataCode{"ONP"}, // Newport Municipal Airport
    IataCode{"ONQ"}, // Zonguldak Airport
    IataCode{"ONS"}, // Onslow Airport
    IataCode{"ONT"}, // LA/Ontario International Airport
    IataCode{"ONX"}, // Enrique Adolfo Jiménez Airport
    IataCode{"ONZ"}, // Grosse Ile Municipal Airport
    IataCode{"OOD"}, // Oodnadatta Airport
    IataCode{"OOK"}, // Toksook Bay Airport
    IataCode{"OOL"}, // Gold Coast Airport
    IataCode{"OOM"}, // Cooma – Snowy Mountains Airport
    IataCode{"OOT"}, // Onotoa Airport
    IataCode{"OPA"}, // Kópasker Airport
    IataCode{"OPF"}, // Opa-locka Airport
    IataCode{"OPI"}, // Oenpelli Airport
    IataCode{"OPL"}, // St. Landry Parish Airport
    IataCode{"OPO"}, // Francisco de Sá Carneiro Airport
    IataCode{"OPS"}, // Sinop Airport
    IataCode{"OPU"}, // Balimo Airport
    IataCode{"OPW"}, // Opuwa Airport
    IataCode{"OQN"}, // Brandywine Airport
    IataCode{"OQU"}, // Quonset State Airport
    IataCode{"ORA"}, // Orán Airport
    IataCode{"ORB"}, // Örebro Airport
    IataCode{"ORC"}, // Orocue Airport
    IataCode{"ORD"}, // O'Hare International Airport
    IataCode{"ORE"}, // Orléans – Saint-Denis-de-l'Hôtel Airport
    IataCode{"ORF"}, // Norfolk International Airport
    IataCode{"ORG"}, // Zorg en Hoop Airport
    IataCode{"ORH"}, // Worcester Regional Airport
    IataCode{"ORI"}, // Port Lions Airport
    IataCode{"ORJ"}, // Orinduik Airport
    IataCode{"ORK"}, // Cork Airport
    IataCode{"ORL"}, // Orlando Executive Airport
    IataCode{"ORM"}, // Sywell Aerodrome
    IataCode{"ORN"}, // Oran Es Sénia Airport
    IataCode{"ORO"}, // Yoro Airport
    IataCode{"ORP"}, // Orapa Airport
    IataCode{"ORT"}, // Northway Airport
    IataCode{"ORU"}, // Juan Mendoza Airport
    IataCode{"ORV"}, // Robert (Bob) Curtis Memorial Airport
    IataCode{"ORW"}, // Ormara Airport
    IataCode{"ORX"}, // Oriximiná Airport
    IataCode{"ORY"}, // Orly Airport
    IataCode{"ORZ"}, // Orange Walk Airport
    IataCode{"OSC"}, // Oscoda-Wurtsmith Airport
    IataCode{"OSD"}, // Åre Östersund Airport
    IataCode{"OSF"}, // Ostafyevo International Airport
    IataCode{"OSH"}, // Wittman Regional Airport
    IataCode{"OSI"}, // Osijek Airport
    IataCode{"OSL"}, // Oslo Airport
    IataCode{"OSM"}, // Mosul International Airport
    IataCode{"OSO"}, // Osborne Mine Airport
    IataCode{"OSP"}, // Słupsk-Redzikowo Airport
    IataCode{"OSR"}, // Leoš Janáček Airport Ostrava
    IataCode{"OSS"}, // Osh Airport
    IataCode{"OST"}, // Ostend-Bruges International Airport
    IataCode{"OSU"}, // Ohio State University Airport
    IataCode{"OSW"}, // Orsk Airport
    IataCode{"OSY"}, // Namsos Airport
    IataCode{"OSZ"}, // Koszalin-Zegrze Pomorskie Airport
    IataCode{"OTC"}, // Bol Airport
    IataCode{"OTD"}, // Contadora Airport
    IataCode{"OTH"}, // Southwest Oregon Regional Airport
    IataCode{"OTI"}, // Pitu Airport
    IataCode{"OTJ"}, // Otjiwarongo Airport
    IataCode{"OTL"}, // Boutilimit Airport
    IataCode{"OTM"}, // Ottumwa Regional Airport
    IataCode{"OTN"}, // Ed-Air Airport
    IataCode{"OTP"}, // Henri Coandă International Airport
    IataCode{"OTR"}, // Coto 47 Airport
    IataCode{"OTS"}, // Anacortes Airport
    IataCode{"OTU"}, // Otú Airport
    IataCode{"OTZ"}, // Ralph Wien Memorial Airport
    IataCode{"OUA"}, // Ouagadougou Airport
    IataCode{"OUD"}, // Angads Airport
    IataCode{"OUE"}, // Ouésso Airport
    IataCode{"OUG"}, // Ouahigouya Airport
    IataCode{"OUL"}, // Oulu Airport
    IataCode{"OUM"}, // Oum Hadjer Airport
    IataCode{"OUN"}, // University of Oklahoma Westheimer Airport
    IataCode{"OUR"}, // Batouri Airport
    IataCode{"OUS"}, // Ourinhos Airport
    IataCode{"OUT"}, // Bousso Airport
    IataCode{"OUZ"}, // Tazadit Airport
    IataCode{"OVB"}, // Tolmachevo Airport
    IataCode{"OVD"}, // Asturias Airport
    IataCode{"OVE"}, // Oroville Municipal Airport
    IataCode{"OVL"}, // El Tuqui Airport
    IataCode{"OVR"}, // Olavarría Airport
    IataCode{"OVS"}, // Boscobel Airport
    IataCode{"OWB"}, // Owensboro-Daviess County Regional Airport
    IataCode{"OWD"}, // Norwood Memorial Airport
    IataCode{"OWI"}, // Ottawa Municipal Airport
    IataCode{"OWK"}, // Central Maine Airport of Norridgewock
    IataCode{"OWP"}, // William R. Pogue Municipal Airport
    IataCode{"OXB"}, // Osvaldo Vieira International Airport
    IataCode{"OXC"}, // Waterbury-Oxford Airport
    IataCode{"OXD"}, // Miami University Airport
    IataCode{"OXF"}, // London Oxford Airport
    IataCode{"OYA"}, // Goya Airport
    IataCode{"OYE"}, // Oyem Airport
    IataCode{"OYG"}, // Moyo Airport
    IataCode{"OYK"}, // Oiapoque Airport
    IataCode{"OYL"}, // Moyale Airport
    IataCode{"OYO"}, // Tres Arroyos Airport
    IataCode{"OYP"}, // Saint-Georges-de-l'Oyapock Airport
    IataCode{"OZC"}, // Labo Airport
    IataCode{"OZG"}, // Zagora Airport
    IataCode{"OZH"}, // Zaporizhzhia International Airport
    IataCode{"OZS"}, // Camdenton Memorial Airport
    IataCode{"OZW"}, // Livingston County Spencer J. Hardy Airport
    IataCode{"OZZ"}, // Ouarzazate Airport
    IataCode{"PAA"}, // Hpa-An Airport
    IataCode{"PAB"}, // Bilaspur Airport
    IataCode{"PAC"}, // Albrook "Marcos A. Gelabert" International Airport
    IataCode{"PAD"}, // Paderborn Lippstadt Airport
    IataCode{"PAE"}, // Paine Field
    IataCode{"PAF"}, // Pakuba Airport
    IataCode{"PAG"}, // Pagadian Airport
    IataCode{"PAH"}, // Barkley Regional Airport
    IataCode{"PAJ"}, // Parachinar Airport
    IataCode{"PAK"}, // Port Allen Airport
    IataCode{"PAL"}, // Café Airport
    IataCode{"PAN"}, // Pattani Airport
    IataCode{"PAO"}, // Palo Alto Airport of Santa Clara County
    IataCode{"PAP"}, // Toussaint Louverture International Airport
    IataCode{"PAQ"}, // Palmer Municipal Airport
    IataCode{"PAS"}, // Paros National Airport
    IataCode{"PAT"}, // Lok Nayak Jayaprakash Airport
    IataCode{"PAV"}, // Paulo Afonso Airport
    IataCode{"PAX"}, // Port-de-Paix Airport
    IataCode{"PAZ"}, // El Tajín National Airport
    IataCode{"PBC"}, // Hermanos Serdán International Airport
    IataCode{"PBD"}, // Porbandar Airport
    IataCode{"PBE"}, // Morela Airport
    IataCode{"PBF"}, // Grider Field
    IataCode{"PBG"}, // Plattsburgh International Airport
    IataCode{"PBH"}, // Paro Airport
    IataCode{"PBI"}, // Palm Beach International Airport
    IataCode{"PBJ"}, // Paama Airport
    IataCode{"PBL"}, // General Bartolomé Salom Airport
    IataCode{"PBM"}, // Johan Adolf Pengel International Airport
    IataCode{"PBN"}, // Porto Amboim Airport
    IataCode{"PBO"}, // Paraburdoo Airport
    IataCode{"PBP"}, // Punta Islita Airport
    IataCode{"PBQ"}, // Pimenta Bueno Airport
    IataCode{"PBR"}, // Puerto Barrios Airport
    IataCode{"PBU"}, // Putao Airport
    IataCode{"PBV"}, // Porto Dos Gaúchos Airport
    IataCode{"PBZ"}, // Plettenberg Bay Airport
    IataCode{"PCA"}, // Portage Creek Airport
    IataCode{"PCB"}, // Pondok Cabe Airport
    IataCode{"PCD"}, // Prairie du Chien Municipal Airport
    IataCode{"PCH"}, // Palacios Airport
    IataCode{"PCL"}, // FAP Captain David Abensur Rengifo International Airport
    IataCode{"PCM"}, // Plant City Airport
    IataCode{"PCN"}, // Picton Aerodrome
    IataCode{"PCO"}, // Punta Colorada Airstrip
    IataCode{"PCP"}, // Príncipe Airport
    IataCode{"PCR"}, // Germán Olano Airport
    IataCode{"PCS"}, // Picos Airport
    IataCode{"PCT"}, // Princeton Airport
    IataCode{"PCW"}, // Erie-Ottawa International Airport
    IataCode{"PCZ"}, // Waupaca Municipal Airport
    IataCode{"PDA"}, // Obando Airport
    IataCode{"PDB"}, // Pedro Bay Airport
    IataCode{"PDD"}, // Ponta do Ouro Airport
    IataCode{"PDG"}, // Tabing Airport
    IataCode{"PDK"}, // DeKalb-Peachtree Airport
    IataCode{"PDL"}, // João Paulo II Airport
    IataCode{"PDO"}, // Pendopo Airport
    IataCode{"PDP"}, // Capitán de Corbeta Carlos A. Curbelo International Airport
    IataCode{"PDS"}, // Piedras Negras International Airport
    IataCode{"PDU"}, // Paysandú Airport
    IataCode{"PDX"}, // Portland International Airport
    IataCode{"PDZ"}, // Pedernales Airport
    IataCode{"PEC"}, // Pelican Seaplane Base
    IataCode{"PED"}, // Pardubice Airport
    IataCode{"PEE"}, // Bolshoye Savino Airport
    IataCode{"PEF"}, // Peenemünde Airfield
    IataCode{"PEG"}, // Perugia San Francesco d'Assisi – Umbria International Airport
    IataCode{"PEH"}, // Comodoro P. Zanni Airport
    IataCode{"PEI"}, // Matecaña International Airport
    IataCode{"PEK"}, // Beijing Capital International Airport
    IataCode{"PEL"}, // Pelaneng Airport
    IataCode{"PEM"}, // Padre Aldamiz International Airport
    IataCode{"PEN"}, // Penang International Airport
    IataCode{"PEO"}, // Penn Yan Airport
    IataCode{"PEQ"}, // Pecos Municipal Airport
    IataCode{"PER"}, // Perth Airport
    IataCode{"PES"}, // Petrozavodsk Airport
    IataCode{"PET"}, // Pelotas International Airport
    IataCode{"PEU"}, // Puerto Lempira Airport
    IataCode{"PEW"}, // Bacha Khan International Airport
    IataCode{"PEX"}, // Pechora Airport
    IataCode{"PEZ"}, // Penza Airport
    IataCode{"PFB"}, // Lauro Kurtz Airport
    IataCode{"PFC"}, // Pacific City State Airport
    IataCode{"PFJ"}, // Patreksfjörður Airport
    IataCode{"PFN"}, // Panama City–Bay County International Airport
    IataCode{"PFO"}, // Paphos International Airport
    IataCode{"PFQ"}, // Parsabad-Moghan Airport
    IataCode{"PFR"}, // Ilebo Airport
    IataCode{"PGA"}, // Page Municipal Airport
    IataCode{"PGB"}, // Progar Airport
    IataCode{"PGC"}, // Grant County Airport
    IataCode{"PGD"}, // Punta Gorda Airport
    IataCode{"PGF"}, // Perpignan–Rivesaltes Airport
    IataCode{"PGH"}, // Pantnagar Airport
    IataCode{"PGI"}, // Chitato Airport
    IataCode{"PGK"}, // Depati Amir Airport
    IataCode{"PGL"}, // Trent Lott International Airport
    IataCode{"PGM"}, // Port Graham Airport
    IataCode{"PGN"}, // Pignon Airport
    IataCode{"PGP"}, // Porto Alegre Airport
    IataCode{"PGR"}, // Kirk Field
    IataCode{"PGS"}, // Grand Canyon Caverns Airport
    IataCode{"PGU"}, // Persian Gulf Airport
    IataCode{"PGV"}, // Pitt-Greenville Airport
    IataCode{"PGX"}, // Périgueux Bassillac Airport
    IataCode{"PGZ"}, // Ponta Grossa Airport
    IataCode{"PHB"}, // Parnaíba-Prefeito Dr. João Silva Filho International Airport
    IataCode{"PHC"}, // Port Harcourt International Airport
    IataCode{"PHD"}, // Harry Clever Field
    IataCode{"PHE"}, // Port Hedland International Airport
    IataCode{"PHF"}, // Newport News/Williamsburg International Airport
    IataCode{"PHG"}, // Port Harcourt City Airport
    IataCode{"PHI"}, // Pinheiro Airport
    IataCode{"PHK"}, // Palm Beach County Glades Airport
    IataCode{"PHL"}, // Philadelphia International Airport
    IataCode{"PHM"}, // Böblingen Airport
    IataCode{"PHN"}, // St. Clair County International Airport
    IataCode{"PHO"}, // Point Hope Airport
    IataCode{"PHQ"}, // The Monument Airport
    IataCode{"PHS"}, // Phitsanulok Airport
    IataCode{"PHT"}, // Henry County Airport
    IataCode{"PHW"}, // Hendrik Van Eck Airport
    IataCode{"PHX"}, // Phoenix Sky Harbor International Airport
    IataCode{"PHY"}, // Phetchabun Airport
    IataCode{"PIA"}, // Peoria International Airport
    IataCode{"PIB"}, // Hattiesburg-Laurel Regional Airport
    IataCode{"PIC"}, // Pine Cay Airport
    IataCode{"PID"}, // New Providence Airport
    IataCode{"PIE"}, // St. Petersburg–Clearwater International Airport
    IataCode{"PIF"}, // Pingtung Airport
    IataCode{"PIG"}, // Pigue Airport
    IataCode{"PIH"}, // Pocatello Regional Airport
    IataCode{"PIK"}, // Glasgow Prestwick Airport
    IataCode{"PIL"}, // Carlos Miguel Jiménez Airport
    IataCode{"PIM"}, // Harris County Airport
    IataCode{"PIN"}, // Parintins Airport
    IataCode{"PIO"}, // Capitán FAP Renán Elías Olivera Airport
    IataCode{"PIP"}, // Pilot Point Airport
    IataCode{"PIR"}, // Pierre Regional Airport
    IataCode{"PIS"}, // Poitiers – Biard Airport
    IataCode{"PIT"}, // Pittsburgh International Airport
    IataCode{"PIU"}, // Cap. FAP Guillermo Concha Iberico International Airport
    IataCode{"PIW"}, // Pikwitonei Airport
    IataCode{"PIX"}, // Pico Airport
    IataCode{"PIZ"}, // Point Lay LRRS Airport
    IataCode{"PJA"}, // Pajala Airport
    IataCode{"PJB"}, // Payson Airport
    IataCode{"PJC"}, // Dr. Augusto Roberto Fuster International Airport
    IataCode{"PJG"}, // Panjgur Airport
    IataCode{"PJM"}, // Puerto Jiménez Airport
    IataCode{"PKA"}, // Napaskiak Airport
    IataCode{"PKB"}, // Mid-Ohio Valley Regional Airport
    IataCode{"PKC"}, // Petropavlovsk-Kamchatsky Airport
    IataCode{"PKE"}, // Parkes Airport
    IataCode{"PKF"}, // Park Falls Municipal Airport
    IataCode{"PKG"}, // Pangkor Airport
    IataCode{"PKH"}, // Porto Cheli Airport
    IataCode{"PKJ"}, // Playa Grande Airport
    IataCode{"PKK"}, // Pakokku Airport
    IataCode{"PKN"}, // Iskandar Airport
    IataCode{"PKO"}, // Parakou Airport
    IataCode{"PKP"}, // Puka-Puka Airport
    IataCode{"PKR"}, // Pokhara Airport
    IataCode{"PKT"}, // Port Keats Airfield
    IataCode{"PKU"}, // Sultan Syarif Kasim II Airport
    IataCode{"PKV"}, // Pskov Airport
    IataCode{"PKW"}, // Selebi-Phikwe Airport
    IataCode{"PKY"}, // Tjilik Riwut Airport
    IataCode{"PKZ"}, // Pakse International Airport
    IataCode{"PLB"}, // Clinton County Airport
    IataCode{"PLD"}, // Carrillo Airport
    IataCode{"PLF"}, // Pala Airport
    IataCode{"PLH"}, // Plymouth City Airport
    IataCode{"PLJ"}, // Placencia Airport
    IataCode{"PLK"}, // M. Graham Clark Field, Taney County Airport
    IataCode{"PLL"}, // Ponta Pelada Airport
    IataCode{"PLM"}, // Sultan Mahmud Badaruddin II International Airport
    IataCode{"PLN"}, // Pellston Regional Airport
    IataCode{"PLO"}, // Port Lincoln Airport
    IataCode{"PLQ"}, // Palanga International Airport
    IataCode{"PLR"}, // St. Clair County Airport
    IataCode{"PLS"}, // Providenciales International Airport
    IataCode{"PLT"}, // Plato Airport
    IataCode{"PLU"}, // Belo Horizonte/Pampulha – Carlos Drummond de Andrade Airport
    IataCode{"PLV"}, // Poltava Airport
    IataCode{"PLW"}, // Mutiara Airport
    IataCode{"PLX"}, // Semey Airport
    IataCode{"PLY"}, // Plymouth Municipal Airport (Indiana)
    IataCode{"PLZ"}, // Port Elizabeth Airport
    IataCode{"PMA"}, // Pemba Airport
    IataCode{"PMB"}, // Pembina Municipal Airport
    IataCode{"PMC"}, // El Tepual Airport
    IataCode{"PMD"}, // LA/Palmdale Regional Airport
    IataCode{"PMF"}, // Parma Airport
    IataCode{"PMG"}, // Ponta Porã International Airport
    IataCode{"PMH"}, // Greater Portsmouth Regional Airport
    IataCode{"PMI"}, // Palma de Mallorca Airport
    IataCode{"PMK"}, // Palm Island Airport
    IataCode{"PML"}, // Port Moller Airport
    IataCode{"PMO"}, // Falcone–Borsellino Airport
    IataCode{"PMQ"}, // Perito Moreno Airport
    IataCode{"PMR"}, // Palmerston North International Airport
    IataCode{"PMS"}, // Palmyra Airport
    IataCode{"PMV"}, // Del Caribe "Santiago Mariño" International Airport
    IataCode{"PMW"}, // Palmas Airport
    IataCode{"PMX"}, // Metropolitan Airport
    IataCode{"PMY"}, // El Tehuelche Airport
    IataCode{"PMZ"}, // Palmar Sur Airport
    IataCode{"PNA"}, // Pamplona Airport
    IataCode{"PNB"}, // Porto Nacional Airport
    IataCode{"PNC"}, // Ponca City Regional Airport
    IataCode{"PND"}, // Punta Gorda Airport
    IataCode{"PNE"}, // Northeast Philadelphia Airport
    IataCode{"PNG"}, // Paranaguá Airport
    IataCode{"PNH"}, // Phnom Penh International Airport
    IataCode{"PNI"}, // Pohnpei International Airport
    IataCode{"PNK"}, // Supadio Airport
    IataCode{"PNL"}, // Pantelleria Airport
    IataCode{"PNM"}, // Princeton Municipal Airport
    IataCode{"PNN"}, // Princeton Municipal Airport (Maine)
    IataCode{"PNP"}, // Girua Airport
    IataCode{"PNQ"}, // Pune Airport
    IataCode{"PNR"}, // Pointe Noire Airport
    IataCode{"PNS"}, // Pensacola International Airport
    IataCode{"PNT"}, // Teniente Julio Gallardo Airport
    IataCode{"PNU"}, // Panguitch Municipal Airport
    IataCode{"PNX"}, // North Texas Regional Airport
    IataCode{"PNY"}, // Pondicherry Airport
    IataCode{"PNZ"}, // Petrolina Airport
    IataCode{"POA"}, // Salgado Filho International Airport
    IataCode{"POC"}, // Brackett Field
    IataCode{"POD"}, // Podor Airport
    IataCode{"POG"}, // Port-Gentil International Airport
    IataCode{"POI"}, // Captain Nicolas Rojas Airport
    IataCode{"POJ"}, // Patos de Minas Airport
    IataCode{"POL"}, // Pemba Airport
    IataCode{"POM"}, // Jacksons International Airport
    IataCode{"PON"}, // Poptún Airport
    IataCode{"POO"}, // Poços de Caldas Airport
    IataCode{"POP"}, // Gregorio Luperón International Airport
    IataCode{"POR"}, // Pori Airport
    IataCode{"POS"}, // Piarco International Airport
    IataCode{"POT"}, // Ken Jones Aerodrome
    IataCode{"POU"}, // Hudson Valley Regional Airport
    IataCode{"POV"}, // Portage County Regional Airport
    IataCode{"POW"}, // Portorož Airport
    IataCode{"POX"}, // Pontoise – Cormeilles Aerodrome
    IataCode{"POZ"}, // Poznań-Ławica Airport
    IataCode{"PPB"}, // Presidente Prudente Airport
    IataCode{"PPC"}, // Prospect Creek Airport
    IataCode{"PPE"}, // Puerto Peñasco International Airport
    IataCode{"PPF"}, // Tri-City Airport (Kansas)
    IataCode{"PPG"}, // Pago Pago International Airport
    IataCode{"PPH"}, // Parai-tepuí Airport
    IataCode{"PPI"}, // Port Pirie Airport
    IataCode{"PPK"}, // Petropavl Airport
    IataCode{"PPL"}, // Phaplu Airport
    IataCode{"PPM"}, // Pompano Beach Airpark
    IataCode{"PPN"}, // Guillermo León Valencia Airport
    IataCode{"PPP"}, // Whitsunday Coast Airport
    IataCode{"PPQ"}, // Kapiti Coast Airport
    IataCode{"PPR"}, // Tuanku Tambusai Airport
    IataCode{"PPS"}, // Puerto Princesa International Airport
    IataCode{"PPT"}, // Faa'a International Airport
    IataCode{"PPV"}, // Port Protection Seaplane Base
    IataCode{"PPW"}, // Papa Westray Airport
    IataCode{"PPY"}, // Pouso Alegre Airport
    IataCode{"PPZ"}, // Puerto Páez Airport
    IataCode{"PQC"}, // Phu Quoc International Airport
    IataCode{"PQI"}, // Northern Maine Regional Airport at Presque Isle
    IataCode{"PQM"}, // Palenque International Airport
    IataCode{"PQQ"}, // Port Macquarie Airport
    IataCode{"PQS"}, // Pilot Station Airport
    IataCode{"PRA"}, // General Justo José de Urquiza Airport
    IataCode{"PRB"}, // Paso Robles Municipal Airport
    IataCode{"PRC"}, // Ernest A. Love Field
    IataCode{"PRG"}, // Prague Václav Havel Airport
    IataCode{"PRH"}, // Phrae Airport
    IataCode{"PRI"}, // Praslin Island Airport
    IataCode{"PRM"}, // Portimão Airport
    IataCode{"PRN"}, // Pristina International Airport Adem Jashari
    IataCode{"PRO"}, // Perry Municipal Airport
    IataCode{"PRP"}, // Propriano Airport
    IataCode{"PRQ"}, // Presidencia Roque Sáenz Peña Airport
    IataCode{"PRR"}, // Paruima Airport
    IataCode{"PRV"}, // Přerov Airport
    IataCode{"PRW"}, // Prentice Airport
    IataCode{"PRX"}, // Cox Field
    IataCode{"PRY"}, // Wonderboom Airport
    IataCode{"PRZ"}, // Prineville Airport
    IataCode{"PSA"}, // Pisa International Airport
    IataCode{"PSB"}, // Mid-State Regional Airport
    IataCode{"PSC"}, // Tri-Cities Airport
    IataCode{"PSD"}, // Port Said Airport
    IataCode{"PSE"}, // Mercedita Airport
    IataCode{"PSF"}, // Pittsfield Municipal Airport
    IataCode{"PSG"}, // Petersburg James A. Johnson Airport
    IataCode{"PSI"}, // Pasni Airport
    IataCode{"PSJ"}, // Kasiguncu Airport
    IataCode{"PSK"}, // New River Valley Airport
    IataCode{"PSL"}, // Perth Airport
    IataCode{"PSM"}, // Portsmouth International Airport at Pease
    IataCode{"PSO"}, // Antonio Nariño Airport
    IataCode{"PSP"}, // Palm Springs International Airport
    IataCode{"PSQ"}, // Philadelphia Seaplane Base
    IataCode{"PSR"}, // Abruzzo Airport
    IataCode{"PSS"}, // Libertador General José de San Martín Airport
    IataCode{"PST"}, // Preston Airport
    IataCode{"PSU"}, // Pangsuma Airport
    IataCode{"PSV"}, // Papa Stour Airport
    IataCode{"PSX"}, // Palacios Municipal Airport
    IataCode{"PSY"}, // Port Stanley Airport
    IataCode{"PSZ"}, // Puerto Suárez International Airport
    IataCode{"PTA"}, // Port Alsworth Airport
    IataCode{"PTD"}, // Port Alexander Seaplane Base
    IataCode{"PTF"}, // Malolo Lailai Airport
    IataCode{"PTG"}, // Polokwane International Airport
    IataCode{"PTH"}, // Port Heiden Airport
    IataCode{"PTJ"}, // Portland Airport
    IataCode{"PTK"}, // Oakland County International Airport
    IataCode{"PTM"}, // Palmarito Airport
    IataCode{"PTN"}, // Harry P. Williams Memorial Airport
    IataCode{"PTO"}, // Pato Branco Airport
    IataCode{"PTP"}, // Pointe-à-Pitre International Airport
    IataCode{"PTS"}, // Atkinson Municipal Airport
    IataCode{"PTT"}, // Pratt Regional Airport
    IataCode{"PTU"}, // Platinum Airport
    IataCode{"PTV"}, // Porterville Municipal Airport
    IataCode{"PTW"}, // Heritage Field Airport
    IataCode{"PTX"}, // Contador Airport
    IataCode{"PTY"}, // Tocumen International Airport
    IataCode{"PTZ"}, // Rio Amazonas Airport
    IataCode{"PUB"}, // Pueblo Memorial Airport
    IataCode{"PUD"}, // Puerto Deseado Airport
    IataCode{"PUE"}, // Puerto Obaldia Airport
    IataCode{"PUF"}, // Pau Pyrénées Airport
    IataCode{"PUG"}, // Port Augusta Airport
    IataCode{"PUJ"}, // Punta Cana International Airport
    IataCode{"PUK"}, // Pukarua Airport
    IataCode{"PUM"}, // Sangia Nibandera Airport
    IataCode{"PUN"}, // Punia Airport
    IataCode{"PUP"}, // Pô Airport
    IataCode{"PUQ"}, // Presidente Carlos Ibáñez del Campo International Airport
    IataCode{"PUR"}, // Puerto Rico Airport
    IataCode{"PUS"}, // Gimhae International Airport
    IataCode{"PUT"}, // Sri Sathya Sai Airport
    IataCode{"PUU"}, // Tres de Mayo Airport
    IataCode{"PUW"}, // Pullman-Moscow Regional Airport
    IataCode{"PUX"}, // El Mirador Airport
    IataCode{"PUY"}, // Pula Airport
    IataCode{"PUZ"}, // Puerto Cabezas Airport
    IataCode{"PVA"}, // El Embrujo Airport
    IataCode{"PVB"}, // Platteville Municipal Airport
    IataCode{"PVC"}, // Provincetown Municipal Airport
    IataCode{"PVD"}, // T. F. Green Airport
    IataCode{"PVE"}, // El Porvenir Airport
    IataCode{"PVF"}, // Placerville Airport
    IataCode{"PVG"}, // Shanghai Pudong International Airport
    IataCode{"PVH"}, // Governador Jorge Teixeira de Oliveira International Airport
    IataCode{"PVI"}, // Paranavaí Airport
    IataCode{"PVK"}, // Aktion National Airport
    IataCode{"PVL"}, // Pike County Airport
    IataCode{"PVO"}, // Reales Tamarindos Airport
    IataCode{"PVP"}, // Palo Verde Airport
    IataCode{"PVR"}, // Licenciado Gustavo Díaz Ordaz International Airport
    IataCode{"PVS"}, // Provideniya Bay Airport
    IataCode{"PVU"}, // Provo Municipal Airport
    IataCode{"PVW"}, // Hale County Airport
    IataCode{"PWA"}, // Wiley Post Airport
    IataCode{"PWD"}, // Sher-Wood Airport
    IataCode{"PWE"}, // Pevek Airport
    IataCode{"PWK"}, // Chicago Executive Airport
    IataCode{"PWL"}, // Purwokerto Airport
    IataCode{"PWM"}, // Portland International Jetport
    IataCode{"PWN"}, // Pitts Town Airport
    IataCode{"PWO"}, // Pweto Airport
    IataCode{"PWQ"}, // Pavlodar Airport
    IataCode{"PWT"}, // Bremerton National Airport
    IataCode{"PWY"}, // Ralph Wenz Field
    IataCode{"PXA"}, // Q17998449
    IataCode{"PXE"}, // Perry-Houston County Airport
    IataCode{"PXH"}, // Prominent Hill Airport
    IataCode{"PXL"}, // Polacca Airport
    IataCode{"PXM"}, // Puerto Escondido International Airport
    IataCode{"PXO"}, // Porto Santo Airport
    IataCode{"PXR"}, // Surin Pakdi Airport
    IataCode{"PXU"}, // Pleiku Airport
    IataCode{"PYA"}, // Velasquez Airport
    IataCode{"PYB"}, // Jeypore Airport
    IataCode{"PYC"}, // Playón Chico Airport
    IataCode{"PYE"}, // Tongareva Airport
    IataCode{"PYH"}, // Cacique Aramare Airport
    IataCode{"PYJ"}, // Polyarny Airport
    IataCode{"PYK"}, // Payam International Airport
    IataCode{"PYM"}, // Plymouth Municipal Airport
    IataCode{"PYO"}, // Putumayo Airport
    IataCode{"PYP"}, // Centre–Piedmont–Cherokee County Regional Airport
    IataCode{"PYS"}, // Paradise Skypark
    IataCode{"PYY"}, // Pai Airport
    IataCode{"PZA"}, // Paz de Ariporo Airport
    IataCode{"PZB"}, // Pietermaritzburg Airport
    IataCode{"PZH"}, // Zhob Airport
    IataCode{"PZI"}, // Panzhihua Bao'anying Airport
    IataCode{"PZO"}, // Manuel Carlos Piar Guayana Airport
    IataCode{"PZS"}, // Maquehue Airport
    IataCode{"PZU"}, // Port Sudan New International Airport
    IataCode{"PZY"}, // Piešťany Airport
    IataCode{"QAJ"}, // Ajman International Airport
    IataCode{"QAK"}, // Maj Brig Doorgal Borges Airport
    IataCode{"QAM"}, // Amiens – Glisy Aerodrome
    IataCode{"QAQ"}, // L'Aquila Preturo Airport
    IataCode{"QAS"}, // Chlef International Airport
    IataCode{"QBC"}, // Bella Coola Airport
    IataCode{"QBG"}, // Pančevo Airport
    IataCode{"QBQ"}, // Besançon – La Vèze Aerodrome
    IataCode{"QBS"}, // Verona Boscomantico
    IataCode{"QCN"}, // Canela Airport
    IataCode{"QCP"}, // Botucatu Airport
    IataCode{"QDC"}, // Dracena Airport
    IataCode{"QDF"}, // Bandeirinhas/Conselheiro Lafaiete Airport
    IataCode{"QDJ"}, // Tsletsi Airport
    IataCode{"QDV"}, // Jundiaí Airport
    IataCode{"QFD"}, // Boufarik Airport
    IataCode{"QFG"}, // Eqalugaarsuit Heliport
    IataCode{"QFN"}, // Narsaq Kujalleq Heliport
    IataCode{"QFO"}, // Duxford Aerodrome
    IataCode{"QFR"}, // Frosinone Airport
    IataCode{"QGF"}, // Montenegro Airport
    IataCode{"QGP"}, // Garanhuns Airport
    IataCode{"QGU"}, // Gifu Air Field
    IataCode{"QGY"}, // Győr-Pér International Airport
    IataCode{"QHB"}, // Pedro Morganti Airport
    IataCode{"QHP"}, // Base De Aviacao De Taubate Airport
    IataCode{"QHR"}, // Harar Meda Airport
    IataCode{"QJB"}, // Jubail Airport
    IataCode{"QJH"}, // Qassimiut Heliport
    IataCode{"QJL"}, // Kjøllefjord Airport
    IataCode{"QKE"}, // Milliken Airport
    IataCode{"QKX"}, // Kautokeino Airport
    IataCode{"QKZ"}, // Konstanz Airport
    IataCode{"QLA"}, // Lasham Airfield
    IataCode{"QLD"}, // Blida Airport
    IataCode{"QMF"}, // Mafra Airport
    IataCode{"QMH"}, // Oum el Bouaghi Airport
    IataCode{"QMJ"}, // Shahid Asyaee Airport
    IataCode{"QMM"}, // Massa-Cinquale Airport
    IataCode{"QMZ"}, // Mainz Finthen Airport
    IataCode{"QNC"}, // Neuchâtel Airport
    IataCode{"QND"}, // Novi Sad Airport
    IataCode{"QNJ"}, // Annemasse Aerodrome
    IataCode{"QNM"}, // Namur-Suarlee Airport
    IataCode{"QNV"}, // Aeroclub, Nova Iguacu Airport
    IataCode{"QNX"}, // Mâcon - Charnay Airport
    IataCode{"QNY"}, // New York Skyports Inc. Seaplane Base
    IataCode{"QOJ"}, // São Borja Airport
    IataCode{"QOW"}, // Sam Mbakwe Airport
    IataCode{"QPA"}, // Padua Airport
    IataCode{"QPD"}, // Pinar del Río Airport
    IataCode{"QPH"}, // Palapye Airport
    IataCode{"QPJ"}, // Pécs-Pogány International Airport
    IataCode{"QPS"}, // Campo Fontenelle Airport
    IataCode{"QRA"}, // Rand Airport
    IataCode{"QRC"}, // Independencia Airport
    IataCode{"QRE"}, // Carazinho Airport
    IataCode{"QRM"}, // Narromine Airport
    IataCode{"QRO"}, // Querétaro International Airport
    IataCode{"QRR"}, // Warren Airport
    IataCode{"QRT"}, // Rieti Airport
    IataCode{"QRV"}, // Arras – Roclincourt Airport
    IataCode{"QRW"}, // Warri Airport
    IataCode{"QSA"}, // Sabadell Airport
    IataCode{"QSC"}, // São Carlos Airport
    IataCode{"QSF"}, // Ain Arnat Airport
    IataCode{"QSI"}, // Moshi Airport
    IataCode{"QSN"}, // San Nicolás de Bari Airport
    IataCode{"QSR"}, // Salerno Costa d'Amalfi Airport
    IataCode{"QSX"}, // New Amsterdam Airport
    IataCode{"QTK"}, // Rothenburg/Görlitz Airport
    IataCode{"QUB"}, // Ubari Airport
    IataCode{"QUG"}, // Chichester/Goodwood Airport
    IataCode{"QUO"}, // Akwa Ibom Airport
    IataCode{"QUS"}, // Gusau Airstrip
    IataCode{"QUT"}, // Utsunomiya Air Field
    IataCode{"QVA"}, // Varese-Venegono Airport
    IataCode{"QVP"}, // Avaré-Arandu Airport
    IataCode{"QWG"}, // Wilgrove Air Park
    IataCode{"QWV"}, // Valjevo Airport
    IataCode{"QXB"}, // Aix-en-Provence Aerodrome
    IataCode{"QYO"}, // Dajtki Airport
    IataCode{"QYR"}, // Troyes – Barberey Airport
    IataCode{"QYY"}, // Białystok-Krywlany Airport
    IataCode{"QZN"}, // Relizane Airport
    IataCode{"RAB"}, // Rabaul Airport
    IataCode{"RAC"}, // John H. Batten Airport
    IataCode{"RAE"}, // Arar Domestic Airport
    IataCode{"RAF"}, // Rafaela Aerodrome
    IataCode{"RAH"}, // Rafha Domestic Airport
    IataCode{"RAI"}, // Praia International Airport
    IataCode{"RAJ"}, // Rajkot Airport
    IataCode{"RAK"}, // Marrakesh Menara Airport
    IataCode{"RAL"}, // Riverside Municipal Airport
    IataCode{"RAM"}, // Ramingining Airport
    IataCode{"RAN"}, // Ravenna Airport
    IataCode{"RAO"}, // Leite Lopes Airport
    IataCode{"RAP"}, // Rapid City Regional Airport
    IataCode{"RAQ"}, // Sugimanuru Airport
    IataCode{"RAR"}, // Rarotonga International Airport
    IataCode{"RAS"}, // Rasht Airport
    IataCode{"RAT"}, // Raduzhny Airport
    IataCode{"RAV"}, // Cravo Norte Airport
    IataCode{"RAW"}, // Warsaw Municipal Airport (Missouri)
    IataCode{"RAZ"}, // Rawalakot Airport
    IataCode{"RBA"}, // Rabat-Salé Airport
    IataCode{"RBB"}, // Borba Airport
    IataCode{"RBC"}, // Robinvale Airport
    IataCode{"RBD"}, // Dallas Executive Airport
    IataCode{"RBE"}, // Ratanakiri Airport
    IataCode{"RBF"}, // Big Bear City Airport
    IataCode{"RBG"}, // Roseburg Regional Airport
    IataCode{"RBJ"}, // Rebun Airport
    IataCode{"RBK"}, // French Valley Airport
    IataCode{"RBL"}, // Red Bluff Municipal Airport
    IataCode{"RBM"}, // Straubing Wallmühle Airport
    IataCode{"RBO"}, // Robore Airport
    IataCode{"RBQ"}, // Rurrenabaque Airport
    IataCode{"RBR"}, // Rio Branco International Airport
    IataCode{"RBS"}, // Orbost Airport
    IataCode{"RBT"}, // Marsabit Airport
    IataCode{"RBV"}, // Ramata Airport
    IataCode{"RBW"}, // Lowcountry Regional Airport
    IataCode{"RBX"}, // Rumbek Airport
    IataCode{"RBY"}, // Ruby Airport
    IataCode{"RCB"}, // Richards Bay Airport
    IataCode{"RCE"}, // Roche Harbor Seaplane Base
    IataCode{"RCH"}, // Almirante Padilla Airport
    IataCode{"RCL"}, // Redcliffe Airport
    IataCode{"RCM"}, // Richmond Airport
    IataCode{"RCP"}, // Rooks County Regional Airport
    IataCode{"RCQ"}, // Reconquista Airport
    IataCode{"RCR"}, // Fulton County Airport
    IataCode{"RCS"}, // Rochester Airport
    IataCode{"RCT"}, // Nartron Field
    IataCode{"RCU"}, // Las Higueras Airport
    IataCode{"RCX"}, // Rusk County Airport
    IataCode{"RCY"}, // Port Nelson Airport
    IataCode{"RCZ"}, // Richmond County Airport
    IataCode{"RDB"}, // Red Dog Airport
    IataCode{"RDC"}, // Redenção Airport
    IataCode{"RDD"}, // Redding Municipal Airport
    IataCode{"RDG"}, // Reading Regional Airport
    IataCode{"RDK"}, // Red Oak Municipal Airport
    IataCode{"RDM"}, // Roberts Field
    IataCode{"RDN"}, // Redang Airport
    IataCode{"RDO"}, // Radom-Sadków Airport
    IataCode{"RDP"}, // Kazi Nazrul Islam Airport
    IataCode{"RDS"}, // Rincón de los Sauces Airport
    IataCode{"RDT"}, // Richard Toll Airport
    IataCode{"RDU"}, // Raleigh–Durham International Airport
    IataCode{"RDV"}, // Red Devil Airport
    IataCode{"RDZ"}, // Rodez-Aveyron Airport
    IataCode{"REA"}, // Reao Airport
    IataCode{"REB"}, // Müritz Airpark
    IataCode{"REC"}, // Recife/Guararapes–Gilberto Freyre International Airport
    IataCode{"RED"}, // Mifflin County Airport
    IataCode{"REG"}, // Reggio Calabria Airport
    IataCode{"REI"}, // Régina Airport
    IataCode{"REL"}, // Almirante Marcos A. Zar Airport
    IataCode{"REN"}, // Orenburg Tsentralny Airport
    IataCode{"REO"}, // Rome State Airport
    IataCode{"REP"}, // Siem Reap International Airport
    IataCode{"RER"}, // Retalhuleu Airport
    IataCode{"RES"}, // Resistencia International Airport
    IataCode{"RET"}, // Røst Airport
    IataCode{"REU"}, // Reus Airport
    IataCode{"REX"}, // General Lucio Blanco International Airport
    IataCode{"REY"}, // Reyes Airport
    IataCode{"REZ"}, // Resende Airport
    IataCode{"RFA"}, // Rafaï Airport
    IataCode{"RFD"}, // Chicago Rockford International Airport
    IataCode{"RFI"}, // Rusk County Airport
    IataCode{"RFN"}, // Raufarhöfn Airport
    IataCode{"RFP"}, // Raiatea Airport
    IataCode{"RFS"}, // Rosita Airport
    IataCode{"RGA"}, // Rio Grande Airport
    IataCode{"RGH"}, // Balurghat Airport
    IataCode{"RGI"}, // Rangiroa Airport
    IataCode{"RGK"}, // Gorno-Altaysk Airport
    IataCode{"RGL"}, // Piloto Civil Norberto Fernández International Airport
    IataCode{"RGN"}, // Yangon International Airport
    IataCode{"RGO"}, // Chongjin Airport
    IataCode{"RGS"}, // Burgos Airport
    IataCode{"RGT"}, // Japura Airport
    IataCode{"RHD"}, // Las Termas Airport
    IataCode{"RHG"}, // Ruhengeri Airport
    IataCode{"RHI"}, // Rhinelander–Oneida County Airport
    IataCode{"RHO"}, // Rhodes Maritsa Airport
    IataCode{"RHP"}, // Ramechhap Airport
    IataCode{"RHT"}, // Alxa Right Banner Badanjilin Airport
    IataCode{"RHV"}, // Reid-Hillview Airport
    IataCode{"RIA"}, // Santa Maria Airport
    IataCode{"RIB"}, // Riberalta Airport
    IataCode{"RIC"}, // Richmond International Airport
    IataCode{"RID"}, // Richmond Municipal Airport
    IataCode{"RIE"}, // Rice Lake Regional Airport
    IataCode{"RIG"}, // Rio Grande Airport
    IataCode{"RIH"}, // Río Hato Airport
    IataCode{"RIJ"}, // Juan Simons Vela Airport
    IataCode{"RIL"}, // Garfield County Regional Airport
    IataCode{"RIN"}, // Ringi Cove Airport
    IataCode{"RIR"}, // Flabob Airport
    IataCode{"RIS"}, // Rishiri Airport
    IataCode{"RIU"}, // Rancho Murieta Airport
    IataCode{"RIW"}, // Riverton Regional Airport
    IataCode{"RIX"}, // Riga International Airport
    IataCode{"RIY"}, // Riyan Airport
    IataCode{"RIZ"}, // Rizhao Shanzihe Airport
    IataCode{"RJA"}, // Rajahmundry Airport
    IataCode{"RJH"}, // Shah Makhdum Airport
    IataCode{"RJK"}, // Rijeka Airport
    IataCode{"RJL"}, // Logroño-Agoncillo Airport
    IataCode{"RJN"}, // Rafsanjan Airport
    IataCode{"RKC"}, // Montague Airport
    IataCode{"RKD"}, // Knox County Regional Airport
    IataCode{"RKE"}, // Roskilde Airport
    IataCode{"RKH"}, // Rock Hill/York County Airport
    IataCode{"RKI"}, // Rokot Airport
    IataCode{"RKP"}, // Aransas County Airport
    IataCode{"RKR"}, // Robert S. Kerr Airport
    IataCode{"RKS"}, // Rock Springs–Sweetwater County Airport
    IataCode{"RKT"}, // Ras Al Khaimah International Airport
    IataCode{"RKV"}, // Reykjavík Airport
    IataCode{"RKW"}, // Rockwood Municipal Airport
    IataCode{"RKZ"}, // Shigatse Peace Airport
    IataCode{"RLD"}, // Richland Airport
    IataCode{"RLG"}, // Rostock Airport
    IataCode{"RLK"}, // Bayannur Tianjitai Airport
    IataCode{"RLO"}, // Sta. Rosa De Conlara Airport
    IataCode{"RLT"}, // Arlit Airport
    IataCode{"RMA"}, // Roma Airport
    IataCode{"RMB"}, // Buraimi Airport
    IataCode{"RMD"}, // Ramagundam Airport
    IataCode{"RME"}, // Griffiss International Airport
    IataCode{"RMF"}, // Marsa Alam International Airport
    IataCode{"RMG"}, // Richard B. Russell Airport
    IataCode{"RMI"}, // Federico Fellini International Airport
    IataCode{"RMK"}, // Renmark Airport
    IataCode{"RML"}, // Ratmalana Airport
    IataCode{"RMN"}, // Stafford Regional Airport
    IataCode{"RMP"}, // Rampart Airport
    IataCode{"RMT"}, // Rimatara Airport
    IataCode{"RMU"}, // International airport of the Region of Murcia
    IataCode{"RMY"}, // Mariposa-Yosemite Airport
    IataCode{"RNA"}, // Ulawa Airport
    IataCode{"RNB"}, // Ronneby Airport
    IataCode{"RNC"}, // Warren County Memorial Airport
    IataCode{"RNE"}, // Roanne Airport
    IataCode{"RNH"}, // New Richmond Regional Airport
    IataCode{"RNI"}, // Corn Island Airport
    IataCode{"RNJ"}, // Yoron Airport
    IataCode{"RNL"}, // Rennell/Tingoa Airport
    IataCode{"RNM"}, // Qarn Alam Airport
    IataCode{"RNN"}, // Bornholm Airport
    IataCode{"RNO"}, // Reno–Tahoe International Airport
    IataCode{"RNP"}, // Rongelap Airport
    IataCode{"RNS"}, // Rennes – Saint-Jacques Airport
    IataCode{"RNT"}, // Renton Municipal Airport
    IataCode{"RNV"}, // Cleveland Municipal Airport
    IataCode{"RNZ"}, // Jasper County Airport
    IataCode{"ROA"}, // Roanoke–Blacksburg Regional Airport
    IataCode{"ROB"}, // Roberts International Airport
    IataCode{"ROC"}, // Greater Rochester International Airport
    IataCode{"ROD"}, // Robertson Airfield
    IataCode{"ROG"}, // Rogers Municipal Airport
    IataCode{"ROI"}, // Roi Et Airport
    IataCode{"ROK"}, // Rockhampton Airport
    IataCode{"RON"}, // Juan José Rondón Airport
    IataCode{"ROO"}, // Rondonópolis Airport
    IataCode{"ROP"}, // Rota International Airport
    IataCode{"ROR"}, // Roman Tmetuchl International Airport
    IataCode{"ROS"}, // Rosario – Islas Malvinas International Airport
    IataCode{"ROT"}, // Rotorua International Airport
    IataCode{"ROV"}, // Platov International Airport
    IataCode{"ROW"}, // Roswell International Air Center
    IataCode{"ROY"}, // Río Mayo Airport
    IataCode{"RPB"}, // Belleville Municipal Airport
    IataCode{"RPJ"}, // Rochelle Municipal Airport
    IataCode{"RPK"}, // Reims – Prunay Aerodrome
    IataCode{"RPM"}, // Ngukurr Airport
    IataCode{"RPN"}, // Rosh Pina Airport
    IataCode{"RPR"}, // Swami Vivekananda Airport
    IataCode{"RPX"}, // Roundup Airport
    IataCode{"RQE"}, // Window Rock Airport
    IataCode{"RQO"}, // El Reno Regional Airport
    IataCode{"RRG"}, // Sir Gaëtan Duval Airport
    IataCode{"RRK"}, // Rourkela Airport
    IataCode{"RRL"}, // Merrill Municipal Airport
    IataCode{"RRR"}, // Raroia Airport
    IataCode{"RRS"}, // Røros Airport
    IataCode{"RRT"}, // Warroad International Airport
    IataCode{"RSA"}, // Santa Rosa Airport
    IataCode{"RSD"}, // Rock Sound International Airport
    IataCode{"RSE"}, // Rose Bay Water Airport
    IataCode{"RSH"}, // Russian Mission Airport
    IataCode{"RSJ"}, // Rosario Seaplane Base
    IataCode{"RSN"}, // Ruston Regional Airport
    IataCode{"RSS"}, // Damazin Airport
    IataCode{"RST"}, // Rochester International Airport
    IataCode{"RSU"}, // Yeosu Airport
    IataCode{"RSV"}, // Crawford County Airport
    IataCode{"RSW"}, // Southwest Florida International Airport
    IataCode{"RTA"}, // Rotuma Airport
    IataCode{"RTB"}, // Juan Manuel Gálvez International Airport
    IataCode{"RTC"}, // Ratnagiri Airport
    IataCode{"RTG"}, // Q12474106
    IataCode{"RTL"}, // Spirit Lake Municipal Airport
    IataCode{"RTM"}, // Rotterdam The Hague Airport
    IataCode{"RTN"}, // Raton Municipal Airport
    IataCode{"RTS"}, // Rottnest Island Airport
    IataCode{"RTW"}, // Saratov Tsentralny Airport
    IataCode{"RUA"}, // Arua Airport
    IataCode{"RUD"}, // Shahroud Airport
    IataCode{"RUE"}, // Russellville Regional Airport
    IataCode{"RUG"}, // Rugby Municipal Airport
    IataCode{"RUH"}, // King Khalid International Airport
    IataCode{"RUI"}, // Sierra Blanca Regional Airport
    IataCode{"RUK"}, // Rukumkot Airport
    IataCode{"RUM"}, // Rumjatar Airport
    IataCode{"RUN"}, // Roland Garros Airport
    IataCode{"RUP"}, // Rupsi Airport
    IataCode{"RUR"}, // Rurutu Airport
    IataCode{"RUS"}, // Marau Airport
    IataCode{"RUT"}, // Rutland Southern Vermont Regional Airport
    IataCode{"RUV"}, // Rubelsanto Airport
    IataCode{"RUY"}, // Copán Ruinas Airport
    IataCode{"RVA"}, // Farafangana Airport
    IataCode{"RVD"}, // Rio Verde Airport
    IataCode{"RVE"}, // Los Colonizadores Airport
    IataCode{"RVH"}, // Rzhevka Airport
    IataCode{"RVI"}, // Rostov-on-Don Airport
    IataCode{"RVK"}, // Rørvik Airport
    IataCode{"RVN"}, // Rovaniemi Airport
    IataCode{"RVR"}, // Green River Municipal Airport
    IataCode{"RVS"}, // Richard Lloyd Jones Jr. Airport
    IataCode{"RVT"}, // Ravensthorpe Airport
    IataCode{"RVV"}, // Raivavae Airport
    IataCode{"RVY"}, // Rivera International Airport
    IataCode{"RWI"}, // Rocky Mount-Wilson Regional Airport
    IataCode{"RWL"}, // Rawlins Municipal Airport
    IataCode{"RWN"}, // Rivne International Airport
    IataCode{"RWV"}, // Caldwell Municipal Airport
    IataCode{"RXE"}, // Rexburg-Madison County Airport
    IataCode{"RXS"}, // Roxas Airport
    IataCode{"RYB"}, // Staroselye Airport
    IataCode{"RYG"}, // Moss Airport, Rygge
    IataCode{"RYK"}, // Shaikh Zayed International Airport
    IataCode{"RYN"}, // Ryan Airfield
    IataCode{"RYO"}, // Rio Turbio Airport
    IataCode{"RYV"}, // Watertown Municipal Airport
    IataCode{"RYY"}, // Cobb County Airport
    IataCode{"RZA"}, // Santa Cruz Airport, Argentina
    IataCode{"RZE"}, // Rzeszów-Jasionka Airport
    IataCode{"RZN"}, // Turlatovo Airport
    IataCode{"RZP"}, // Taytay Airport
    IataCode{"RZR"}, // Ramsar Airport
    IataCode{"RZS"}, // Sawan Airport
    IataCode{"RZZ"}, // Halifax County Airport
    IataCode{"SAA"}, // Shively Field
    IataCode{"SAB"}, // Juancho E. Yrausquin Airport
    IataCode{"SAC"}, // Sacramento Executive Airport
    IataCode{"SAD"}, // Safford Regional Airport
    IataCode{"SAF"}, // Santa Fe Municipal Airport
    IataCode{"SAG"}, // Shirdi Airport
    IataCode{"SAH"}, // Sana'a International Airport
    IataCode{"SAK"}, // Sauðárkrókur Airport
    IataCode{"SAL"}, // Monseñor Óscar Arnulfo Romero International Airport
    IataCode{"SAM"}, // Salamo Airport
    IataCode{"SAN"}, // San Diego International Airport
    IataCode{"SAP"}, // Ramón Villeda Morales International Airport
    IataCode{"SAQ"}, // San Andros Airport
    IataCode{"SAS"}, // Salton Sea Airport
    IataCode{"SAT"}, // San Antonio International Airport
    IataCode{"SAU"}, // Tardamu Airport
    IataCode{"SAV"}, // Savannah/Hilton Head International Airport
    IataCode{"SAW"}, // Sabiha Gökçen International Airport
    IataCode{"SAY"}, // Siena-Ampugnano Airport
    IataCode{"SAZ"}, // Sasstown Airport
    IataCode{"SBA"}, // Santa Barbara Municipal Airport
    IataCode{"SBB"}, // Santa Bárbara de Barinas Airport
    IataCode{"SBD"}, // San Bernardino International Airport
    IataCode{"SBF"}, // Sardeh Band Airport
    IataCode{"SBG"}, // Maimun Saleh Airport
    IataCode{"SBH"}, // Gustaf III Airport
    IataCode{"SBI"}, // Sambailo Airport
    IataCode{"SBJ"}, // Sao Mateus Airport
    IataCode{"SBK"}, // Saint-Brieuc – Armor Airport
    IataCode{"SBL"}, // Santa Ana del Yacuma Airport
    IataCode{"SBM"}, // Sheboygan County Memorial Airport
    IataCode{"SBN"}, // South Bend Regional Airport
    IataCode{"SBO"}, // Salina-Gunnison Airport
    IataCode{"SBP"}, // San Luis Obispo County Regional Airport
    IataCode{"SBQ"}, // Sibi Airport
    IataCode{"SBR"}, // Saibai Island Airport
    IataCode{"SBS"}, // Steamboat Springs Airport
    IataCode{"SBT"}, // Sabetta International Airport
    IataCode{"SBW"}, // Sibu Airport
    IataCode{"SBX"}, // Shelby Airport
    IataCode{"SBY"}, // Salisbury–Ocean City–Wicomico Regional Airport
    IataCode{"SBZ"}, // Sibiu International Airport
    IataCode{"SCB"}, // Scribner State Airport
    IataCode{"SCC"}, // Deadhorse Airport
    IataCode{"SCD"}, // Sylacauga Municipal Airport
    IataCode{"SCE"}, // University Park Airport
    IataCode{"SCF"}, // Scottsdale Airport
    IataCode{"SCH"}, // Schenectady County Airport
    IataCode{"SCI"}, // Paramillo Airport
    IataCode{"SCK"}, // Stockton Metropolitan Airport
    IataCode{"SCL"}, // Comodoro Arturo Merino Benítez International Airport
    IataCode{"SCM"}, // Scammon Bay Airport
    IataCode{"SCN"}, // Saarbrücken Airport
    IataCode{"SCO"}, // Aktau Airport
    IataCode{"SCP"}, // Mont-Dauphin - Saint-Crépin Airport
    IataCode{"SCQ"}, // Santiago de Compostela Airport
    IataCode{"SCS"}, // Scatsta Airport
    IataCode{"SCT"}, // Socotra Airport
    IataCode{"SCU"}, // Antonio Maceo Airport
    IataCode{"SCV"}, // Suceava Airport
    IataCode{"SCW"}, // Syktyvkar Airport
    IataCode{"SCX"}, // Salina Cruz Airport
    IataCode{"SCY"}, // San Cristóbal Airport
    IataCode{"SCZ"}, // Santa Cruz/Graciosa Bay/Luova Airport
    IataCode{"SDC"}, // Williamson–Sodus Airport
    IataCode{"SDD"}, // Lubango Airport
    IataCode{"SDE"}, // Vicecomodoro Ángel de la Paz Aragonés Airport
    IataCode{"SDF"}, // Louisville International Airport
    IataCode{"SDG"}, // Sanandaj Airport
    IataCode{"SDH"}, // Santa Rosa de Copán Airport
    IataCode{"SDI"}, // Saidor Airport
    IataCode{"SDJ"}, // Sendai Airport
    IataCode{"SDK"}, // Sandakan Airport
    IataCode{"SDL"}, // Sundsvall-Härnösand Airport
    IataCode{"SDM"}, // Brown Field Municipal Airport
    IataCode{"SDN"}, // Sandane Airport
    IataCode{"SDO"}, // Smederevo Airport
    IataCode{"SDP"}, // Sand Point Airport
    IataCode{"SDQ"}, // Las Américas International Airport
    IataCode{"SDR"}, // Santander Airport
    IataCode{"SDS"}, // Sado Airport
    IataCode{"SDT"}, // Saidu Sharif Airport
    IataCode{"SDU"}, // Santos Dumont Airport
    IataCode{"SDV"}, // Sde Dov Airport
    IataCode{"SDX"}, // Sedona Airport
    IataCode{"SDY"}, // Sidney-Richland Municipal Airport
    IataCode{"SEA"}, // Seattle–Tacoma International Airport
    IataCode{"SEB"}, // Sabha Airport
    IataCode{"SEE"}, // Gillespie Field
    IataCode{"SEF"}, // Sebring Regional Airport
    IataCode{"SEG"}, // Penn Valley Airport
    IataCode{"SEK"}, // Srednekolymsk Airport
    IataCode{"SEM"}, // Craig Field Airport
    IataCode{"SEN"}, // London Southend Airport
    IataCode{"SEO"}, // Séguéla Airport
    IataCode{"SEQ"}, // Sungai Pakning
    IataCode{"SER"}, // Freeman Municipal Airport
    IataCode{"SES"}, // Selma Municipal Airport
    IataCode{"SEU"}, // Seronera Airstrip
    IataCode{"SEW"}, // Siwa Oasis North Airport
    IataCode{"SEY"}, // Sélibaby Airport
    IataCode{"SEZ"}, // Seychelles International Airport
    IataCode{"SFA"}, // Sfax–Thyna International Airport
    IataCode{"SFB"}, // Orlando Sanford International Airport
    IataCode{"SFC"}, // Saint-François Airport
    IataCode{"SFD"}, // Las Flecheras Airport
    IataCode{"SFE"}, // San Fernando Airport
    IataCode{"SFF"}, // Felts Field
    IataCode{"SFG"}, // L'Espérance Airport
    IataCode{"SFH"}, // San Felipe International Airport
    IataCode{"SFJ"}, // Kangerlussuaq Airport
    IataCode{"SFK"}, // Siófok-Kiliti Airport
    IataCode{"SFL"}, // São Filipe Airport
    IataCode{"SFM"}, // Sanford Regional Airport
    IataCode{"SFN"}, // Sauce Viejo Airport
    IataCode{"SFO"}, // San Francisco International Airport
    IataCode{"SFQ"}, // Şanlıurfa Airport
    IataCode{"SFS"}, // Subic Bay International Airport
    IataCode{"SFT"}, // Skellefteå Airport
    IataCode{"SFZ"}, // North Central State Airport
    IataCode{"SGA"}, // Sheghnan Airport
    IataCode{"SGC"}, // Surgut International Airport
    IataCode{"SGD"}, // Sønderborg Airport
    IataCode{"SGE"}, // Siegerland Airport
    IataCode{"SGF"}, // Springfield-Branson National Airport
    IataCode{"SGH"}, // Springfield-Beckley Municipal Airport
    IataCode{"SGK"}, // Sangapi Airport
    IataCode{"SGL"}, // Los Pozos Airport
    IataCode{"SGM"}, // San Ignacio Airfield
    IataCode{"SGN"}, // Tan Son Nhat International Airport
    IataCode{"SGO"}, // St George Airport
    IataCode{"SGP"}, // Shay Gap Airport
    IataCode{"SGR"}, // Sugar Land Regional Airport
    IataCode{"SGS"}, // Sanga-Sanga Airport
    IataCode{"SGT"}, // Stuttgart Municipal Airport
    IataCode{"SGU"}, // St. George Regional Airport
    IataCode{"SGV"}, // Sierra Grande Airport
    IataCode{"SGW"}, // Saginaw Seaplane Base
    IataCode{"SGX"}, // Songea Airport
    IataCode{"SGY"}, // Skagway Airport
    IataCode{"SGZ"}, // Songkhla Airport
    IataCode{"SHA"}, // Shanghai Hongqiao International Airport
    IataCode{"SHB"}, // Nakashibetsu Airport
    IataCode{"SHC"}, // Shire Airport
    IataCode{"SHD"}, // Shenandoah Valley Regional Airport
    IataCode{"SHE"}, // Shenyang Taoxian International Airport
    IataCode{"SHF"}, // Shihezi Huayuan Airport
    IataCode{"SHG"}, // Shungnak Airport
    IataCode{"SHH"}, // Shishmaref Airport
    IataCode{"SHI"}, // Shimojishima Airport
    IataCode{"SHJ"}, // Sharjah International Airport
    IataCode{"SHK"}, // Sehonghong Airport
    IataCode{"SHL"}, // Shillong Airport
    IataCode{"SHM"}, // Nanki-Shirahama Airport
    IataCode{"SHN"}, // Sanderson Field
    IataCode{"SHO"}, // Sokcho Airport
    IataCode{"SHQ"}, // Southport Airport
    IataCode{"SHR"}, // Sheridan County Airport
    IataCode{"SHS"}, // Shashi Airport
    IataCode{"SHT"}, // Shepparton Airport
    IataCode{"SHU"}, // Smith Point Airport
    IataCode{"SHV"}, // Shreveport Regional Airport
    IataCode{"SHW"}, // Sharurah Domestic Airport
    IataCode{"SHX"}, // Shageluk Airport
    IataCode{"SHY"}, // Shinyanga Airport
    IataCode{"SHZ"}, // Seshutes Airport
    IataCode{"SIA"}, // Xi'an Xiguan Airport
    IataCode{"SIB"}, // Sibiti Airport
    IataCode{"SIC"}, // San José Airport, Las Perlas
    IataCode{"SID"}, // Amílcar Cabral International Airport
    IataCode{"SIF"}, // Simara Airport
    IataCode{"SIG"}, // Fernando Luis Ribas Dominicci Airport
    IataCode{"SII"}, // Sidi Ifni Airport
    IataCode{"SIJ"}, // Siglufjörður Airport
    IataCode{"SIK"}, // Sikeston Memorial Municipal Airport
    IataCode{"SIN"}, // Singapore Changi Airport
    IataCode{"SIO"}, // Smithton Airport
    IataCode{"SIP"}, // Simferopol International Airport
    IataCode{"SIQ"}, // Dabo Singkep Airport
    IataCode{"SIR"}, // Sion Airport
    IataCode{"SIS"}, // Sishen Airport
    IataCode{"SIT"}, // Sitka Rocky Gutierrez Airport
    IataCode{"SIU"}, // Siuna Airport
    IataCode{"SIV"}, // Sullivan County Airport
    IataCode{"SIW"}, // Sibisa Airport
    IataCode{"SIX"}, // Ferdinand Lumban Tobing Airport
    IataCode{"SIY"}, // Siskiyou County Airport
    IataCode{"SJB"}, // San Joaquín Airport
    IataCode{"SJC"}, // San Jose International Airport
    IataCode{"SJD"}, // Los Cabos International Airport
    IataCode{"SJE"}, // Jorge Enrique González Torres Airport
    IataCode{"SJI"}, // San Jose Airport
    IataCode{"SJJ"}, // Sarajevo International Airport
    IataCode{"SJK"}, // São José dos Campos Airport
    IataCode{"SJL"}, // São Gabriel da Cachoeira Airport
    IataCode{"SJM"}, // San Juan de la Maguana Airport
    IataCode{"SJN"}, // St. Johns Industrial Air Park
    IataCode{"SJO"}, // Juan Santamaría International Airport
    IataCode{"SJP"}, // São José do Rio Preto Airport
    IataCode{"SJQ"}, // Sao Joaquim International Airport
    IataCode{"SJS"}, // San José de Chiquitos Airport
    IataCode{"SJT"}, // San Angelo Regional Airport
    IataCode{"SJU"}, // Luis Muñoz Marín International Airport
    IataCode{"SJV"}, // San Javier Airport (Bolivia)
    IataCode{"SJW"}, // Shijiazhuang Zhengding International Airport
    IataCode{"SJX"}, // Sarteneja Airport
    IataCode{"SJY"}, // Seinäjoki Airport
    IataCode{"SJZ"}, // São Jorge Airport
    IataCode{"SKB"}, // Robert L. Bradshaw International Airport
    IataCode{"SKC"}, // Suki Airport
    IataCode{"SKD"}, // Samarkand International Airport
    IataCode{"SKE"}, // Skien Airport, Geiteryggen
    IataCode{"SKF"}, // Kelly Field Annex
    IataCode{"SKG"}, // Thessaloniki International Airport
    IataCode{"SKH"}, // Surkhet Airport
    IataCode{"SKI"}, // Skikda Airport
    IataCode{"SKK"}, // Shaktoolik Airport
    IataCode{"SKL"}, // Broadford Airfield
    IataCode{"SKN"}, // Stokmarknes Airport
    IataCode{"SKO"}, // Sadiq Abubakar III International Airport
    IataCode{"SKP"}, // Skopje "Alexander the Great" Airport
    IataCode{"SKQ"}, // Sekake Airport
    IataCode{"SKR"}, // Shakiso Airport
    IataCode{"SKS"}, // Vojens Airport
    IataCode{"SKT"}, // Sialkot International Airport
    IataCode{"SKU"}, // Skyros Island National Airport
    IataCode{"SKV"}, // St. Catherine International Airport
    IataCode{"SKW"}, // Skwentna Airport
    IataCode{"SKX"}, // Saransk Airport
    IataCode{"SKY"}, // Griffing Sandusky Airport
    IataCode{"SKZ"}, // Sukkur Airport
    IataCode{"SLA"}, // Martín Miguel de Güemes International Airport
    IataCode{"SLB"}, // Storm Lake Municipal Airport
    IataCode{"SLC"}, // Salt Lake City International Airport
    IataCode{"SLD"}, // Sliač Airport
    IataCode{"SLE"}, // McNary Field
    IataCode{"SLG"}, // Smith Field
    IataCode{"SLH"}, // Vanua Lava Airport
    IataCode{"SLI"}, // Solwezi Airport
    IataCode{"SLJ"}, // Solomon Airport
    IataCode{"SLK"}, // Adirondack Regional Airport
    IataCode{"SLL"}, // Salalah Airport
    IataCode{"SLM"}, // Salamanca Airport
    IataCode{"SLN"}, // Salina Regional Airport
    IataCode{"SLO"}, // Salem-Leckrone Airport
    IataCode{"SLP"}, // San Luis Potosí International Airport
    IataCode{"SLQ"}, // Sleetmute Airport
    IataCode{"SLR"}, // Sulphur Springs Municipal Airport
    IataCode{"SLS"}, // Silistra Airfield
    IataCode{"SLT"}, // Harriet Alexander Field
    IataCode{"SLU"}, // George F. L. Charles Airport
    IataCode{"SLV"}, // Shimla Airport
    IataCode{"SLW"}, // Plan de Guadalupe International Airport
    IataCode{"SLX"}, // Salt Cay Airport
    IataCode{"SLY"}, // Salekhard Airport
    IataCode{"SLZ"}, // Marechal Cunha Machado International Airport
    IataCode{"SMA"}, // Santa Maria Airport
    IataCode{"SMB"}, // Franco Bianco Airport
    IataCode{"SMC"}, // Sremska Mitrovica Airport
    IataCode{"SMD"}, // Smith Field
    IataCode{"SME"}, // Lake Cumberland Regional Airport
    IataCode{"SMF"}, // Sacramento International Airport
    IataCode{"SMG"}, // Santa Maria Airport (Peru)
    IataCode{"SMI"}, // Samos International Airport
    IataCode{"SMK"}, // St. Michael Airport
    IataCode{"SML"}, // Stella Maris Airport
    IataCode{"SMM"}, // Semporna Airport
    IataCode{"SMN"}, // Lemhi County Airport
    IataCode{"SMO"}, // Santa Monica Airport
    IataCode{"SMP"}, // Stockholm Airport
    IataCode{"SMQ"}, // Sampit Airport
    IataCode{"SMR"}, // Simón Bolívar International Airport
    IataCode{"SMS"}, // Sainte Marie Airport
    IataCode{"SMT"}, // Sorriso Airport
    IataCode{"SMV"}, // Samedan Airport
    IataCode{"SMW"}, // Smara Airport
    IataCode{"SMX"}, // Santa Maria Public Airport
    IataCode{"SMY"}, // Simenti Airport
    IataCode{"SMZ"}, // Stoelmans Eiland Airstrip
    IataCode{"SNA"}, // John Wayne Airport
    IataCode{"SNB"}, // Snake Bay Airport
    IataCode{"SNC"}, // General Ulpiano Paez Airport
    IataCode{"SNE"}, // Preguiça Airport
    IataCode{"SNF"}, // Sub Teniente Nestor Arias Airport
    IataCode{"SNG"}, // Cap. Av. Juan Cochamanidis San Airport
    IataCode{"SNH"}, // Stanthorpe Airport
    IataCode{"SNI"}, // Greenville/Sinoe Airport
    IataCode{"SNK"}, // Winston Field Airport
    IataCode{"SNL"}, // Shawnee Regional Airport
    IataCode{"SNM"}, // San Ignacio de Moxos Airport
    IataCode{"SNN"}, // Shannon Airport
    IataCode{"SNO"}, // Sakon Nakhon Airport
    IataCode{"SNP"}, // St. Paul Island Airport
    IataCode{"SNR"}, // Saint-Nazaire - Montoir Airport
    IataCode{"SNS"}, // Salinas Municipal Airport
    IataCode{"SNT"}, // Las Cruces Airport
    IataCode{"SNU"}, // Abel Santamaría Airport
    IataCode{"SNV"}, // Santa Elena de Uairén Airport
    IataCode{"SNW"}, // Thandwe Airport
    IataCode{"SNX"}, // Sabana de la Mar Airport
    IataCode{"SNY"}, // Sidney Municipal Airport
    IataCode{"SNZ"}, // Bartolomeu de Gusmão Airport
    IataCode{"SOB"}, // Sármellék International Airport
    IataCode{"SOC"}, // Adisumarmo International Airport
    IataCode{"SOD"}, // Sorocaba Airport
    IataCode{"SOE"}, // Souanké Airport
    IataCode{"SOF"}, // Sofia Airport
    IataCode{"SOG"}, // Sogndal Airport, Haukåsen
    IataCode{"SOJ"}, // Sørkjosen Airport
    IataCode{"SOK"}, // Semonkong Airport
    IataCode{"SOM"}, // San Tomé Airport
    IataCode{"SON"}, // Santo-Pekoa International Airport
    IataCode{"SOO"}, // Söderhamn Airport
    IataCode{"SOP"}, // Moore County Airport
    IataCode{"SOQ"}, // Sorong Airport
    IataCode{"SOU"}, // Southampton Airport
    IataCode{"SOV"}, // Seldovia Airport
    IataCode{"SOW"}, // Show Low Regional Airport
    IataCode{"SOX"}, // Alberto Lleras Camargo Airport
    IataCode{"SOY"}, // Stronsay Airport
    IataCode{"SPA"}, // Spartanburg Downtown Memorial Airport
    IataCode{"SPB"}, // Charlotte Amalie Harbor Seaplane Base
    IataCode{"SPC"}, // La Palma Airport
    IataCode{"SPD"}, // Saidpur Airport
    IataCode{"SPF"}, // Black Hills Airport
    IataCode{"SPG"}, // Albert Whitted Airport
    IataCode{"SPI"}, // Abraham Lincoln Capital Airport
    IataCode{"SPJ"}, // Sparti Airport
    IataCode{"SPL"}, // Smederevska Palanka Airport
    IataCode{"SPM"}, // Cueva Las Maravillas Airport
    IataCode{"SPN"}, // Saipan International Airport
    IataCode{"SPP"}, // Menongue Airport
    IataCode{"SPR"}, // John Greif II Airport
    IataCode{"SPS"}, // Wichita Falls Municipal Airport
    IataCode{"SPU"}, // Split Airport
    IataCode{"SPV"}, // Stara Pazova Airport
    IataCode{"SPW"}, // Spencer Municipal Airport
    IataCode{"SPX"}, // Sphinx International Airport
    IataCode{"SPY"}, // San Pédro Airport
    IataCode{"SPZ"}, // Springdale Municipal Airport
    IataCode{"SQA"}, // Santa Ynez Airport
    IataCode{"SQC"}, // Southern Cross Airport
    IataCode{"SQD"}, // Shangrao Sanqingshan Airport
    IataCode{"SQG"}, // Sintang Airport
    IataCode{"SQH"}, // Nà Sản Airport
    IataCode{"SQJ"}, // Sanming Shaxian Airport
    IataCode{"SQL"}, // San Carlos Airport
    IataCode{"SQO"}, // Storuman Airport
    IataCode{"SQQ"}, // Šiauliai International Airport
    IataCode{"SQR"}, // Soroako Airport
    IataCode{"SQS"}, // Matthew Spain Airport
    IataCode{"SQV"}, // Sequim Valley Airport
    IataCode{"SQW"}, // Skive Airport
    IataCode{"SQX"}, // Sao Miguel Do Oeste Airport
    IataCode{"SQY"}, // São Lourenço do Sul Airport
    IataCode{"SRA"}, // Santa Rosa Airport
    IataCode{"SRB"}, // Santa Rosa Airport
    IataCode{"SRC"}, // Searcy Municipal Airport
    IataCode{"SRD"}, // San Ramón Airport
    IataCode{"SRE"}, // Alcantari Airport
    IataCode{"SRG"}, // Achmad Yani International Airport
    IataCode{"SRH"}, // Sarh Airport
    IataCode{"SRI"}, // Temindung Airport
    IataCode{"SRJ"}, // Capitán Germán Quiroga Guardia Airport
    IataCode{"SRN"}, // Strahan Airport
    IataCode{"SRP"}, // Stord Airport
    IataCode{"SRQ"}, // Sarasota–Bradenton International Airport
    IataCode{"SRT"}, // Soroti Airport
    IataCode{"SRV"}, // Stony River Airport
    IataCode{"SRW"}, // Mid-Carolina Regional Airport
    IataCode{"SRY"}, // Dasht-e Naz Airport
    IataCode{"SRZ"}, // El Trompillo Airport
    IataCode{"SSA"}, // Deputado Luís Eduardo Magalhães International Airport
    IataCode{"SSB"}, // Christiansted Harbor Seaplane Base
    IataCode{"SSD"}, // Víctor Lafón Airport
    IataCode{"SSE"}, // Solapur Airport
    IataCode{"SSF"}, // Stinson Municipal Airport
    IataCode{"SSG"}, // Malabo International Airport
    IataCode{"SSH"}, // Sharm el-Sheikh International Airport
    IataCode{"SSI"}, // Malcolm McKinnon Airport
    IataCode{"SSJ"}, // Sandnessjøen Airport
    IataCode{"SSL"}, // Santa Rosalía Airport
    IataCode{"SSM"}, // Sault Ste. Marie Municipal Airport
    IataCode{"SSO"}, // São Lourenço Airport
    IataCode{"SSQ"}, // La Sarre Airport
    IataCode{"SSR"}, // Sara Airport
    IataCode{"SST"}, // Santa Teresita Airport
    IataCode{"SSY"}, // Mbanza Congo Airport
    IataCode{"STA"}, // Stauning Vestjylland Airport
    IataCode{"STB"}, // Miguel Urdaneta Fernández Airport
    IataCode{"STC"}, // St. Cloud Regional Airport
    IataCode{"STD"}, // Mayor Buenaventura Vivas Airport
    IataCode{"STE"}, // Stevens Point Municipal Airport
    IataCode{"STF"}, // George M. Bryan Airport
    IataCode{"STG"}, // St. George Airport
    IataCode{"STH"}, // Strathmore (D.J. Murray) Airport
    IataCode{"STI"}, // Cibao International Airport
    IataCode{"STJ"}, // Rosecrans Memorial Airport
    IataCode{"STM"}, // Santarém-Maestro Wilson Fonseca Airport
    IataCode{"STN"}, // London Stansted Airport
    IataCode{"STP"}, // St. Paul Downtown Airport
    IataCode{"STQ"}, // St. Marys Municipal Airport
    IataCode{"STR"}, // Stuttgart Airport
    IataCode{"STT"}, // Cyril E. King Airport
    IataCode{"STV"}, // Surat Airport
    IataCode{"STW"}, // Stavropol Shpakovskoye Airport
    IataCode{"STX"}, // Henry E. Rohlsen Airport
    IataCode{"STY"}, // Nueva Hespérides International Airport
    IataCode{"STZ"}, // Santa Terezinha Airport
    IataCode{"SUA"}, // Witham Field
    IataCode{"SUB"}, // Juanda International Airport
    IataCode{"SUD"}, // Stroud Municipal Airport
    IataCode{"SUE"}, // Door County Cherryland Airport
    IataCode{"SUF"}, // Lamezia Terme International Airport
    IataCode{"SUG"}, // Surigao Airport
    IataCode{"SUH"}, // Sur Airport
    IataCode{"SUI"}, // Sukhumi Babushara Airport
    IataCode{"SUJ"}, // Satu Mare International Airport
    IataCode{"SUK"}, // Sakkyryr Airport
    IataCode{"SUL"}, // Sui Airport
    IataCode{"SUM"}, // Sumter Airport
    IataCode{"SUN"}, // Friedman Memorial Airport
    IataCode{"SUO"}, // Sunriver Airport
    IataCode{"SUP"}, // Trunojoyo Airport
    IataCode{"SUQ"}, // Sucúa Airport
    IataCode{"SUR"}, // Summer Beaver Airport
    IataCode{"SUS"}, // Spirit of St. Louis Airport
    IataCode{"SUT"}, // Sumbawanga Airport
    IataCode{"SUV"}, // Nausori International Airport
    IataCode{"SUW"}, // Richard I. Bong Airport
    IataCode{"SUX"}, // Sioux Gateway Airport
    IataCode{"SUY"}, // Suntar Airport
    IataCode{"SUZ"}, // Brigadier Hector Eduardo Ruiz Airport
    IataCode{"SVA"}, // Savoonga Airport
    IataCode{"SVB"}, // Sambava Airport
    IataCode{"SVC"}, // Grant County Airport
    IataCode{"SVD"}, // Argyle International Airport
    IataCode{"SVE"}, // Susanville Municipal Airport
    IataCode{"SVF"}, // Savé Airport
    IataCode{"SVG"}, // Stavanger Airport
    IataCode{"SVI"}, // Eduardo Falla Solano Airport
    IataCode{"SVJ"}, // Svolvær Airport
    IataCode{"SVK"}, // Silver Creek Airport
    IataCode{"SVL"}, // Savonlinna Airport
    IataCode{"SVO"}, // Sheremetyevo International Airport
    IataCode{"SVP"}, // Kuito Airport
    IataCode{"SVQ"}, // San Pablo Airport
    IataCode{"SVS"}, // Stevens Village Airport
    IataCode{"SVT"}, // Savuti Airport
    IataCode{"SVU"}, // Savusavu Airport
    IataCode{"SVW"}, // Sparrevohn LRRS Airport
    IataCode{"SVX"}, // Koltsovo Airport
    IataCode{"SVZ"}, // Juan Vicente Gómez International Airport
    IataCode{"SWA"}, // Jieyang Chaoshan Airport
    IataCode{"SWC"}, // Stawell Airport
    IataCode{"SWD"}, // Seward Airport
    IataCode{"SWE"}, // Samberigi Airport
    IataCode{"SWF"}, // Stewart International Airport
    IataCode{"SWH"}, // Swan Hill Airport
    IataCode{"SWI"}, // Sherman Municipal Airport
    IataCode{"SWJ"}, // South West Bay Airport
    IataCode{"SWO"}, // Stillwater Regional Airport
    IataCode{"SWP"}, // Swakopmund Airport
    IataCode{"SWQ"}, // Brangbiji Airport
    IataCode{"SWS"}, // Swansea Airport
    IataCode{"SWT"}, // Strezhevoy Airport
    IataCode{"SWV"}, // Severo-Evensk Airport
    IataCode{"SWW"}, // Avenger Field
    IataCode{"SWX"}, // Shakawe Airport
    IataCode{"SWY"}, // Sitiawan Airport
    IataCode{"SXB"}, // Strasbourg Airport
    IataCode{"SXE"}, // West Sale Airport
    IataCode{"SXF"}, // Berlin Schönefeld Airport
    IataCode{"SXG"}, // Senanga Airport
    IataCode{"SXI"}, // Sirri Island Airport
    IataCode{"SXL"}, // Sligo Airport
    IataCode{"SXM"}, // Princess Juliana International Airport
    IataCode{"SXN"}, // Sua Pan Airport
    IataCode{"SXO"}, // São Félix do Araguaia Airport
    IataCode{"SXP"}, // Sheldon Point Airport
    IataCode{"SXQ"}, // Soldotna Airport
    IataCode{"SXR"}, // Srinagar Airport
    IataCode{"SXU"}, // Soddo Airport
    IataCode{"SXV"}, // Salem Airport
    IataCode{"SXX"}, // São Félix do Xingu Airport
    IataCode{"SXY"}, // Sidney Municipal Airport (New York)
    IataCode{"SXZ"}, // Siirt Airport
    IataCode{"SYB"}, // Seal Bay Seaplane Base
    IataCode{"SYD"}, // Sydney Airport
    IataCode{"SYE"}, // Saadah Airport
    IataCode{"SYH"}, // Syangboche Airport
    IataCode{"SYI"}, // Shelbyville Municipal Airport
    IataCode{"SYJ"}, // Sirjan Airport
    IataCode{"SYK"}, // Stykkishólmur Airport
    IataCode{"SYM"}, // Pu'er Simao Airport
    IataCode{"SYN"}, // Stanton Airfield
    IataCode{"SYO"}, // Shonai Airport
    IataCode{"SYP"}, // Ruben Cantu Airport
    IataCode{"SYQ"}, // Tobías Bolaños International Airport
    IataCode{"SYR"}, // Syracuse Hancock International Airport
    IataCode{"SYS"}, // Saskylakh Airport
    IataCode{"SYT"}, // Saint-Yan Airport
    IataCode{"SYU"}, // Warraber Island Airport
    IataCode{"SYW"}, // Sehwan Sharif Airport
    IataCode{"SYX"}, // Sanya Phoenix International Airport
    IataCode{"SYY"}, // Stornoway Airport
    IataCode{"SYZ"}, // Shiraz International Airport, Iran
    IataCode{"SZA"}, // Soyo Airport
    IataCode{"SZB"}, // Sultan Abdul Aziz Shah Airport
    IataCode{"SZE"}, // Semera Airport
    IataCode{"SZF"}, // Samsun-Çarşamba Airport
    IataCode{"SZG"}, // Salzburg Airport
    IataCode{"SZI"}, // Zaysan Airport
    IataCode{"SZJ"}, // Siguanea Airport
    IataCode{"SZK"}, // Skukuza Airport
    IataCode{"SZN"}, // Santa Cruz Island Airport
    IataCode{"SZP"}, // Santa Paula Airport
    IataCode{"SZR"}, // Stara Zagora Airport
    IataCode{"SZS"}, // Ryan's Creek Aerodrome
    IataCode{"SZT"}, // San Cristóbal de las Casas National Airport
    IataCode{"SZV"}, // Suzhou Guangfu Airport
    IataCode{"SZW"}, // Parchim International Airport
    IataCode{"SZX"}, // Shenzhen Bao'an International Airport
    IataCode{"SZY"}, // Szczytno-Szymany International Airport
    IataCode{"SZZ"}, // "Solidarity" Szczecin-Goleniów Airport
    IataCode{"TAB"}, // Arthur Napoleon Raymond Robinson International Airport
    IataCode{"TAC"}, // Daniel Z. Romualdez Airport
    IataCode{"TAD"}, // Perry Stokes Airport
    IataCode{"TAE"}, // Daegu International Airport
    IataCode{"TAF"}, // Oran Tafraoui Airport
    IataCode{"TAG"}, // Tagbilaran Airport
    IataCode{"TAH"}, // Whitegrass Airport
    IataCode{"TAI"}, // Ta'izz International Airport
    IataCode{"TAJ"}, // Tadji Airport
    IataCode{"TAK"}, // Takamatsu Airport
    IataCode{"TAL"}, // Ralph M. Calhoun Memorial Airport
    IataCode{"TAM"}, // General Francisco Javier Mina International Airport
    IataCode{"TAN"}, // Taunton Municipal Airport
    IataCode{"TAO"}, // Qingdao Liuting International Airport
    IataCode{"TAP"}, // Tapachula International Airport
    IataCode{"TAR"}, // Taranto-Grottaglie Airport
    IataCode{"TAS"}, // Tashkent International Airport
    IataCode{"TAT"}, // Poprad-Tatry Airport
    IataCode{"TAV"}, // Tau Airport
    IataCode{"TAW"}, // Tacuarembó Airport
    IataCode{"TAY"}, // Tartu Airport
    IataCode{"TAZ"}, // Daşoguz Airport
    IataCode{"TBA"}, // SLAF Iranamadu
    IataCode{"TBB"}, // Tuy Hoa Airport
    IataCode{"TBC"}, // Tuba City Airport
    IataCode{"TBF"}, // Tabiteuea Nord Aerodrome
    IataCode{"TBG"}, // Tabubil Airport
    IataCode{"TBH"}, // Tugdan Airport
    IataCode{"TBI"}, // New Bight Airport
    IataCode{"TBJ"}, // Tabarka-Ain Draham International Airport
    IataCode{"TBN"}, // Waynesville-St. Robert Regional Airport
    IataCode{"TBO"}, // Tabora Airport
    IataCode{"TBP"}, // Cap. FAP Pedro Canga Rodríguez Airport
    IataCode{"TBR"}, // Statesboro-Bulloch County Airport
    IataCode{"TBS"}, // Tbilisi International Airport
    IataCode{"TBT"}, // Tabatinga International Airport
    IataCode{"TBU"}, // Fuaʻamotu International Airport
    IataCode{"TBW"}, // Tambov Donskoye Airport
    IataCode{"TBY"}, // Tshabong Airport
    IataCode{"TBZ"}, // Tabriz International Airport
    IataCode{"TCA"}, // Tennant Creek Airport
    IataCode{"TCB"}, // Treasure Cay Airport
    IataCode{"TCC"}, // Tucumcari Municipal Airport
    IataCode{"TCD"}, // Tarapacá Airport
    IataCode{"TCE"}, // Tulcea Airport
    IataCode{"TCG"}, // Tacheng Airport
    IataCode{"TCH"}, // Tchibanga Airport
    IataCode{"TCL"}, // Tuscaloosa Regional Airport
    IataCode{"TCN"}, // Tehuacán Airport
    IataCode{"TCO"}, // La Florida Airport
    IataCode{"TCP"}, // Taba International Airport
    IataCode{"TCQ"}, // Crnl. FAP Carlos Ciriani Santa Rosa International Airport
    IataCode{"TCR"}, // Tuticorin Airport
    IataCode{"TCS"}, // Truth or Consequences Municipal Airport
    IataCode{"TCT"}, // Takotna Airport
    IataCode{"TCW"}, // Tocumwal Airport
    IataCode{"TCX"}, // Tabas Airport
    IataCode{"TCY"}, // Tracy Municipal Airport
    IataCode{"TCZ"}, // Tengchong Tuofeng Airport
    IataCode{"TDA"}, // Trinidad Airport
    IataCode{"TDD"}, // Teniente Jorge Henrich Arauz Airport
    IataCode{"TDF"}, // Person County Airport
    IataCode{"TDG"}, // Tandag Airport
    IataCode{"TDJ"}, // Tadjoura Airport
    IataCode{"TDL"}, // Tandil Airport
    IataCode{"TDO"}, // South Lewis County Airport
    IataCode{"TDS"}, // Sasereme Airport
    IataCode{"TDW"}, // Tradewind Airport
    IataCode{"TDX"}, // Trat Airport
    IataCode{"TDZ"}, // Toledo Executive Airport
    IataCode{"TEA"}, // Tela Airport
    IataCode{"TEB"}, // Teterboro Airport
    IataCode{"TEC"}, // Telêmaco Borba Airport
    IataCode{"TED"}, // Thisted Airport
    IataCode{"TEE"}, // Cheikh Larbi Tébessi Airport
    IataCode{"TEF"}, // Telfer Airport
    IataCode{"TEG"}, // Tenkodogo Airport
    IataCode{"TEI"}, // Tezu Airport
    IataCode{"TEK"}, // Tatitlek Airport
    IataCode{"TEL"}, // Telupid Airport
    IataCode{"TEM"}, // Temora Airport
    IataCode{"TEN"}, // Tongren Fenghuang Airport
    IataCode{"TER"}, // Lajes Airport
    IataCode{"TES"}, // Teseney Airport
    IataCode{"TET"}, // Chingozi Airport
    IataCode{"TEU"}, // Manapouri Aerodrome
    IataCode{"TEV"}, // Teruel Airport
    IataCode{"TEW"}, // Mason Jewett Field
    IataCode{"TEX"}, // Telluride Regional Airport
    IataCode{"TEY"}, // Thingeyri Airport
    IataCode{"TEZ"}, // Tezpur Airport
    IataCode{"TFF"}, // Tefé Airport
    IataCode{"TFI"}, // Tufi Airport
    IataCode{"TFL"}, // Teófilo Otoni Airport
    IataCode{"TFM"}, // Telefomin Airport
    IataCode{"TFN"}, // Tenerife North Airport
    IataCode{"TFS"}, // Tenerife South Airport
    IataCode{"TGC"}, // Tanjung Manis Airport
    IataCode{"TGD"}, // Podgorica Airport
    IataCode{"TGE"}, // Sharpe Field
    IataCode{"TGG"}, // Sultan Mahmud Airport
    IataCode{"TGH"}, // Tongoa Airport
    IataCode{"TGI"}, // Tingo María Airport
    IataCode{"TGJ"}, // Tiga Airport
    IataCode{"TGM"}, // Târgu Mureș International Airport
    IataCode{"TGN"}, // Latrobe Valley Airport
    IataCode{"TGO"}, // Tongliao Airport
    IataCode{"TGP"}, // Podkamennaya Tunguska Airport
    IataCode{"TGQ"}, // Tangará da Serra Airport
    IataCode{"TGR"}, // Sidi Mahdi Airport
    IataCode{"TGS"}, // Chókwè airport
    IataCode{"TGT"}, // Tanga Airport
    IataCode{"TGU"}, // Toncontín International Airport
    IataCode{"TGV"}, // Targovishte Airport
    IataCode{"TGZ"}, // Ángel Albino Corzo International Airport
    IataCode{"THA"}, // Tullahoma Regional Airport
    IataCode{"THB"}, // Thaba Tseka Airport
    IataCode{"THC"}, // Tchien Airport
    IataCode{"THD"}, // Tho Xuan Airport
    IataCode{"THE"}, // Teresina Airport
    IataCode{"THG"}, // Thangool Airport
    IataCode{"THI"}, // Tichitt Airport
    IataCode{"THL"}, // Tachilek Airport
    IataCode{"THM"}, // Thompson Falls Airport
    IataCode{"THN"}, // Trollhättan-Vänersborg Airport
    IataCode{"THO"}, // Þórshöfn Airport
    IataCode{"THP"}, // Hot Springs County-Thermopolis Municipal Airport
    IataCode{"THQ"}, // Tianshui Maijishan Airport
    IataCode{"THR"}, // Mehrabad International Airport
    IataCode{"THS"}, // Sukhothai Airport
    IataCode{"THT"}, // Tamchakett Airport
    IataCode{"THV"}, // York Airport (Pennsylvania)
    IataCode{"THX"}, // Turukhansk Airport
    IataCode{"THZ"}, // Tahoua Airport
    IataCode{"TIA"}, // Tirana International Airport
    IataCode{"TIB"}, // Tibú Airport
    IataCode{"TIC"}, // Tinak Airport
    IataCode{"TID"}, // Abdelhafid Boussouf Bou Chekif Airport
    IataCode{"TIE"}, // Tippi Airport
    IataCode{"TIF"}, // Ta’if Regional Airport
    IataCode{"TIH"}, // Tikehau Airport
    IataCode{"TII"}, // Tarin Kowt Airport
    IataCode{"TIJ"}, // Tijuana International Airport
    IataCode{"TIL"}, // Cheadle Airport
    IataCode{"TIM"}, // Timika Airport
    IataCode{"TIN"}, // Tindouf Airport
    IataCode{"TIP"}, // Tripoli International Airport
    IataCode{"TIQ"}, // Tinian International Airport
    IataCode{"TIR"}, // Tirupati Airport
    IataCode{"TIU"}, // Richard Pearse Airport
    IataCode{"TIV"}, // Tivat Airport
    IataCode{"TIW"}, // Tacoma Narrows Airport
    IataCode{"TIX"}, // Space Coast Regional Airport
    IataCode{"TIY"}, // Tidjikja Airport
    IataCode{"TIZ"}, // Tari Airport
    IataCode{"TJA"}, // Capitán Oriel Lea Plaza Airport
    IataCode{"TJB"}, // Sei Bati Airport
    IataCode{"TJG"}, // Warukin Airport
    IataCode{"TJH"}, // Tajima Airport
    IataCode{"TJI"}, // Trujillo Airport
    IataCode{"TJK"}, // Tokat Airport
    IataCode{"TJL"}, // Três Lagoas Airport
    IataCode{"TJM"}, // Roshchino International Airport
    IataCode{"TJQ"}, // Buluh Tumbang Airport
    IataCode{"TJS"}, // Tanjung Harapan Airport
    IataCode{"TJU"}, // Kulob Airport
    IataCode{"TKA"}, // Talkeetna Airport
    IataCode{"TKC"}, // Tiko Airport
    IataCode{"TKD"}, // Takoradi Airport
    IataCode{"TKE"}, // Tenakee Seaplane Base
    IataCode{"TKF"}, // Truckee Tahoe Airport
    IataCode{"TKG"}, // Radin Inten II Airport
    IataCode{"TKH"}, // Takhli Airport
    IataCode{"TKI"}, // Tokeen Seaplane Base
    IataCode{"TKJ"}, // Tok Junction Airport
    IataCode{"TKK"}, // Chuuk International Airport
    IataCode{"TKN"}, // Tokunoshima Airport
    IataCode{"TKO"}, // Tlokoeng Airport
    IataCode{"TKQ"}, // Kigoma Airport
    IataCode{"TKR"}, // Thakurgaon STOLport
    IataCode{"TKS"}, // Tokushima Airport
    IataCode{"TKT"}, // Tak Airport
    IataCode{"TKU"}, // Turku Airport
    IataCode{"TKV"}, // Tatakoto Airport
    IataCode{"TKW"}, // Tekin Airport
    IataCode{"TKX"}, // Takaroa Airport
    IataCode{"TKZ"}, // Tokoroa Airport
    IataCode{"TLA"}, // Teller Airport
    IataCode{"TLB"}, // Tarbela Dam Airport
    IataCode{"TLC"}, // Lic. Adolfo López Mateos International Airport
    IataCode{"TLD"}, // Tuli Lodge Airport
    IataCode{"TLE"}, // Toliara Airport
    IataCode{"TLF"}, // Telida Airport
    IataCode{"TLH"}, // Tallahassee International Airport
    IataCode{"TLI"}, // Sultan Bantilan Airport
    IataCode{"TLJ"}, // Tatalina LRRS Airport
    IataCode{"TLK"}, // Talakan
    IataCode{"TLL"}, // Tallinn Airport
    IataCode{"TLM"}, // Zenata – Messali El Hadj Airport
    IataCode{"TLN"}, // Toulon-Hyères Airport
    IataCode{"TLQ"}, // Turpan Jiaohe Airport
    IataCode{"TLR"}, // Mefford Field Airport
    IataCode{"TLS"}, // Toulouse–Blagnac Airport
    IataCode{"TLT"}, // Tuluksak Airport
    IataCode{"TLU"}, // Golfo de Morrosquillo Airport
    IataCode{"TLV"}, // Ben Gurion Airport
    IataCode{"TLX"}, // Panguilemo Airport
    IataCode{"TLZ"}, // Catalão Airport
    IataCode{"TMA"}, // Henry Tift Myers Airport
    IataCode{"TMB"}, // Miami Executive Airport
    IataCode{"TMC"}, // Tambolaka Airport
    IataCode{"TMD"}, // Timbedra Airport
    IataCode{"TME"}, // Gabriel Vargas Santos Airport
    IataCode{"TMF"}, // Thimarafushi Airport
    IataCode{"TMG"}, // Tommanggong Airport
    IataCode{"TMI"}, // Tumlingtar Airport
    IataCode{"TMJ"}, // Termez Airport
    IataCode{"TMK"}, // Tillamook Airport
    IataCode{"TML"}, // Tamale Airport
    IataCode{"TMM"}, // Toamasina Airport
    IataCode{"TMN"}, // Tamana Airport
    IataCode{"TMO"}, // Tumeremo Airport
    IataCode{"TMP"}, // Tampere-Pirkkala Airport
    IataCode{"TMQ"}, // Tambao Airport
    IataCode{"TMR"}, // Aguenar–Hadj Bey Akhamok Airport
    IataCode{"TMS"}, // São Tomé International Airport
    IataCode{"TMT"}, // Porto Trombetas Airport
    IataCode{"TMU"}, // Tambor Airport
    IataCode{"TMW"}, // Tamworth Airport
    IataCode{"TMX"}, // Timimoun Airport
    IataCode{"TMZ"}, // Thames Aerodrome
    IataCode{"TNA"}, // Jinan Yaoqiang International Airport
    IataCode{"TNC"}, // Tin City LRRS Airport
    IataCode{"TND"}, // Alberto Delgado Airport
    IataCode{"TNE"}, // New Tanegashima Airport
    IataCode{"TNF"}, // Toussus-le-Noble Airport
    IataCode{"TNG"}, // Tangier Ibn Battouta Airport
    IataCode{"TNH"}, // Tonghua Sanyuanpu Airport
    IataCode{"TNI"}, // Satna Airport
    IataCode{"TNJ"}, // Raja Haji Fisabilillah Airport
    IataCode{"TNK"}, // Tununak Airport
    IataCode{"TNL"}, // Ternopil Airport
    IataCode{"TNN"}, // Tainan Airport
    IataCode{"TNO"}, // Tamarindo Airport
    IataCode{"TNP"}, // Twentynine Palms Airport
    IataCode{"TNR"}, // Ivato Airport
    IataCode{"TNS"}, // Tungsten (Cantung) Airport
    IataCode{"TNT"}, // Dade-Collier Training and Transition Airport
    IataCode{"TNU"}, // Newton Municipal Airport (Iowa)
    IataCode{"TNW"}, // Jumandy Airport
    IataCode{"TNX"}, // Stung Treng Airport
    IataCode{"TOA"}, // Zamperini Field
    IataCode{"TOB"}, // Tobruk Airport
    IataCode{"TOC"}, // Toccoa Airport
    IataCode{"TOD"}, // Tioman Airport
    IataCode{"TOE"}, // Tozeur–Nefta International Airport
    IataCode{"TOF"}, // Bogashevo Airport
    IataCode{"TOG"}, // Togiak Airport
    IataCode{"TOH"}, // Torres Airport
    IataCode{"TOI"}, // Troy Municipal Airport
    IataCode{"TOL"}, // Toledo Express Airport
    IataCode{"TOM"}, // Timbuktu Airport
    IataCode{"TOO"}, // San Vito de Java Airport
    IataCode{"TOP"}, // Philip Billard Municipal Airport
    IataCode{"TOQ"}, // Barriles Airport
    IataCode{"TOR"}, // Torrington Municipal Airport
    IataCode{"TOS"}, // Tromsø Airport
    IataCode{"TOT"}, // Totness Airstrip
    IataCode{"TOU"}, // Touho Airport
    IataCode{"TOW"}, // Toledo Airport (Brazil)
    IataCode{"TOY"}, // Toyama Airport
    IataCode{"TOZ"}, // Mahana Airport
    IataCode{"TPA"}, // Tampa International Airport
    IataCode{"TPC"}, // Tarapoa Airport
    IataCode{"TPE"}, // Taoyuan International Airport
    IataCode{"TPF"}, // Peter O. Knight Airport
    IataCode{"TPG"}, // Taiping Airport
    IataCode{"TPH"}, // Tonopah Airport
    IataCode{"TPI"}, // Tapini Airport
    IataCode{"TPJ"}, // Taplejung Airport
    IataCode{"TPL"}, // Draughon-Miller Central Texas Regional Airport
    IataCode{"TPN"}, // Tiputini Airport
    IataCode{"TPP"}, // Cad. FAP Guillermo del Castillo Paredes Airport
    IataCode{"TPQ"}, // Amado Nervo International Airport
    IataCode{"TPR"}, // Tom Price Airport
    IataCode{"TPS"}, // Vincenzo Florio Airport Trapani-Birgi
    IataCode{"TPU"}, // Tikapur Airport
    IataCode{"TQH"}, // Tahlequah Municipal Airport
    IataCode{"TQL"}, // Ñanco Lauquen Airport
    IataCode{"TQN"}, // Taloqan Airport
    IataCode{"TQP"}, // Trepell Airport
    IataCode{"TRA"}, // Tarama Airport
    IataCode{"TRB"}, // Gonzalo Mejia Airport
    IataCode{"TRC"}, // Francisco Sarabia International Airport
    IataCode{"TRD"}, // Trondheim Airport
    IataCode{"TRE"}, // Tiree Airport
    IataCode{"TRF"}, // Sandefjord Airport, Torp
    IataCode{"TRG"}, // Tauranga Airport
    IataCode{"TRH"}, // Trona Airport
    IataCode{"TRI"}, // Tri-Cities Regional Airport
    IataCode{"TRK"}, // Juwata International Airport
    IataCode{"TRL"}, // Terrell Municipal Airport
    IataCode{"TRM"}, // Jacqueline Cochran Regional Airport
    IataCode{"TRN"}, // Turin Airport
    IataCode{"TRO"}, // Taree Airport
    IataCode{"TRQ"}, // Tarauacá Airport
    IataCode{"TRS"}, // Trieste – Friuli Venezia Giulia Airport
    IataCode{"TRU"}, // Cap. FAP Carlos Martínez de Pinillos International Airport
    IataCode{"TRV"}, // Trivandrum International Airport
    IataCode{"TRW"}, // Bonriki International Airport
    IataCode{"TRX"}, // Trenton Municipal Airport
    IataCode{"TRY"}, // Tororo Airport
    IataCode{"TRZ"}, // Tiruchirapalli Airport
    IataCode{"TSB"}, // Tsumeb Airport
    IataCode{"TSC"}, // Taisha Airport
    IataCode{"TSE"}, // Astana International Airport
    IataCode{"TSF"}, // Treviso Airport
    IataCode{"TSG"}, // Tanacross Airport
    IataCode{"TSH"}, // Tshikapa Airport
    IataCode{"TSJ"}, // Tsushima Airport
    IataCode{"TSL"}, // Tamuín National Airport
    IataCode{"TSM"}, // Taos Regional Airport
    IataCode{"TSN"}, // Tianjin Binhai International Airport
    IataCode{"TSO"}, // Tresco Heliport
    IataCode{"TSP"}, // Tehachapi Municipal Airport
    IataCode{"TSQ"}, // Torres Airport
    IataCode{"TSR"}, // Traian Vuia International Airport
    IataCode{"TSS"}, // East 34th Street Heliport
    IataCode{"TST"}, // Trang Airport
    IataCode{"TSU"}, // Tabiteuea Süd Airport
    IataCode{"TSV"}, // Townsville Airport
    IataCode{"TSY"}, // Tasikmalaya Airport
    IataCode{"TTA"}, // Tan Tan Airport
    IataCode{"TTB"}, // Tortolì Airport
    IataCode{"TTC"}, // Las Breas Airport
    IataCode{"TTD"}, // Portland-Troutdale Airport
    IataCode{"TTE"}, // Babullah Airport
    IataCode{"TTG"}, // Tartagal "General Enrique Mosconi" Airport
    IataCode{"TTJ"}, // Tottori Airport
    IataCode{"TTM"}, // Tablón de Tamará Airport
    IataCode{"TTN"}, // Trenton-Mercer Airport
    IataCode{"TTO"}, // Britton Municipal Airport
    IataCode{"TTQ"}, // Tortuguero Airport
    IataCode{"TTR"}, // Pongtiku Airport
    IataCode{"TTS"}, // Tsaratanana Airport
    IataCode{"TTT"}, // Taitung Airport
    IataCode{"TTU"}, // Sania Ramel Airport
    IataCode{"TUA"}, // Teniente Coronel Luis a Mantilla International Airport
    IataCode{"TUB"}, // Tubuai – Mataura Airport
    IataCode{"TUC"}, // Teniente Benjamín Matienzo International Airport
    IataCode{"TUD"}, // Tambacounda Airport
    IataCode{"TUF"}, // Tours Val de Loire Airport
    IataCode{"TUG"}, // Tuguegarao Airport
    IataCode{"TUI"}, // Turaif Domestic Airport
    IataCode{"TUJ"}, // Tum Airport
    IataCode{"TUK"}, // Turbat International Airport
    IataCode{"TUL"}, // Tulsa International Airport
    IataCode{"TUM"}, // Tumut Airport
    IataCode{"TUN"}, // Tunis–Carthage International Airport
    IataCode{"TUO"}, // Taupo Airport
    IataCode{"TUP"}, // Tupelo Regional Airport
    IataCode{"TUQ"}, // Tougan Airport
    IataCode{"TUR"}, // Tucuruí Airport
    IataCode{"TUS"}, // Tucson International Airport
    IataCode{"TUU"}, // Tabuk Regional Airport
    IataCode{"TUV"}, // San Rafael Airport (Venezuela)
    IataCode{"TUX"}, // Tumbler Ridge Airport
    IataCode{"TVA"}, // Morafenobe Airport
    IataCode{"TVC"}, // Cherry Capital Airport
    IataCode{"TVF"}, // Thief River Falls Regional Airport
    IataCode{"TVI"}, // Thomasville Regional Airport
    IataCode{"TVK"}, // Centerville Municipal Airport
    IataCode{"TVL"}, // Lake Tahoe Airport
    IataCode{"TVS"}, // Tangshan Sannühe Airport
    IataCode{"TVU"}, // Matei Airport
    IataCode{"TVY"}, // Dawei Airport
    IataCode{"TWA"}, // Twin Hills Airport
    IataCode{"TWB"}, // Toowoomba Airport
    IataCode{"TWD"}, // Jefferson County International Airport
    IataCode{"TWF"}, // Magic Valley Regional Airport
    IataCode{"TWU"}, // Tawau Airport
    IataCode{"TWZ"}, // Pukaki Airport
    IataCode{"TXE"}, // Takengon Rembele Airport
    IataCode{"TXF"}, // Teixeira de Freitas Airport
    IataCode{"TXG"}, // Taichung Aero Airport
    IataCode{"TXK"}, // Texarkana Regional Airport
    IataCode{"TXL"}, // Berlin Tegel Airport
    IataCode{"TXN"}, // Huangshan Tunxi International Airport
    IataCode{"TXU"}, // Tabou Airport
    IataCode{"TYA"}, // Klokovo
    IataCode{"TYB"}, // Tibooburra Airport
    IataCode{"TYD"}, // Tynda Airport
    IataCode{"TYE"}, // Tyonek Airport
    IataCode{"TYF"}, // Torsby Airport
    IataCode{"TYL"}, // Cap. FAP Víctor Montes Arias Airport
    IataCode{"TYM"}, // Staniel Cay Airport
    IataCode{"TYN"}, // Taiyuan Wusu International Airport
    IataCode{"TYQ"}, // Indianapolis Executive Airport
    IataCode{"TYR"}, // Tyler Pounds Regional Airport
    IataCode{"TYS"}, // McGhee Tyson Airport
    IataCode{"TYT"}, // Treinta y Tres Airport
    IataCode{"TYZ"}, // Taylor Airport
    IataCode{"TZA"}, // Belize City Municipal Airport
    IataCode{"TZC"}, // Tuscola Area Airport
    IataCode{"TZL"}, // Tuzla International Airport
    IataCode{"TZR"}, // Bolton Field
    IataCode{"TZX"}, // Trabzon Airport
    IataCode{"UAC"}, // San Luis Río Colorado Airport
    IataCode{"UAI"}, // Suai Airport
    IataCode{"UAK"}, // Narsarsuaq Airport
    IataCode{"UAL"}, // Luau Airport
    IataCode{"UAO"}, // Aurora State Airport
    IataCode{"UAQ"}, // Domingo Faustino Sarmiento Airport
    IataCode{"UAR"}, // Bouarfa Airport
    IataCode{"UAS"}, // Samburu Airport
    IataCode{"UAX"}, // Uaxactun Airport
    IataCode{"UBA"}, // Uberaba Airport
    IataCode{"UBB"}, // Mabuiag Island Airport
    IataCode{"UBE"}, // Rome Urbe Airport
    IataCode{"UBI"}, // Buin Airport
    IataCode{"UBJ"}, // Yamaguchi Ube Airport
    IataCode{"UBP"}, // Ubon Ratchathani Airport
    IataCode{"UBS"}, // Columbus-Lowndes County Airport
    IataCode{"UBT"}, // Ubatuba Airport
    IataCode{"UCA"}, // Oneida County Airport
    IataCode{"UCB"}, // Ulanqab Airport
    IataCode{"UCC"}, // Yucca Airstrip
    IataCode{"UCK"}, // Lutsk Airport
    IataCode{"UCN"}, // Buchanan Airport
    IataCode{"UCP"}, // New Castle Municipal Airport
    IataCode{"UCT"}, // Ukhta Airport
    IataCode{"UCY"}, // Everett-Stewart Regional Airport
    IataCode{"UCZ"}, // Uchiza Airport
    IataCode{"UDD"}, // Bermuda Dunes Airport
    IataCode{"UDG"}, // Darlington County Jetport
    IataCode{"UDI"}, // Uberlândia Airport
    IataCode{"UDJ"}, // Uzhhorod International Airport
    IataCode{"UDL"}, // Buol Airport
    IataCode{"UDN"}, // Udine-Campoformido Airport
    IataCode{"UDR"}, // Udaipur Airport
    IataCode{"UEE"}, // Queenstown Airport
    IataCode{"UEL"}, // Quelimane Airport
    IataCode{"UEO"}, // Kumejima Airport
    IataCode{"UES"}, // Waukesha County Airport
    IataCode{"UET"}, // Quetta International Airport
    IataCode{"UFA"}, // Ufa International Airport
    IataCode{"UGA"}, // Bulgan Airport
    IataCode{"UGB"}, // Ugashik Bay Airport
    IataCode{"UGC"}, // Urgench International Airport
    IataCode{"UGN"}, // Waukegan Regional Airport
    IataCode{"UGO"}, // Uíge Airport
    IataCode{"UGS"}, // Ugashik Airport
    IataCode{"UHE"}, // Kunovice Airport
    IataCode{"UIB"}, // El Caraño Airport
    IataCode{"UIH"}, // Phu Cat Airport
    IataCode{"UII"}, // Útila Airport
    IataCode{"UIK"}, // Ust-Ilimsk Airport
    IataCode{"UIL"}, // Quillayute Airport
    IataCode{"UIN"}, // Quincy Regional Airport
    IataCode{"UIO"}, // Mariscal Sucre International Airport
    IataCode{"UIP"}, // Quimper – Cornouaille Airport
    IataCode{"UIR"}, // Quirindi Airport
    IataCode{"UIT"}, // Jaluit Airport
    IataCode{"UJE"}, // Ujae Airport
    IataCode{"UJU"}, // Uiju Airfield
    IataCode{"UKA"}, // Ukunda Airport
    IataCode{"UKB"}, // Kobe Airport
    IataCode{"UKG"}, // Ust-Kuyga Airport
    IataCode{"UKI"}, // Ukiah Municipal Airport
    IataCode{"UKK"}, // Oskemen Airport
    IataCode{"UKL"}, // Coffey County Airport
    IataCode{"UKR"}, // Mukeiras Airport
    IataCode{"UKS"}, // Sevastopol International Airport
    IataCode{"UKT"}, // Quakertown Airport
    IataCode{"UKX"}, // Ust-Kut Airport
    IataCode{"ULA"}, // Capitán José Daniel Vazquez Airport
    IataCode{"ULB"}, // Ulei Airport
    IataCode{"ULC"}, // Los Cerrillos Airport
    IataCode{"ULD"}, // Prince M. Buthelezi Airport
    IataCode{"ULG"}, // Ölgii Airport
    IataCode{"ULH"}, // Prince Abdul Majeed bin Abdul Aziz Domestic Airport
    IataCode{"ULK"}, // Lensk Airport
    IataCode{"ULM"}, // New Ulm Municipal Airport
    IataCode{"ULN"}, // Chinggis Khaan International Airport
    IataCode{"ULO"}, // Ulaangom Airport
    IataCode{"ULP"}, // Quilpie Airport
    IataCode{"ULQ"}, // Heriberto Gíl Martínez Airport
    IataCode{"ULU"}, // Gulu Airport
    IataCode{"ULV"}, // Ulyanovsk Baratayevka Airport
    IataCode{"ULY"}, // Ulyanovsk Vostochny Airport
    IataCode{"ULZ"}, // Donoi Airport
    IataCode{"UMA"}, // Punta de Maisi Airport
    IataCode{"UME"}, // Umeå Airport
    IataCode{"UMM"}, // Summit Airport
    IataCode{"UMP"}, // Indianapolis Metropolitan Airport
    IataCode{"UMS"}, // Ust-Maya Airport
    IataCode{"UMT"}, // Umiat Airport
    IataCode{"UMU"}, // Umuarama Airport
    IataCode{"UMY"}, // Sumy Airport
    IataCode{"UNA"}, // Una-Comandatuba Airport
    IataCode{"UND"}, // Kunduz Airport
    IataCode{"UNE"}, // Qacha's Nek Airport
    IataCode{"UNG"}, // Kiunga Airport
    IataCode{"UNI"}, // Union Island Airport
    IataCode{"UNK"}, // Unalakleet Airport
    IataCode{"UNN"}, // Ranong Airport
    IataCode{"UNO"}, // West Plains Regional Airport
    IataCode{"UNU"}, // Dodge County Airport
    IataCode{"UOS"}, // Franklin County Airport
    IataCode{"UOX"}, // University-Oxford Airport
    IataCode{"UPB"}, // Playa Baracoa Airport
    IataCode{"UPG"}, // Sultan Hasanuddin International Airport
    IataCode{"UPL"}, // Upala Airport
    IataCode{"UPN"}, // Lic. y Gen. Ignacio López Rayón International Airport
    IataCode{"UPP"}, // Upolu Airport
    IataCode{"URA"}, // Oral Ak Zhol Airport
    IataCode{"URB"}, // Urubupunga Airport
    IataCode{"URC"}, // Ürümqi Diwopu International Airport
    IataCode{"URE"}, // Kuressaare Airport
    IataCode{"URG"}, // Ruben Berta International Airport
    IataCode{"URJ"}, // Uray Airport
    IataCode{"URO"}, // Rouen Airport
    IataCode{"URR"}, // Urrao Airport
    IataCode{"URS"}, // Kursk Vostochny Airport
    IataCode{"URT"}, // Surat Thani Airport
    IataCode{"URY"}, // Gurayat Domestic Airport
    IataCode{"USH"}, // Ushuaia – Malvinas Argentinas International Airport
    IataCode{"USI"}, // Mabaruma Airport
    IataCode{"USK"}, // Usinsk Airport
    IataCode{"USM"}, // Samui Airport
    IataCode{"USN"}, // Ulsan Airport
    IataCode{"USQ"}, // Uşak Airport
    IataCode{"USR"}, // Ust-Nera Airport
    IataCode{"USS"}, // Sancti Spíritus Airport
    IataCode{"UST"}, // Northeast Florida Regional Airport
    IataCode{"USU"}, // Francisco B. Reyes Airport
    IataCode{"UTA"}, // Mutare Airport
    IataCode{"UTB"}, // Muttaburra Airport
    IataCode{"UTG"}, // Quthing Airport
    IataCode{"UTH"}, // Udon Thani International Airport
    IataCode{"UTK"}, // Utirik Airport
    IataCode{"UTM"}, // Tunica Municipal Airport
    IataCode{"UTN"}, // Upington Airport
    IataCode{"UTO"}, // Indian Mountain LRRS Airport
    IataCode{"UTP"}, // U-Tapao International Airport
    IataCode{"UTS"}, // Ust-Tsylma Airport
    IataCode{"UTT"}, // Mthatha Airport
    IataCode{"UUA"}, // Bugulma Airport
    IataCode{"UUD"}, // Ulan-Ude Airport
    IataCode{"UUK"}, // Ugnu-Kuparuk Airport
    IataCode{"UUN"}, // Baruun-Urt Airport
    IataCode{"UUS"}, // Yuzhno-Sakhalinsk Airport
    IataCode{"UVA"}, // Garner Field
    IataCode{"UVE"}, // Ouvéa Airport
    IataCode{"UVF"}, // Hewanorra International Airport
    IataCode{"UVL"}, // El Kharga Airport
    IataCode{"UWA"}, // Ware Airport
    IataCode{"UXL"}, // Southland Field
    IataCode{"UYF"}, // Madison County Airport
    IataCode{"UYL"}, // Nyala Airport
    IataCode{"UYN"}, // Yulin Yuyang Airport
    IataCode{"UYU"}, // Joya Andina Airport
    IataCode{"UZC"}, // Ponikve Airport
    IataCode{"UZM"}, // Hope Bay Aerodrome
    IataCode{"UZU"}, // Curuzú Cuatiá Airport
    IataCode{"VAA"}, // Vaasa Airport
    IataCode{"VAF"}, // Valence-Chabeuil Airport
    IataCode{"VAG"}, // Varginha Airport
    IataCode{"VAH"}, // Vallegrande Airport
    IataCode{"VAI"}, // Vanimo Airport
    IataCode{"VAK"}, // Chevak Airport
    IataCode{"VAL"}, // Valenca Airport
    IataCode{"VAM"}, // Maamigili Airport
    IataCode{"VAN"}, // Van Ferit Melen Airport
    IataCode{"VAO"}, // Suavanao Airport
    IataCode{"VAP"}, // Viñamar Airport
    IataCode{"VAR"}, // Varna Airport
    IataCode{"VAS"}, // Sivas Airport
    IataCode{"VAT"}, // Vatomandry Airport
    IataCode{"VAV"}, // Vava'u International Airport
    IataCode{"VAW"}, // Vardø Airport, Svartnes
    IataCode{"VBC"}, // Mandalay Chanmyathazi Airport
    IataCode{"VBS"}, // Brescia Airport
    IataCode{"VBT"}, // Bentonville Municipal Airport
    IataCode{"VBV"}, // Vanuabalavu Airport
    IataCode{"VBY"}, // Visby Airport
    IataCode{"VCA"}, // Can Tho International Airport
    IataCode{"VCB"}, // Nut Tree Airport
    IataCode{"VCC"}, // Limbe Airport
    IataCode{"VCD"}, // Victoria River Downs Airport
    IataCode{"VCE"}, // Venice Marco Polo Airport
    IataCode{"VCF"}, // Valcheta Airport
    IataCode{"VCH"}, // Vichadero Airport
    IataCode{"VCL"}, // Chu Lai International Airport
    IataCode{"VCP"}, // Viracopos International Airport
    IataCode{"VCR"}, // Carora Airport
    IataCode{"VCS"}, // Con Dao Airport
    IataCode{"VCT"}, // Victoria Regional Airport
    IataCode{"VCV"}, // Southern California Logistics Airport
    IataCode{"VDA"}, // Ovda Airport
    IataCode{"VDB"}, // Fagernes Airport, Leirin
    IataCode{"VDC"}, // Vitória da Conquista Airport
    IataCode{"VDE"}, // El Hierro Airport
    IataCode{"VDF"}, // Tampa Executive Airport
    IataCode{"VDH"}, // Dong Hoi Airport
    IataCode{"VDI"}, // Vidalia Regional Airport
    IataCode{"VDM"}, // Gobernador Edgardo Castello Airport
    IataCode{"VDP"}, // Valle de la Pascua Airport
    IataCode{"VDR"}, // Villa Dolores Airport
    IataCode{"VDS"}, // Vadsø Airport
    IataCode{"VDY"}, // Vidyanagar Airport
    IataCode{"VDZ"}, // Valdez Airport
    IataCode{"VEE"}, // Venetie Airport
    IataCode{"VEL"}, // Vernal Regional Airport
    IataCode{"VER"}, // General Heriberto Jara International Airport
    IataCode{"VES"}, // Darke County Airport
    IataCode{"VEY"}, // Vestmannaeyjar Airport
    IataCode{"VFA"}, // Victoria Falls Airport
    IataCode{"VGA"}, // Vijayawada Airport
    IataCode{"VGC"}, // Hamilton Municipal Airport
    IataCode{"VGD"}, // Vologda Airport
    IataCode{"VGN"}, // Mindoro Airport
    IataCode{"VGO"}, // Vigo Airport
    IataCode{"VGT"}, // North Las Vegas Airport
    IataCode{"VGZ"}, // Villa Garzón Airport
    IataCode{"VHC"}, // Saurimo Airport
    IataCode{"VHM"}, // Vilhelmina Airport
    IataCode{"VHN"}, // Culberson County Airport
    IataCode{"VHV"}, // Verkhnevilyuysk Airport
    IataCode{"VHY"}, // Vichy – Charmeil Airport
    IataCode{"VHZ"}, // Vahitahi Airport
    IataCode{"VIA"}, // Videira Airport
    IataCode{"VIB"}, // Villa Constitución Airport
    IataCode{"VID"}, // Vidin Airfield
    IataCode{"VIE"}, // Wien-Schwechat Airport
    IataCode{"VIG"}, // Juan Pablo Pérez Alfonso Airport
    IataCode{"VIH"}, // Rolla National Airport
    IataCode{"VII"}, // Vinh Airport
    IataCode{"VIJ"}, // Virgin Gorda Airport
    IataCode{"VIL"}, // Dakhla Airport
    IataCode{"VIN"}, // Havryshivka Vinnytsia International Airport
    IataCode{"VIR"}, // Virginia Airport
    IataCode{"VIS"}, // Visalia Municipal Airport
    IataCode{"VIT"}, // Vitoria Airport
    IataCode{"VIV"}, // Vivigani Airfield
    IataCode{"VIX"}, // Eurico de Aguiar Salles Airport
    IataCode{"VJI"}, // Virginia Highlands Airport
    IataCode{"VKG"}, // Rach Gia Airport
    IataCode{"VKO"}, // Vnukovo International Airport
    IataCode{"VKT"}, // Vorkuta Airport
    IataCode{"VKX"}, // Potomac Airfield
    IataCode{"VLC"}, // Manises Airport
    IataCode{"VLD"}, // Valdosta Regional Airport
    IataCode{"VLE"}, // Valle Airport
    IataCode{"VLG"}, // Villa Gesell Airport
    IataCode{"VLI"}, // Bauerfield International Airport
    IataCode{"VLL"}, // Valladolid Airport
    IataCode{"VLM"}, // Lieutenant Colonel Rafael Pabón Airport
    IataCode{"VLN"}, // Arturo Michelena International Airport
    IataCode{"VLP"}, // Vila Rica Airport
    IataCode{"VLR"}, // Vallenar Airport
    IataCode{"VLS"}, // Valesdir Airport
    IataCode{"VLU"}, // Velikiye Luki Airport
    IataCode{"VLV"}, // Dr. Antonio Nicolás Briceño Airport
    IataCode{"VLY"}, // Anglesey Airport
    IataCode{"VME"}, // Villa Reynolds Airport
    IataCode{"VMI"}, // Dr. Juan Plate Airport
    IataCode{"VMR"}, // Presidente Néstor Kirchner Airport
    IataCode{"VMU"}, // Baimuru Airport
    IataCode{"VNC"}, // Venice Municipal Airport
    IataCode{"VND"}, // Vangaindrano Airport
    IataCode{"VNE"}, // Meucon Airport
    IataCode{"VNO"}, // Vilnius Airport
    IataCode{"VNS"}, // Lal Bahadur Shastri Airport
    IataCode{"VNT"}, // Ventspils International Airport
    IataCode{"VNX"}, // Vilankulo Airport
    IataCode{"VNY"}, // Van Nuys Airport
    IataCode{"VOD"}, // Vodochody Airport
    IataCode{"VOG"}, // Volgograd International Airport
    IataCode{"VOH"}, // Vohemar Airport
    IataCode{"VOI"}, // Voinjama Airport
    IataCode{"VOL"}, // Nea Anchialos National Airport
    IataCode{"VOT"}, // Votuporanga Airport
    IataCode{"VOZ"}, // Voronezh International Airport
    IataCode{"VPA"}, // Rodelillo Airfield
    IataCode{"VPC"}, // Cartersville Airport
    IataCode{"VPE"}, // Ondjiva Pereira Airport
    IataCode{"VPN"}, // Vopnafjörður Airport
    IataCode{"VPS"}, // Destin–Fort Walton Beach Airport
    IataCode{"VPY"}, // Chimoio Airport
    IataCode{"VPZ"}, // Porter County Regional Airport
    IataCode{"VQQ"}, // Cecil Airport
    IataCode{"VQS"}, // Antonio Rivera Rodríguez Airport
    IataCode{"VRA"}, // Juan Gualberto Gómez Airport
    IataCode{"VRB"}, // Vero Beach Municipal Airport
    IataCode{"VRC"}, // Virac Airport
    IataCode{"VRE"}, // Vredendal Airport
    IataCode{"VRI"}, // Varandey Airport
    IataCode{"VRL"}, // Vila Real Airport
    IataCode{"VRN"}, // Verona Villafranca Airport
    IataCode{"VRO"}, // Kawama Airport
    IataCode{"VRU"}, // Vryburg Airport
    IataCode{"VRY"}, // Værøy Airport
    IataCode{"VSA"}, // Carlos Rovirosa Pérez International Airport
    IataCode{"VSE"}, // Viseu Airport
    IataCode{"VSF"}, // Hartness State Airport
    IataCode{"VSG"}, // Luhansk International Airport
    IataCode{"VSK"}, // Vista Field
    IataCode{"VTB"}, // Vitebsk Vostochny Airport
    IataCode{"VTE"}, // Wattay International Airport
    IataCode{"VTG"}, // Vung Tau Airport
    IataCode{"VTN"}, // Miller Field
    IataCode{"VTR"}, // Rome Viterbo Airport
    IataCode{"VTU"}, // Hermanos Ameijeiras Airport
    IataCode{"VTZ"}, // Visakhapatnam Airport
    IataCode{"VUE"}, // Yuendumu Airport
    IataCode{"VUJ"}, // Stanly County Airport
    IataCode{"VUO"}, // Pearson Field
    IataCode{"VUP"}, // Alfonso López Pumarejo Airport
    IataCode{"VUS"}, // Veliky Ustyug Airport
    IataCode{"VVC"}, // La Vanguardia Airport
    IataCode{"VVI"}, // Viru Viru International Airport
    IataCode{"VVO"}, // Vladivostok International Airport
    IataCode{"VVZ"}, // Takhamalt Airport
    IataCode{"VXC"}, // Lichinga Airport
    IataCode{"VXE"}, // São Pedro Airport
    IataCode{"VXO"}, // Växjö Småland Airport
    IataCode{"VYI"}, // Vilyuisk Airport
    IataCode{"VYS"}, // Illinois Valley Regional Airport
    IataCode{"WAA"}, // Wales Airport
    IataCode{"WAE"}, // Wadi al-Dawasir Domestic Airport
    IataCode{"WAG"}, // Wanganui Airport
    IataCode{"WAH"}, // Harry Stern Airport
    IataCode{"WAI"}, // Ambalabe Airport
    IataCode{"WAK"}, // Ankazoabo Airport
    IataCode{"WAM"}, // Ambatondrazaka Airport
    IataCode{"WAP"}, // Alto Palena Airport
    IataCode{"WAQ"}, // Antsalova Airport
    IataCode{"WAT"}, // Waterford Airport
    IataCode{"WAW"}, // Warsaw Chopin Airport
    IataCode{"WAX"}, // Zuwarah Airport
    IataCode{"WAY"}, // Greene County Airport
    IataCode{"WAZ"}, // Warwick Airport
    IataCode{"WBB"}, // Stebbins Airport
    IataCode{"WBM"}, // Wapenamanda Airport
    IataCode{"WBO"}, // Antsoa Airport
    IataCode{"WBQ"}, // Beaver Airport
    IataCode{"WBR"}, // Roben-Hood Airport
    IataCode{"WBU"}, // Boulder Municipal Airport
    IataCode{"WBW"}, // Wilkes-Barre Wyoming Valley Airport
    IataCode{"WCA"}, // Gamboa Airport
    IataCode{"WCH"}, // Chaitén Airport
    IataCode{"WCR"}, // Chandalar Lake Airport
    IataCode{"WDG"}, // Enid Woodring Regional Airport
    IataCode{"WDH"}, // Windhoek Hosea Kutako International Airport
    IataCode{"WDR"}, // Barrow County Airport
    IataCode{"WDS"}, // Shiyan Wudangshan Airport
    IataCode{"WEF"}, // Weifang Airport
    IataCode{"WEH"}, // Weihai Dashuibo Airport
    IataCode{"WEI"}, // Weipa Airport
    IataCode{"WEL"}, // Welkom Airport
    IataCode{"WFB"}, // Ketchikan Harbor Seaplane Base
    IataCode{"WFI"}, // Fianarantsoa Airport
    IataCode{"WFK"}, // Northern Aroostook Regional Airport
    IataCode{"WGC"}, // Warangal Airport
    IataCode{"WGE"}, // Walgett Airport
    IataCode{"WGN"}, // Shaoyang Wugang Airport
    IataCode{"WGO"}, // Winchester Regional Airport
    IataCode{"WGP"}, // Mau Hau Airport
    IataCode{"WGT"}, // Wangaratta Airport
    IataCode{"WHD"}, // Hyder Seaplane Base
    IataCode{"WHF"}, // Wadi Halfa Airport
    IataCode{"WHK"}, // Whakatane Airport
    IataCode{"WHP"}, // Whiteman Airport
    IataCode{"WHS"}, // Whalsay Airport
    IataCode{"WHT"}, // Wharton Regional Airport
    IataCode{"WIB"}, // Wilbarger County Airport
    IataCode{"WIC"}, // Wick Airport
    IataCode{"WIK"}, // Waiheke Island Aerodrome
    IataCode{"WIL"}, // Wilson Airport
    IataCode{"WIN"}, // Winton Airport
    IataCode{"WIO"}, // Wilcannia Airport
    IataCode{"WIR"}, // Wairoa Aerodrome
    IataCode{"WJA"}, // Woja Airport
    IataCode{"WJF"}, // General William J. Fox Airfield
    IataCode{"WJR"}, // Wajir Airport
    IataCode{"WJU"}, // Wonju Airport
    IataCode{"WKA"}, // Wanaka Airport
    IataCode{"WKB"}, // Warracknabeal Airport
    IataCode{"WKI"}, // Hwange Town Airport
    IataCode{"WKJ"}, // Wakkanai Airport
    IataCode{"WKK"}, // Aleknagik Airport
    IataCode{"WKN"}, // Wakunai Airport
    IataCode{"WKR"}, // Walkers Cay Airport
    IataCode{"WLD"}, // Strother Field
    IataCode{"WLE"}, // Miles Airport
    IataCode{"WLG"}, // Wellington International Airport
    IataCode{"WLH"}, // Walaha Airport
    IataCode{"WLK"}, // Selawik Airport
    IataCode{"WLS"}, // Hihifo Airport
    IataCode{"WLW"}, // Willows-Glenn County Airport
    IataCode{"WMA"}, // Mandritsara Airport
    IataCode{"WMB"}, // Warrnambool Airport
    IataCode{"WMC"}, // Winnemucca Municipal Airport
    IataCode{"WMD"}, // Mandabe Airport
    IataCode{"WME"}, // Mount Keith Airport
    IataCode{"WMH"}, // Ozark Regional Airport
    IataCode{"WMI"}, // Warsaw-Modlin Mazovia Airport
    IataCode{"WML"}, // West Melton Aerodrome
    IataCode{"WMN"}, // Maroantsetra Airport
    IataCode{"WMO"}, // White Mountain Airport
    IataCode{"WMP"}, // Mampikony Airport
    IataCode{"WMR"}, // Mananara Nord Airport
    IataCode{"WMX"}, // Wamena Airport
    IataCode{"WNA"}, // Napakiak Airport
    IataCode{"WNC"}, // Naukati Bay Seaplane Base
    IataCode{"WNH"}, // Wenshan Puzhehei Airport
    IataCode{"WNN"}, // Wunnummin Lake Airport
    IataCode{"WNP"}, // Naga Airport
    IataCode{"WNR"}, // Windorah Airport
    IataCode{"WNS"}, // Nawabshah Airport
    IataCode{"WNZ"}, // Wenzhou Yongqiang International Airport
    IataCode{"WOL"}, // Illawarra Regional Airport
    IataCode{"WON"}, // Wondoola Airport
    IataCode{"WOS"}, // Wonsan Airport
    IataCode{"WOT"}, // Wang-an Airport
    IataCode{"WOW"}, // Willow Airport
    IataCode{"WPA"}, // Cabo Juan Román Airfield
    IataCode{"WPB"}, // Port Bergé Airport
    IataCode{"WPC"}, // Pincher Creek Airport
    IataCode{"WPL"}, // Powell Lake Water Aerodrome
    IataCode{"WPR"}, // Capitan Fuentes Martinez Airport
    IataCode{"WPU"}, // Guardiamarina Zañartu Airport
    IataCode{"WRE"}, // Whangarei Airport
    IataCode{"WRG"}, // Wrangell Airport
    IataCode{"WRL"}, // Worland Municipal Airport
    IataCode{"WRN"}, // Windarling Airport
    IataCode{"WRO"}, // Wrocław – Copernicus Airport
    IataCode{"WRR"}, // Werur Airport
    IataCode{"WRT"}, // Warton Aerodrome
    IataCode{"WRY"}, // Westray Airport
    IataCode{"WSE"}, // Santa Cecilia Airport
    IataCode{"WSF"}, // Cape Sarichef Airport
    IataCode{"WSG"}, // Washington County Airport
    IataCode{"WSH"}, // Brookhaven Airport
    IataCode{"WSJ"}, // San Juan (Uganik) Seaplane Base
    IataCode{"WSN"}, // Lt. Col. Wisnu Airfield
    IataCode{"WSO"}, // Washabo Airport
    IataCode{"WSP"}, // Waspam Airport
    IataCode{"WST"}, // Westerly State Airport
    IataCode{"WSX"}, // Westsound/WSX Seaplane Base
    IataCode{"WSZ"}, // Westport Airport, New Zealand
    IataCode{"WTA"}, // Tambohorano Airport
    IataCode{"WTB"}, // Brisbane West Wellcamp Airport
    IataCode{"WTD"}, // West End Airport
    IataCode{"WTE"}, // Wotje Airport
    IataCode{"WTK"}, // Noatak Airport
    IataCode{"WTL"}, // Tuntutuliak Airport
    IataCode{"WTO"}, // Wotho Airport
    IataCode{"WTP"}, // Woitape Airport
    IataCode{"WTR"}, // Whiteriver Airport
    IataCode{"WTS"}, // Tsiroanomandidy Airport
    IataCode{"WTZ"}, // Whitianga Aerodrome
    IataCode{"WUA"}, // Wuhai Airport
    IataCode{"WUB"}, // Buli Airport
    IataCode{"WUD"}, // Wudinna Airport
    IataCode{"WUG"}, // Wau Airport, Papua New Guinea
    IataCode{"WUH"}, // Wuhan Tianhe International Airport
    IataCode{"WUI"}, // Murrin Murrin Airport
    IataCode{"WUN"}, // Wiluna Airport
    IataCode{"WUS"}, // Wuyishan Airport
    IataCode{"WUT"}, // Xinzhou Wutaishan Airport
    IataCode{"WUU"}, // Wau Airport
    IataCode{"WUX"}, // Sunan Shuofang International Airport
    IataCode{"WUZ"}, // Wuzhou Changzhoudao Airport
    IataCode{"WVB"}, // Walvis Bay Airport
    IataCode{"WVI"}, // Watsonville Municipal Airport
    IataCode{"WVK"}, // Manakara Airport
    IataCode{"WVL"}, // Waterville Robert LaFleur Airport
    IataCode{"WWA"}, // Wasilla Airport
    IataCode{"WWD"}, // Cape May Airport
    IataCode{"WWK"}, // Wewak Airport
    IataCode{"WWP"}, // North Whale Seaplane Base
    IataCode{"WWR"}, // West Woodward Airport
    IataCode{"WWT"}, // Newtok Airport
    IataCode{"WWY"}, // West Wyalong Airport
    IataCode{"WXN"}, // Wanzhou Wuqiao Airport
    IataCode{"WYA"}, // Whyalla Airport
    IataCode{"WYE"}, // Yengema Airport
    IataCode{"WYN"}, // Wyndham Airport
    IataCode{"WYS"}, // Yellowstone Airport
    IataCode{"XAB"}, // Aerodrome Abbeville
    IataCode{"XAP"}, // Chapecó Airport
    IataCode{"XAR"}, // Aribinda Airport
    IataCode{"XAU"}, // Saül Airport
    IataCode{"XBE"}, // Bearskin Lake Airport
    IataCode{"XBG"}, // Bogande Airport
    IataCode{"XBJ"}, // Birjand International Airport
    IataCode{"XBK"}, // Bourg – Ceyzériat Airport
    IataCode{"XBO"}, // Boulsa Airport
    IataCode{"XBP"}, // Bridgeport Municipal Airport
    IataCode{"XBQ"}, // Blois - Le Breuil Airport
    IataCode{"XBR"}, // Brockville-Thousand Islands Regional Tackaberry Airport
    IataCode{"XCD"}, // Chalon – Champforgeuil Airport
    IataCode{"XCH"}, // Christmas Island Airport
    IataCode{"XCL"}, // Cluff Lake Airport
    IataCode{"XCM"}, // Chatham-Kent Airport
    IataCode{"XCR"}, // Châlons Vatry Airport
    IataCode{"XCY"}, // Château-Thierry – Belleau Aerodrome
    IataCode{"XCZ"}, // Charleville-Mézières Airport
    IataCode{"XDE"}, // Diébougou Airport
    IataCode{"XDJ"}, // Djibo Airport
    IataCode{"XDR"}, // Vernouillet Airport
    IataCode{"XEP"}, // Épernay Plivot Airport
    IataCode{"XES"}, // Grand Geneva Resort Airport
    IataCode{"XFN"}, // Xiangyang Liuji Airport
    IataCode{"XGA"}, // Gaoua Airport
    IataCode{"XGG"}, // Gorom Gorom Airport
    IataCode{"XGN"}, // Xangongo Airport
    IataCode{"XGR"}, // Kangiqsualujjuaq (Georges River) Airport
    IataCode{"XIC"}, // Xichang Qingshan Airport
    IataCode{"XIG"}, // Xinguara Municipal Airport
    IataCode{"XIL"}, // Xilinhot Airport
    IataCode{"XIY"}, // Xi'an Xianyang International Airport
    IataCode{"XJM"}, // Gurha Salim Airport
    IataCode{"XKA"}, // Kantchari Airport
    IataCode{"XKH"}, // Xieng Khouang Airport
    IataCode{"XKS"}, // Kasabonika Airport
    IataCode{"XKY"}, // Kaya Airport
    IataCode{"XLB"}, // Lac Brochet Airport
    IataCode{"XLG"}, // Lognes-Émerainville Aerodrome
    IataCode{"XLL"}, // Greensboro North Airport
    IataCode{"XLS"}, // Saint-Louis Airport
    IataCode{"XLU"}, // Leo Airport
    IataCode{"XMC"}, // Mallacoota Airport
    IataCode{"XMD"}, // Madison Municipal Airport
    IataCode{"XME"}, // Maubeuge - Élesmes Airport
    IataCode{"XMF"}, // Montbéliard – Courcelles Aerodrome
    IataCode{"XMG"}, // Mahendranagar Airport
    IataCode{"XMH"}, // Manihi Airport
    IataCode{"XMI"}, // Masasi Airport
    IataCode{"XMN"}, // Xiamen Gaoqi International Airport
    IataCode{"XMP"}, // Macmillian Pass Airport
    IataCode{"XMS"}, // Edmundo Carvajal Airport
    IataCode{"XMU"}, // Moulins – Montbeugny Airport
    IataCode{"XMW"}, // Montauban Airport
    IataCode{"XMY"}, // Yam Island Airport
    IataCode{"XNA"}, // Northwest Arkansas Regional Airport
    IataCode{"XNN"}, // Xining Caojiabao Airport
    IataCode{"XNO"}, // North Auxiliary Airfield
    IataCode{"XNT"}, // Xingtai Dalian Airport
    IataCode{"XNU"}, // Nouna Airport
    IataCode{"XPA"}, // Pama Airport
    IataCode{"XPK"}, // Pukatawagan Airport
    IataCode{"XPP"}, // Poplar River Airport
    IataCode{"XPR"}, // Pine Ridge Airport
    IataCode{"XQP"}, // Quepos La Managua Airport
    IataCode{"XQU"}, // Qualicum Beach Airport
    IataCode{"XRR"}, // Ross River Airport
    IataCode{"XRY"}, // Jerez Airport
    IataCode{"XSA"}, // Tappahannock-Essex County Airport
    IataCode{"XSB"}, // Sir Bani Yas Airport
    IataCode{"XSC"}, // South Caicos Airport
    IataCode{"XSD"}, // Tonopah Test Range Airport
    IataCode{"XSE"}, // Sebba Airport
    IataCode{"XSI"}, // South Indian Lake Airport
    IataCode{"XSJ"}, // Peronne-St Quentin Airport
    IataCode{"XSN"}, // Sallanches Aerodrome
    IataCode{"XSP"}, // Seletar Airport
    IataCode{"XSU"}, // Saumur - Saint-Florent Airport
    IataCode{"XTG"}, // Thargomindah Airport
    IataCode{"XTL"}, // Tadoule Lake Airport
    IataCode{"XTO"}, // Taroom Airport
    IataCode{"XUD"}, // Cranfield Airport
    IataCode{"XUZ"}, // Xuzhou Guanyin Airport
    IataCode{"XVF"}, // Villefranche – Tarare Airport
    IataCode{"XVG"}, // Longville Municipal Airport
    IataCode{"XVN"}, // Verdun-Le-Rozelier Airport
    IataCode{"XVO"}, // Vesoul - Frotey Airport
    IataCode{"XVS"}, // Valenciennes-Denain Airport
    IataCode{"XWA"}, // Williston Basin International Airport
    IataCode{"XYA"}, // Yandina Airport
    IataCode{"XYP"}, // Persan-Beaumont Airport
    IataCode{"XZA"}, // Zabré Airport
    IataCode{"XZB"}, // Saint-Cyr-l'École Airport
    IataCode{"XZX"}, // Chavenay - Villepreux Airport
    IataCode{"YAA"}, // Anahim Lake Airport
    IataCode{"YAB"}, // Arctic Bay Airport
    IataCode{"YAC"}, // Cat Lake Airport
    IataCode{"YAG"}, // Fort Frances Municipal Airport
    IataCode{"YAH"}, // La Grande-4 Airport
    IataCode{"YAI"}, // General Bernardo O'Higgins Airport
    IataCode{"YAK"}, // Yakutat Airport
    IataCode{"YAL"}, // Alert Bay Airport
    IataCode{"YAM"}, // Sault Ste. Marie Airport
    IataCode{"YAN"}, // Yangambi Airport
    IataCode{"YAO"}, // Yaoundé Airport
    IataCode{"YAP"}, // Yap International Airport
    IataCode{"YAR"}, // La Grande-3 Airport
    IataCode{"YAS"}, // Sandy Point Airport
    IataCode{"YAT"}, // Attawapiskat Airport
    IataCode{"YAU"}, // Kattiniq/Donaldson Airport
    IataCode{"YAV"}, // Mayne Island Water Aerodrome
    IataCode{"YAX"}, // Angling Lake/Wapekeka Airport
    IataCode{"YAY"}, // St. Anthony Airport
    IataCode{"YAZ"}, // Tofino/Long Beach Airport
    IataCode{"YBA"}, // Banff Airport
    IataCode{"YBB"}, // Kugaaruk Airport
    IataCode{"YBC"}, // Baie-Comeau Airport
    IataCode{"YBE"}, // Uranium City Airport
    IataCode{"YBF"}, // Bamfield Water Aerodrome
    IataCode{"YBI"}, // Black Tickle Airport
    IataCode{"YBJ"}, // Baie-Johan-Beetz Seaplane Base
    IataCode{"YBK"}, // Baker Lake Airport
    IataCode{"YBL"}, // Campbell River Airport
    IataCode{"YBM"}, // Bronson Creek Airport
    IataCode{"YBO"}, // Bob Quinn Lake Airport
    IataCode{"YBP"}, // Yibin Caiba Airport
    IataCode{"YBR"}, // Brandon Municipal Airport
    IataCode{"YBS"}, // Opapimiskan Lake Airport
    IataCode{"YBT"}, // Brochet Airport
    IataCode{"YBU"}, // Nipawin Airport
    IataCode{"YBV"}, // Berens River Airport
    IataCode{"YBW"}, // Bedwell Harbour Water Aerodrome
    IataCode{"YBX"}, // Lourdes-de-Blanc-Sablon Airport
    IataCode{"YBY"}, // Bonnyville Airport
    IataCode{"YCA"}, // Courtenay Airpark
    IataCode{"YCB"}, // Cambridge Bay Airport
    IataCode{"YCC"}, // Cornwall Regional Airport
    IataCode{"YCD"}, // Nanaimo Airport
    IataCode{"YCE"}, // Centralia/James T. Field Memorial Aerodrome
    IataCode{"YCF"}, // Cortes Island (Hansen Airfield) Airport
    IataCode{"YCG"}, // West Kootenay Regional Airport
    IataCode{"YCH"}, // Miramichi Airport
    IataCode{"YCK"}, // Colville Lake Airport
    IataCode{"YCL"}, // Charlo Airport
    IataCode{"YCM"}, // St. Catharines/Niagara District Airport
    IataCode{"YCN"}, // Cochrane Airport
    IataCode{"YCO"}, // Kugluktuk Airport
    IataCode{"YCP"}, // Blue River Airport
    IataCode{"YCQ"}, // Chetwynd Airport
    IataCode{"YCR"}, // Cross Lake Airport
    IataCode{"YCS"}, // Chesterfield Inlet Airport
    IataCode{"YCT"}, // Coronation Airport
    IataCode{"YCU"}, // Yuncheng Guangong Airport
    IataCode{"YCW"}, // Chilliwack Airport
    IataCode{"YCY"}, // Clyde River Airport
    IataCode{"YCZ"}, // Fairmont Hot Springs Airport
    IataCode{"YDA"}, // Dawson City Airport
    IataCode{"YDB"}, // Burwash Airport
    IataCode{"YDC"}, // Drayton Valley Industrial Airport
    IataCode{"YDE"}, // Paradise River Airport
    IataCode{"YDF"}, // Deer Lake Regional Airport
    IataCode{"YDG"}, // Digby/Annapolis Regional Airport
    IataCode{"YDJ"}, // Hatchet Lake Airport
    IataCode{"YDL"}, // Dease Lake Airport
    IataCode{"YDN"}, // Lt. Col W.G. (Billy) Barker VC Airport
    IataCode{"YDO"}, // Dolbeau-Saint-Félicien Airport
    IataCode{"YDP"}, // Nain Airport
    IataCode{"YDQ"}, // Dawson Creek Airport
    IataCode{"YDT"}, // Boundary Bay Airport
    IataCode{"YDU"}, // Kasba Lake Airport
    IataCode{"YDV"}, // Bloodvein River Airport
    IataCode{"YDW"}, // Obre Lake/North of Sixty Airport
    IataCode{"YEA"}, // Empress Airport
    IataCode{"YEB"}, // Bar River Airport
    IataCode{"YEE"}, // Midland/Huronia Airport
    IataCode{"YEG"}, // Edmonton International Airport
    IataCode{"YEH"}, // Asalouyeh Airport
    IataCode{"YEK"}, // Arviat Airport
    IataCode{"YEL"}, // Elliot Lake Municipal Airport
    IataCode{"YEM"}, // Manitowaning/Manitoulin East Municipal Airport
    IataCode{"YEN"}, // Estevan Regional Aerodrome
    IataCode{"YER"}, // Fort Severn Airport
    IataCode{"YES"}, // Yasuj Airport
    IataCode{"YET"}, // Edson Airport
    IataCode{"YEU"}, // Eureka Aerodrome
    IataCode{"YEV"}, // Inuvik (Mike Zubko) Airport
    IataCode{"YEY"}, // Amos/Magny Airport
    IataCode{"YFA"}, // Fort Albany Airport
    IataCode{"YFB"}, // Iqaluit Airport
    IataCode{"YFC"}, // Fredericton International Airport
    IataCode{"YFD"}, // Brantford Airport
    IataCode{"YFE"}, // Forestville Airport
    IataCode{"YFG"}, // Fontages Airport
    IataCode{"YFH"}, // Fort Hope Airport
    IataCode{"YFI"}, // Fort MacKay/Firebag Aerodrome
    IataCode{"YFJ"}, // Wekweètì Airport
    IataCode{"YFL"}, // Fort Reliance Water Aerodrome
    IataCode{"YFO"}, // Flin Flon Airport
    IataCode{"YFR"}, // Fort Resolution Airport
    IataCode{"YFS"}, // Fort Simpson Airport
    IataCode{"YFX"}, // St. Lewis (Fox Harbour) Airport
    IataCode{"YGA"}, // Lac Gagnon Water Aerodrome
    IataCode{"YGB"}, // Texada/Gillies Bay Airport
    IataCode{"YGC"}, // Grande Cache Airport
    IataCode{"YGD"}, // Goderich Airport
    IataCode{"YGE"}, // Golden Airport
    IataCode{"YGG"}, // Ganges Water Aerodrome
    IataCode{"YGH"}, // Fort Good Hope Airport
    IataCode{"YGJ"}, // Miho-Yonago Airport
    IataCode{"YGK"}, // Kingston/Norman Rogers Airport
    IataCode{"YGL"}, // La Grande Rivière Airport
    IataCode{"YGM"}, // Gimli Industrial Park Airport
    IataCode{"YGO"}, // Gods Lake Narrows Airport
    IataCode{"YGP"}, // Michel-Pouliot Gaspé Airport
    IataCode{"YGQ"}, // Geraldton (Greenstone Regional) Airport
    IataCode{"YGR"}, // Îles-de-la-Madeleine Airport
    IataCode{"YGT"}, // Igloolik Airport
    IataCode{"YGV"}, // Havre Saint-Pierre Airport
    IataCode{"YGW"}, // Kuujjuarapik Airport
    IataCode{"YGX"}, // Gillam Airport
    IataCode{"YGZ"}, // Grise Fiord Airport
    IataCode{"YHA"}, // Port Hope Simpson Airport
    IataCode{"YHB"}, // Hudson Bay Airport
    IataCode{"YHD"}, // Dryden Regional Airport
    IataCode{"YHE"}, // Hope Aerodrome
    IataCode{"YHF"}, // Hearst (René Fontaine) Municipal Airport
    IataCode{"YHG"}, // Charlottetown Airport
    IataCode{"YHH"}, // Campbell River Water Aerodrome
    IataCode{"YHI"}, // Ulukhaktok/Holman Airport
    IataCode{"YHK"}, // Gjoa Haven Airport
    IataCode{"YHM"}, // John C. Munro Hamilton International Airport
    IataCode{"YHN"}, // Hornepayne Municipal Airport
    IataCode{"YHO"}, // Hopedale Airport
    IataCode{"YHP"}, // Poplar Hill Airport
    IataCode{"YHR"}, // Chevery Airport
    IataCode{"YHS"}, // Sechelt Aerodrome
    IataCode{"YHT"}, // Haines Junction Airport
    IataCode{"YHU"}, // Montréal/Saint-Hubert Airport
    IataCode{"YHY"}, // Hay River/Merlyn Carter Airport
    IataCode{"YHZ"}, // Halifax Stanfield International Airport
    IataCode{"YIB"}, // Atikokan Municipal Airport
    IataCode{"YIC"}, // Yichun Mingyueshan Airport
    IataCode{"YIE"}, // Arxan Yi'ershi Airport
    IataCode{"YIF"}, // Saint-Augustin Airport
    IataCode{"YIG"}, // Big Bay Water Aerodrome
    IataCode{"YIH"}, // Yichang Airport
    IataCode{"YIK"}, // Ivujivik Airport
    IataCode{"YIN"}, // Yining Airport
    IataCode{"YIO"}, // Pond Inlet Airport
    IataCode{"YIP"}, // Willow Run Airport
    IataCode{"YIV"}, // Island Lake Airport
    IataCode{"YIW"}, // Yiwu Airport
    IataCode{"YJA"}, // Jasper Airport
    IataCode{"YJF"}, // Fort Liard Airport
    IataCode{"YJM"}, // Fort St. James (Perison) Airport
    IataCode{"YJN"}, // Saint-Jean Airport
    IataCode{"YJP"}, // Hinton/Jasper-Hinton Airport
    IataCode{"YJS"}, // Samjiyŏn Airport
    IataCode{"YJT"}, // Stephenville International Airport
    IataCode{"YKA"}, // Kamloops Airport
    IataCode{"YKC"}, // Collins Bay Airport
    IataCode{"YKD"}, // Kincardine Airport
    IataCode{"YKE"}, // Knee Lake Airport
    IataCode{"YKF"}, // Region of Waterloo International Airport
    IataCode{"YKG"}, // Kangirsuk Airport
    IataCode{"YKH"}, // Yingkou Lanqi Airport
    IataCode{"YKJ"}, // Key Lake Airport
    IataCode{"YKK"}, // Kitkatla Water Aerodrome
    IataCode{"YKL"}, // Schefferville Airport
    IataCode{"YKM"}, // Yakima Air Terminal
    IataCode{"YKN"}, // Chan Gurney Municipal Airport
    IataCode{"YKO"}, // Hakkari Yüksekova Airport
    IataCode{"YKQ"}, // Waskaganish Airport
    IataCode{"YKS"}, // Yakutsk Airport
    IataCode{"YKU"}, // Chisasibi Airport
    IataCode{"YKX"}, // Kirkland Lake Airport
    IataCode{"YKY"}, // Kindersley Regional Airport
    IataCode{"YKZ"}, // Buttonville Municipal Airport
    IataCode{"YLB"}, // Lac La Biche Airport
    IataCode{"YLC"}, // Kimmirut Airport
    IataCode{"YLD"}, // Chapleau Airport
    IataCode{"YLE"}, // Whatì Airport
    IataCode{"YLH"}, // Lansdowne House Airport
    IataCode{"YLJ"}, // Meadow Lake Airport
    IataCode{"YLK"}, // Lake Simcoe Regional Airport
    IataCode{"YLL"}, // Lloydminster Airport
    IataCode{"YLQ"}, // La Tuque Airport
    IataCode{"YLR"}, // Leaf Rapids Airport
    IataCode{"YLS"}, // Lebel-sur-Quévillon Airport
    IataCode{"YLT"}, // Alert Airport
    IataCode{"YLV"}, // Yevlakh Airport
    IataCode{"YLW"}, // Kelowna International Airport
    IataCode{"YLY"}, // Langley Regional Airport
    IataCode{"YMA"}, // Mayo Airport
    IataCode{"YMB"}, // Merritt Airport
    IataCode{"YMD"}, // Mould Bay Airport
    IataCode{"YME"}, // Matane Airport
    IataCode{"YMG"}, // Manitouwadge Airport
    IataCode{"YMH"}, // Mary's Harbour Airport
    IataCode{"YML"}, // Charlevoix Airport
    IataCode{"YMM"}, // Fort McMurray International Airport
    IataCode{"YMN"}, // Makkovik Airport
    IataCode{"YMO"}, // Moosonee Airport
    IataCode{"YMP"}, // Port McNeill Airport
    IataCode{"YMS"}, // Moisés Benzaquén Rengifo Airport
    IataCode{"YMT"}, // Chibougamau/Chapais Airport
    IataCode{"YMU"}, // Mansons Landing Water Aerodrome
    IataCode{"YMV"}, // Mary River Aerodrome
    IataCode{"YMW"}, // Maniwaki Airport
    IataCode{"YMX"}, // Montréal–Mirabel International Airport
    IataCode{"YMY"}, // Victoria STOLport
    IataCode{"YNA"}, // Natashquan Airport
    IataCode{"YNB"}, // Yanbu Airport
    IataCode{"YNC"}, // Wemindji Airport
    IataCode{"YND"}, // Gatineau-Ottawa Executive Airport
    IataCode{"YNE"}, // Norway House Airport
    IataCode{"YNG"}, // Youngstown-Warren Regional Airport
    IataCode{"YNH"}, // Hudson's Hope Airport
    IataCode{"YNJ"}, // Yanji Chaoyangchuan Airport
    IataCode{"YNL"}, // Points North Landing Airport
    IataCode{"YNM"}, // Matagami Airport
    IataCode{"YNO"}, // North Spirit Lake Airport
    IataCode{"YNP"}, // Natuashish Airport
    IataCode{"YNR"}, // Arnes Airport
    IataCode{"YNS"}, // Nemiscau Airport
    IataCode{"YNT"}, // Yantai Penglai International Airport
    IataCode{"YNX"}, // Snap Lake Airport
    IataCode{"YNY"}, // Yangyang International Airport
    IataCode{"YNZ"}, // Yancheng Nanyang Airport
    IataCode{"YOA"}, // Ekati Airport
    IataCode{"YOC"}, // Old Crow Airport
    IataCode{"YOE"}, // Donnelly Airport
    IataCode{"YOG"}, // Ogoki Post Airport
    IataCode{"YOH"}, // Oxford House Airport
    IataCode{"YOI"}, // Opinaca Aerodrome
    IataCode{"YOJ"}, // High Level Airport
    IataCode{"YOL"}, // Yola Airport
    IataCode{"YON"}, // Yongphulla Airport
    IataCode{"YOO"}, // Oshawa Airport
    IataCode{"YOP"}, // Rainbow Lake Airport
    IataCode{"YOS"}, // Owen Sound Billy Bishop Regional Airport
    IataCode{"YOT"}, // Yotvata Airfield
    IataCode{"YOW"}, // Ottawa Macdonald-Cartier International Airport
    IataCode{"YPA"}, // Prince Albert (Glass Field) Airport
    IataCode{"YPB"}, // Port Alberni (Alberni Valley Regional) Airport
    IataCode{"YPC"}, // Paulatuk (Nora Aliqatchialuk Ruben) Airport
    IataCode{"YPD"}, // Parry Sound Area Municipal Airport
    IataCode{"YPE"}, // Peace River Airport
    IataCode{"YPF"}, // Esquimalt Airport
    IataCode{"YPG"}, // Portage la Prairie Southport Airport
    IataCode{"YPH"}, // Inukjuak Airport
    IataCode{"YPI"}, // Port Simpson Water Aerodrome
    IataCode{"YPJ"}, // Aupaluk Airport
    IataCode{"YPK"}, // Pitt Meadows Airport
    IataCode{"YPL"}, // Pickle Lake Airport
    IataCode{"YPM"}, // Pikangikum Airport
    IataCode{"YPN"}, // Port-Menier Airport
    IataCode{"YPO"}, // Peawanuck Airport
    IataCode{"YPQ"}, // Peterborough Airport
    IataCode{"YPR"}, // Prince Rupert Airport
    IataCode{"YPS"}, // Port Hawkesbury Airport
    IataCode{"YPT"}, // Pender Harbour Water Aerodrome
    IataCode{"YPW"}, // Powell River Airport
    IataCode{"YPX"}, // Puvirnituq Airport
    IataCode{"YPY"}, // Fort Chipewyan Airport
    IataCode{"YPZ"}, // Burns Lake Airport
    IataCode{"YQA"}, // Muskoka Airport
    IataCode{"YQB"}, // Québec City Jean Lesage International Airport
    IataCode{"YQC"}, // Quaqtaq Airport
    IataCode{"YQD"}, // The Pas Airport
    IataCode{"YQF"}, // Red Deer Regional Airport
    IataCode{"YQG"}, // Windsor International Airport
    IataCode{"YQH"}, // Watson Lake Airport
    IataCode{"YQI"}, // Yarmouth Airport
    IataCode{"YQK"}, // Kenora Airport
    IataCode{"YQL"}, // Lethbridge Airport
    IataCode{"YQM"}, // Greater Moncton International Airport
    IataCode{"YQN"}, // Nakina Airport
    IataCode{"YQR"}, // Regina International Airport
    IataCode{"YQS"}, // St. Thomas Municipal Airport
    IataCode{"YQT"}, // Thunder Bay International Airport
    IataCode{"YQU"}, // Grande Prairie Airport
    IataCode{"YQV"}, // Yorkton Municipal Airport
    IataCode{"YQW"}, // North Battleford Airport
    IataCode{"YQX"}, // Gander International Airport
    IataCode{"YQY"}, // Sydney/J.A. Douglas McCurdy Airport
    IataCode{"YQZ"}, // Quesnel Airport
    IataCode{"YRA"}, // Gamètì/Rae Lakes Airport
    IataCode{"YRB"}, // Resolute Bay Airport
    IataCode{"YRC"}, // Chicoutimi/Saint-Honoré Aerodrome
    IataCode{"YRF"}, // Cartwright Airport
    IataCode{"YRG"}, // Rigolet Airport
    IataCode{"YRI"}, // Rivière-du-Loup Airport
    IataCode{"YRJ"}, // Roberval Airport
    IataCode{"YRL"}, // Red Lake Airport
    IataCode{"YRM"}, // Rocky Mountain House Airport
    IataCode{"YRN"}, // Rivers Inlet Water Aerodrome
    IataCode{"YRO"}, // Ottawa/Rockcliffe Airport
    IataCode{"YRP"}, // Carp Airport
    IataCode{"YRQ"}, // Trois-Rivières Airport
    IataCode{"YRS"}, // Red Sucker Lake Airport
    IataCode{"YRT"}, // Rankin Inlet Airport
    IataCode{"YRV"}, // Revelstoke Airport
    IataCode{"YSA"}, // Sable Island Aerodrome
    IataCode{"YSB"}, // Sudbury Airport
    IataCode{"YSC"}, // Sherbrooke Airport
    IataCode{"YSE"}, // Squamish Airport
    IataCode{"YSF"}, // Stony Rapids Airport
    IataCode{"YSG"}, // Lutselk'e Airport
    IataCode{"YSH"}, // Smiths Falls-Montague Airport
    IataCode{"YSI"}, // Parry Sound/Frying Pan Island-Sans Souci Water Aerodrome
    IataCode{"YSJ"}, // Saint John Airport
    IataCode{"YSK"}, // Sanikiluaq Airport
    IataCode{"YSL"}, // Saint-Léonard Aerodrome
    IataCode{"YSM"}, // Fort Smith Airport
    IataCode{"YSN"}, // Salmon Arm Airport
    IataCode{"YSO"}, // Postville Airport
    IataCode{"YSP"}, // Marathon Aerodrome
    IataCode{"YSQ"}, // Songyuan Chaganhu Airport
    IataCode{"YSR"}, // Nanisivik Airport
    IataCode{"YST"}, // St. Theresa Point Airport
    IataCode{"YSU"}, // Summerside Airport
    IataCode{"YSV"}, // Saglek Airport
    IataCode{"YSX"}, // Bella Bella/Shearwater Water Aerodrome
    IataCode{"YSY"}, // Sachs Harbour (David Nasogaluak Jr. Saaryuaq) Airport
    IataCode{"YTA"}, // Pembroke Airport
    IataCode{"YTB"}, // Hartley Bay Water Aerodrome
    IataCode{"YTD"}, // Thicket Portage Airport
    IataCode{"YTE"}, // Cape Dorset Airport
    IataCode{"YTF"}, // Alma Airport
    IataCode{"YTG"}, // Sullivan Bay Water Aerodrome
    IataCode{"YTH"}, // Thompson Airport
    IataCode{"YTJ"}, // Terrace Bay Airport
    IataCode{"YTL"}, // Big Trout Lake Airport
    IataCode{"YTM"}, // Mont Tremblant International Airport
    IataCode{"YTN"}, // Trenton Aerodrome
    IataCode{"YTP"}, // Tofino Harbour Water Aerodrome
    IataCode{"YTQ"}, // Tasiujaq Airport
    IataCode{"YTS"}, // Timmins/Victor M. Power Airport
    IataCode{"YTT"}, // Tisdale Airport
    IataCode{"YTU"}, // Tasu Water Aerodrome
    IataCode{"YTX"}, // Telegraph Creek Airport
    IataCode{"YTY"}, // Yangzhou Taizhou Airport
    IataCode{"YTZ"}, // Billy Bishop Toronto City Airport
    IataCode{"YUB"}, // Tuktoyaktuk/James Gruben Airport
    IataCode{"YUD"}, // Umiujaq Airport
    IataCode{"YUE"}, // Yuendumu Airport
    IataCode{"YUL"}, // Montréal–Pierre Elliott Trudeau International Airport
    IataCode{"YUM"}, // Yuma International Airport
    IataCode{"YUS"}, // Yushu Batang Airport
    IataCode{"YUT"}, // Repulse Bay Airport
    IataCode{"YUX"}, // Hall Beach Airport
    IataCode{"YUY"}, // Rouyn-Noranda Airport
    IataCode{"YVA"}, // Iconi Airport
    IataCode{"YVB"}, // Bonaventure Airport
    IataCode{"YVC"}, // La Ronge (Barber Field) Airport
    IataCode{"YVE"}, // Vernon Regional Airport
    IataCode{"YVG"}, // Vermilion Airport
    IataCode{"YVM"}, // Qikiqtarjuaq Airport
    IataCode{"YVO"}, // Val-d'Or Airport
    IataCode{"YVP"}, // Kuujjuaq Airport
    IataCode{"YVQ"}, // Norman Wells Airport
    IataCode{"YVR"}, // Vancouver International Airport
    IataCode{"YVT"}, // Buffalo Narrows Airport
    IataCode{"YVV"}, // Wiarton Airport
    IataCode{"YVZ"}, // Deer Lake Airport
    IataCode{"YWA"}, // Petawawa Airport
    IataCode{"YWB"}, // Kangiqsujuaq Airport
    IataCode{"YWG"}, // Winnipeg James Armstrong Richardson International Airport
    IataCode{"YWH"}, // Victoria Inner Harbour Airport
    IataCode{"YWJ"}, // Déline Airport
    IataCode{"YWK"}, // Wabush Airport
    IataCode{"YWL"}, // Williams Lake Airport
    IataCode{"YWM"}, // Williams Harbour Airport
    IataCode{"YWO"}, // Lupin Airport
    IataCode{"YWP"}, // Webequie Airport
    IataCode{"YWQ"}, // Chutes-des-Passes/Lac Margane Water Aerodrome
    IataCode{"YWR"}, // White River Water Aerodrome
    IataCode{"YWS"}, // Whistler/Green Lake Water Aerodrome
    IataCode{"YWV"}, // Wainwright Aerodrome
    IataCode{"YWY"}, // Wrigley Airport
    IataCode{"YXC"}, // Canadian Rockies International Airport
    IataCode{"YXD"}, // Edmonton City Centre (Blatchford Field) Airport
    IataCode{"YXE"}, // Saskatoon John G. Diefenbaker International Airport
    IataCode{"YXH"}, // Medicine Hat Airport
    IataCode{"YXI"}, // Killaloe/Bonnechere Airport
    IataCode{"YXJ"}, // Fort St. John Airport
    IataCode{"YXK"}, // Rimouski Airport
    IataCode{"YXL"}, // Sioux Lookout Airport
    IataCode{"YXN"}, // Whale Cove Airport
    IataCode{"YXP"}, // Pangnirtung Airport
    IataCode{"YXQ"}, // Beaver Creek Airport
    IataCode{"YXR"}, // Earlton (Timiskaming Regional) Airport
    IataCode{"YXS"}, // Prince George Airport
    IataCode{"YXT"}, // Northwest Regional Airport
    IataCode{"YXU"}, // London International Airport
    IataCode{"YXX"}, // Abbotsford International Airport
    IataCode{"YXY"}, // Erik Nielsen Whitehorse International Airport
    IataCode{"YXZ"}, // Wawa Airport
    IataCode{"YYB"}, // North Bay/Jack Garland Airport
    IataCode{"YYC"}, // Calgary International Airport
    IataCode{"YYD"}, // Smithers Airport
    IataCode{"YYE"}, // Fort Nelson Airport
    IataCode{"YYF"}, // Penticton Regional Airport
    IataCode{"YYG"}, // Charlottetown Airport
    IataCode{"YYH"}, // Taloyoak Airport
    IataCode{"YYJ"}, // Victoria International Airport
    IataCode{"YYL"}, // Lynn Lake Airport
    IataCode{"YYM"}, // Cowley Airport
    IataCode{"YYN"}, // Swift Current Airport
    IataCode{"YYO"}, // Wynyard/W. B. Needham Field Aerodrome
    IataCode{"YYQ"}, // Churchill Airport
    IataCode{"YYT"}, // St. John's International Airport
    IataCode{"YYU"}, // Kapuskasing Airport
    IataCode{"YYW"}, // Armstrong Airport
    IataCode{"YYY"}, // Mont-Joli Airport
    IataCode{"YYZ"}, // Toronto Pearson International Airport
    IataCode{"YZA"}, // Cache Creek Airport
    IataCode{"YZD"}, // Downsview Airport
    IataCode{"YZE"}, // Gore Bay-Manitoulin Airport
    IataCode{"YZF"}, // Yellowknife Airport
    IataCode{"YZG"}, // Salluit Airport
    IataCode{"YZH"}, // Slave Lake Airport
    IataCode{"YZP"}, // Sandspit Airport
    IataCode{"YZR"}, // Sarnia Chris Hadfield Airport
    IataCode{"YZS"}, // Coral Harbour Airport
    IataCode{"YZT"}, // Port Hardy Airport
    IataCode{"YZU"}, // Whitecourt Airport
    IataCode{"YZV"}, // Sept-Îles Airport
    IataCode{"YZW"}, // Teslin Airport
    IataCode{"YZY"}, // Zhangye Ganzhou Airport
    IataCode{"YZZ"}, // Trail Airport
    IataCode{"ZAA"}, // Alice Arm/Silver City Water Aerodrome
    IataCode{"ZAC"}, // York Landing Airport
    IataCode{"ZAD"}, // Zadar Airport
    IataCode{"ZAG"}, // Zagreb Airport
    IataCode{"ZAH"}, // Zahedan Airport
    IataCode{"ZAJ"}, // Zaranj Airport
    IataCode{"ZAL"}, // Pichoy Airfield
    IataCode{"ZAM"}, // Zamboanga International Airport
    IataCode{"ZAP"}, // Zapopan Airport
    IataCode{"ZAR"}, // Zaria Airport
    IataCode{"ZAT"}, // Zhaotong Airport
    IataCode{"ZAZ"}, // Zaragoza Airport
    IataCode{"ZBF"}, // Bathurst Airport
    IataCode{"ZBK"}, // Žabljak Airport
    IataCode{"ZBL"}, // Biloela Airport
    IataCode{"ZBM"}, // Roland-Désourdy Airport
    IataCode{"ZBO"}, // Bowen Airport
    IataCode{"ZBR"}, // Konarak Airport
    IataCode{"ZBY"}, // Sayaboury Airport
    IataCode{"ZCA"}, // Arnsberg Menden
    IataCode{"ZCC"}, // Oos Airport
    IataCode{"ZCL"}, // General Leobardo C. Ruiz International Airport
    IataCode{"ZCO"}, // Aeropuerto La Araucanía
    IataCode{"ZCQ"}, // General Freire Airfield
    IataCode{"ZDY"}, // Dalma Airport
    IataCode{"ZEF"}, // Elkin Municipal Airport
    IataCode{"ZEL"}, // Bella Bella (Campbell Island) Airport
    IataCode{"ZEM"}, // Eastmain River Airport
    IataCode{"ZER"}, // Zero Airport
    IataCode{"ZFA"}, // Faro Airport
    IataCode{"ZFD"}, // Fond-du-Lac Airport
    IataCode{"ZFM"}, // Fort McPherson Airport
    IataCode{"ZFN"}, // Tulita Airport
    IataCode{"ZFW"}, // Fairview Airport
    IataCode{"ZGF"}, // Grand Forks Airport
    IataCode{"ZGI"}, // Gods River Airport
    IataCode{"ZGM"}, // Ngoma Airport
    IataCode{"ZGR"}, // Little Grand Rapids Airport
    IataCode{"ZGS"}, // La Romaine Airport
    IataCode{"ZGU"}, // Gaua Airport
    IataCode{"ZHA"}, // Zhanjiang Airport
    IataCode{"ZHM"}, // Shamshernagar Airport
    IataCode{"ZHP"}, // High Prairie Airport
    IataCode{"ZHV"}, // Les Eplatures Airport
    IataCode{"ZHY"}, // Zhongwei Shapotou Airport
    IataCode{"ZIA"}, // Zhukovsky International Airport
    IataCode{"ZIC"}, // Victoria Airport
    IataCode{"ZIG"}, // Ziguinchor Airport
    IataCode{"ZIH"}, // Ixtapa-Zihuatanejo International Airport
    IataCode{"ZIN"}, // Interlaken Airport
    IataCode{"ZIS"}, // Alzintan Airport
    IataCode{"ZIX"}, // Zhigansk Airport
    IataCode{"ZJG"}, // Jenpeg Airport
    IataCode{"ZJI"}, // Locarno Airport
    IataCode{"ZJN"}, // Swan River Airport
    IataCode{"ZKB"}, // Kasaba Bay Airport
    IataCode{"ZKE"}, // Kashechewan Airport
    IataCode{"ZKG"}, // Kegaska Airport
    IataCode{"ZKM"}, // Sette Cama Airport
    IataCode{"ZKP"}, // Zyryanka Airport
    IataCode{"ZLG"}, // La Güera Airport
    IataCode{"ZLO"}, // Playa de Oro International Airport
    IataCode{"ZLR"}, // Linares Airport
    IataCode{"ZLT"}, // La Tabatière Airport
    IataCode{"ZLX"}, // Zalingei Airport
    IataCode{"ZMG"}, // Magdeburg Aerodrome
    IataCode{"ZMH"}, // South Cariboo Regional Airport
    IataCode{"ZMM"}, // Zamora Airport
    IataCode{"ZMO"}, // Modena Airport
    IataCode{"ZMT"}, // Masset Airport
    IataCode{"ZNA"}, // Nanaimo Harbour Water Airport
    IataCode{"ZNC"}, // Nyac Airport
    IataCode{"ZND"}, // Zinder Airport
    IataCode{"ZNE"}, // Newman Airport
    IataCode{"ZNJ"}, // Heilbron Airport
    IataCode{"ZNL"}, // Nelson Airport
    IataCode{"ZNZ"}, // Abeid Amani Karume International Airport
    IataCode{"ZOF"}, // Ocean Falls Water Aerodrome
    IataCode{"ZOS"}, // Cañal Bajo Carlos Hott Siebert Airport
    IataCode{"ZPB"}, // Sachigo Lake Airport
    IataCode{"ZPC"}, // Pucón Airport
    IataCode{"ZPH"}, // Zephyrhills Municipal Airport
    IataCode{"ZPO"}, // Pinehouse Lake Airport
    IataCode{"ZQF"}, // Trier-Föhren Airport
    IataCode{"ZQN"}, // Queenstown Airport
    IataCode{"ZQS"}, // Queen Charlotte City Water Aerodrome
    IataCode{"ZQV"}, // Worms Airport
    IataCode{"ZQW"}, // Zweibrücken Airport
    IataCode{"ZQZ"}, // Zhangjiakou Ningyuan Airport
    IataCode{"ZRE"}, // Zrenjanin Airport
    IataCode{"ZRH"}, // Zurich Airport
    IataCode{"ZRI"}, // Serui Airport
    IataCode{"ZRJ"}, // Round Lake (Weagamow Lake) Airport
    IataCode{"ZRO"}, // Reggio Emilia Airport
    IataCode{"ZSA"}, // San Salvador Airport
    IataCode{"ZSE"}, // Pierrefonds Airport
    IataCode{"ZSJ"}, // Sandy Lake Airport
    IataCode{"ZSP"}, // St. Paul Aerodrome
    IataCode{"ZSS"}, // Sassandra Airport
    IataCode{"ZST"}, // Stewart Aerodrome
    IataCode{"ZSU"}, // Dessau Aerodrome
    IataCode{"ZSW"}, // Prince Rupert/Seal Cove Water Airport
    IataCode{"ZTA"}, // Tureia Airport
    IataCode{"ZTB"}, // Tête-à-la-Baleine Airport
    IataCode{"ZTH"}, // Zakynthos International Airport
    IataCode{"ZTM"}, // Shamattawa Airport
    IataCode{"ZTR"}, // Zhytomyr Airport
    IataCode{"ZTS"}, // Tahsis Water Aerodrome
    IataCode{"ZTU"}, // Zaqatala International Airport
    IataCode{"ZUC"}, // Ignace Municipal Airport
    IataCode{"ZUD"}, // Pupelde Airport
    IataCode{"ZUH"}, // Zhuhai Sanzao Airport
    IataCode{"ZUL"}, // Azul Airport
    IataCode{"ZUM"}, // Churchill Falls Airport
    IataCode{"ZUN"}, // Black Rock Airport
    IataCode{"ZVA"}, // Miandrivazo Airport
    IataCode{"ZVG"}, // Springvale Airport
    IataCode{"ZVK"}, // Savannakhet Airport
    IataCode{"ZVL"}, // Edmonton/Villeneuve Airport
    IataCode{"ZWA"}, // Andapa Airport
    IataCode{"ZWL"}, // Wollaston Lake Airport
    IataCode{"ZXB"}, // Jan Mayensfield
    IataCode{"ZXT"}, // Zabrat Airport
    IataCode{"ZYI"}, // Zunyi Xinzhou Airport
    IataCode{"ZYL"}, // Osmani International Airport
    IataCode{"ZZO"}, // Zonalnoye Airport
    IataCode{"ZZU"}, // Mzuzu Airport
    IataCode{"ZZV"}, // Zanesville Municipal Airport
};

// airport coordinates in latitude/longitude pairs
// NAN indicates the coordinate is not known
static constexpr Coordinate coordinate_table[] = {
    Coordinate{-145.512, -17.3489}, // AAA
    Coordinate{141.047, -26.6906}, // AAB
    Coordinate{33.8358, 31.0733}, // AAC
    Coordinate{7.80944, 36.8222}, // AAE
    Coordinate{-85.0275, 29.7275}, // AAF
    Coordinate{-49.7906, -24.1042}, // AAG
    Coordinate{-46.8856, -13.0239}, // AAI
    Coordinate{-55.5778, 3.89861}, // AAJ
    Coordinate{173.636, 0.185278}, // AAK
    Coordinate{9.84917, 57.0928}, // AAL
    Coordinate{31.5447, -24.8181}, // AAM
    Coordinate{55.6149, 24.2595}, // AAN
    Coordinate{-64.4708, 9.4303}, // AAO
    Coordinate{-95.5833, 29.7167}, // AAP
    Coordinate{37.3473, 45.0021}, // AAQ
    Coordinate{10.6192, 56.3042}, // AAR
    Coordinate{139.311, -3.88472}, // AAS
    Coordinate{88.0844, 47.7504}, // AAT
    Coordinate{-172.628, -13.505}, // AAU
    Coordinate{124.753, 6.36777}, // AAV
    Coordinate{73.2167, 34.15}, // AAW
    Coordinate{-46.9656, -19.5606}, // AAX
    Coordinate{52.1742, 16.1934}, // AAY
    Coordinate{-91.5019, 14.8656}, // AAZ
    Coordinate{91.3859, 53.7433}, // ABA
    Coordinate{6.65889, 6.20306}, // ABB
    Coordinate{-1.86333, 38.9483}, // ABC
    Coordinate{48.2283, 30.3711}, // ABD
    Coordinate{-75.4405, 40.6523}, // ABE
    Coordinate{173.04, 1.79639}, // ABF
    Coordinate{143.184, -17.6075}, // ABG
    Coordinate{146.583, -23.6467}, // ABH
    Coordinate{-99.6831, 32.4132}, // ABI
    Coordinate{-3.92578, 5.26142}, // ABJ
    Coordinate{44.2416, 6.73281}, // ABK
    Coordinate{-157.857, 67.1066}, // ABL
    Coordinate{142.459, -10.9508}, // ABM
    Coordinate{-54.05, 5.51667}, // ABN
    Coordinate{-3.26667, 5.43306}, // ABO
    Coordinate{141.1, -6.06667}, // ABP
    Coordinate{-106.609, 35.0403}, // ABQ
    Coordinate{-98.4228, 45.4483}, // ABR
    Coordinate{31.6117, 22.3758}, // ABS
    Coordinate{41.6343, 20.2961}, // ABT
    Coordinate{124.9, -9.33333}, // ABU
    Coordinate{7.26319, 9.00681}, // ABV
    Coordinate{148.7, -10.1667}, // ABW
    Coordinate{146.958, -36.0678}, // ABX
    Coordinate{-84.1944, 31.5356}, // ABY
    Coordinate{-2.19778, 57.2019}, // ABZ
    Coordinate{-99.7516, 16.756}, // ACA
    Coordinate{-85.1983, 44.9886}, // ACB
    Coordinate{-0.167389, 5.60467}, // ACC
    Coordinate{-77.2739, 8.49806}, // ACD
    Coordinate{-13.6053, 28.9456}, // ACE
    Coordinate{9.56083, 47.485}, // ACH
    Coordinate{-2.21444, 49.7067}, // ACI
    Coordinate{80.4283, 8.30139}, // ACJ
    Coordinate{-70.059, 41.2529}, // ACK
    Coordinate{-72.9906, 4.74694}, // ACL
    Coordinate{-101.101, 29.3317}, // ACN
    Coordinate{46.1279, 37.348}, // ACP
    Coordinate{-93.5531, 44.0733}, // ACQ
    Coordinate{-72.3978, -0.601111}, // ACR
    Coordinate{90.5767, 56.2683}, // ACS
    Coordinate{-97.2306, 31.6114}, // ACT
    Coordinate{-78.0167, 9.18333}, // ACU
    Coordinate{-124.108, 40.9778}, // ACV
    Coordinate{104.959, 25.0883}, // ACX
    Coordinate{-74.5772, 39.4575}, // ACY
    Coordinate{61.5439, 31.0983}, // ACZ
    Coordinate{35.2803, 36.9819}, // ADA
    Coordinate{27.155, 38.2892}, // ADB
    Coordinate{145.733, -7.13333}, // ADC
    Coordinate{38.7994, 8.97778}, // ADD
    Coordinate{45.0288, 12.8295}, // ADE
    Coordinate{38.4689, 37.7317}, // ADF
    Coordinate{-84.0772, 41.8678}, // ADG
    Coordinate{125.4, 58.6}, // ADH
    Coordinate{14.98, -22.4622}, // ADI
    Coordinate{35.9914, 31.9725}, // ADJ
    Coordinate{-176.646, 51.8781}, // ADK
    Coordinate{138.531, -34.945}, // ADL
    Coordinate{-97.0206, 34.3042}, // ADM
    Coordinate{137.137, -30.4383}, // ADO
    Coordinate{81.6258, 7.33667}, // ADP
    Coordinate{-152.494, 57.7497}, // ADQ
    Coordinate{-79.5261, 33.4517}, // ADR
    Coordinate{-96.8364, 32.9686}, // ADS
    Coordinate{-96.6714, 34.8044}, // ADT
    Coordinate{48.4242, 38.3256}, // ADU
    Coordinate{26.1192, 11.4036}, // ADV
    Coordinate{29.0555, -22.679}, // ADY
    Coordinate{-81.7111, 12.5836}, // ADZ
    Coordinate{173.829, 0.490833}, // AEA
    Coordinate{106.959, 23.7194}, // AEB
    Coordinate{99.4305, 1.4001}, // AEG
    Coordinate{20.8442, 13.8469}, // AEH
    Coordinate{-5.44111, 36.1289}, // AEI
    Coordinate{-93.3672, 43.6817}, // AEL
    Coordinate{-9.63778, 16.7111}, // AEO
    Coordinate{-58.4164, -34.5589}, // AEP
    Coordinate{39.9567, 43.45}, // AER
    Coordinate{6.11972, 62.5625}, // AES
    Coordinate{-152.622, 66.5519}, // AET
    Coordinate{55.0317, 25.8756}, // AEU
    Coordinate{-92.5486, 31.3275}, // AEX
    Coordinate{-18.0727, 65.66}, // AEY
    Coordinate{-68.4036, -34.5967}, // AFA
    Coordinate{26.8797, -33.5542}, // AFD
    Coordinate{-133.91, 56.9614}, // AFE
    Coordinate{-75.0472, 6.89444}, // AFI
    Coordinate{-95.8678, 40.6056}, // AFK
    Coordinate{-56.105, -9.86639}, // AFL
    Coordinate{-72.003, 42.8051}, // AFN
    Coordinate{-110.942, 42.7089}, // AFO
    Coordinate{-80.0772, 35.0206}, // AFP
    Coordinate{64.2328, 41.6136}, // AFS
    Coordinate{160.948, -9.19139}, // AFT
    Coordinate{-97.3189, 32.9878}, // AFW
    Coordinate{30.6011, 38.7264}, // AFY
    Coordinate{57.5952, 36.1681}, // AFZ
    Coordinate{-9.41139, 30.3225}, // AGA
    Coordinate{-79.9302, 40.3544}, // AGC
    Coordinate{133.867, -1.38333}, // AGD
    Coordinate{0.590556, 44.1747}, // AGF
    Coordinate{12.8472, 56.2961}, // AGH
    Coordinate{-56.6333, 5.76667}, // AGI
    Coordinate{127.24, 26.5928}, // AGJ
    Coordinate{149.156, -9.3375}, // AGL
    Coordinate{-134.585, 57.5036}, // AGN
    Coordinate{-93.2169, 33.2275}, // AGO
    Coordinate{-4.49917, 36.675}, // AGP
    Coordinate{21.3511, 38.6019}, // AGQ
    Coordinate{-82.0628, 33.1994}, // AGS
    Coordinate{-54.8433, -25.4553}, // AGT
    Coordinate{-102.318, 21.7056}, // AGU
    Coordinate{-69.2375, 9.55333}, // AGV
    Coordinate{142.149, -12.1456}, // AGW
    Coordinate{72.1789, 10.8281}, // AGX
    Coordinate{128.75, -16.35}, // AGY
    Coordinate{18.8136, -29.2817}, // AGZ
    Coordinate{42.6566, 18.2404}, // AHB
    Coordinate{-97.1228, 34.1469}, // AHD
    Coordinate{-146.257, -14.4281}, // AHE
    Coordinate{-99.9064, 40.3394}, // AHF
    Coordinate{-92.3753, 45.2811}, // AHH
    Coordinate{128.917, -3.33333}, // AHI
    Coordinate{102.357, 32.5292}, // AHJ
    Coordinate{-59.3222, 2.47222}, // AHL
    Coordinate{-122.661, 42.1903}, // AHM
    Coordinate{-83.3264, 33.9486}, // AHN
    Coordinate{8.28861, 40.6311}, // AHO
    Coordinate{-96.5944, 41.2406}, // AHQ
    Coordinate{-84.3522, 15.4722}, // AHS
    Coordinate{-3.83944, 35.1769}, // AHU
    Coordinate{}, // AHY
    Coordinate{6.08361, 45.0875}, // AHZ
    Coordinate{-102.804, 42.0533}, // AIA
    Coordinate{168.826, 7.27917}, // AIC
    Coordinate{-85.6131, 40.1086}, // AID
    Coordinate{144.732, -5.14222}, // AIE
    Coordinate{-50.4531, -22.64}, // AIF
    Coordinate{23.2667, 6.51667}, // AIG
    Coordinate{141.266, -7.3425}, // AIH
    Coordinate{42.7167, 11.1333}, // AII
    Coordinate{-81.685, 33.6494}, // AIK
    Coordinate{-78.0236, 9.22222}, // AIL
    Coordinate{169.983, 10.2169}, // AIM
    Coordinate{-159.995, 70.6381}, // AIN
    Coordinate{-95.0469, 41.4072}, // AIO
    Coordinate{-59.3892, -10.2531}, // AIR
    Coordinate{176.802, -2.61626}, // AIS
    Coordinate{-159.764, -18.8308}, // AIT
    Coordinate{-158.12, -19.9678}, // AIU
    Coordinate{-88.1978, 33.1064}, // AIV
    Coordinate{-74.4561, 39.36}, // AIY
    Coordinate{-92.5495, 38.096}, // AIZ
    Coordinate{8.8025, 41.9239}, // AJA
    Coordinate{40.0997, 29.7853}, // AJF
    Coordinate{43.0272, 39.6544}, // AJI
    Coordinate{-14.3833, 19.733}, // AJJ
    Coordinate{49.8473, 34.1381}, // AJK
    Coordinate{92.6204, 23.8384}, // AJL
    Coordinate{44.4296, -12.1317}, // AJN
    Coordinate{-117.603, 33.8978}, // AJO
    Coordinate{19.2819, 65.5903}, // AJR
    Coordinate{-113.56, 26.7272}, // AJS
    Coordinate{-37.0733, -10.9853}, // AJU
    Coordinate{7.99028, 16.9622}, // AJY
    Coordinate{108.931, 32.7081}, // AKA
    Coordinate{-174.206, 52.2206}, // AKB
    Coordinate{-81.4669, 41.0375}, // AKC
    Coordinate{77.0586, 20.6989}, // AKD
    Coordinate{13.9033, -1.13972}, // AKE
    Coordinate{23.3133, 24.1767}, // AKF
    Coordinate{-161.231, 60.9028}, // AKI
    Coordinate{142.447, 43.6708}, // AKJ
    Coordinate{-154.182, 56.9386}, // AKK
    Coordinate{174.792, -37.0081}, // AKL
    Coordinate{19.8175, 10.8908}, // AKM
    Coordinate{-156.649, 58.6764}, // AKN
    Coordinate{-103.222, 40.1756}, // AKO
    Coordinate{-151.743, 68.1336}, // AKP
    Coordinate{105.233, -4.61667}, // AKQ
    Coordinate{5.30083, 7.24667}, // AKR
    Coordinate{160.681, -8.69778}, // AKS
    Coordinate{80.2917, 41.2625}, // AKU
    Coordinate{-78.1486, 60.8186}, // AKV
    Coordinate{49.6769, 30.7444}, // AKW
    Coordinate{57.2033, 50.245}, // AKX
    Coordinate{92.8725, 20.1328}, // AKY
    Coordinate{77.0406, 43.3519}, // ALA
    Coordinate{-73.8019, 42.7492}, // ALB
    Coordinate{-0.558056, 38.2822}, // ALC
    Coordinate{-69.3333, -11.6833}, // ALD
    Coordinate{-103.684, 30.3842}, // ALE
    Coordinate{23.3717, 69.9761}, // ALF
    Coordinate{3.21694, 36.6944}, // ALG
    Coordinate{117.809, -34.9433}, // ALH
    Coordinate{-98.0269, 27.7408}, // ALI
    Coordinate{16.5344, -28.5733}, // ALJ
    Coordinate{8.12533, 44.0457}, // ALL
    Coordinate{-105.991, 32.84}, // ALM
    Coordinate{-90.0461, 38.8903}, // ALN
    Coordinate{-92.4003, 42.5569}, // ALO
    Coordinate{37.2242, 36.1806}, // ALP
    Coordinate{-55.8922, -29.8125}, // ALQ
    Coordinate{169.373, -45.2117}, // ALR
    Coordinate{-105.866, 37.435}, // ALS
    Coordinate{50.7483, 11.9586}, // ALU
    Coordinate{1.525, 42.5078}, // ALV
    Coordinate{-118.289, 46.0947}, // ALW
    Coordinate{-85.9631, 32.9147}, // ALX
    Coordinate{29.9489, 31.1839}, // ALY
    Coordinate{-154.248, 56.8994}, // ALZ
    Coordinate{-101.706, 35.2194}, // AMA
    Coordinate{48.9833, -13.1883}, // AMB
    Coordinate{20.274, 11.034}, // AMC
    Coordinate{72.6347, 23.0772}, // AMD
    Coordinate{37.5903, 6.03972}, // AMH
    Coordinate{116.094, -8.56056}, // AMI
    Coordinate{-107.869, 37.2031}, // AMK
    Coordinate{35.9933, 31.7225}, // AMM
    Coordinate{-84.6881, 43.3222}, // AMN
    Coordinate{15.3144, 14.1456}, // AMO
    Coordinate{44.7333, -24.7}, // AMP
    Coordinate{128.089, -3.71026}, // AMQ
    Coordinate{4.76028, 52.3081}, // AMS
    Coordinate{61.5633, 69.7633}, // AMV
    Coordinate{-93.6217, 41.9919}, // AMW
    Coordinate{45.6242, -17.6864}, // AMY
    Coordinate{174.973, -37.0297}, // AMZ
    Coordinate{-85.8581, 33.5881}, // ANB
    Coordinate{-149.998, 61.1742}, // ANC
    Coordinate{-82.709, 34.4949}, // AND
    Coordinate{-0.312222, 47.5603}, // ANE
    Coordinate{-70.4451, -23.4445}, // ANF
    Coordinate{0.219167, 45.7294}, // ANG
    Coordinate{-159.543, 61.5817}, // ANI
    Coordinate{13.8167, -2.85}, // ANJ
    Coordinate{16.711, -11.4715}, // ANL
    Coordinate{50.3202, -14.9994}, // ANM
    Coordinate{-131.572, 55.0425}, // ANN
    Coordinate{39.9333, -16.1833}, // ANO
    Coordinate{-76.5683, 38.9428}, // ANP
    Coordinate{-85.0836, 41.6397}, // ANQ
    Coordinate{4.46028, 51.1894}, // ANR
    Coordinate{-73.3528, -13.7128}, // ANS
    Coordinate{-61.7931, 17.1367}, // ANU
    Coordinate{-160.191, 62.6467}, // ANV
    Coordinate{-99.9931, 42.5792}, // ANW
    Coordinate{16.1442, 69.2925}, // ANX
    Coordinate{-98.0797, 37.1586}, // ANY
    Coordinate{19.2833, 11.4667}, // AOD
    Coordinate{30.5194, 39.81}, // AOE
    Coordinate{122.856, 41.1047}, // AOG
    Coordinate{-84.0275, 40.7083}, // AOH
    Coordinate{13.3623, 43.6163}, // AOI
    Coordinate{140.689, 40.7333}, // AOJ
    Coordinate{27.1467, 35.4167}, // AOK
    Coordinate{-57.1522, -29.6894}, // AOL
    Coordinate{57.3822, 22.4972}, // AOM
    Coordinate{-78.32, 40.2964}, // AOO
    Coordinate{-76.4666, -2.79611}, // AOP
    Coordinate{100.398, 6.18944}, // AOR
    Coordinate{-153.815, 57.4714}, // AOS
    Coordinate{7.36385, 45.7392}, // AOT
    Coordinate{107.045, 14.7931}, // AOU
    Coordinate{-104.849, 39.57}, // APA
    Coordinate{-68.4167, -14.8181}, // APB
    Coordinate{-122.281, 38.2132}, // APC
    Coordinate{-81.7756, 26.1525}, // APF
    Coordinate{-146.414, -15.5726}, // APK
    Coordinate{39.2818, -15.1056}, // APL
    Coordinate{-83.5603, 45.0781}, // APN
    Coordinate{-76.7134, 7.81117}, // APO
    Coordinate{-36.6306, -9.77639}, // APQ
    Coordinate{-48.9281, -16.3625}, // APS
    Coordinate{-85.5853, 35.0606}, // APT
    Coordinate{-51.385, -23.6122}, // APU
    Coordinate{-117.186, 34.5753}, // APV
    Coordinate{-172.008, -13.8297}, // APW
    Coordinate{-51.4908, -23.3558}, // APX
    Coordinate{-45.9506, -9.08361}, // APY
    Coordinate{-70.1136, -38.9756}, // APZ
    Coordinate{-48.1403, -21.8044}, // AQA
    Coordinate{-91.1506, 15.0108}, // AQB
    Coordinate{-133.102, 55.5547}, // AQC
    Coordinate{117.05, 30.5822}, // AQG
    Coordinate{46.125, 28.335}, // AQI
    Coordinate{35.0181, 29.6116}, // AQJ
    Coordinate{-62.8256, -10.1781}, // AQM
    Coordinate{-98.6619, 30.7836}, // AQO
    Coordinate{-71.5831, -16.3411}, // AQP
    Coordinate{-73.1703, 42.6958}, // AQW
    Coordinate{-149.126, 60.9661}, // AQY
    Coordinate{-91.8839, 30.0377}, // ARA
    Coordinate{-83.7456, 42.2231}, // ARB
    Coordinate{-145.579, 68.1147}, // ARC
    Coordinate{124.598, -8.13167}, // ARD
    Coordinate{-66.6756, 18.4511}, // ARE
    Coordinate{-90.925, 36.1247}, // ARG
    Coordinate{40.7167, 64.6}, // ARH
    Coordinate{-70.3386, -18.3486}, // ARI
    Coordinate{128.917, -3.33333}, // ARJ
    Coordinate{36.6219, -3.36667}, // ARK
    Coordinate{1.48333, 11.5833}, // ARL
    Coordinate{151.617, -30.5283}, // ARM
    Coordinate{17.9186, 59.6519}, // ARN
    Coordinate{-71.3889, 7.02111}, // ARQ
    Coordinate{-70.8129, -45.0136}, // ARR
    Coordinate{-76.0206, 43.9919}, // ART
    Coordinate{-50.4264, -21.1442}, // ARU
    Coordinate{-89.7308, 45.9278}, // ARV
    Coordinate{21.2619, 46.1767}, // ARW
    Coordinate{142.988, -37.31}, // ARY
    Coordinate{12.8626, -7.25903}, // ARZ
    Coordinate{42.645, 13.0717}, // ASA
    Coordinate{58.3608, 37.9869}, // ASB
    Coordinate{-63.1559, -15.9322}, // ASC
    Coordinate{-77.8, 24.6983}, // ASD
    Coordinate{-106.869, 39.2231}, // ASE
    Coordinate{48.0063, 46.2833}, // ASF
    Coordinate{171.797, -43.9033}, // ASG
    Coordinate{-71.5147, 42.7817}, // ASH
    Coordinate{129.712, 28.4308}, // ASJ
    Coordinate{-5.36558, 6.90317}, // ASK
    Coordinate{-94.3078, 32.5206}, // ASL
    Coordinate{38.9017, 15.285}, // ASM
    Coordinate{-86.0511, 33.5694}, // ASN
    Coordinate{34.5861, 10.0183}, // ASO
    Coordinate{133.902, -23.8069}, // ASP
    Coordinate{-117.195, 39.4681}, // ASQ
    Coordinate{35.4953, 38.7703}, // ASR
    Coordinate{-123.879, 46.1581}, // AST
    Coordinate{-57.5192, -25.2397}, // ASU
    Coordinate{37.2508, -2.63583}, // ASV
    Coordinate{32.8197, 23.9642}, // ASW
    Coordinate{-90.9189, 46.5486}, // ASX
    Coordinate{-99.3517, 46.0247}, // ASY
    Coordinate{-77.5983, -9.34722}, // ATA
    Coordinate{34.0569, 17.7097}, // ATB
    Coordinate{-75.6739, 24.6294}, // ATC
    Coordinate{161.011, -8.87333}, // ATD
    Coordinate{-95.6497, 34.1925}, // ATE
    Coordinate{-78.5744, -1.21194}, // ATF
    Coordinate{-73.7679, -10.7309}, // ATG
    Coordinate{23.9444, 37.9364}, // ATH
    Coordinate{-56.5078, -30.4008}, // ATI
    Coordinate{47.067, -19.8348}, // ATJ
    Coordinate{-157.436, 70.4672}, // ATK
    Coordinate{-84.4281, 33.6367}, // ATL
    Coordinate{-52.2522, -3.25083}, // ATM
    Coordinate{152.442, -3.66667}, // ATN
    Coordinate{-82.2292, 39.2119}, // ATO
    Coordinate{142.346, -3.14417}, // ATP
    Coordinate{74.7992, 31.7078}, // ATQ
    Coordinate{-13.0431, 20.5067}, // ATR
    Coordinate{-104.468, 32.8525}, // ATS
    Coordinate{-162.273, 60.8667}, // ATT
    Coordinate{173.176, 52.8325}, // ATU
    Coordinate{18.3133, 13.2389}, // ATV
    Coordinate{-88.5192, 44.2581}, // ATW
    Coordinate{68.3633, 51.8517}, // ATX
    Coordinate{-97.1547, 44.9139}, // ATY
    Coordinate{31.0119, 27.0464}, // ATZ
    Coordinate{-70.0153, 12.5014}, // AUA
    Coordinate{-41.983, -7.1}, // AUB
    Coordinate{-70.7369, 7.06889}, // AUC
    Coordinate{33.2, 28.8989}, // AUE
    Coordinate{3.49667, 47.8464}, // AUF
    Coordinate{-69.7972, 44.3206}, // AUG
    Coordinate{54.6511, 24.4331}, // AUH
    Coordinate{-164.66, 62.68}, // AUK
    Coordinate{171.173, 8.1455}, // AUL
    Coordinate{-92.9328, 43.6625}, // AUM
    Coordinate{-121.082, 38.9547}, // AUN
    Coordinate{-85.4339, 32.615}, // AUO
    Coordinate{149.386, -9.93083}, // AUP
    Coordinate{-139.013, -9.76861}, // AUQ
    Coordinate{2.41667, 44.8975}, // AUR
    Coordinate{-97.67, 30.1944}, // AUS
    Coordinate{141.721, -13.3539}, // AUU
    Coordinate{-89.6267, 44.9261}, // AUW
    Coordinate{-48.2408, -7.22833}, // AUX
    Coordinate{169.771, -20.2492}, // AUY
    Coordinate{-88.4756, 41.7719}, // AUZ
    Coordinate{105.873, 26.2606}, // AVA
    Coordinate{-78.7894, 22.0269}, // AVI
    Coordinate{102.799, 46.2525}, // AVK
    Coordinate{-82.5417, 35.4361}, // AVL
    Coordinate{4.90194, 43.9067}, // AVN
    Coordinate{-81.5289, 27.5914}, // AVO
    Coordinate{-75.7233, 41.3383}, // AVP
    Coordinate{160.41, -9.86818}, // AVU
    Coordinate{144.469, -38.0394}, // AVV
    Coordinate{-111.218, 32.4096}, // AVW
    Coordinate{-118.416, 33.405}, // AVX
    Coordinate{38.5, 7.067}, // AWA
    Coordinate{142.751, -8.01433}, // AWB
    Coordinate{169.601, -19.2344}, // AWD
    Coordinate{166.637, 19.2825}, // AWK
    Coordinate{-90.2344, 35.135}, // AWM
    Coordinate{-122.159, 48.1608}, // AWO
    Coordinate{48.762, 31.3374}, // AWZ
    Coordinate{-63.055, 18.2047}, // AXA
    Coordinate{-75.8997, 44.3167}, // AXB
    Coordinate{145.242, -22.9667}, // AXC
    Coordinate{25.9563, 40.8559}, // AXD
    Coordinate{-52.3731, -26.8756}, // AXE
    Coordinate{105.631, 38.8233}, // AXF
    Coordinate{-94.2719, 43.0778}, // AXG
    Coordinate{-95.4769, 29.5061}, // AXH
    Coordinate{130.159, 32.4822}, // AXJ
    Coordinate{46.8261, 14.5511}, // AXK
    Coordinate{-75.7664, 4.4525}, // AXM
    Coordinate{-95.3947, 45.8664}, // AXN
    Coordinate{-78.9708, 22.4419}, // AXP
    Coordinate{-79.4422, 41.225}, // AXQ
    Coordinate{-99.3383, 34.6989}, // AXS
    Coordinate{140.219, 39.6156}, // AXT
    Coordinate{38.7761, 14.1369}, // AXU
    Coordinate{-84.2981, 40.4936}, // AXV
    Coordinate{-75.1464, 8.32}, // AYA
    Coordinate{66.96, 50.325}, // AYK
    Coordinate{114.344, 36.1339}, // AYN
    Coordinate{-56.8539, -27.3706}, // AYO
    Coordinate{-74.2042, -13.1547}, // AYP
    Coordinate{130.976, -25.1861}, // AYQ
    Coordinate{147.33, -19.585}, // AYR
    Coordinate{-82.3956, 31.2492}, // AYS
    Coordinate{30.7928, 36.9003}, // AYT
    Coordinate{145.904, -6.33778}, // AYU
    Coordinate{132.5, -1.2}, // AYW
    Coordinate{-73.4164, 40.6667}, // AYZ
    Coordinate{-111.656, 33.3078}, // AZA
    Coordinate{-113.014, 36.96}, // AZC
    Coordinate{54.2764, 31.905}, // AZD
    Coordinate{54.4581, 24.4266}, // AZI
    Coordinate{72.2939, 40.7278}, // AZN
    Coordinate{-85.5519, 42.235}, // AZO
    Coordinate{-0.186361, 27.8378}, // AZR
    Coordinate{-69.7375, 19.27}, // AZS
    Coordinate{13.1156, -7.88333}, // AZZ
    Coordinate{6.60917, 44.3872}, // BAE
    Coordinate{-72.7158, 42.1581}, // BAF
    Coordinate{120.616, 16.375}, // BAG
    Coordinate{50.6336, 26.2708}, // BAH
    Coordinate{-83.33, 9.16361}, // BAI
    Coordinate{-116.876, 40.5997}, // BAM
    Coordinate{20.4333, -4.31667}, // BAN
    Coordinate{-74.7818, 10.8886}, // BAQ
    Coordinate{110.459, 19.1406}, // BAR
    Coordinate{155.888, -6.9925}, // BAS
    Coordinate{-48.5958, -20.5856}, // BAT
    Coordinate{-49.0539, -22.3436}, // BAU
    Coordinate{109.997, 40.5597}, // BAV
    Coordinate{83.5417, 53.3633}, // BAX
    Coordinate{23.4662, 47.6582}, // BAY
    Coordinate{-62.9194, -0.981112}, // BAZ
    Coordinate{-71.687, -45.9164}, // BBA
    Coordinate{-95.6506, 45.3319}, // BBB
    Coordinate{-95.8633, 28.9733}, // BBC
    Coordinate{-99.3239, 31.1792}, // BBD
    Coordinate{172.811, 3.08333}, // BBG
    Coordinate{12.7101, 54.3382}, // BBH
    Coordinate{85.8178, 20.2444}, // BBI
    Coordinate{25.1631, -17.8297}, // BBK
    Coordinate{141.808, -27.4083}, // BBL
    Coordinate{103.223, 13.094}, // BBM
    Coordinate{115.469, 3.73694}, // BBN
    Coordinate{44.9411, 10.3892}, // BBO
    Coordinate{-1.10944, 50.6781}, // BBP
    Coordinate{-61.8269, 17.6358}, // BBQ
    Coordinate{-61.7422, 16.0133}, // BBR
    Coordinate{-0.8475, 51.3239}, // BBS
    Coordinate{15.7861, 4.22139}, // BBT
    Coordinate{26.1036, 44.5036}, // BBU
    Coordinate{-6.92396, 4.63333}, // BBV
    Coordinate{-99.6422, 41.4364}, // BBW
    Coordinate{-75.265, 40.1375}, // BBX
    Coordinate{20.6475, 5.84694}, // BBY
    Coordinate{23.1042, -13.5361}, // BBZ
    Coordinate{-74.5061, 20.3653}, // BCA
    Coordinate{-80.4078, 37.2078}, // BCB
    Coordinate{-156.144, 63.5717}, // BCC
    Coordinate{122.93, 10.6425}, // BCD
    Coordinate{-112.145, 37.7064}, // BCE
    Coordinate{18.2667, 6.51667}, // BCF
    Coordinate{126.399, -8.48528}, // BCH
    Coordinate{145.307, -23.5653}, // BCI
    Coordinate{-90.8553, 44.2508}, // BCK
    Coordinate{-83.5833, 10.7667}, // BCL
    Coordinate{26.9103, 46.5219}, // BCM
    Coordinate{2.07833, 41.2969}, // BCN
    Coordinate{36.55, 5.78287}, // BCO
    Coordinate{14.2655, 27.6547}, // BCQ
    Coordinate{21.367, 44.8867}, // BCR
    Coordinate{-90.0222, 29.8661}, // BCS
    Coordinate{-80.1078, 26.3786}, // BCT
    Coordinate{9.74444, 10.4833}, // BCU
    Coordinate{-88.7761, 17.2694}, // BCV
    Coordinate{35.4383, -21.8531}, // BCW
    Coordinate{-64.6787, 32.364}, // BDA
    Coordinate{152.319, -24.9039}, // BDB
    Coordinate{-45.2422, -5.5025}, // BDC
    Coordinate{142.175, -10.15}, // BDD
    Coordinate{-94.6122, 48.7283}, // BDE
    Coordinate{-109.483, 37.5833}, // BDG
    Coordinate{54.8248, 26.5314}, // BDH
    Coordinate{55.2087, -3.72147}, // BDI
    Coordinate{114.762, -3.44222}, // BDJ
    Coordinate{-2.76194, 8.01722}, // BDK
    Coordinate{-72.6833, 41.9392}, // BDL
    Coordinate{-121.2, 44.0944}, // BDN
    Coordinate{107.576, -6.90056}, // BDO
    Coordinate{88.0794, 26.5706}, // BDP
    Coordinate{73.2161, 22.3293}, // BDQ
    Coordinate{-73.1261, 41.1633}, // BDR
    Coordinate{17.9469, 40.6575}, // BDS
    Coordinate{20.9667, 4.25}, // BDT
    Coordinate{18.5403, 69.0558}, // BDU
    Coordinate{29.7333, -7.1}, // BDV
    Coordinate{-105.457, 45.4706}, // BDX
    Coordinate{-124.408, 43.0865}, // BDY
    Coordinate{-7.36278, 57.4811}, // BEB
    Coordinate{-97.215, 37.6944}, // BEC
    Coordinate{-71.2889, 42.47}, // BED
    Coordinate{-83.7742, 11.9908}, // BEF
    Coordinate{20.3069, 44.8194}, // BEG
    Coordinate{-86.4261, 42.1286}, // BEH
    Coordinate{34.5167, 9.35}, // BEI
    Coordinate{117.432, 2.15528}, // BEJ
    Coordinate{79.4469, 28.4225}, // BEK
    Coordinate{-48.4789, -1.38472}, // BEL
    Coordinate{17.6333, 5.26667}, // BEM
    Coordinate{20.2708, 32.0975}, // BEN
    Coordinate{151.648, -33.0667}, // BEO
    Coordinate{76.8828, 15.1628}, // BEP
    Coordinate{13.5033, 52.3667}, // BER
    Coordinate{-4.42167, 48.4472}, // BES
    Coordinate{-161.837, 60.7786}, // BET
    Coordinate{139.46, -24.3461}, // BEU
    Coordinate{34.723, 31.287}, // BEV
    Coordinate{34.9075, -19.7964}, // BEW
    Coordinate{35.4883, 33.8211}, // BEY
    Coordinate{176.007, -1.35472}, // BEZ
    Coordinate{-78.64, 41.8031}, // BFD
    Coordinate{-103.596, 41.8739}, // BFF
    Coordinate{-110.713, 37.5458}, // BFG
    Coordinate{-49.2336, -25.4033}, // BFH
    Coordinate{-122.302, 47.53}, // BFI
    Coordinate{105.301, 27.3003}, // BFJ
    Coordinate{-99.6186, 36.8633}, // BFK
    Coordinate{-119.058, 35.4339}, // BFL
    Coordinate{-88.0681, 30.6267}, // BFM
    Coordinate{26.3039, -29.0939}, // BFN
    Coordinate{31.5786, -21.01}, // BFO
    Coordinate{-80.3914, 40.7725}, // BFP
    Coordinate{-78.1806, 7.5875}, // BFQ
    Coordinate{-86.4453, 38.84}, // BFR
    Coordinate{-6.21583, 54.6575}, // BFS
    Coordinate{-80.6344, 32.4122}, // BFT
    Coordinate{117.32, 32.8475}, // BFU
    Coordinate{103.251, 15.2267}, // BFV
    Coordinate{-0.593275, 35.1718}, // BFW
    Coordinate{10.3544, 5.53472}, // BFX
    Coordinate{-73.1847, 7.12639}, // BGA
    Coordinate{11.9431, -0.106944}, // BGB
    Coordinate{-6.70713, 41.8578}, // BGC
    Coordinate{-101.394, 35.7008}, // BGD
    Coordinate{-84.6375, 30.9717}, // BGE
    Coordinate{18.5197, 4.39778}, // BGF
    Coordinate{40.5925, 38.8611}, // BGG
    Coordinate{-14.2, 16.6333}, // BGH
    Coordinate{-59.4925, 13.0747}, // BGI
    Coordinate{-88.4167, 16.5167}, // BGK
    Coordinate{-75.9797, 42.2086}, // BGM
    Coordinate{146.235, 68.5569}, // BGN
    Coordinate{5.21806, 60.2936}, // BGO
    Coordinate{-149.814, 61.5361}, // BGQ
    Coordinate{-68.8281, 44.8072}, // BGR
    Coordinate{-113.17, 34.5958}, // BGT
    Coordinate{22.7833, 4.78333}, // BGU
    Coordinate{-51.5364, -29.1483}, // BGV
    Coordinate{44.2344, 33.2625}, // BGW
    Coordinate{-54.1097, -31.3908}, // BGX
    Coordinate{9.70028, 45.6689}, // BGY
    Coordinate{-8.44514, 41.5871}, // BGZ
    Coordinate{-80.4042, -0.605556}, // BHA
    Coordinate{-68.3617, 44.4497}, // BHB
    Coordinate{-5.87123, 54.6155}, // BHD
    Coordinate{173.87, -41.5183}, // BHE
    Coordinate{-84.5436, 15.7631}, // BHG
    Coordinate{42.6208, 19.9844}, // BHH
    Coordinate{-62.1575, -38.7203}, // BHI
    Coordinate{69.6703, 23.2878}, // BHJ
    Coordinate{64.4833, 39.775}, // BHK
    Coordinate{-113.561, 28.9772}, // BHL
    Coordinate{-86.7522, 33.5639}, // BHM
    Coordinate{45.72, 14.7819}, // BHN
    Coordinate{77.3369, 23.2869}, // BHO
    Coordinate{87.0508, 27.1475}, // BHP
    Coordinate{141.472, -32.0014}, // BHQ
    Coordinate{84.4294, 27.6781}, // BHR
    Coordinate{149.652, -33.41}, // BHS
    Coordinate{72.1853, 21.7522}, // BHU
    Coordinate{71.7114, 29.3471}, // BHV
    Coordinate{-1.74806, 52.4539}, // BHX
    Coordinate{109.294, 21.5394}, // BHY
    Coordinate{9.48472, 42.55}, // BIA
    Coordinate{43.6178, 3.09267}, // BIB
    Coordinate{-71.5778, 41.1681}, // BID
    Coordinate{165.565, 11.5225}, // BII
    Coordinate{136.107, -1.19}, // BIK
    Coordinate{-108.543, 45.8078}, // BIL
    Coordinate{-79.2647, 25.7}, // BIM
    Coordinate{67.8206, 34.81}, // BIN
    Coordinate{-2.91056, 43.3011}, // BIO
    Coordinate{-1.52333, 43.4683}, // BIQ
    Coordinate{87.2639, 26.4814}, // BIR
    Coordinate{-100.746, 46.7728}, // BIS
    Coordinate{-23.5461, 65.6414}, // BIU
    Coordinate{21.9894, 6.52667}, // BIV
    Coordinate{27.285, -32.895}, // BIY
    Coordinate{5.06947, 36.712}, // BJA
    Coordinate{57.3064, 37.4892}, // BJB
    Coordinate{-105.117, 39.9089}, // BJC
    Coordinate{-14.8244, 66.0219}, // BJD
    Coordinate{29.6925, 70.6003}, // BJF
    Coordinate{122.112, -0.960556}, // BJG
    Coordinate{81.1853, 29.5389}, // BJH
    Coordinate{-94.9347, 47.5108}, // BJI
    Coordinate{-81.8883, 40.8747}, // BJJ
    Coordinate{134.274, -6.0662}, // BJK
    Coordinate{-16.6522, 13.338}, // BJL
    Coordinate{29.3185, -3.32402}, // BJM
    Coordinate{-64.3128, -22.7733}, // BJO
    Coordinate{-46.5375, -22.9792}, // BJP
    Coordinate{37.312, 11.5986}, // BJR
    Coordinate{79.9833, 6.41667}, // BJT
    Coordinate{81.6667, 29.5}, // BJU
    Coordinate{27.6642, 37.2506}, // BJV
    Coordinate{121.063, -8.7125}, // BJW
    Coordinate{-101.481, 20.9933}, // BJX
    Coordinate{-6.82139, 38.8914}, // BJZ
    Coordinate{38.0639, 55.6222}, // BKA
    Coordinate{73.2069, 28.0704}, // BKB
    Coordinate{-161.149, 65.9817}, // BKC
    Coordinate{-117.809, 44.8372}, // BKE
    Coordinate{-155.777, 58.5547}, // BKF
    Coordinate{-93.2006, 36.5319}, // BKG
    Coordinate{-159.785, 22.0228}, // BKH
    Coordinate{116.053, 5.94472}, // BKI
    Coordinate{-14.2811, 10.9658}, // BKJ
    Coordinate{100.747, 13.6811}, // BKK
    Coordinate{-81.6833, 41.5175}, // BKL
    Coordinate{115.618, 3.974}, // BKM
    Coordinate{54.3628, 39.4814}, // BKN
    Coordinate{-7.94306, 12.5378}, // BKO
    Coordinate{145.428, -24.4283}, // BKQ
    Coordinate{17.067, 12.383}, // BKR
    Coordinate{102.337, -3.86188}, // BKS
    Coordinate{-82.4556, 28.4736}, // BKV
    Coordinate{-81.1242, 37.7872}, // BKW
    Coordinate{-96.8169, 44.3047}, // BKX
    Coordinate{28.8086, -2.30889}, // BKY
    Coordinate{31.8211, -1.33222}, // BKZ
    Coordinate{-64.6892, 10.1072}, // BLA
    Coordinate{-79.5994, 8.915}, // BLB
    Coordinate{10.0339, 5.89528}, // BLC
    Coordinate{-114.861, 35.9475}, // BLD
    Coordinate{15.515, 60.4219}, // BLE
    Coordinate{-81.2078, 37.2958}, // BLF
    Coordinate{113.761, 2.63611}, // BLG
    Coordinate{-114.713, 33.6147}, // BLH
    Coordinate{6.30925, 35.7518}, // BLJ
    Coordinate{-3.02833, 53.7714}, // BLK
    Coordinate{9.15194, 55.7403}, // BLL
    Coordinate{-74.125, 40.1869}, // BLM
    Coordinate{146.007, -36.5519}, // BLN
    Coordinate{-20.2875, 65.645}, // BLO
    Coordinate{11.2887, 44.5354}, // BLQ
    Coordinate{77.7056, 13.1989}, // BLR
    Coordinate{148.807, -23.6031}, // BLT
    Coordinate{-120.71, 39.275}, // BLU
    Coordinate{12.2481, 46.1667}, // BLX
    Coordinate{-10.0308, 54.2228}, // BLY
    Coordinate{34.9676, -15.6798}, // BLZ
    Coordinate{17.9397, 59.3544}, // BMA
    Coordinate{22.4817, 2.18278}, // BMB
    Coordinate{-112.062, 41.5525}, // BMC
    Coordinate{44.5333, -19.6867}, // BMD
    Coordinate{122.232, -17.9447}, // BME
    Coordinate{22.8006, 5.69417}, // BMF
    Coordinate{-86.6167, 39.1461}, // BMG
    Coordinate{-88.9158, 40.4772}, // BMI
    Coordinate{-60.488, 7.37012}, // BMJ
    Coordinate{6.70917, 53.5956}, // BMK
    Coordinate{-71.1758, 44.5753}, // BML
    Coordinate{11.4933, 2.07556}, // BMM
    Coordinate{97.2469, 24.2667}, // BMO
    Coordinate{84.8769, 19.2975}, // BMP
    Coordinate{39.7312, -3.98005}, // BMQ
    Coordinate{7.37324, 53.7248}, // BMR
    Coordinate{-41.8208, -14.2583}, // BMS
    Coordinate{-94.215, 30.0703}, // BMT
    Coordinate{118.687, -8.53972}, // BMU
    Coordinate{108.12, 12.6681}, // BMV
    Coordinate{0.927, 21.3778}, // BMW
    Coordinate{163.661, -19.7206}, // BMY
    Coordinate{-86.6819, 36.1267}, // BNA
    Coordinate{20.8667, -0.283333}, // BNB
    Coordinate{29.4667, 0.575}, // BNC
    Coordinate{56.3778, 27.2181}, // BND
    Coordinate{153.118, -27.3833}, // BNE
    Coordinate{-116.851, 33.9225}, // BNG
    Coordinate{5.59944, 6.31694}, // BNI
    Coordinate{7.16333, 50.7689}, // BNJ
    Coordinate{153.562, -28.8333}, // BNK
    Coordinate{-81.3881, 33.2581}, // BNL
    Coordinate{12.2175, 65.4611}, // BNN
    Coordinate{-118.956, 43.5919}, // BNO
    Coordinate{70.5242, 32.9719}, // BNP
    Coordinate{-4.717, 10.683}, // BNR
    Coordinate{-70.2208, 8.61944}, // BNS
    Coordinate{-49.0936, -26.8328}, // BNU
    Coordinate{-93.8475, 42.0494}, // BNW
    Coordinate{17.2975, 44.9414}, // BNX
    Coordinate{159.798, -11.3017}, // BNY
    Coordinate{13.0636, -5.86667}, // BOA
    Coordinate{-151.753, -16.4436}, // BOB
    Coordinate{-82.2508, 9.34083}, // BOC
    Coordinate{-0.715556, 44.8283}, // BOD
    Coordinate{15.3833, -1.03333}, // BOE
    Coordinate{-74.1469, 4.70139}, // BOG
    Coordinate{-1.8425, 50.78}, // BOH
    Coordinate{-116.223, 43.5644}, // BOI
    Coordinate{27.5153, 42.5703}, // BOJ
    Coordinate{-124.29, 42.0744}, // BOK
    Coordinate{72.8681, 19.0886}, // BOM
    Coordinate{-68.2686, 12.1311}, // BON
    Coordinate{14.3653, 67.2692}, // BOO
    Coordinate{15.6378, 5.9625}, // BOP
    Coordinate{-71.0064, 42.3631}, // BOS
    Coordinate{141.092, -7.24083}, // BOT
    Coordinate{2.37, 47.0608}, // BOU
    Coordinate{-81.7833, 27.9433}, // BOW
    Coordinate{136.3, -16.0753}, // BOX
    Coordinate{-4.33083, 11.16}, // BOY
    Coordinate{16.3167, 6.33333}, // BOZ
    Coordinate{10.1167, 6.03917}, // BPC
    Coordinate{119.059, 39.6664}, // BPE
    Coordinate{158, -8.63}, // BPF
    Coordinate{-52.3894, -15.8608}, // BPG
    Coordinate{126.324, 8.19637}, // BPH
    Coordinate{-110.111, 42.585}, // BPI
    Coordinate{141.744, -5.52639}, // BPK
    Coordinate{82.2997, 44.895}, // BPL
    Coordinate{78.4675, 17.4531}, // BPM
    Coordinate{116.894, -1.26833}, // BPN
    Coordinate{125.479, 11.6742}, // BPR
    Coordinate{-39.0778, -16.4381}, // BPS
    Coordinate{-94.0206, 29.9508}, // BPT
    Coordinate{97.1086, 30.5536}, // BPX
    Coordinate{44.4833, -16.75}, // BPY
    Coordinate{121.5, 15.7303}, // BQA
    Coordinate{115.4, -33.6872}, // BQB
    Coordinate{-15.8381, 11.2972}, // BQE
    Coordinate{140.449, 52.3806}, // BQG
    Coordinate{0.0325, 51.3308}, // BQH
    Coordinate{134.695, 67.6489}, // BQJ
    Coordinate{-81.4664, 31.2589}, // BQK
    Coordinate{139.9, -22.9133}, // BQL
    Coordinate{-67.1294, 18.4949}, // BQN
    Coordinate{-3.0338, 9.254}, // BQO
    Coordinate{-43.1475, -11.0839}, // BQQ
    Coordinate{-78.6122, 42.9222}, // BQR
    Coordinate{127.413, 50.425}, // BQS
    Coordinate{23.8981, 52.1083}, // BQT
    Coordinate{-61.2644, 12.9869}, // BQU
    Coordinate{127.973, -20.1483}, // BQW
    Coordinate{-45.01, -12.08}, // BRA
    Coordinate{-42.8058, -2.75639}, // BRB
    Coordinate{-71.1575, -41.1511}, // BRC
    Coordinate{-94.1356, 46.4022}, // BRD
    Coordinate{8.78667, 53.0475}, // BRE
    Coordinate{16.7606, 41.1389}, // BRI
    Coordinate{145.952, -30.0392}, // BRK
    Coordinate{-91.1256, 40.7831}, // BRL
    Coordinate{-69.3586, 10.0428}, // BRM
    Coordinate{7.49917, 46.9122}, // BRN
    Coordinate{-97.4258, 25.9069}, // BRO
    Coordinate{16.6944, 49.1514}, // BRQ
    Coordinate{-7.44167, 57.0236}, // BRR
    Coordinate{-2.71917, 51.3828}, // BRS
    Coordinate{130.62, -11.7692}, // BRT
    Coordinate{4.48444, 50.9014}, // BRU
    Coordinate{25.5243, 45.7071}, // BRV
    Coordinate{-156.766, 71.2856}, // BRW
    Coordinate{-71.1219, 18.2517}, // BRX
    Coordinate{-85.4997, 37.8144}, // BRY
    Coordinate{49.15, 11.2756}, // BSA
    Coordinate{-47.9186, -15.8711}, // BSB
    Coordinate{-77.3948, 6.20278}, // BSC
    Coordinate{99.1683, 25.0533}, // BSD
    Coordinate{109.763, 1.81361}, // BSE
    Coordinate{9.80568, 1.90547}, // BSG
    Coordinate{147.568, -37.8875}, // BSJ
    Coordinate{5.73831, 34.7934}, // BSK
    Coordinate{7.52917, 47.59}, // EAP
    Coordinate{17.4333, 6.5}, // BSN
    Coordinate{121.979, 20.4504}, // BSO
    Coordinate{141.256, -8.85633}, // BSP
    Coordinate{-109.883, 31.3639}, // BSQ
    Coordinate{47.6625, 30.5489}, // BSR
    Coordinate{-46.0533, -7.52528}, // BSS
    Coordinate{64.3647, 31.5588}, // BST
    Coordinate{19.7889, 1.21667}, // BSU
    Coordinate{-146.146, 60.4231}, // BSW
    Coordinate{94.78, 16.8125}, // BSX
    Coordinate{42.3077, 2.33672}, // BSY
    Coordinate{13.7167, 4.54861}, // BTA
    Coordinate{18.5, 3.05}, // BTB
    Coordinate{-12.5183, 7.53194}, // BTE
    Coordinate{-111.927, 40.8694}, // BTF
    Coordinate{18.3, 7.31667}, // BTG
    Coordinate{104.119, 1.12083}, // BTH
    Coordinate{-143.582, 70.1339}, // BTI
    Coordinate{95.4203, 5.52333}, // BTJ
    Coordinate{101.698, 56.37}, // BTK
    Coordinate{-85.25, 42.3064}, // BTL
    Coordinate{-112.497, 45.9547}, // BTM
    Coordinate{-79.7344, 34.6217}, // BTN
    Coordinate{-55.45, 4.21667}, // BTO
    Coordinate{-79.9497, 40.7769}, // BTP
    Coordinate{29.74, -2.595}, // BTQ
    Coordinate{-91.15, 30.5328}, // BTR
    Coordinate{17.2128, 48.17}, // BTS
    Coordinate{-151.529, 66.9139}, // BTT
    Coordinate{113.02, 3.12361}, // BTU
    Coordinate{-73.1533, 44.4719}, // BTV
    Coordinate{115.996, -3.45}, // BTW
    Coordinate{-116.787, 36.8611}, // BTY
    Coordinate{154.673, -5.42222}, // BUA
    Coordinate{139.534, -17.7486}, // BUC
    Coordinate{19.2619, 47.4394}, // BUD
    Coordinate{-78.7322, 42.9406}, // BUF
    Coordinate{13.4036, -12.6089}, // BUG
    Coordinate{138.65, -3.71667}, // BUI
    Coordinate{4.20575, 35.3327}, // BUJ
    Coordinate{43.7667, 15.8333}, // BUK
    Coordinate{146.649, -7.21611}, // BUL
    Coordinate{-76.9897, 3.81959}, // BUN
    Coordinate{45.5667, 9.5}, // BUO
    Coordinate{74.7556, 30.27}, // BUP
    Coordinate{28.6179, -20.0174}, // BUQ
    Coordinate{-118.359, 34.2006}, // BUR
    Coordinate{41.5994, 41.6103}, // BUS
    Coordinate{90.7464, 27.5628}, // BUT
    Coordinate{-88.3047, 42.6908}, // BUU
    Coordinate{-57.5597, -30.3194}, // BUV
    Coordinate{122.568, -5.48778}, // BUW
    Coordinate{30.2167, 1.56583}, // BUX
    Coordinate{115.677, -33.3781}, // BUY
    Coordinate{50.8303, 28.9448}, // BUZ
    Coordinate{2.11278, 49.4544}, // BVA
    Coordinate{-60.6922, 2.84139}, // BVB
    Coordinate{-22.8886, 16.1372}, // BVC
    Coordinate{1.48556, 45.0397}, // BVE
    Coordinate{29.0342, 70.8714}, // BVG
    Coordinate{-60.0972, -12.6942}, // BVH
    Coordinate{139.348, -25.8975}, // BVI
    Coordinate{-63.8783, -13.6066}, // BVK
    Coordinate{-63.5833, -13.5833}, // BVL
    Coordinate{-98.0558, 41.7286}, // BVN
    Coordinate{-96.0111, 36.7642}, // BVO
    Coordinate{-24.746, 14.8643}, // BVR
    Coordinate{-151.045, 61.1731}, // BVU
    Coordinate{147.622, 44.92}, // BVV
    Coordinate{142.675, -12.6592}, // BVW
    Coordinate{-91.6475, 35.7261}, // BVX
    Coordinate{-70.9165, 42.5842}, // BVY
    Coordinate{83.4161, 27.5056}, // BWA
    Coordinate{115.405, -20.8658}, // BWB
    Coordinate{-115.517, 32.9931}, // BWC
    Coordinate{-98.9564, 31.7936}, // BWD
    Coordinate{10.5553, 52.3192}, // BWE
    Coordinate{-3.26722, 54.1286}, // BWF
    Coordinate{-86.4197, 36.9644}, // BWG
    Coordinate{100.391, 5.46611}, // BWH
    Coordinate{-76.6683, 39.1753}, // BWI
    Coordinate{16.6797, 43.2858}, // BWK
    Coordinate{-97.3494, 36.745}, // BWL
    Coordinate{-103.428, 46.1869}, // BWM
    Coordinate{114.928, 4.94417}, // BWN
    Coordinate{47.75, 51.85}, // BWO
    Coordinate{146.817, -29.9739}, // BWQ
    Coordinate{-122.732, 48.99}, // BWS
    Coordinate{145.731, -40.9989}, // BWT
    Coordinate{150.988, -33.925}, // BWU
    Coordinate{-79.1472, 22.6211}, // BWW
    Coordinate{114.34, -8.3106}, // BWX
    Coordinate{133.417, -2.55}, // BXB
    Coordinate{139.583, -7.16667}, // BXD
    Coordinate{-12.4833, 14.8472}, // BXE
    Coordinate{144.33, -36.7394}, // BXG
    Coordinate{75.005, 46.8933}, // BXH
    Coordinate{-6.467, 9.533}, // BXI
    Coordinate{76.8825, 43.3517}, // BXJ
    Coordinate{-112.686, 33.4206}, // BXK
    Coordinate{139.6, -2.28333}, // BXM
    Coordinate{27.6556, 37.1361}, // BXN
    Coordinate{8.39694, 46.9744}, // BXO
    Coordinate{23.1436, 52.0031}, // BXP
    Coordinate{58.4497, 29.0842}, // BXR
    Coordinate{-116.321, 33.2589}, // BXS
    Coordinate{117.477, 0.121661}, // BXT
    Coordinate{125.478, 8.95132}, // BXU
    Coordinate{-14.0228, 64.79}, // BXV
    Coordinate{112.679, -5.72361}, // BXW
    Coordinate{43.1508, 9.94556}, // BXX
    Coordinate{56.2457, 25.6146}, // BYB
    Coordinate{-63.6517, -21.9608}, // BYC
    Coordinate{45.4403, 14.1056}, // BYD
    Coordinate{2.6925, 49.97}, // BYF
    Coordinate{-89.9439, 35.9644}, // BYH
    Coordinate{-113.772, 42.5425}, // BYI
    Coordinate{-7.9325, 38.0789}, // BYJ
    Coordinate{-5.07361, 7.73889}, // BYK
    Coordinate{-76.6214, 20.3964}, // BYM
    Coordinate{100.7, 46.1706}, // BYN
    Coordinate{-56.4561, -21.2472}, // BYO
    Coordinate{119.166, -22.6739}, // BYP
    Coordinate{117.867, 3.45583}, // BYQ
    Coordinate{10.9997, 57.2769}, // BYR
    Coordinate{-9.48444, 51.6689}, // BYT
    Coordinate{-84.6306, 14.0383}, // BZA
    Coordinate{35.4728, -21.5428}, // BZB
    Coordinate{-41.9656, -22.771}, // BZC
    Coordinate{143.578, -34.6236}, // BZD
    Coordinate{-88.3083, 17.5392}, // BZE
    Coordinate{-122.408, 40.5742}, // BZF
    Coordinate{17.9778, 53.0967}, // BZG
    Coordinate{34.1764, 53.2142}, // BZK
    Coordinate{90.3012, 22.7989}, // BZL
    Coordinate{-111.152, 45.7775}, // BZN
    Coordinate{11.3264, 46.4603}, // BZO
    Coordinate{3.35333, 43.3233}, // BZR
    Coordinate{24.7833, 2.81667}, // BZU
    Coordinate{15.253, -4.2517}, // BZV
    Coordinate{27.7772, 47.8431}, // BZY
    Coordinate{-85.7717, 14.8756}, // CAA
    Coordinate{12.1881, -5.59711}, // CAB
    Coordinate{-53.5019, -25.0022}, // CAC
    Coordinate{-85.4189, 44.2753}, // CAD
    Coordinate{-81.1194, 33.9389}, // CAE
    Coordinate{-66.8956, -4.87861}, // CAF
    Coordinate{9.05428, 39.2515}, // CAG
    Coordinate{105.179, 9.17556}, // CAH
    Coordinate{31.4056, 30.1219}, // CAI
    Coordinate{-62.8542, 6.23194}, // CAJ
    Coordinate{-81.4422, 40.9161}, // CAK
    Coordinate{-5.68639, 55.4372}, // CAL
    Coordinate{-63.5278, -20.0071}, // CAM
    Coordinate{113.299, 23.3924}, // CAN
    Coordinate{-103.15, 36.4464}, // CAO
    Coordinate{-72.2, 19.7331}, // CAP
    Coordinate{-75.1983, 7.96833}, // CAQ
    Coordinate{-68.0179, 46.8715}, // CAR
    Coordinate{-7.66056, 33.5569}, // CAS
    Coordinate{-9.35528, 38.7256}, // CAT
    Coordinate{-36.0108, -8.28444}, // CAU
    Coordinate{22.916, -11.8929}, // CAV
    Coordinate{-41.3078, -21.7011}, // CAW
    Coordinate{-2.80917, 54.9375}, // CAX
    Coordinate{-52.3619, 4.81972}, // CAY
    Coordinate{145.793, -31.5383}, // CAZ
    Coordinate{43.0667, 11.5167}, // CBA
    Coordinate{-66.1769, -17.4208}, // CBB
    Coordinate{-78.7608, 39.6156}, // CBE
    Coordinate{-95.7586, 41.26}, // CBF
    Coordinate{0.175, 52.205}, // CBG
    Coordinate{-2.26119, 31.6547}, // CBH
    Coordinate{-71.6447, 17.9289}, // CBJ
    Coordinate{-101.047, 39.4275}, // CBK
    Coordinate{-63.5361, 8.12222}, // CBL
    Coordinate{108.54, -6.75614}, // CBN
    Coordinate{124.21, 7.16076}, // CBO
    Coordinate{-8.47222, 40.1614}, // CBP
    Coordinate{8.34694, 4.97583}, // CBQ
    Coordinate{149.195, -35.3069}, // CBR
    Coordinate{-71.3225, 10.33}, // CBS
    Coordinate{13.4873, -12.4795}, // CBT
    Coordinate{14.532, 51.8895}, // CBU
    Coordinate{-90.4067, 15.4689}, // CBV
    Coordinate{-52.3569, -24.0025}, // CBW
    Coordinate{147.208, -33.065}, // CBX
    Coordinate{-65.1415, -16.99}, // CCA
    Coordinate{-117.688, 34.1117}, // CCB
    Coordinate{-78.3286, 22.4611}, // CCC
    Coordinate{2.30855, 43.2158}, // CCF
    Coordinate{-71.6907, -46.5827}, // CCH
    Coordinate{-52.0511, -27.1806}, // CCI
    Coordinate{75.9504, 11.1381}, // CCJ
    Coordinate{96.8339, -12.1883}, // CCK
    Coordinate{150.617, -26.775}, // CCL
    Coordinate{-49.4214, -28.7244}, // CCM
    Coordinate{65.2706, 34.5264}, // CCN
    Coordinate{-71.3364, 4.56417}, // CCO
    Coordinate{-73.0631, -36.7725}, // CCP
    Coordinate{-122.057, 37.9897}, // CCR
    Coordinate{-66.9906, 10.6031}, // CCS
    Coordinate{-67.835, -37.91}, // CCT
    Coordinate{88.4467, 22.6539}, // CCU
    Coordinate{167.924, -16.265}, // CCV
    Coordinate{136.892, -33.6667}, // CCW
    Coordinate{-57.6308, -16.0436}, // CCX
    Coordinate{-92.6108, 43.0725}, // CCY
    Coordinate{-77.8833, 25.4167}, // CCZ
    Coordinate{-162.724, 55.2053}, // CDB
    Coordinate{-113.099, 37.7008}, // CDC
    Coordinate{-83.5917, 15.3167}, // CDD
    Coordinate{118.072, 41.1219}, // CDE
    Coordinate{12.1151, 46.5743}, // CDF
    Coordinate{2.54778, 49.0097}, // CDG
    Coordinate{-92.7633, 33.6228}, // CDH
    Coordinate{-41.1875, -20.8367}, // CDI
    Coordinate{-49.3031, -8.34861}, // CDJ
    Coordinate{-83.0506, 29.1342}, // CDK
    Coordinate{-80.565, 34.2836}, // CDN
    Coordinate{78.7728, 14.51}, // CDP
    Coordinate{-103.095, 42.8375}, // CDR
    Coordinate{-100.288, 34.4339}, // CDS
    Coordinate{0.02474, 39.9981}, // CDT
    Coordinate{150.687, -34.0403}, // CDU
    Coordinate{-145.477, 60.4917}, // CDV
    Coordinate{-74.2814, 40.8753}, // CDW
    Coordinate{118.495, 7.01273}, // CDY
    Coordinate{-97.2506, 37.6486}, // CEA
    Coordinate{123.979, 10.3075}, // CEB
    Coordinate{-124.237, 41.7803}, // CEC
    Coordinate{133.71, -32.1306}, // CED
    Coordinate{38.0283, 59.2767}, // CEE
    Coordinate{-72.5347, 42.1939}, // CEF
    Coordinate{-2.97778, 53.1781}, // CEG
    Coordinate{33.8, -10.55}, // CEH
    Coordinate{99.8828, 19.9522}, // CEI
    Coordinate{31.16, 51.4033}, // CEJ
    Coordinate{61.505, 55.305}, // CEK
    Coordinate{-76.2947, 24.7903}, // CEL
    Coordinate{-144.781, 65.5739}, // CEM
    Coordinate{-109.833, 27.3925}, // CEN
    Coordinate{15.1015, -11.4264}, // CEO
    Coordinate{-62.026, -16.1472}, // CEP
    Coordinate{6.95417, 43.5464}, // CEQ
    Coordinate{-1.47528, 49.6508}, // CER
    Coordinate{151.342, -32.7883}, // CES
    Coordinate{-0.877222, 47.0819}, // CET
    Coordinate{-82.8868, 34.6719}, // CEU
    Coordinate{-85.1311, 39.6983}, // CEV
    Coordinate{-86.5221, 30.7788}, // CEW
    Coordinate{-88.3728, 36.6644}, // CEY
    Coordinate{-108.628, 37.3031}, // CEZ
    Coordinate{-42.0714, -22.9208}, // CFB
    Coordinate{-50.9397, -26.7897}, // CFC
    Coordinate{-96.3314, 30.7156}, // CFD
    Coordinate{3.1625, 45.7858}, // CFE
    Coordinate{17.9906, -8.78347}, // CFF
    Coordinate{-80.3975, 22.15}, // CFG
    Coordinate{-8.34111, 55.0442}, // CFN
    Coordinate{-51.5672, -10.6336}, // CFO
    Coordinate{-116.498, 49.0367}, // CFQ
    Coordinate{-0.45, 49.1733}, // CFR
    Coordinate{153.117, -30.32}, // CFS
    Coordinate{-109.211, 32.9569}, // CFT
    Coordinate{19.9122, 39.6019}, // CFU
    Coordinate{-95.5719, 37.0942}, // CFV
    Coordinate{-133.148, 55.4789}, // CGA
    Coordinate{-56.1175, -15.65}, // CGB
    Coordinate{148.432, -5.45917}, // CGC
    Coordinate{111.64, 28.9189}, // CGD
    Coordinate{-76.0303, 38.5394}, // CGE
    Coordinate{-81.4864, 41.565}, // CGF
    Coordinate{-46.6564, -23.6261}, // CGH
    Coordinate{-89.5708, 37.2253}, // CGI
    Coordinate{27.8939, -12.5728}, // CGJ
    Coordinate{106.654, -6.12736}, // CGK
    Coordinate{124.707, 9.25361}, // CGM
    Coordinate{7.14278, 50.8658}, // CGN
    Coordinate{113.841, 34.5197}, // CGO
    Coordinate{91.8133, 22.2497}, // CGP
    Coordinate{121.196, 43.905}, // CGQ
    Coordinate{-54.6703, -20.4694}, // CGR
    Coordinate{-76.9223, 38.9806}, // CGS
    Coordinate{124.457, 8.6125}, // CGY
    Coordinate{-111.767, 32.955}, // CGZ
    Coordinate{-85.2039, 35.0353}, // CHA
    Coordinate{74.0817, 35.4267}, // CHB
    Coordinate{172.532, -43.4894}, // CHC
    Coordinate{-111.811, 33.2692}, // CHD
    Coordinate{128.696, 35.1411}, // CHF
    Coordinate{120.435, 41.5381}, // CHG
    Coordinate{-77.8561, -6.20194}, // CHH
    Coordinate{32.6289, -20.2064}, // CHJ
    Coordinate{-97.9678, 35.0972}, // CHK
    Coordinate{-114.218, 44.5236}, // CHL
    Coordinate{-78.5239, -9.14972}, // CHM
    Coordinate{127.119, 35.8783}, // CHN
    Coordinate{-78.4529, 38.1386}, // CHO
    Coordinate{-144.611, 65.4856}, // CHP
    Coordinate{24.1497, 35.5317}, // CHQ
    Coordinate{1.72111, 46.8603}, // CHR
    Coordinate{-80.0406, 32.8986}, // CHS
    Coordinate{-176.457, -43.81}, // CHT
    Coordinate{-159.216, 61.5792}, // CHU
    Coordinate{-7.46445, 41.7222}, // CHV
    Coordinate{-82.5486, 9.45889}, // CHX
    Coordinate{156.396, -6.71194}, // CHY
    Coordinate{-121.876, 42.5831}, // CHZ
    Coordinate{12.5972, 41.7994}, // CIA
    Coordinate{-121.858, 39.7953}, // CIC
    Coordinate{-91.7003, 41.8891}, // CID
    Coordinate{118.908, 42.235}, // CIF
    Coordinate{-107.522, 40.4953}, // CIG
    Coordinate{113.126, 36.2475}, // CIH
    Coordinate{-112.168, 47.8283}, // CII
    Coordinate{-68.7828, -11.0403}, // CIJ
    Coordinate{-143.74, 66.645}, // CIK
    Coordinate{-163.703, 64.8978}, // CIL
    Coordinate{-73.97, 6.36667}, // CIM
    Coordinate{-94.7889, 42.0461}, // CIN
    Coordinate{-57.4278, -23.4417}, // CIO
    Coordinate{32.5869, -13.5569}, // CIP
    Coordinate{-89.6167, 14.85}, // CIQ
    Coordinate{-171.713, -2.77}, // CIS
    Coordinate{69.4761, 42.365}, // CIT
    Coordinate{-84.4725, 46.2508}, // CIU
    Coordinate{-61.3444, 12.6992}, // CIW
    Coordinate{-79.8281, -6.78722}, // CIX
    Coordinate{14.6069, 36.9917}, // CIY
    Coordinate{-63.1311, -4.13389}, // CIZ
    Coordinate{-78.4892, -7.13917}, // CJA
    Coordinate{77.0419, 11.0305}, // CJB
    Coordinate{-68.9036, -22.4897}, // CJC
    Coordinate{118.802, -22.9667}, // CJF
    Coordinate{-124.142, 51.6261}, // CJH
    Coordinate{127.499, 36.7164}, // CJJ
    Coordinate{71.7981, 35.8817}, // CJL
    Coordinate{99.3617, 10.7111}, // CJM
    Coordinate{108.49, -7.72039}, // CJN
    Coordinate{-77.8597, 38.5256}, // CJR
    Coordinate{-106.429, 31.6361}, // CJS
    Coordinate{-92.0506, 16.175}, // CJT
    Coordinate{126.493, 33.5122}, // CJU
    Coordinate{-38.5719, -6.90444}, // CJZ
    Coordinate{-80.2281, 39.2967}, // CKB
    Coordinate{31.9953, 49.4156}, // CKC
    Coordinate{-158.135, 61.8678}, // CKD
    Coordinate{-122.901, 38.9906}, // CKE
    Coordinate{-83.7739, 31.9889}, // CKF
    Coordinate{106.642, 29.7192}, // CKG
    Coordinate{147.897, 70.625}, // CKH
    Coordinate{132.483, -11.1653}, // CKI
    Coordinate{38.0617, 55.8783}, // CKL
    Coordinate{-90.5122, 34.2997}, // CKM
    Coordinate{-96.6217, 47.8408}, // CKN
    Coordinate{-50.6028, -23.1528}, // CKO
    Coordinate{-50.0042, -6.11778}, // CKS
    Coordinate{61.07, 36.4881}, // CKT
    Coordinate{-145.727, 60.5439}, // CKU
    Coordinate{-87.415, 36.6219}, // CKV
    Coordinate{119.652, -22.3556}, // CKW
    Coordinate{-141.952, 64.0714}, // CKX
    Coordinate{-13.6119, 9.57689}, // CKY
    Coordinate{-75.2906, 40.3892}, // CKZ
    Coordinate{91.1833, 23.4333}, // CLA
    Coordinate{-117.28, 33.1283}, // CLD
    Coordinate{-81.8497, 41.4117}, // CLE
    Coordinate{-120.294, 36.1631}, // CLG
    Coordinate{149.61, -31.7733}, // CLH
    Coordinate{-88.7308, 44.6133}, // CLI
    Coordinate{23.6861, 46.7851}, // CLJ
    Coordinate{-98.9328, 35.5383}, // CLK
    Coordinate{-96.3639, 30.5886}, // CLL
    Coordinate{-123.5, 48.1203}, // CLM
    Coordinate{-47.4586, -7.33361}, // CLN
    Coordinate{-76.3814, 3.54306}, // CLO
    Coordinate{-158.529, 58.8336}, // CLP
    Coordinate{-103.578, 19.2769}, // CLQ
    Coordinate{-115.521, 33.1314}, // CLR
    Coordinate{-122.59, 46.4062}, // CLS
    Coordinate{-85.8964, 39.2619}, // CLU
    Coordinate{-48.61, -17.7247}, // CLV
    Coordinate{-82.7586, 27.9767}, // CLW
    Coordinate{-57.7348, -25.3048}, // CLX
    Coordinate{8.79, 42.525}, // CLY
    Coordinate{-67.4169, 8.92444}, // CLZ
    Coordinate{145.622, -28.03}, // CMA
    Coordinate{79.8836, 7.18111}, // CMB
    Coordinate{148.028, -34.625}, // CMD
    Coordinate{-91.7995, 18.652}, // CME
    Coordinate{5.88, 45.6392}, // CMF
    Coordinate{-57.6714, -19.0119}, // CMG
    Coordinate{-82.8919, 39.9981}, // CMH
    Coordinate{-88.2781, 40.0392}, // CMI
    Coordinate{119.418, 23.2131}, // CMJ
    Coordinate{35.1325, -14.3069}, // CMK
    Coordinate{138.125, -19.9117}, // CML
    Coordinate{-90.0528, 17.4625}, // CMM
    Coordinate{-7.58167, 33.3642}, // CMN
    Coordinate{48.5256, 5.35}, // CMO
    Coordinate{-50.3503, -9.33528}, // CMP
    Coordinate{147.62, -22.7733}, // CMQ
    Coordinate{7.35917, 48.1103}, // CMR
    Coordinate{50.2056, 10.3}, // CMS
    Coordinate{144.97, -6.02417}, // CMU
    Coordinate{175.509, -36.7917}, // CMV
    Coordinate{-77.8475, 21.4203}, // CMW
    Coordinate{-88.4892, 47.1683}, // CMX
    Coordinate{-90.7378, 43.9583}, // CMY
    Coordinate{-110.267, 31}, // CNA
    Coordinate{148.375, -30.9834}, // CNB
    Coordinate{143.067, -10.05}, // CNC
    Coordinate{28.4883, 44.3621}, // CND
    Coordinate{-43.9714, -19.6239}, // CNF
    Coordinate{-72.3686, 43.3706}, // CNH
    Coordinate{122.667, 39.2664}, // CNI
    Coordinate{140.504, -20.6686}, // CNJ
    Coordinate{-97.6522, 39.5492}, // CNK
    Coordinate{10.2266, 57.5047}, // CNL
    Coordinate{-104.263, 32.3375}, // CNM
    Coordinate{-117.637, 33.9747}, // CNO
    Coordinate{-22.6486, 70.7433}, // CNP
    Coordinate{-58.7619, -27.4456}, // CNQ
    Coordinate{-70.6074, -26.3344}, // CNR
    Coordinate{145.755, -16.8858}, // CNS
    Coordinate{-95.485, 37.6689}, // CNU
    Coordinate{-97.0742, 31.6378}, // CNW
    Coordinate{98.9625, 18.7667}, // CNX
    Coordinate{-109.755, 38.755}, // CNY
    Coordinate{19.8604, -13.7094}, // CNZ
    Coordinate{-120.414, 38.0306}, // COA
    Coordinate{-57.9967, -31.2969}, // COC
    Coordinate{-109.024, 44.5203}, // COD
    Coordinate{-116.819, 47.7744}, // COE
    Coordinate{-76.6833, 5.08333}, // COG
    Coordinate{89.4679, 26.3307}, // COH
    Coordinate{-80.6856, 28.3417}, // COI
    Coordinate{149.267, -31.3333}, // COJ
    Coordinate{76.4019, 10.1519}, // COK
    Coordinate{-6.61778, 56.6019}, // COL
    Coordinate{-99.4033, 31.8411}, // COM
    Coordinate{-71.5022, 43.2028}, // CON
    Coordinate{2.385, 6.35583}, // COO
    Coordinate{-74.8911, 42.6292}, // COP
    Coordinate{114.646, 48.1356}, // COQ
    Coordinate{-64.2083, -31.31}, // COR
    Coordinate{-104.701, 38.8058}, // COS
    Coordinate{-99.2183, 28.4567}, // COT
    Coordinate{-92.2197, 38.8181}, // COU
    Coordinate{-7.48, 40.2642}, // COV
    Coordinate{-77.5898, 24.1587}, // COX
    Coordinate{117.759, -21.7942}, // COY
    Coordinate{-70.7197, 18.9075}, // COZ
    Coordinate{-7.70012, 4.36764}, // CPA
    Coordinate{-77.35, 8.63028}, // CPB
    Coordinate{-71.1372, -40.0753}, // CPC
    Coordinate{134.721, -29.04}, // CPD
    Coordinate{-90.5008, 19.8158}, // CPE
    Coordinate{111.548, -7.19472}, // CPF
    Coordinate{12.6561, 55.6181}, // CPH
    Coordinate{-76.3206, 36.6656}, // CPK
    Coordinate{-75.4653, 3.72444}, // CPL
    Coordinate{-118.244, 33.89}, // CPM
    Coordinate{-70.7792, -27.2612}, // CPO
    Coordinate{-47.1081, -22.8592}, // CPQ
    Coordinate{-106.464, 42.9081}, // CPR
    Coordinate{-90.1561, 38.5708}, // CPS
    Coordinate{18.5972, -33.9694}, // CPT
    Coordinate{-44.8669, -1.82111}, // CPU
    Coordinate{-35.895, -7.26917}, // CPV
    Coordinate{-65.3044, 18.3133}, // CPX
    Coordinate{-52.2708, -13.5744}, // CQA
    Coordinate{-96.8203, 35.7239}, // CQB
    Coordinate{50.8422, 32.2972}, // CQD
    Coordinate{1.95139, 50.9608}, // CQF
    Coordinate{-3.97, 38.8564}, // CQM
    Coordinate{-69.9894, 41.6883}, // CQX
    Coordinate{23.8886, 44.3181}, // CRA
    Coordinate{148.582, -29.5219}, // CRB
    Coordinate{-75.9558, 4.75833}, // CRC
    Coordinate{-67.4656, -45.7853}, // CRD
    Coordinate{-78.7239, 33.8117}, // CRE
    Coordinate{15.9, 4.93333}, // CRF
    Coordinate{-81.5144, 30.3364}, // CRG
    Coordinate{-74.1822, 22.7456}, // CRI
    Coordinate{120.56, 15.1858}, // CRK
    Coordinate{}, // CRL
    Coordinate{124.636, 12.5022}, // CRM
    Coordinate{-119.595, 36.1028}, // CRO
    Coordinate{-97.5011, 27.7703}, // CRP
    Coordinate{-39.2544, -17.6506}, // CRQ
    Coordinate{-61.8767, -29.8717}, // CRR
    Coordinate{-96.4006, 32.0281}, // CRS
    Coordinate{-91.8803, 33.1783}, // CRT
    Coordinate{-61.4722, 12.4769}, // CRU
    Coordinate{17.0803, 38.9972}, // CRV
    Coordinate{-81.5931, 38.3758}, // CRW
    Coordinate{-88.6036, 34.915}, // CRX
    Coordinate{63.6133, 39.0833}, // CRZ
    Coordinate{-6.24306, 56.0575}, // CSA
    Coordinate{22.2522, 45.4202}, // CSB
    Coordinate{-83.5931, 10.1606}, // CSC
    Coordinate{-84.9389, 32.5164}, // CSG
    Coordinate{35.7333, 65.03}, // CSH
    Coordinate{153.067, -28.8833}, // CSI
    Coordinate{-16.7461, 12.3889}, // CSK
    Coordinate{-109.937, 22.9475}, // CSL
    Coordinate{-99.2006, 35.3397}, // CSM
    Coordinate{-119.734, 39.1922}, // CSN
    Coordinate{11.418, 51.8559}, // CSO
    Coordinate{-94.3633, 41.0214}, // CSQ
    Coordinate{-51.6853, -19.1464}, // CSS
    Coordinate{-52.4122, -29.6836}, // CSU
    Coordinate{113.221, 28.1967}, // CSX
    Coordinate{47.3472, 56.09}, // CSY
    Coordinate{15.0639, 37.4667}, // CTA
    Coordinate{-112.376, 48.6083}, // CTB
    Coordinate{-65.7508, -28.5931}, // CTC
    Coordinate{-80.4097, 7.9875}, // CTD
    Coordinate{-78.9792, 9.45278}, // CTE
    Coordinate{-91.8825, 14.6942}, // CTF
    Coordinate{-75.5131, 10.4425}, // CTG
    Coordinate{-75.8656, 39.9789}, // CTH
    Coordinate{19.1572, -15.1605}, // CTI
    Coordinate{-85.1522, 33.6317}, // CTJ
    Coordinate{-90.0747, 40.5692}, // CTK
    Coordinate{146.262, -26.4133}, // CTL
    Coordinate{-88.3269, 18.5046}, // CTM
    Coordinate{145.184, -15.4447}, // CTN
    Coordinate{-72.7919, 40.915}, // CTO
    Coordinate{-53.3442, -33.5022}, // CTQ
    Coordinate{141.692, 42.7752}, // CTS
    Coordinate{5.78611, 43.2522}, // CTT
    Coordinate{103.948, 30.58}, // CTU
    Coordinate{-114.701, 29.7264}, // CTV
    Coordinate{-76.2147, 42.5925}, // CTX
    Coordinate{-83.1047, 29.6356}, // CTY
    Coordinate{-78.3656, 34.975}, // CTZ
    Coordinate{-111.615, 25.0539}, // CUA
    Coordinate{-80.9953, 33.9706}, // CUB
    Coordinate{-72.5117, 7.9275}, // CUC
    Coordinate{153.105, -26.8017}, // CUD
    Coordinate{-78.9844, -2.88944}, // CUE
    Coordinate{7.62182, 44.546}, // CUF
    Coordinate{-96.7733, 35.95}, // CUH
    Coordinate{-88.0294, 17.735}, // CUK
    Coordinate{-107.475, 24.7644}, // CUL
    Coordinate{-64.1306, 10.4503}, // CUM
    Coordinate{-86.8769, 21.0367}, // CUN
    Coordinate{-71.2972, 1.01389}, // CUO
    Coordinate{-63.2617, 10.66}, // CUP
    Coordinate{143.114, -13.7619}, // CUQ
    Coordinate{-68.9597, 12.1889}, // CUR
    Coordinate{-107.662, 31.8081}, // CUS
    Coordinate{-69.2647, -38.9397}, // CUT
    Coordinate{-105.964, 28.7028}, // CUU
    Coordinate{-72.5366, 8.75639}, // CUV
    Coordinate{117.918, -27.4467}, // CUY
    Coordinate{-77.9406, -4.60708}, // CUZ
    Coordinate{136.505, -33.71}, // CVC
    Coordinate{-75.6917, 9.40083}, // CVE
    Coordinate{6.62717, 45.3974}, // CVF
    Coordinate{-84.6678, 39.0489}, // CVG
    Coordinate{-71.0161, -37.8506}, // CVH
    Coordinate{-99.2619, 18.8345}, // CVJ
    Coordinate{-91.5628, 36.265}, // CVK
    Coordinate{-98.9564, 23.7034}, // CVM
    Coordinate{-103.079, 34.4253}, // CVN
    Coordinate{-123.289, 44.4972}, // CVO
    Coordinate{113.672, -24.8806}, // CVQ
    Coordinate{-1.47972, 52.3725}, // CVT
    Coordinate{-31.1128, 39.6708}, // CVU
    Coordinate{-85.2753, 45.3047}, // CVX
    Coordinate{-89.6667, 44.7775}, // CWA
    Coordinate{-49.1761, -25.5317}, // CWB
    Coordinate{25.9811, 48.2589}, // CWC
    Coordinate{-93.1431, 30.2106}, // CWF
    Coordinate{-90.3292, 41.8311}, // CWI
    Coordinate{99.3704, 23.2739}, // CWJ
    Coordinate{-3.34333, 51.3967}, // CWL
    Coordinate{-122.832, 48.49}, // CWS
    Coordinate{148.648, -33.845}, // CWT
    Coordinate{146.352, -35.99}, // CWW
    Coordinate{-109.895, 32.2456}, // CWX
    Coordinate{-66.1653, 7.62583}, // CXA
    Coordinate{91.9648, 21.4498}, // CXB
    Coordinate{-150.204, 67.2522}, // CXF
    Coordinate{-123.111, 49.2944}, // CXH
    Coordinate{-157.359, 1.98611}, // CXI
    Coordinate{-51.1897, -29.1956}, // CXJ
    Coordinate{-115.513, 32.6694}, // CXL
    Coordinate{18.9238, -8.37311}, // CXM
    Coordinate{49.9086, 11.4944}, // CXN
    Coordinate{-95.4144, 30.3525}, // CXO
    Coordinate{109.05, -7.63333}, // CXP
    Coordinate{125.917, -18.8833}, // CXQ
    Coordinate{109.219, 11.9981}, // CXR
    Coordinate{146.273, -20.0433}, // CXT
    Coordinate{-92.555, 35.0197}, // CXW
    Coordinate{-79.2761, 25.5553}, // CXY
    Coordinate{-73.7883, 18.2667}, // CYA
    Coordinate{-79.8828, 19.6869}, // CYB
    Coordinate{-88.0411, 17.7008}, // CYC
    Coordinate{-164.286, 60.1492}, // CYF
    Coordinate{147.888, -36.1828}, // CYG
    Coordinate{120.383, 23.4617}, // CYI
    Coordinate{-86.675, 15.4458}, // CYL
    Coordinate{-134.946, 57.515}, // CYM
    Coordinate{-81.5456, 21.6161}, // CYO
    Coordinate{124.545, 12.0727}, // CYP
    Coordinate{-57.7706, -34.4564}, // CYR
    Coordinate{-104.811, 41.1556}, // CYS
    Coordinate{-142.494, 60.0819}, // CYT
    Coordinate{121.068, 10.8581}, // CYU
    Coordinate{-100.9, 20.5458}, // CYW
    Coordinate{161.337, 68.7433}, // CYX
    Coordinate{121.718, 16.93}, // CYZ
    Coordinate{-88.4489, 20.6386}, // CZA
    Coordinate{-145.294, 61.9411}, // CZC
    Coordinate{-69.6817, 11.415}, // CZE
    Coordinate{-166.037, 61.7819}, // CZF
    Coordinate{-76.0964, 42.0786}, // CZG
    Coordinate{-88.4108, 18.3822}, // CZH
    Coordinate{-78.575, 9.44722}, // CZJ
    Coordinate{-121.879, 45.6769}, // CZK
    Coordinate{6.61706, 36.2824}, // CZL
    Coordinate{-86.9289, 20.515}, // CZM
    Coordinate{-142.048, 62.0711}, // CZN
    Coordinate{-72.7694, -7.59944}, // CZS
    Coordinate{-75.2856, 9.33278}, // CZU
    Coordinate{19.2047, 50.885}, // CZW
    Coordinate{119.776, 31.9193}, // CZX
    Coordinate{-81.0606, 29.1847}, // DAB
    Coordinate{90.4006, 23.8428}, // DAC
    Coordinate{108.199, 16.0439}, // DAD
    Coordinate{-116.787, 34.8536}, // DAG
    Coordinate{29.0028, 25.4111}, // DAK
    Coordinate{-96.8517, 32.8472}, // DAL
    Coordinate{36.5156, 33.4115}, // DAM
    Coordinate{-79.3361, 36.5728}, // DAN
    Coordinate{39.2028, -6.87806}, // DAR
    Coordinate{-119.717, 66.7031}, // DAS
    Coordinate{113.482, 40.0603}, // DAT
    Coordinate{143.208, -9.08667}, // DAU
    Coordinate{-82.435, 8.39083}, // DAV
    Coordinate{-70.9292, 43.2842}, // DAW
    Coordinate{107.5, 31.3}, // DAX
    Coordinate{-84.2194, 39.9025}, // DAY
    Coordinate{70.8818, 38.4617}, // DAZ
    Coordinate{64.4042, 28.875}, // DBA
    Coordinate{28.4607, 30.9251}, // DBB
    Coordinate{123.019, 45.5053}, // DBC
    Coordinate{86.4253, 23.8339}, // DBD
    Coordinate{37.7333, 10.3167}, // DBM
    Coordinate{-82.9853, 32.5644}, // DBN
    Coordinate{148.575, -32.2167}, // DBO
    Coordinate{-90.7094, 42.4019}, // DBQ
    Coordinate{38, 11.9667}, // DBT
    Coordinate{18.2683, 42.5614}, // DBV
    Coordinate{151.267, -27.1553}, // DBY
    Coordinate{-77.0378, 38.8522}, // DCA
    Coordinate{-61.3922, 15.3367}, // DCF
    Coordinate{-156.905, 66.9433}, // DCK
    Coordinate{2.29056, 43.555}, // DCM
    Coordinate{-84.8625, 40.8375}, // DCR
    Coordinate{-75.7294, 22.1817}, // DCT
    Coordinate{-86.9453, 34.6542}, // DCU
    Coordinate{100.053, 29.3231}, // DCY
    Coordinate{-99.9656, 37.7631}, // DDC
    Coordinate{124.287, 40.0257}, // DDG
    Coordinate{-73.2461, 42.8911}, // DDH
    Coordinate{-66.2925, 18.4644}, // DDP
    Coordinate{70.4858, 29.9608}, // DEA
    Coordinate{21.6153, 47.4889}, // DEB
    Coordinate{-88.8656, 39.8344}, // DEC
    Coordinate{78.1802, 30.1897}, // DED
    Coordinate{145.85, 44.0333}, // DEE
    Coordinate{48.3833, 32.4333}, // DEF
    Coordinate{-91.7394, 43.2756}, // DEH
    Coordinate{55.6645, -3.80222}, // DEI
    Coordinate{77.0994, 28.5544}, // DEL
    Coordinate{34.85, 8.55}, // DEM
    Coordinate{-104.673, 39.8617}, // DEN
    Coordinate{94.2167, 27.9833}, // DEP
    Coordinate{-94.3994, 34.0469}, // DEQ
    Coordinate{53.65, -5.7}, // DES
    Coordinate{-83.01, 42.4092}, // DET
    Coordinate{-117.429, 47.9669}, // DEW
    Coordinate{40.1758, 35.2853}, // DEZ
    Coordinate{-84.4289, 41.3375}, // DFI
    Coordinate{-97.0381, 32.8969}, // DFW
    Coordinate{-88.2586, 16.9825}, // DGA
    Coordinate{149.611, -32.5625}, // DGE
    Coordinate{-120.183, 50.1667}, // DGF
    Coordinate{-109.506, 31.3425}, // DGL
    Coordinate{-104.528, 24.1242}, // DGO
    Coordinate{26.665, 55.9447}, // DGP
    Coordinate{173.894, -35.9397}, // DGR
    Coordinate{123.299, 9.33361}, // DGT
    Coordinate{-3.49, 12.459}, // DGU
    Coordinate{-105.386, 42.7972}, // DGW
    Coordinate{-3.43583, 51.4047}, // DGX
    Coordinate{50.1519, 26.2653}, // DHA
    Coordinate{80.5819, 28.7533}, // DHI
    Coordinate{76.2619, 32.165}, // DHM
    Coordinate{78.8557, 23.754}, // DHN
    Coordinate{4.78278, 52.9225}, // DHR
    Coordinate{-102.547, 36.0225}, // DHT
    Coordinate{95.018, 27.481}, // DIB
    Coordinate{49.2917, -12.3511}, // DIE
    Coordinate{99.6773, 27.7933}, // DIG
    Coordinate{-111.098, 43.7425}, // DIJ
    Coordinate{-102.802, 46.7972}, // DIK
    Coordinate{125.525, -8.54655}, // DIL
    Coordinate{-4.6411, 6.6}, // DIM
    Coordinate{103.008, 21.3972}, // DIN
    Coordinate{1.783, 12.05}, // DIP
    Coordinate{-44.87, -20.1819}, // DIQ
    Coordinate{41.8542, 9.62361}, // DIR
    Coordinate{12.6597, -4.20611}, // DIS
    Coordinate{70.9211, 20.7131}, // DIU
    Coordinate{-5.35444, 5.79306}, // DIV
    Coordinate{40.2008, 37.8925}, // DIY
    Coordinate{1.6376, 9.692}, // DJA
    Coordinate{103.644, -1.63806}, // DJB
    Coordinate{10.7753, 33.875}, // DJE
    Coordinate{9.45211, 24.2929}, // DJG
    Coordinate{140.516, -2.57694}, // DJJ
    Coordinate{14.75, -2.53333}, // DJM
    Coordinate{-145.717, 64.0506}, // DJN
    Coordinate{-6.47319, 6.79281}, // DJO
    Coordinate{-14.2778, 64.6431}, // DJU
    Coordinate{7.66028, 13.0078}, // DKA
    Coordinate{146.14, -17.9417}, // DKI
    Coordinate{-79.2719, 42.4933}, // DKK
    Coordinate{-17.4793, 14.7438}, // DKR
    Coordinate{80.3817, 73.5167}, // DKS
    Coordinate{-83.8736, 35.9639}, // DKX
    Coordinate{9.71944, 4.00583}, // DLA
    Coordinate{121.538, 38.9656}, // DLC
    Coordinate{8.51245, 60.4167}, // DLD
    Coordinate{5.42444, 47.0422}, // DLE
    Coordinate{-158.506, 59.0447}, // DLG
    Coordinate{-92.1936, 46.8422}, // DLH
    Coordinate{108.374, 11.7506}, // DLI
    Coordinate{-79.3686, 34.4492}, // DLL
    Coordinate{28.7928, 36.7147}, // DLM
    Coordinate{-112.552, 45.2553}, // DLN
    Coordinate{-119.236, 35.7456}, // DLO
    Coordinate{-121.167, 45.6186}, // DLS
    Coordinate{100.318, 25.6511}, // DLU
    Coordinate{169.001, -18.7694}, // DLY
    Coordinate{104.367, 43.6086}, // DLZ
    Coordinate{71.3036, 42.8536}, // DMB
    Coordinate{138.822, -17.9403}, // DMD
    Coordinate{37.9061, 55.4086}, // DME
    Coordinate{100.607, 13.9125}, // DMK
    Coordinate{49.7978, 26.4711}, // DMM
    Coordinate{-107.721, 32.2622}, // DMN
    Coordinate{-93.1758, 38.7075}, // DMO
    Coordinate{-56.4006, -14.3769}, // DMT
    Coordinate{93.7711, 25.8839}, // DMU
    Coordinate{-77.0078, 39.6083}, // DMW
    Coordinate{-3.0175, 56.4525}, // DND
    Coordinate{94.8003, 40.1636}, // DNH
    Coordinate{36.3289, 15.3875}, // DNI
    Coordinate{35.1006, 48.3572}, // DNK
    Coordinate{-82.0394, 33.4664}, // DNL
    Coordinate{-84.8703, 34.7231}, // DNN
    Coordinate{82.2942, 28.1108}, // DNP
    Coordinate{144.946, -35.56}, // DNQ
    Coordinate{-2.08, 48.5878}, // DNR
    Coordinate{-95.3806, 41.9867}, // DNS
    Coordinate{-87.5956, 40.1992}, // DNV
    Coordinate{35.067, 12.533}, // DNX
    Coordinate{134.212, -5.77167}, // DOB
    Coordinate{35.7494, -6.17036}, // DOD
    Coordinate{-55.4816, 4.00571}, // DOE
    Coordinate{30.43, 19.1536}, // DOG
    Coordinate{51.6081, 25.2731}, // DOH
    Coordinate{37.7256, 48.075}, // DOK
    Coordinate{0.154167, 49.3633}, // DOL
    Coordinate{-61.3, 15.5469}, // DOM
    Coordinate{-89.6884, 17.6124}, // DON
    Coordinate{82.8192, 28.9858}, // DOP
    Coordinate{-0.066667, 14.0333}, // DOR
    Coordinate{-54.9256, -22.2006}, // DOU
    Coordinate{118.784, 37.5103}, // DOY
    Coordinate{-88.2483, 41.9069}, // DPA
    Coordinate{1.08528, 49.8825}, // DPE
    Coordinate{123.334, 8.60139}, // DPL
    Coordinate{146.43, -41.1697}, // DPO
    Coordinate{115.168, -8.74806}, // DPS
    Coordinate{139.899, 69.3917}, // DPT
    Coordinate{125.228, 46.5872}, // DQA
    Coordinate{-150.945, 70.3442}, // DQH
    Coordinate{-116.033, 36.6194}, // DRA
    Coordinate{123.661, -17.37}, // DRB
    Coordinate{20.7663, -17.9815}, // DRC
    Coordinate{-83.7439, 46.0094}, // DRE
    Coordinate{-162.766, 66.0694}, // DRG
    Coordinate{138.317, -2.8}, // DRH
    Coordinate{-93.34, 30.8317}, // DRI
    Coordinate{-54.6667, 4.11667}, // DRJ
    Coordinate{-83.65, 8.73333}, // DRK
    Coordinate{148.217, -28.5917}, // DRN
    Coordinate{-107.754, 37.1514}, // DRO
    Coordinate{13.7681, 51.1344}, // DRS
    Coordinate{-100.927, 29.3742}, // DRT
    Coordinate{73.1306, 5.15667}, // DRV
    Coordinate{-1.00417, 53.4753}, // DSA
    Coordinate{10.0641, 5.44809}, // DSC
    Coordinate{-61.0844, 16.2969}, // DSD
    Coordinate{39.7114, 11.0825}, // DSE
    Coordinate{-86.4714, 30.4}, // DSI
    Coordinate{70.8964, 31.9092}, // DSK
    Coordinate{-93.6631, 41.5339}, // DSM
    Coordinate{109.862, 39.4939}, // DSN
    Coordinate{127.475, 39.7473}, // DSO
    Coordinate{122.455, -29.0983}, // DSR
    Coordinate{-17.0689, 14.6708}, // DSS
    Coordinate{-77.7131, 42.5708}, // DSV
    Coordinate{116.717, 20.7}, // DSX
    Coordinate{-112.508, 39.3806}, // DTA
    Coordinate{98.9953, 2.25972}, // DTB
    Coordinate{116.48, 0.72}, // DTD
    Coordinate{122.979, 14.1262}, // DTE
    Coordinate{-116.881, 36.4639}, // DTH
    Coordinate{-43.6511, -18.2333}, // DTI
    Coordinate{-95.8847, 46.8253}, // DTL
    Coordinate{7.61222, 51.5183}, // DTM
    Coordinate{-93.745, 32.5403}, // DTN
    Coordinate{-97.1981, 33.2008}, // DTO
    Coordinate{-83.3533, 42.2125}, // DTW
    Coordinate{-96.3944, 33.9422}, // DUA
    Coordinate{-6.27, 53.4214}, // DUB
    Coordinate{-97.96, 34.4708}, // DUC
    Coordinate{170.198, -45.9281}, // DUD
    Coordinate{20.8185, -7.40064}, // DUE
    Coordinate{-75.7886, 36.2533}, // DUF
    Coordinate{-109.604, 31.4689}, // DUG
    Coordinate{-83.6558, 41.7358}, // DUH
    Coordinate{-78.8986, 41.1783}, // DUJ
    Coordinate{101.434, 1.60919}, // DUM
    Coordinate{-123.717, 48.7583}, // DUQ
    Coordinate{31.1164, -29.6144}, // DUR
    Coordinate{6.76667, 51.2894}, // DUS
    Coordinate{-166.545, 53.8989}, // DUT
    Coordinate{43.2706, -22.1111}, // DVD
    Coordinate{-110.29, 64.5114}, // DVK
    Coordinate{-98.9083, 48.1144}, // DVL
    Coordinate{-90.5883, 41.6103}, // DVN
    Coordinate{125.646, 7.12552}, // DVO
    Coordinate{-112.082, 33.6883}, // DVT
    Coordinate{34.1311, -12.5183}, // DWA
    Coordinate{45.3667, -16.1}, // DWB
    Coordinate{55.1722, 24.8861}, // DWC
    Coordinate{44.1211, 24.4497}, // DWD
    Coordinate{-95.5528, 30.0619}, // DWH
    Coordinate{-81.5715, 28.4}, // DWS
    Coordinate{-82.7381, 38.5544}, // DWU
    Coordinate{55.3644, 25.2528}, // DXB
    Coordinate{-90.1031, 32.4386}, // DXE
    Coordinate{-73.4822, 41.3717}, // DXR
    Coordinate{148.364, -22.6222}, // DYA
    Coordinate{110.443, 29.1031}, // DYG
    Coordinate{-75.1219, 40.3331}, // DYL
    Coordinate{177.742, 64.735}, // DYR
    Coordinate{-92.0433, 46.7219}, // DYT
    Coordinate{68.8217, 38.5436}, // DYU
    Coordinate{45.2806, -12.8067}, // DZA
    Coordinate{-83.9972, 34.8544}, // DZJ
    Coordinate{67.7333, 47.7083}, // DZN
    Coordinate{-56.4992, -33.3586}, // DZO
    Coordinate{-141.15, 64.7781}, // EAA
    Coordinate{43.1778, 15.3}, // EAB
    Coordinate{168.342, -17.0892}, // EAE
    Coordinate{167.333, 9.08333}, // EAL
    Coordinate{44.4192, 17.6114}, // EAM
    Coordinate{7.52917, 47.59}, // EAP
    Coordinate{-99.0067, 40.7269}, // EAR
    Coordinate{-1.79056, 43.3564}, // EAS
    Coordinate{-120.206, 47.3981}, // EAT
    Coordinate{-91.4842, 44.8658}, // EAU
    Coordinate{10.2394, 42.7603}, // EBA
    Coordinate{32.4431, 0.0447222}, // EBB
    Coordinate{30.2325, 13.1531}, // EBD
    Coordinate{-74.8133, 7.59639}, // EBG
    Coordinate{8.55333, 55.5258}, // EBJ
    Coordinate{43.9631, 36.2375}, // EBL
    Coordinate{168.753, 4.59889}, // EBO
    Coordinate{-93.8692, 42.4364}, // EBS
    Coordinate{4.29639, 45.5406}, // EBU
    Coordinate{11.1833, 2.85}, // EBW
    Coordinate{-76.1744, 36.2606}, // ECG
    Coordinate{144.762, -36.1572}, // ECH
    Coordinate{-85.9333, 11.4333}, // ECI
    Coordinate{33.4884, 35.1596}, // ECN
    Coordinate{-85.7956, 30.3583}, // ECP
    Coordinate{-78.0944, 2.45}, // ECR
    Coordinate{-3.785, 40.3706}, // ECV
    Coordinate{30.9583, 18.025}, // EDB
    Coordinate{-97.5733, 30.3967}, // EDC
    Coordinate{-76.5672, 36.0278}, // EDE
    Coordinate{-3.3725, 55.95}, // EDI
    Coordinate{-83.8189, 40.3722}, // EDJ
    Coordinate{-96.8175, 37.7742}, // EDK
    Coordinate{35.2389, 0.404444}, // EDL
    Coordinate{-1.38167, 46.7025}, // EDM
    Coordinate{27.0138, 39.5546}, // EDO
    Coordinate{-88.4375, 14.2361}, // EDQ
    Coordinate{141.609, -14.8967}, // EDR
    Coordinate{-121.786, 38.5314}, // EDU
    Coordinate{-114.623, 34.7664}, // EED
    Coordinate{-162.044, 60.2136}, // EEK
    Coordinate{-72.2708, 42.8983}, // EEN
    Coordinate{-86.7831, 33.1778}, // EET
    Coordinate{-95.1589, 29.6072}, // EFD
    Coordinate{147.66, -9.15567}, // EFG
    Coordinate{-72.2292, 44.8889}, // EFK
    Coordinate{20.5003, 38.12}, // EFL
    Coordinate{0.520555, 44.8244}, // EGC
    Coordinate{-106.918, 39.6425}, // EGE
    Coordinate{34.1292, 31.0689}, // EGH
    Coordinate{-86.5254, 30.6492}, // EGI
    Coordinate{39.75, 5.28333}, // EGL
    Coordinate{157.875, -8.578}, // EGM
    Coordinate{22.4672, 13.4817}, // EGN
    Coordinate{36.59, 50.6433}, // EGO
    Coordinate{-100.513, 28.8572}, // EGP
    Coordinate{-14.4014, 65.2833}, // EGS
    Coordinate{-97.3883, 37.3236}, // EGT
    Coordinate{-89.2683, 45.9322}, // EGV
    Coordinate{-157.376, 58.1856}, // EGX
    Coordinate{-101.88, 37.0008}, // EHA
    Coordinate{-71.5322, -41.9433}, // EHL
    Coordinate{-162.063, 58.6464}, // EHM
    Coordinate{-81.6008, 35.2558}, // EHO
    Coordinate{-87.6856, 37.8078}, // EHR
    Coordinate{10.4727, 50.9922}, // EIB
    Coordinate{92.1133, 58.4733}, // EIE
    Coordinate{38.2145, 46.6835}, // EIK
    Coordinate{5.37417, 51.4506}, // EIN
    Coordinate{-64.5431, 18.4456}, // EIS
    Coordinate{35.2032, 30.6215}, // EIY
    Coordinate{-73.8067, 7.02444}, // EJA
    Coordinate{36.4764, 26.1986}, // EJH
    Coordinate{101.001, 42.0156}, // EJN
    Coordinate{171.984, 6.04028}, // EJT
    Coordinate{-124.113, 40.8033}, // EKA
    Coordinate{75.2167, 51.5833}, // EKB
    Coordinate{-86.0033, 41.7194}, // EKI
    Coordinate{-115.792, 40.825}, // EKO
    Coordinate{-84.8561, 36.8553}, // EKQ
    Coordinate{-111.649, 45.2744}, // EKS
    Coordinate{16.7083, 59.35}, // EKT
    Coordinate{-85.925, 37.6861}, // EKX
    Coordinate{-86.9264, 33.3125}, // EKY
    Coordinate{-73.975, 9.04583}, // ELB
    Coordinate{135.571, -12.0193}, // ELC
    Coordinate{-92.8133, 33.2211}, // ELD
    Coordinate{-77.7264, 8.10694}, // ELE
    Coordinate{25.3244, 13.6147}, // ELF
    Coordinate{2.86422, 30.5774}, // ELG
    Coordinate{-76.6836, 25.475}, // ELH
    Coordinate{-162.271, 64.615}, // ELI
    Coordinate{-99.3943, 35.4308}, // ELK
    Coordinate{-76.8917, 42.16}, // ELM
    Coordinate{-120.531, 47.0331}, // ELN
    Coordinate{-54.5747, -26.4}, // ELO
    Coordinate{-106.378, 31.8072}, // ELP
    Coordinate{43.7742, 26.3028}, // ELQ
    Coordinate{27.8214, -33.035}, // ELS
    Coordinate{33.6456, 28.2092}, // ELT
    Coordinate{6.78258, 33.5129}, // ELU
    Coordinate{-136.348, 58.1953}, // ELV
    Coordinate{-64.2106, 8.83278}, // ELX
    Coordinate{-114.842, 39.2997}, // ELY
    Coordinate{-77.99, 42.1094}, // ELZ
    Coordinate{-1.32806, 52.8311}, // EMA
    Coordinate{148.179, -23.5675}, // EMD
    Coordinate{7.2275, 53.3911}, // EME
    Coordinate{149.975, -1.64167}, // EMI
    Coordinate{-164.491, 62.7861}, // EMK
    Coordinate{-110.557, 41.8242}, // EMM
    Coordinate{-7.31639, 16.6219}, // EMN
    Coordinate{-96.1911, 38.3322}, // EMP
    Coordinate{-118.035, 34.0861}, // EMT
    Coordinate{-71.1707, -42.35}, // EMX
    Coordinate{-151.245, 60.5733}, // ENA
    Coordinate{6.22611, 48.6922}, // ENC
    Coordinate{121.661, -8.84917}, // ENE
    Coordinate{23.4275, 68.3644}, // ENF
    Coordinate{109.485, 30.3203}, // ENH
    Coordinate{119.416, 11.2025}, // ENI
    Coordinate{-90.1514, 17.3528}, // ENJ
    Coordinate{-7.65194, 54.3986}, // ENK
    Coordinate{-89.092, 38.5148}, // ENL
    Coordinate{-149.074, 64.5472}, // ENN
    Coordinate{-55.9167, -27.3}, // ENO
    Coordinate{6.88667, 52.2742}, // ENS
    Coordinate{162.328, 11.34}, // ENT
    Coordinate{7.56194, 6.47417}, // ENU
    Coordinate{-114.031, 40.7186}, // ENV
    Coordinate{-87.9278, 42.5956}, // ENW
    Coordinate{109.553, 36.6367}, // ENY
    Coordinate{-81.6406, 34.3094}, // EOE
    Coordinate{-75.5903, 6.21972}, // EOH
    Coordinate{-2.77222, 59.1906}, // EOI
    Coordinate{-91.4286, 40.46}, // EOK
    Coordinate{-82.9281, 39.1669}, // EOP
    Coordinate{-61.6389, 6.71583}, // EOR
    Coordinate{-94.3917, 36.8108}, // EOS
    Coordinate{-69.4967, 7.05972}, // EOZ
    Coordinate{-58.6125, -34.61}, // EPA
    Coordinate{-119.517, 47.3081}, // EPH
    Coordinate{6.06667, 48.3247}, // EPL
    Coordinate{-67.0128, 44.91}, // EPM
    Coordinate{121.823, -33.6844}, // EPR
    Coordinate{-69.4333, 19.1986}, // EPS
    Coordinate{24.4728, 58.4192}, // EPU
    Coordinate{-71.1467, -42.9067}, // EQS
    Coordinate{-80.6203, 35.0189}, // EQY
    Coordinate{47.3833, 10.6347}, // ERA
    Coordinate{39.5206, 39.71}, // ERC
    Coordinate{36.7581, 46.8147}, // ERD
    Coordinate{10.9581, 50.9797}, // ERF
    Coordinate{108.03, 61.275}, // ERG
    Coordinate{-4.40066, 31.9475}, // ERH
    Coordinate{-80.1808, 42.085}, // ERI
    Coordinate{112.098, 43.4267}, // ERL
    Coordinate{-52.2761, -27.66}, // ERM
    Coordinate{-69.9172, -6.66694}, // ERN
    Coordinate{141.007, -20.9767}, // ERQ
    Coordinate{-71.1643, 44.7927}, // ERR
    Coordinate{17.0806, -22.6122}, // ERS
    Coordinate{-99.0856, 29.9767}, // ERV
    Coordinate{-85.4572, 46.311}, // ERY
    Coordinate{41.1692, 39.9553}, // ERZ
    Coordinate{32.995, 40.1281}, // ESB
    Coordinate{-87.0936, 45.7228}, // ESC
    Coordinate{-122.911, 48.7081}, // ESD
    Coordinate{-116.604, 31.7952}, // ESE
    Coordinate{-60.6217, -22.045}, // ESG
    Coordinate{-0.297222, 50.8356}, // ESH
    Coordinate{30.5819, 39.7822}, // ESK
    Coordinate{44.3308, 46.3739}, // ESL
    Coordinate{-79.6267, 0.978611}, // ESM
    Coordinate{-76.0689, 38.8042}, // ESN
    Coordinate{-106.045, 36.0261}, // ESO
    Coordinate{-75.1606, 41.0358}, // ESP
    Coordinate{-69.7658, -26.3133}, // ESR
    Coordinate{6.93722, 51.4022}, // ESS
    Coordinate{-9.68167, 31.3975}, // ESU
    Coordinate{-121.186, 47.2542}, // ESW
    Coordinate{-88.1278, 43.4222}, // ETB
    Coordinate{34.9592, 29.5594}, // ETH
    Coordinate{-79.9778, -3.43528}, // ETR
    Coordinate{-85.8997, 31.2997}, // ETS
    Coordinate{6.24667, 48.9783}, // ETZ
    Coordinate{-174.95, -21.3833}, // EUA
    Coordinate{128.877, -31.7067}, // EUC
    Coordinate{-116.005, 39.6042}, // EUE
    Coordinate{-85.1289, 31.9514}, // EUF
    Coordinate{-123.219, 44.1231}, // EUG
    Coordinate{-116.636, 43.6419}, // EUL
    Coordinate{-13.2192, 27.1517}, // EUN
    Coordinate{121.932, 10.7658}, // EUQ
    Coordinate{-62.9794, 17.4964}, // EUX
    Coordinate{-80.9489, 29.0556}, // EVB
    Coordinate{16.6781, 68.4913}, // EVE
    Coordinate{14.4228, 62.0478}, // EVG
    Coordinate{153.42, -29.0933}, // EVH
    Coordinate{44.3958, 40.1472}, // EVN
    Coordinate{-94.9167, 40.3533}, // EVU
    Coordinate{-87.5308, 38.0383}, // EVV
    Coordinate{-75.7206, 39.5203}, // EVY
    Coordinate{-70.9569, 41.6761}, // EWB
    Coordinate{138.067, -5.48333}, // EWE
    Coordinate{136.378, -3.92583}, // EWI
    Coordinate{-97.2744, 38.0583}, // EWK
    Coordinate{-77.0431, 35.0731}, // EWN
    Coordinate{14.8, -0.883333}, // EWO
    Coordinate{-74.1686, 40.6925}, // EWR
    Coordinate{-135.449, 58.4206}, // EXI
    Coordinate{-3.41389, 50.7344}, // EXT
    Coordinate{-80.3039, 35.7811}, // EXX
    Coordinate{-78.5792, 34.6017}, // EYF
    Coordinate{66.6831, 63.6831}, // EYK
    Coordinate{-10.567, 15.133}, // EYL
    Coordinate{-72.3862, 5.31962}, // EYP
    Coordinate{-95.6397, 29.9353}, // EYQ
    Coordinate{-119.158, 39.0042}, // EYR
    Coordinate{35.9744, 3.23639}, // EYS
    Coordinate{-81.7594, 24.5561}, // EYW
    Coordinate{-58.5358, -34.8222}, // EZE
    Coordinate{39.2914, 38.605}, // EZS
    Coordinate{-0.5325, 51.115}, // FAA
    Coordinate{-0.7775, 51.2753}, // FAB
    Coordinate{-145.333, -16.6869}, // FAC
    Coordinate{-7.27722, 62.0636}, // FAE
    Coordinate{-16.6417, 63.875}, // FAG
    Coordinate{62.1655, 32.3662}, // FAH
    Coordinate{-147.856, 64.815}, // FAI
    Coordinate{-65.6619, 18.3081}, // FAJ
    Coordinate{6.625, 58.1003}, // FAN
    Coordinate{-7.96583, 37.0144}, // FAO
    Coordinate{141.96, -4.609}, // FAQ
    Coordinate{-96.8158, 46.9206}, // FAR
    Coordinate{-14.05, 64.9319}, // FAS
    Coordinate{-119.719, 36.7709}, // FAT
    Coordinate{56.4825, 22.3483}, // FAU
    Coordinate{-145.657, -16.0542}, // FAV
    Coordinate{-78.8803, 34.9911}, // FAY
    Coordinate{53.7233, 28.8917}, // FAZ
    Coordinate{-66.0672, -2.53361}, // FBA
    Coordinate{70.5183, 37.1194}, // FBD
    Coordinate{-53.0639, -26.0594}, // FBE
    Coordinate{27.531, -11.5913}, // FBM
    Coordinate{-123.01, 48.5372}, // FBS
    Coordinate{-114.256, 48.3106}, // FCA
    Coordinate{27.9089, -28.8231}, // FCB
    Coordinate{-119.82, 36.7322}, // FCH
    Coordinate{-77.525, 37.4067}, // FCI
    Coordinate{-93.4572, 44.8272}, // FCM
    Coordinate{8.66417, 53.7683}, // FCN
    Coordinate{12.2389, 41.8003}, // FCO
    Coordinate{-90.775, 34.9419}, // FCY
    Coordinate{5.83389, 61.4578}, // FDE
    Coordinate{-60.9964, 14.5922}, // FDF
    Coordinate{9.51139, 47.6714}, // FDH
    Coordinate{-77.3744, 39.4175}, // FDK
    Coordinate{-58.5913, -34.4549}, // FDO
    Coordinate{-98.9839, 34.3522}, // FDR
    Coordinate{17.3817, -3.31139}, // FDU
    Coordinate{-81.1089, 34.3156}, // FDW
    Coordinate{-83.6686, 41.0119}, // FDY
    Coordinate{81.2167, 29.2333}, // FEB
    Coordinate{-38.9067, -12.2031}, // FEC
    Coordinate{71.745, 40.3589}, // FEG
    Coordinate{-70.3472, -8.14083}, // FEJ
    Coordinate{-5.2, 9.6}, // FEK
    Coordinate{-32.4283, -3.85472}, // FEN
    Coordinate{-89.5819, 42.2461}, // FEP
    Coordinate{-96.5203, 41.4492}, // FET
    Coordinate{-4.97778, 33.9272}, // FEZ
    Coordinate{-75.6714, 36.0183}, // FFA
    Coordinate{-84.5719, 33.3572}, // FFC
    Coordinate{-91.9808, 41.0558}, // FFL
    Coordinate{-96.1567, 46.2844}, // FFM
    Coordinate{-84.9061, 38.1819}, // FFT
    Coordinate{-71.8512, -43.1888}, // FFU
    Coordinate{-85.995, 43.4394}, // FFX
    Coordinate{-12.733, 22.667}, // FGD
    Coordinate{-171.742, -13.8492}, // FGI
    Coordinate{170.02, -43.4621}, // FGL
    Coordinate{-140.887, -15.8197}, // FGU
    Coordinate{-83.7433, 38.5417}, // FGX
    Coordinate{-81.4611, 30.6119}, // FHB
    Coordinate{-110.344, 31.5883}, // FHU
    Coordinate{-72.0317, 41.2514}, // FID
    Coordinate{-1.61722, 59.5353}, // FIE
    Coordinate{-13.5692, 10.3506}, // FIG
    Coordinate{15.4446, -4.38575}, // FIH
    Coordinate{-112.363, 38.9581}, // FIL
    Coordinate{147.854, -6.62229}, // FIN
    Coordinate{-71.7589, 42.5542}, // FIT
    Coordinate{125.559, -18.182}, // FIZ
    Coordinate{56.3239, 25.1097}, // FJR
    Coordinate{-92.1794, 43.6761}, // FKA
    Coordinate{8.08056, 48.7794}, // FKB
    Coordinate{25.3381, 0.481667}, // FKI
    Coordinate{136.224, 36.1428}, // FKJ
    Coordinate{-79.8603, 41.3778}, // FKL
    Coordinate{-76.9039, 36.6981}, // FKN
    Coordinate{132.267, -2.92}, // FKQ
    Coordinate{140.428, 37.2275}, // FKS
    Coordinate{-75.5644, 1.58917}, // FLA
    Coordinate{-43.0781, -6.84611}, // FLB
    Coordinate{-88.4883, 43.7711}, // FLD
    Coordinate{9.37667, 54.7733}, // FLF
    Coordinate{-111.669, 35.1403}, // FLG
    Coordinate{-80.1528, 26.0725}, // FLL
    Coordinate{-60.054, -22.36}, // FLM
    Coordinate{-48.5525, -27.6703}, // FLN
    Coordinate{-79.7239, 34.1853}, // FLO
    Coordinate{-92.5903, 36.2908}, // FLP
    Coordinate{11.2029, 43.8088}, // FLR
    Coordinate{147.993, -40.0914}, // FLS
    Coordinate{-71.9003, 19.6775}, // FLT
    Coordinate{-73.8333, 40.7792}, // FLU
    Coordinate{-31.1322, 39.4581}, // FLW
    Coordinate{-118.749, 39.4992}, // FLX
    Coordinate{-104.57, 38.9458}, // FLY
    Coordinate{-58.2281, -26.2128}, // FMA
    Coordinate{-149.84, 65.9269}, // FMC
    Coordinate{-76.7594, 39.0853}, // FME
    Coordinate{29.25, -5.87556}, // FMI
    Coordinate{10.2394, 47.9889}, // FMM
    Coordinate{-108.23, 36.7411}, // FMN
    Coordinate{7.68483, 52.1346}, // FMO
    Coordinate{-124.111, 43.9828}, // FMU
    Coordinate{-81.8633, 26.5867}, // FMY
    Coordinate{-97.5731, 40.5861}, // FMZ
    Coordinate{-13.1955, 8.61644}, // FNA
    Coordinate{13.306, 53.6022}, // FNB
    Coordinate{-16.7781, 32.6942}, // FNC
    Coordinate{147.085, -8.55117}, // FNE
    Coordinate{0.35, 12.033}, // FNG
    Coordinate{37.3764, 9.58333}, // FNH
    Coordinate{4.41639, 43.7575}, // FNI
    Coordinate{125.67, 39.2239}, // FNJ
    Coordinate{-105.011, 40.4519}, // FNL
    Coordinate{-134.898, 58.2544}, // FNR
    Coordinate{-83.7436, 42.9656}, // FNT
    Coordinate{8.64083, 39.8936}, // FNU
    Coordinate{-2.05333, 60.1217}, // FOA
    Coordinate{119.663, 25.935}, // FOC
    Coordinate{-94.1919, 42.5511}, // FOD
    Coordinate{-95.6636, 38.9508}, // FOE
    Coordinate{15.5351, 41.4329}, // FOG
    Coordinate{-72.6317, 40.8436}, // FOK
    Coordinate{10.7508, 5.63694}, // FOM
    Coordinate{-84.5778, 10.47}, // FON
    Coordinate{134.872, -0.936389}, // FOO
    Coordinate{-38.5322, -3.77583}, // FOR
    Coordinate{128.115, -30.8383}, // FOS
    Coordinate{}, // FOT
    Coordinate{10.617, -1.283}, // FOU
    Coordinate{-10.2264, 8.35222}, // FOY
    Coordinate{-84.8114, 42.5744}, // FPK
    Coordinate{-78.6956, 26.5586}, // FPO
    Coordinate{-80.3683, 27.495}, // FPR
    Coordinate{-83.5783, 30.0722}, // FPY
    Coordinate{8.57056, 50.0333}, // FRA
    Coordinate{147.935, -33.3636}, // FRB
    Coordinate{-47.3825, -20.5903}, // FRC
    Coordinate{-123.024, 48.5219}, // FRD
    Coordinate{159.577, -8.10746}, // FRE
    Coordinate{-73.4133, 40.7289}, // FRG
    Coordinate{-86.6369, 38.5061}, // FRH
    Coordinate{6.73556, 43.4172}, // FRJ
    Coordinate{55.9408, -4.58389}, // FRK
    Coordinate{12.0696, 44.1954}, // FRL
    Coordinate{-94.4156, 43.6439}, // FRM
    Coordinate{5.02472, 61.5836}, // FRO
    Coordinate{-78.2533, 38.9175}, // FRR
    Coordinate{-89.8663, 16.9138}, // FRS
    Coordinate{-73.0646, -41.1308}, // FRT
    Coordinate{74.4775, 43.0613}, // FRU
    Coordinate{27.4744, -21.1594}, // FRW
    Coordinate{-70.9478, 43.9911}, // FRY
    Coordinate{9.09667, 41.5022}, // FSC
    Coordinate{-96.7419, 43.5819}, // FSD
    Coordinate{-94.7694, 37.7983}, // FSK
    Coordinate{-94.3675, 35.3367}, // FSM
    Coordinate{-73.0975, 44.9403}, // FSO
    Coordinate{-56.1742, 46.7631}, // FSP
    Coordinate{-102.913, 30.9153}, // FST
    Coordinate{-104.216, 34.4878}, // FSU
    Coordinate{138.189, 34.7961}, // FSZ
    Coordinate{170.232, -19.5164}, // FTA
    Coordinate{-72.0532, -50.2803}, // FTE
    Coordinate{-104.543, 39.7853}, // FTG
    Coordinate{-169.424, -14.2161}, // FTI
    Coordinate{46.9558, -25.0381}, // FTU
    Coordinate{-97.3624, 32.8198}, // FTW
    Coordinate{15.95, -0.531389}, // FTX
    Coordinate{-84.5214, 33.7792}, // FTY
    Coordinate{-13.8639, 28.4528}, // FUE
    Coordinate{115.734, 32.8819}, // FUG
    Coordinate{128.833, 32.6664}, // FUJ
    Coordinate{130.452, 33.5844}, // FUK
    Coordinate{-117.98, 33.872}, // FUL
    Coordinate{179.196, -8.525}, // FUN
    Coordinate{113.071, 23.0825}, // FUO
    Coordinate{-178.066, -14.3114}, // FUT
    Coordinate{73.4325, -0.309444}, // FVM
    Coordinate{-85.1953, 40.9783}, // FWA
    Coordinate{-93.4022, 36.6986}, // FWB
    Coordinate{-88.4128, 38.3786}, // FWC
    Coordinate{-74.6231, 41.2003}, // FWN
    Coordinate{-79.8314, 40.2097}, // FWQ
    Coordinate{-97.3081, 32.5653}, // FWS
    Coordinate{-80.1708, 26.1972}, // FXE
    Coordinate{36.5283, -14.8175}, // FXO
    Coordinate{-93.6242, 43.2347}, // FXY
    Coordinate{-89.3944, 35.2078}, // FYE
    Coordinate{134.366, 48.1995}, // FYJ
    Coordinate{-86.5639, 35.0597}, // FYM
    Coordinate{89.5079, 46.8011}, // FYN
    Coordinate{19.1108, 17.9143}, // FYT
    Coordinate{-145.246, 66.5725}, // FYU
    Coordinate{-94.17, 36.005}, // FYV
    Coordinate{-83.3944, 41.1908}, // FZI
    Coordinate{-2.59361, 51.5194}, // FZO
    Coordinate{21.3333, -5.35}, // FZU
    Coordinate{-76.3881, 43.3508}, // FZY
    Coordinate{-74.0651, 4.81139}, // GAA
    Coordinate{-117.959, 38.9242}, // GAB
    Coordinate{-88.5958, 14.5736}, // GAC
    Coordinate{-86.0892, 33.9728}, // GAD
    Coordinate{9.92005, 33.7343}, // GAE
    Coordinate{8.81361, 34.4156}, // GAF
    Coordinate{-99.7764, 36.2956}, // GAG
    Coordinate{151.62, -25.6153}, // GAH
    Coordinate{-77.166, 39.1683}, // GAI
    Coordinate{140.371, 38.4119}, // GAJ
    Coordinate{-156.938, 64.7361}, // GAL
    Coordinate{-171.733, 63.7667}, // GAM
    Coordinate{73.1556, -0.693333}, // GAN
    Coordinate{-75.1583, 20.0853}, // GAO
    Coordinate{145.96, -6.05359}, // GAP
    Coordinate{-0.00583333, 16.2483}, // GAQ
    Coordinate{39.6483, -0.463428}, // GAS
    Coordinate{6.03667, 44.4539}, // GAT
    Coordinate{91.5855, 26.1049}, // GAU
    Coordinate{138.719, -34.6}, // GAW
    Coordinate{9.99583, -2.76583}, // GAX
    Coordinate{84.9511, 24.7444}, // GAY
    Coordinate{152.95, -9.23333}, // GAZ
    Coordinate{-2.05694, 51.6681}, // GBA
    Coordinate{47.7125, 40.8267}, // GBB
    Coordinate{-98.8592, 38.3442}, // GBD
    Coordinate{25.9183, -24.5553}, // GBE
    Coordinate{-90.4311, 40.9381}, // GBG
    Coordinate{-149.49, 68.4797}, // GBH
    Coordinate{-78.3667, 26.6318}, // GBI
    Coordinate{-61.2722, 15.8686}, // GBJ
    Coordinate{-12.3833, 7.76667}, // GBK
    Coordinate{133.382, -11.65}, // GBL
    Coordinate{42.2131, 3.32278}, // GBM
    Coordinate{-73.4032, 42.1842}, // GBR
    Coordinate{54.4053, 36.9067}, // GBT
    Coordinate{35.878, 14.925}, // GBU
    Coordinate{126.445, -16.4233}, // GBV
    Coordinate{175.472, -36.2414}, // GBZ
    Coordinate{-105.539, 44.3489}, // GCC
    Coordinate{50.8281, 30.3375}, // GCH
    Coordinate{-2.60194, 49.435}, // GCI
    Coordinate{28.14, -25.9871}, // GCJ
    Coordinate{-100.724, 37.9275}, // GCK
    Coordinate{-81.3592, 19.2925}, // GCM
    Coordinate{-112.147, 35.9522}, // GCN
    Coordinate{-113.231, 36.258}, // GCT
    Coordinate{-113.816, 35.9903}, // GCW
    Coordinate{-82.815, 36.1931}, // GCY
    Coordinate{21.1972, 9.27222}, // GDA
    Coordinate{-95.5561, 44.7533}, // GDB
    Coordinate{-82.3764, 34.7583}, // GDC
    Coordinate{43.5786, 5.93513}, // GDE
    Coordinate{125.8, 53.4667}, // GDG
    Coordinate{21.7333, 9.58333}, // GDI
    Coordinate{23.95, -6.73333}, // GDJ
    Coordinate{-103.311, 20.5218}, // GDL
    Coordinate{-72.0161, 42.55}, // GDM
    Coordinate{18.4661, 54.3775}, // GDN
    Coordinate{-70.7564, 7.21111}, // GDO
    Coordinate{-43.5822, -6.78222}, // GDP
    Coordinate{37.4318, 12.5197}, // GDQ
    Coordinate{-71.1422, 21.4444}, // GDT
    Coordinate{-104.807, 47.1386}, // GDV
    Coordinate{-84.475, 43.9706}, // GDW
    Coordinate{150.721, 59.9111}, // GDX
    Coordinate{-82.125, 37.2325}, // GDY
    Coordinate{38.0094, 44.5725}, // GDZ
    Coordinate{166.473, -22.2583}, // GEA
    Coordinate{-75.3589, 38.6892}, // GED
    Coordinate{146.84, -41.08}, // GEE
    Coordinate{-54.1689, -28.2822}, // GEL
    Coordinate{-58.2539, 6.49833}, // GEO
    Coordinate{-82.7839, 21.8347}, // GER
    Coordinate{125.096, 6.058}, // GES
    Coordinate{114.707, -28.7961}, // GET
    Coordinate{-112.295, 33.5269}, // GEU
    Coordinate{20.8122, 67.1331}, // GEV
    Coordinate{144.333, -38.2253}, // GEX
    Coordinate{-85.8047, 39.5831}, // GEZ
    Coordinate{-85.7361, 39.7903}, // GFD
    Coordinate{146.067, -34.2517}, // GFF
    Coordinate{-97.1761, 47.9492}, // GFK
    Coordinate{-73.6103, 43.3411}, // GFL
    Coordinate{153.03, -29.76}, // GFN
    Coordinate{-58.5892, 6.4225}, // GFO
    Coordinate{-1.56422, 48.8815}, // GFR
    Coordinate{18.1228, -19.6022}, // GFY
    Coordinate{21.4503, -14.1051}, // GGC
    Coordinate{-79.3203, 33.3114}, // GGE
    Coordinate{-101.734, 40.8706}, // GGF
    Coordinate{-94.7114, 32.3839}, // GGG
    Coordinate{34.5514, 0.263945}, // GGM
    Coordinate{-5.98694, 6.10333}, // GGN
    Coordinate{-7.47861, 6.52499}, // GGO
    Coordinate{48.4833, 8.4}, // GGR
    Coordinate{-70.1492, -48.7828}, // GGS
    Coordinate{-75.878, 23.5626}, // GGT
    Coordinate{-106.615, 48.2125}, // GGW
    Coordinate{3.79467, 32.3843}, // GHA
    Coordinate{-76.3311, 25.2847}, // GHB
    Coordinate{-77.85, 25.7383}, // GHC
    Coordinate{-78.3669, 8.065}, // GHE
    Coordinate{-70.6722, 42.0983}, // GHG
    Coordinate{34.2944, 31.3675}, // GHK
    Coordinate{-87.4453, 35.8375}, // GHM
    Coordinate{104.33, 30.9478}, // GHN
    Coordinate{10.1425, 25.1456}, // GHT
    Coordinate{-58.6131, -33.0103}, // GHU
    Coordinate{-5.34972, 36.1511}, // GIB
    Coordinate{142.217, -9.23333}, // GIC
    Coordinate{29.3183, -3.43333}, // GID
    Coordinate{-81.7533, 28.0628}, // GIF
    Coordinate{-43.2506, -22.81}, // GIG
    Coordinate{-9.167, 11.433}, // GII
    Coordinate{74.3336, 35.9186}, // GIL
    Coordinate{-74.7967, 4.27611}, // GIR
    Coordinate{177.978, -38.6633}, // GIS
    Coordinate{80.7281, 7.95589}, // GIU
    Coordinate{42.5858, 16.9011}, // GIZ
    Coordinate{-85.9067, 16.4453}, // GJA
    Coordinate{5.87361, 36.7951}, // GJL
    Coordinate{-65.2817, -10.7883}, // GJM
    Coordinate{-21.3296, 65.9933}, // GJR
    Coordinate{-108.527, 39.1225}, // GJT
    Coordinate{145.392, -6.08169}, // GKA
    Coordinate{25.8822, 40.2011}, // GKD
    Coordinate{73.4331, 0.730833}, // GKK
    Coordinate{-145.454, 62.155}, // GKN
    Coordinate{-83.5286, 35.8578}, // GKT
    Coordinate{-97.0942, 32.6639}, // GKY
    Coordinate{-4.43306, 55.8719}, // GLA
    Coordinate{-110.667, 33.3531}, // GLB
    Coordinate{-101.699, 39.3706}, // GLD
    Coordinate{-97.1969, 33.6514}, // GLE
    Coordinate{-83.1833, 8.65}, // GLF
    Coordinate{-90.9856, 33.4828}, // GLH
    Coordinate{151.69, -29.675}, // GLI
    Coordinate{47.4333, 6.76667}, // GLK
    Coordinate{9.05056, 60.7908}, // GLL
    Coordinate{-10.0678, 29.0167}, // GLN
    Coordinate{-2.16722, 51.8942}, // GLO
    Coordinate{-84.7033, 45.0131}, // GLR
    Coordinate{-94.8606, 29.2653}, // GLS
    Coordinate{151.223, -23.8697}, // GLT
    Coordinate{90.4653, 26.8686}, // GLU
    Coordinate{-163.007, 64.5506}, // GLV
    Coordinate{-85.9539, 37.0317}, // GLW
    Coordinate{127.786, 1.83722}, // GLX
    Coordinate{19.7667, 3.23528}, // GMA
    Coordinate{34.5631, 8.12861}, // GMB
    Coordinate{-7.22139, 33.6556}, // GMD
    Coordinate{31.0167, 52.5269}, // GME
    Coordinate{150.333, -6.275}, // GMI
    Coordinate{-94.7386, 36.6067}, // GMJ
    Coordinate{30.1919, 50.6036}, // GML
    Coordinate{15.8667, -1.86667}, // GMM
    Coordinate{171.19, -42.4617}, // GMN
    Coordinate{10.9, 10.2989}, // GMO
    Coordinate{126.798, 37.5569}, // GMP
    Coordinate{100.311, 34.4158}, // GMQ
    Coordinate{-134.883, -23.0833}, // GMR
    Coordinate{-82.35, 34.8481}, // GMU
    Coordinate{-17.2146, 28.0296}, // GMZ
    Coordinate{24.0539, 53.6019}, // GNA
    Coordinate{5.33278, 45.3631}, // GNB
    Coordinate{-61.7861, 12.0042}, // GND
    Coordinate{-120.945, 39.9439}, // GNF
    Coordinate{121.466, 22.6736}, // GNI
    Coordinate{5.52565, 51.015}, // GNK
    Coordinate{-42.7511, -14.2081}, // GNM
    Coordinate{40.7167, 7.15}, // GNN
    Coordinate{-67.6206, -39.0008}, // GNR
    Coordinate{97.7044, 1.16611}, // GNS
    Coordinate{-107.902, 35.1672}, // GNT
    Coordinate{-161.577, 59.1175}, // GNU
    Coordinate{-82.2717, 29.69}, // GNV
    Coordinate{38.9, 37.45}, // GNY
    Coordinate{21.6578, -21.7}, // GNZ
    Coordinate{8.83756, 44.4135}, // GOA
    Coordinate{40.045, 7.11889}, // GOB
    Coordinate{18.9747, -22.5072}, // GOG
    Coordinate{-51.6778, 64.1917}, // GOH
    Coordinate{73.8314, 15.3808}, // GOI
    Coordinate{43.7867, 56.23}, // GOJ
    Coordinate{-97.4161, 35.8514}, // GOK
    Coordinate{-124.425, 42.4153}, // GOL
    Coordinate{29.2383, -1.67056}, // GOM
    Coordinate{150.32, -28.5217}, // GOO
    Coordinate{83.45, 26.74}, // GOP
    Coordinate{94.7861, 36.4006}, // GOQ
    Coordinate{35.5525, 8.16167}, // GOR
    Coordinate{12.2911, 57.66}, // GOT
    Coordinate{13.37, 9.33583}, // GOU
    Coordinate{136.818, -12.27}, // GOV
    Coordinate{25.7125, 43.1514}, // GOZ
    Coordinate{21.4167, 38.15}, // GPA
    Coordinate{-51.5244, -25.3881}, // GPB
    Coordinate{139.407, -19.775}, // GPD
    Coordinate{-94.3097, 39.3325}, // GPH
    Coordinate{-77.8983, 2.57}, // GPI
    Coordinate{-83.8, 10.2167}, // GPL
    Coordinate{-97.0469, 32.6989}, // GPM
    Coordinate{130.425, -11.3992}, // GPN
    Coordinate{-63.7581, -35.6961}, // GPO
    Coordinate{-90.2658, -0.453889}, // GPS
    Coordinate{-89.07, 30.4072}, // GPT
    Coordinate{-93.5097, 47.2111}, // GPZ
    Coordinate{-82.7239, 40.7533}, // GQQ
    Coordinate{-88.1297, 44.4847}, // GRB
    Coordinate{-82.1592, 34.2486}, // GRD
    Coordinate{-89.3783, 38.8361}, // GRE
    Coordinate{69.2385, 33.6299}, // GRG
    Coordinate{-98.3097, 40.9675}, // GRI
    Coordinate{22.375, -34.0067}, // GRJ
    Coordinate{-97.8289, 31.0672}, // GRK
    Coordinate{-90.3831, 47.8383}, // GRM
    Coordinate{2.76056, 41.9008}, // GRO
    Coordinate{-49.1322, -11.7436}, // GRP
    Coordinate{6.57806, 53.1206}, // GRQ
    Coordinate{-85.5228, 42.8808}, // GRR
    Coordinate{11.0717, 42.7597}, // GRS
    Coordinate{-46.4731, -23.4356}, // GRU
    Coordinate{45.6997, 43.3883}, // GRV
    Coordinate{-28.0286, 39.0925}, // GRW
    Coordinate{-3.77722, 37.1886}, // GRX
    Coordinate{-18.0186, 66.5467}, // GRY
    Coordinate{15.4392, 46.9931}, // GRZ
    Coordinate{115.719, 4.40944}, // GSA
    Coordinate{11.8706, 57.7756}, // GSE
    Coordinate{-85.7942, 41.5264}, // GSH
    Coordinate{-54.3811, 4.28333}, // GSI
    Coordinate{-90.8358, 13.9361}, // GSJ
    Coordinate{-111.541, 62.5972}, // GSL
    Coordinate{55.8978, 26.7511}, // GSM
    Coordinate{-79.9372, 36.0978}, // GSO
    Coordinate{-82.2189, 34.8956}, // GSP
    Coordinate{28.7164, 22.5806}, // GSQ
    Coordinate{49.0833, 9.51667}, // GSR
    Coordinate{-135.708, 58.4253}, // GST
    Coordinate{35.3169, 14.1365}, // GSU
    Coordinate{-97.0492, 32.8314}, // GSW
    Coordinate{158.203, -8.73917}, // GTA
    Coordinate{111.7, 2.11667}, // GTB
    Coordinate{136.46, -13.975}, // GTE
    Coordinate{-111.371, 47.4828}, // GTF
    Coordinate{-92.6644, 45.7981}, // GTG
    Coordinate{170.133, -43.7668}, // GTN
    Coordinate{122.85, 0.637222}, // GTO
    Coordinate{-123.388, 42.5101}, // GTP
    Coordinate{-88.5914, 33.4483}, // GTR
    Coordinate{130.35, -20.5483}, // GTS
    Coordinate{143.53, -18.305}, // GTT
    Coordinate{-97.6794, 30.6788}, // GTU
    Coordinate{17.5703, 49.3203}, // GTW
    Coordinate{-77.2742, 39.8408}, // GTY
    Coordinate{-90.5275, 14.5833}, // GUA
    Coordinate{-114.024, 28.0258}, // GUB
    Coordinate{-106.933, 38.5339}, // GUC
    Coordinate{-3.6, 16.35}, // GUD
    Coordinate{-87.6717, 30.2897}, // GUF
    Coordinate{150.25, -30.9617}, // GUH
    Coordinate{-62.3125, 10.5739}, // GUI
    Coordinate{-45.2044, -22.7917}, // GUJ
    Coordinate{149.718, -34.81}, // GUL
    Coordinate{144.797, 13.4839}, // GUM
    Coordinate{-86.0619, 15.0253}, // GUO
    Coordinate{-108.789, 35.5111}, // GUP
    Coordinate{-69.7544, 9.02778}, // GUQ
    Coordinate{150.334, -10.3114}, // GUR
    Coordinate{-86.1522, 40.6481}, // GUS
    Coordinate{-23.2222, 64.9917}, // GUU
    Coordinate{51.8294, 47.1222}, // GUW
    Coordinate{-101.508, 36.685}, // GUY
    Coordinate{-40.4922, -20.6506}, // GUZ
    Coordinate{6.10944, 46.2383}, // GVA
    Coordinate{-83.8303, 34.2725}, // GVL
    Coordinate{-78.1697, 43.0317}, // GVQ
    Coordinate{-41.9861, -18.8969}, // GVR
    Coordinate{-96.0653, 33.0678}, // GVT
    Coordinate{}, // GVW
    Coordinate{16.9511, 60.5944}, // GVX
    Coordinate{62.3294, 25.2284}, // GWD
    Coordinate{78.2278, 26.2933}, // GWL
    Coordinate{-90.0692, 33.6464}, // GWO
    Coordinate{8.34056, 54.9133}, // GWT
    Coordinate{-77.965, 35.4606}, // GWW
    Coordinate{-8.94159, 53.3002}, // GWY
    Coordinate{48.7881, 15.9661}, // GXF
    Coordinate{15.2876, -7.75431}, // GXG
    Coordinate{102.645, 34.8106}, // GXH
    Coordinate{-72.1065, -45.5947}, // GXQ
    Coordinate{15.2437, 10.3531}, // GXX
    Coordinate{-104.633, 40.4375}, // GXY
    Coordinate{-65.3458, -10.8217}, // GYA
    Coordinate{-96.98, 30.1692}, // GYB
    Coordinate{50.0467, 40.4675}, // GYD
    Coordinate{-79.8836, -2.1575}, // GYE
    Coordinate{129.563, 62.1083}, // GYG
    Coordinate{29.2583, -1.68}, // GYI
    Coordinate{128.451, -16.6369}, // GYL
    Coordinate{-110.924, 27.9693}, // GYM
    Coordinate{-49.2267, -16.6297}, // GYN
    Coordinate{152.702, -26.2833}, // GYP
    Coordinate{-112.374, 33.4281}, // GYR
    Coordinate{105.693, 32.39}, // GYS
    Coordinate{106.218, 36.0761}, // GYU
    Coordinate{-87.4128, 41.6164}, // GYY
    Coordinate{34.2761, 31.2464}, // GZA
    Coordinate{-87.0442, 31.4158}, // GZH
    Coordinate{68.4123, 33.5308}, // GZI
    Coordinate{-95.0939, 35.2881}, // GZL
    Coordinate{156.864, -8.09861}, // GZO
    Coordinate{32.1814, 36.1756}, // GZP
    Coordinate{-87.0569, 35.1536}, // GZS
    Coordinate{37.4789, 36.9478}, // GZT
    Coordinate{50.0333, 36.2333}, // GZW
    Coordinate{22.1397, 70.4867}, // HAA
    Coordinate{-87.9983, 34.1175}, // HAB
    Coordinate{139.786, 33.115}, // HAC
    Coordinate{12.82, 56.6908}, // HAD
    Coordinate{125.779, 38.0054}, // HAE
    Coordinate{-122.501, 37.5133}, // HAF
    Coordinate{43.2714, -11.5367}, // HAH
    Coordinate{9.685, 52.4608}, // HAJ
    Coordinate{110.459, 19.9347}, // HAK
    Coordinate{16.4583, -19.0314}, // HAL
    Coordinate{9.99111, 53.6303}, // HAM
    Coordinate{105.807, 21.2211}, // HAN
    Coordinate{-84.5219, 39.3638}, // HAO
    Coordinate{73.1685, 6.74417}, // HAQ
    Coordinate{-76.8514, 40.2172}, // HAR
    Coordinate{41.6863, 27.4397}, // HAS
    Coordinate{5.2125, 59.3433}, // HAU
    Coordinate{-82.4089, 22.9889}, // HAV
    Coordinate{-4.96111, 51.8331}, // HAW
    Coordinate{-95.4128, 35.7458}, // HAX
    Coordinate{-161.157, 65.2011}, // HAY
    Coordinate{147.51, -42.8361}, // HBA
    Coordinate{29.6964, 30.9178}, // HBE
    Coordinate{-89.2528, 31.265}, // HBG
    Coordinate{-79.8947, 35.6544}, // HBI
    Coordinate{-110.138, 34.9408}, // HBK
    Coordinate{-99.0514, 34.9914}, // HBR
    Coordinate{91.5819, 46.1017}, // HBU
    Coordinate{75.0847, 15.3617}, // HBX
    Coordinate{-101.522, 32.2125}, // HCA
    Coordinate{-73.7103, 42.2914}, // HCC
    Coordinate{-94.3825, 44.86}, // HCD
    Coordinate{107.7, 24.7839}, // HCJ
    Coordinate{49.8, 7.91667}, // HCM
    Coordinate{120.73, 22.0381}, // HCN
    Coordinate{127.67, -18.2339}, // HCQ
    Coordinate{-159.775, 62.1883}, // HCR
    Coordinate{-79.9569, 34.7128}, // HCW
    Coordinate{35.0006, 32.4369}, // HDA
    Coordinate{-90.4183, 30.5217}, // HDC
    Coordinate{68.3663, 25.3179}, // HDD
    Coordinate{14.1522, 53.8786}, // HDF
    Coordinate{114.43, 36.5239}, // HDG
    Coordinate{-84.8325, 35.22}, // HDI
    Coordinate{48.5525, 34.8692}, // HDM
    Coordinate{-107.218, 40.4811}, // HDN
    Coordinate{-99.1775, 29.3592}, // HDO
    Coordinate{100.393, 6.93306}, // HDY
    Coordinate{62.2279, 34.2101}, // HEA
    Coordinate{-90.6758, 34.5764}, // HEE
    Coordinate{-81.8058, 30.2778}, // HEG
    Coordinate{96.7919, 20.7469}, // HEH
    Coordinate{-102.656, 46.015}, // HEI
    Coordinate{127.309, 50.1722}, // HEK
    Coordinate{24.9633, 60.3172}, // HEL
    Coordinate{24.9242, 60.1478}, // HEN
    Coordinate{147.6, -9.1375}, // HEO
    Coordinate{25.1803, 35.3397}, // HER
    Coordinate{-119.259, 45.8283}, // HES
    Coordinate{111.822, 40.8514}, // HET
    Coordinate{23.7295, 37.8984}, // HEW
    Coordinate{-69.9703, 18.4686}, // HEX
    Coordinate{-91.2972, 31.6136}, // HEZ
    Coordinate{35.0431, 32.8094}, // HFA
    Coordinate{-72.6494, 41.7367}, // HFD
    Coordinate{116.989, 31.9911}, // HFE
    Coordinate{-79.4975, 35.0364}, // HFF
    Coordinate{-15.2272, 64.2956}, // HFN
    Coordinate{13.5806, 60.025}, // HFS
    Coordinate{23.6686, 70.6797}, // HFT
    Coordinate{44.0888, 9.51817}, // HGA
    Coordinate{144.225, -20.815}, // HGD
    Coordinate{-66.0998, 10.4667}, // HGE
    Coordinate{120.434, 30.2294}, // HGH
    Coordinate{32.5006, 10.5292}, // HGI
    Coordinate{7.91444, 54.1858}, // HGL
    Coordinate{97.9747, 19.3011}, // HGN
    Coordinate{-5.55666, 9.38718}, // HGO
    Coordinate{-77.7264, 39.7086}, // HGR
    Coordinate{-13.1291, 8.3943}, // HGS
    Coordinate{144.296, -5.82679}, // HGU
    Coordinate{-80.6975, 32.2244}, // HHH
    Coordinate{7.26417, 49.9483}, // HHN
    Coordinate{99.9514, 12.6303}, // HHQ
    Coordinate{-118.335, 33.9228}, // HHR
    Coordinate{-142.613, -17.5478}, // HHZ
    Coordinate{119.148, 33.7772}, // HIA
    Coordinate{-92.8389, 47.3867}, // HIB
    Coordinate{142.29, -10.5864}, // HID
    Coordinate{-71.5445, 44.3676}, // HIE
    Coordinate{-114.358, 34.5711}, // HII
    Coordinate{132.919, 34.4361}, // HIJ
    Coordinate{44.7639, 6.07778}, // HIL
    Coordinate{128.07, 35.0885}, // HIN
    Coordinate{-122.95, 45.5404}, // HIO
    Coordinate{160.055, -9.428}, // HIR
    Coordinate{132.414, 34.3669}, // HIW
    Coordinate{109.7, 27.4414}, // HJJ
    Coordinate{-119.628, 36.3167}, // HJO
    Coordinate{79.9184, 24.8172}, // HJR
    Coordinate{102.778, 46.9253}, // HJT
    Coordinate{-89.8308, 35.9406}, // HKA
    Coordinate{-144.693, 63.9958}, // HKB
    Coordinate{140.822, 41.77}, // HKD
    Coordinate{113.914, 22.3089}, // HKG
    Coordinate{170.985, -42.7136}, // HKK
    Coordinate{150.405, -5.46217}, // HKN
    Coordinate{}, // HKO
    Coordinate{-156.69, 20.9433}, // HKP
    Coordinate{-90.2225, 32.3347}, // HKS
    Coordinate{98.3169, 8.11333}, // HKT
    Coordinate{-81.3894, 35.7411}, // HKY
    Coordinate{27.9261, -25.9386}, // HLA
    Coordinate{-99.8314, 39.3803}, // HLC
    Coordinate{119.825, 49.205}, // HLD
    Coordinate{-5.64592, -15.9591}, // HLE
    Coordinate{15.8337, 57.5214}, // HLF
    Coordinate{-80.6464, 40.175}, // HLG
    Coordinate{122.008, 46.1953}, // HLH
    Coordinate{-121.41, 36.8933}, // HLI
    Coordinate{23.5581, 56.0673}, // HLJ
    Coordinate{-86.1619, 42.7958}, // HLM
    Coordinate{-111.983, 46.6067}, // HLN
    Coordinate{106.891, -6.26639}, // HLP
    Coordinate{148.282, -41.3367}, // HLS
    Coordinate{142.065, -37.6489}, // HLT
    Coordinate{32.275, -28.0083}, // HLW
    Coordinate{175.332, -37.8667}, // HLZ
    Coordinate{69.0867, 61.0283}, // HMA
    Coordinate{31.7393, 26.3399}, // HMB
    Coordinate{6.14056, 31.6739}, // HME
    Coordinate{93.6694, 42.8425}, // HMI
    Coordinate{26.9333, 49.36}, // HMJ
    Coordinate{-111.048, 29.0958}, // HMO
    Coordinate{11.0681, 60.8181}, // HMR
    Coordinate{-117.022, 33.7339}, // HMT
    Coordinate{141.135, 39.4286}, // HNA
    Coordinate{-86.9536, 38.2489}, // HNB
    Coordinate{-75.6178, 35.2328}, // HNC
    Coordinate{139.781, 35.5533}, // HND
    Coordinate{-135.41, 58.0961}, // HNH
    Coordinate{-157.923, 21.3186}, // HNL
    Coordinate{-156.014, 20.7956}, // HNM
    Coordinate{-135.524, 59.2439}, // HNS
    Coordinate{112.618, 26.7239}, // HNY
    Coordinate{-78.5292, 36.3617}, // HNZ
    Coordinate{40.0039, -1.52}, // HOA
    Coordinate{-103.217, 32.6875}, // HOB
    Coordinate{42.9763, 14.753}, // HOD
    Coordinate{100.426, 20.2578}, // HOE
    Coordinate{49.4852, 25.2853}, // HOF
    Coordinate{-76.315, 20.7856}, // HOG
    Coordinate{9.7, 47.385}, // HOH
    Coordinate{-140.946, -18.0747}, // HOI
    Coordinate{130.643, -18.3367}, // HOK
    Coordinate{-151.477, 59.6456}, // HOM
    Coordinate{-98.2286, 44.3853}, // HON
    Coordinate{106.591, 17.0153}, // HOO
    Coordinate{-28.7164, 38.52}, // HOR
    Coordinate{-70.2225, -37.4447}, // HOS
    Coordinate{-93.0961, 34.4781}, // HOT
    Coordinate{-95.2789, 29.6456}, // HOU
    Coordinate{6.07583, 62.1786}, // HOV
    Coordinate{-174.341, -19.778}, // HPA
    Coordinate{-166.147, 61.5239}, // HPB
    Coordinate{110.338, 31.6336}, // HPG
    Coordinate{106.725, 20.8192}, // HPH
    Coordinate{-73.7075, 41.0669}, // HPN
    Coordinate{-159.446, 22.2092}, // HPV
    Coordinate{-52.1522, -14.0194}, // HPX
    Coordinate{-94.9528, 29.7861}, // HPY
    Coordinate{-101.371, 37.1631}, // HQG
    Coordinate{-123.937, 46.9711}, // HQM
    Coordinate{-96.5306, 32.7469}, // HQZ
    Coordinate{126.25, 45.6234}, // HRB
    Coordinate{31.0928, -17.9318}, // HRE
    Coordinate{33.7992, 27.1781}, // HRG
    Coordinate{81.1236, 6.28889}, // HRI
    Coordinate{83.8333, 28}, // HRJ
    Coordinate{36.29, 49.9247}, // HRK
    Coordinate{-97.655, 26.2272}, // HRL
    Coordinate{3.31039, 32.9315}, // HRM
    Coordinate{-93.1547, 36.2614}, // HRO
    Coordinate{29.1064, -28.235}, // HRS
    Coordinate{-96.8081, 38.6947}, // HRU
    Coordinate{34.834, 32.1803}, // HRZ
    Coordinate{-89.4547, 30.3678}, // HSA
    Coordinate{113.421, 24.9786}, // HSC
    Coordinate{-97.7061, 35.6019}, // HSD
    Coordinate{130.302, 33.1497}, // HSG
    Coordinate{-115.134, 35.9728}, // HSH
    Coordinate{-98.4278, 40.6053}, // HSI
    Coordinate{-0.323333, 42.0808}, // HSK
    Coordinate{-156.351, 65.6978}, // HSL
    Coordinate{142.173, -36.6697}, // HSM
    Coordinate{122.362, 29.9342}, // HSN
    Coordinate{-103.388, 43.3683}, // HSR
    Coordinate{75.7533, 29.1792}, // HSS
    Coordinate{-86.775, 34.6372}, // HSV
    Coordinate{113.305, 52.0267}, // HTA
    Coordinate{-0.250833, 51.7658}, // HTF
    Coordinate{102.487, 71.9683}, // HTG
    Coordinate{-118.634, 38.5444}, // HTH
    Coordinate{148.952, -20.3581}, // HTI
    Coordinate{-84.6711, 44.3597}, // HTL
    Coordinate{100.137, 50.4394}, // HTM
    Coordinate{79.865, 37.0333}, // HTN
    Coordinate{-72.2517, 40.9594}, // HTO
    Coordinate{123.804, 24.0583}, // HTR
    Coordinate{-82.5586, 38.3669}, // HTS
    Coordinate{90.8417, 38.2033}, // HTT
    Coordinate{142.36, -35.715}, // HTU
    Coordinate{-95.5872, 30.7469}, // HTV
    Coordinate{-82.4944, 38.4192}, // HTW
    Coordinate{36.2822, 36.3628}, // HTY
    Coordinate{-71.7625, 6.15278}, // HTZ
    Coordinate{130.63, -16.4897}, // HUB
    Coordinate{-65.8008, 18.1381}, // HUC
    Coordinate{-94.2453, 42.7361}, // HUD
    Coordinate{36.8817, 13.8303}, // HUE
    Coordinate{-87.3075, 39.4514}, // HUF
    Coordinate{-91.505, 15.3164}, // HUG
    Coordinate{-151.022, -16.6872}, // HUH
    Coordinate{107.703, 16.4017}, // HUI
    Coordinate{-95.5419, 34.0347}, // HUJ
    Coordinate{21.7581, -23.9897}, // HUK
    Coordinate{-67.7919, 46.1231}, // HUL
    Coordinate{-90.6606, 29.5664}, // HUM
    Coordinate{121.618, 24.0231}, // HUN
    Coordinate{15.95, 29.1111}, // HUQ
    Coordinate{-154.265, 66.0392}, // HUS
    Coordinate{-97.8606, 38.0656}, // HUT
    Coordinate{-76.2048, -9.87881}, // HUU
    Coordinate{17.0806, 61.7683}, // HUV
    Coordinate{-63.0506, -7.53361}, // HUW
    Coordinate{-96.2625, 15.7742}, // HUX
    Coordinate{-0.350833, 53.5744}, // HUY
    Coordinate{114.6, 23.0483}, // HUZ
    Coordinate{47.7638, -14.6333}, // HVA
    Coordinate{152.88, -25.3189}, // HVB
    Coordinate{-87.455, 36.8569}, // HVC
    Coordinate{91.6258, 47.9614}, // HVD
    Coordinate{25.9836, 71.0097}, // HVG
    Coordinate{-21.6964, 65.7047}, // HVK
    Coordinate{-72.8867, 41.2639}, // HVN
    Coordinate{-109.762, 48.5431}, // HVR
    Coordinate{-80.1192, 34.4031}, // HVS
    Coordinate{141.751, -15.4856}, // HWM
    Coordinate{27.0045, -18.6351}, // HWN
    Coordinate{-80.2408, 26.0011}, // HWO
    Coordinate{-109.853, 46.4486}, // HWQ
    Coordinate{-77.7106, 38.5864}, // HWY
    Coordinate{97.2686, 37.125}, // HXD
    Coordinate{144.83, -34.5317}, // HXX
    Coordinate{-70.2803, 41.6694}, // HYA
    Coordinate{-0.808333, 51.6117}, // HYC
    Coordinate{78.4281, 17.24}, // HYD
    Coordinate{-132.828, 55.2064}, // HYG
    Coordinate{-97.8631, 29.8928}, // HYI
    Coordinate{-132.624, 55.4906}, // HYL
    Coordinate{121.429, 28.5622}, // HYN
    Coordinate{-91.4442, 46.0253}, // HYR
    Coordinate{-99.2731, 38.8422}, // HYS
    Coordinate{-79.1222, 33.8286}, // HYW
    Coordinate{-83.8623, 43.4334}, // HYX
    Coordinate{2.64, 50.6166}, // HZB
    Coordinate{-88.4633, 36.0892}, // HZD
    Coordinate{-101.581, 47.29}, // HZE
    Coordinate{107.202, 33.1367}, // HZG
    Coordinate{109.152, 26.3228}, // HZH
    Coordinate{-17.4258, 65.9522}, // HZK
    Coordinate{-75.995, 40.9867}, // HZL
    Coordinate{-111.701, 57.3817}, // HZP
    Coordinate{-91.4786, 30.7183}, // HZR
    Coordinate{86.6217, 67.4367}, // IAA
    Coordinate{-77.4558, 38.9444}, // IAD
    Coordinate{-78.9461, 43.1072}, // IAG
    Coordinate{-95.3414, 29.9844}, // IAH
    Coordinate{9.64278, 28.0514}, // IAM
    Coordinate{-160.437, 66.9758}, // IAN
    Coordinate{126.014, 9.85889}, // IAO
    Coordinate{54.3186, 27.2127}, // IAQ
    Coordinate{40.1567, 57.56}, // IAR
    Coordinate{27.62, 47.1789}, // IAS
    Coordinate{3.97833, 7.36222}, // IBA
    Coordinate{-75.1325, 4.42139}, // IBE
    Coordinate{35.4522, -21.7072}, // IBL
    Coordinate{-69.4889, -11.4117}, // IBP
    Coordinate{1.37312, 38.8729}, // IBZ
    Coordinate{-61.7389, 4.3375}, // ICA
    Coordinate{-63.9814, 10.7942}, // ICC
    Coordinate{-179.342, -17.7431}, // ICI
    Coordinate{-57.0394, 5.95556}, // ICK
    Coordinate{126.439, 37.4625}, // ICN
    Coordinate{-75.5333, 20.6833}, // ICR
    Coordinate{-97.4331, 37.6499}, // ICT
    Coordinate{-141.662, 59.9689}, // ICY
    Coordinate{-112.071, 43.5136}, // IDA
    Coordinate{19.6, -5}, // IDF
    Coordinate{-116.123, 45.9425}, // IDH
    Coordinate{-79.1056, 40.6322}, // IDI
    Coordinate{-90.6789, 33.4858}, // IDL
    Coordinate{-95.7783, 37.1583}, // IDP
    Coordinate{75.8008, 22.7217}, // IDR
    Coordinate{-2.39111, 46.7186}, // IDY
    Coordinate{15.7986, 52.1386}, // IEG
    Coordinate{127.787, 26.7225}, // IEJ
    Coordinate{-93.0992, 31.7358}, // IER
    Coordinate{13.356, 51.2935}, // IES
    Coordinate{30.4517, 50.4017}, // IEV
    Coordinate{-23.1353, 66.0581}, // IFJ
    Coordinate{146.012, -17.5586}, // IFL
    Coordinate{51.8611, 32.7508}, // IFN
    Coordinate{24.6861, 48.8842}, // IFO
    Coordinate{-114.559, 35.1575}, // IFP
    Coordinate{-73.6669, 20.975}, // IGA
    Coordinate{-69.575, -41.3208}, // IGB
    Coordinate{43.8664, 39.9831}, // IGD
    Coordinate{9.31389, -1.91944}, // IGE
    Coordinate{-155.902, 59.3242}, // IGG
    Coordinate{146.152, -18.6606}, // IGH
    Coordinate{-113.938, 35.2594}, // IGM
    Coordinate{124.214, 8.13052}, // IGN
    Coordinate{-76.6833, 7.67778}, // IGO
    Coordinate{-87.5294, 41.535}, // IGQ
    Coordinate{-54.4733, -25.7372}, // IGR
    Coordinate{11.534, 48.7157}, // IGS
    Coordinate{45.013, 43.3193}, // IGT
    Coordinate{-54.485, -25.6003}, // IGU
    Coordinate{-79.0658, 35.935}, // IGX
    Coordinate{32.9292, -25.9978}, // IHC
    Coordinate{}, // IHO
    Coordinate{60.7204, 27.2289}, // IHR
    Coordinate{145.4, -7.90017}, // IHU
    Coordinate{-9.57, 53.0919}, // IIA
    Coordinate{-91.9478, 42.4569}, // IIB
    Coordinate{46.4044, 33.5866}, // IIL
    Coordinate{154.227, -4.5}, // IIS
    Coordinate{-72.1803, 41.7442}, // IJD
    Coordinate{53.4567, 56.8333}, // IJK
    Coordinate{-53.8456, -28.3706}, // IJU
    Coordinate{51.1522, 35.4161}, // IKA
    Coordinate{-81.0983, 36.2228}, // IKB
    Coordinate{-98.0308, 27.5508}, // IKG
    Coordinate{129.786, 33.7492}, // IKI
    Coordinate{-87.8464, 41.0714}, // IKK
    Coordinate{23.2833, -1.2}, // IKL
    Coordinate{128.903, 71.6975}, // IKS
    Coordinate{104.395, 52.2672}, // IKT
    Coordinate{76.7133, 42.5883}, // IKU
    Coordinate{-93.5664, 41.6911}, // IKV
    Coordinate{-84.2614, 43.6628}, // IKW
    Coordinate{-51.3167, -20.4167}, // ILB
    Coordinate{0.535833, 41.7278}, // ILD
    Coordinate{-97.6864, 31.0858}, // ILE
    Coordinate{-95.6181, 56.0517}, // ILF
    Coordinate{-75.6067, 39.6786}, // ILG
    Coordinate{-154.911, 59.7539}, // ILI
    Coordinate{}, // ILK
    Coordinate{-95.1306, 45.1178}, // ILL
    Coordinate{-77.9025, 34.2706}, // ILM
    Coordinate{-83.7922, 39.4281}, // ILN
    Coordinate{122.493, 10.7147}, // ILO
    Coordinate{167.451, -22.5889}, // ILP
    Coordinate{-71.3606, -17.695}, // ILQ
    Coordinate{4.49444, 8.44056}, // ILR
    Coordinate{-89.1256, 13.6917}, // ILS
    Coordinate{38.0675, -2.91914}, // ILU
    Coordinate{-6.24917, 55.6833}, // ILY
    Coordinate{18.6136, 49.2333}, // ILZ
    Coordinate{-60.2833, 5.71667}, // IMB
    Coordinate{171.483, 7.01667}, // IMI
    Coordinate{81.8189, 29.9711}, // IMK
    Coordinate{-81.4028, 26.4325}, // IMM
    Coordinate{25.1022, 5.00167}, // IMO
    Coordinate{-47.4583, -5.53056}, // IMP
    Coordinate{-88.1144, 45.8183}, // IMT
    Coordinate{60.1114, 66.0556}, // INA
    Coordinate{-88.4106, 16.5219}, // INB
    Coordinate{106.393, 38.3217}, // INC
    Coordinate{-86.2944, 39.7172}, // IND
    Coordinate{5.74889, 19.5689}, // INF
    Coordinate{-72.3, -50.3333}, // ING
    Coordinate{35.4085, -23.8764}, // INH
    Coordinate{21.8536, 43.3372}, // INI
    Coordinate{-97.0972, 32.0836}, // INJ
    Coordinate{-103.202, 31.7797}, // INK
    Coordinate{-93.4022, 48.5656}, // INL
    Coordinate{11.3439, 47.2603}, // INN
    Coordinate{18.2858, -1.94722}, // INO
    Coordinate{-9.51111, 53.0586}, // INQ
    Coordinate{-80.2219, 36.1336}, // INT
    Coordinate{166.919, -0.547458}, // INU
    Coordinate{-4.0475, 57.5425}, // INV
    Coordinate{-110.723, 35.0219}, // INW
    Coordinate{2.51142, 27.2505}, // INZ
    Coordinate{20.8219, 39.6964}, // IOA
    Coordinate{-4.62389, 54.0833}, // IOM
    Coordinate{18.045, 1.58333}, // ION
    Coordinate{-9.65389, 53.1062}, // IOR
    Coordinate{-39.0333, -14.815}, // IOS
    Coordinate{-91.5465, 41.6392}, // IOW
    Coordinate{169.283, -18.8564}, // IPA
    Coordinate{-109.422, -27.1647}, // IPC
    Coordinate{122.601, 7.78614}, // IPE
    Coordinate{-69.6947, -2.93361}, // IPG
    Coordinate{101.092, 4.56778}, // IPH
    Coordinate{-77.6717, 0.861667}, // IPI
    Coordinate{-81.1611, 35.4833}, // IPJ
    Coordinate{-115.579, 32.8342}, // IPL
    Coordinate{-42.4881, -19.4706}, // IPN
    Coordinate{-76.9217, 41.2417}, // IPT
    Coordinate{107.603, 35.7997}, // IQN
    Coordinate{-70.1813, -20.5352}, // IQQ
    Coordinate{-73.3086, -3.78472}, // IQT
    Coordinate{161.898, -10.4494}, // IRA
    Coordinate{-144.076, 65.8278}, // IRC
    Coordinate{89.0486, 24.1525}, // IRD
    Coordinate{143.305, -12.7869}, // IRG
    Coordinate{35.7519, -7.66944}, // IRI
    Coordinate{-66.8025, -29.3892}, // IRJ
    Coordinate{-92.545, 40.0933}, // IRK
    Coordinate{22.7167, 10.2333}, // IRO
    Coordinate{27.5881, 2.82667}, // IRP
    Coordinate{-65.0339, -0.41694}, // IRZ
    Coordinate{139.489, -20.6639}, // ISA
    Coordinate{73.0992, 33.6164}, // ISB
    Coordinate{-6.29167, 49.9133}, // ISC
    Coordinate{30.3819, 37.865}, // ISE
    Coordinate{124.245, 24.3964}, // ISG
    Coordinate{144.425, -24.2583}, // ISI
    Coordinate{-86.7403, 21.245}, // ISJ
    Coordinate{73.9131, 20.1192}, // ISK
    Coordinate{-81.4372, 28.2897}, // ISM
    Coordinate{-103.642, 48.1781}, // ISN
    Coordinate{-77.6117, 35.3233}, // ISO
    Coordinate{-73.1003, 40.7953}, // ISP
    Coordinate{-86.1717, 45.9744}, // ISQ
    Coordinate{-69.7125, 43.9614}, // ISS
    Coordinate{28.8142, 40.9761}, // IST
    Coordinate{45.3144, 35.5608}, // ISU
    Coordinate{-89.8389, 44.3603}, // ISW
    Coordinate{-84.3889, 39.2467}, // ISZ
    Coordinate{-58.4817, -3.12639}, // ITA
    Coordinate{-56.0008, -4.24222}, // ITB
    Coordinate{-76.4586, 42.4914}, // ITH
    Coordinate{135.438, 34.7855}, // ITM
    Coordinate{-155.048, 19.7253}, // ITO
    Coordinate{-41.8756, -21.2194}, // ITP
    Coordinate{-56.5367, -29.1809}, // ITQ
    Coordinate{-49.2142, -18.445}, // ITR
    Coordinate{147.956, 45.2564}, // ITU
    Coordinate{-169.926, -19.08}, // IUE
    Coordinate{155.15, -5.78306}, // IUS
    Coordinate{48.6327, -13.485}, // IVA
    Coordinate{168.313, -46.415}, // IVC
    Coordinate{19.862, 42.839}, // IVG
    Coordinate{27.4139, 68.6108}, // IVL
    Coordinate{151.143, -29.8883}, // IVR
    Coordinate{40.9333, 56.9417}, // IWA
    Coordinate{-90.1314, 46.5275}, // IWD
    Coordinate{131.79, 34.6764}, // IWJ
    Coordinate{-95.6725, 29.8183}, // IWS
    Coordinate{91.2392, 23.89}, // IXA
    Coordinate{88.3282, 26.6811}, // IXB
    Coordinate{76.7885, 30.6733}, // IXC
    Coordinate{81.7339, 25.44}, // IXD
    Coordinate{74.8897, 12.9619}, // IXE
    Coordinate{74.6175, 15.8592}, // IXG
    Coordinate{92.0072, 24.3078}, // IXH
    Coordinate{94.0969, 27.2906}, // IXI
    Coordinate{74.8367, 32.6892}, // IXJ
    Coordinate{70.2691, 21.315}, // IXK
    Coordinate{77.5457, 34.1357}, // IXL
    Coordinate{78.0883, 9.83361}, // IXM
    Coordinate{91.6039, 24.0617}, // IXN
    Coordinate{75.6344, 32.2336}, // IXP
    Coordinate{91.8142, 24.1317}, // IXQ
    Coordinate{85.3217, 23.3142}, // IXR
    Coordinate{92.9786, 24.912}, // IXS
    Coordinate{95.3833, 28.1}, // IXT
    Coordinate{75.3976, 19.8628}, // IXU
    Coordinate{94.8019, 28.164}, // IXV
    Coordinate{86.1643, 22.8136}, // IXW
    Coordinate{70.1003, 23.1122}, // IXY
    Coordinate{92.7297, 11.6411}, // IXZ
    Coordinate{-92.0842, 29.9758}, // IYA
    Coordinate{-117.829, 35.6586}, // IYK
    Coordinate{-43.1731, -21.5131}, // IZA
    Coordinate{132.89, 35.4136}, // IZO
    Coordinate{-95.0931, 16.4456}, // IZT
    Coordinate{70.4985, 34.3997}, // JAA
    Coordinate{132.893, -12.6583}, // JAB
    Coordinate{-110.738, 43.6072}, // JAC
    Coordinate{115.881, -32.0975}, // JAD
    Coordinate{-78.7742, -5.59528}, // JAE
    Coordinate{75.8122, 26.8242}, // JAI
    Coordinate{-72.5186, 18.2411}, // JAK
    Coordinate{-96.7975, 19.4744}, // JAL
    Coordinate{-90.0758, 32.3111}, // JAN
    Coordinate{21.2331, 43.9767}, // JAO
    Coordinate{-84.7833, 9.98333}, // JAP
    Coordinate{151.507, -5.6525}, // JAQ
    Coordinate{53.5789, 28.5867}, // JAR
    Coordinate{168.978, 7.75}, // JAT
    Coordinate{-75.4733, -11.7831}, // JAU
    Coordinate{-51.0572, 69.2433}, // JAV
    Coordinate{-81.6878, 30.4942}, // JAX
    Coordinate{113.694, -8.24111}, // JBB
    Coordinate{-69.9814, 18.5756}, // JBQ
    Coordinate{-90.6464, 35.8317}, // JBR
    Coordinate{-161.743, 60.7819}, // JBT
    Coordinate{-51.5517, -27.1728}, // JCB
    Coordinate{-51.1747, 68.8172}, // JCH
    Coordinate{-94.8903, 38.8308}, // JCI
    Coordinate{141.722, -20.6683}, // JCK
    Coordinate{-57.7758, -6.23528}, // JCR
    Coordinate{-118.968, 44.4028}, // JDA
    Coordinate{-95.4964, 32.7422}, // JDD
    Coordinate{-43.3856, -21.7931}, // JDF
    Coordinate{126.713, 33.3983}, // JDG
    Coordinate{73.0467, 26.2511}, // JDH
    Coordinate{-106.953, 47.3289}, // JDN
    Coordinate{-39.2717, -7.21833}, // JDO
    Coordinate{-44.2264, -21.0864}, // JDR
    Coordinate{117.176, 29.3386}, // JDZ
    Coordinate{39.1556, 21.6811}, // JED
    Coordinate{-74.1705, 18.6633}, // JEE
    Coordinate{-92.1561, 38.5911}, // JEF
    Coordinate{-52.7847, 68.7218}, // JEG
    Coordinate{168.962, 7.565}, // JEJ
    Coordinate{-40.0719, -13.8778}, // JEQ
    Coordinate{-2.19528, 49.2081}, // JER
    Coordinate{-81.8825, 31.5539}, // JES
    Coordinate{-73.7789, 40.6397}, // JFK
    Coordinate{-80.6956, 41.7781}, // JFN
    Coordinate{-49.6708, 62.0147}, // JFR
    Coordinate{-87.3142, 33.9019}, // JFX
    Coordinate{70.0125, 22.4656}, // JGA
    Coordinate{82.0369, 19.0744}, // JGB
    Coordinate{124.118, 50.3714}, // JGD
    Coordinate{98.3383, 39.8597}, // JGN
    Coordinate{-53.5381, 69.2511}, // JGO
    Coordinate{114.737, 26.8575}, // JGS
    Coordinate{103.669, 1.64111}, // JHB
    Coordinate{100.76, 21.9739}, // JHG
    Coordinate{-111.419, 57.2239}, // JHL
    Coordinate{-156.673, 20.9631}, // JHM
    Coordinate{-101.732, 37.5853}, // JHN
    Coordinate{148.755, -20.2767}, // JHQ
    Coordinate{-53.7294, 66.9514}, // JHS
    Coordinate{-79.2581, 42.1533}, // JHW
    Coordinate{-58.7114, -11.4194}, // JIA
    Coordinate{43.1593, 11.5473}, // JIB
    Coordinate{102.348, 38.5419}, // JIC
    Coordinate{42.9119, 9.33222}, // JIJ
    Coordinate{26.3471, 37.6827}, // JIK
    Coordinate{126.396, 44.0022}, // JIL
    Coordinate{36.815, 7.66201}, // JIM
    Coordinate{33.1931, 0.4525}, // JIN
    Coordinate{127.909, -8.14056}, // JIO
    Coordinate{108.829, 29.5175}, // JIQ
    Coordinate{115.801, 29.4769}, // JIU
    Coordinate{61.8054, 25.0678}, // JIW
    Coordinate{-99.2889, 19.5747}, // JJC
    Coordinate{-49.0603, -28.6753}, // JJG
    Coordinate{-76.7292, -7.16972}, // JJI
    Coordinate{38.1706, 0.230278}, // JJM
    Coordinate{118.589, 24.7989}, // JJN
    Coordinate{14.0717, 57.7583}, // JKG
    Coordinate{26.1406, 38.3431}, // JKH
    Coordinate{26.9406, 36.9633}, // JKL
    Coordinate{85.9222, 26.7086}, // JKR
    Coordinate{-95.2175, 31.8694}, // JKV
    Coordinate{-94.4983, 37.1517}, // JLN
    Coordinate{80.0603, 23.1834}, // JLR
    Coordinate{16.0653, -14.6986}, // JMB
    Coordinate{99.7864, 22.4158}, // JMJ
    Coordinate{25.3481, 37.4351}, // JMK
    Coordinate{83.7225, 28.7822}, // JMO
    Coordinate{-98.6783, 46.9297}, // JMS
    Coordinate{130.465, 46.8433}, // JMU
    Coordinate{-44.3864, -15.4747}, // JNA
    Coordinate{28.2461, -26.1392}, // JNB
    Coordinate{116.347, 35.2928}, // JNG
    Coordinate{-60.9339, -34.5458}, // JNI
    Coordinate{57.6344, 19.5022}, // JNJ
    Coordinate{-134.576, 58.355}, // JNU
    Coordinate{25.3682, 37.0811}, // JNX
    Coordinate{121.28, 40.93}, // JNZ
    Coordinate{29.6244, 62.6589}, // JOE
    Coordinate{110.432, -7.78806}, // JOG
    Coordinate{-48.7978, -26.2231}, // JOI
    Coordinate{-106.585, 68.1253}, // JOJ
    Coordinate{47.895, 56.705}, // JOK
    Coordinate{121.01, 6.05307}, // JOL
    Coordinate{-169.534, 16.7286}, // JON
    Coordinate{8.86889, 9.63972}, // JOS
    Coordinate{-88.1756, 41.5178}, // JOT
    Coordinate{-34.9503, -7.14833}, // JPA
    Coordinate{-61.8467, -10.8706}, // JPR
    Coordinate{-52.6961, 70.7342}, // JQA
    Coordinate{-78.1572, 7.51778}, // JQE
    Coordinate{-80.7092, 35.3878}, // JQF
    Coordinate{-158.07, 21.3072}, // JRF
    Coordinate{94.175, 26.73}, // JRH
    Coordinate{-58.4894, -10.3058}, // JRN
    Coordinate{37.0744, -3.42944}, // JRO
    Coordinate{-59.7921, -37.7061}, // JRZ
    Coordinate{84.0503, 21.9133}, // JSA
    Coordinate{26.1013, 35.2161}, // JSH
    Coordinate{23.5036, 39.1772}, // JSI
    Coordinate{}, // JSJ
    Coordinate{-70.7567, -44.0911}, // JSM
    Coordinate{89.1608, 23.1836}, // JSR
    Coordinate{-78.8347, 40.3156}, // JST
    Coordinate{-52.9394, 65.4125}, // JSU
    Coordinate{-94.8028, 35.4383}, // JSV
    Coordinate{24.95, 37.4228}, // JSY
    Coordinate{-49.0683, -22.1578}, // JTC
    Coordinate{-51.7753, -17.83}, // JTI
    Coordinate{25.4793, 36.3992}, // JTR
    Coordinate{26.3758, 36.5798}, // JTY
    Coordinate{-57.5389, -11.2867}, // JUA
    Coordinate{31.6011, 4.87201}, // JUB
    Coordinate{117.687, 30.7403}, // JUH
    Coordinate{7.05573, 53.6816}, // JUI
    Coordinate{-65.0978, -24.3928}, // JUJ
    Coordinate{-70.1581, -15.4669}, // JUL
    Coordinate{82.1933, 29.2744}, // JUM
    Coordinate{115.055, -30.3033}, // JUR
    Coordinate{-58.5995, -34.7305}, // JUS
    Coordinate{-56.1306, 72.7903}, // JUV
    Coordinate{118.899, 28.9658}, // JUZ
    Coordinate{45.2833, -18.8}, // JVA
    Coordinate{-74.5983, 40.5244}, // JVI
    Coordinate{-89.0417, 42.6203}, // JVL
    Coordinate{-148.926, 61.7319}, // JVM
    Coordinate{-90.4106, 32.3044}, // JVW
    Coordinate{-85.7383, 38.3656}, // JVY
    Coordinate{24.691, -24.6023}, // JWA
    Coordinate{-98.4208, 35.8644}, // JWG
    Coordinate{48.3585, 36.7742}, // JWN
    Coordinate{130.997, 45.3061}, // JXA
    Coordinate{-84.4606, 42.2606}, // JXN
    Coordinate{120.681, 30.7067}, // JXS
    Coordinate{-84.5858, 41.9214}, // JYM
    Coordinate{-77.5575, 39.0781}, // JYO
    Coordinate{57.6703, 28.7269}, // JYR
    Coordinate{25.6728, 62.4008}, // JYV
    Coordinate{103.685, 32.8542}, // JZH
    Coordinate{-80.0028, 32.7008}, // JZI
    Coordinate{-84.4572, 34.4533}, // JZP
    Coordinate{31.1333, -10.2167}, // KAA
    Coordinate{28.885, -16.5197}, // KAB
    Coordinate{41.1914, 37.0206}, // KAC
    Coordinate{7.32, 10.6958}, // KAD
    Coordinate{-133.946, 56.9731}, // KAE
    Coordinate{-59.4914, 5.1725}, // KAI
    Coordinate{27.6875, 64.2842}, // KAJ
    Coordinate{-158.741, 64.3189}, // KAL
    Coordinate{42.6111, 15.3611}, // KAM
    Coordinate{8.52444, 12.0475}, // KAN
    Coordinate{29.2319, 65.9903}, // KAO
    Coordinate{22.65, -8.35}, // KAP
    Coordinate{-60.6139, 5.86528}, // KAR
    Coordinate{18.7333, -28.0333}, // KAS
    Coordinate{173.285, -35.07}, // KAT
    Coordinate{98.538, 10.0493}, // KAW
    Coordinate{114.26, -27.6917}, // KAX
    Coordinate{-11.55, 9.583}, // KBA
    Coordinate{-145.824, 66.2739}, // KBC
    Coordinate{31.4978, 2.32639}, // KBG
    Coordinate{9.97722, 2.87278}, // KBI
    Coordinate{69.2123, 34.5659}, // KBL
    Coordinate{24.3333, -6.12056}, // KBN
    Coordinate{26.9167, -6.08333}, // KBO
    Coordinate{30.8933, 50.3447}, // KBP
    Coordinate{33.4667, -13.0167}, // KBQ
    Coordinate{102.293, 6.16667}, // KBR
    Coordinate{-11.7624, 7.94389}, // KBS
    Coordinate{116.163, -3.29278}, // KBU
    Coordinate{98.9853, 8.10016}, // KBV
    Coordinate{-158.401, 56.2956}, // KBW
    Coordinate{134.293, -32.8358}, // KBY
    Coordinate{173.602, -42.425}, // KBZ
    Coordinate{82.9869, 41.7181}, // KCA
    Coordinate{-55.7167, 3.15}, // KCB
    Coordinate{-132.834, 56.0147}, // KCC
    Coordinate{69.1564, 27.1553}, // KCF
    Coordinate{-158.591, 56.3178}, // KCG
    Coordinate{110.347, 1.48444}, // KCH
    Coordinate{108.061, 57.7728}, // KCK
    Coordinate{-158.534, 56.3111}, // KCL
    Coordinate{36.9533, 37.5386}, // KCM
    Coordinate{-158.775, 56.255}, // KCQ
    Coordinate{80.3206, 5.99389}, // KCT
    Coordinate{31.7367, 1.75}, // KCU
    Coordinate{133.669, 33.5461}, // KCZ
    Coordinate{-14.9681, 12.8983}, // KDA
    Coordinate{121.598, -31.19}, // KDB
    Coordinate{2.933, 11.133}, // KDC
    Coordinate{66.6403, 27.7926}, // KDD
    Coordinate{65.8503, 31.5072}, // KDH
    Coordinate{122.418, -4.08161}, // KDI
    Coordinate{10.7611, -0.188889}, // KDJ
    Coordinate{-152.374, 57.8058}, // KDK
    Coordinate{22.8306, 58.9906}, // KDL
    Coordinate{72.9962, 0.488056}, // KDM
    Coordinate{11.3611, -2.40556}, // KDN
    Coordinate{73.5197, 1.85835}, // KDO
    Coordinate{149.542, -6.20833}, // KDR
    Coordinate{75.5361, 35.3356}, // KDU
    Coordinate{178.157, -19.0581}, // KDV
    Coordinate{29.6992, 11.1371}, // KDX
    Coordinate{136.842, 62.7861}, // KDY
    Coordinate{-151.925, 59.3522}, // KEB
    Coordinate{-13.5167, 16.15}, // KED
    Coordinate{14.5333, -0.0833333}, // KEE
    Coordinate{-22.6056, 63.985}, // KEF
    Coordinate{-122.259, 47.7547}, // KEH
    Coordinate{86.11, 55.2717}, // KEJ
    Coordinate{-157.472, 59.3547}, // KEK
    Coordinate{24.5847, 65.7792}, // KEM
    Coordinate{-11.1766, 7.8913}, // KEN
    Coordinate{-7.567, 9.5}, // KEO
    Coordinate{81.6669, 28.1036}, // KEP
    Coordinate{56.9511, 30.2744}, // KER
    Coordinate{-96.5061, 56.0367}, // KES
    Coordinate{99.6361, 21.3017}, // KET
    Coordinate{35.2508, -1.58592}, // KEU
    Coordinate{-92.8364, 52.9911}, // KEW
    Coordinate{35.245, -0.413778}, // KEY
    Coordinate{-11.4061, 16.5833}, // KFA
    Coordinate{119.437, -22.2919}, // KFE
    Coordinate{130.808, -17.4319}, // KFG
    Coordinate{-163.41, 54.8475}, // KFP
    Coordinate{33.7908, 41.3047}, // KFS
    Coordinate{22.4667, -5.9}, // KGA
    Coordinate{137.521, -35.7139}, // KGC
    Coordinate{20.5925, 54.89}, // KGD
    Coordinate{157.587, -7.33278}, // KGE
    Coordinate{73.3353, 49.6717}, // KGF
    Coordinate{-12.2203, 12.5667}, // KGG
    Coordinate{121.462, -30.7894}, // KGI
    Coordinate{33.8928, -9.95494}, // KGJ
    Coordinate{-157.259, 59.7267}, // KGK
    Coordinate{30.1331, -1.96656}, // KGL
    Coordinate{16.8056, -6.46806}, // KGN
    Coordinate{74.535, 62.19}, // KGP
    Coordinate{27.0917, 36.7933}, // KGS
    Coordinate{101.735, 30.1575}, // KGT
    Coordinate{116.159, 5.35444}, // KGU
    Coordinate{-160.065, 62.8944}, // KGX
    Coordinate{151.841, -26.5808}, // KGY
    Coordinate{36.4014, 45.3725}, // KHC
    Coordinate{48.2808, 33.4354}, // KHD
    Coordinate{32.5022, 46.6681}, // KHE
    Coordinate{76.02, 39.5431}, // KHG
    Coordinate{120.35, 22.5769}, // KHH
    Coordinate{67.1605, 24.9045}, // KHI
    Coordinate{50.3233, 29.2594}, // KHK
    Coordinate{95.6744, 25.9875}, // KHM
    Coordinate{115.9, 28.865}, // KHN
    Coordinate{102.826, 47.2467}, // KHR
    Coordinate{56.2333, 26.1708}, // KHS
    Coordinate{69.9517, 33.3336}, // KHT
    Coordinate{33.4753, 49.1308}, // KHU
    Coordinate{135.188, 48.5281}, // KHV
    Coordinate{23.7878, -19.1494}, // KHW
    Coordinate{44.9736, 38.4275}, // KHY
    Coordinate{-121.121, 36.2286}, // KIC
    Coordinate{14.0833, 55.9119}, // KID
    Coordinate{155.723, -6.30333}, // KIE
    Coordinate{-89.8553, 53.0125}, // KIF
    Coordinate{53.9797, 26.5262}, // KIH
    Coordinate{139.112, 37.9558}, // KIJ
    Coordinate{24.7636, -28.8017}, // KIM
    Coordinate{-76.7875, 17.9356}, // KIN
    Coordinate{169.128, 5.64617}, // KIO
    Coordinate{-98.4903, 33.8606}, // KIP
    Coordinate{-9.52389, 52.1808}, // KIR
    Coordinate{34.7289, -0.086111}, // KIS
    Coordinate{23.017, 36.2743}, // KIT
    Coordinate{28.9308, 46.9278}, // KIV
    Coordinate{28.1497, -12.9003}, // KIW
    Coordinate{135.233, 34.4342}, // KIX
    Coordinate{39.5086, -8.91111}, // KIY
    Coordinate{89.644, 22.647}, // KJA
    Coordinate{107.981, 26.9742}, // KJH
    Coordinate{86.9981, 48.2211}, // KJI
    Coordinate{3.20472, 50.8172}, // KJK
    Coordinate{127.293, 26.1683}, // KJP
    Coordinate{-161.154, 64.9394}, // KKA
    Coordinate{-152.371, 58.1908}, // KKB
    Coordinate{102.782, 16.4644}, // KKC
    Coordinate{147.733, -8.88306}, // KKD
    Coordinate{173.912, -35.2628}, // KKE
    Coordinate{-162.881, 59.9608}, // KKH
    Coordinate{-161.423, 60.9047}, // KKI
    Coordinate{131.035, 33.8456}, // KKJ
    Coordinate{100.658, 14.8722}, // KKM
    Coordinate{29.8878, 69.725}, // KKN
    Coordinate{173.817, -35.4528}, // KKO
    Coordinate{-146.886, -15.6677}, // KKR
    Coordinate{-87.4283, 40.7586}, // KKT
    Coordinate{18.7833, -5.03583}, // KKW
    Coordinate{129.928, 28.3214}, // KKX
    Coordinate{-7.29611, 52.6508}, // KKY
    Coordinate{102.996, 11.6132}, // KKZ
    Coordinate{32.5925, 0.326111}, // KLA
    Coordinate{22.4806, -14.9972}, // KLB
    Coordinate{-16.0511, 14.1467}, // KLC
    Coordinate{35.76, 56.825}, // KLD
    Coordinate{14.4456, 10.0925}, // KLE
    Coordinate{36.3689, 54.5467}, // KLF
    Coordinate{-160.341, 61.5364}, // KLG
    Coordinate{74.2894, 16.6647}, // KLH
    Coordinate{21.2428, 55.7119}, // KLJ
    Coordinate{35.8342, 3.48036}, // KLK
    Coordinate{-156.859, 59.1281}, // KLL
    Coordinate{55.4519, 37.375}, // KLM
    Coordinate{-153.977, 57.535}, // KLN
    Coordinate{122.378, 11.6813}, // KLO
    Coordinate{112.537, -3.37639}, // KLP
    Coordinate{16.2833, 56.6833}, // KLR
    Coordinate{-122.898, 46.1181}, // KLS
    Coordinate{14.3372, 46.6428}, // KLU
    Coordinate{12.915, 50.2031}, // KLV
    Coordinate{-133.076, 55.5792}, // KLW
    Coordinate{22.0256, 37.0684}, // KLX
    Coordinate{26.7333, -2.57639}, // KLY
    Coordinate{17.0933, -29.6884}, // KLZ
    Coordinate{145.771, -7.96365}, // KMA
    Coordinate{45.5281, 27.9008}, // KMC
    Coordinate{28.9078, -2.46222}, // KME
    Coordinate{102.929, 25.1019}, // KMG
    Coordinate{23.4114, -27.4597}, // KMH
    Coordinate{131.449, 31.8772}, // KMI
    Coordinate{130.855, 32.8372}, // KMJ
    Coordinate{12.6167, -3.48333}, // KMK
    Coordinate{24.9833, -8.73333}, // KMN
    Coordinate{-159.05, 58.9903}, // KMO
    Coordinate{18.1114, -26.5397}, // KMP
    Coordinate{136.408, 36.3939}, // KMQ
    Coordinate{-1.59056, 6.71444}, // KMS
    Coordinate{104.162, 10.6341}, // KMT
    Coordinate{42.4475, -0.389333}, // KMU
    Coordinate{94.0508, 23.1875}, // KMV
    Coordinate{41.02, 57.7967}, // KMW
    Coordinate{-154.146, 57.0256}, // KMY
    Coordinate{24.7833, -14.8}, // KMZ
    Coordinate{-71.4786, -32.9497}, // KNA
    Coordinate{-112.531, 37.0111}, // KNB
    Coordinate{25.9, -2.93333}, // KND
    Coordinate{133.695, -3.64452}, // KNG
    Coordinate{118.359, 24.4278}, // KNH
    Coordinate{117.653, -33.7}, // KNI
    Coordinate{14.5167, -3.95}, // KNJ
    Coordinate{-154.803, 59.4331}, // KNK
    Coordinate{24.1569, -7.60139}, // KNM
    Coordinate{-9.22733, 10.4485}, // KNN
    Coordinate{98.878, 3.64174}, // KNO
    Coordinate{15.4565, -9.77078}, // KNP
    Coordinate{164.838, -21.0533}, // KNQ
    Coordinate{143.878, -39.8775}, // KNS
    Coordinate{-90.0367, 36.2258}, // KNT
    Coordinate{80.4117, 26.4028}, // KNU
    Coordinate{-157.373, 59.4517}, // KNW
    Coordinate{128.708, -15.7781}, // KNX
    Coordinate{-11.2528, 12.8333}, // KNZ
    Coordinate{-156.046, 19.7389}, // KOA
    Coordinate{10.7508, 5.63694}, // FOM
    Coordinate{164.256, -20.5464}, // KOC
    Coordinate{123.671, -10.1714}, // KOE
    Coordinate{-2.90056, 58.9581}, // KOI
    Coordinate{130.717, 31.8033}, // KOJ
    Coordinate{23.1392, 63.7203}, // KOK
    Coordinate{21.25, 8.5}, // KOL
    Coordinate{26.99, -5.4}, // KOO
    Coordinate{104.642, 17.3839}, // KOP
    Coordinate{11.9472, 51.7211}, // KOQ
    Coordinate{103.637, 10.58}, // KOS
    Coordinate{-163.533, 63.0306}, // KOT
    Coordinate{12.4411, -1.18444}, // KOU
    Coordinate{69.5967, 53.33}, // KOV
    Coordinate{114.777, 25.8517}, // KOW
    Coordinate{-154.23, 57.1614}, // KOY
    Coordinate{-152.501, 57.9229}, // KOZ
    Coordinate{-133.622, 56.3519}, // KPB
    Coordinate{-166.859, 65.2536}, // KPC
    Coordinate{112.843, 2.00833}, // KPI
    Coordinate{-164.031, 59.9331}, // KPN
    Coordinate{129.42, 35.9878}, // KPO
    Coordinate{-152.582, 58.49}, // KPR
    Coordinate{152.77, -31.0744}, // KPS
    Coordinate{-114.658, 41.9761}, // KPT
    Coordinate{-159.161, 55.9067}, // KPV
    Coordinate{166.139, 67.8469}, // KPW
    Coordinate{-153.041, 57.93}, // KPY
    Coordinate{-165.778, 54.1339}, // KQA
    Coordinate{116.687, -29.2167}, // KQR
    Coordinate{68.8628, 37.8622}, // KQT
    Coordinate{143.939, -35.7517}, // KRA
    Coordinate{140.83, -17.4558}, // KRB
    Coordinate{101.463, -2.09111}, // KRC
    Coordinate{29.3183, -3.32389}, // KRE
    Coordinate{17.7686, 63.0483}, // KRF
    Coordinate{-59.5333, 4.03333}, // KRG
    Coordinate{-0.138611, 51.2136}, // KRH
    Coordinate{144.25, -7.42472}, // KRI
    Coordinate{19.7847, 50.0778}, // KRK
    Coordinate{86.1431, 41.6164}, // KRL
    Coordinate{-59.3097, 3.75195}, // KRM
    Coordinate{20.3356, 67.8214}, // KRN
    Coordinate{65.4153, 55.475}, // KRO
    Coordinate{9.12472, 56.2975}, // KRP
    Coordinate{39.1706, 45.0347}, // KRR
    Coordinate{8.085, 58.2039}, // KRS
    Coordinate{32.5532, 15.5895}, // KRT
    Coordinate{35.665, 0.32}, // KRV
    Coordinate{53.0072, 40.0633}, // KRW
    Coordinate{84.9525, 45.4664}, // KRY
    Coordinate{19, -1.45}, // KRZ
    Coordinate{162.958, 5.35694}, // KSA
    Coordinate{21.2411, 48.6631}, // KSC
    Coordinate{13.3375, 59.4447}, // KSD
    Coordinate{30.1025, 0.19}, // KSE
    Coordinate{9.37763, 51.4084}, // KSF
    Coordinate{47.1564, 34.3459}, // KSH
    Coordinate{-10.1244, 9.16056}, // KSI
    Coordinate{26.91, 35.4214}, // KSJ
    Coordinate{14.4947, 59.3333}, // KSK
    Coordinate{36.3286, 15.3872}, // KSL
    Coordinate{-163.302, 62.0608}, // KSM
    Coordinate{63.5503, 53.2069}, // KSN
    Coordinate{21.2811, 40.4463}, // KSO
    Coordinate{65.7733, 38.8033}, // KSQ
    Coordinate{120.437, -6.17567}, // KSR
    Coordinate{-5.7989, 11.327}, // KSS
    Coordinate{32.6981, 13.1894}, // KST
    Coordinate{7.82611, 63.1119}, // KSU
    Coordinate{140.703, -23.5431}, // KSV
    Coordinate{43.0989, 40.5586}, // KSY
    Coordinate{46.6967, 61.2367}, // KSZ
    Coordinate{116.773, -20.7122}, // KTA
    Coordinate{-132.537, 55.6881}, // KTB
    Coordinate{-5.0654, 8.1344}, // KTC
    Coordinate{131.327, 25.9447}, // KTD
    Coordinate{103.427, 4.53722}, // KTE
    Coordinate{172.775, -40.9038}, // KTF
    Coordinate{109.963, -1.81639}, // KTG
    Coordinate{106.055, 12.4852}, // KTI
    Coordinate{34.9508, 0.897222}, // KTL
    Coordinate{85.3578, 27.6972}, // KTM
    Coordinate{-131.711, 55.3542}, // KTN
    Coordinate{-59.8322, 4.64917}, // KTO
    Coordinate{-76.825, 17.9858}, // KTP
    Coordinate{-166.466, 65.3314}, // KTS
    Coordinate{24.8481, 67.6986}, // KTT
    Coordinate{75.8456, 25.1601}, // KTU
    Coordinate{-62.3375, 5.71667}, // KTV
    Coordinate{19.08, 50.4742}, // KTW
    Coordinate{-5.467, 12.35}, // KTX
    Coordinate{103.209, 3.77518}, // KUA
    Coordinate{173.44, 0.219662}, // KUC
    Coordinate{116.831, 6.92417}, // KUD
    Coordinate{}, // KUE
    Coordinate{50.155, 53.5017}, // KUF
    Coordinate{142.218, -10.225}, // KUG
    Coordinate{144.193, 43.0408}, // KUH
    Coordinate{-162.524, 60.8733}, // KUK
    Coordinate{101.71, 2.74556}, // KUL
    Coordinate{130.659, 30.3856}, // KUM
    Coordinate{24.0847, 54.9639}, // KUN
    Coordinate{27.7944, 63.0086}, // KUO
    Coordinate{70.7622, 36.0175}, // KUR
    Coordinate{-37.1236, 65.5736}, // KUS
    Coordinate{42.4825, 42.1764}, // KUT
    Coordinate{77.1544, 31.8767}, // KUU
    Coordinate{126.616, 35.9039}, // KUV
    Coordinate{143.122, -7.4196}, // KUY
    Coordinate{24.6192, 40.9133}, // KVA
    Coordinate{13.9728, 58.4561}, // KVB
    Coordinate{-162.266, 55.1164}, // KVC
    Coordinate{46.3175, 40.7378}, // KVD
    Coordinate{150.808, -2.57917}, // KVG
    Coordinate{33.5881, 67.4631}, // KVK
    Coordinate{-164.564, 67.7361}, // KVL
    Coordinate{170.414, 64.6653}, // KVM
    Coordinate{20.5853, 43.8186}, // KVO
    Coordinate{20.724, 43.7307}, // KVS
    Coordinate{49.3483, 58.5033}, // KVX
    Coordinate{110.479, -5.80111}, // KWB
    Coordinate{106.801, 26.5386}, // KWE
    Coordinate{-133.243, 55.2964}, // KWF
    Coordinate{33.2069, 48.0431}, // KWG
    Coordinate{70.2033, 37.8917}, // KWH
    Coordinate{47.98, 29.2268}, // KWI
    Coordinate{126.809, 35.1264}, // KWJ
    Coordinate{-163.169, 59.8764}, // KWK
    Coordinate{110.039, 25.2181}, // KWL
    Coordinate{-161.845, 59.755}, // KWN
    Coordinate{-153.549, 57.77}, // KWP
    Coordinate{35.5967, 33.2167}, // KWS
    Coordinate{-161.444, 60.7903}, // KWT
    Coordinate{41.2975, -1.96056}, // KWY
    Coordinate{25.5, -10.7667}, // KWZ
    Coordinate{67.4333, 59.65}, // KXD
    Coordinate{179.422, -17.3458}, // KXF
    Coordinate{136.933, 50.4083}, // KXK
    Coordinate{121.527, 22.0294}, // KYD
    Coordinate{-154.454, 57.5661}, // KYK
    Coordinate{93.5347, 19.4244}, // KYP
    Coordinate{-11.4044, 14.4811}, // KYS
    Coordinate{-157.731, 64.8758}, // KYU
    Coordinate{94.4052, 51.6761}, // KYZ
    Coordinate{-153.746, 57.5533}, // KZB
    Coordinate{22.3181, 43.6917}, // KZC
    Coordinate{104.148, 12.5395}, // KZD
    Coordinate{21.8408, 40.2858}, // KZI
    Coordinate{105.441, 12.0289}, // KZK
    Coordinate{49.2817, 55.6067}, // KZN
    Coordinate{65.5925, 44.7069}, // KZO
    Coordinate{30.13, 39.1114}, // KZR
    Coordinate{29.5667, 36.1278}, // KZS
    Coordinate{-102.689, 38.0697}, // LAA
    Coordinate{113.842, 7.37222}, // LAC
    Coordinate{13.2312, -8.85808}, // LAD
    Coordinate{146.996, -6.73306}, // LAE
    Coordinate{-86.9369, 40.4122}, // LAF
    Coordinate{127.501, -0.637222}, // LAH
    Coordinate{-3.47444, 48.7542}, // LAI
    Coordinate{-50.2822, -27.7828}, // LAJ
    Coordinate{-135.006, 68.2233}, // LAK
    Coordinate{-82.0186, 27.9889}, // LAL
    Coordinate{-106.269, 35.8797}, // LAM
    Coordinate{-84.5862, 42.7786}, // LAN
    Coordinate{120.532, 18.1781}, // LAO
    Coordinate{-110.363, 24.0727}, // LAP
    Coordinate{21.9639, 32.7886}, // LAQ
    Coordinate{-105.675, 41.3119}, // LAR
    Coordinate{-115.152, 36.08}, // LAS
    Coordinate{40.9131, -2.25235}, // LAU
    Coordinate{-98.4164, 34.5678}, // LAW
    Coordinate{-118.408, 33.9425}, // LAX
    Coordinate{29.7526, -28.581}, // LAY
    Coordinate{-43.4078, -13.2617}, // LAZ
    Coordinate{-1.66056, 53.8658}, // LBA
    Coordinate{-101.821, 33.6636}, // LBB
    Coordinate{10.7192, 53.8053}, // LBC
    Coordinate{69.6947, 40.215}, // LBD
    Coordinate{-79.4067, 40.2747}, // LBE
    Coordinate{-100.684, 41.1261}, // LBF
    Coordinate{2.44139, 48.9694}, // LBG
    Coordinate{119.889, -8.48667}, // LBJ
    Coordinate{40.8817, 0.34833}, // LBK
    Coordinate{-100.96, 37.0442}, // LBL
    Coordinate{36.1042, 0.6661}, // LBN
    Coordinate{23.3783, -4.96667}, // LBO
    Coordinate{115.45, 3.18333}, // LBP
    Coordinate{10.2458, -0.704167}, // LBQ
    Coordinate{-64.7839, -7.25028}, // LBR
    Coordinate{179.34, -16.4668}, // LBS
    Coordinate{-79.0594, 34.6097}, // LBT
    Coordinate{115.25, 5.30056}, // LBU
    Coordinate{9.41222, 0.458611}, // LBV
    Coordinate{115.683, 3.86667}, // LBW
    Coordinate{120.103, 13.8565}, // LBX
    Coordinate{20.7328, -8.44153}, // LBZ
    Coordinate{33.6303, 34.8789}, // LCA
    Coordinate{-59.3853, -15.2308}, // LCB
    Coordinate{18.1333, 40.2392}, // LCC
    Coordinate{-86.8522, 15.7428}, // LCE
    Coordinate{-88.9611, 15.6681}, // LCF
    Coordinate{-8.37722, 43.3019}, // LCG
    Coordinate{-93.2233, 30.1261}, // LCH
    Coordinate{-71.4189, 43.5728}, // LCI
    Coordinate{19.3981, 51.7219}, // LCJ
    Coordinate{-82.9278, 39.8139}, // LCK
    Coordinate{-83.6422, 22.3361}, // LCL
    Coordinate{-64.5333, -31.0086}, // LCM
    Coordinate{14.5333, -2.45}, // LCO
    Coordinate{-82.5769, 30.1819}, // LCQ
    Coordinate{-72.8023, -1.45789}, // LCR
    Coordinate{10.5782, 43.8256}, // LCV
    Coordinate{116.746, 25.6742}, // LCX
    Coordinate{0.055278, 51.5053}, // LCY
    Coordinate{88.1306, 25}, // LDA
    Coordinate{-51.1367, -23.3303}, // LDB
    Coordinate{-0.00194444, 43.185}, // LDE
    Coordinate{45.7228, 64.8958}, // LDG
    Coordinate{159.077, -31.5383}, // LDH
    Coordinate{39.7586, -9.85}, // LDI
    Coordinate{-74.2447, 40.6175}, // LDJ
    Coordinate{13.1742, 58.4653}, // LDK
    Coordinate{-86.4078, 43.9625}, // LDM
    Coordinate{86.67, 27.2531}, // LDN
    Coordinate{-55.4075, 4.3754}, // LDO
    Coordinate{129.019, 47.7519}, // LDS
    Coordinate{118.324, 5.03222}, // LDU
    Coordinate{-54.0344, 5.48306}, // LDX
    Coordinate{-7.16194, 55.0428}, // LDY
    Coordinate{-72.3042, 43.6261}, // LEB
    Coordinate{-41.2769, -12.4833}, // LEC
    Coordinate{30.2625, 59.8003}, // LED
    Coordinate{-81.8087, 28.8231}, // LEE
    Coordinate{28.6556, -29.8908}, // LEF
    Coordinate{0.088055, 49.5339}, // LEH
    Coordinate{-2.37, 36.8439}, // LEI
    Coordinate{12.2364, 51.4239}, // LEJ
    Coordinate{-12.29, 11.3382}, // LEK
    Coordinate{135.805, -12.4983}, // LEL
    Coordinate{-5.65556, 42.5889}, // LEN
    Coordinate{-42.7331, -21.4719}, // LEP
    Coordinate{-5.67056, 50.1028}, // LEQ
    Coordinate{120.703, -27.8433}, // LER
    Coordinate{21.934, 43.0187}, // LES
    Coordinate{-69.9431, -4.19333}, // LET
    Coordinate{1.40917, 42.3386}, // LEU
    Coordinate{178.759, -17.7111}, // LEV
    Coordinate{-70.2836, 44.0486}, // LEW
    Coordinate{-84.6058, 38.0364}, // LEX
    Coordinate{5.52306, 52.4553}, // LEY
    Coordinate{-88.175, 14.2903}, // LEZ
    Coordinate{40.6667, -15.0333}, // LFB
    Coordinate{-94.75, 31.2339}, // LFK
    Coordinate{53.1881, 27.3727}, // LFM
    Coordinate{-78.3303, 36.0233}, // LFN
    Coordinate{111.497, 36.0431}, // LFQ
    Coordinate{-72.2711, 8.23917}, // LFR
    Coordinate{-91.9875, 30.2053}, // LFT
    Coordinate{1.25417, 6.16583}, // LFW
    Coordinate{-73.8726, 40.7772}, // LGA
    Coordinate{-118.152, 33.8178}, // LGB
    Coordinate{-85.0725, 33.0089}, // LGC
    Coordinate{-118.007, 45.2903}, // LGD
    Coordinate{127.619, -20.1089}, // LGE
    Coordinate{5.44417, 50.6378}, // LGG
    Coordinate{138.427, -30.9983}, // LGH
    Coordinate{-75.0942, 23.1789}, // LGI
    Coordinate{99.7286, 6.32972}, // LGK
    Coordinate{115.179, 3.45944}, // LGL
    Coordinate{-69.0008, -45.5822}, // LGM
    Coordinate{7.49867, 53.7428}, // LGO
    Coordinate{123.723, 13.1569}, // LGP
    Coordinate{-76.8694, 0.0925}, // LGQ
    Coordinate{-72.5877, -47.2437}, // LGR
    Coordinate{-69.5742, -35.4933}, // LGS
    Coordinate{-70.9264, 4.55}, // LGT
    Coordinate{-111.852, 41.7912}, // LGU
    Coordinate{-0.190278, 51.1472}, // LGW
    Coordinate{42.5458, 3.8125}, // LGX
    Coordinate{-1.13056, 52.4869}, // LHB
    Coordinate{-70.5083, -3.91686}, // LHC
    Coordinate{-149.972, 61.18}, // LHD
    Coordinate{74.4025, 31.5214}, // LHE
    Coordinate{147.984, -29.4567}, // LHG
    Coordinate{-121.351, 38.9092}, // LHM
    Coordinate{-0.461389, 51.4775}, // LHR
    Coordinate{-68.9653, -46.5384}, // LHS
    Coordinate{-77.4222, 41.1358}, // LHV
    Coordinate{103.619, 36.5075}, // LHW
    Coordinate{-103.51, 38.05}, // LHX
    Coordinate{107.786, 30.6794}, // LIA
    Coordinate{18.6333, 3.63333}, // LIE
    Coordinate{167.24, -20.775}, // LIF
    Coordinate{1.18028, 45.8608}, // LIG
    Coordinate{-159.339, 21.9761}, // LIH
    Coordinate{169.309, 9.82333}, // LIK
    Coordinate{3.08694, 50.5633}, // LIL
    Coordinate{-77.1144, -12.0219}, // LIM
    Coordinate{9.27833, 45.4494}, // LIN
    Coordinate{-83.0219, 9.95778}, // LIO
    Coordinate{-49.7311, -21.6628}, // LIP
    Coordinate{21.4833, 2.16667}, // LIQ
    Coordinate{-85.5442, 10.5931}, // LIR
    Coordinate{-9.13417, 38.7742}, // LIS
    Coordinate{-92.2195, 34.7308}, // LIT
    Coordinate{-102.387, 33.9239}, // LIU
    Coordinate{97.2147, 19.6914}, // LIW
    Coordinate{34.7372, -12.0758}, // LIX
    Coordinate{-67.8833, 46.95}, // LIZ
    Coordinate{23.4444, -3.41866}, // LJA
    Coordinate{100.246, 26.6792}, // LJG
    Coordinate{-95.4622, 29.1086}, // LJN
    Coordinate{14.4561, 46.2244}, // LJU
    Coordinate{123.002, -8.27454}, // LKA
    Coordinate{-178.817, -18.1992}, // LKB
    Coordinate{-122.339, 47.6289}, // LKE
    Coordinate{34.345, 4.20412}, // LKG
    Coordinate{114.783, 3.31306}, // LKH
    Coordinate{-155.121, 58.9819}, // LKK
    Coordinate{24.9739, 70.0667}, // LKL
    Coordinate{13.6094, 68.1525}, // LKN
    Coordinate{80.8833, 26.7619}, // LKO
    Coordinate{-73.9619, 44.2644}, // LKP
    Coordinate{-80.8547, 34.7228}, // LKR
    Coordinate{-120.399, 42.1611}, // LKV
    Coordinate{55.375, 22.8056}, // LKW
    Coordinate{35.8183, -3.37583}, // LKY
    Coordinate{22.1219, 65.5436}, // LLA
    Coordinate{107.962, 25.4525}, // LLB
    Coordinate{31.5658, -25.4736}, // LLE
    Coordinate{111.612, 26.3456}, // LLF
    Coordinate{102.917, -3.28}, // LLG
    Coordinate{-87.8986, 15.4431}, // LLH
    Coordinate{38.9911, 11.9739}, // LLI
    Coordinate{89.4331, 25.8875}, // LLJ
    Coordinate{48.8064, 38.7586}, // LLK
    Coordinate{120.245, -3.08472}, // LLO
    Coordinate{-91.7511, 33.6386}, // LLQ
    Coordinate{-123.754, 39.2619}, // LLR
    Coordinate{-60.5491, -24.7214}, // LLS
    Coordinate{13.5333, -12.3667}, // LLT
    Coordinate{-94.3114, 37.4894}, // LLU
    Coordinate{111.143, 37.6833}, // LLV
    Coordinate{33.7808, -13.7892}, // LLW
    Coordinate{-72.0181, 44.5692}, // LLX
    Coordinate{-74.8458, 39.9428}, // LLY
    Coordinate{34.5831, -13.7569}, // LMB
    Coordinate{-73.7875, 2.17917}, // LMC
    Coordinate{0.201667, 47.9486}, // LME
    Coordinate{166.266, 8.92167}, // LML
    Coordinate{-109.081, 25.6861}, // LMM
    Coordinate{115.01, 4.80806}, // LMN
    Coordinate{12.6181, 35.4978}, // LMP
    Coordinate{19.5764, 30.3781}, // LMQ
    Coordinate{23.4391, -28.3601}, // LMR
    Coordinate{-89.0614, 33.1447}, // LMS
    Coordinate{-121.733, 42.1561}, // LMT
    Coordinate{141.493, -7.0094}, // LMY
    Coordinate{-80.085, 26.5931}, // LNA
    Coordinate{168.16, -16.585}, // LNB
    Coordinate{-96.7175, 32.5775}, // LNC
    Coordinate{-108.73, 42.8152}, // LND
    Coordinate{168.172, -15.8647}, // LNE
    Coordinate{-153.242, 70.9108}, // LNI
    Coordinate{100.025, 23.7383}, // LNJ
    Coordinate{-89.2119, 46.1539}, // LNL
    Coordinate{-81.3897, 41.6839}, // LNN
    Coordinate{121.315, -28.8781}, // LNO
    Coordinate{-82.53, 36.9875}, // LNP
    Coordinate{-90.1797, 43.2119}, // LNR
    Coordinate{-76.2944, 40.1222}, // LNS
    Coordinate{152.628, -3.0424}, // LNV
    Coordinate{32.025, 54.825}, // LNX
    Coordinate{-156.951, 20.7856}, // LNY
    Coordinate{14.1875, 48.2333}, // LNZ
    Coordinate{-70.6481, -32.8144}, // LOB
    Coordinate{167.968, -15.3058}, // LOD
    Coordinate{101.722, 17.4392}, // LOE
    Coordinate{-79.3719, -3.99583}, // LOH
    Coordinate{-49.5433, -27.1603}, // LOI
    Coordinate{35.6086, 3.12222}, // LOK
    Coordinate{-118.565, 40.0664}, // LOL
    Coordinate{-101.944, 21.2592}, // LOM
    Coordinate{106.818, 10.9754}, // LON
    Coordinate{2.92833, 33.7644}, // LOO
    Coordinate{116.277, -8.75732}, // LOP
    Coordinate{25.7139, -25.1975}, // LOQ
    Coordinate{3.32111, 6.57722}, // LOS
    Coordinate{-88.0961, 41.6072}, // LOT
    Coordinate{-85.6636, 38.2281}, // LOU
    Coordinate{-101.47, 26.9558}, // LOV
    Coordinate{-77.97, 38.0097}, // LOW
    Coordinate{36.7167, 2.74706}, // LOY
    Coordinate{-84.0775, 37.0869}, // LOZ
    Coordinate{-15.3867, 27.9319}, // LPA
    Coordinate{-68.1922, -16.5133}, // LPB
    Coordinate{-120.468, 34.6656}, // LPC
    Coordinate{-69.5794, -1.33167}, // LPD
    Coordinate{-70.4206, 5.47917}, // LPE
    Coordinate{104.979, 26.6064}, // LPF
    Coordinate{-57.8947, -34.9722}, // LPG
    Coordinate{15.6728, 58.4083}, // LPI
    Coordinate{39.5383, 52.7033}, // LPK
    Coordinate{-2.84972, 53.3336}, // LPL
    Coordinate{167.817, -16.45}, // LPM
    Coordinate{-86.7344, 41.5725}, // LPO
    Coordinate{28.1486, 61.0458}, // LPP
    Coordinate{102.162, 19.8986}, // LPQ
    Coordinate{-82.1776, 41.3443}, // LPR
    Coordinate{-122.918, 48.5164}, // LPS
    Coordinate{99.5042, 18.2709}, // LPT
    Coordinate{114.97, 1.70361}, // LPU
    Coordinate{21.0969, 56.5175}, // LPX
    Coordinate{3.76333, 45.0797}, // LPY
    Coordinate{-82.7028, 34.81}, // LQK
    Coordinate{-74.775, -0.182222}, // LQM
    Coordinate{63.1176, 34.9857}, // LQN
    Coordinate{22.4486, 39.6486}, // LRA
    Coordinate{28.0528, -28.8556}, // LRB
    Coordinate{-99.4617, 27.5439}, // LRD
    Coordinate{144.28, -23.4342}, // LRE
    Coordinate{-68.5347, 45.3622}, // LRG
    Coordinate{-1.19528, 46.1792}, // LRH
    Coordinate{-96.1936, 42.7781}, // LRJ
    Coordinate{1.09278, 9.76963}, // LRL
    Coordinate{-68.9117, 18.4511}, // LRM
    Coordinate{-79.7828, 32.8978}, // LRO
    Coordinate{-101.304, 56.2486}, // LRQ
    Coordinate{54.3814, 27.6731}, // LRR
    Coordinate{26.8003, 37.1847}, // LRS
    Coordinate{-3.44, 47.7606}, // LRT
    Coordinate{-106.922, 32.2894}, // LRU
    Coordinate{-66.6717, 11.9458}, // LRV
    Coordinate{151.08, -8.5051}, // LSA
    Coordinate{-71.1994, -29.9161}, // LSC
    Coordinate{-91.2567, 43.8792}, // LSE
    Coordinate{97.7525, 22.9758}, // LSH
    Coordinate{-1.29389, 59.8814}, // LSI
    Coordinate{-84.7, 11.0333}, // LSL
    Coordinate{115.583, 4.21639}, // LSM
    Coordinate{-120.869, 37.0628}, // LSN
    Coordinate{-1.725, 46.4756}, // LSO
    Coordinate{-70.1514, 11.7808}, // LSP
    Coordinate{-72.4256, -37.4019}, // LSQ
    Coordinate{-167.163, 65.3961}, // LSR
    Coordinate{-61.5806, 15.8644}, // LSS
    Coordinate{147.214, -41.5453}, // LST
    Coordinate{115.494, 4.55222}, // LSU
    Coordinate{96.9503, 5.22667}, // LSW
    Coordinate{153.26, -28.8303}, // LSY
    Coordinate{14.3931, 44.5658}, // LSZ
    Coordinate{30.3293, -23.8244}, // LTA
    Coordinate{16.3, 9.4}, // LTC
    Coordinate{9.71533, 30.1517}, // LTD
    Coordinate{96.2192, 46.3758}, // LTI
    Coordinate{35.9486, 35.4008}, // LTK
    Coordinate{12.7486, -0.825}, // LTL
    Coordinate{-59.7961, 3.36889}, // LTM
    Coordinate{-0.368333, 51.8747}, // LTN
    Coordinate{-111.348, 25.9892}, // LTO
    Coordinate{1.6275, 50.5147}, // LTQ
    Coordinate{6.4816, 43.2054}, // LTT
    Coordinate{76.4642, 18.4117}, // LTU
    Coordinate{-76.55, 38.3153}, // LTW
    Coordinate{-78.6158, -0.906944}, // LTX
    Coordinate{-110.991, 48.5108}, // LTY
    Coordinate{86.7314, 27.6875}, // LUA
    Coordinate{-59.4333, 2.4}, // LUB
    Coordinate{-179.667, -16.7481}, // LUC
    Coordinate{15.2428, -26.6875}, // LUD
    Coordinate{8.91028, 46.0036}, // LUG
    Coordinate{75.9525, 30.8526}, // LUH
    Coordinate{-86.6925, 15.0333}, // LUI
    Coordinate{-84.4186, 39.1033}, // LUK
    Coordinate{-89.1728, 31.6731}, // LUL
    Coordinate{98.5478, 24.4}, // LUM
    Coordinate{28.4525, -15.3306}, // LUN
    Coordinate{19.8899, -11.7711}, // LUO
    Coordinate{-156.974, 21.2111}, // LUP
    Coordinate{-66.3522, -33.2772}, // LUQ
    Coordinate{-166.111, 68.875}, // LUR
    Coordinate{18.7167, -4.8}, // LUS
    Coordinate{144.45, -15.55}, // LUU
    Coordinate{132.759, -5.75917}, // LUV
    Coordinate{122.761, -1.03778}, // LUW
    Coordinate{6.20444, 49.6233}, // LUX
    Coordinate{22.6903, 51.2319}, // LUZ
    Coordinate{-0.74278, 48.0322}, // LVA
    Coordinate{-55.6247, -30.8358}, // LVB
    Coordinate{25.8186, -17.8217}, // LVI
    Coordinate{-121.82, 37.6934}, // LVK
    Coordinate{-110.448, 45.6994}, // LVM
    Coordinate{-93.2281, 44.6278}, // LVN
    Coordinate{122.423, -28.6136}, // LVO
    Coordinate{53.3561, 26.8103}, // LVP
    Coordinate{-55.9422, -13.0372}, // LVR
    Coordinate{-105.143, 35.6542}, // LVS
    Coordinate{-80.3994, 37.8583}, // LWB
    Coordinate{-95.2164, 39.0111}, // LWC
    Coordinate{122.237, -8.64056}, // LWE
    Coordinate{-1.24361, 60.1919}, // LWK
    Coordinate{-114.922, 41.1172}, // LWL
    Coordinate{-71.1233, 42.7172}, // LWM
    Coordinate{43.8592, 40.7503}, // LWN
    Coordinate{23.9561, 49.8125}, // LWO
    Coordinate{-117.015, 46.3744}, // LWS
    Coordinate{-109.467, 47.0492}, // LWT
    Coordinate{-87.6056, 38.7642}, // LWV
    Coordinate{115.403, 4.84917}, // LWY
    Coordinate{90.9119, 29.2978}, // LXA
    Coordinate{101.402, 20.9606}, // LXG
    Coordinate{-94.3475, 45.9497}, // LXL
    Coordinate{-99.7758, 40.7906}, // LXN
    Coordinate{32.7064, 25.6708}, // LXR
    Coordinate{25.2363, 39.9171}, // LXS
    Coordinate{23.25, -14.375}, // LXU
    Coordinate{-106.317, 39.2203}, // LXV
    Coordinate{112.388, 34.7413}, // LYA
    Coordinate{-80.1, 19.6667}, // LYB
    Coordinate{18.7161, 64.5481}, // LYC
    Coordinate{118.874, 34.5717}, // LYG
    Coordinate{-79.2011, 37.3253}, // LYH
    Coordinate{118.412, 35.0461}, // LYI
    Coordinate{1.01667, 51.0833}, // LYM
    Coordinate{4.93889, 45.7294}, // LYN
    Coordinate{72.9947, 31.365}, // LYP
    Coordinate{15.4656, 78.2461}, // LYR
    Coordinate{5.08111, 45.7256}, // LYS
    Coordinate{-91.8308, 47.8244}, // LYU
    Coordinate{0.939167, 50.9561}, // LYX
    Coordinate{22.4, -7.18333}, // LZA
    Coordinate{-102.22, 17.9833}, // LZC
    Coordinate{-71.9011, 41.8197}, // LZD
    Coordinate{109.391, 24.2075}, // LZH
    Coordinate{18.0493, -9.11596}, // LZM
    Coordinate{119.958, 26.1597}, // LZN
    Coordinate{105.391, 28.8528}, // LZO
    Coordinate{145.453, -14.6767}, // LZR
    Coordinate{-83.9625, 33.9781}, // LZU
    Coordinate{94.3353, 29.3033}, // LZY
    Coordinate{80.1636, 12.9822}, // MAA
    Coordinate{-49.1383, -5.36778}, // MAB
    Coordinate{-83.5619, 32.8222}, // MAC
    Coordinate{-3.56083, 40.4722}, // MAD
    Coordinate{-120.113, 36.9886}, // MAE
    Coordinate{-102.202, 31.9425}, // MAF
    Coordinate{145.783, -5.20833}, // MAG
    Coordinate{4.21861, 39.8625}, // MAH
    Coordinate{35.2625, -14.4889}, // MAI
    Coordinate{171.272, 7.06498}, // MAJ
    Coordinate{31.6522, 9.55889}, // MAK
    Coordinate{-74.3289, 44.8536}, // MAL
    Coordinate{-97.5253, 25.7699}, // MAM
    Coordinate{-2.275, 53.3539}, // MAN
    Coordinate{-60.0506, -3.04111}, // MAO
    Coordinate{98.5436, 16.6997}, // MAQ
    Coordinate{-71.7278, 10.5581}, // MAR
    Coordinate{147.424, -2.06194}, // MAS
    Coordinate{13.4417, -5.79833}, // MAT
    Coordinate{-152.243, -16.4264}, // MAU
    Coordinate{171.231, 8.705}, // MAV
    Coordinate{-89.9925, 36.5983}, // MAW
    Coordinate{-13.3228, 15.5936}, // MAX
    Coordinate{-77.6847, 24.2833}, // MAY
    Coordinate{-67.1485, 18.2557}, // MAZ
    Coordinate{39.5942, -4.03472}, // MBA
    Coordinate{11.9125, -1.89306}, // MBC
    Coordinate{25.5444, -25.8075}, // MBD
    Coordinate{143.404, 44.3042}, // MBE
    Coordinate{-100.406, 45.5464}, // MBG
    Coordinate{152.715, -25.5133}, // MBH
    Coordinate{33.4622, -8.91861}, // MBI
    Coordinate{-77.9133, 18.5036}, // MBJ
    Coordinate{-54.9528, -10.1703}, // MBK
    Coordinate{-86.2469, 44.2725}, // MBL
    Coordinate{120.605, 13.2051}, // MBO
    Coordinate{-76.9883, -6.01889}, // MBP
    Coordinate{30.6, -0.555}, // MBQ
    Coordinate{-84.0797, 43.5328}, // MBS
    Coordinate{123.627, 12.3671}, // MBT
    Coordinate{159.839, -9.7475}, // MBU
    Coordinate{145.102, -37.9758}, // MBW
    Coordinate{15.6861, 46.48}, // MBX
    Coordinate{125.117, 8.14056}, // MBY
    Coordinate{-57.7122, -3.35695}, // MBZ
    Coordinate{-9.467, 8.533}, // MCA
    Coordinate{-90.4719, 31.1783}, // MCB
    Coordinate{-121.401, 38.6678}, // MCC
    Coordinate{-84.6372, 45.865}, // MCD
    Coordinate{-120.514, 37.2847}, // MCE
    Coordinate{-155.606, 62.9528}, // MCG
    Coordinate{-79.9614, -3.26889}, // MCH
    Coordinate{-94.7139, 39.2975}, // MCI
    Coordinate{-72.4933, 11.2325}, // MCJ
    Coordinate{-100.592, 40.2064}, // MCK
    Coordinate{-148.911, 63.7325}, // MCL
    Coordinate{-83.6492, 32.6928}, // MCN
    Coordinate{-81.3089, 28.4294}, // MCO
    Coordinate{-51.0703, 0.05083}, // MCP
    Coordinate{20.79, 48.1378}, // MCQ
    Coordinate{-57.6403, -30.2719}, // MCS
    Coordinate{58.2817, 23.5928}, // MCT
    Coordinate{2.36278, 46.2261}, // MCU
    Coordinate{136.075, -16.445}, // MCV
    Coordinate{-93.3311, 43.1578}, // MCW
    Coordinate{47.6523, 42.8168}, // MCX
    Coordinate{153.092, -26.6033}, // MCY
    Coordinate{-35.7836, -9.51722}, // MCZ
    Coordinate{-88.3042, 17.0045}, // MDB
    Coordinate{124.926, 1.54917}, // MDC
    Coordinate{-102.101, 32.0367}, // MDD
    Coordinate{-75.4267, 6.16722}, // MDE
    Coordinate{-90.3008, 45.1014}, // MDF
    Coordinate{129.569, 44.5242}, // MDG
    Coordinate{-89.2519, 37.7781}, // MDH
    Coordinate{8.61389, 7.70361}, // MDI
    Coordinate{-121.155, 44.6703}, // MDJ
    Coordinate{18.2886, 0.0225}, // MDK
    Coordinate{95.9781, 21.7022}, // MDL
    Coordinate{-85.4647, 38.76}, // MDN
    Coordinate{-146.307, 59.4497}, // MDO
    Coordinate{-57.5733, -37.9342}, // MDQ
    Coordinate{-71.8025, 21.8258}, // MDS
    Coordinate{-76.7633, 40.1931}, // MDT
    Coordinate{143.657, -6.14774}, // MDU
    Coordinate{10.7556, 1.00694}, // MDV
    Coordinate{-87.7525, 41.7861}, // MDW
    Coordinate{-58.087, -29.2261}, // MDX
    Coordinate{-177.381, 28.2014}, // MDY
    Coordinate{-68.7928, -32.8317}, // MDZ
    Coordinate{-52.5561, -17.5519}, // MEA
    Coordinate{144.901, -37.7297}, // MEB
    Coordinate{-80.6786, -0.945833}, // MEC
    Coordinate{39.7058, 24.5503}, // MED
    Coordinate{168.038, -21.4814}, // MEE
    Coordinate{17.95, 11.05}, // MEF
    Coordinate{16.3124, -9.52492}, // MEG
    Coordinate{27.8264, 71.0289}, // MEH
    Coordinate{-88.7425, 32.3372}, // MEI
    Coordinate{-80.2147, 41.6267}, // MEJ
    Coordinate{144.843, -37.6733}, // MEL
    Coordinate{-89.9767, 35.0425}, // MEM
    Coordinate{3.52743, 44.5042}, // MEN
    Coordinate{-75.6956, 35.9189}, // MEO
    Coordinate{103.876, 2.3864}, // MEP
    Coordinate{96.2508, 4.04372}, // MEQ
    Coordinate{-120.568, 37.3806}, // MER
    Coordinate{-52.6022, -0.889722}, // MEU
    Coordinate{-119.752, 39.0008}, // MEV
    Coordinate{21.5417, -4.855}, // MEW
    Coordinate{-99.0719, 19.4361}, // MEX
    Coordinate{84.2289, 27.5772}, // MEY
    Coordinate{-94.2028, 34.5453}, // MEZ
    Coordinate{39.6683, -7.9175}, // MFA
    Coordinate{27.2433, -29.8289}, // MFC
    Coordinate{-82.5167, 40.8214}, // MFD
    Coordinate{-98.2386, 26.1758}, // MFE
    Coordinate{13.2694, -1.53778}, // MFF
    Coordinate{73.5086, 34.339}, // MFG
    Coordinate{-114.055, 36.835}, // MFH
    Coordinate{-90.1894, 44.6369}, // MFI
    Coordinate{179.951, -18.5669}, // MFJ
    Coordinate{120.003, 26.2239}, // MFK
    Coordinate{113.591, 22.1494}, // MFM
    Coordinate{167.923, -44.6733}, // MFN
    Coordinate{151.792, -5.5825}, // MFO
    Coordinate{7.1202, 13.5008}, // MFQ
    Coordinate{-122.874, 42.3742}, // MFR
    Coordinate{-71.9444, 1.35}, // MFS
    Coordinate{31.9333, -13.2667}, // MFU
    Coordinate{-75.7608, 37.6467}, // MFV
    Coordinate{6.5775, 45.4075}, // MFX
    Coordinate{-86.1681, 12.1414}, // MGA
    Coordinate{140.785, -37.7456}, // MGB
    Coordinate{-86.8211, 41.7033}, // MGC
    Coordinate{-64.1366, -13.3084}, // MGD
    Coordinate{-74.8461, 9.11807}, // MGE
    Coordinate{-52.0122, -23.4794}, // MGF
    Coordinate{-93.9856, 45.2361}, // MGG
    Coordinate{30.3431, -30.8594}, // MGH
    Coordinate{-58.2469, -34.1819}, // MGI
    Coordinate{-74.2647, 41.51}, // MGJ
    Coordinate{6.50444, 51.2303}, // MGL
    Coordinate{-86.3939, 32.3006}, // MGM
    Coordinate{-74.8667, 9.28333}, // MGN
    Coordinate{45.3047, 2.01361}, // MGQ
    Coordinate{-83.8033, 31.085}, // MGR
    Coordinate{134.894, -12.0944}, // MGT
    Coordinate{126.874, -18.6243}, // MGV
    Coordinate{-79.9164, 39.6428}, // MGW
    Coordinate{11, -2.43333}, // MGX
    Coordinate{-84.225, 39.5889}, // MGY
    Coordinate{98.6214, 12.4397}, // MGZ
    Coordinate{-59.1511, 5.26667}, // MHA
    Coordinate{-73.7158, -42.3404}, // MHC
    Coordinate{59.645, 36.2342}, // MHD
    Coordinate{-98.0386, 43.7747}, // MHE
    Coordinate{-77.0836, 26.5114}, // MHH
    Coordinate{43.2, 11.7167}, // MHI
    Coordinate{-96.6717, 39.1411}, // MHK
    Coordinate{-93.2028, 39.0956}, // MHL
    Coordinate{-152.302, 63.8861}, // MHM
    Coordinate{27.5397, 53.8644}, // MHP
    Coordinate{19.8964, 60.1219}, // MHQ
    Coordinate{-121.298, 38.5539}, // MHR
    Coordinate{-122.272, 41.2631}, // MHS
    Coordinate{-71.4372, 42.9278}, // MHT
    Coordinate{147.334, -37.0475}, // MHU
    Coordinate{-118.152, 35.0594}, // MHV
    Coordinate{-63.9624, -19.8238}, // MHW
    Coordinate{-161, -10.3806}, // MHX
    Coordinate{-80.2906, 25.7933}, // MIA
    Coordinate{-93.3539, 45.0619}, // MIC
    Coordinate{-89.6578, 20.9369}, // MID
    Coordinate{-85.3958, 40.2422}, // MIE
    Coordinate{104.74, 31.43}, // MIG
    Coordinate{-49.9269, -22.1956}, // MII
    Coordinate{171.731, 6.085}, // MIJ
    Coordinate{27.2, 61.6864}, // MIK
    Coordinate{149.901, -36.9086}, // MIM
    Coordinate{-94.8875, 36.9092}, // MIO
    Coordinate{34.8067, 30.6522}, // MIP
    Coordinate{-96.1122, 41.1961}, // MIQ
    Coordinate{10.7547, 35.7581}, // MIR
    Coordinate{152.838, -10.6891}, // MIS
    Coordinate{-119.192, 35.5058}, // MIT
    Coordinate{13.0808, 11.8553}, // MIU
    Coordinate{-75.0722, 39.3678}, // MIV
    Coordinate{44.3167, -21.4167}, // MJA
    Coordinate{170.869, 10.2833}, // MJB
    Coordinate{-7.58722, 7.26667}, // MJC
    Coordinate{68.1431, 27.3352}, // MJD
    Coordinate{168.264, 7.76222}, // MJE
    Coordinate{13.2149, 65.7836}, // MJF
    Coordinate{13.2778, 32.8944}, // MJI
    Coordinate{113.577, -25.8933}, // MJK
    Coordinate{11.0578, -1.85}, // MJL
    Coordinate{23.5667, -6.12111}, // MJM
    Coordinate{46.3511, -15.6669}, // MJN
    Coordinate{16.4528, -21.0231}, // MJO
    Coordinate{116.14, -34.2653}, // MJP
    Coordinate{-94.9867, 43.65}, // MJQ
    Coordinate{-57.871, -38.2258}, // MJR
    Coordinate{26.5979, 39.0567}, // MJT
    Coordinate{119.03, -2.58673}, // MJU
    Coordinate{-0.812222, 37.7747}, // MJV
    Coordinate{-74.2925, 39.9275}, // MJX
    Coordinate{114.022, 62.5344}, // MJZ
    Coordinate{12.7166, 49.9228}, // MKA
    Coordinate{13.9681, 0.977778}, // MKB
    Coordinate{-94.5928, 39.1233}, // MKC
    Coordinate{-87.8967, 42.9472}, // MKE
    Coordinate{-86.2356, 43.1678}, // MKG
    Coordinate{29.0722, -29.2817}, // MKH
    Coordinate{26.4833, 5.4}, // MKI
    Coordinate{15.5821, -0.019055}, // MKJ
    Coordinate{-157.096, 21.1528}, // MKK
    Coordinate{-88.9156, 35.5997}, // MKL
    Coordinate{112.064, 2.89985}, // MKM
    Coordinate{-98.5992, 31.9203}, // MKN
    Coordinate{-95.3617, 35.6578}, // MKO
    Coordinate{140.418, -8.52028}, // MKQ
    Coordinate{118.548, -26.6117}, // MKR
    Coordinate{38.7414, 10.7244}, // MKS
    Coordinate{-93.9186, 44.2217}, // MKT
    Coordinate{12.8908, 0.579167}, // MKU
    Coordinate{134.049, -0.891667}, // MKW
    Coordinate{149.18, -21.1717}, // MKY
    Coordinate{102.251, 2.26333}, // MKZ
    Coordinate{14.4775, 35.8575}, // MLA
    Coordinate{-80.6453, 28.1028}, // MLB
    Coordinate{-95.7833, 34.8825}, // MLC
    Coordinate{73.5291, 4.19183}, // MLE
    Coordinate{112.714, -7.92639}, // MLG
    Coordinate{7.52917, 47.59}, // EAP
    Coordinate{-90.5075, 41.4486}, // MLI
    Coordinate{-83.2414, 33.1542}, // MLJ
    Coordinate{-107.919, 48.3669}, // MLK
    Coordinate{-162.026, 61.8642}, // MLL
    Coordinate{-101.025, 19.8497}, // MLM
    Coordinate{-2.95639, 35.2797}, // MLN
    Coordinate{24.475, 36.6961}, // MLO
    Coordinate{124.058, 7.61667}, // MLP
    Coordinate{-105.886, 46.4281}, // MLS
    Coordinate{-68.6856, 45.6478}, // MLT
    Coordinate{-92.0377, 32.5109}, // MLU
    Coordinate{-10.7586, 6.28917}, // MLW
    Coordinate{-150.644, 64.9975}, // MLY
    Coordinate{-54.2217, -32.3425}, // MLZ
    Coordinate{13.0597, 55.605}, // MMA
    Coordinate{144.164, 43.8806}, // MMB
    Coordinate{-99.0181, 22.7403}, // MMC
    Coordinate{131.264, 25.8467}, // MMD
    Coordinate{-1.42944, 54.5092}, // MME
    Coordinate{9.30361, 5.70417}, // MMF
    Coordinate{117.842, -28.1161}, // MMG
    Coordinate{-118.839, 37.6242}, // MMH
    Coordinate{-84.5625, 35.3972}, // MMI
    Coordinate{137.923, 36.1667}, // MMJ
    Coordinate{32.7559, 68.7838}, // MMK
    Coordinate{-95.8219, 44.4505}, // MML
    Coordinate{148.705, -22.8033}, // MMM
    Coordinate{-71.5178, 42.4606}, // MMN
    Coordinate{-23.2136, 15.1558}, // MMO
    Coordinate{-74.4378, 9.25972}, // MMP
    Coordinate{31.3333, -8.85833}, // MMQ
    Coordinate{-80.8011, 33.9208}, // MMT
    Coordinate{-74.415, 40.7994}, // MMU
    Coordinate{-123.136, 45.1944}, // MMV
    Coordinate{13.3714, 55.53}, // MMX
    Coordinate{125.295, 24.7828}, // MMY
    Coordinate{64.7609, 35.9307}, // MMZ
    Coordinate{126.673, 4.00694}, // MNA
    Coordinate{12.35, -5.93333}, // MNB
    Coordinate{40.7122, -14.4881}, // MNC
    Coordinate{177.098, -17.6731}, // MNF
    Coordinate{134.234, -12.0561}, // MNG
    Coordinate{80.9817, 8.053}, // MNH
    Coordinate{-62.1933, 16.7914}, // MNI
    Coordinate{48.3556, -21.2061}, // MNJ
    Coordinate{173.031, 1.00359}, // MNK
    Coordinate{121.019, 14.5086}, // MNL
    Coordinate{-87.6383, 45.1267}, // MNM
    Coordinate{-83.0633, 40.6161}, // MNN
    Coordinate{151.1, -24.8867}, // MNQ
    Coordinate{23.1528, -15.2544}, // MNR
    Coordinate{28.857, -11.1381}, // MNS
    Coordinate{-149.369, 65.1481}, // MNT
    Coordinate{97.6572, 16.4405}, // MNU
    Coordinate{-84.3803, 35.5453}, // MNV
    Coordinate{-61.2839, -5.81695}, // MNX
    Coordinate{155.565, -7.41611}, // MNY
    Coordinate{-77.5156, 38.7214}, // MNZ
    Coordinate{-74.9222, 20.6539}, // MOA
    Coordinate{-88.2428, 30.6914}, // MOB
    Coordinate{-43.8219, -16.7061}, // MOC
    Coordinate{-120.954, 37.6258}, // MOD
    Coordinate{96.6531, 23.0919}, // MOE
    Coordinate{120.833, -8.64056}, // MOF
    Coordinate{99.2567, 20.5167}, // MOG
    Coordinate{-157.703, -19.8427}, // MOI
    Coordinate{-54.4003, 5.6076}, // MOJ
    Coordinate{7.2625, 62.7447}, // MOL
    Coordinate{-12.5, 17.75}, // MOM
    Coordinate{170.128, -43.9067}, // MON
    Coordinate{140.197, -28.1}, // MOO
    Coordinate{-84.7375, 43.6217}, // MOP
    Coordinate{44.3174, -20.2848}, // MOQ
    Coordinate{-83.3756, 36.1794}, // MOR
    Coordinate{-162.057, 64.6981}, // MOS
    Coordinate{-101.28, 48.2594}, // MOT
    Coordinate{-163.682, 62.0953}, // MOU
    Coordinate{148.077, -22.0578}, // MOV
    Coordinate{-149.762, -17.4894}, // MOZ
    Coordinate{24.1764, -17.6342}, // MPA
    Coordinate{-80.1703, 25.7783}, // MPB
    Coordinate{69.0333, 25.6836}, // MPD
    Coordinate{-72.5497, 41.2711}, // MPE
    Coordinate{-80.7358, 39.8808}, // MPG
    Coordinate{121.955, 11.9247}, // MPH
    Coordinate{-92.9092, 35.1389}, // MPJ
    Coordinate{126.38, 34.7589}, // MPK
    Coordinate{3.96139, 43.5833}, // MPL
    Coordinate{32.5725, -25.9208}, // MPM
    Coordinate{-75.38, 41.1378}, // MPO
    Coordinate{-77.7331, 8.94528}, // MPP
    Coordinate{-94.9617, 33.0969}, // MPS
    Coordinate{-72.5622, 44.2036}, // MPV
    Coordinate{37.4564, 47.0725}, // MPW
    Coordinate{-54.0394, 3.65556}, // MPY
    Coordinate{-91.5111, 40.9467}, // MPZ
    Coordinate{-90.6525, 40.52}, // MQB
    Coordinate{-56.3844, 47.0958}, // MQC
    Coordinate{-68.7333, -41.25}, // MQD
    Coordinate{58.7567, 53.3933}, // MQF
    Coordinate{-48.2006, -13.5506}, // MQH
    Coordinate{143.263, 66.45}, // MQJ
    Coordinate{-58.4015, -16.3379}, // MQK
    Coordinate{142.086, -34.2292}, // MQL
    Coordinate{40.6317, 37.2233}, // MQM
    Coordinate{14.3017, 66.3639}, // MQN
    Coordinate{31.0993, -25.3916}, // MQP
    Coordinate{16.0714, 8.62417}, // MQQ
    Coordinate{-61.1803, 12.8877}, // MQS
    Coordinate{-87.3953, 46.3536}, // MQT
    Coordinate{-74.8837, 5.2125}, // MQU
    Coordinate{0.148997, 35.9089}, // MQV
    Coordinate{-82.8794, 32.0969}, // MQW
    Coordinate{39.5333, 13.4672}, // MQX
    Coordinate{-86.52, 36.0089}, // MQY
    Coordinate{115.099, -33.9304}, // MQZ
    Coordinate{15.0597, 32.3256}, // MRA
    Coordinate{-77.9847, 39.4019}, // MRB
    Coordinate{-87.1792, 35.5544}, // MRC
    Coordinate{-71.1611, 8.58222}, // MRD
    Coordinate{35.0081, -1.40611}, // MRE
    Coordinate{-104.018, 30.3711}, // MRF
    Coordinate{145.419, -17.0692}, // MRG
    Coordinate{-76.6606, 34.7336}, // MRH
    Coordinate{-149.844, 61.2136}, // MRI
    Coordinate{-88.0333, 14.15}, // MRJ
    Coordinate{-81.6725, 25.995}, // MRK
    Coordinate{-81.6114, 35.8203}, // MRN
    Coordinate{175.633, -40.975}, // MRO
    Coordinate{121.825, 13.36}, // MRQ
    Coordinate{-79.9408, -4.37806}, // MRR
    Coordinate{5.215, 43.4367}, // MRS
    Coordinate{-83.3517, 40.2247}, // MRT
    Coordinate{57.683, -20.43}, // MRU
    Coordinate{43.0833, 44.225}, // MRV
    Coordinate{11.44, 54.6993}, // MRW
    Coordinate{49.1506, 30.5562}, // MRX
    Coordinate{-121.843, 36.5869}, // MRY
    Coordinate{149.845, -29.4989}, // MRZ
    Coordinate{-91.7628, 53.4414}, // MSA
    Coordinate{-111.728, 33.4608}, // MSC
    Coordinate{-111.476, 39.5267}, // MSD
    Coordinate{1.34611, 51.3422}, // MSE
    Coordinate{134.917, -22.6667}, // MSF
    Coordinate{28.8092, -29.8136}, // MSG
    Coordinate{141.372, 40.7053}, // MSJ
    Coordinate{-87.6103, 34.7453}, // MSL
    Coordinate{17.85, -4.78333}, // MSM
    Coordinate{124.783, 10.1871}, // MSN
    Coordinate{-114.091, 46.9164}, // MSO
    Coordinate{-93.2217, 44.8819}, // MSP
    Coordinate{28.0325, 53.8825}, // MSQ
    Coordinate{-74.8456, 44.9358}, // MSS
    Coordinate{5.76954, 50.9126}, // MST
    Coordinate{27.5525, -29.4622}, // MSU
    Coordinate{-74.795, 41.7017}, // MSV
    Coordinate{39.368, 15.6711}, // MSW
    Coordinate{12.7, -2.95}, // MSX
    Coordinate{-90.2581, 29.9933}, // MSY
    Coordinate{12.1667, -15.2167}, // MSZ
    Coordinate{175.74, -37.7344}, // MTA
    Coordinate{-75.4325, 7.97167}, // MTB
    Coordinate{35.5333, 6.96667}, // MTF
    Coordinate{-59.9672, -15.0153}, // MTG
    Coordinate{-81.0514, 24.7261}, // MTH
    Coordinate{-24.34, 15.045}, // MTI
    Coordinate{-107.894, 38.5098}, // MTJ
    Coordinate{172.992, 3.37411}, // MTK
    Coordinate{151.488, -32.7033}, // MTL
    Coordinate{-131.578, 55.1311}, // MTM
    Coordinate{-76.4139, 39.3256}, // MTN
    Coordinate{-88.2792, 39.4781}, // MTO
    Coordinate{-71.9206, 41.0767}, // MTP
    Coordinate{147.937, -26.4833}, // MTQ
    Coordinate{-75.8258, 8.82361}, // MTR
    Coordinate{31.3078, -26.5286}, // MTS
    Coordinate{-94.5808, 18.1036}, // MTT
    Coordinate{167.711, -13.6658}, // MTV
    Coordinate{-87.6806, 44.1289}, // MTW
    Coordinate{-100.106, 25.7783}, // MTY
    Coordinate{35.3886, 31.3282}, // MTZ
    Coordinate{157.263, -8.32797}, // MUA
    Coordinate{23.4281, -19.9725}, // MUB
    Coordinate{11.7861, 48.3539}, // MUC
    Coordinate{39.5631, -11.6729}, // MUD
    Coordinate{-155.668, 20.0014}, // MUE
    Coordinate{-111.971, 26.9058}, // MUG
    Coordinate{27.2217, 31.3253}, // MUH
    Coordinate{35.7486, 5.86389}, // MUJ
    Coordinate{-83.7042, 31.1378}, // MUL
    Coordinate{-63.1533, 9.74917}, // MUN
    Coordinate{114.322, 4.1775}, // MUR
    Coordinate{153.979, 24.2897}, // MUS
    Coordinate{-91.1483, 41.3678}, // MUT
    Coordinate{0.147142, 35.2077}, // MUW
    Coordinate{71.4192, 30.2033}, // MUX
    Coordinate{13.9167, -4.01472}, // MUY
    Coordinate{33.8022, -1.50278}, // MUZ
    Coordinate{-16.9181, 65.6558}, // MVA
    Coordinate{13.4347, -1.65611}, // MVB
    Coordinate{-87.3511, 31.4581}, // MVC
    Coordinate{-56.0308, -34.8383}, // MVD
    Coordinate{-95.712, 44.9714}, // MVE
    Coordinate{-37.3617, -5.19583}, // MVF
    Coordinate{-72.6139, 44.5347}, // MVL
    Coordinate{-110.228, 36.7164}, // MVM
    Coordinate{-88.8586, 38.3233}, // MVN
    Coordinate{18.6775, 12.1719}, // MVO
    Coordinate{-70.2341, 1.25353}, // MVP
    Coordinate{30.095, 53.955}, // MVQ
    Coordinate{14.2531, 10.4514}, // MVR
    Coordinate{-39.8642, -18.0494}, // MVS
    Coordinate{6.64999, 45.8223}, // MVV
    Coordinate{-122.421, 48.4708}, // MVW
    Coordinate{12.1167, 2.15}, // MVX
    Coordinate{-70.6144, 41.3931}, // MVY
    Coordinate{30.8589, -20.0619}, // MVZ
    Coordinate{-89.0111, 37.755}, // MWA
    Coordinate{116.022, -29.2014}, // MWB
    Coordinate{-88.0344, 43.1103}, // MWC
    Coordinate{31.8187, 18.45}, // MWE
    Coordinate{168.079, -14.9944}, // MWF
    Coordinate{-119.319, 47.2086}, // MWH
    Coordinate{106.258, 3.34812}, // MWK
    Coordinate{-98.0603, 32.7817}, // MWL
    Coordinate{33.6167, -3.5}, // MWN
    Coordinate{-84.3964, 39.5317}, // MWO
    Coordinate{94.9729, 20.1579}, // MWQ
    Coordinate{107.187, 12.4606}, // MWV
    Coordinate{126.383, 34.9914}, // MWX
    Coordinate{32.9325, -2.44444}, // MWZ
    Coordinate{-90.1544, 35.8944}, // MXA
    Coordinate{120.331, -2.55972}, // MXB
    Coordinate{-109.341, 37.9325}, // MXC
    Coordinate{-79.3658, 34.7919}, // MXE
    Coordinate{-71.509, 42.3432}, // MXG
    Coordinate{143.238, -6.36333}, // MXH
    Coordinate{126.216, 6.95028}, // MXI
    Coordinate{6.46222, 9.65194}, // MXJ
    Coordinate{-115.242, 32.6306}, // MXL
    Coordinate{43.3667, -21.7539}, // MXM
    Coordinate{-3.81667, 48.6008}, // MXN
    Coordinate{-91.1633, 42.2203}, // MXO
    Coordinate{8.72306, 45.63}, // MXP
    Coordinate{16.5006, 13.6441}, // MXR
    Coordinate{-172.258, -13.7422}, // MXS
    Coordinate{44.0322, -18.0508}, // MXT
    Coordinate{115.518, -28.4739}, // MXU
    Coordinate{100.099, 49.6631}, // MXV
    Coordinate{106.283, 45.7667}, // MXW
    Coordinate{14.5111, 60.9586}, // MXX
    Coordinate{-142.904, 61.4369}, // MXY
    Coordinate{116.133, 24.35}, // MXZ
    Coordinate{150.144, -35.8978}, // MYA
    Coordinate{10.6764, -3.45833}, // MYB
    Coordinate{16.1633, 11.4134}, // MYC
    Coordinate{40.1005, -3.22917}, // MYD
    Coordinate{139.56, 34.0736}, // MYE
    Coordinate{-117.139, 32.8158}, // MYF
    Coordinate{-73.0333, 22.3794}, // MYG
    Coordinate{-111.644, 36.8113}, // MYH
    Coordinate{144.054, -9.91667}, // MYI
    Coordinate{132.7, 33.8272}, // MYJ
    Coordinate{-142.687, 61.3356}, // MYK
    Coordinate{-116.102, 44.8886}, // MYL
    Coordinate{-59.6833, 4.48333}, // MYM
    Coordinate{45.3269, 15.4692}, // MYN
    Coordinate{61.8967, 37.6067}, // MYP
    Coordinate{76.6583, 12.2292}, // MYQ
    Coordinate{-78.9311, 33.6797}, // MYR
    Coordinate{97.3519, 25.3836}, // MYT
    Coordinate{-166.271, 60.3714}, // MYU
    Coordinate{-121.57, 39.0978}, // MYV
    Coordinate{40.1819, -10.3361}, // MYW
    Coordinate{-77.7884, 25.402}, // MYX
    Coordinate{113.987, 4.32194}, // MYY
    Coordinate{34.9167, -14.1}, // MYZ
    Coordinate{-74.5358, -11.3257}, // MZA
    Coordinate{40.35, -11.3617}, // MZB
    Coordinate{11.5528, 0.777778}, // MZC
    Coordinate{-89.0238, 17.2784}, // MZE
    Coordinate{-4.08417, 14.5086}, // MZI
    Coordinate{-111.325, 32.5097}, // MZJ
    Coordinate{173.267, 2.05028}, // MZK
    Coordinate{-75.4624, 5.02984}, // MZL
    Coordinate{-77.0867, 20.2889}, // MZO
    Coordinate{172.994, -41.1233}, // MZP
    Coordinate{67.2091, 36.7069}, // MZR
    Coordinate{-106.266, 23.1614}, // MZT
    Coordinate{85.3136, 26.1192}, // MZU
    Coordinate{114.809, 4.05047}, // MZV
    Coordinate{-0.256226, 33.5318}, // MZW
    Coordinate{-85.6797, 40.49}, // MZZ
    Coordinate{149.827, -30.3192}, // NAA
    Coordinate{140.725, -36.985}, // NAC
    Coordinate{1.36667, 10.3833}, // NAE
    Coordinate{79.0472, 21.0925}, // NAG
    Coordinate{125.528, 3.68306}, // NAH
    Coordinate{-59.1242, 3.95944}, // NAI
    Coordinate{45.4583, 39.1886}, // NAJ
    Coordinate{102.083, 14.9333}, // NAK
    Coordinate{43.6383, 43.5133}, // NAL
    Coordinate{127.083, -3.25}, // NAM
    Coordinate{177.443, -17.7553}, // NAN
    Coordinate{106.16, 30.7939}, // NAO
    Coordinate{14.2908, 40.8844}, // NAP
    Coordinate{-69.3886, 77.4886}, // NAQ
    Coordinate{-74.5906, 6.21002}, // NAR
    Coordinate{-77.4661, 25.0389}, // NAS
    Coordinate{-35.3664, -5.76889}, // NAT
    Coordinate{-141.267, -14.1767}, // NAU
    Coordinate{34.5264, 38.7764}, // NAV
    Coordinate{101.743, 6.52}, // NAW
    Coordinate{116.388, 39.7825}, // NAY
    Coordinate{-69.8, 3.48333}, // NBB
    Coordinate{52.095, 55.5633}, // NBC
    Coordinate{10.4386, 36.0758}, // NBE
    Coordinate{-78.1389, 9.25028}, // NBL
    Coordinate{5.62194, -1.41028}, // NBN
    Coordinate{36.9275, -1.31917}, // NBO
    Coordinate{127.549, 42.0881}, // NBS
    Coordinate{-75.2069, 19.9064}, // NBW
    Coordinate{135.496, -3.37028}, // NBX
    Coordinate{-71.9394, 21.9175}, // NCA
    Coordinate{7.215, 43.6653}, // NCE
    Coordinate{-107.883, 30.4}, // NCG
    Coordinate{38.78, -10.3583}, // NCH
    Coordinate{-76.7778, 8.45139}, // NCI
    Coordinate{-61.5289, -30.9572}, // NCJ
    Coordinate{-1.69167, 55.0375}, // NCL
    Coordinate{-147.992, 60.0772}, // NCN
    Coordinate{-84.7656, 11.1331}, // NCR
    Coordinate{29.978, -27.7709}, // NCS
    Coordinate{-85.4456, 10.1394}, // NCT
    Coordinate{59.6233, 42.4883}, // NCU
    Coordinate{6.10639, 45.9308}, // NCY
    Coordinate{129.904, -4.52167}, // NDA
    Coordinate{-17.0311, 20.9283}, // NDB
    Coordinate{77.3186, 19.1819}, // NDC
    Coordinate{13.8478, -11.168}, // NDD
    Coordinate{41.8444, 3.93396}, // NDE
    Coordinate{14.9833, -9.28056}, // NDF
    Coordinate{123.918, 47.2397}, // NDG
    Coordinate{15.0247, 12.125}, // NDJ
    Coordinate{168.126, 5.63306}, // NDK
    Coordinate{20.6344, 8.43}, // NDL
    Coordinate{-3.02821, 34.9888}, // NDR
    Coordinate{19.7194, -17.9564}, // NDU
    Coordinate{-2.57667, 59.2503}, // NDY
    Coordinate{-58.8172, -38.4833}, // NEC
    Coordinate{54.3483, 56.11}, // NEF
    Coordinate{-78.3356, 18.34}, // NEG
    Coordinate{35.4667, 9.52222}, // NEJ
    Coordinate{36.6, 9.05}, // NEK
    Coordinate{124.912, 56.9133}, // NER
    Coordinate{-62.59, 17.2056}, // NEV
    Coordinate{72.65, 61.1083}, // NFG
    Coordinate{-175.631, -15.5711}, // NFO
    Coordinate{148.248, -34.2556}, // NGA
    Coordinate{121.462, 29.8267}, // NGB
    Coordinate{-64.3281, 18.7275}, // NGD
    Coordinate{13.5592, 7.35694}, // NGE
    Coordinate{179.34, -18.1156}, // NGI
    Coordinate{143.142, 51.7839}, // NGK
    Coordinate{136.805, 34.8583}, // NGO
    Coordinate{80.0443, 32.1142}, // NGQ
    Coordinate{129.914, 32.9169}, // NGS
    Coordinate{-97.6125, 28.6117}, // NGT
    Coordinate{84, 28.6333}, // NGX
    Coordinate{35.7278, 15.3556}, // NHF
    Coordinate{-69.9389, 43.8922}, // NHZ
    Coordinate{-8.60013, 7.5}, // NIA
    Coordinate{-154.358, 63.0186}, // NIB
    Coordinate{33.2772, 35.15}, // NIC
    Coordinate{121.595, -21.6737}, // NIF
    Coordinate{176.409, -1.31667}, // NIG
    Coordinate{-12.7264, 13.0542}, // NIK
    Coordinate{2.17028, 13.4817}, // NIM
    Coordinate{17.6847, -2.7175}, // NIO
    Coordinate{-0.394445, 46.3133}, // NIT
    Coordinate{-146.37, -16.1194}, // NIU
    Coordinate{-9.58333, 15.2333}, // NIX
    Coordinate{76.4817, 60.9483}, // NJC
    Coordinate{44.4043, 31.9899}, // NJF
    Coordinate{-15.9697, 18.31}, // NKC
    Coordinate{118.862, 31.7422}, // NKG
    Coordinate{14.8167, -5.42083}, // NKL
    Coordinate{136.924, 35.255}, // NKM
    Coordinate{9.93333, 4.95}, // NKS
    Coordinate{42.06, 37.3639}, // NKT
    Coordinate{28.1969, -30.0217}, // NKU
    Coordinate{13.2833, -4.21667}, // NKY
    Coordinate{28.66, -13}, // NLA
    Coordinate{-99.5706, 27.4434}, // NLD
    Coordinate{-86.2259, 41.8407}, // NLE
    Coordinate{143.78, -9.57833}, // NLF
    Coordinate{-161.16, 56.0075}, // NLG
    Coordinate{100.757, 27.5438}, // NLH
    Coordinate{140.655, 53.1539}, // NLI
    Coordinate{167.938, -29.0425}, // NLK
    Coordinate{-123.927, 40.7192}, // NLN
    Coordinate{15.3272, -4.32667}, // NLO
    Coordinate{30.9138, -25.5}, // NLP
    Coordinate{83.3803, 43.4331}, // NLT
    Coordinate{31.9208, 47.0581}, // NLV
    Coordinate{71.5567, 40.9844}, // NMA
    Coordinate{72.8432, 20.4344}, // NMB
    Coordinate{-76.8203, 24.5942}, // NMC
    Coordinate{-164.701, 60.4711}, // NME
    Coordinate{-78.9333, 8.45694}, // NMG
    Coordinate{-111.574, 57.0556}, // NML
    Coordinate{97.7369, 20.8856}, // NMS
    Coordinate{-6.61667, 34.25}, // NNA
    Coordinate{162.454, -10.8481}, // NNB
    Coordinate{108.172, 22.6083}, // NNG
    Coordinate{16.925, -18.8111}, // NNI
    Coordinate{-157.02, 58.7328}, // NNK
    Coordinate{-154.839, 59.9803}, // NNL
    Coordinate{53.125, 67.64}, // NNM
    Coordinate{30.385, 50.4783}, // NNN
    Coordinate{-9.46778, 53.2305}, // NNR
    Coordinate{100.783, 18.8078}, // NNT
    Coordinate{-40.3339, -17.8172}, // NNU
    Coordinate{117.667, 4.13667}, // NNX
    Coordinate{112.615, 32.9808}, // NNY
    Coordinate{-85.6531, 9.96667}, // NOB
    Coordinate{-8.81861, 53.9103}, // NOC
    Coordinate{7.18889, 53.6331}, // NOD
    Coordinate{-110.977, 31.2261}, // NOG
    Coordinate{75.27, 63.1833}, // NOJ
    Coordinate{-52.3492, -14.6973}, // NOK
    Coordinate{174.428, -0.639667}, // NON
    Coordinate{35.0664, 42.0158}, // NOP
    Coordinate{-13.7464, 65.1319}, // NOR
    Coordinate{48.3147, -13.3119}, // NOS
    Coordinate{-122.556, 38.1436}, // NOT
    Coordinate{166.216, -22.0164}, // NOU
    Coordinate{15.7606, -12.8089}, // NOV
    Coordinate{86.8783, 53.81}, // NOZ
    Coordinate{176.87, -39.4683}, // NPE
    Coordinate{174.179, -39.0086}, // NPL
    Coordinate{111.473, 0.06362}, // NPO
    Coordinate{-55.4008, -7.12583}, // NPR
    Coordinate{-71.2817, 41.5325}, // NPT
    Coordinate{-89.8703, 35.3567}, // NQA
    Coordinate{-48.4919, -14.4364}, // NQL
    Coordinate{-68.1558, -38.9489}, // NQN
    Coordinate{-77.2833, 5.7}, // NQU
    Coordinate{-4.99528, 50.4408}, // NQY
    Coordinate{146.512, -34.7022}, // NRA
    Coordinate{-121.109, 37.4081}, // NRC
    Coordinate{7.23008, 53.7069}, // NRD
    Coordinate{126.7, -3.85583}, // NRE
    Coordinate{117.08, -32.93}, // NRG
    Coordinate{-94.8619, 36.5775}, // NRI
    Coordinate{16.2317, 58.5861}, // NRK
    Coordinate{-2.43444, 59.3675}, // NRL
    Coordinate{-7.26667, 15.2287}, // NRM
    Coordinate{6.14194, 51.6014}, // NRN
    Coordinate{-65.6433, 18.2453}, // NRR
    Coordinate{140.388, 35.7649}, // NRT
    Coordinate{-79.25, 25.7669}, // NSB
    Coordinate{51.4647, 36.6633}, // NSH
    Coordinate{11.5533, 3.7225}, // NSI
    Coordinate{87.3333, 69.31}, // NSK
    Coordinate{121.754, -32.2114}, // NSM
    Coordinate{173.221, -41.2983}, // NSN
    Coordinate{150.832, -32.0372}, // NSO
    Coordinate{99.9447, 8.53944}, // NST
    Coordinate{9.21222, 59.5656}, // NTB
    Coordinate{-1.60778, 47.1569}, // NTE
    Coordinate{120.976, 32.0708}, // NTG
    Coordinate{141.07, -17.685}, // NTN
    Coordinate{136.962, 37.2933}, // NTQ
    Coordinate{-100.237, 25.8656}, // NTR
    Coordinate{-173.755, -15.9767}, // NTT
    Coordinate{108.388, 3.90871}, // NTX
    Coordinate{27.1716, -25.3355}, // NTY
    Coordinate{135.717, -14.2717}, // NUB
    Coordinate{28.333, 12.6667}, // NUD
    Coordinate{11.0781, 49.4986}, // NUE
    Coordinate{-151.006, 70.21}, // NUI
    Coordinate{-138.772, -19.285}, // NUK
    Coordinate{-158.074, 64.7294}, // NUL
    Coordinate{-87.3381, 30.4697}, // NUN
    Coordinate{-162.439, 60.9058}, // NUP
    Coordinate{-122.048, 37.415}, // NUQ
    Coordinate{167.401, -16.0797}, // NUS
    Coordinate{36.1508, -0.302695}, // NUU
    Coordinate{76.5217, 66.07}, // NUX
    Coordinate{-75.2939, 2.95}, // NVA
    Coordinate{-84.4547, 11.6667}, // NVG
    Coordinate{65.175, 40.1178}, // NVI
    Coordinate{-109.416, 26.9903}, // NVJ
    Coordinate{17.3867, 68.4369}, // NVK
    Coordinate{-120.353, 39.8186}, // NVN
    Coordinate{31.2417, 58.4933}, // NVR
    Coordinate{3.11083, 47.0036}, // NVS
    Coordinate{-48.6514, -26.88}, // NVT
    Coordinate{43.7618, -12.2981}, // NWA
    Coordinate{-72.1893, 43.3881}, // NWH
    Coordinate{1.28278, 52.6758}, // NWI
    Coordinate{-116.162, 34.2961}, // NXP
    Coordinate{65.615, 62.11}, // NYA
    Coordinate{36.9667, -0.371389}, // NYE
    Coordinate{-2.32861, 7.36167}, // NYI
    Coordinate{37.0342, -0.069444}, // NYK
    Coordinate{72.7033, 65.48}, // NYM
    Coordinate{147.203, -31.5517}, // NYN
    Coordinate{16.9122, 58.7886}, // NYO
    Coordinate{118.333, 63.2931}, // NYR
    Coordinate{96.1999, 19.6191}, // NYT
    Coordinate{94.9303, 21.1789}, // NYU
    Coordinate{21.3579, -7.71694}, // NZA
    Coordinate{-74.9618, -14.8542}, // NZC
    Coordinate{-8.7026, 7.8132}, // NZE
    Coordinate{117.33, 49.5667}, // NZH
    Coordinate{172.105, -41.25}, // NZK
    Coordinate{122.768, 47.8658}, // NZL
    Coordinate{149.133, -33.3817}, // OAG
    Coordinate{-77.6122, 34.8292}, // OAJ
    Coordinate{-122.221, 37.7214}, // OAK
    Coordinate{-61.4508, -11.4956}, // OAL
    Coordinate{171.082, -44.97}, // OAM
    Coordinate{-86.5764, 15.5069}, // OAN
    Coordinate{-121.762, 36.6814}, // OAR
    Coordinate{68.8386, 33.126}, // OAS
    Coordinate{-96.7267, 17}, // OAX
    Coordinate{43.2786, 11.9683}, // OBC
    Coordinate{-80.8511, 27.266}, // OBE
    Coordinate{11.2831, 48.0814}, // OBF
    Coordinate{-55.9467, 2.22417}, // OBI
    Coordinate{-5.4, 56.4636}, // OBN
    Coordinate{143.217, 42.7333}, // OBO
    Coordinate{4.36917, 44.5394}, // OBS
    Coordinate{-156.897, 66.9122}, // OBU
    Coordinate{141.324, -7.59053}, // OBX
    Coordinate{-80.2783, 25.3203}, // OCA
    Coordinate{-76.9867, -0.462778}, // OCC
    Coordinate{-75.1239, 38.3106}, // OCE
    Coordinate{-82.2242, 29.1725}, // OCF
    Coordinate{-76.9753, 18.4006}, // OCJ
    Coordinate{117.275, -22.5397}, // OCM
    Coordinate{-117.351, 33.2181}, // OCN
    Coordinate{9.33056, 0.916667}, // OCS
    Coordinate{-73.3581, 8.315}, // OCV
    Coordinate{22.4, 8.01667}, // ODA
    Coordinate{-4.84888, 37.842}, // ODB
    Coordinate{-120.8, 37.7564}, // ODC
    Coordinate{10.3308, 55.4767}, // ODE
    Coordinate{22.7833, 8.9}, // ODJ
    Coordinate{-79.3394, 39.5803}, // ODM
    Coordinate{115.063, 3.97611}, // ODN
    Coordinate{114.243, 57.8664}, // ODO
    Coordinate{30.6781, 46.4269}, // ODS
    Coordinate{-122.674, 48.2517}, // ODW
    Coordinate{101.993, 20.6806}, // ODY
    Coordinate{-87.5522, 38.6914}, // OEA
    Coordinate{-85.0522, 41.9336}, // OEB
    Coordinate{124.352, -9.19833}, // OEC
    Coordinate{36.0017, 52.935}, // OEL
    Coordinate{-55.4417, 3.34611}, // OEM
    Coordinate{-92.69, 45.3094}, // OEO
    Coordinate{18.99, 63.4078}, // OER
    Coordinate{-65.0344, -40.7514}, // OES
    Coordinate{46.6411, 25.2131}, // OET
    Coordinate{-4.05, 9.6}, // OFI
    Coordinate{-18.6667, 66.0736}, // OFJ
    Coordinate{-97.435, 41.9856}, // OFK
    Coordinate{-77.4364, 37.7089}, // OFP
    Coordinate{-169.67, -14.1844}, // OFU
    Coordinate{-80.8594, 33.4569}, // OGB
    Coordinate{-112.013, 41.1956}, // OGD
    Coordinate{-156.431, 20.8986}, // OGG
    Coordinate{-58.1058, 6.80722}, // OGL
    Coordinate{-77.9819, 9.13278}, // OGM
    Coordinate{122.98, 24.4675}, // OGN
    Coordinate{-3.47028, 6.71556}, // OGO
    Coordinate{15.3797, 10.2883}, // OGR
    Coordinate{-75.4656, 44.6819}, // OGS
    Coordinate{38.0667, 40.9667}, // OGU
    Coordinate{5.40667, 31.9314}, // OGX
    Coordinate{44.6067, 43.205}, // OGZ
    Coordinate{175.387, -40.2067}, // OHA
    Coordinate{20.7422, 41.1799}, // OHD
    Coordinate{122.421, 52.9211}, // OHE
    Coordinate{142.88, 53.5178}, // OHH
    Coordinate{15.699, -17.7972}, // OHI
    Coordinate{56.6953, 24.3328}, // OHS
    Coordinate{-51.06, -6.77583}, // OIA
    Coordinate{-75.5242, 42.5664}, // OIC
    Coordinate{139.36, 34.7819}, // OIM
    Coordinate{139.433, 42.0717}, // OIR
    Coordinate{131.737, 33.4794}, // OIT
    Coordinate{-98.6686, 35.5458}, // OJA
    Coordinate{-94.7375, 38.8475}, // OJC
    Coordinate{127.646, 26.1958}, // OKA
    Coordinate{-97.6008, 35.3931}, // OKC
    Coordinate{141.381, 43.1175}, // OKD
    Coordinate{128.706, 27.4317}, // OKE
    Coordinate{15.9167, -19.15}, // OKF
    Coordinate{15.0733, -1.44833}, // OKG
    Coordinate{133.323, 36.1783}, // OKI
    Coordinate{133.855, 34.7569}, // OKJ
    Coordinate{-86.0589, 40.5281}, // OKK
    Coordinate{140.664, -5.10161}, // OKL
    Coordinate{-95.9486, 35.6681}, // OKM
    Coordinate{13.6728, -0.664167}, // OKN
    Coordinate{143.404, -9.75333}, // OKR
    Coordinate{133.933, 34.5914}, // OKS
    Coordinate{53.3883, 54.44}, // OKT
    Coordinate{17.0519, -18.8144}, // OKU
    Coordinate{9.60389, 63.6992}, // OLA
    Coordinate{9.51763, 40.8987}, // OLB
    Coordinate{-68.9583, -3.46944}, // OLC
    Coordinate{-68.6744, 44.9525}, // OLD
    Coordinate{-78.3714, 42.2411}, // OLE
    Coordinate{-105.575, 48.0944}, // OLF
    Coordinate{-153.269, 57.2183}, // OLH
    Coordinate{-23.8231, 64.9114}, // OLI
    Coordinate{166.558, -14.8817}, // OLJ
    Coordinate{15.9142, -1.21861}, // OLL
    Coordinate{-122.902, 46.9694}, // OLM
    Coordinate{-69, -45.5819}, // OLN
    Coordinate{17.2108, 49.5878}, // OLO
    Coordinate{136.877, -30.485}, // OLP
    Coordinate{-110.848, 31.4178}, // OLS
    Coordinate{-97.3428, 41.4481}, // OLU
    Coordinate{-89.7869, 34.9789}, // OLV
    Coordinate{120.464, 60.3992}, // OLZ
    Coordinate{-95.8937, 41.302}, // OMA
    Coordinate{9.26278, -1.57472}, // OMB
    Coordinate{124.566, 11.0562}, // OMC
    Coordinate{16.4467, -28.5847}, // OMD
    Coordinate{-165.445, 64.5122}, // OME
    Coordinate{22.1889, -18.0303}, // OMG
    Coordinate{45.0686, 37.6681}, // OMH
    Coordinate{-119.518, 48.4642}, // OMK
    Coordinate{55.1753, 18.136}, // OMM
    Coordinate{76.0533, 18.2786}, // OMN
    Coordinate{17.8458, 43.2828}, // OMO
    Coordinate{21.9024, 47.0253}, // OMR
    Coordinate{73.3083, 54.9667}, // OMS
    Coordinate{104.972, 13.7606}, // OMY
    Coordinate{-91.7083, 44.0772}, // ONA
    Coordinate{15.95, -17.8781}, // OND
    Coordinate{139.178, -16.6625}, // ONG
    Coordinate{-75.0644, 42.5247}, // ONH
    Coordinate{140.372, 40.1919}, // ONJ
    Coordinate{112.479, 68.5156}, // ONK
    Coordinate{-98.6872, 42.4694}, // ONL
    Coordinate{-117.013, 44.0194}, // ONO
    Coordinate{-124.058, 44.5803}, // ONP
    Coordinate{32.0886, 41.5064}, // ONQ
    Coordinate{115.113, -21.6684}, // ONS
    Coordinate{-117.601, 34.0561}, // ONT
    Coordinate{-79.8675, 9.35528}, // ONX
    Coordinate{-83.1614, 42.0992}, // ONZ
    Coordinate{135.445, -27.56}, // OOD
    Coordinate{-165.087, 60.5414}, // OOK
    Coordinate{153.505, -28.165}, // OOL
    Coordinate{148.973, -36.3006}, // OOM
    Coordinate{175.526, -1.79639}, // OOT
    Coordinate{-16.4667, 66.3108}, // OPA
    Coordinate{-80.2783, 25.9069}, // OPF
    Coordinate{133.005, -12.3253}, // OPI
    Coordinate{-92.0994, 30.5583}, // OPL
    Coordinate{-8.67806, 41.2356}, // OPO
    Coordinate{-55.5861, -11.885}, // OPS
    Coordinate{142.94, -8.05117}, // OPU
    Coordinate{13.83, -18.07}, // OPW
    Coordinate{-75.5819, 39.99}, // OQN
    Coordinate{-71.4122, 41.5972}, // OQU
    Coordinate{-64.3292, -23.1528}, // ORA
    Coordinate{15.0381, 59.2236}, // ORB
    Coordinate{-71.3564, 4.78972}, // ORC
    Coordinate{-87.9047, 41.9786}, // ORD
    Coordinate{2.16417, 47.8975}, // ORE
    Coordinate{-76.2011, 36.8947}, // ORF
    Coordinate{-55.1901, 5.81147}, // ORG
    Coordinate{-71.8758, 42.2672}, // ORH
    Coordinate{-152.846, 57.8853}, // ORI
    Coordinate{-60.0333, 4.72778}, // ORJ
    Coordinate{-8.49111, 51.8414}, // ORK
    Coordinate{-81.3331, 28.5456}, // ORL
    Coordinate{-0.791389, 52.3061}, // ORM
    Coordinate{-0.611389, 35.6272}, // ORN
    Coordinate{-87.1356, 15.1278}, // ORO
    Coordinate{25.3178, -21.2672}, // ORP
    Coordinate{-141.928, 62.9611}, // ORT
    Coordinate{-67.0761, -17.9625}, // ORU
    Coordinate{-161.022, 66.8175}, // ORV
    Coordinate{64.5861, 25.2747}, // ORW
    Coordinate{-55.8672, -1.76695}, // ORX
    Coordinate{2.37944, 48.7233}, // ORY
    Coordinate{-88.5483, 18.0744}, // ORZ
    Coordinate{-83.3942, 44.4517}, // OSC
    Coordinate{14.5019, 63.1942}, // OSD
    Coordinate{37.5072, 55.5117}, // OSF
    Coordinate{-88.5569, 43.9844}, // OSH
    Coordinate{18.8103, 45.4628}, // OSI
    Coordinate{11.0839, 60.2028}, // OSL
    Coordinate{43.1475, 36.3058}, // OSM
    Coordinate{140.557, -22.0817}, // OSO
    Coordinate{17.1075, 54.4789}, // OSP
    Coordinate{18.1108, 49.6961}, // OSR
    Coordinate{72.7931, 40.6089}, // OSS
    Coordinate{2.87028, 51.2003}, // OST
    Coordinate{-83.0731, 40.0797}, // OSU
    Coordinate{58.5967, 51.0717}, // OSW
    Coordinate{11.5786, 64.4667}, // OSY
    Coordinate{16.2642, 54.0422}, // OSZ
    Coordinate{14.7393, 13.4433}, // OTC
    Coordinate{-79.0344, 8.62861}, // OTD
    Coordinate{-124.263, 43.4172}, // OTH
    Coordinate{128.315, 2.04583}, // OTI
    Coordinate{16.6625, -20.4306}, // OTJ
    Coordinate{-14.7167, 17.533}, // OTL
    Coordinate{-92.4481, 41.1067}, // OTM
    Coordinate{-87.4997, 38.8514}, // OTN
    Coordinate{26.085, 44.5711}, // OTP
    Coordinate{-82.9667, 8.6}, // OTR
    Coordinate{-122.662, 48.4989}, // OTS
    Coordinate{-74.7183, 7.01194}, // OTU
    Coordinate{-162.599, 66.8847}, // OTZ
    Coordinate{-1.51222, 12.3531}, // OUA
    Coordinate{-1.92389, 34.7872}, // OUD
    Coordinate{16.0378, 1.61583}, // OUE
    Coordinate{-2.417, 13.567}, // OUG
    Coordinate{25.3556, 64.9292}, // OUL
    Coordinate{19.2333, 13.2667}, // OUM
    Coordinate{-97.4722, 35.2456}, // OUN
    Coordinate{14.3625, 4.47083}, // OUR
    Coordinate{-49.9119, -22.9736}, // OUS
    Coordinate{16.717, 10.483}, // OUT
    Coordinate{-12.4686, 22.7567}, // OUZ
    Coordinate{82.6506, 55.0125}, // OVB
    Coordinate{-6.03472, 43.5636}, // OVD
    Coordinate{-121.622, 39.4878}, // OVE
    Coordinate{-71.1761, -30.5594}, // OVL
    Coordinate{-60.2167, -36.89}, // OVR
    Coordinate{-90.6739, 43.1608}, // OVS
    Coordinate{-87.1669, 37.7389}, // OWB
    Coordinate{-71.1731, 42.1906}, // OWD
    Coordinate{-95.2519, 38.5392}, // OWI
    Coordinate{-69.8665, 44.7155}, // OWK
    Coordinate{-96.1519, 36.1753}, // OWP
    Coordinate{-15.6536, 11.895}, // OXB
    Coordinate{-73.1353, 41.4786}, // OXC
    Coordinate{-84.7844, 39.5022}, // OXD
    Coordinate{-1.32, 51.8369}, // OXF
    Coordinate{-59.2506, -29.1044}, // OYA
    Coordinate{11.5814, 1.54311}, // OYE
    Coordinate{31.7644, 3.64889}, // OYG
    Coordinate{-51.7967, 3.85588}, // OYK
    Coordinate{39.102, 3.465}, // OYL
    Coordinate{-60.3333, -38.4}, // OYO
    Coordinate{-51.8056, 3.89333}, // OYP
    Coordinate{123.841, 8.17852}, // OZC
    Coordinate{-5.86667, 30.2667}, // OZG
    Coordinate{35.3158, 47.8669}, // OZH
    Coordinate{-92.6911, 37.9739}, // OZS
    Coordinate{-83.9822, 42.6294}, // OZW
    Coordinate{-6.90944, 30.9392}, // OZZ
    Coordinate{97.6744, 16.8931}, // PAA
    Coordinate{82.0648, 21.9883}, // PAB
    Coordinate{-79.5556, 8.97333}, // PAC
    Coordinate{8.61722, 51.6153}, // PAD
    Coordinate{-122.281, 47.9061}, // PAE
    Coordinate{31.5544, 2.20222}, // PAF
    Coordinate{123.458, 7.82722}, // PAG
    Coordinate{-88.7731, 37.0603}, // PAH
    Coordinate{70.0714, 33.9027}, // PAJ
    Coordinate{-159.603, 21.8969}, // PAK
    Coordinate{-75.6156, 5.03615}, // PAL
    Coordinate{101.154, 6.78546}, // PAN
    Coordinate{-122.115, 37.4611}, // PAO
    Coordinate{-72.2925, 18.58}, // PAP
    Coordinate{-149.089, 61.595}, // PAQ
    Coordinate{25.128, 37.0112}, // PAS
    Coordinate{85.0919, 25.5936}, // PAT
    Coordinate{-38.2542, -9.40222}, // PAV
    Coordinate{-72.85, 19.9333}, // PAX
    Coordinate{-97.4608, 20.6021}, // PAZ
    Coordinate{-98.3714, 19.1581}, // PBC
    Coordinate{69.6572, 21.6486}, // PBD
    Coordinate{-74.4106, 6.45972}, // PBE
    Coordinate{-91.9356, 34.1744}, // PBF
    Coordinate{-73.4681, 44.6508}, // PBG
    Coordinate{89.4206, 27.4088}, // PBH
    Coordinate{-80.0956, 26.6832}, // PBI
    Coordinate{168.236, -16.4319}, // PBJ
    Coordinate{-68.0733, 10.4781}, // PBL
    Coordinate{-55.1878, 5.45283}, // PBM
    Coordinate{13.7657, -10.722}, // PBN
    Coordinate{117.746, -23.1714}, // PBO
    Coordinate{-85.3667, 9.85}, // PBP
    Coordinate{-61.1811, -11.6417}, // PBQ
    Coordinate{-88.585, 15.7308}, // PBR
    Coordinate{97.4264, 27.3197}, // PBU
    Coordinate{-57.3689, -11.532}, // PBV
    Coordinate{23.3294, -34.0883}, // PBZ
    Coordinate{-157.711, 58.9064}, // PCA
    Coordinate{106.765, -6.3368}, // PCB
    Coordinate{-91.1236, 43.0192}, // PCD
    Coordinate{-84.9403, 15.9542}, // PCH
    Coordinate{-74.5742, -8.37778}, // PCL
    Coordinate{-82.1642, 28.0003}, // PCM
    Coordinate{173.958, -41.3447}, // PCN
    Coordinate{-109.536, 23.575}, // PCO
    Coordinate{7.41167, 1.66306}, // PCP
    Coordinate{-67.4931, 6.18444}, // PCR
    Coordinate{-41.5194, -7.06528}, // PCS
    Coordinate{-74.6589, 40.3992}, // PCT
    Coordinate{-82.8694, 41.5164}, // PCW
    Coordinate{-89.0197, 44.3333}, // PCZ
    Coordinate{-67.9061, 3.85361}, // PDA
    Coordinate{-154.13, 59.7972}, // PDB
    Coordinate{32.8383, -26.8267}, // PDD
    Coordinate{100.354, -0.8807}, // PDG
    Coordinate{-84.3019, 33.8756}, // PDK
    Coordinate{-25.6978, 37.7419}, // PDL
    Coordinate{103.88, -3.28607}, // PDO
    Coordinate{-55.0942, -34.855}, // PDP
    Coordinate{-100.534, 28.6274}, // PDS
    Coordinate{-58.0622, -32.3633}, // PDU
    Coordinate{-122.598, 45.5886}, // PDX
    Coordinate{-62.2333, 9.97778}, // PDZ
    Coordinate{-136.236, 57.9553}, // PEC
    Coordinate{15.7386, 50.0133}, // PED
    Coordinate{56.0267, 57.9167}, // PEE
    Coordinate{13.7728, 54.1578}, // PEF
    Coordinate{12.5102, 43.0958}, // PEG
    Coordinate{-61.8575, -35.8447}, // PEH
    Coordinate{-75.7394, 4.8125}, // PEI
    Coordinate{116.584, 40.08}, // PEK
    Coordinate{28.4972, -29.0881}, // PEL
    Coordinate{-69.2286, -12.6136}, // PEM
    Coordinate{100.277, 5.29694}, // PEN
    Coordinate{-77.0528, 42.6372}, // PEO
    Coordinate{-103.511, 31.3825}, // PEQ
    Coordinate{115.967, -31.9403}, // PER
    Coordinate{34.1567, 61.885}, // PES
    Coordinate{-52.3311, -31.7161}, // PET
    Coordinate{-83.7831, 15.2667}, // PEU
    Coordinate{71.5147, 33.9939}, // PEW
    Coordinate{57.13, 65.1217}, // PEX
    Coordinate{45.0167, 53.1167}, // PEZ
    Coordinate{-52.3286, -28.2453}, // PFB
    Coordinate{-123.962, 45.1997}, // PFC
    Coordinate{-23.965, 65.5558}, // PFJ
    Coordinate{-85.6828, 30.2122}, // PFN
    Coordinate{32.485, 34.7183}, // PFO
    Coordinate{47.8547, 39.6036}, // PFQ
    Coordinate{20.6, -4.33}, // PFR
    Coordinate{-111.448, 36.9261}, // PGA
    Coordinate{20.1808, 44.723}, // PGB
    Coordinate{-79.1458, 38.995}, // PGC
    Coordinate{-81.9908, 26.9189}, // PGD
    Coordinate{2.87056, 42.7406}, // PGF
    Coordinate{79.4725, 29.0321}, // PGH
    Coordinate{20.8035, -7.35756}, // PGI
    Coordinate{106.139, -2.16194}, // PGK
    Coordinate{-88.5292, 30.4628}, // PGL
    Coordinate{-151.832, 59.3483}, // PGM
    Coordinate{-72.1186, 19.3214}, // PGN
    Coordinate{6.51667, 0.0333333}, // PGP
    Coordinate{-90.5092, 36.0639}, // PGR
    Coordinate{-113.247, 35.5269}, // PGS
    Coordinate{52.7375, 27.3794}, // PGU
    Coordinate{-77.3853, 35.6353}, // PGV
    Coordinate{0.815217, 45.1975}, // PGX
    Coordinate{-50.1444, -25.1878}, // PGZ
    Coordinate{-41.7303, -2.89389}, // PHB
    Coordinate{6.94944, 5.01528}, // PHC
    Coordinate{-81.42, 40.4703}, // PHD
    Coordinate{118.626, -20.3778}, // PHE
    Coordinate{-76.4931, 37.1319}, // PHF
    Coordinate{7.02083, 4.84583}, // PHG
    Coordinate{-45.0672, -2.48361}, // PHI
    Coordinate{-80.6933, 26.785}, // PHK
    Coordinate{-75.2411, 39.8719}, // PHL
    Coordinate{8.99419, 48.6899}, // PHM
    Coordinate{-82.5289, 42.9108}, // PHN
    Coordinate{-166.799, 68.3489}, // PHO
    Coordinate{139.923, -21.8117}, // PHQ
    Coordinate{100.279, 16.7731}, // PHS
    Coordinate{-88.3828, 36.3383}, // PHT
    Coordinate{31.155, -23.9372}, // PHW
    Coordinate{-112.012, 33.4342}, // PHX
    Coordinate{101.195, 16.6758}, // PHY
    Coordinate{-89.6933, 40.6642}, // PIA
    Coordinate{-89.3369, 31.4672}, // PIB
    Coordinate{-72.0904, 21.8779}, // PIC
    Coordinate{-77.2933, 25.0792}, // PID
    Coordinate{-82.6875, 27.91}, // PIE
    Coordinate{120.478, 22.6953}, // PIF
    Coordinate{-62.3833, -37.6007}, // PIG
    Coordinate{-112.596, 42.9098}, // PIH
    Coordinate{-4.59444, 55.5094}, // PIK
    Coordinate{-58.318, -26.8815}, // PIL
    Coordinate{-84.8825, 32.8406}, // PIM
    Coordinate{-56.7711, -2.66944}, // PIN
    Coordinate{-76.2203, -13.745}, // PIO
    Coordinate{-157.572, 57.5803}, // PIP
    Coordinate{-100.286, 44.3828}, // PIR
    Coordinate{0.306667, 46.5875}, // PIS
    Coordinate{-80.2567, 40.496}, // PIT
    Coordinate{-80.6167, -5.2}, // PIU
    Coordinate{-97.1636, 55.5894}, // PIW
    Coordinate{-28.4414, 38.5544}, // PIX
    Coordinate{-163.011, 69.7322}, // PIZ
    Coordinate{23.0689, 67.2458}, // PJA
    Coordinate{-111.339, 34.2569}, // PJB
    Coordinate{-55.8297, -22.6414}, // PJC
    Coordinate{64.1325, 26.9545}, // PJG
    Coordinate{-83.3, 8.53333}, // PJM
    Coordinate{-161.778, 60.7028}, // PKA
    Coordinate{-81.4394, 39.345}, // PKB
    Coordinate{158.454, 53.1677}, // PKC
    Coordinate{148.239, -33.1314}, // PKE
    Coordinate{-90.4244, 45.955}, // PKF
    Coordinate{100.553, 4.24472}, // PKG
    Coordinate{23.149, 37.2988}, // PKH
    Coordinate{-90.7417, 15.9975}, // PKJ
    Coordinate{95.1023, 21.3445}, // PKK
    Coordinate{111.673, -2.705}, // PKN
    Coordinate{2.60917, 9.35722}, // PKO
    Coordinate{-138.811, -14.8093}, // PKP
    Coordinate{83.9819, 28.2008}, // PKR
    Coordinate{129.528, -14.2483}, // PKT
    Coordinate{101.444, 0.460833}, // PKU
    Coordinate{28.3983, 57.785}, // PKV
    Coordinate{27.8205, -22.0572}, // PKW
    Coordinate{113.942, -2.225}, // PKY
    Coordinate{105.782, 15.1339}, // PKZ
    Coordinate{-73.5244, 44.6875}, // PLB
    Coordinate{-85.4833, 9.86667}, // PLD
    Coordinate{14.925, 9.37806}, // PLF
    Coordinate{-4.10583, 50.4228}, // PLH
    Coordinate{-88.3617, 16.5369}, // PLJ
    Coordinate{-93.2289, 36.6258}, // PLK
    Coordinate{-59.9864, -3.14611}, // PLL
    Coordinate{104.7, -2.90028}, // PLM
    Coordinate{-84.7967, 45.5708}, // PLN
    Coordinate{135.88, -34.6053}, // PLO
    Coordinate{21.0939, 55.9733}, // PLQ
    Coordinate{-86.2492, 33.5589}, // PLR
    Coordinate{-72.2658, 21.7736}, // PLS
    Coordinate{-74.7861, 9.8}, // PLT
    Coordinate{-43.9506, -19.8519}, // PLU
    Coordinate{34.3986, 49.5739}, // PLV
    Coordinate{119.91, -0.918611}, // PLW
    Coordinate{80.2344, 50.3514}, // PLX
    Coordinate{-86.3003, 41.365}, // PLY
    Coordinate{25.6103, -33.99}, // PLZ
    Coordinate{39.8114, -5.25722}, // PMA
    Coordinate{-97.2408, 48.9425}, // PMB
    Coordinate{-73.0939, -41.4386}, // PMC
    Coordinate{-118.084, 34.6294}, // PMD
    Coordinate{10.2953, 44.8222}, // PMF
    Coordinate{-55.7025, -22.5497}, // PMG
    Coordinate{-82.8472, 38.8406}, // PMH
    Coordinate{2.73881, 39.5517}, // PMI
    Coordinate{146.581, -18.7553}, // PMK
    Coordinate{-160.561, 56.0061}, // PML
    Coordinate{13.0994, 38.1819}, // PMO
    Coordinate{-70.9805, -46.5381}, // PMQ
    Coordinate{175.617, -40.3206}, // PMR
    Coordinate{38.3, 34.55}, // PMS
    Coordinate{-63.9675, 10.9131}, // PMV
    Coordinate{-48.3578, -10.29}, // PMW
    Coordinate{-72.3114, 42.2233}, // PMX
    Coordinate{-65.1014, -42.7585}, // PMY
    Coordinate{-83.4686, 8.95111}, // PMZ
    Coordinate{-1.647, 42.77}, // PNA
    Coordinate{-48.4003, -10.7169}, // PNB
    Coordinate{-97.0997, 36.7319}, // PNC
    Coordinate{-88.8081, 16.1022}, // PND
    Coordinate{-75.0106, 40.0819}, // PNE
    Coordinate{-48.5311, -25.5406}, // PNG
    Coordinate{104.844, 11.5464}, // PNH
    Coordinate{158.209, 6.985}, // PNI
    Coordinate{109.404, -0.150556}, // PNK
    Coordinate{11.9686, 36.8164}, // PNL
    Coordinate{-93.6083, 45.56}, // PNM
    Coordinate{-67.5644, 45.2006}, // PNN
    Coordinate{148.309, -8.80444}, // PNP
    Coordinate{73.9197, 18.5822}, // PNQ
    Coordinate{11.8858, -4.81333}, // PNR
    Coordinate{-87.1866, 30.4734}, // PNS
    Coordinate{-72.5284, -51.6717}, // PNT
    Coordinate{-112.392, 37.8453}, // PNU
    Coordinate{-96.6736, 33.7142}, // PNX
    Coordinate{79.8105, 11.9658}, // PNY
    Coordinate{-40.5969, -9.3675}, // PNZ
    Coordinate{-51.1711, -29.9939}, // POA
    Coordinate{-117.782, 34.0916}, // POC
    Coordinate{-14.9667, 16.6781}, // POD
    Coordinate{8.75444, -0.711667}, // POG
    Coordinate{-65.7236, -19.5431}, // POI
    Coordinate{-46.4914, -18.6722}, // POJ
    Coordinate{40.5225, -12.9868}, // POL
    Coordinate{147.22, -9.44333}, // POM
    Coordinate{-89.4167, 16.3264}, // PON
    Coordinate{-46.5681, -21.8431}, // POO
    Coordinate{-70.57, 19.7578}, // POP
    Coordinate{21.7978, 61.4614}, // POR
    Coordinate{-61.3372, 10.5953}, // POS
    Coordinate{-76.5361, 18.1967}, // POT
    Coordinate{-73.8842, 41.6267}, // POU
    Coordinate{-81.2517, 41.2103}, // POV
    Coordinate{13.615, 45.4734}, // POW
    Coordinate{2.04072, 49.0966}, // POX
    Coordinate{16.8264, 52.4211}, // POZ
    Coordinate{-51.4189, -22.1783}, // PPB
    Coordinate{-150.644, 66.8142}, // PPC
    Coordinate{-113.533, 31.35}, // PPE
    Coordinate{-95.5061, 37.3308}, // PPF
    Coordinate{-170.711, -14.3317}, // PPG
    Coordinate{-61.5194, 4.57028}, // PPH
    Coordinate{137.995, -33.2389}, // PPI
    Coordinate{69.185, 54.7744}, // PPK
    Coordinate{86.5844, 27.5181}, // PPL
    Coordinate{-80.1111, 26.2472}, // PPM
    Coordinate{-76.6092, 2.45417}, // PPN
    Coordinate{148.552, -20.495}, // PPP
    Coordinate{174.989, -40.9047}, // PPQ
    Coordinate{100.37, 0.845478}, // PPR
    Coordinate{118.759, 9.74222}, // PPS
    Coordinate{-149.611, -17.5567}, // PPT
    Coordinate{-133.61, 56.3289}, // PPV
    Coordinate{-2.90028, 59.3517}, // PPW
    Coordinate{-45.9194, -22.2889}, // PPY
    Coordinate{-67.4497, 6.21944}, // PPZ
    Coordinate{103.991, 10.1717}, // PQC
    Coordinate{-68.0447, 46.6889}, // PQI
    Coordinate{-92.0156, 17.533}, // PQM
    Coordinate{152.863, -31.4358}, // PQQ
    Coordinate{-162.899, 61.9344}, // PQS
    Coordinate{-60.4803, -31.7947}, // PRA
    Coordinate{-120.627, 35.6728}, // PRB
    Coordinate{-112.42, 34.6544}, // PRC
    Coordinate{14.26, 50.1008}, // PRG
    Coordinate{100.165, 18.1317}, // PRH
    Coordinate{55.6916, -4.31924}, // PRI
    Coordinate{-8.57972, 37.1475}, // PRM
    Coordinate{21.0358, 42.5728}, // PRN
    Coordinate{-94.1597, 41.8281}, // PRO
    Coordinate{8.89389, 41.6603}, // PRP
    Coordinate{-60.4934, -26.7667}, // PRQ
    Coordinate{-61.0556, 5.81667}, // PRR
    Coordinate{17.4047, 49.4258}, // PRV
    Coordinate{-90.2758, 45.5386}, // PRW
    Coordinate{-95.4508, 33.6367}, // PRX
    Coordinate{28.2167, -25.6536}, // PRY
    Coordinate{-120.904, 44.2869}, // PRZ
    Coordinate{10.3925, 43.6839}, // PSA
    Coordinate{-78.0872, 40.8833}, // PSB
    Coordinate{-119.119, 46.2647}, // PSC
    Coordinate{32.24, 31.2794}, // PSD
    Coordinate{-66.5631, 18.0083}, // PSE
    Coordinate{-73.2929, 42.4268}, // PSF
    Coordinate{-132.946, 56.8014}, // PSG
    Coordinate{63.3444, 25.2902}, // PSI
    Coordinate{120.656, -1.41838}, // PSJ
    Coordinate{-80.6786, 37.1372}, // PSK
    Coordinate{-3.37222, 56.4392}, // PSL
    Coordinate{-70.8233, 43.0781}, // PSM
    Coordinate{-77.2914, 1.39611}, // PSO
    Coordinate{-116.507, 33.8297}, // PSP
    Coordinate{-75.2997, 39.8589}, // PSQ
    Coordinate{14.1872, 42.4372}, // PSR
    Coordinate{-55.9706, -27.3858}, // PSS
    Coordinate{-75.6572, 20.7342}, // PST
    Coordinate{112.937, 0.835556}, // PSU
    Coordinate{}, // PSV
    Coordinate{-96.2508, 28.7275}, // PSX
    Coordinate{-57.7776, -51.6857}, // PSY
    Coordinate{-57.8206, -18.9753}, // PSZ
    Coordinate{-154.319, 60.2044}, // PTA
    Coordinate{-134.648, 56.2469}, // PTD
    Coordinate{177.216, -17.7831}, // PTF
    Coordinate{29.4585, -23.8453}, // PTG
    Coordinate{-158.633, 56.9592}, // PTH
    Coordinate{141.471, -38.3181}, // PTJ
    Coordinate{-83.4194, 42.6656}, // PTK
    Coordinate{-70.1832, 7.56671}, // PTM
    Coordinate{-91.3389, 29.7094}, // PTN
    Coordinate{-52.6942, -26.2178}, // PTO
    Coordinate{-61.5258, 16.2642}, // PTP
    Coordinate{-94.7311, 37.4494}, // PTS
    Coordinate{-98.7469, 37.7025}, // PTT
    Coordinate{-161.819, 59.0114}, // PTU
    Coordinate{-119.063, 36.0297}, // PTV
    Coordinate{-75.5567, 40.2394}, // PTW
    Coordinate{-76.0858, 1.85778}, // PTX
    Coordinate{-79.3836, 9.07139}, // PTY
    Coordinate{-78.0628, -1.50528}, // PTZ
    Coordinate{-104.496, 38.2892}, // PUB
    Coordinate{-65.9164, -47.7356}, // PUD
    Coordinate{-77.5331, 8.68306}, // PUE
    Coordinate{-0.418611, 43.38}, // PUF
    Coordinate{137.717, -32.5069}, // PUG
    Coordinate{-68.3519, 18.5667}, // PUJ
    Coordinate{-137.017, -18.2956}, // PUK
    Coordinate{121.524, -4.34139}, // PUM
    Coordinate{26.3333, -1.36667}, // PUN
    Coordinate{-1.14847, 11.1791}, // PUP
    Coordinate{-70.8544, -53.0025}, // PUQ
    Coordinate{-67.5472, -11.1072}, // PUR
    Coordinate{128.938, 35.1806}, // PUS
    Coordinate{77.7911, 14.1467}, // PUT
    Coordinate{-76.5008, 0.505278}, // PUU
    Coordinate{-117.109, 46.7439}, // PUW
    Coordinate{-72.9468, -41.3493}, // PUX
    Coordinate{13.9222, 44.8936}, // PUY
    Coordinate{-83.3877, 14.0462}, // PUZ
    Coordinate{-81.3583, 13.3569}, // PVA
    Coordinate{-90.4444, 42.6894}, // PVB
    Coordinate{-70.2214, 42.0719}, // PVC
    Coordinate{-71.4283, 41.7239}, // PVD
    Coordinate{-78.9475, 9.55833}, // PVE
    Coordinate{-120.753, 38.7242}, // PVF
    Coordinate{121.805, 31.1433}, // PVG
    Coordinate{-63.9028, -8.71361}, // PVH
    Coordinate{-52.4886, -23.0917}, // PVI
    Coordinate{20.7667, 38.9261}, // PVK
    Coordinate{-82.5664, 37.5617}, // PVL
    Coordinate{-80.4719, -1.04139}, // PVO
    Coordinate{-112.099, 27.0931}, // PVP
    Coordinate{-105.254, 20.68}, // PVR
    Coordinate{-173.247, 64.3783}, // PVS
    Coordinate{-111.723, 40.2192}, // PVU
    Coordinate{-101.716, 34.1689}, // PVW
    Coordinate{-97.6469, 35.5342}, // PWA
    Coordinate{-104.523, 48.7889}, // PWD
    Coordinate{170.597, 69.7833}, // PWE
    Coordinate{-87.9017, 42.1142}, // PWK
    Coordinate{109.417, -7.46167}, // PWL
    Coordinate{-70.3092, 43.6461}, // PWM
    Coordinate{-74.3464, 22.8297}, // PWN
    Coordinate{28.8896, -8.46853}, // PWO
    Coordinate{77.0739, 52.195}, // PWQ
    Coordinate{-122.765, 47.4903}, // PWT
    Coordinate{-109.807, 42.7956}, // PWY
    Coordinate{103.379, -4.0225}, // PXA
    Coordinate{-83.7672, 32.5106}, // PXE
    Coordinate{135.522, -29.7167}, // PXH
    Coordinate{-110.423, 35.7917}, // PXL
    Coordinate{-97.0891, 15.8767}, // PXM
    Coordinate{-16.3497, 33.0708}, // PXO
    Coordinate{103.498, 14.8683}, // PXR
    Coordinate{108.017, 14.0044}, // PXU
    Coordinate{-74.457, 5.93904}, // PYA
    Coordinate{82.5519, 18.8797}, // PYB
    Coordinate{-78.2347, 9.30972}, // PYC
    Coordinate{-158.033, -9.01444}, // PYE
    Coordinate{-67.6061, 5.62}, // PYH
    Coordinate{112.05, 66.4167}, // PYJ
    Coordinate{50.8228, 35.7761}, // PYK
    Coordinate{-70.7289, 41.9089}, // PYM
    Coordinate{-75.9, 0.08333}, // PYO
    Coordinate{-85.61, 34.09}, // PYP
    Coordinate{-121.616, 39.7106}, // PYS
    Coordinate{98.4359, 19.3704}, // PYY
    Coordinate{-71.8875, 5.875}, // PZA
    Coordinate{30.3983, -29.6506}, // PZB
    Coordinate{69.4634, 31.3583}, // PZH
    Coordinate{101.799, 26.5423}, // PZI
    Coordinate{-62.7603, 8.28861}, // PZO
    Coordinate{-72.6372, -38.7669}, // PZS
    Coordinate{37.2341, 19.4336}, // PZU
    Coordinate{17.8286, 48.625}, // PZY
    Coordinate{55.9925, 25.3103}, // QAJ
    Coordinate{-43.7611, -21.275}, // QAK
    Coordinate{2.38694, 49.8731}, // QAM
    Coordinate{13.3103, 42.3806}, // QAQ
    Coordinate{1.33564, 36.2148}, // QAS
    Coordinate{-126.596, 52.3875}, // QBC
    Coordinate{20.6353, 44.9022}, // QBG
    Coordinate{6.08056, 47.2053}, // QBQ
    Coordinate{10.9281, 45.4719}, // QBS
    Coordinate{-50.8322, -29.3706}, // QCN
    Coordinate{-48.4675, -22.9367}, // QCP
    Coordinate{-51.6069, -21.4611}, // QDC
    Coordinate{-43.7981, -20.7386}, // QDF
    Coordinate{3.349, 34.6671}, // QDJ
    Coordinate{-46.9436, -23.1817}, // QDV
    Coordinate{2.87611, 36.5458}, // QFD
    Coordinate{-45.9142, 60.6242}, // QFG
    Coordinate{-44.6536, 60.0036}, // QFN
    Coordinate{0.131944, 52.0908}, // QFO
    Coordinate{13.2939, 41.6481}, // QFR
    Coordinate{-51.4894, -29.7194}, // QGF
    Coordinate{-36.4714, -8.83494}, // QGP
    Coordinate{136.869, 35.3939}, // QGU
    Coordinate{17.8136, 47.6244}, // QGY
    Coordinate{-47.6194, -22.7106}, // QHB
    Coordinate{-45.516, -23.0401}, // QHP
    Coordinate{39.0059, 8.7163}, // QHR
    Coordinate{49.405, 27.0385}, // QJB
    Coordinate{-47.1525, 60.7792}, // QJH
    Coordinate{27.3492, 70.9406}, // QJL
    Coordinate{28.3792, -14.45}, // QKE
    Coordinate{23.0342, 69.0403}, // QKX
    Coordinate{9.13722, 47.6818}, // QKZ
    Coordinate{-1.03361, 51.1872}, // QLA
    Coordinate{2.81417, 36.5036}, // QLD
    Coordinate{-49.8322, -26.1589}, // QMF
    Coordinate{7.25719, 35.8775}, // QMH
    Coordinate{49.2686, 32.0022}, // QMJ
    Coordinate{10.1431, 43.9856}, // QMM
    Coordinate{8.148, 49.9685}, // QMZ
    Coordinate{6.86472, 46.9575}, // QNC
    Coordinate{19.8339, 45.3857}, // QND
    Coordinate{6.26806, 46.1919}, // QNJ
    Coordinate{4.76889, 50.4881}, // QNM
    Coordinate{-43.4647, -22.7467}, // QNV
    Coordinate{4.79583, 46.2958}, // QNX
    Coordinate{-73.9728, 40.7339}, // QNY
    Coordinate{-56.0328, -28.6531}, // QOJ
    Coordinate{7.20583, 5.42694}, // QOW
    Coordinate{11.8481, 45.3958}, // QPA
    Coordinate{-83.6784, 22.4214}, // QPD
    Coordinate{27.1333, -22.5636}, // QPH
    Coordinate{18.241, 45.9909}, // QPJ
    Coordinate{-47.3442, -21.9844}, // QPS
    Coordinate{28.1511, -26.2425}, // QRA
    Coordinate{-70.7708, -34.1678}, // QRC
    Coordinate{-52.8156, -28.3214}, // QRE
    Coordinate{148.225, -32.2144}, // QRM
    Coordinate{-100.188, 20.6174}, // QRO
    Coordinate{147.803, -31.7333}, // QRR
    Coordinate{12.8503, 42.4261}, // QRT
    Coordinate{2.80278, 50.3239}, // QRV
    Coordinate{5.81944, 5.59722}, // QRW
    Coordinate{2.10503, 41.5209}, // QSA
    Coordinate{-47.9033, -21.8764}, // QSC
    Coordinate{5.28861, 36.1767}, // QSF
    Coordinate{37.3256, -3.36278}, // QSI
    Coordinate{-81.9208, 22.7564}, // QSN
    Coordinate{14.9125, 40.62}, // QSR
    Coordinate{-58.5892, 6.4225}, // QSX
    Coordinate{14.95, 51.3632}, // QTK
    Coordinate{12.8231, 26.5672}, // QUB
    Coordinate{-0.759167, 50.8594}, // QUG
    Coordinate{8.09889, 4.87583}, // QUO
    Coordinate{6.69611, 12.1717}, // QUS
    Coordinate{139.871, 36.5147}, // QUT
    Coordinate{8.88694, 45.7406}, // QVA
    Coordinate{-48.9842, -23.0931}, // QVP
    Coordinate{-80.67, 35.2139}, // QWG
    Coordinate{20.0219, 44.2978}, // QWV
    Coordinate{5.36, 43.505}, // QXB
    Coordinate{20.415, 53.7731}, // QYO
    Coordinate{4.01667, 48.3217}, // QYR
    Coordinate{22.8175, 53.1853}, // QYY
    Coordinate{0.626956, 35.7517}, // QZN
    Coordinate{152.379, -4.34028}, // RAB
    Coordinate{-87.8153, 42.7606}, // RAC
    Coordinate{41.1382, 30.9066}, // RAE
    Coordinate{-61.5042, -31.2844}, // RAF
    Coordinate{43.4906, 29.6264}, // RAH
    Coordinate{-23.4847, 14.9411}, // RAI
    Coordinate{70.7794, 22.3092}, // RAJ
    Coordinate{-8.04083, 31.6086}, // RAK
    Coordinate{-117.445, 33.9519}, // RAL
    Coordinate{134.898, -12.3567}, // RAM
    Coordinate{12.225, 44.3642}, // RAN
    Coordinate{-47.7767, -21.1364}, // RAO
    Coordinate{-103.057, 44.0453}, // RAP
    Coordinate{122.6, -4.8}, // RAQ
    Coordinate{-159.806, -21.2028}, // RAR
    Coordinate{49.6058, 37.3233}, // RAS
    Coordinate{77.33, 62.1583}, // RAT
    Coordinate{-70.2131, 6.32056}, // RAV
    Coordinate{-93.3456, 38.3469}, // RAW
    Coordinate{73.7981, 33.8497}, // RAZ
    Coordinate{-6.75167, 34.0514}, // RBA
    Coordinate{-59.5978, -4.40861}, // RBB
    Coordinate{142.117, -34.65}, // RBC
    Coordinate{-96.8683, 32.6808}, // RBD
    Coordinate{106.984, 13.7294}, // RBE
    Coordinate{-116.856, 34.2639}, // RBF
    Coordinate{-123.356, 43.2389}, // RBG
    Coordinate{141.039, 45.455}, // RBJ
    Coordinate{-117.129, 33.5742}, // RBK
    Coordinate{-122.252, 40.1508}, // RBL
    Coordinate{12.5192, 48.9017}, // RBM
    Coordinate{-59.7658, -18.3276}, // RBO
    Coordinate{-67.4981, -14.4275}, // RBQ
    Coordinate{-67.8981, -9.86889}, // RBR
    Coordinate{148.61, -37.79}, // RBS
    Coordinate{37.9842, 2.345}, // RBT
    Coordinate{157.643, -8.16806}, // RBV
    Coordinate{-80.6406, 32.9211}, // RBW
    Coordinate{29.67, 6.83}, // RBX
    Coordinate{-155.47, 64.7272}, // RBY
    Coordinate{32.0919, -28.7408}, // RCB
    Coordinate{-123.16, 48.6081}, // RCE
    Coordinate{-72.9258, 11.5261}, // RCH
    Coordinate{167.835, -15.472}, // RCL
    Coordinate{143.115, -20.7019}, // RCM
    Coordinate{-99.3047, 39.3467}, // RCP
    Coordinate{-59.68, -29.2103}, // RCQ
    Coordinate{-86.1817, 41.0656}, // RCR
    Coordinate{0.502778, 51.3519}, // RCS
    Coordinate{-85.5167, 43.9}, // RCT
    Coordinate{-64.2647, -33.0936}, // RCU
    Coordinate{-91.0006, 45.4969}, // RCX
    Coordinate{-74.8361, 23.6844}, // RCY
    Coordinate{-79.7597, 34.8914}, // RCZ
    Coordinate{-162.899, 68.0322}, // RDB
    Coordinate{-49.9806, -8.03111}, // RDC
    Coordinate{-122.293, 40.5089}, // RDD
    Coordinate{-75.9653, 40.3786}, // RDG
    Coordinate{-95.2589, 41.0108}, // RDK
    Coordinate{-121.15, 44.2542}, // RDM
    Coordinate{103.007, 5.76528}, // RDN
    Coordinate{21.2136, 51.3892}, // RDO
    Coordinate{87.2433, 23.6214}, // RDP
    Coordinate{-68.9043, -37.3906}, // RDS
    Coordinate{-15.6572, 16.4375}, // RDT
    Coordinate{-78.7875, 35.8778}, // RDU
    Coordinate{-157.35, 61.7881}, // RDV
    Coordinate{2.48278, 44.4078}, // RDZ
    Coordinate{-136.443, -18.4659}, // REA
    Coordinate{12.7522, 53.3052}, // REB
    Coordinate{-34.9228, -8.12639}, // REC
    Coordinate{-77.6269, 40.6775}, // RED
    Coordinate{15.6536, 38.0719}, // REG
    Coordinate{-52.132, 4.314}, // REI
    Coordinate{-65.2838, -43.2098}, // REL
    Coordinate{55.4567, 51.7958}, // REN
    Coordinate{-117.886, 42.5778}, // REO
    Coordinate{103.813, 13.4106}, // REP
    Coordinate{-91.6972, 14.5211}, // RER
    Coordinate{-59.0561, -27.45}, // RES
    Coordinate{12.1033, 67.5278}, // RET
    Coordinate{1.16722, 41.1475}, // REU
    Coordinate{-98.2283, 26.0086}, // REX
    Coordinate{-67.3917, -14.3233}, // REY
    Coordinate{-44.4817, -22.4786}, // REZ
    Coordinate{23.9281, 4.98957}, // RFA
    Coordinate{-89.0972, 42.1953}, // RFD
    Coordinate{-94.8517, 32.1417}, // RFI
    Coordinate{-15.9183, 66.4064}, // RFN
    Coordinate{-151.466, -16.723}, // RFP
    Coordinate{-84.4086, 13.8897}, // RFS
    Coordinate{-67.7539, -53.7811}, // RGA
    Coordinate{88.7956, 25.2617}, // RGH
    Coordinate{-147.659, -14.9564}, // RGI
    Coordinate{85.8333, 51.9667}, // RGK
    Coordinate{-69.3128, -51.6089}, // RGL
    Coordinate{96.1331, 16.9072}, // RGN
    Coordinate{129.649, 41.4297}, // RGO
    Coordinate{-3.61361, 42.3575}, // RGS
    Coordinate{102.335, -0.352222}, // RGT
    Coordinate{-64.9483, -27.5106}, // RHD
    Coordinate{29.6333, -1.5}, // RHG
    Coordinate{-89.4664, 45.6308}, // RHI
    Coordinate{28.1178, 36.3842}, // RHO
    Coordinate{86.0614, 27.3939}, // RHP
    Coordinate{101.644, 39.2133}, // RHT
    Coordinate{-121.82, 37.3328}, // RHV
    Coordinate{-53.6922, -29.7108}, // RIA
    Coordinate{-66.1167, -11.0167}, // RIB
    Coordinate{-77.3194, 37.505}, // RIC
    Coordinate{-84.8428, 39.7561}, // RID
    Coordinate{-91.7733, 45.42}, // RIE
    Coordinate{-52.1633, -32.0817}, // RIG
    Coordinate{-80.1297, 8.37583}, // RIH
    Coordinate{-77.16, -6.06806}, // RIJ
    Coordinate{-107.727, 39.5264}, // RIL
    Coordinate{157.143, -8.12639}, // RIN
    Coordinate{-117.41, 33.9889}, // RIR
    Coordinate{141.188, 45.2419}, // RIS
    Coordinate{-121.103, 38.4867}, // RIU
    Coordinate{-108.46, 43.0642}, // RIW
    Coordinate{23.9711, 56.9236}, // RIX
    Coordinate{49.375, 14.6625}, // RIY
    Coordinate{119.317, 35.3997}, // RIZ
    Coordinate{81.8183, 17.1083}, // RJA
    Coordinate{88.6163, 24.4369}, // RJH
    Coordinate{14.5703, 45.2169}, // RJK
    Coordinate{-2.32028, 42.4603}, // RJL
    Coordinate{56.0508, 30.2975}, // RJN
    Coordinate{-122.546, 41.7303}, // RKC
    Coordinate{-69.0992, 44.06}, // RKD
    Coordinate{12.1314, 55.5856}, // RKE
    Coordinate{-81.0572, 34.9878}, // RKH
    Coordinate{99.7044, -2.1001}, // RKI
    Coordinate{-97.0436, 28.0861}, // RKP
    Coordinate{-94.6211, 35.0217}, // RKR
    Coordinate{-109.065, 41.5942}, // RKS
    Coordinate{55.9389, 25.6136}, // RKT
    Coordinate{-21.9406, 64.13}, // RKV
    Coordinate{-84.6897, 35.9222}, // RKW
    Coordinate{89.3069, 29.3517}, // RKZ
    Coordinate{-119.304, 46.3056}, // RLD
    Coordinate{12.2783, 53.9183}, // RLG
    Coordinate{107.739, 40.9264}, // RLK
    Coordinate{-65.1858, -32.3845}, // RLO
    Coordinate{7.36, 18.7889}, // RLT
    Coordinate{148.775, -26.545}, // RMA
    Coordinate{55.7833, 24.2417}, // RMB
    Coordinate{81.8183, 17.1103}, // RMD
    Coordinate{-75.4069, 43.2339}, // RME
    Coordinate{34.5836, 25.5569}, // RMF
    Coordinate{-85.1586, 34.3508}, // RMG
    Coordinate{12.6094, 44.0194}, // RMI
    Coordinate{140.673, -34.1967}, // RMK
    Coordinate{79.8862, 6.82199}, // RML
    Coordinate{-77.4556, 38.3981}, // RMN
    Coordinate{-150.141, 65.5078}, // RMP
    Coordinate{-152.805, -22.6387}, // RMT
    Coordinate{-1.12411, 37.8036}, // RMU
    Coordinate{-120.039, 37.5108}, // RMY
    Coordinate{161.979, -9.85472}, // RNA
    Coordinate{15.265, 56.2667}, // RNB
    Coordinate{-85.8439, 35.6986}, // RNC
    Coordinate{3.99972, 46.0527}, // RNE
    Coordinate{-92.5391, 45.1478}, // RNH
    Coordinate{-83.0606, 12.1714}, // RNI
    Coordinate{128.402, 27.0439}, // RNJ
    Coordinate{160.071, -11.5583}, // RNL
    Coordinate{57.0506, 21.375}, // RNM
    Coordinate{14.7594, 55.0633}, // RNN
    Coordinate{-119.768, 39.4992}, // RNO
    Coordinate{166.887, 11.1572}, // RNP
    Coordinate{-1.73222, 48.0719}, // RNS
    Coordinate{-122.216, 47.4931}, // RNT
    Coordinate{-90.7578, 33.7611}, // RNV
    Coordinate{-87.1825, 40.9478}, // RNZ
    Coordinate{-79.9756, 37.3256}, // ROA
    Coordinate{-10.3622, 6.23389}, // ROB
    Coordinate{-77.6725, 43.1189}, // ROC
    Coordinate{19.8999, -33.8124}, // ROD
    Coordinate{-94.1069, 36.3725}, // ROG
    Coordinate{103.774, 16.1167}, // ROI
    Coordinate{150.475, -23.3817}, // ROK
    Coordinate{-73.1057, 5.76442}, // RON
    Coordinate{-62.7092, -16.5853}, // ROO
    Coordinate{145.242, 14.1744}, // ROP
    Coordinate{134.544, 7.36722}, // ROR
    Coordinate{-60.7844, -32.9036}, // ROS
    Coordinate{176.317, -38.1092}, // ROT
    Coordinate{39.924, 47.4716}, // ROV
    Coordinate{-104.531, 33.3016}, // ROW
    Coordinate{-70.4206, -46.2094}, // ROY
    Coordinate{-97.6597, 39.8178}, // RPB
    Coordinate{-89.0783, 41.8931}, // RPJ
    Coordinate{4.15667, 49.2086}, // RPK
    Coordinate{134.747, -14.7228}, // RPM
    Coordinate{35.5719, 32.981}, // RPN
    Coordinate{81.7385, 21.1803}, // RPR
    Coordinate{-108.543, 46.475}, // RPX
    Coordinate{-109.067, 35.6519}, // RQE
    Coordinate{-98.0058, 35.4728}, // RQO
    Coordinate{63.3608, -19.7575}, // RRG
    Coordinate{84.8097, 22.2565}, // RRK
    Coordinate{-89.7128, 45.1989}, // RRL
    Coordinate{-142.477, -16.045}, // RRR
    Coordinate{11.3423, 62.5784}, // RRS
    Coordinate{-95.3483, 48.9414}, // RRT
    Coordinate{-64.2794, -36.5919}, // RSA
    Coordinate{-76.1778, 24.8917}, // RSD
    Coordinate{151.255, -33.8706}, // RSE
    Coordinate{-161.319, 61.775}, // RSH
    Coordinate{-122.868, 48.6456}, // RSJ
    Coordinate{-92.5883, 32.5147}, // RSN
    Coordinate{34.3364, 11.7858}, // RSS
    Coordinate{-92.5, 43.9083}, // RST
    Coordinate{127.617, 34.8423}, // RSU
    Coordinate{-87.6497, 39.0161}, // RSV
    Coordinate{-81.7553, 26.5361}, // RSW
    Coordinate{177.071, -12.4825}, // RTA
    Coordinate{-86.5222, 16.3172}, // RTB
    Coordinate{73.3278, 17.0122}, // RTC
    Coordinate{}, // RTG
    Coordinate{-95.1392, 43.3875}, // RTL
    Coordinate{4.43333, 51.95}, // RTM
    Coordinate{-104.502, 36.7417}, // RTN
    Coordinate{115.54, -32.0067}, // RTS
    Coordinate{46.0467, 51.565}, // RTW
    Coordinate{30.9122, 3.04722}, // RUA
    Coordinate{55.1042, 36.4253}, // RUD
    Coordinate{-93.0933, 35.2592}, // RUE
    Coordinate{-100.024, 48.3903}, // RUG
    Coordinate{46.6989, 24.9578}, // RUH
    Coordinate{-105.535, 33.4628}, // RUI
    Coordinate{82.1942, 28.6272}, // RUK
    Coordinate{86.5506, 27.3036}, // RUM
    Coordinate{55.5164, -20.89}, // RUN
    Coordinate{89.9067, 26.1397}, // RUP
    Coordinate{-151.368, -22.4335}, // RUR
    Coordinate{160.825, -9.86167}, // RUS
    Coordinate{-72.9497, 43.53}, // RUT
    Coordinate{-90.4453, 15.992}, // RUV
    Coordinate{-89.0078, 14.9167}, // RUY
    Coordinate{47.8203, -22.805}, // RVA
    Coordinate{-50.9561, -17.8347}, // RVD
    Coordinate{-71.9, 6.91667}, // RVE
    Coordinate{30.5883, 59.98}, // RVH
    Coordinate{39.8183, 47.2583}, // RVI
    Coordinate{11.1461, 64.8383}, // RVK
    Coordinate{25.8308, 66.5617}, // RVN
    Coordinate{-110.228, 38.9614}, // RVR
    Coordinate{-95.9846, 36.0396}, // RVS
    Coordinate{120.208, -33.7972}, // RVT
    Coordinate{-147.7, -23.8861}, // RVV
    Coordinate{-55.4761, -30.9744}, // RVY
    Coordinate{-77.8919, 35.8564}, // RWI
    Coordinate{-107.2, 41.8056}, // RWL
    Coordinate{26.1417, 50.6072}, // RWN
    Coordinate{-96.7042, 30.5156}, // RWV
    Coordinate{-111.805, 43.8339}, // RXE
    Coordinate{122.752, 11.5978}, // RXS
    Coordinate{38.925, 58.1017}, // RYB
    Coordinate{10.7856, 59.3789}, // RYG
    Coordinate{70.2797, 28.3839}, // RYK
    Coordinate{-111.174, 32.1422}, // RYN
    Coordinate{-72.2219, -51.6092}, // RYO
    Coordinate{-88.7233, 43.1697}, // RYV
    Coordinate{-84.5986, 34.0131}, // RYY
    Coordinate{-68.5792, -50.0167}, // RZA
    Coordinate{22.0189, 50.11}, // RZE
    Coordinate{39.855, 54.555}, // RZN
    Coordinate{119.508, 10.8189}, // RZP
    Coordinate{50.6796, 36.9092}, // RZR
    Coordinate{68.8739, 26.9594}, // RZS
    Coordinate{-77.7094, 36.4394}, // RZZ
    Coordinate{-106.824, 41.4447}, // SAA
    Coordinate{-63.2206, 17.6456}, // SAB
    Coordinate{-121.493, 38.5125}, // SAC
    Coordinate{-109.635, 32.8533}, // SAD
    Coordinate{-106.089, 35.6172}, // SAF
    Coordinate{74.3789, 19.6886}, // SAG
    Coordinate{44.2197, 15.4764}, // SAH
    Coordinate{-19.5728, 65.7317}, // SAK
    Coordinate{-89.0557, 13.4409}, // SAL
    Coordinate{150.789, -9.67133}, // SAM
    Coordinate{-117.19, 32.7336}, // SAN
    Coordinate{-87.9236, 15.4528}, // SAP
    Coordinate{-78.05, 25.05}, // SAQ
    Coordinate{-115.952, 33.2411}, // SAS
    Coordinate{-98.472, 29.527}, // SAT
    Coordinate{121.898, -10.4278}, // SAU
    Coordinate{-81.2022, 32.1275}, // SAV
    Coordinate{29.3092, 40.8983}, // SAW
    Coordinate{11.2549, 43.2564}, // SAY
    Coordinate{-8.43333, 4.66667}, // SAZ
    Coordinate{-119.84, 34.4261}, // SBA
    Coordinate{-71.1657, 7.80278}, // SBB
    Coordinate{-117.235, 34.0953}, // SBD
    Coordinate{68.6365, 33.321}, // SBF
    Coordinate{95.3416, 5.8745}, // SBG
    Coordinate{-62.8439, 17.9044}, // SBH
    Coordinate{-13.3585, 12.5727}, // SBI
    Coordinate{-39.8336, -18.7214}, // SBJ
    Coordinate{-2.85667, 48.5375}, // SBK
    Coordinate{-65.4353, -13.7622}, // SBL
    Coordinate{-87.8517, 43.7697}, // SBM
    Coordinate{-86.3172, 41.7083}, // SBN
    Coordinate{-111.838, 39.0292}, // SBO
    Coordinate{-120.642, 35.2369}, // SBP
    Coordinate{67.8431, 29.5744}, // SBQ
    Coordinate{142.625, -9.37833}, // SBR
    Coordinate{-106.866, 40.5161}, // SBS
    Coordinate{72.0522, 71.2192}, // SBT
    Coordinate{111.985, 2.26139}, // SBW
    Coordinate{-111.871, 48.5406}, // SBX
    Coordinate{-75.5094, 38.34}, // SBY
    Coordinate{24.0856, 45.7858}, // SBZ
    Coordinate{-96.63, 41.6103}, // SCB
    Coordinate{-148.465, 70.1947}, // SCC
    Coordinate{-86.3056, 33.1719}, // SCD
    Coordinate{-77.8486, 40.8492}, // SCE
    Coordinate{-111.911, 33.6228}, // SCF
    Coordinate{-73.9289, 42.8525}, // SCH
    Coordinate{-72.2015, 7.80504}, // SCI
    Coordinate{-121.238, 37.8942}, // SCK
    Coordinate{-70.7856, -33.3928}, // SCL
    Coordinate{-165.571, 61.8453}, // SCM
    Coordinate{7.10944, 49.2144}, // SCN
    Coordinate{51.0919, 43.86}, // SCO
    Coordinate{6.59917, 44.7006}, // SCP
    Coordinate{-8.41514, 42.8963}, // SCQ
    Coordinate{-1.29611, 60.4328}, // SCS
    Coordinate{53.9056, 12.6306}, // SCT
    Coordinate{-75.8356, 19.97}, // SCU
    Coordinate{26.354, 47.6875}, // SCV
    Coordinate{50.8383, 61.6417}, // SCW
    Coordinate{-95.2014, 16.2125}, // SCX
    Coordinate{-89.6175, -0.910278}, // SCY
    Coordinate{165.798, -10.7197}, // SCZ
    Coordinate{-77.1194, 43.2347}, // SDC
    Coordinate{13.5767, -14.9333}, // SDD
    Coordinate{-64.2997, -27.7561}, // SDE
    Coordinate{-85.7364, 38.1742}, // SDF
    Coordinate{47.0092, 35.2459}, // SDG
    Coordinate{-88.775, 14.7772}, // SDH
    Coordinate{146.465, -5.62859}, // SDI
    Coordinate{140.917, 38.1397}, // SDJ
    Coordinate{118.059, 5.90083}, // SDK
    Coordinate{17.4428, 62.5281}, // SDL
    Coordinate{-116.98, 32.5722}, // SDM
    Coordinate{6.10583, 61.83}, // SDN
    Coordinate{20.9629, 44.6447}, // SDO
    Coordinate{-160.521, 55.3136}, // SDP
    Coordinate{-69.6689, 18.4297}, // SDQ
    Coordinate{-3.82, 43.4269}, // SDR
    Coordinate{138.414, 38.0611}, // SDS
    Coordinate{72.35, 34.8078}, // SDT
    Coordinate{-43.1628, -22.9103}, // SDU
    Coordinate{34.7794, 32.1108}, // SDV
    Coordinate{-111.79, 34.85}, // SDX
    Coordinate{-104.192, 47.7069}, // SDY
    Coordinate{-122.309, 47.4489}, // SEA
    Coordinate{14.4725, 26.987}, // SEB
    Coordinate{-116.973, 32.8261}, // SEE
    Coordinate{-81.3425, 27.4564}, // SEF
    Coordinate{-76.8642, 40.8211}, // SEG
    Coordinate{153.716, 67.4633}, // SEK
    Coordinate{-86.9878, 32.3439}, // SEM
    Coordinate{0.693333, 51.5703}, // SEN
    Coordinate{-6.64422, 7.96}, // SEO
    Coordinate{102.14, 1.37127}, // SEQ
    Coordinate{-85.9083, 38.9247}, // SER
    Coordinate{-86.9536, 32.4389}, // SES
    Coordinate{34.8214, -2.45694}, // SEU
    Coordinate{25.5053, 29.3469}, // SEW
    Coordinate{-12.2072, 15.1794}, // SEY
    Coordinate{55.5219, -4.67434}, // SEZ
    Coordinate{10.6886, 34.7178}, // SFA
    Coordinate{-81.2375, 28.7778}, // SFB
    Coordinate{-61.27, 15.8686}, // SFC
    Coordinate{-67.4439, 7.88306}, // SFD
    Coordinate{120.303, 16.5956}, // SFE
    Coordinate{-117.323, 47.6831}, // SFF
    Coordinate{-63.0472, 18.0999}, // SFG
    Coordinate{-114.816, 30.9303}, // SFH
    Coordinate{-50.6894, 67.0169}, // SFJ
    Coordinate{18.0936, 46.8572}, // SFK
    Coordinate{-24.48, 14.885}, // SFL
    Coordinate{-70.7081, 43.3939}, // SFM
    Coordinate{-60.8089, -31.7117}, // SFN
    Coordinate{-122.375, 37.6189}, // SFO
    Coordinate{38.8469, 37.0942}, // SFQ
    Coordinate{120.271, 14.7944}, // SFS
    Coordinate{21.0769, 64.6247}, // SFT
    Coordinate{-71.4914, 41.9208}, // SFZ
    Coordinate{71.5, 37.5667}, // SGA
    Coordinate{73.4022, 61.3439}, // SGC
    Coordinate{9.79173, 54.9644}, // SGD
    Coordinate{8.08306, 50.7078}, // SGE
    Coordinate{-93.3886, 37.2456}, // SGF
    Coordinate{-83.8403, 39.8403}, // SGH
    Coordinate{144.323, -5.125}, // SGK
    Coordinate{-73.1289, 6.59028}, // SGL
    Coordinate{-112.939, 27.2969}, // SGM
    Coordinate{106.652, 10.8189}, // SGN
    Coordinate{148.595, -28.05}, // SGO
    Coordinate{120.14, -20.425}, // SGP
    Coordinate{-95.6567, 29.6222}, // SGR
    Coordinate{119.743, 5.04694}, // SGS
    Coordinate{-91.575, 34.5995}, // SGT
    Coordinate{-113.51, 37.0364}, // SGU
    Coordinate{-65.3503, -41.5917}, // SGV
    Coordinate{-134.158, 56.8864}, // SGW
    Coordinate{35.5811, -10.6808}, // SGX
    Coordinate{-135.316, 59.46}, // SGY
    Coordinate{100.617, 7.18333}, // SGZ
    Coordinate{121.336, 31.1981}, // SHA
    Coordinate{144.96, 43.5775}, // SHB
    Coordinate{38.2708, 14.0794}, // SHC
    Coordinate{-78.8964, 38.2639}, // SHD
    Coordinate{123.484, 41.64}, // SHE
    Coordinate{85.8911, 44.2417}, // SHF
    Coordinate{-157.163, 66.8881}, // SHG
    Coordinate{-166.089, 66.2494}, // SHH
    Coordinate{125.145, 24.8267}, // SHI
    Coordinate{55.5172, 25.3286}, // SHJ
    Coordinate{28.7689, -29.7308}, // SHK
    Coordinate{91.978, 25.7032}, // SHL
    Coordinate{135.364, 33.6622}, // SHM
    Coordinate{-123.147, 47.2336}, // SHN
    Coordinate{128.598, 38.1425}, // SHO
    Coordinate{153.372, -27.9217}, // SHQ
    Coordinate{-106.98, 44.7692}, // SHR
    Coordinate{112.279, 30.3222}, // SHS
    Coordinate{145.393, -36.4289}, // SHT
    Coordinate{132.158, -11.1328}, // SHU
    Coordinate{-93.8256, 32.4467}, // SHV
    Coordinate{47.1211, 17.4669}, // SHW
    Coordinate{-159.569, 62.6922}, // SHX
    Coordinate{33.5, -3.61}, // SHY
    Coordinate{28.5536, -29.2667}, // SHZ
    Coordinate{109.12, 34.3767}, // SIA
    Coordinate{13.4, -3.74639}, // SIB
    Coordinate{-79.0778, 8.2625}, // SIC
    Coordinate{-22.95, 16.7376}, // SID
    Coordinate{84.98, 27.1594}, // SIF
    Coordinate{-66.0988, 18.4567}, // SIG
    Coordinate{-10.1847, 29.3672}, // SII
    Coordinate{-18.9167, 66.1333}, // SIJ
    Coordinate{-89.5617, 36.8989}, // SIK
    Coordinate{103.989, 1.35917}, // SIN
    Coordinate{145.083, -40.835}, // SIO
    Coordinate{33.9753, 45.0522}, // SIP
    Coordinate{104.579, -0.4788}, // SIQ
    Coordinate{7.32676, 46.2196}, // SIR
    Coordinate{23, -27.65}, // SIS
    Coordinate{-135.362, 57.0472}, // SIT
    Coordinate{-84.7769, 13.7167}, // SIU
    Coordinate{-87.4483, 39.1147}, // SIV
    Coordinate{98.9322, 2.667}, // SIW
    Coordinate{98.8905, 1.55446}, // SIX
    Coordinate{-122.468, 41.7814}, // SIY
    Coordinate{-64.8167, -13.0667}, // SJB
    Coordinate{-121.929, 37.3628}, // SJC
    Coordinate{-109.721, 23.1517}, // SJD
    Coordinate{-72.6393, 2.57972}, // SJE
    Coordinate{121.047, 12.3614}, // SJI
    Coordinate{18.3314, 43.8247}, // SJJ
    Coordinate{-45.8711, -23.2289}, // SJK
    Coordinate{-66.9858, -0.14806}, // SJL
    Coordinate{-71.2333, 18.8333}, // SJM
    Coordinate{-109.379, 34.5186}, // SJN
    Coordinate{-84.2089, 9.99389}, // SJO
    Coordinate{-49.4047, -20.8161}, // SJP
    Coordinate{-49.9158, -28.2589}, // SJQ
    Coordinate{-60.8, -17.8324}, // SJS
    Coordinate{-100.496, 31.355}, // SJT
    Coordinate{-66.0019, 18.4392}, // SJU
    Coordinate{-62.4704, -16.2667}, // SJV
    Coordinate{114.697, 38.2808}, // SJW
    Coordinate{-88.1308, 18.3556}, // SJX
    Coordinate{22.8319, 62.6936}, // SJY
    Coordinate{-28.1703, 38.6628}, // SJZ
    Coordinate{-62.7186, 17.3111}, // SKB
    Coordinate{141.8, -8.08333}, // SKC
    Coordinate{66.9839, 39.7006}, // SKD
    Coordinate{9.56694, 59.185}, // SKE
    Coordinate{-98.5811, 29.4842}, // SKF
    Coordinate{22.9709, 40.5197}, // SKG
    Coordinate{81.6358, 28.5858}, // SKH
    Coordinate{6.95108, 36.8627}, // SKI
    Coordinate{-161.224, 64.3711}, // SKK
    Coordinate{-5.82417, 57.2536}, // SKL
    Coordinate{15.0261, 68.5808}, // SKN
    Coordinate{5.20694, 12.9161}, // SKO
    Coordinate{21.6214, 41.9616}, // SKP
    Coordinate{28.3703, -30.0389}, // SKQ
    Coordinate{38.975, 5.69167}, // SKR
    Coordinate{9.29078, 55.2219}, // SKS
    Coordinate{74.3639, 32.5356}, // SKT
    Coordinate{24.4872, 38.9675}, // SKU
    Coordinate{34.0625, 28.6853}, // SKV
    Coordinate{-151.191, 61.9653}, // SKW
    Coordinate{45.215, 54.125}, // SKX
    Coordinate{-82.6522, 41.4333}, // SKY
    Coordinate{68.7917, 27.7219}, // SKZ
    Coordinate{-65.4786, -24.8444}, // SLA
    Coordinate{-95.2407, 42.5972}, // SLB
    Coordinate{-111.978, 40.7883}, // SLC
    Coordinate{19.1342, 48.6381}, // SLD
    Coordinate{-123.003, 44.9094}, // SLE
    Coordinate{-94.49, 36.1919}, // SLG
    Coordinate{167.537, -13.8517}, // SLH
    Coordinate{26.3667, -12.1742}, // SLI
    Coordinate{117.762, -22.2553}, // SLJ
    Coordinate{-74.2061, 44.3853}, // SLK
    Coordinate{54.0922, 17.0389}, // SLL
    Coordinate{-5.50194, 40.9519}, // SLM
    Coordinate{-97.6522, 38.7906}, // SLN
    Coordinate{-88.9642, 38.6428}, // SLO
    Coordinate{-100.931, 22.2543}, // SLP
    Coordinate{-157.166, 61.7006}, // SLQ
    Coordinate{-95.6211, 33.1597}, // SLR
    Coordinate{27.1799, 44.055}, // SLS
    Coordinate{-106.049, 38.5383}, // SLT
    Coordinate{-60.9931, 14.02}, // SLU
    Coordinate{77.0679, 31.0817}, // SLV
    Coordinate{-100.929, 25.5494}, // SLW
    Coordinate{-71.2, 21.3333}, // SLX
    Coordinate{66.5866, 66.5901}, // SLY
    Coordinate{-44.2361, -2.58694}, // SLZ
    Coordinate{-25.1706, 36.9714}, // SMA
    Coordinate{-69.3373, -52.7367}, // SMB
    Coordinate{19.6599, 45.0365}, // SMC
    Coordinate{-85.1528, 41.1433}, // SMD
    Coordinate{-84.6156, 37.0536}, // SME
    Coordinate{-121.591, 38.6956}, // SMF
    Coordinate{-76.7681, -12.4}, // SMG
    Coordinate{26.9117, 37.69}, // SMI
    Coordinate{-162.11, 63.49}, // SMK
    Coordinate{-75.2793, 23.5901}, // SML
    Coordinate{118.596, 4.44972}, // SMM
    Coordinate{-113.881, 45.1239}, // SMN
    Coordinate{-118.451, 34.0158}, // SMO
    Coordinate{151.55, -4.35}, // SMP
    Coordinate{112.975, -2.49917}, // SMQ
    Coordinate{-74.2306, 11.1194}, // SMR
    Coordinate{49.8158, -17.0939}, // SMS
    Coordinate{-55.6689, -12.4728}, // SMT
    Coordinate{9.88389, 46.5339}, // SMV
    Coordinate{-11.6847, 26.7317}, // SMW
    Coordinate{-120.457, 34.8989}, // SMX
    Coordinate{-13.3, 13.0467}, // SMY
    Coordinate{-54.4167, 4.35}, // SMZ
    Coordinate{-117.868, 33.6756}, // SNA
    Coordinate{130.654, -11.4228}, // SNB
    Coordinate{-80.9889, -2.205}, // SNC
    Coordinate{-24.2839, 16.5881}, // SNE
    Coordinate{-68.7332, 10.2834}, // SNF
    Coordinate{-60.9778, -16.3847}, // SNG
    Coordinate{151.491, -28.6203}, // SNH
    Coordinate{-9.0668, 5.03432}, // SNI
    Coordinate{-100.948, 32.6996}, // SNK
    Coordinate{-96.9428, 35.3572}, // SNL
    Coordinate{-65.6434, -14.9667}, // SNM
    Coordinate{-8.92472, 52.7019}, // SNN
    Coordinate{104.112, 17.1951}, // SNO
    Coordinate{-170.221, 57.1672}, // SNP
    Coordinate{-2.16111, 47.3106}, // SNR
    Coordinate{-121.606, 36.6628}, // SNS
    Coordinate{-73.5056, 7.38333}, // SNT
    Coordinate{-79.9436, 22.4922}, // SNU
    Coordinate{-61.1447, 4.55472}, // SNV
    Coordinate{94.3, 18.4564}, // SNW
    Coordinate{-69.3852, 19.0619}, // SNX
    Coordinate{-102.985, 41.0997}, // SNY
    Coordinate{-43.7192, -22.9322}, // SNZ
    Coordinate{17.1592, 46.6864}, // SOB
    Coordinate{110.757, -7.51611}, // SOC
    Coordinate{-47.4864, -23.4831}, // SOD
    Coordinate{14.1333, 2}, // SOE
    Coordinate{23.4083, 42.695}, // SOF
    Coordinate{7.13778, 61.1561}, // SOG
    Coordinate{20.9597, 69.7867}, // SOJ
    Coordinate{28.06, -29.8383}, // SOK
    Coordinate{-64.1511, 8.94528}, // SOM
    Coordinate{167.22, -15.505}, // SON
    Coordinate{17.0983, 61.2614}, // SOO
    Coordinate{-79.3911, 35.2372}, // SOP
    Coordinate{131.289, -0.894167}, // SOQ
    Coordinate{-1.35667, 50.9503}, // SOU
    Coordinate{-151.704, 59.4425}, // SOV
    Coordinate{-110.006, 34.2656}, // SOW
    Coordinate{-72.9703, 5.67732}, // SOX
    Coordinate{-2.64139, 59.1553}, // SOY
    Coordinate{-81.9565, 34.9157}, // SPA
    Coordinate{-64.9408, 18.3386}, // SPB
    Coordinate{-17.7556, 28.6264}, // SPC
    Coordinate{88.9085, 25.7592}, // SPD
    Coordinate{-103.783, 44.4803}, // SPF
    Coordinate{-82.6269, 27.765}, // SPG
    Coordinate{-89.6781, 39.8442}, // SPI
    Coordinate{22.5167, 36.9667}, // SPJ
    Coordinate{20.9596, 44.3499}, // SPL
    Coordinate{-69.3, 18.45}, // SPM
    Coordinate{145.729, 15.1189}, // SPN
    Coordinate{17.7196, -14.6576}, // SPP
    Coordinate{-87.9711, 17.9139}, // SPR
    Coordinate{-98.4919, 33.9889}, // SPS
    Coordinate{16.2981, 43.5389}, // SPU
    Coordinate{20.1294, 44.9762}, // SPV
    Coordinate{-95.2028, 43.1656}, // SPW
    Coordinate{30.8944, 30.1097}, // SPX
    Coordinate{-6.66082, 4.74672}, // SPY
    Coordinate{-94.1192, 36.1764}, // SPZ
    Coordinate{-120.076, 34.6069}, // SQA
    Coordinate{119.358, -31.2417}, // SQC
    Coordinate{117.961, 28.3803}, // SQD
    Coordinate{111.475, 0.0636111}, // SQG
    Coordinate{104.035, 21.2147}, // SQH
    Coordinate{117.845, 26.4281}, // SQJ
    Coordinate{-122.249, 37.5119}, // SQL
    Coordinate{17.6967, 64.9556}, // SQO
    Coordinate{23.3947, 55.8939}, // SQQ
    Coordinate{121.283, -2.5377}, // SQR
    Coordinate{-89.0098, 17.1859}, // SQS
    Coordinate{-123.187, 48.0981}, // SQV
    Coordinate{9.17278, 56.55}, // SQW
    Coordinate{-53.5033, -26.7811}, // SQX
    Coordinate{-52.0328, -31.3833}, // SQY
    Coordinate{-54.5222, -27.9089}, // SRA
    Coordinate{-66.7872, -14.0729}, // SRB
    Coordinate{-91.7375, 35.2106}, // SRC
    Coordinate{-64.7, -13.2833}, // SRD
    Coordinate{-65.1491, -19.2383}, // SRE
    Coordinate{110.374, -6.97139}, // SRG
    Coordinate{18.3794, 9.15111}, // SRH
    Coordinate{117.159, -0.481667}, // SRI
    Coordinate{-66.75, -14.8667}, // SRJ
    Coordinate{145.291, -42.1556}, // SRN
    Coordinate{5.33972, 59.7928}, // SRP
    Coordinate{-82.5544, 27.3956}, // SRQ
    Coordinate{33.6187, 1.72231}, // SRT
    Coordinate{-156.589, 61.7897}, // SRV
    Coordinate{-80.5203, 35.6458}, // SRW
    Coordinate{53.1936, 36.6358}, // SRY
    Coordinate{-63.1714, -17.8114}, // SRZ
    Coordinate{-38.3225, -12.9086}, // SSA
    Coordinate{-64.705, 17.7472}, // SSB
    Coordinate{-70.705, -32.7458}, // SSD
    Coordinate{75.934, 17.6274}, // SSE
    Coordinate{-98.4711, 29.3369}, // SSF
    Coordinate{8.70861, 3.755}, // SSG
    Coordinate{34.3947, 27.9772}, // SSH
    Coordinate{-81.3914, 31.1519}, // SSI
    Coordinate{12.4689, 65.9567}, // SSJ
    Coordinate{-70.8686, 5.13056}, // SSL
    Coordinate{-84.3683, 46.4792}, // SSM
    Coordinate{-45.0453, -22.0917}, // SSO
    Coordinate{-79.1792, 48.9167}, // SSQ
    Coordinate{168.153, -15.4715}, // SSR
    Coordinate{-56.7217, -36.55}, // SST
    Coordinate{14.2471, -6.26986}, // SSY
    Coordinate{8.35389, 55.99}, // STA
    Coordinate{-71.9428, 8.97417}, // STB
    Coordinate{-94.06, 45.5467}, // STC
    Coordinate{-72.035, 7.565}, // STD
    Coordinate{-89.5303, 44.545}, // STE
    Coordinate{-88.8486, 33.4331}, // STF
    Coordinate{-169.664, 56.5772}, // STG
    Coordinate{-113.56, 51.1342}, // STH
    Coordinate{-70.6047, 19.4061}, // STI
    Coordinate{-94.9097, 39.7719}, // STJ
    Coordinate{-54.7858, -2.42472}, // STM
    Coordinate{0.235, 51.885}, // STN
    Coordinate{-93.06, 44.9344}, // STP
    Coordinate{-78.5025, 41.4125}, // STQ
    Coordinate{9.22194, 48.69}, // STR
    Coordinate{-64.9733, 18.3372}, // STT
    Coordinate{72.7428, 21.1153}, // STV
    Coordinate{42.1133, 45.11}, // STW
    Coordinate{-64.8017, 17.7044}, // STX
    Coordinate{-57.9853, -31.4386}, // STY
    Coordinate{-50.5186, -10.4647}, // STZ
    Coordinate{-80.2211, 27.1817}, // SUA
    Coordinate{112.767, -7.38056}, // SUB
    Coordinate{-96.6556, 35.7894}, // SUD
    Coordinate{-87.4217, 44.8436}, // SUE
    Coordinate{16.2422, 38.9053}, // SUF
    Coordinate{125.473, 9.40819}, // SUG
    Coordinate{59.4778, 22.5361}, // SUH
    Coordinate{41.1281, 42.8581}, // SUI
    Coordinate{22.8856, 47.7033}, // SUJ
    Coordinate{130.391, 67.7919}, // SUK
    Coordinate{69.1667, 28.6333}, // SUL
    Coordinate{-80.3614, 33.995}, // SUM
    Coordinate{-114.296, 43.5039}, // SUN
    Coordinate{-121.453, 43.8764}, // SUO
    Coordinate{113.89, -7.02425}, // SUP
    Coordinate{-78.1694, -2.47083}, // SUQ
    Coordinate{-88.5419, 52.7086}, // SUR
    Coordinate{-90.6519, 38.6622}, // SUS
    Coordinate{31.6103, -7.94889}, // SUT
    Coordinate{178.559, -18.0447}, // SUV
    Coordinate{-92.0947, 46.6897}, // SUW
    Coordinate{-96.3844, 42.4025}, // SUX
    Coordinate{117.635, 62.185}, // SUY
    Coordinate{-61.8893, -37.4462}, // SUZ
    Coordinate{-170.492, 63.6864}, // SVA
    Coordinate{50.1747, -14.2786}, // SVB
    Coordinate{-108.156, 32.6367}, // SVC
    Coordinate{-61.1503, 13.1564}, // SVD
    Coordinate{-120.573, 40.3756}, // SVE
    Coordinate{2.46458, 8.01817}, // SVF
    Coordinate{5.63778, 58.8767}, // SVG
    Coordinate{-74.7667, 2.15}, // SVI
    Coordinate{14.6692, 68.2433}, // SVJ
    Coordinate{-88.3692, 16.7284}, // SVK
    Coordinate{28.945, 61.9428}, // SVL
    Coordinate{37.4146, 55.9726}, // SVO
    Coordinate{16.9474, -12.4049}, // SVP
    Coordinate{-5.89889, 37.4181}, // SVQ
    Coordinate{-149.054, 66.0169}, // SVS
    Coordinate{24.0767, -18.5206}, // SVT
    Coordinate{179.341, -16.8028}, // SVU
    Coordinate{-155.575, 61.0972}, // SVW
    Coordinate{60.8036, 56.7414}, // SVX
    Coordinate{-72.4397, 7.84083}, // SVZ
    Coordinate{116.415, 23.5686}, // SWA
    Coordinate{142.74, -37.0717}, // SWC
    Coordinate{-149.419, 60.1269}, // SWD
    Coordinate{143.935, -6.72217}, // SWE
    Coordinate{-74.1047, 41.5042}, // SWF
    Coordinate{143.549, -35.3758}, // SWH
    Coordinate{-96.5861, 33.6242}, // SWI
    Coordinate{167.438, -16.495}, // SWJ
    Coordinate{-97.0856, 36.1611}, // SWO
    Coordinate{14.5667, -22.6583}, // SWP
    Coordinate{117.414, -8.48861}, // SWQ
    Coordinate{-4.06778, 51.6053}, // SWS
    Coordinate{77.66, 60.7083}, // SWT
    Coordinate{159.23, 61.9217}, // SWV
    Coordinate{-100.466, 32.4672}, // SWW
    Coordinate{21.8167, -18.3742}, // SWX
    Coordinate{100.699, 4.21639}, // SWY
    Coordinate{7.63444, 48.5419}, // SXB
    Coordinate{146.965, -38.0917}, // SXE
    Coordinate{13.5206, 52.3786}, // SXF
    Coordinate{23.2667, -16.1125}, // SXG
    Coordinate{54.5394, 25.9083}, // SXI
    Coordinate{-8.59921, 54.2802}, // SXL
    Coordinate{-63.1094, 18.0408}, // SXM
    Coordinate{26.1156, -20.5534}, // SXN
    Coordinate{-50.6883, -11.6319}, // SXO
    Coordinate{-164.848, 62.5206}, // SXP
    Coordinate{-151.038, 60.475}, // SXQ
    Coordinate{74.7742, 33.9871}, // SXR
    Coordinate{37.7667, 6.83333}, // SXU
    Coordinate{78.0641, 11.7812}, // SXV
    Coordinate{-51.99, -6.64028}, // SXX
    Coordinate{-75.4161, 42.3025}, // SXY
    Coordinate{41.8392, 37.9781}, // SXZ
    Coordinate{-152.202, 58.3717}, // SYB
    Coordinate{151.177, -33.9461}, // SYD
    Coordinate{43.7292, 16.9667}, // SYE
    Coordinate{86.7103, 27.8092}, // SYH
    Coordinate{-86.4425, 35.5594}, // SYI
    Coordinate{55.6717, 29.5508}, // SYJ
    Coordinate{-22.7942, 65.0581}, // SYK
    Coordinate{100.959, 22.7933}, // SYM
    Coordinate{-93.0164, 44.4756}, // SYN
    Coordinate{139.787, 38.8122}, // SYO
    Coordinate{-80.9453, 8.08556}, // SYP
    Coordinate{-84.1394, 9.95722}, // SYQ
    Coordinate{-76.1064, 43.1111}, // SYR
    Coordinate{114.082, 71.9289}, // SYS
    Coordinate{4.02111, 46.4064}, // SYT
    Coordinate{142.823, -10.2083}, // SYU
    Coordinate{67.7172, 26.4731}, // SYW
    Coordinate{109.412, 18.3029}, // SYX
    Coordinate{-6.33111, 58.2156}, // SYY
    Coordinate{52.59, 29.5392}, // SYZ
    Coordinate{12.3667, -6.14106}, // SZA
    Coordinate{101.549, 3.13056}, // SZB
    Coordinate{40.9917, 11.7875}, // SZE
    Coordinate{36.5486, 41.2656}, // SZF
    Coordinate{13.0033, 47.7944}, // SZG
    Coordinate{84.8862, 47.4872}, // SZI
    Coordinate{-82.955, 21.6425}, // SZJ
    Coordinate{31.5886, -24.9609}, // SZK
    Coordinate{-119.915, 34.0606}, // SZN
    Coordinate{-119.062, 34.3469}, // SZP
    Coordinate{25.6552, 42.3767}, // SZR
    Coordinate{168.102, -46.8997}, // SZS
    Coordinate{-92.5303, 16.69}, // SZT
    Coordinate{120.401, 31.2631}, // SZV
    Coordinate{11.7834, 53.427}, // SZW
    Coordinate{113.811, 22.6394}, // SZX
    Coordinate{20.9378, 53.4819}, // SZY
    Coordinate{14.9022, 53.5847}, // SZZ
    Coordinate{-60.8322, 11.1497}, // TAB
    Coordinate{125.028, 11.2275}, // TAC
    Coordinate{-104.341, 37.2594}, // TAD
    Coordinate{128.659, 35.8942}, // TAE
    Coordinate{-0.533894, 35.5411}, // TAF
    Coordinate{123.853, 9.66408}, // TAG
    Coordinate{169.224, -19.455}, // TAH
    Coordinate{44.1392, 13.6858}, // TAI
    Coordinate{142.428, -3.199}, // TAJ
    Coordinate{134.016, 34.2142}, // TAK
    Coordinate{-152.109, 65.1744}, // TAL
    Coordinate{-97.8658, 22.2898}, // TAM
    Coordinate{-71.0164, 41.8742}, // TAN
    Coordinate{120.374, 36.2661}, // TAO
    Coordinate{-92.37, 14.7943}, // TAP
    Coordinate{17.4048, 40.5162}, // TAR
    Coordinate{69.2812, 41.2579}, // TAS
    Coordinate{20.2411, 49.0736}, // TAT
    Coordinate{-169.511, -14.2292}, // TAV
    Coordinate{-55.9258, -31.7503}, // TAW
    Coordinate{26.6869, 58.3075}, // TAY
    Coordinate{59.8331, 41.7647}, // TAZ
    Coordinate{80.4876, 9.30544}, // TBA
    Coordinate{109.334, 13.0494}, // TBB
    Coordinate{-111.383, 36.0928}, // TBC
    Coordinate{174.776, -1.22382}, // TBF
    Coordinate{141.226, -5.27861}, // TBG
    Coordinate{122.078, 12.3099}, // TBH
    Coordinate{-75.4522, 24.3153}, // TBI
    Coordinate{8.87694, 36.98}, // TBJ
    Coordinate{-92.1408, 37.7417}, // TBN
    Coordinate{32.8306, -5.07611}, // TBO
    Coordinate{-80.3811, -3.5525}, // TBP
    Coordinate{-81.7369, 32.4828}, // TBR
    Coordinate{44.9547, 41.6692}, // TBS
    Coordinate{-69.9378, -4.25694}, // TBT
    Coordinate{-175.149, -21.2411}, // TBU
    Coordinate{41.4828, 52.8058}, // TBW
    Coordinate{22.4014, -26.0667}, // TBY
    Coordinate{46.235, 38.1339}, // TBZ
    Coordinate{134.183, -19.6344}, // TCA
    Coordinate{-77.3996, 26.7453}, // TCB
    Coordinate{-103.603, 35.1828}, // TCC
    Coordinate{-69.7472, -2.89472}, // TCD
    Coordinate{28.7144, 45.0628}, // TCE
    Coordinate{83.3408, 46.6725}, // TCG
    Coordinate{11.017, -2.85}, // TCH
    Coordinate{-87.6114, 33.2206}, // TCL
    Coordinate{-97.4197, 18.4969}, // TCN
    Coordinate{-78.7492, 1.81456}, // TCO
    Coordinate{34.7781, 29.5878}, // TCP
    Coordinate{-70.2758, -18.0533}, // TCQ
    Coordinate{78.0258, 8.72417}, // TCR
    Coordinate{-107.272, 33.2369}, // TCS
    Coordinate{-156.028, 62.9936}, // TCT
    Coordinate{145.603, -35.8108}, // TCW
    Coordinate{56.8925, 33.6675}, // TCX
    Coordinate{-121.442, 37.6889}, // TCY
    Coordinate{98.4851, 24.9401}, // TCZ
    Coordinate{-71.6584, 5.43049}, // TDA
    Coordinate{-64.9181, -14.8186}, // TDD
    Coordinate{-78.9847, 36.2847}, // TDF
    Coordinate{126.17, 9.06683}, // TDG
    Coordinate{42.9167, 11.7833}, // TDJ
    Coordinate{-59.25, -37.2333}, // TDL
    Coordinate{-122.806, 46.4772}, // TDO
    Coordinate{142.869, -7.62278}, // TDS
    Coordinate{-101.826, 35.17}, // TDW
    Coordinate{102.319, 12.2746}, // TDX
    Coordinate{-83.4822, 41.5647}, // TDZ
    Coordinate{-87.4758, 15.7758}, // TEA
    Coordinate{-74.063, 40.849}, // TEB
    Coordinate{-50.6522, -24.3164}, // TEC
    Coordinate{8.70522, 57.0688}, // TED
    Coordinate{8.1225, 35.432}, // TEE
    Coordinate{122.229, -21.715}, // TEF
    Coordinate{-0.367, 11.8}, // TEG
    Coordinate{96.1346, 27.9417}, // TEI
    Coordinate{-146.691, 60.8725}, // TEK
    Coordinate{117.126, 5.62861}, // TEL
    Coordinate{147.512, -34.4217}, // TEM
    Coordinate{109.309, 27.8833}, // TEN
    Coordinate{-27.0908, 38.7619}, // TER
    Coordinate{36.6575, 15.1028}, // TES
    Coordinate{33.6397, -16.1083}, // TET
    Coordinate{167.65, -45.5331}, // TEU
    Coordinate{-1.21794, 40.4119}, // TEV
    Coordinate{-84.4233, 42.5658}, // TEW
    Coordinate{-107.909, 37.9539}, // TEX
    Coordinate{-23.5583, 65.8694}, // TEY
    Coordinate{92.7872, 26.699}, // TEZ
    Coordinate{-64.7253, -3.38028}, // TFF
    Coordinate{149.32, -9.076}, // TFI
    Coordinate{-41.515, -17.8922}, // TFL
    Coordinate{141.642, -5.126}, // TFM
    Coordinate{-16.3459, 28.488}, // TFN
    Coordinate{-16.5725, 28.0444}, // TFS
    Coordinate{111.202, 2.17778}, // TGC
    Coordinate{19.2519, 42.3594}, // TGD
    Coordinate{-85.7756, 32.4919}, // TGE
    Coordinate{103.103, 5.3825}, // TGG
    Coordinate{168.551, -16.8911}, // TGH
    Coordinate{-76.005, -9.29}, // TGI
    Coordinate{167.804, -21.0958}, // TGJ
    Coordinate{24.4125, 46.4677}, // TGM
    Coordinate{146.47, -38.2072}, // TGN
    Coordinate{122.2, 43.5569}, // TGO
    Coordinate{89.9733, 61.59}, // TGP
    Coordinate{-57.4486, -14.6619}, // TGQ
    Coordinate{6.08953, 33.0736}, // TGR
    Coordinate{32.9653, -24.5206}, // TGS
    Coordinate{39.0717, -5.09209}, // TGT
    Coordinate{-87.2169, 14.0617}, // TGU
    Coordinate{26.7001, 43.3068}, // TGV
    Coordinate{-93.0225, 16.5636}, // TGZ
    Coordinate{-86.2467, 35.38}, // THA
    Coordinate{28.6167, -29.5228}, // THB
    Coordinate{-8.13667, 6.06639}, // THC
    Coordinate{105.468, 19.9017}, // THD
    Coordinate{-42.8244, -5.06056}, // THE
    Coordinate{150.579, -24.4939}, // THG
    Coordinate{-9.517, 18.45}, // THI
    Coordinate{99.9348, 20.4829}, // THL
    Coordinate{-115.281, 47.5736}, // THM
    Coordinate{12.3364, 58.3242}, // THN
    Coordinate{-15.3356, 66.2183}, // THO
    Coordinate{-108.213, 43.6583}, // THP
    Coordinate{105.861, 34.5583}, // THQ
    Coordinate{51.3136, 35.6892}, // THR
    Coordinate{99.8181, 17.2378}, // THS
    Coordinate{-10.817, 17.233}, // THT
    Coordinate{-76.8731, 39.9169}, // THV
    Coordinate{87.93, 65.8}, // THX
    Coordinate{5.26917, 14.8775}, // THZ
    Coordinate{19.7206, 41.4147}, // TIA
    Coordinate{-72.7319, 8.63139}, // TIB
    Coordinate{171.917, 7.13333}, // TIC
    Coordinate{1.46297, 35.341}, // TID
    Coordinate{35.415, 7.2025}, // TIE
    Coordinate{40.5444, 21.4833}, // TIF
    Coordinate{-148.234, -15.1197}, // TIH
    Coordinate{65.8642, 32.6053}, // TII
    Coordinate{-116.97, 32.5408}, // TIJ
    Coordinate{-113.624, 51.0575}, // TIL
    Coordinate{136.887, -4.5291}, // TIM
    Coordinate{-8.16667, 27.7}, // TIN
    Coordinate{13.1567, 32.6694}, // TIP
    Coordinate{145.619, 14.9992}, // TIQ
    Coordinate{79.5418, 13.6325}, // TIR
    Coordinate{171.225, -44.3029}, // TIU
    Coordinate{18.7233, 42.4047}, // TIV
    Coordinate{-122.578, 47.2681}, // TIW
    Coordinate{-80.7992, 28.5148}, // TIX
    Coordinate{-11.4333, 18.5667}, // TIY
    Coordinate{142.947, -5.845}, // TIZ
    Coordinate{-64.7013, -21.5557}, // TJA
    Coordinate{103.393, 1.05222}, // TJB
    Coordinate{115.437, -2.21636}, // TJG
    Coordinate{134.787, 35.5128}, // TJH
    Coordinate{-85.9383, 15.9269}, // TJI
    Coordinate{36.3736, 40.3117}, // TJK
    Coordinate{-51.6839, -20.7544}, // TJL
    Coordinate{65.3167, 57.1683}, // TJM
    Coordinate{107.755, -2.74556}, // TJQ
    Coordinate{117.374, 2.83639}, // TJS
    Coordinate{69.805, 37.9883}, // TJU
    Coordinate{-150.094, 62.3206}, // TKA
    Coordinate{9.36028, 4.08917}, // TKC
    Coordinate{-1.77472, 4.89583}, // TKD
    Coordinate{-135.218, 57.7797}, // TKE
    Coordinate{-120.139, 39.32}, // TKF
    Coordinate{105.179, -5.2425}, // TKG
    Coordinate{100.3, 15.2783}, // TKH
    Coordinate{-133.327, 55.9372}, // TKI
    Coordinate{-142.954, 63.3294}, // TKJ
    Coordinate{151.843, 7.46194}, // TKK
    Coordinate{128.881, 27.8364}, // TKN
    Coordinate{28.8847, -29.2347}, // TKO
    Coordinate{29.6703, -4.885}, // TKQ
    Coordinate{88.4017, 26.0164}, // TKR
    Coordinate{134.606, 34.1328}, // TKS
    Coordinate{99.2533, 16.896}, // TKT
    Coordinate{22.2617, 60.5147}, // TKU
    Coordinate{-138.445, -17.3553}, // TKV
    Coordinate{}, // TKW
    Coordinate{-145.027, -14.4577}, // TKX
    Coordinate{175.892, -38.2367}, // TKZ
    Coordinate{-166.339, 65.2403}, // TLA
    Coordinate{72.6114, 33.985}, // TLB
    Coordinate{-99.566, 19.3369}, // TLC
    Coordinate{29.1167, -22.1833}, // TLD
    Coordinate{43.7244, -23.3911}, // TLE
    Coordinate{-153.269, 63.3939}, // TLF
    Coordinate{-84.3503, 30.3967}, // TLH
    Coordinate{120.794, 1.12343}, // TLI
    Coordinate{-155.976, 62.8944}, // TLJ
    Coordinate{111.044, 59.8764}, // TLK
    Coordinate{24.7992, 59.4164}, // TLL
    Coordinate{-1.45753, 35.0134}, // TLM
    Coordinate{6.14611, 43.0972}, // TLN
    Coordinate{89.1006, 43.0306}, // TLQ
    Coordinate{-119.327, 36.1567}, // TLR
    Coordinate{1.36778, 43.635}, // TLS
    Coordinate{-160.969, 61.0969}, // TLT
    Coordinate{-75.5864, 9.5}, // TLU
    Coordinate{34.8828, 32.0094}, // TLV
    Coordinate{-71.6015, -35.3783}, // TLX
    Coordinate{-47.9014, -18.2169}, // TLZ
    Coordinate{-83.4886, 31.4289}, // TMA
    Coordinate{-80.4328, 25.6478}, // TMB
    Coordinate{119.244, -9.40972}, // TMC
    Coordinate{-8.167, 16.233}, // TMD
    Coordinate{-71.7597, 6.45111}, // TME
    Coordinate{73.2097, 2.20972}, // TMF
    Coordinate{118.646, 5.39972}, // TMG
    Coordinate{87.1933, 27.315}, // TMI
    Coordinate{67.31, 37.2867}, // TMJ
    Coordinate{-123.814, 45.4182}, // TMK
    Coordinate{-0.863056, 9.55694}, // TML
    Coordinate{49.3925, -18.1158}, // TMM
    Coordinate{175.97, -2.48624}, // TMN
    Coordinate{-61.4332, 7.25004}, // TMO
    Coordinate{23.5878, 61.4153}, // TMP
    Coordinate{0.0411111, 14.7908}, // TMQ
    Coordinate{5.45083, 22.8111}, // TMR
    Coordinate{6.71222, 0.378056}, // TMS
    Coordinate{-56.3992, -1.48444}, // TMT
    Coordinate{-85.0167, 9.73333}, // TMU
    Coordinate{150.849, -31.0839}, // TMW
    Coordinate{0.276111, 29.2367}, // TMX
    Coordinate{175.549, -37.16}, // TMZ
    Coordinate{117.216, 36.8572}, // TNA
    Coordinate{-167.922, 65.5631}, // TNC
    Coordinate{-79.9972, 21.7883}, // TND
    Coordinate{130.992, 30.605}, // TNE
    Coordinate{2.10611, 48.7514}, // TNF
    Coordinate{-5.91689, 35.7269}, // TNG
    Coordinate{125.704, 42.2539}, // TNH
    Coordinate{80.8544, 24.5572}, // TNI
    Coordinate{104.532, 0.9225}, // TNJ
    Coordinate{-165.272, 60.5756}, // TNK
    Coordinate{25.7, 49.525}, // TNL
    Coordinate{120.204, 22.9503}, // TNN
    Coordinate{-85.8132, 10.3156}, // TNO
    Coordinate{-115.946, 34.1317}, // TNP
    Coordinate{47.4789, -18.7969}, // TNR
    Coordinate{-128.203, 61.9569}, // TNS
    Coordinate{-80.8969, 25.8617}, // TNT
    Coordinate{-93.0217, 41.6744}, // TNU
    Coordinate{-77.5735, -1.06281}, // TNW
    Coordinate{106.014, 13.5317}, // TNX
    Coordinate{-118.34, 33.8033}, // TOA
    Coordinate{23.8375, 32.0961}, // TOB
    Coordinate{-83.2964, 34.5928}, // TOC
    Coordinate{104.16, 2.81889}, // TOD
    Coordinate{8.11056, 33.9397}, // TOE
    Coordinate{85.2117, 56.3833}, // TOF
    Coordinate{-160.397, 59.0536}, // TOG
    Coordinate{166.638, -13.3275}, // TOH
    Coordinate{-86.0122, 31.8606}, // TOI
    Coordinate{-83.8078, 41.5868}, // TOL
    Coordinate{-3.0075, 16.7306}, // TOM
    Coordinate{-82.9589, 8.82611}, // TOO
    Coordinate{-95.6225, 39.0686}, // TOP
    Coordinate{-70.0658, -22.1425}, // TOQ
    Coordinate{-104.153, 42.0644}, // TOR
    Coordinate{18.9178, 69.6814}, // TOS
    Coordinate{-56.3275, 5.86583}, // TOT
    Coordinate{165.259, -20.7903}, // TOU
    Coordinate{-53.6967, -24.6853}, // TOW
    Coordinate{137.188, 36.6483}, // TOY
    Coordinate{-7.67361, 8.28972}, // TOZ
    Coordinate{-82.5333, 27.9756}, // TPA
    Coordinate{-76.3375, -0.122778}, // TPC
    Coordinate{121.224, 25.0764}, // TPE
    Coordinate{-82.4492, 27.9156}, // TPF
    Coordinate{100.715, 4.86639}, // TPG
    Coordinate{-117.087, 38.0603}, // TPH
    Coordinate{146.989, -8.35667}, // TPI
    Coordinate{87.6972, 27.3515}, // TPJ
    Coordinate{-97.4078, 31.1519}, // TPL
    Coordinate{-75.5264, -0.776111}, // TPN
    Coordinate{-76.3732, -6.50874}, // TPP
    Coordinate{-104.843, 21.4194}, // TPQ
    Coordinate{117.869, -22.7461}, // TPR
    Coordinate{12.4933, 37.9119}, // TPS
    Coordinate{81.15, 28.5169}, // TPU
    Coordinate{-95.0044, 35.9303}, // TQH
    Coordinate{-62.7724, -35.9711}, // TQL
    Coordinate{69.5324, 36.7707}, // TQN
    Coordinate{140.888, -21.835}, // TQP
    Coordinate{124.675, 24.6539}, // TRA
    Coordinate{-76.7483, 8.06667}, // TRB
    Coordinate{-103.411, 25.5681}, // TRC
    Coordinate{10.9242, 63.4575}, // TRD
    Coordinate{-6.87139, 56.5008}, // TRE
    Coordinate{10.2586, 59.1867}, // TRF
    Coordinate{176.196, -37.6719}, // TRG
    Coordinate{-117.327, 35.8125}, // TRH
    Coordinate{-82.4075, 36.4753}, // TRI
    Coordinate{117.566, 3.32667}, // TRK
    Coordinate{-96.2674, 32.7092}, // TRL
    Coordinate{-116.16, 33.6267}, // TRM
    Coordinate{7.64959, 45.2018}, // TRN
    Coordinate{152.514, -31.8886}, // TRO
    Coordinate{-70.7828, -8.1575}, // TRQ
    Coordinate{13.4722, 45.8275}, // TRS
    Coordinate{-79.1086, -8.08139}, // TRU
    Coordinate{76.92, 8.48222}, // TRV
    Coordinate{173.147, 1.38167}, // TRW
    Coordinate{-93.5906, 40.0836}, // TRX
    Coordinate{34.1667, 0.68}, // TRY
    Coordinate{78.7147, 10.7658}, // TRZ
    Coordinate{17.7256, -19.2619}, // TSB
    Coordinate{-77.5028, -2.38167}, // TSC
    Coordinate{71.4669, 51.0222}, // TSE
    Coordinate{12.1978, 45.6508}, // TSF
    Coordinate{-143.336, 63.3744}, // TSG
    Coordinate{20.7947, -6.43833}, // TSH
    Coordinate{129.331, 34.285}, // TSJ
    Coordinate{-98.8067, 22.0378}, // TSL
    Coordinate{-105.673, 36.4581}, // TSM
    Coordinate{117.346, 39.1244}, // TSN
    Coordinate{-6.33139, 49.9456}, // TSO
    Coordinate{-118.439, 35.135}, // TSP
    Coordinate{-49.8103, -29.41}, // TSQ
    Coordinate{21.3379, 45.8098}, // TSR
    Coordinate{-73.9719, 40.7425}, // TSS
    Coordinate{99.6158, 7.50861}, // TST
    Coordinate{175.065, -1.47439}, // TSU
    Coordinate{146.765, -19.2533}, // TSV
    Coordinate{108.246, -7.3466}, // TSY
    Coordinate{-11.1614, 28.4439}, // TTA
    Coordinate{9.68321, 39.9167}, // TTB
    Coordinate{-70.3767, -25.5639}, // TTC
    Coordinate{-122.401, 45.5494}, // TTD
    Coordinate{127.381, 0.831411}, // TTE
    Coordinate{-63.8183, -22.6283}, // TTG
    Coordinate{134.163, 35.53}, // TTJ
    Coordinate{-72.1006, 5.72639}, // TTM
    Coordinate{-74.8133, 40.2767}, // TTN
    Coordinate{-97.7428, 45.815}, // TTO
    Coordinate{-83.5147, 10.5689}, // TTQ
    Coordinate{119.821, -3.04256}, // TTR
    Coordinate{47.6167, -16.75}, // TTS
    Coordinate{121.093, 22.7547}, // TTT
    Coordinate{-5.31997, 35.5944}, // TTU
    Coordinate{-77.7081, 0.809444}, // TUA
    Coordinate{-149.529, -23.371}, // TUB
    Coordinate{-65.1047, -26.8408}, // TUC
    Coordinate{-13.6581, 13.7328}, // TUD
    Coordinate{0.723056, 47.4319}, // TUF
    Coordinate{121.731, 17.6383}, // TUG
    Coordinate{38.7311, 31.6928}, // TUI
    Coordinate{35.5194, 6.25972}, // TUJ
    Coordinate{63.0302, 25.9864}, // TUK
    Coordinate{-95.8881, 36.1983}, // TUL
    Coordinate{148.241, -35.2628}, // TUM
    Coordinate{10.2272, 36.8511}, // TUN
    Coordinate{176.084, -38.7397}, // TUO
    Coordinate{-88.77, 34.2681}, // TUP
    Coordinate{-3.067, 13.0667}, // TUQ
    Coordinate{-49.7197, -3.79361}, // TUR
    Coordinate{-110.941, 32.1161}, // TUS
    Coordinate{36.6189, 28.3656}, // TUU
    Coordinate{-62.0942, 9.08889}, // TUV
    Coordinate{-120.931, 55.0272}, // TUX
    Coordinate{44.9167, -17.8501}, // TVA
    Coordinate{-85.5822, 44.7417}, // TVC
    Coordinate{-96.185, 48.0656}, // TVF
    Coordinate{-83.8811, 30.9017}, // TVI
    Coordinate{-92.9011, 40.6844}, // TVK
    Coordinate{-119.995, 38.8939}, // TVL
    Coordinate{117.993, 39.7253}, // TVS
    Coordinate{-179.877, -16.6906}, // TVU
    Coordinate{98.2036, 14.1}, // TVY
    Coordinate{-160.275, 59.0744}, // TWA
    Coordinate{151.912, -27.5417}, // TWB
    Coordinate{-122.811, 48.0539}, // TWD
    Coordinate{-114.488, 42.4818}, // TWF
    Coordinate{118.122, 4.31333}, // TWU
    Coordinate{170.118, -44.2369}, // TWZ
    Coordinate{96.8494, 4.72083}, // TXE
    Coordinate{-39.6697, -17.5244}, // TXF
    Coordinate{120.654, 24.1863}, // TXG
    Coordinate{-93.9911, 33.4536}, // TXK
    Coordinate{13.2878, 52.5597}, // TXL
    Coordinate{118.253, 29.73}, // TXN
    Coordinate{-7.36273, 4.43781}, // TXU
    Coordinate{37.6067, 54.2367}, // TYA
    Coordinate{142.058, -29.4517}, // TYB
    Coordinate{124.778, 55.2833}, // TYD
    Coordinate{-151.138, 61.0767}, // TYE
    Coordinate{12.9936, 60.1547}, // TYF
    Coordinate{-81.2539, -4.57639}, // TYL
    Coordinate{-76.4403, 24.1625}, // TYM
    Coordinate{112.628, 37.7469}, // TYN
    Coordinate{-86.2514, 40.0306}, // TYQ
    Coordinate{-95.4028, 32.3539}, // TYR
    Coordinate{-83.9939, 35.8111}, // TYS
    Coordinate{-54.3472, -33.195}, // TYT
    Coordinate{-110.115, 34.4528}, // TYZ
    Coordinate{-88.1917, 17.5164}, // TZA
    Coordinate{-83.4453, 43.4586}, // TZC
    Coordinate{18.7247, 44.4586}, // TZL
    Coordinate{-83.1369, 39.9011}, // TZR
    Coordinate{39.7853, 40.9951}, // TZX
    Coordinate{-114.798, 32.4453}, // UAC
    Coordinate{125.287, -9.30397}, // UAI
    Coordinate{-45.4257, 61.1606}, // UAK
    Coordinate{22.2311, -10.7158}, // UAL
    Coordinate{-122.77, 45.2472}, // UAO
    Coordinate{-68.4211, -31.5711}, // UAQ
    Coordinate{-1.97833, 32.5144}, // UAR
    Coordinate{37.5342, 0.53056}, // UAS
    Coordinate{-89.6347, 17.3931}, // UAX
    Coordinate{-47.9661, -19.7647}, // UBA
    Coordinate{142.197, -9.95167}, // UBB
    Coordinate{12.5019, 41.9531}, // UBE
    Coordinate{155.685, -6.73333}, // UBI
    Coordinate{131.279, 33.93}, // UBJ
    Coordinate{104.87, 15.2513}, // UBP
    Coordinate{-88.3803, 33.4653}, // UBS
    Coordinate{-45.0761, -23.4414}, // UBT
    Coordinate{-75.3839, 43.145}, // UCA
    Coordinate{113.109, 41.1239}, // UCB
    Coordinate{-116.038, 36.9458}, // UCC
    Coordinate{25.4833, 50.6833}, // UCK
    Coordinate{-10.0575, 5.16765}, // UCN
    Coordinate{-80.4133, 41.0253}, // UCP
    Coordinate{53.8033, 63.5667}, // UCT
    Coordinate{-88.9858, 36.3797}, // UCY
    Coordinate{-76.35, -8.46667}, // UCZ
    Coordinate{-116.275, 33.7483}, // UDD
    Coordinate{-79.89, 34.4494}, // UDG
    Coordinate{-48.2253, -18.8836}, // UDI
    Coordinate{22.2633, 48.6342}, // UDJ
    Coordinate{121.415, 1.10472}, // UDL
    Coordinate{13.1867, 46.0314}, // UDN
    Coordinate{73.8944, 24.6176}, // UDR
    Coordinate{145.53, -42.0756}, // UEE
    Coordinate{36.8667, -17.8764}, // UEL
    Coordinate{126.714, 26.3636}, // UEO
    Coordinate{-88.2369, 43.0411}, // UES
    Coordinate{66.9387, 30.2521}, // UET
    Coordinate{55.8742, 54.5575}, // UFA
    Coordinate{103.484, 48.8542}, // UGA
    Coordinate{-157.74, 57.4253}, // UGB
    Coordinate{60.6417, 41.5842}, // UGC
    Coordinate{-87.8678, 42.4222}, // UGN
    Coordinate{15.0277, -7.60278}, // UGO
    Coordinate{-157.396, 57.5233}, // UGS
    Coordinate{17.4397, 49.0294}, // UHE
    Coordinate{-76.6411, 5.69083}, // UIB
    Coordinate{109.042, 13.955}, // UIH
    Coordinate{-86.0542, 16.0917}, // UII
    Coordinate{102.557, 58.1333}, // UIK
    Coordinate{-124.563, 47.9367}, // UIL
    Coordinate{-91.1947, 39.9428}, // UIN
    Coordinate{-78.3656, -0.135556}, // UIO
    Coordinate{-4.16778, 47.975}, // UIP
    Coordinate{150.514, -31.4986}, // UIR
    Coordinate{169.637, 5.90917}, // UIT
    Coordinate{165.762, 8.92806}, // UJE
    Coordinate{124.499, 40.1517}, // UJU
    Coordinate{39.5714, -4.29694}, // UKA
    Coordinate{135.224, 34.6328}, // UKB
    Coordinate{135.647, 70.0111}, // UKG
    Coordinate{-123.201, 39.1258}, // UKI
    Coordinate{82.4942, 50.0361}, // UKK
    Coordinate{-95.725, 38.3025}, // UKL
    Coordinate{45.6556, 13.9333}, // UKR
    Coordinate{33.5833, 44.6833}, // UKS
    Coordinate{-75.3803, 40.4364}, // UKT
    Coordinate{105.73, 56.8567}, // UKX
    Coordinate{-67.8028, -49.3094}, // ULA
    Coordinate{168.283, -16.333}, // ULB
    Coordinate{-70.6978, -33.4936}, // ULC
    Coordinate{31.4161, -28.3206}, // ULD
    Coordinate{89.9197, 48.9917}, // ULG
    Coordinate{38.1169, 26.4833}, // ULH
    Coordinate{114.826, 60.7206}, // ULK
    Coordinate{-94.5022, 44.3194}, // ULM
    Coordinate{106.766, 47.8431}, // ULN
    Coordinate{92.0797, 49.9733}, // ULO
    Coordinate{144.257, -26.6086}, // ULP
    Coordinate{-76.2261, 4.0945}, // ULQ
    Coordinate{32.275, 2.8}, // ULU
    Coordinate{48.2267, 54.2683}, // ULV
    Coordinate{48.8028, 54.4011}, // ULY
    Coordinate{96.5242, 47.7128}, // ULZ
    Coordinate{-74.15, 20.25}, // UMA
    Coordinate{20.28, 63.7931}, // UME
    Coordinate{-149.127, 63.3314}, // UMM
    Coordinate{-86.045, 39.9353}, // UMP
    Coordinate{134.449, 60.3639}, // UMS
    Coordinate{-152.135, 69.3711}, // UMT
    Coordinate{-53.3139, -23.7992}, // UMU
    Coordinate{34.7625, 50.8583}, // UMY
    Coordinate{-38.9972, -15.3533}, // UNA
    Coordinate{68.9106, 36.6651}, // UND
    Coordinate{28.6719, -30.1111}, // UNE
    Coordinate{141.282, -6.12567}, // UNG
    Coordinate{-61.4147, 12.5986}, // UNI
    Coordinate{-160.799, 63.8883}, // UNK
    Coordinate{98.5853, 9.7775}, // UNN
    Coordinate{-91.9028, 36.8783}, // UNO
    Coordinate{-88.7039, 43.4264}, // UNU
    Coordinate{-85.8981, 35.2053}, // UOS
    Coordinate{-89.5367, 34.3844}, // UOX
    Coordinate{-82.5794, 23.0328}, // UPB
    Coordinate{119.554, -5.06167}, // UPG
    Coordinate{-85.0167, 10.9}, // UPL
    Coordinate{-102.039, 19.3965}, // UPN
    Coordinate{-155.86, 20.2653}, // UPP
    Coordinate{51.5431, 51.1508}, // URA
    Coordinate{-51.5619, -20.7758}, // URB
    Coordinate{87.4742, 43.9072}, // URC
    Coordinate{22.5094, 58.2297}, // URE
    Coordinate{-57.0383, -29.7833}, // URG
    Coordinate{64.8333, 60.1167}, // URJ
    Coordinate{1.18389, 49.3908}, // URO
    Coordinate{-76.1406, 6.32771}, // URR
    Coordinate{36.2967, 51.7517}, // URS
    Coordinate{99.1392, 9.13611}, // URT
    Coordinate{37.2794, 31.4119}, // URY
    Coordinate{-68.2958, -54.8433}, // USH
    Coordinate{-59.7764, 8.20139}, // USI
    Coordinate{57.3667, 66}, // USK
    Coordinate{100.062, 9.54778}, // USM
    Coordinate{129.352, 35.5933}, // USN
    Coordinate{29.4699, 38.6796}, // USQ
    Coordinate{143.111, 64.5486}, // USR
    Coordinate{-79.4428, 21.97}, // USS
    Coordinate{-81.3397, 29.9592}, // UST
    Coordinate{120.1, 12.1214}, // USU
    Coordinate{32.625, -18.9975}, // UTA
    Coordinate{144.529, -22.5831}, // UTB
    Coordinate{27.6933, -30.4075}, // UTG
    Coordinate{102.788, 17.3864}, // UTH
    Coordinate{169.853, 11.2225}, // UTK
    Coordinate{-90.3478, 34.685}, // UTM
    Coordinate{21.2597, -28.4011}, // UTN
    Coordinate{-153.704, 65.9928}, // UTO
    Coordinate{101.005, 12.6796}, // UTP
    Coordinate{52.1989, 65.4333}, // UTS
    Coordinate{28.6736, -31.5464}, // UTT
    Coordinate{52.8017, 54.64}, // UUA
    Coordinate{107.438, 51.8075}, // UUD
    Coordinate{-149.598, 70.3308}, // UUK
    Coordinate{113.285, 46.6603}, // UUN
    Coordinate{142.722, 46.8869}, // UUS
    Coordinate{-99.7436, 29.2114}, // UVA
    Coordinate{166.573, -20.6417}, // UVE
    Coordinate{-60.9525, 13.7333}, // UVF
    Coordinate{30.59, 25.4716}, // UVL
    Coordinate{-72.2148, 42.282}, // UWA
    Coordinate{-93.3761, 30.1314}, // UXL
    Coordinate{-83.4619, 39.9328}, // UYF
    Coordinate{24.9561, 12.0535}, // UYL
    Coordinate{109.73, 38.2742}, // UYN
    Coordinate{-66.8422, -20.45}, // UYU
    Coordinate{19.6974, 43.8988}, // UZC
    Coordinate{-106.614, 68.1639}, // UZM
    Coordinate{-57.9789, -29.7718}, // UZU
    Coordinate{21.7642, 63.0453}, // VAA
    Coordinate{4.96861, 44.9156}, // VAF
    Coordinate{-45.4733, -21.5889}, // VAG
    Coordinate{-64.0996, -18.4793}, // VAH
    Coordinate{141.302, -2.69717}, // VAI
    Coordinate{-165.601, 61.5408}, // VAK
    Coordinate{-38.9925, -13.2964}, // VAL
    Coordinate{72.8358, 3.47056}, // VAM
    Coordinate{43.3308, 38.4683}, // VAN
    Coordinate{158.731, -7.58583}, // VAO
    Coordinate{-71.3542, -33.3568}, // VAP
    Coordinate{27.8253, 43.2319}, // VAR
    Coordinate{36.9025, 39.7667}, // VAS
    Coordinate{}, // VAT
    Coordinate{-173.97, -18.5856}, // VAV
    Coordinate{31.045, 70.3553}, // VAW
    Coordinate{96.0896, 21.9405}, // VBC
    Coordinate{10.3314, 45.4286}, // VBS
    Coordinate{-94.2194, 36.3458}, // VBT
    Coordinate{-178.983, -17.2667}, // VBV
    Coordinate{18.3461, 57.6628}, // VBY
    Coordinate{105.712, 10.0853}, // VCA
    Coordinate{-121.962, 38.3778}, // VCB
    Coordinate{9.2, 4.01667}, // VCC
    Coordinate{131.003, -16.4033}, // VCD
    Coordinate{12.3519, 45.5053}, // VCE
    Coordinate{-66.1495, -40.6997}, // VCF
    Coordinate{-54.6169, -31.7669}, // VCH
    Coordinate{108.706, 15.4061}, // VCL
    Coordinate{-47.1344, -23.0069}, // VCP
    Coordinate{-70.0654, 10.1756}, // VCR
    Coordinate{106.629, 8.7325}, // VCS
    Coordinate{-96.9186, 28.8525}, // VCT
    Coordinate{-117.383, 34.5975}, // VCV
    Coordinate{34.9358, 29.9403}, // VDA
    Coordinate{9.28801, 61.0151}, // VDB
    Coordinate{-40.8631, -14.8636}, // VDC
    Coordinate{-17.8869, 27.8147}, // VDE
    Coordinate{-82.3453, 28.0139}, // VDF
    Coordinate{106.591, 17.515}, // VDH
    Coordinate{-82.3711, 32.1928}, // VDI
    Coordinate{-65.2838, -43.2098}, // VDM
    Coordinate{-65.9933, 9.22194}, // VDP
    Coordinate{-65.1472, -31.9533}, // VDR
    Coordinate{29.8447, 70.0653}, // VDS
    Coordinate{76.6341, 15.175}, // VDY
    Coordinate{-146.248, 61.1339}, // VDZ
    Coordinate{-146.366, 67.0086}, // VEE
    Coordinate{-109.51, 40.4408}, // VEL
    Coordinate{-96.1874, 19.1458}, // VER
    Coordinate{-84.5319, 40.2044}, // VES
    Coordinate{-20.2792, 63.425}, // VEY
    Coordinate{25.839, -18.0959}, // VFA
    Coordinate{80.6667, 16.5275}, // VGA
    Coordinate{-75.5611, 42.8433}, // VGC
    Coordinate{39.9467, 59.2817}, // VGD
    Coordinate{120.356, 17.5547}, // VGN
    Coordinate{-8.6275, 42.2292}, // VGO
    Coordinate{-115.194, 36.2106}, // VGT
    Coordinate{-76.6056, 0.978889}, // VGZ
    Coordinate{20.4316, -9.7}, // VHC
    Coordinate{16.8333, 64.5789}, // VHM
    Coordinate{-104.784, 31.0578}, // VHN
    Coordinate{120.276, 63.4592}, // VHV
    Coordinate{3.40333, 46.1692}, // VHY
    Coordinate{-138.853, -18.78}, // VHZ
    Coordinate{-51.1575, -27}, // VIA
    Coordinate{-111.688, 25.0553}, // VIB
    Coordinate{22.8158, 44.0222}, // VID
    Coordinate{16.5697, 48.1103}, // VIE
    Coordinate{-71.6728, 8.62417}, // VIG
    Coordinate{-91.7694, 38.1275}, // VIH
    Coordinate{105.671, 18.7367}, // VII
    Coordinate{-64.4286, 18.4456}, // VIJ
    Coordinate{-15.9319, 23.7181}, // VIL
    Coordinate{28.6139, 49.2397}, // VIN
    Coordinate{31.0583, -29.7708}, // VIR
    Coordinate{-119.393, 36.3186}, // VIS
    Coordinate{-2.72444, 42.8828}, // VIT
    Coordinate{150.32, -9.30639}, // VIV
    Coordinate{-40.2864, -20.2581}, // VIX
    Coordinate{-82.0333, 36.6871}, // VJI
    Coordinate{105.134, 9.95972}, // VKG
    Coordinate{37.2675, 55.5961}, // VKO
    Coordinate{63.99, 67.4883}, // VKT
    Coordinate{-76.9558, 38.7486}, // VKX
    Coordinate{-0.481667, 39.4894}, // VLC
    Coordinate{-83.2761, 30.7814}, // VLD
    Coordinate{-112.142, 35.6495}, // VLE
    Coordinate{-57.0292, -37.2353}, // VLG
    Coordinate{168.32, -17.6992}, // VLI
    Coordinate{-4.85194, 41.7061}, // VLL
    Coordinate{-63.4056, -21.255}, // VLM
    Coordinate{-67.9283, 10.1497}, // VLN
    Coordinate{-51.1422, -9.97945}, // VLP
    Coordinate{-70.7575, -28.5965}, // VLR
    Coordinate{168.177, -16.7961}, // VLS
    Coordinate{30.61, 56.3817}, // VLU
    Coordinate{-70.5842, 9.34083}, // VLV
    Coordinate{-4.53528, 53.2481}, // VLY
    Coordinate{-65.3781, -33.7253}, // VME
    Coordinate{-57.9431, -22.1583}, // VMI
    Coordinate{-63.2581, -32.3883}, // VMR
    Coordinate{144.823, -7.49483}, // VMU
    Coordinate{-82.4403, 27.0717}, // VNC
    Coordinate{}, // VND
    Coordinate{-2.72333, 47.7192}, // VNE
    Coordinate{25.2878, 54.6369}, // VNO
    Coordinate{82.8586, 25.4514}, // VNS
    Coordinate{21.5442, 57.3578}, // VNT
    Coordinate{35.3133, -22.0184}, // VNX
    Coordinate{-118.49, 34.2097}, // VNY
    Coordinate{14.3956, 50.2167}, // VOD
    Coordinate{44.3467, 48.7817}, // VOG
    Coordinate{50, -13.3833}, // VOH
    Coordinate{-9.767, 8.4}, // VOI
    Coordinate{22.7942, 39.2194}, // VOL
    Coordinate{-50.0025, -20.4572}, // VOT
    Coordinate{39.23, 51.815}, // VOZ
    Coordinate{-71.5574, -33.0683}, // VPA
    Coordinate{-84.8486, 34.1231}, // VPC
    Coordinate{15.6839, -17.0434}, // VPE
    Coordinate{-14.8506, 65.7206}, // VPN
    Coordinate{-86.5253, 30.4833}, // VPS
    Coordinate{33.4286, -19.1486}, // VPY
    Coordinate{-87.0072, 41.4539}, // VPZ
    Coordinate{-81.8767, 30.2186}, // VQQ
    Coordinate{-65.4936, 18.1347}, // VQS
    Coordinate{-81.4353, 23.0344}, // VRA
    Coordinate{-80.4179, 27.6556}, // VRB
    Coordinate{124.206, 13.5758}, // VRC
    Coordinate{18.5396, -31.6431}, // VRE
    Coordinate{58.1986, 68.8478}, // VRI
    Coordinate{-7.72, 41.2758}, // VRL
    Coordinate{10.8881, 45.3964}, // VRN
    Coordinate{-81.3036, 23.1228}, // VRO
    Coordinate{24.7283, -26.9808}, // VRU
    Coordinate{12.6817, 67.6883}, // VRY
    Coordinate{-92.8172, 17.995}, // VSA
    Coordinate{-7.88917, 40.7222}, // VSE
    Coordinate{-72.5172, 43.3436}, // VSF
    Coordinate{39.374, 48.418}, // VSG
    Coordinate{-119.21, 46.2186}, // VSK
    Coordinate{30.3517, 55.1264}, // VTB
    Coordinate{102.563, 17.9883}, // VTE
    Coordinate{107.093, 10.3703}, // VTG
    Coordinate{-100.549, 42.8567}, // VTN
    Coordinate{12.0622, 42.4302}, // VTR
    Coordinate{-76.9358, 20.9878}, // VTU
    Coordinate{83.2244, 17.7211}, // VTZ
    Coordinate{131.782, -22.2542}, // VUE
    Coordinate{-80.1508, 35.4167}, // VUJ
    Coordinate{-122.656, 45.6206}, // VUO
    Coordinate{-73.2494, 10.435}, // VUP
    Coordinate{46.26, 60.7883}, // VUS
    Coordinate{-73.6136, 4.16778}, // VVC
    Coordinate{-63.1353, -17.6447}, // VVI
    Coordinate{132.151, 43.3992}, // VVO
    Coordinate{8.62247, 26.7236}, // VVZ
    Coordinate{35.2644, -13.2742}, // VXC
    Coordinate{-25.0547, 16.8336}, // VXE
    Coordinate{14.7278, 56.9289}, // VXO
    Coordinate{121.693, 63.7567}, // VYI
    Coordinate{-89.1531, 41.3519}, // VYS
    Coordinate{-168.095, 65.6225}, // WAA
    Coordinate{45.1994, 20.5042}, // WAE
    Coordinate{175.025, -39.9622}, // WAG
    Coordinate{-96.6072, 46.2442}, // WAH
    Coordinate{46.953, -15.7741}, // WAI
    Coordinate{44.51, -22.3}, // WAK
    Coordinate{48.4333, -17.8}, // WAM
    Coordinate{-71.8069, -43.6153}, // WAP
    Coordinate{44.6167, -18.7}, // WAQ
    Coordinate{-7.08696, 52.1872}, // WAT
    Coordinate{20.9672, 52.1658}, // WAW
    Coordinate{12.0167, 32.9528}, // WAX
    Coordinate{-80.1306, 39.9011}, // WAY
    Coordinate{151.943, -28.1494}, // WAZ
    Coordinate{-162.278, 63.5158}, // WBB
    Coordinate{143.895, -5.6433}, // WBM
    Coordinate{}, // WBO
    Coordinate{-147.407, 66.3622}, // WBQ
    Coordinate{-85.5042, 43.7225}, // WBR
    Coordinate{-105.226, 40.0394}, // WBU
    Coordinate{-75.8522, 41.2972}, // WBW
    Coordinate{-73.775, -42.4903}, // WCA
    Coordinate{-72.6995, -42.9328}, // WCH
    Coordinate{-148.483, 67.5044}, // WCR
    Coordinate{-97.7889, 36.3783}, // WDG
    Coordinate{17.4708, -22.48}, // WDH
    Coordinate{-83.6681, 33.9822}, // WDR
    Coordinate{110.908, 32.5917}, // WDS
    Coordinate{119.118, 36.6467}, // WEF
    Coordinate{122.229, 37.1869}, // WEH
    Coordinate{141.925, -12.6786}, // WEI
    Coordinate{26.6667, -28}, // WEL
    Coordinate{-131.663, 55.3444}, // WFB
    Coordinate{47.1, -21.45}, // WFI
    Coordinate{-68.3128, 47.2856}, // WFK
    Coordinate{79.6, 17.9155}, // WGC
    Coordinate{148.125, -30.0333}, // WGE
    Coordinate{110.642, 26.802}, // WGN
    Coordinate{-78.1444, 39.1439}, // WGO
    Coordinate{120.301, -9.6681}, // WGP
    Coordinate{146.307, -36.4158}, // WGT
    Coordinate{-130.007, 55.9033}, // WHD
    Coordinate{31.5164, 21.8003}, // WHF
    Coordinate{176.914, -37.9206}, // WHK
    Coordinate{-118.413, 34.2593}, // WHP
    Coordinate{-0.927356, 60.3766}, // WHS
    Coordinate{-96.1542, 29.2542}, // WHT
    Coordinate{-99.2839, 34.2256}, // WIB
    Coordinate{-3.09306, 58.4589}, // WIC
    Coordinate{175.085, -36.8083}, // WIK
    Coordinate{36.8148, -1.32172}, // WIL
    Coordinate{143.085, -22.3633}, // WIN
    Coordinate{143.375, -31.5267}, // WIO
    Coordinate{177.404, -39.0122}, // WIR
    Coordinate{168.55, 7.45083}, // WJA
    Coordinate{-118.219, 34.7411}, // WJF
    Coordinate{40.09, 1.73}, // WJR
    Coordinate{127.96, 37.4381}, // WJU
    Coordinate{169.246, -44.7225}, // WKA
    Coordinate{142.419, -36.3211}, // WKB
    Coordinate{26.5142, -18.3632}, // WKI
    Coordinate{141.802, 45.4044}, // WKJ
    Coordinate{-158.618, 59.2825}, // WKK
    Coordinate{155.221, -5.86139}, // WKN
    Coordinate{-78.4022, 27.2604}, // WKR
    Coordinate{-97.0375, 37.1686}, // WLD
    Coordinate{150.165, -26.8092}, // WLE
    Coordinate{174.805, -41.3272}, // WLG
    Coordinate{167.691, -15.412}, // WLH
    Coordinate{-159.986, 66.6}, // WLK
    Coordinate{-176.199, -13.2383}, // WLS
    Coordinate{-122.217, 39.5158}, // WLW
    Coordinate{48.833, -15.8333}, // WMA
    Coordinate{142.447, -38.2953}, // WMB
    Coordinate{-117.806, 40.8967}, // WMC
    Coordinate{}, // WMD
    Coordinate{120.555, -27.2864}, // WME
    Coordinate{-92.4706, 36.3689}, // WMH
    Coordinate{20.6517, 52.4511}, // WMI
    Coordinate{172.395, -43.4767}, // WML
    Coordinate{49.6833, -15.4367}, // WMN
    Coordinate{-163.413, 64.6892}, // WMO
    Coordinate{47.6167, -16.05}, // WMP
    Coordinate{49.7667, -16.1667}, // WMR
    Coordinate{138.952, -4.09833}, // WMX
    Coordinate{-161.979, 60.6903}, // WNA
    Coordinate{-133.228, 55.8497}, // WNC
    Coordinate{104.243, 23.3758}, // WNH
    Coordinate{-89.2892, 52.8939}, // WNN
    Coordinate{123.27, 13.5847}, // WNP
    Coordinate{142.667, -25.4133}, // WNR
    Coordinate{68.39, 26.2194}, // WNS
    Coordinate{120.852, 27.9119}, // WNZ
    Coordinate{150.789, -34.5611}, // WOL
    Coordinate{}, // WON
    Coordinate{127.484, 39.1626}, // WOS
    Coordinate{119.494, 23.3667}, // WOT
    Coordinate{-150.052, 61.7542}, // WOW
    Coordinate{-72.6703, -45.3992}, // WPA
    Coordinate{47.6167, -15.5833}, // WPB
    Coordinate{-113.997, 49.5206}, // WPC
    Coordinate{-124.533, 49.8833}, // WPL
    Coordinate{-70.3327, -53.2537}, // WPR
    Coordinate{-67.6263, -54.9311}, // WPU
    Coordinate{174.365, -35.7683}, // WRE
    Coordinate{-132.37, 56.4844}, // WRG
    Coordinate{-107.951, 43.9628}, // WRL
    Coordinate{119.39, -30.0317}, // WRN
    Coordinate{16.8858, 51.1028}, // WRO
    Coordinate{132.191, -0.419444}, // WRR
    Coordinate{-2.88389, 53.745}, // WRT
    Coordinate{-2.95056, 59.3503}, // WRY
    Coordinate{-76.9917, 0.0708333}, // WSE
    Coordinate{-164.914, 54.5825}, // WSF
    Coordinate{-80.2903, 40.1364}, // WSG
    Coordinate{-72.8669, 40.8219}, // WSH
    Coordinate{-153.321, 57.7303}, // WSJ
    Coordinate{114.618, -8.14172}, // WSN
    Coordinate{-57.1738, 5.25015}, // WSO
    Coordinate{-83.9758, 14.736}, // WSP
    Coordinate{-71.8033, 41.3497}, // WST
    Coordinate{-122.953, 48.6178}, // WSX
    Coordinate{171.581, -41.7381}, // WSZ
    Coordinate{43.9667, -17.4833}, // WTA
    Coordinate{151.795, -27.5586}, // WTB
    Coordinate{-78.975, 26.6833}, // WTD
    Coordinate{170.239, 9.45833}, // WTE
    Coordinate{-162.98, 67.5611}, // WTK
    Coordinate{-162.667, 60.3353}, // WTL
    Coordinate{166.003, 10.1733}, // WTO
    Coordinate{147.253, -8.5625}, // WTP
    Coordinate{-109.986, 33.8106}, // WTR
    Coordinate{46.05, -18.7635}, // WTS
    Coordinate{175.679, -36.8358}, // WTZ
    Coordinate{106.803, 39.7919}, // WUA
    Coordinate{127.381, 0.83141}, // WUB
    Coordinate{135.447, -33.0432}, // WUD
    Coordinate{146.719, -7.34528}, // WUG
    Coordinate{114.208, 30.7836}, // WUH
    Coordinate{121.89, -28.7053}, // WUI
    Coordinate{120.22, -26.63}, // WUN
    Coordinate{118, 27.7008}, // WUS
    Coordinate{112.968, 38.5992}, // WUT
    Coordinate{27.975, 7.72583}, // WUU
    Coordinate{120.429, 31.4944}, // WUX
    Coordinate{111.248, 23.4567}, // WUZ
    Coordinate{14.6453, -22.98}, // WVB
    Coordinate{-121.79, 36.9358}, // WVI
    Coordinate{48.0167, -22.1197}, // WVK
    Coordinate{-69.6756, 44.5333}, // WVL
    Coordinate{-149.539, 61.5719}, // WWA
    Coordinate{-74.9083, 39.0086}, // WWD
    Coordinate{143.669, -3.58383}, // WWK
    Coordinate{-133.122, 56.1164}, // WWP
    Coordinate{-99.5228, 36.4381}, // WWR
    Coordinate{-164.641, 60.9392}, // WWT
    Coordinate{147.192, -33.9367}, // WWY
    Coordinate{108.431, 30.7978}, // WXN
    Coordinate{137.514, -33.0589}, // WYA
    Coordinate{-11.0472, 8.61047}, // WYE
    Coordinate{128.153, -15.5114}, // WYN
    Coordinate{-111.118, 44.6883}, // WYS
    Coordinate{1.83111, 50.1422}, // XAB
    Coordinate{-52.6619, -27.1339}, // XAP
    Coordinate{-0.895556, 14.2153}, // XAR
    Coordinate{-53.2042, 3.61361}, // XAU
    Coordinate{-91.0272, 53.9656}, // XBE
    Coordinate{-0.167, 12.983}, // XBG
    Coordinate{59.2661, 32.8981}, // XBJ
    Coordinate{5.29167, 46.2056}, // XBK
    Coordinate{-0.567, 12.65}, // XBO
    Coordinate{-97.8283, 33.1753}, // XBP
    Coordinate{1.20583, 47.6797}, // XBQ
    Coordinate{-75.7503, 44.6394}, // XBR
    Coordinate{4.8175, 46.8261}, // XCD
    Coordinate{105.69, -10.4506}, // XCH
    Coordinate{-109.516, 58.3914}, // XCL
    Coordinate{-82.0825, 42.3058}, // XCM
    Coordinate{4.20611, 48.7733}, // XCR
    Coordinate{3.35556, 49.0667}, // XCY
    Coordinate{4.64278, 49.785}, // XCZ
    Coordinate{-3.25, 10.9482}, // XDE
    Coordinate{-1.62472, 14.125}, // XDJ
    Coordinate{1.36278, 48.7067}, // XDR
    Coordinate{4.08528, 49.0044}, // XEP
    Coordinate{-88.3944, 42.6131}, // XES
    Coordinate{112.291, 32.15}, // XFN
    Coordinate{-3.16439, 10.383}, // XGA
    Coordinate{-0.218889, 14.4542}, // XGG
    Coordinate{14.9649, -16.7553}, // XGN
    Coordinate{-65.9928, 58.7114}, // XGR
    Coordinate{102.184, 27.9892}, // XIC
    Coordinate{-49.9764, -7.09056}, // XIG
    Coordinate{115.964, 43.9167}, // XIL
    Coordinate{108.751, 34.4469}, // XIY
    Coordinate{73.6081, 32.8767}, // XJM
    Coordinate{1.5, 12.467}, // XKA
    Coordinate{103.158, 19.4401}, // XKH
    Coordinate{-88.6431, 53.5247}, // XKS
    Coordinate{-1.1, 13.067}, // XKY
    Coordinate{-101.469, 58.6142}, // XLB
    Coordinate{2.62279, 48.8222}, // XLG
    Coordinate{-79.9133, 36.2561}, // XLL
    Coordinate{-16.4611, 16.0498}, // XLS
    Coordinate{-2.1, 11.1}, // XLU
    Coordinate{149.721, -37.5989}, // XMC
    Coordinate{-97.0856, 44.0164}, // XMD
    Coordinate{4.03, 50.3083}, // XME
    Coordinate{6.79139, 47.4867}, // XMF
    Coordinate{80.1481, 28.9633}, // XMG
    Coordinate{-146.071, -14.4375}, // XMH
    Coordinate{38.7714, -10.7383}, // XMI
    Coordinate{118.128, 24.5442}, // XMN
    Coordinate{-130.202, 63.1765}, // XMP
    Coordinate{-78.1208, -2.29917}, // XMS
    Coordinate{3.42167, 46.5344}, // XMU
    Coordinate{1.37694, 44.0267}, // XMW
    Coordinate{142.772, -9.9}, // XMY
    Coordinate{-94.3078, 36.2817}, // XNA
    Coordinate{102.043, 36.5275}, // XNN
    Coordinate{-81.0831, 33.6169}, // XNO
    Coordinate{114.429, 36.8828}, // XNT
    Coordinate{-3.867, 12.75}, // XNU
    Coordinate{0.7, 11.25}, // XPA
    Coordinate{-101.266, 55.7492}, // XPK
    Coordinate{-97.2736, 52.9964}, // XPP
    Coordinate{-102.511, 43.0225}, // XPR
    Coordinate{-84.1333, 9.44306}, // XQP
    Coordinate{-124.394, 49.3372}, // XQU
    Coordinate{-132.422, 61.9706}, // XRR
    Coordinate{-6.06, 36.7447}, // XRY
    Coordinate{-76.8942, 37.8597}, // XSA
    Coordinate{52.5833, 24.2833}, // XSB
    Coordinate{-71.5286, 21.5158}, // XSC
    Coordinate{-116.779, 37.7947}, // XSD
    Coordinate{0.503333, 13.4567}, // XSE
    Coordinate{-98.9072, 56.7928}, // XSI
    Coordinate{3.02861, 49.8689}, // XSJ
    Coordinate{6.63889, 45.95}, // XSN
    Coordinate{103.868, 1.41694}, // XSP
    Coordinate{-0.113612, 47.2567}, // XSU
    Coordinate{143.811, -27.9864}, // XTG
    Coordinate{-98.5122, 58.7061}, // XTL
    Coordinate{149.899, -25.8019}, // XTO
    Coordinate{-0.616667, 52.0722}, // XUD
    Coordinate{117.555, 34.0591}, // XUZ
    Coordinate{4.635, 45.9186}, // XVF
    Coordinate{-94.2039, 46.9903}, // XVG
    Coordinate{5.46905, 49.1224}, // XVN
    Coordinate{6.20421, 47.6386}, // XVO
    Coordinate{3.46126, 50.3247}, // XVS
    Coordinate{-103.751, 48.2597}, // XWA
    Coordinate{159.219, -9.09278}, // XYA
    Coordinate{2.31306, 49.1658}, // XYP
    Coordinate{-0.616667, 11.1667}, // XZA
    Coordinate{2.0732, 48.8103}, // XZB
    Coordinate{1.98028, 48.8422}, // XZX
    Coordinate{-125.304, 52.4514}, // YAA
    Coordinate{-85.0472, 73.0064}, // YAB
    Coordinate{-91.8244, 51.7272}, // YAC
    Coordinate{-93.4406, 48.6544}, // YAG
    Coordinate{-73.6753, 53.7547}, // YAH
    Coordinate{-72.0317, -36.5828}, // YAI
    Coordinate{-139.66, 59.5033}, // YAK
    Coordinate{-126.916, 50.5822}, // YAL
    Coordinate{-84.5094, 46.485}, // YAM
    Coordinate{24.45, 0.8}, // YAN
    Coordinate{11.5216, 3.83206}, // YAO
    Coordinate{138.083, 9.49889}, // YAP
    Coordinate{-76.1964, 53.5719}, // YAR
    Coordinate{-77.3996, 26.0004}, // YAS
    Coordinate{-82.4319, 52.9275}, // YAT
    Coordinate{-73.3214, 61.6622}, // YAU
    Coordinate{-123.3, 48.8667}, // YAV
    Coordinate{-89.5794, 53.8492}, // YAX
    Coordinate{-56.0831, 51.3919}, // YAY
    Coordinate{-125.772, 49.0822}, // YAZ
    Coordinate{-115.54, 51.2083}, // YBA
    Coordinate{-89.8053, 68.5358}, // YBB
    Coordinate{-68.2044, 49.1325}, // YBC
    Coordinate{-108.481, 59.5614}, // YBE
    Coordinate{-125.137, 48.8342}, // YBF
    Coordinate{-55.7875, 53.47}, // YBI
    Coordinate{-62.8103, 50.2836}, // YBJ
    Coordinate{-96.0778, 64.2989}, // YBK
    Coordinate{-125.273, 49.9519}, // YBL
    Coordinate{-131.087, 56.6797}, // YBM
    Coordinate{-130.249, 56.9667}, // YBO
    Coordinate{104.544, 28.8003}, // YBP
    Coordinate{-99.9522, 49.91}, // YBR
    Coordinate{-90.3769, 52.6086}, // YBS
    Coordinate{-101.679, 57.8894}, // YBT
    Coordinate{-104.009, 53.3325}, // YBU
    Coordinate{-97.0181, 52.3589}, // YBV
    Coordinate{-123.228, 48.7467}, // YBW
    Coordinate{-57.1861, 51.4419}, // YBX
    Coordinate{-110.741, 54.3047}, // YBY
    Coordinate{-124.982, 49.6794}, // YCA
    Coordinate{-105.137, 69.1081}, // YCB
    Coordinate{-74.5678, 45.0928}, // YCC
    Coordinate{-123.87, 49.0544}, // YCD
    Coordinate{-81.5064, 43.2858}, // YCE
    Coordinate{-124.984, 50.0236}, // YCF
    Coordinate{-117.632, 49.2961}, // YCG
    Coordinate{-65.4569, 47.0058}, // YCH
    Coordinate{-126.129, 67.0211}, // YCK
    Coordinate{-66.3303, 47.9908}, // YCL
    Coordinate{-79.1711, 43.1917}, // YCM
    Coordinate{-81.0153, 49.1067}, // YCN
    Coordinate{-115.144, 67.8167}, // YCO
    Coordinate{-119.283, 52.1167}, // YCP
    Coordinate{-121.627, 55.6872}, // YCQ
    Coordinate{-97.7603, 54.6108}, // YCR
    Coordinate{-90.7311, 63.3472}, // YCS
    Coordinate{-111.445, 52.075}, // YCT
    Coordinate{111.04, 35.1167}, // YCU
    Coordinate{-121.939, 49.1528}, // YCW
    Coordinate{-68.5169, 70.4858}, // YCY
    Coordinate{-115.873, 50.3303}, // YCZ
    Coordinate{-139.13, 64.0422}, // YDA
    Coordinate{-139.04, 61.3706}, // YDB
    Coordinate{-114.96, 53.2658}, // YDC
    Coordinate{-57.2308, 53.4272}, // YDE
    Coordinate{-57.3944, 49.2092}, // YDF
    Coordinate{-65.7858, 44.5458}, // YDG
    Coordinate{-103.538, 58.6625}, // YDJ
    Coordinate{-130.031, 58.4222}, // YDL
    Coordinate{-100.052, 51.1008}, // YDN
    Coordinate{-72.375, 48.7783}, // YDO
    Coordinate{-61.6822, 56.5506}, // YDP
    Coordinate{-120.183, 55.7422}, // YDQ
    Coordinate{-123.007, 49.0742}, // YDT
    Coordinate{-102.502, 60.2919}, // YDU
    Coordinate{-96.6922, 51.7844}, // YDV
    Coordinate{-103.132, 60.3156}, // YDW
    Coordinate{-110, 50.9333}, // YEA
    Coordinate{-84.0942, 46.4189}, // YEB
    Coordinate{-79.9294, 44.6847}, // YEE
    Coordinate{-113.579, 53.31}, // YEG
    Coordinate{52.6153, 27.4814}, // YEH
    Coordinate{-94.0717, 61.0939}, // YEK
    Coordinate{-82.5611, 46.3517}, // YEL
    Coordinate{-81.8575, 45.8425}, // YEM
    Coordinate{-102.966, 49.2103}, // YEN
    Coordinate{-87.6761, 56.0189}, // YER
    Coordinate{51.545, 30.7006}, // YES
    Coordinate{-116.465, 53.5789}, // YET
    Coordinate{-85.8119, 79.9944}, // YEU
    Coordinate{-133.483, 68.3039}, // YEV
    Coordinate{-78.2492, 48.565}, // YEY
    Coordinate{-81.6958, 52.2036}, // YFA
    Coordinate{-68.5561, 63.7567}, // YFB
    Coordinate{-66.5372, 45.8689}, // YFC
    Coordinate{-80.3414, 43.1325}, // YFD
    Coordinate{-69.0972, 48.7461}, // YFE
    Coordinate{-71.1733, 54.5539}, // YFG
    Coordinate{-87.9078, 51.5619}, // YFH
    Coordinate{-110.977, 57.2758}, // YFI
    Coordinate{-114.079, 64.1917}, // YFJ
    Coordinate{-109.167, 62.7}, // YFL
    Coordinate{-101.682, 54.6781}, // YFO
    Coordinate{-113.69, 61.1808}, // YFR
    Coordinate{-121.237, 61.7603}, // YFS
    Coordinate{-55.6739, 52.3728}, // YFX
    Coordinate{-75.1153, 46.1175}, // YGA
    Coordinate{-124.518, 49.6942}, // YGB
    Coordinate{-118.874, 53.9169}, // YGC
    Coordinate{-81.7108, 43.7678}, // YGD
    Coordinate{-116.982, 51.2992}, // YGE
    Coordinate{-123.5, 48.85}, // YGG
    Coordinate{-128.648, 66.2406}, // YGH
    Coordinate{133.239, 35.4933}, // YGJ
    Coordinate{-76.5969, 44.2253}, // YGK
    Coordinate{-77.7042, 53.6253}, // YGL
    Coordinate{-97.0433, 50.6281}, // YGM
    Coordinate{-94.4914, 54.5589}, // YGO
    Coordinate{-64.4797, 48.7753}, // YGP
    Coordinate{-86.9386, 49.7786}, // YGQ
    Coordinate{-61.7781, 47.425}, // YGR
    Coordinate{-81.8164, 69.3647}, // YGT
    Coordinate{-63.6111, 50.2819}, // YGV
    Coordinate{-77.7653, 55.2819}, // YGW
    Coordinate{-94.7108, 56.3578}, // YGX
    Coordinate{-82.9094, 76.4261}, // YGZ
    Coordinate{-56.2853, 52.5281}, // YHA
    Coordinate{-102.311, 52.8183}, // YHB
    Coordinate{-92.7442, 49.8317}, // YHD
    Coordinate{-121.498, 49.3683}, // YHE
    Coordinate{-83.6869, 49.7139}, // YHF
    Coordinate{-56.1125, 52.7658}, // YHG
    Coordinate{-125.25, 50.05}, // YHH
    Coordinate{-117.806, 70.7628}, // YHI
    Coordinate{-95.8503, 68.6356}, // YHK
    Coordinate{-79.935, 43.1736}, // YHM
    Coordinate{-84.7589, 49.1931}, // YHN
    Coordinate{-60.2281, 55.4489}, // YHO
    Coordinate{-94.2556, 52.1133}, // YHP
    Coordinate{-59.6367, 50.4689}, // YHR
    Coordinate{-123.719, 49.4606}, // YHS
    Coordinate{-137.545, 60.7894}, // YHT
    Coordinate{-73.4169, 45.5181}, // YHU
    Coordinate{-115.783, 60.8397}, // YHY
    Coordinate{-63.5103, 44.8797}, // YHZ
    Coordinate{-91.6386, 48.7739}, // YIB
    Coordinate{114.308, 27.8033}, // YIC
    Coordinate{119.912, 47.3106}, // YIE
    Coordinate{-58.6575, 51.2097}, // YIF
    Coordinate{-125.133, 50.4}, // YIG
    Coordinate{111.48, 30.5565}, // YIH
    Coordinate{-77.9253, 62.4172}, // YIK
    Coordinate{81.3303, 43.9558}, // YIN
    Coordinate{-77.9689, 72.6894}, // YIO
    Coordinate{-83.5304, 42.2379}, // YIP
    Coordinate{-94.6536, 53.8572}, // YIV
    Coordinate{120.032, 29.3447}, // YIW
    Coordinate{-118.059, 52.9967}, // YJA
    Coordinate{-123.47, 60.2356}, // YJF
    Coordinate{-124.263, 54.3972}, // YJM
    Coordinate{-73.2817, 45.2944}, // YJN
    Coordinate{-117.753, 53.3192}, // YJP
    Coordinate{128.41, 41.9072}, // YJS
    Coordinate{-58.55, 48.5414}, // YJT
    Coordinate{-120.449, 50.7025}, // YKA
    Coordinate{-103.677, 58.2361}, // YKC
    Coordinate{-81.6056, 44.2014}, // YKD
    Coordinate{-94.7981, 54.9153}, // YKE
    Coordinate{-80.3786, 43.4608}, // YKF
    Coordinate{-69.9992, 60.0272}, // YKG
    Coordinate{122.357, 40.5408}, // YKH
    Coordinate{-105.618, 57.2564}, // YKJ
    Coordinate{-130.433, 53.8}, // YKK
    Coordinate{-66.8053, 54.8053}, // YKL
    Coordinate{-120.544, 46.5681}, // YKM
    Coordinate{-97.3858, 42.9167}, // YKN
    Coordinate{44.2833, 37.5667}, // YKO
    Coordinate{-78.7583, 51.4733}, // YKQ
    Coordinate{129.772, 62.0933}, // YKS
    Coordinate{-78.9169, 53.8058}, // YKU
    Coordinate{-79.9814, 48.2103}, // YKX
    Coordinate{-109.181, 51.5153}, // YKY
    Coordinate{-79.3686, 43.8608}, // YKZ
    Coordinate{-112.032, 54.7703}, // YLB
    Coordinate{-69.8772, 62.8481}, // YLC
    Coordinate{-83.3469, 47.8203}, // YLD
    Coordinate{-117.246, 63.1317}, // YLE
    Coordinate{-87.9342, 52.1956}, // YLH
    Coordinate{-108.523, 54.1253}, // YLJ
    Coordinate{-79.5556, 44.4861}, // YLK
    Coordinate{-110.073, 53.3092}, // YLL
    Coordinate{-72.7889, 47.4097}, // YLQ
    Coordinate{-99.9853, 56.5133}, // YLR
    Coordinate{-77.0172, 49.0303}, // YLS
    Coordinate{-62.2806, 82.5178}, // YLT
    Coordinate{47.1417, 40.6317}, // YLV
    Coordinate{-119.378, 49.9572}, // YLW
    Coordinate{-122.631, 49.1008}, // YLY
    Coordinate{-135.868, 63.6164}, // YMA
    Coordinate{-120.747, 50.1228}, // YMB
    Coordinate{-119.319, 76.2392}, // YMD
    Coordinate{-67.4522, 48.8564}, // YME
    Coordinate{-85.8611, 49.0833}, // YMG
    Coordinate{-55.8478, 52.3028}, // YMH
    Coordinate{-70.2239, 47.5975}, // YML
    Coordinate{-111.223, 56.6533}, // YMM
    Coordinate{-59.1878, 55.0772}, // YMN
    Coordinate{-80.6083, 51.2919}, // YMO
    Coordinate{-127.029, 50.5756}, // YMP
    Coordinate{-76.1181, -5.89361}, // YMS
    Coordinate{-74.5281, 49.7719}, // YMT
    Coordinate{-124.983, 50.0667}, // YMU
    Coordinate{-79.3569, 71.3242}, // YMV
    Coordinate{-75.9906, 46.2728}, // YMW
    Coordinate{-74.0386, 45.6797}, // YMX
    Coordinate{-73.5486, 45.4825}, // YMY
    Coordinate{-61.7889, 50.19}, // YNA
    Coordinate{38.0636, 24.1442}, // YNB
    Coordinate{-78.8311, 53.0106}, // YNC
    Coordinate{-75.5636, 45.5217}, // YND
    Coordinate{-97.8442, 53.9583}, // YNE
    Coordinate{-80.6792, 41.2608}, // YNG
    Coordinate{-121.976, 56.0356}, // YNH
    Coordinate{129.451, 42.8828}, // YNJ
    Coordinate{-104.082, 58.2767}, // YNL
    Coordinate{-77.8028, 49.7617}, // YNM
    Coordinate{-92.9711, 52.4733}, // YNO
    Coordinate{-61.1844, 55.9139}, // YNP
    Coordinate{-96.9581, 50.8367}, // YNR
    Coordinate{-76.1356, 51.6911}, // YNS
    Coordinate{120.979, 37.6578}, // YNT
    Coordinate{-110.906, 63.5936}, // YNX
    Coordinate{128.669, 38.0614}, // YNY
    Coordinate{120.203, 33.4258}, // YNZ
    Coordinate{-110.615, 64.6989}, // YOA
    Coordinate{-139.84, 67.57}, // YOC
    Coordinate{-117.094, 55.7094}, // YOE
    Coordinate{-85.9011, 51.6586}, // YOG
    Coordinate{-95.2789, 54.9331}, // YOH
    Coordinate{-76.6119, 52.2219}, // YOI
    Coordinate{-117.165, 58.6217}, // YOJ
    Coordinate{12.4303, 9.2575}, // YOL
    Coordinate{91.5145, 27.2564}, // YON
    Coordinate{-78.8967, 43.9228}, // YOO
    Coordinate{-119.408, 58.4914}, // YOP
    Coordinate{-80.8383, 44.5906}, // YOS
    Coordinate{35.0675, 29.9011}, // YOT
    Coordinate{-75.6672, 45.3225}, // YOW
    Coordinate{-105.673, 53.2144}, // YPA
    Coordinate{-124.931, 49.3219}, // YPB
    Coordinate{-124.076, 69.3606}, // YPC
    Coordinate{-79.8297, 45.2575}, // YPD
    Coordinate{-117.447, 56.2272}, // YPE
    Coordinate{-123.4, 48.4333}, // YPF
    Coordinate{-98.2739, 49.9031}, // YPG
    Coordinate{-78.0769, 58.4719}, // YPH
    Coordinate{-130.433, 54.5667}, // YPI
    Coordinate{-69.5997, 59.2967}, // YPJ
    Coordinate{-122.713, 49.2161}, // YPK
    Coordinate{-90.2142, 51.4464}, // YPL
    Coordinate{-93.9733, 51.8197}, // YPM
    Coordinate{-64.2886, 49.8364}, // YPN
    Coordinate{-85.4433, 54.9881}, // YPO
    Coordinate{-78.3633, 44.2306}, // YPQ
    Coordinate{-130.445, 54.2858}, // YPR
    Coordinate{-61.3681, 45.6567}, // YPS
    Coordinate{-124.017, 49.6167}, // YPT
    Coordinate{-124.5, 49.8342}, // YPW
    Coordinate{-77.2875, 60.0522}, // YPX
    Coordinate{-111.118, 58.7675}, // YPY
    Coordinate{-125.951, 54.3764}, // YPZ
    Coordinate{-79.3039, 44.975}, // YQA
    Coordinate{-71.3933, 46.7911}, // YQB
    Coordinate{-69.6178, 61.0464}, // YQC
    Coordinate{-101.091, 53.9714}, // YQD
    Coordinate{-113.894, 52.1822}, // YQF
    Coordinate{-82.9553, 42.2761}, // YQG
    Coordinate{-128.822, 60.1164}, // YQH
    Coordinate{-66.0883, 43.8272}, // YQI
    Coordinate{-94.3631, 49.7883}, // YQK
    Coordinate{-112.8, 49.6303}, // YQL
    Coordinate{-64.6786, 46.1122}, // YQM
    Coordinate{-86.6975, 50.1831}, // YQN
    Coordinate{-104.666, 50.4322}, // YQR
    Coordinate{-81.1097, 42.77}, // YQS
    Coordinate{-89.3217, 48.3719}, // YQT
    Coordinate{-118.885, 55.18}, // YQU
    Coordinate{-102.461, 51.2647}, // YQV
    Coordinate{-108.244, 52.7692}, // YQW
    Coordinate{-54.5681, 48.9369}, // YQX
    Coordinate{-60.0481, 46.1614}, // YQY
    Coordinate{-122.51, 53.0261}, // YQZ
    Coordinate{-117.31, 64.1161}, // YRA
    Coordinate{-94.9694, 74.7169}, // YRB
    Coordinate{-71.0506, 48.5208}, // YRC
    Coordinate{-57.0419, 53.6825}, // YRF
    Coordinate{-58.4578, 54.1794}, // YRG
    Coordinate{-69.5844, 47.7644}, // YRI
    Coordinate{-72.2658, 48.52}, // YRJ
    Coordinate{-93.7931, 51.0672}, // YRL
    Coordinate{-114.904, 52.4297}, // YRM
    Coordinate{-127.25, 51.6833}, // YRN
    Coordinate{-75.6461, 45.4603}, // YRO
    Coordinate{-76.0222, 45.3225}, // YRP
    Coordinate{-72.6806, 46.3517}, // YRQ
    Coordinate{-93.5575, 54.1675}, // YRS
    Coordinate{-92.1147, 62.8106}, // YRT
    Coordinate{-118.183, 50.9667}, // YRV
    Coordinate{-59.9597, 43.9294}, // YSA
    Coordinate{-80.7978, 46.6256}, // YSB
    Coordinate{-71.6914, 45.4386}, // YSC
    Coordinate{-123.162, 49.7817}, // YSE
    Coordinate{-105.841, 59.2503}, // YSF
    Coordinate{-110.682, 62.4183}, // YSG
    Coordinate{-75.9403, 44.9458}, // YSH
    Coordinate{-80.1375, 45.1733}, // YSI
    Coordinate{-65.89, 45.3161}, // YSJ
    Coordinate{-79.25, 56.5369}, // YSK
    Coordinate{-67.8364, 47.1572}, // YSL
    Coordinate{-111.962, 60.0203}, // YSM
    Coordinate{-119.229, 50.6825}, // YSN
    Coordinate{-59.7853, 54.9103}, // YSO
    Coordinate{-86.3458, 48.7572}, // YSP
    Coordinate{124.55, 44.9381}, // YSQ
    Coordinate{-84.6136, 72.9822}, // YSR
    Coordinate{-94.8522, 53.8456}, // YST
    Coordinate{-63.8336, 46.4406}, // YSU
    Coordinate{-62.6542, 58.4744}, // YSV
    Coordinate{-128.083, 52.15}, // YSX
    Coordinate{-125.241, 71.9936}, // YSY
    Coordinate{-77.2514, 45.8644}, // YTA
    Coordinate{-129.25, 53.4167}, // YTB
    Coordinate{-97.7078, 55.3189}, // YTD
    Coordinate{-76.525, 64.2303}, // YTE
    Coordinate{-71.6414, 48.5086}, // YTF
    Coordinate{-126.833, 50.8833}, // YTG
    Coordinate{-97.8625, 55.8047}, // YTH
    Coordinate{-87.0994, 48.8133}, // YTJ
    Coordinate{-89.8969, 53.8178}, // YTL
    Coordinate{-74.78, 46.4092}, // YTM
    Coordinate{-62.6211, 45.6119}, // YTN
    Coordinate{-125.91, 49.1553}, // YTP
    Coordinate{-69.9558, 58.6678}, // YTQ
    Coordinate{-81.3767, 48.5706}, // YTS
    Coordinate{-104.067, 52.8367}, // YTT
    Coordinate{-132.042, 52.765}, // YTU
    Coordinate{-131.117, 57.9167}, // YTX
    Coordinate{119.715, 32.5617}, // YTY
    Coordinate{-79.3961, 43.6275}, // YTZ
    Coordinate{-133.026, 69.4333}, // YUB
    Coordinate{-76.5183, 56.5361}, // YUD
    Coordinate{131.782, -22.2542}, // YUE
    Coordinate{-73.7408, 45.4706}, // YUL
    Coordinate{-114.606, 32.6567}, // YUM
    Coordinate{97.1242, 32.8299}, // YUS
    Coordinate{-86.2247, 66.5206}, // YUT
    Coordinate{-81.2425, 68.7758}, // YUX
    Coordinate{-78.8356, 48.2061}, // YUY
    Coordinate{43.2439, -11.7108}, // YVA
    Coordinate{-65.4603, 48.0711}, // YVB
    Coordinate{-105.267, 55.1514}, // YVC
    Coordinate{-119.331, 50.2461}, // YVE
    Coordinate{-110.825, 52.3569}, // YVG
    Coordinate{-64.0317, 67.5467}, // YVM
    Coordinate{-77.7828, 48.0533}, // YVO
    Coordinate{-68.4222, 58.095}, // YVP
    Coordinate{-126.799, 65.2814}, // YVQ
    Coordinate{-123.184, 49.1947}, // YVR
    Coordinate{-108.418, 55.8419}, // YVT
    Coordinate{-81.1086, 44.7442}, // YVV
    Coordinate{-94.0614, 52.6558}, // YVZ
    Coordinate{-77.3192, 45.9522}, // YWA
    Coordinate{-71.9294, 61.5886}, // YWB
    Coordinate{-97.24, 49.91}, // YWG
    Coordinate{-123.387, 48.4228}, // YWH
    Coordinate{-123.436, 65.2111}, // YWJ
    Coordinate{-66.8647, 52.9228}, // YWK
    Coordinate{-122.054, 52.1833}, // YWL
    Coordinate{-55.785, 52.5675}, // YWM
    Coordinate{-111.25, 65.7592}, // YWO
    Coordinate{-87.3753, 52.9594}, // YWP
    Coordinate{-71.1361, 49.945}, // YWQ
    Coordinate{-85.2233, 48.6269}, // YWR
    Coordinate{-122.949, 50.1436}, // YWS
    Coordinate{-110.857, 52.7958}, // YWV
    Coordinate{-123.437, 63.2097}, // YWY
    Coordinate{-115.782, 49.6122}, // YXC
    Coordinate{-113.519, 53.5719}, // YXD
    Coordinate{-106.7, 52.1708}, // YXE
    Coordinate{-110.721, 50.0189}, // YXH
    Coordinate{-77.6028, 45.6631}, // YXI
    Coordinate{-120.74, 56.2383}, // YXJ
    Coordinate{-68.4964, 48.4778}, // YXK
    Coordinate{-91.9056, 50.1142}, // YXL
    Coordinate{-92.5981, 62.24}, // YXN
    Coordinate{-65.7136, 66.145}, // YXP
    Coordinate{-140.869, 62.4103}, // YXQ
    Coordinate{-79.8489, 47.695}, // YXR
    Coordinate{-122.677, 53.8842}, // YXS
    Coordinate{-128.578, 54.4686}, // YXT
    Coordinate{-81.1511, 43.0331}, // YXU
    Coordinate{-122.36, 49.0253}, // YXX
    Coordinate{-135.067, 60.7094}, // YXY
    Coordinate{-84.7864, 47.9669}, // YXZ
    Coordinate{-79.4242, 46.3639}, // YYB
    Coordinate{-114.02, 51.1139}, // YYC
    Coordinate{-127.183, 54.8253}, // YYD
    Coordinate{-122.597, 58.8364}, // YYE
    Coordinate{-119.602, 49.4625}, // YYF
    Coordinate{-63.1192, 46.2892}, // YYG
    Coordinate{-93.5769, 69.5467}, // YYH
    Coordinate{-123.426, 48.6472}, // YYJ
    Coordinate{-101.076, 56.8644}, // YYL
    Coordinate{-114.094, 49.6364}, // YYM
    Coordinate{-107.691, 50.2925}, // YYN
    Coordinate{-104.169, 51.8092}, // YYO
    Coordinate{-94.0664, 58.7392}, // YYQ
    Coordinate{-52.7525, 47.6186}, // YYT
    Coordinate{-82.4686, 49.4117}, // YYU
    Coordinate{-88.9097, 50.2903}, // YYW
    Coordinate{-68.2075, 48.6089}, // YYY
    Coordinate{-79.6306, 43.6767}, // YYZ
    Coordinate{-121.322, 50.775}, // YZA
    Coordinate{-79.4656, 43.7428}, // YZD
    Coordinate{-82.5683, 45.8842}, // YZE
    Coordinate{-114.44, 62.4631}, // YZF
    Coordinate{-75.6672, 62.1794}, // YZG
    Coordinate{-114.777, 55.2931}, // YZH
    Coordinate{-131.814, 53.2542}, // YZP
    Coordinate{-82.3094, 42.9997}, // YZR
    Coordinate{-83.3594, 64.1933}, // YZS
    Coordinate{-127.333, 50.6806}, // YZT
    Coordinate{-115.787, 54.1439}, // YZU
    Coordinate{-66.2656, 50.2233}, // YZV
    Coordinate{-132.744, 60.1731}, // YZW
    Coordinate{100.675, 38.8019}, // YZY
    Coordinate{-117.609, 49.0556}, // YZZ
    Coordinate{-129.483, 55.4667}, // ZAA
    Coordinate{-96.0892, 56.0894}, // ZAC
    Coordinate{15.3467, 44.1083}, // ZAD
    Coordinate{16.0689, 45.7431}, // ZAG
    Coordinate{60.9033, 29.4733}, // ZAH
    Coordinate{61.8667, 30.9695}, // ZAJ
    Coordinate{-73.0863, -39.6498}, // ZAL
    Coordinate{122.06, 6.92242}, // ZAM
    Coordinate{-103.459, 20.7333}, // ZAP
    Coordinate{7.68556, 11.13}, // ZAR
    Coordinate{103.757, 27.3278}, // ZAT
    Coordinate{-1.04167, 41.6661}, // ZAZ
    Coordinate{-65.7389, 47.6297}, // ZBF
    Coordinate{19.2333, 43.1167}, // ZBK
    Coordinate{150.5, -24.3958}, // ZBL
    Coordinate{-72.7419, 45.2908}, // ZBM
    Coordinate{148.215, -20.0199}, // ZBO
    Coordinate{60.3819, 25.4433}, // ZBR
    Coordinate{101.733, 19.233}, // ZBY
    Coordinate{7.89933, 51.4833}, // ZCA
    Coordinate{8.18667, 48.7919}, // ZCC
    Coordinate{-102.686, 22.8974}, // ZCL
    Coordinate{-72.6514, -38.9258}, // ZCO
    Coordinate{-71.2169, -34.9669}, // ZCQ
    Coordinate{52.3358, 24.5031}, // ZDY
    Coordinate{-80.7861, 36.28}, // ZEF
    Coordinate{-128.157, 52.185}, // ZEL
    Coordinate{-78.5225, 52.2264}, // ZEM
    Coordinate{93.8281, 27.5883}, // ZER
    Coordinate{-133.373, 62.2069}, // ZFA
    Coordinate{-107.182, 59.3344}, // ZFD
    Coordinate{-134.86, 67.4069}, // ZFM
    Coordinate{-125.573, 64.9097}, // ZFN
    Coordinate{-118.433, 56.0814}, // ZFW
    Coordinate{-118.431, 49.0156}, // ZGF
    Coordinate{-94.0786, 54.8397}, // ZGI
    Coordinate{25.9333, -15.9667}, // ZGM
    Coordinate{-95.4661, 52.045}, // ZGR
    Coordinate{-60.6739, 50.2597}, // ZGS
    Coordinate{167.587, -14.2181}, // ZGU
    Coordinate{110.358, 21.2175}, // ZHA
    Coordinate{91.9169, 24.3983}, // ZHM
    Coordinate{-116.475, 53.3936}, // ZHP
    Coordinate{6.79278, 47.0839}, // ZHV
    Coordinate{105.154, 37.5728}, // ZHY
    Coordinate{38.1517, 55.5533}, // ZIA
    Coordinate{-72.3486, -38.2456}, // ZIC
    Coordinate{-16.2817, 12.5556}, // ZIG
    Coordinate{-101.461, 17.6014}, // ZIH
    Coordinate{7.87786, 46.6747}, // ZIN
    Coordinate{12.25, 31.775}, // ZIS
    Coordinate{123.361, 66.7964}, // ZIX
    Coordinate{-98.0461, 54.5189}, // ZJG
    Coordinate{8.87861, 46.1608}, // ZJI
    Coordinate{-101.234, 52.1214}, // ZJN
    Coordinate{30.6614, -8.53333}, // ZKB
    Coordinate{-81.6778, 52.2825}, // ZKE
    Coordinate{-61.2658, 50.1958}, // ZKG
    Coordinate{9.76528, -2.53889}, // ZKM
    Coordinate{150.708, 65.7383}, // ZKP
    Coordinate{-17.0833, 20.85}, // ZLG
    Coordinate{-104.559, 19.1447}, // ZLO
    Coordinate{-71.5486, -35.8617}, // ZLR
    Coordinate{-58.9756, 50.8308}, // ZLT
    Coordinate{23.4824, 12.9012}, // ZLX
    Coordinate{11.6265, 52.0732}, // ZMG
    Coordinate{-121.333, 51.7367}, // ZMH
    Coordinate{-102.271, 20.0456}, // ZMM
    Coordinate{10.8086, 44.6314}, // ZMO
    Coordinate{-132.125, 54.0272}, // ZMT
    Coordinate{-123.935, 49.1692}, // ZNA
    Coordinate{-159.994, 60.9806}, // ZNC
    Coordinate{8.9837, 13.779}, // ZND
    Coordinate{119.803, -23.4178}, // ZNE
    Coordinate{27.9833, -27.2833}, // ZNJ
    Coordinate{-117.301, 49.4942}, // ZNL
    Coordinate{39.225, -6.22222}, // ZNZ
    Coordinate{-127.717, 52.3667}, // ZOF
    Coordinate{-73.0606, -40.6114}, // ZOS
    Coordinate{-92.1964, 53.8911}, // ZPB
    Coordinate{-71.9208, -39.2914}, // ZPC
    Coordinate{-82.1558, 28.2281}, // ZPH
    Coordinate{-106.582, 55.5281}, // ZPO
    Coordinate{6.78805, 49.8635}, // ZQF
    Coordinate{168.739, -45.0211}, // ZQN
    Coordinate{-132.076, 53.2543}, // ZQS
    Coordinate{8.36667, 49.6064}, // ZQV
    Coordinate{7.40056, 49.2094}, // ZQW
    Coordinate{114.93, 40.7386}, // ZQZ
    Coordinate{20.4541, 45.3398}, // ZRE
    Coordinate{8.54917, 47.4647}, // ZRH
    Coordinate{}, // ZRI
    Coordinate{-91.3125, 52.9436}, // ZRJ
    Coordinate{10.6623, 44.6983}, // ZRO
    Coordinate{-74.5239, 24.0631}, // ZSA
    Coordinate{55.4256, -21.3217}, // ZSE
    Coordinate{-93.3444, 53.0642}, // ZSJ
    Coordinate{-111.378, 53.9936}, // ZSP
    Coordinate{-6.13278, 4.92833}, // ZSS
    Coordinate{-129.983, 55.9333}, // ZST
    Coordinate{12.184, 51.8318}, // ZSU
    Coordinate{-130.283, 54.3333}, // ZSW
    Coordinate{-138.57, -20.7897}, // ZTA
    Coordinate{-59.3836, 50.6744}, // ZTB
    Coordinate{20.8842, 37.7508}, // ZTH
    Coordinate{-92.0814, 55.8631}, // ZTM
    Coordinate{28.7386, 50.2706}, // ZTR
    Coordinate{-126.667, 49.9167}, // ZTS
    Coordinate{46.6672, 41.5622}, // ZTU
    Coordinate{-91.7178, 49.4297}, // ZUC
    Coordinate{-73.7975, -41.9039}, // ZUD
    Coordinate{113.376, 22.0069}, // ZUH
    Coordinate{-59.8807, -36.8372}, // ZUL
    Coordinate{-64.1058, 53.5625}, // ZUM
    Coordinate{-108.792, 35.0831}, // ZUN
    Coordinate{45.45, -19.5667}, // ZVA
    Coordinate{127.67, -17.7869}, // ZVG
    Coordinate{104.759, 16.55}, // ZVK
    Coordinate{-113.856, 53.6683}, // ZVL
    Coordinate{49.6167, -14.65}, // ZWA
    Coordinate{-103.173, 58.1069}, // ZWL
    Coordinate{-8.57583, 70.9611}, // ZXB
    Coordinate{49.977, 40.4951}, // ZXT
    Coordinate{107, 27.59}, // ZYI
    Coordinate{91.8669, 24.9633}, // ZYL
    Coordinate{142.76, 50.6683}, // ZZO
    Coordinate{34.0117, -11.4479}, // ZZU
    Coordinate{-81.8922, 39.9444}, // ZZV
};

// timezone name strings
static const char timezone_names[] =
    "Africa/Abidjan\0"
    "Africa/Accra\0"
    "Africa/Addis_Ababa\0"
    "Africa/Algiers\0"
    "Africa/Asmara\0"
    "Africa/Bamako\0"
    "Africa/Banjul\0"
    "Africa/Bissau\0"
    "Africa/Blantyre\0"
    "Africa/Brazzaville\0"
    "Africa/Cairo\0"
    "Africa/Ceuta\0"
    "Africa/Conakry\0"
    "Africa/Dakar\0"
    "Africa/Dar_es_Salaam\0"
    "Africa/Djibouti\0"
    "Africa/Douala\0"
    "Africa/El_Aaiun\0"
    "Africa/Freetown\0"
    "Africa/Gaborone\0"
    "Africa/Harare\0"
    "Africa/Johannesburg\0"
    "Africa/Juba\0"
    "Africa/Kampala\0"
    "Africa/Kigali\0"
    "Africa/Kinshasa\0"
    "Africa/Lagos\0"
    "Africa/Libreville\0"
    "Africa/Lome\0"
    "Africa/Luanda\0"
    "Africa/Lubumbashi\0"
    "Africa/Lusaka\0"
    "Africa/Malabo\0"
    "Africa/Maputo\0"
    "Africa/Maseru\0"
    "Africa/Mbabane\0"
    "Africa/Mogadishu\0"
    "Africa/Monrovia\0"
    "Africa/Nairobi\0"
    "Africa/Ndjamena\0"
    "Africa/Niamey\0"
    "Africa/Nouakchott\0"
    "Africa/Ouagadougou\0"
    "Africa/Porto-Novo\0"
    "Africa/Sao_Tome\0"
    "Africa/Tripoli\0"
    "Africa/Tunis\0"
    "Africa/Windhoek\0"
    "America/Adak\0"
    "America/Anchorage\0"
    "America/Anguilla\0"
    "America/Araguaina\0"
    "America/Argentina/Buenos_Aires\0"
    "America/Argentina/Catamarca\0"
    "America/Argentina/Cordoba\0"
    "America/Argentina/La_Rioja\0"
    "America/Argentina/Mendoza\0"
    "America/Argentina/Rio_Gallegos\0"
    "America/Argentina/Salta\0"
    "America/Argentina/San_Juan\0"
    "America/Argentina/San_Luis\0"
    "America/Argentina/Tucuman\0"
    "America/Argentina/Ushuaia\0"
    "America/Aruba\0"
    "America/Asuncion\0"
    "America/Atikokan\0"
    "America/Bahia\0"
    "America/Bahia_Banderas\0"
    "America/Barbados\0"
    "America/Belem\0"
    "America/Belize\0"
    "America/Blanc-Sablon\0"
    "America/Boa_Vista\0"
    "America/Bogota\0"
    "America/Boise\0"
    "America/Cambridge_Bay\0"
    "America/Campo_Grande\0"
    "America/Cancun\0"
    "America/Caracas\0"
    "America/Cayenne\0"
    "America/Cayman\0"
    "America/Chicago\0"
    "America/Chihuahua\0"
    "America/Costa_Rica\0"
    "America/Creston\0"
    "America/Cuiaba\0"
    "America/Curacao\0"
    "America/Danmarkshavn\0"
    "America/Dawson_Creek\0"
    "America/Denver\0"
    "America/Detroit\0"
    "America/Dominica\0"
    "America/Edmonton\0"
    "America/Eirunepe\0"
    "America/El_Salvador\0"
    "America/Fort_Nelson\0"
    "America/Fortaleza\0"
    "America/Glace_Bay\0"
    "America/Godthab\0"
    "America/Grand_Turk\0"
    "America/Grenada\0"
    "America/Guadeloupe\0"
    "America/Guatemala\0"
    "America/Guyana\0"
    "America/Halifax\0"
    "America/Havana\0"
    "America/Hermosillo\0"
    "America/Indiana/Knox\0"
    "America/Indiana/Vincennes\0"
    "America/Inuvik\0"
    "America/Iqaluit\0"
    "America/Juneau\0"
    "America/Kentucky/Louisville\0"
    "America/Kentucky/Monticello\0"
    "America/Kralendijk\0"
    "America/La_Paz\0"
    "America/Lima\0"
    "America/Los_Angeles\0"
    "America/Maceio\0"
    "America/Managua\0"
    "America/Manaus\0"
    "America/Martinique\0"
    "America/Matamoros\0"
    "America/Mazatlan\0"
    "America/Menominee\0"
    "America/Merida\0"
    "America/Metlakatla\0"
    "America/Mexico_City\0"
    "America/Miquelon\0"
    "America/Moncton\0"
    "America/Monterrey\0"
    "America/Montevideo\0"
    "America/Montserrat\0"
    "America/Nassau\0"
    "America/New_York\0"
    "America/Nome\0"
    "America/Noronha\0"
    "America/North_Dakota/Beulah\0"
    "America/Ojinaga\0"
    "America/Panama\0"
    "America/Pangnirtung\0"
    "America/Paramaribo\0"
    "America/Phoenix\0"
    "America/Port-au-Prince\0"
    "America/Port_of_Spain\0"
    "America/Porto_Velho\0"
    "America/Puerto_Rico\0"
    "America/Punta_Arenas\0"
    "America/Rankin_Inlet\0"
    "America/Recife\0"
    "America/Regina\0"
    "America/Resolute\0"
    "America/Rio_Branco\0"
    "America/Santarem\0"
    "America/Santiago\0"
    "America/Santo_Domingo\0"
    "America/Sao_Paulo\0"
    "America/Sitka\0"
    "America/St_Barthelemy\0"
    "America/St_Johns\0"
    "America/St_Kitts\0"
    "America/St_Lucia\0"
    "America/St_Thomas\0"
    "America/St_Vincent\0"
    "America/Tegucigalpa\0"
    "America/Thule\0"
    "America/Thunder_Bay\0"
    "America/Tijuana\0"
    "America/Toronto\0"
    "America/Tortola\0"
    "America/Vancouver\0"
    "America/Whitehorse\0"
    "America/Winnipeg\0"
    "America/Yakutat\0"
    "America/Yellowknife\0"
    "Arctic/Longyearbyen\0"
    "Asia/Aden\0"
    "Asia/Almaty\0"
    "Asia/Amman\0"
    "Asia/Anadyr\0"
    "Asia/Aqtau\0"
    "Asia/Aqtobe\0"
    "Asia/Ashgabat\0"
    "Asia/Atyrau\0"
    "Asia/Baghdad\0"
    "Asia/Bahrain\0"
    "Asia/Baku\0"
    "Asia/Barnaul\0"
    "Asia/Beirut\0"
    "Asia/Bishkek\0"
    "Asia/Brunei\0"
    "Asia/Chita\0"
    "Asia/Choibalsan\0"
    "Asia/Colombo\0"
    "Asia/Damascus\0"
    "Asia/Dhaka\0"
    "Asia/Dubai\0"
    "Asia/Dushanbe\0"
    "Asia/Famagusta\0"
    "Asia/Hebron\0"
    "Asia/Ho_Chi_Minh\0"
    "Asia/Hovd\0"
    "Asia/Irkutsk\0"
    "Asia/Jayapura\0"
    "Asia/Jerusalem\0"
    "Asia/Kabul\0"
    "Asia/Kamchatka\0"
    "Asia/Karachi\0"
    "Asia/Kathmandu\0"
    "Asia/Khandyga\0"
    "Asia/Kolkata\0"
    "Asia/Krasnoyarsk\0"
    "Asia/Kuala_Lumpur\0"
    "Asia/Kuwait\0"
    "Asia/Magadan\0"
    "Asia/Makassar\0"
    "Asia/Manila\0"
    "Asia/Muscat\0"
    "Asia/Nicosia\0"
    "Asia/Novokuznetsk\0"
    "Asia/Novosibirsk\0"
    "Asia/Oral\0"
    "Asia/Phnom_Penh\0"
    "Asia/Pontianak\0"
    "Asia/Pyongyang\0"
    "Asia/Qatar\0"
    "Asia/Qyzylorda\0"
    "Asia/Riyadh\0"
    "Asia/Sakhalin\0"
    "Asia/Samarkand\0"
    "Asia/Seoul\0"
    "Asia/Shanghai\0"
    "Asia/Singapore\0"
    "Asia/Srednekolymsk\0"
    "Asia/Taipei\0"
    "Asia/Tashkent\0"
    "Asia/Tbilisi\0"
    "Asia/Tehran\0"
    "Asia/Thimphu\0"
    "Asia/Tokyo\0"
    "Asia/Tomsk\0"
    "Asia/Ulaanbaatar\0"
    "Asia/Urumqi\0"
    "Asia/Ust-Nera\0"
    "Asia/Vientiane\0"
    "Asia/Vladivostok\0"
    "Asia/Yakutsk\0"
    "Asia/Yangon\0"
    "Asia/Yekaterinburg\0"
    "Asia/Yerevan\0"
    "Atlantic/Azores\0"
    "Atlantic/Bermuda\0"
    "Atlantic/Canary\0"
    "Atlantic/Cape_Verde\0"
    "Atlantic/Faroe\0"
    "Atlantic/Madeira\0"
    "Atlantic/Reykjavik\0"
    "Atlantic/St_Helena\0"
    "Atlantic/Stanley\0"
    "Australia/Adelaide\0"
    "Australia/Brisbane\0"
    "Australia/Broken_Hill\0"
    "Australia/Currie\0"
    "Australia/Darwin\0"
    "Australia/Eucla\0"
    "Australia/Hobart\0"
    "Australia/Melbourne\0"
    "Australia/Perth\0"
    "Australia/Sydney\0"
    "Europe/Amsterdam\0"
    "Europe/Astrakhan\0"
    "Europe/Athens\0"
    "Europe/Belgrade\0"
    "Europe/Berlin\0"
    "Europe/Bratislava\0"
    "Europe/Brussels\0"
    "Europe/Bucharest\0"
    "Europe/Budapest\0"
    "Europe/Chisinau\0"
    "Europe/Copenhagen\0"
    "Europe/Dublin\0"
    "Europe/Guernsey\0"
    "Europe/Helsinki\0"
    "Europe/Isle_of_Man\0"
    "Europe/Istanbul\0"
    "Europe/Jersey\0"
    "Europe/Kaliningrad\0"
    "Europe/Kiev\0"
    "Europe/Kirov\0"
    "Europe/Lisbon\0"
    "Europe/Ljubljana\0"
    "Europe/London\0"
    "Europe/Luxembourg\0"
    "Europe/Madrid\0"
    "Europe/Malta\0"
    "Europe/Mariehamn\0"
    "Europe/Minsk\0"
    "Europe/Moscow\0"
    "Europe/Oslo\0"
    "Europe/Paris\0"
    "Europe/Podgorica\0"
    "Europe/Prague\0"
    "Europe/Riga\0"
    "Europe/Rome\0"
    "Europe/Samara\0"
    "Europe/Sarajevo\0"
    "Europe/Saratov\0"
    "Europe/Simferopol\0"
    "Europe/Skopje\0"
    "Europe/Sofia\0"
    "Europe/Stockholm\0"
    "Europe/Tallinn\0"
    "Europe/Tirane\0"
    "Europe/Ulyanovsk\0"
    "Europe/Vienna\0"
    "Europe/Vilnius\0"
    "Europe/Volgograd\0"
    "Europe/Warsaw\0"
    "Europe/Zagreb\0"
    "Europe/Zaporozhye\0"
    "Europe/Zurich\0"
    "Indian/Antananarivo\0"
    "Indian/Christmas\0"
    "Indian/Comoro\0"
    "Indian/Mahe\0"
    "Indian/Maldives\0"
    "Indian/Mauritius\0"
    "Indian/Mayotte\0"
    "Indian/Reunion\0"
    "Pacific/Apia\0"
    "Pacific/Auckland\0"
    "Pacific/Bougainville\0"
    "Pacific/Chatham\0"
    "Pacific/Chuuk\0"
    "Pacific/Easter\0"
    "Pacific/Efate\0"
    "Pacific/Enderbury\0"
    "Pacific/Fiji\0"
    "Pacific/Funafuti\0"
    "Pacific/Galapagos\0"
    "Pacific/Gambier\0"
    "Pacific/Guadalcanal\0"
    "Pacific/Guam\0"
    "Pacific/Honolulu\0"
    "Pacific/Kiritimati\0"
    "Pacific/Kwajalein\0"
    "Pacific/Majuro\0"
    "Pacific/Marquesas\0"
    "Pacific/Midway\0"
    "Pacific/Niue\0"
    "Pacific/Noumea\0"
    "Pacific/Pago_Pago\0"
    "Pacific/Pohnpei\0"
    "Pacific/Port_Moresby\0"
    "Pacific/Rarotonga\0"
    "Pacific/Saipan\0"
    "Pacific/Tahiti\0"
    "Pacific/Tarawa\0"
    "Pacific/Tongatapu\0"
    "Pacific/Wallis\0"
;

// timezone name string table indexes
static const uint16_t timezone_table[] = {
    5802, // AAA Pacific/Tahiti
    4262, // AAB Australia/Adelaide
    153, // AAC Africa/Cairo
    47, // AAE Africa/Algiers
    std::numeric_limits<uint16_t>::max(), // AAF
    2759, // AAG America/Sao_Paulo
    784, // AAI America/Araguaina
    2475, // AAJ America/Paramaribo
    5817, // AAK Pacific/Tarawa
    4603, // AAL Europe/Copenhagen
    320, // AAM Africa/Johannesburg
    3358, // AAN Asia/Dubai
    1358, // AAO America/Caracas
    1405, // AAP America/Chicago
    4880, // AAQ Europe/Moscow
    4603, // AAR Europe/Copenhagen
    3450, // AAS Asia/Jayapura
    3991, // AAT Asia/Urumqi
    5359, // AAU Pacific/Apia
    3634, // AAV Asia/Manila
    3505, // AAW Asia/Karachi
    2759, // AAX America/Sao_Paulo
    3113, // AAY Asia/Aden
    1775, // AAZ America/Guatemala
    3560, // ABA Asia/Krasnoyarsk
    397, // ABB Africa/Lagos
    4823, // ABC Europe/Madrid
    3207, // ABD Asia/Baghdad
    2350, // ABE America/New_York
    5817, // ABF Pacific/Tarawa
    4281, // ABG Australia/Brisbane
    4281, // ABH Australia/Brisbane
    1405, // ABI America/Chicago
    0, // ABJ Africa/Abidjan
    28, // ABK Africa/Addis_Ababa
    749, // ABL America/Anchorage
    4281, // ABM Australia/Brisbane
    2475, // ABN America/Paramaribo
    0, // ABO Africa/Abidjan
    3450, // ABP Asia/Jayapura
    1547, // ABQ America/Denver
    1405, // ABR America/Chicago
    153, // ABS Africa/Cairo
    3788, // ABT Asia/Riyadh
    3620, // ABU Asia/Makassar
    397, // ABV Africa/Lagos
    5748, // ABW Pacific/Port_Moresby
    4425, // ABX Australia/Sydney
    2350, // ABY America/New_York
    4791, // ABZ Europe/London
    2226, // ACA America/Mexico_City
    1562, // ACB America/Detroit
    15, // ACC Africa/Accra
    1271, // ACD America/Bogota
    4139, // ACE Atlantic/Canary
    5219, // ACH Europe/Zurich
    4635, // ACI Europe/Guernsey
    3320, // ACJ Asia/Colombo
    2350, // ACK America/New_York
    1271, // ACL America/Bogota
    2139, // ACN America/Matamoros
    3927, // ACP Asia/Tehran
    1405, // ACQ America/Chicago
    1271, // ACR America/Bogota
    3560, // ACS Asia/Krasnoyarsk
    1405, // ACT America/Chicago
    2440, // ACU America/Panama
    2054, // ACV America/Los_Angeles
    3840, // ACX Asia/Shanghai
    2350, // ACY America/New_York
    3927, // ACZ Asia/Tehran
    4686, // ADA Europe/Istanbul
    4686, // ADB Europe/Istanbul
    5748, // ADC Pacific/Port_Moresby
    28, // ADD Africa/Addis_Ababa
    3113, // ADE Asia/Aden
    4686, // ADF Europe/Istanbul
    1562, // ADG America/Detroit
    4049, // ADH Asia/Yakutsk
    720, // ADI Africa/Windhoek
    3135, // ADJ Asia/Amman
    736, // ADK America/Adak
    4262, // ADL Australia/Adelaide
    1405, // ADM America/Chicago
    4262, // ADO Australia/Adelaide
    3320, // ADP Asia/Colombo
    749, // ADQ America/Anchorage
    2350, // ADR America/New_York
    1405, // ADS America/Chicago
    1405, // ADT America/Chicago
    3927, // ADU Asia/Tehran
    367, // ADV Africa/Kigali
    320, // ADY Africa/Johannesburg
    1271, // ADZ America/Bogota
    std::numeric_limits<uint16_t>::max(), // AEA
    3840, // AEB Asia/Shanghai
    3450, // AEG Asia/Jayapura
    591, // AEH Africa/Ndjamena
    4823, // AEI Europe/Madrid
    1405, // AEL America/Chicago
    621, // AEO Africa/Nouakchott
    802, // AEP America/Argentina/Buenos_Aires
    4880, // AER Europe/Moscow
    4894, // AES Europe/Oslo
    749, // AET America/Anchorage
    3927, // AEU Asia/Tehran
    1405, // AEX America/Chicago
    4207, // AEY Atlantic/Reykjavik
    914, // AFA America/Argentina/Mendoza
    320, // AFD Africa/Johannesburg
    2777, // AFE America/Sitka
    1271, // AFI America/Bogota
    1405, // AFK America/Chicago
    1474, // AFL America/Cuiaba
    2350, // AFN America/New_York
    1547, // AFO America/Denver
    2350, // AFP America/New_York
    3814, // AFS Asia/Samarkand
    5551, // AFT Pacific/Guadalcanal
    1405, // AFW America/Chicago
    4686, // AFY Europe/Istanbul
    3927, // AFZ Asia/Tehran
    166, // AGA Africa/Ceuta
    2350, // AGC America/New_York
    3450, // AGD Asia/Jayapura
    4906, // AGF Europe/Paris
    5064, // AGH Europe/Stockholm
    2475, // AGI America/Paramaribo
    3952, // AGJ Asia/Tokyo
    5748, // AGL Pacific/Port_Moresby
    1936, // AGN America/Juneau
    1405, // AGO America/Chicago
    4823, // AGP Europe/Madrid
    4476, // AGQ Europe/Athens
    2350, // AGS America/New_York
    1115, // AGT America/Asuncion
    2226, // AGU America/Mexico_City
    1358, // AGV America/Caracas
    4281, // AGW Australia/Brisbane
    3547, // AGX Asia/Kolkata
    4409, // AGY Australia/Perth
    320, // AGZ Africa/Johannesburg
    3788, // AHB Asia/Riyadh
    1405, // AHD America/Chicago
    5802, // AHE Pacific/Tahiti
    1405, // AHF America/Chicago
    1405, // AHH America/Chicago
    3450, // AHI Asia/Jayapura
    3840, // AHJ Asia/Shanghai
    1793, // AHL America/Guyana
    2054, // AHM America/Los_Angeles
    2350, // AHN America/New_York
    4962, // AHO Europe/Rome
    1405, // AHQ America/Chicago
    2901, // AHS America/Tegucigalpa
    166, // AHU Africa/Ceuta
    std::numeric_limits<uint16_t>::max(), // AHY
    4906, // AHZ Europe/Paris
    1547, // AIA America/Denver
    5638, // AIC Pacific/Majuro
    1858, // AID America/Indiana/Knox
    5748, // AIE Pacific/Port_Moresby
    2759, // AIF America/Sao_Paulo
    90, // AIG Africa/Banjul
    3450, // AIH Asia/Jayapura
    228, // AII Africa/Djibouti
    2350, // AIK America/New_York
    2440, // AIL America/Panama
    5638, // AIM Pacific/Majuro
    749, // AIN America/Anchorage
    1405, // AIO America/Chicago
    1474, // AIR America/Cuiaba
    std::numeric_limits<uint16_t>::max(), // AIS
    5769, // AIT Pacific/Rarotonga
    5769, // AIU Pacific/Rarotonga
    1405, // AIV America/Chicago
    2350, // AIY America/New_York
    1405, // AIZ America/Chicago
    4906, // AJA Europe/Paris
    3788, // AJF Asia/Riyadh
    4686, // AJI Europe/Istanbul
    621, // AJJ Africa/Nouakchott
    3927, // AJK Asia/Tehran
    3547, // AJL Asia/Kolkata
    5270, // AJN Indian/Comoro
    2054, // AJO America/Los_Angeles
    5064, // AJR Europe/Stockholm
    2157, // AJS America/Mazatlan
    2074, // AJU America/Maceio
    607, // AJY Africa/Niamey
    3840, // AKA Asia/Shanghai
    736, // AKB America/Adak
    2350, // AKC America/New_York
    3547, // AKD Asia/Kolkata
    410, // AKE Africa/Libreville
    692, // AKF Africa/Tripoli
    749, // AKI America/Anchorage
    3952, // AKJ Asia/Tokyo
    749, // AKK America/Anchorage
    5372, // AKL Pacific/Auckland
    591, // AKM Africa/Ndjamena
    749, // AKN America/Anchorage
    1547, // AKO America/Denver
    749, // AKP America/Anchorage
    3450, // AKQ Asia/Jayapura
    397, // AKR Africa/Lagos
    5551, // AKS Pacific/Guadalcanal
    3991, // AKU Asia/Urumqi
    1920, // AKV America/Iqaluit
    3927, // AKW Asia/Tehran
    3169, // AKX Asia/Aqtobe
    4062, // AKY Asia/Yangon
    3123, // ALA Asia/Almaty
    2350, // ALB America/New_York
    4823, // ALC Europe/Madrid
    2041, // ALD America/Lima
    1405, // ALE America/Chicago
    4894, // ALF Europe/Oslo
    47, // ALG Africa/Algiers
    4409, // ALH Australia/Perth
    1405, // ALI America/Chicago
    720, // ALJ Africa/Windhoek
    4962, // ALL Europe/Rome
    1547, // ALM America/Denver
    1405, // ALN America/Chicago
    1405, // ALO America/Chicago
    3333, // ALP Asia/Damascus
    2759, // ALQ America/Sao_Paulo
    5372, // ALR Pacific/Auckland
    1547, // ALS America/Denver
    543, // ALU Africa/Mogadishu
    4823, // ALV Europe/Madrid
    2054, // ALW America/Los_Angeles
    1405, // ALX America/Chicago
    153, // ALY Africa/Cairo
    749, // ALZ America/Anchorage
    1405, // AMA America/Chicago
    5233, // AMB Indian/Antananarivo
    591, // AMC Africa/Ndjamena
    3547, // AMD Asia/Kolkata
    28, // AMH Africa/Addis_Ababa
    3620, // AMI Asia/Makassar
    1547, // AMK America/Denver
    3135, // AMM Asia/Amman
    1562, // AMN America/Detroit
    591, // AMO Africa/Ndjamena
    5233, // AMP Indian/Antananarivo
    3450, // AMQ Asia/Jayapura
    4442, // AMS Europe/Amsterdam
    4880, // AMV Europe/Moscow
    1405, // AMW America/Chicago
    5233, // AMY Indian/Antananarivo
    5372, // AMZ Pacific/Auckland
    1405, // ANB America/Chicago
    749, // ANC America/Anchorage
    2350, // AND America/New_York
    4906, // ANE Europe/Paris
    2720, // ANF America/Santiago
    4906, // ANG Europe/Paris
    749, // ANI America/Anchorage
    134, // ANJ Africa/Brazzaville
    440, // ANL Africa/Luanda
    5233, // ANM Indian/Antananarivo
    2207, // ANN America/Metlakatla
    500, // ANO Africa/Maputo
    2350, // ANP America/New_York
    1858, // ANQ America/Indiana/Knox
    4538, // ANR Europe/Brussels
    2041, // ANS America/Lima
    784, // ANU America/Araguaina
    749, // ANV America/Anchorage
    1405, // ANW America/Chicago
    4894, // ANX Europe/Oslo
    1405, // ANY America/Chicago
    591, // AOD Africa/Ndjamena
    4686, // AOE Europe/Istanbul
    3840, // AOG Asia/Shanghai
    2350, // AOH America/New_York
    4962, // AOI Europe/Rome
    3952, // AOJ Asia/Tokyo
    4476, // AOK Europe/Athens
    861, // AOL America/Argentina/Cordoba
    3646, // AOM Asia/Muscat
    2350, // AOO America/New_York
    2041, // AOP America/Lima
    3577, // AOR Asia/Kuala_Lumpur
    749, // AOS America/Anchorage
    4962, // AOT Europe/Rome
    4017, // AOU Asia/Vientiane
    1547, // APA America/Denver
    2026, // APB America/La_Paz
    2054, // APC America/Los_Angeles
    2350, // APF America/New_York
    5802, // APK Pacific/Tahiti
    500, // APL Africa/Maputo
    1562, // APN America/Detroit
    1271, // APO America/Bogota
    2074, // APQ America/Maceio
    2759, // APS America/Sao_Paulo
    1405, // APT America/Chicago
    2759, // APU America/Sao_Paulo
    2054, // APV America/Los_Angeles
    5359, // APW Pacific/Apia
    2759, // APX America/Sao_Paulo
    1669, // APY America/Fortaleza
    971, // APZ America/Argentina/Salta
    2759, // AQA America/Sao_Paulo
    1775, // AQB America/Guatemala
    2777, // AQC America/Sitka
    3840, // AQG Asia/Shanghai
    3788, // AQI Asia/Riyadh
    153, // AQJ Africa/Cairo
    2555, // AQM America/Porto_Velho
    1405, // AQO America/Chicago
    2041, // AQP America/Lima
    2350, // AQW America/New_York
    749, // AQY America/Anchorage
    1405, // ARA America/Chicago
    1562, // ARB America/Detroit
    749, // ARC America/Anchorage
    3620, // ARD Asia/Makassar
    2575, // ARE America/Puerto_Rico
    1405, // ARG America/Chicago
    4880, // ARH Europe/Moscow
    2041, // ARI America/Lima
    3450, // ARJ Asia/Jayapura
    207, // ARK Africa/Dar_es_Salaam
    639, // ARL Africa/Ouagadougou
    4425, // ARM Australia/Sydney
    5064, // ARN Europe/Stockholm
    1358, // ARQ America/Caracas
    833, // ARR America/Argentina/Catamarca
    2350, // ART America/New_York
    2759, // ARU America/Sao_Paulo
    1405, // ARV America/Chicago
    4554, // ARW Europe/Bucharest
    4389, // ARY Australia/Melbourne
    440, // ARZ Africa/Luanda
    62, // ASA Africa/Asmara
    3181, // ASB Asia/Ashgabat
    2026, // ASC America/La_Paz
    2335, // ASD America/Nassau
    1547, // ASE America/Denver
    4459, // ASF Europe/Astrakhan
    5372, // ASG Pacific/Auckland
    2350, // ASH America/New_York
    3952, // ASJ Asia/Tokyo
    0, // ASK Africa/Abidjan
    1405, // ASL America/Chicago
    62, // ASM Africa/Asmara
    1405, // ASN America/Chicago
    28, // ASO Africa/Addis_Ababa
    4339, // ASP Australia/Darwin
    2054, // ASQ America/Los_Angeles
    4686, // ASR Europe/Istanbul
    2054, // AST America/Los_Angeles
    1115, // ASU America/Asuncion
    576, // ASV Africa/Nairobi
    153, // ASW Africa/Cairo
    1405, // ASX America/Chicago
    1405, // ASY America/Chicago
    2041, // ATA America/Lima
    367, // ATB Africa/Kigali
    2335, // ATC America/Nassau
    5551, // ATD Pacific/Guadalcanal
    1405, // ATE America/Chicago
    1793, // ATF America/Guyana
    2041, // ATG America/Lima
    4476, // ATH Europe/Athens
    2297, // ATI America/Montevideo
    5233, // ATJ Indian/Antananarivo
    749, // ATK America/Anchorage
    2350, // ATL America/New_York
    2703, // ATM America/Santarem
    5748, // ATN Pacific/Port_Moresby
    2350, // ATO America/New_York
    5748, // ATP Pacific/Port_Moresby
    3547, // ATQ Asia/Kolkata
    621, // ATR Africa/Nouakchott
    1547, // ATS America/Denver
    2367, // ATT America/Nome
    736, // ATU America/Adak
    591, // ATV Africa/Ndjamena
    1405, // ATW America/Chicago
    3123, // ATX Asia/Almaty
    1405, // ATY America/Chicago
    153, // ATZ Africa/Cairo
    1101, // AUA America/Aruba
    1669, // AUB America/Fortaleza
    1358, // AUC America/Caracas
    153, // AUE Africa/Cairo
    4906, // AUF Europe/Paris
    2350, // AUG America/New_York
    3358, // AUH Asia/Dubai
    2367, // AUK America/Nome
    5638, // AUL Pacific/Majuro
    1405, // AUM America/Chicago
    2054, // AUN America/Los_Angeles
    1405, // AUO America/Chicago
    5748, // AUP Pacific/Port_Moresby
    5653, // AUQ Pacific/Marquesas
    4906, // AUR Europe/Paris
    1405, // AUS America/Chicago
    4281, // AUU Australia/Brisbane
    1405, // AUW America/Chicago
    784, // AUX America/Araguaina
    5455, // AUY Pacific/Efate
    1405, // AUZ America/Chicago
    3840, // AVA Asia/Shanghai
    1824, // AVI America/Havana
    3974, // AVK Asia/Ulaanbaatar
    2350, // AVL America/New_York
    4906, // AVN Europe/Paris
    2350, // AVO America/New_York
    2350, // AVP America/New_York
    5551, // AVU Pacific/Guadalcanal
    4389, // AVV Australia/Melbourne
    2494, // AVW America/Phoenix
    2054, // AVX America/Los_Angeles
    28, // AWA Africa/Addis_Ababa
    5748, // AWB Pacific/Port_Moresby
    5455, // AWD Pacific/Efate
    std::numeric_limits<uint16_t>::max(), // AWK
    1405, // AWM America/Chicago
    2054, // AWO America/Los_Angeles
    3927, // AWZ Asia/Tehran
    767, // AXA America/Anguilla
    2971, // AXB America/Toronto
    4281, // AXC Australia/Brisbane
    4476, // AXD Europe/Athens
    2759, // AXE America/Sao_Paulo
    3840, // AXF Asia/Shanghai
    1405, // AXG America/Chicago
    1405, // AXH America/Chicago
    3952, // AXJ Asia/Tokyo
    3113, // AXK Asia/Aden
    1271, // AXM America/Bogota
    1405, // AXN America/Chicago
    1824, // AXP America/Havana
    2350, // AXQ America/New_York
    1405, // AXS America/Chicago
    3952, // AXT Asia/Tokyo
    28, // AXU Africa/Addis_Ababa
    2350, // AXV America/New_York
    1271, // AYA America/Bogota
    3773, // AYK Asia/Qyzylorda
    3840, // AYN Asia/Shanghai
    1115, // AYO America/Asuncion
    2041, // AYP America/Lima
    4339, // AYQ Australia/Darwin
    4281, // AYR Australia/Brisbane
    2350, // AYS America/New_York
    4686, // AYT Europe/Istanbul
    5748, // AYU Pacific/Port_Moresby
    3450, // AYW Asia/Jayapura
    2350, // AYZ America/New_York
    2494, // AZA America/Phoenix
    1547, // AZC America/Denver
    3927, // AZD Asia/Tehran
    3358, // AZI Asia/Dubai
    3900, // AZN Asia/Tashkent
    1562, // AZO America/Detroit
    47, // AZR Africa/Algiers
    2737, // AZS America/Santo_Domingo
    440, // AZZ Africa/Luanda
    4906, // BAE Europe/Paris
    2350, // BAF America/New_York
    3634, // BAG Asia/Manila
    3220, // BAH Asia/Bahrain
    1439, // BAI America/Costa_Rica
    2054, // BAM America/Los_Angeles
    381, // BAN Africa/Kinshasa
    1271, // BAQ America/Bogota
    3840, // BAR Asia/Shanghai
    5389, // BAS Pacific/Bougainville
    2759, // BAT America/Sao_Paulo
    2759, // BAU America/Sao_Paulo
    3840, // BAV Asia/Shanghai
    3243, // BAX Asia/Barnaul
    4554, // BAY Europe/Bucharest
    2105, // BAZ America/Manaus
    2720, // BBA America/Santiago
    1405, // BBB America/Chicago
    1405, // BBC America/Chicago
    1405, // BBD America/Chicago
    5817, // BBG Pacific/Tarawa
    4506, // BBH Europe/Berlin
    3547, // BBI Asia/Kolkata
    720, // BBK Africa/Windhoek
    4281, // BBL Australia/Brisbane
    3716, // BBM Asia/Phnom_Penh
    3595, // BBN Asia/Kuwait
    543, // BBO Africa/Mogadishu
    4791, // BBP Europe/London
    784, // BBQ America/Araguaina
    1756, // BBR America/Guadeloupe
    4791, // BBS Europe/London
    90, // BBT Africa/Banjul
    4554, // BBU Europe/Bucharest
    0, // BBV Africa/Abidjan
    1405, // BBW America/Chicago
    2350, // BBX America/New_York
    90, // BBY Africa/Banjul
    472, // BBZ Africa/Lusaka
    1824, // BCA America/Havana
    2350, // BCB America/New_York
    749, // BCC America/Anchorage
    3634, // BCD Asia/Manila
    1547, // BCE America/Denver
    90, // BCF Africa/Banjul
    3358, // BCH Asia/Dubai
    4281, // BCI Australia/Brisbane
    1405, // BCK America/Chicago
    1439, // BCL America/Costa_Rica
    4554, // BCM Europe/Bucharest
    4823, // BCN Europe/Madrid
    28, // BCO Africa/Addis_Ababa
    692, // BCQ Africa/Tripoli
    4490, // BCR Europe/Belgrade
    1405, // BCS America/Chicago
    2350, // BCT America/New_York
    397, // BCU Africa/Lagos
    1217, // BCV America/Belize
    500, // BCW Africa/Maputo
    4122, // BDA Atlantic/Bermuda
    4281, // BDB Australia/Brisbane
    1669, // BDC America/Fortaleza
    4281, // BDD Australia/Brisbane
    1405, // BDE America/Chicago
    1547, // BDG America/Denver
    3927, // BDH Asia/Tehran
    std::numeric_limits<uint16_t>::max(), // BDI
    3620, // BDJ Asia/Makassar
    0, // BDK Africa/Abidjan
    2350, // BDL America/New_York
    2054, // BDN America/Los_Angeles
    3450, // BDO Asia/Jayapura
    3518, // BDP Asia/Kathmandu
    3547, // BDQ Asia/Kolkata
    2350, // BDR America/New_York
    4962, // BDS Europe/Rome
    381, // BDT Africa/Kinshasa
    4894, // BDU Europe/Oslo
    454, // BDV Africa/Lubumbashi
    1547, // BDX America/Denver
    2054, // BDY America/Los_Angeles
    4791, // BEB Europe/London
    1405, // BEC America/Chicago
    2350, // BED America/New_York
    2089, // BEF America/Managua
    4490, // BEG Europe/Belgrade
    1562, // BEH America/Detroit
    28, // BEI Africa/Addis_Ababa
    3620, // BEJ Asia/Makassar
    3547, // BEK Asia/Kolkata
    1203, // BEL America/Belem
    90, // BEM Africa/Banjul
    692, // BEN Africa/Tripoli
    4425, // BEO Australia/Sydney
    3547, // BEP Asia/Kolkata
    4506, // BER Europe/Berlin
    4906, // BES Europe/Paris
    749, // BET America/Anchorage
    4281, // BEU Australia/Brisbane
    3464, // BEV Asia/Jerusalem
    500, // BEW Africa/Maputo
    3256, // BEY Asia/Beirut
    std::numeric_limits<uint16_t>::max(), // BEZ
    2350, // BFD America/New_York
    1547, // BFF America/Denver
    1547, // BFG America/Denver
    2759, // BFH America/Sao_Paulo
    2054, // BFI America/Los_Angeles
    3840, // BFJ Asia/Shanghai
    1405, // BFK America/Chicago
    2054, // BFL America/Los_Angeles
    1405, // BFM America/Chicago
    320, // BFN Africa/Johannesburg
    306, // BFO Africa/Harare
    2350, // BFP America/New_York
    2440, // BFQ America/Panama
    1858, // BFR America/Indiana/Knox
    4791, // BFS Europe/London
    2350, // BFT America/New_York
    3840, // BFU Asia/Shanghai
    3243, // BFV Asia/Barnaul
    47, // BFW Africa/Algiers
    244, // BFX Africa/Douala
    1271, // BGA America/Bogota
    410, // BGB Africa/Libreville
    4760, // BGC Europe/Lisbon
    1405, // BGD America/Chicago
    2350, // BGE America/New_York
    90, // BGF Africa/Banjul
    4686, // BGG Europe/Istanbul
    621, // BGH Africa/Nouakchott
    1186, // BGI America/Barbados
    1217, // BGK America/Belize
    2350, // BGM America/New_York
    3869, // BGN Asia/Srednekolymsk
    4894, // BGO Europe/Oslo
    749, // BGQ America/Anchorage
    2350, // BGR America/New_York
    2494, // BGT America/Phoenix
    90, // BGU Africa/Banjul
    2759, // BGV America/Sao_Paulo
    3207, // BGW Asia/Baghdad
    2759, // BGX America/Sao_Paulo
    4962, // BGY Europe/Rome
    4760, // BGZ Europe/Lisbon
    1793, // BHA America/Guyana
    2350, // BHB America/New_York
    4791, // BHD Europe/London
    5372, // BHE Pacific/Auckland
    2901, // BHG America/Tegucigalpa
    3788, // BHH Asia/Riyadh
    802, // BHI America/Argentina/Buenos_Aires
    3547, // BHJ Asia/Kolkata
    3814, // BHK Asia/Samarkand
    2955, // BHL America/Tijuana
    1405, // BHM America/Chicago
    3113, // BHN Asia/Aden
    3547, // BHO Asia/Kolkata
    3518, // BHP Asia/Kathmandu
    4300, // BHQ Australia/Broken_Hill
    3518, // BHR Asia/Kathmandu
    4425, // BHS Australia/Sydney
    3547, // BHU Asia/Kolkata
    3505, // BHV Asia/Karachi
    4791, // BHX Europe/London
    3840, // BHY Asia/Shanghai
    4906, // BIA Europe/Paris
    543, // BIB Africa/Mogadishu
    2350, // BID America/New_York
    5638, // BII Pacific/Majuro
    3450, // BIK Asia/Jayapura
    1547, // BIL America/Denver
    2335, // BIM America/Nassau
    3479, // BIN Asia/Kabul
    4823, // BIO Europe/Madrid
    4906, // BIQ Europe/Paris
    std::numeric_limits<uint16_t>::max(), // BIR
    std::numeric_limits<uint16_t>::max(), // BIS
    4207, // BIU Atlantic/Reykjavik
    90, // BIV Africa/Banjul
    320, // BIY Africa/Johannesburg
    47, // BJA Africa/Algiers
    3927, // BJB Asia/Tehran
    1547, // BJC America/Denver
    4207, // BJD Atlantic/Reykjavik
    4894, // BJF Europe/Oslo
    3620, // BJG Asia/Makassar
    3518, // BJH Asia/Kathmandu
    1405, // BJI America/Chicago
    2350, // BJJ America/New_York
    3450, // BJK Asia/Jayapura
    90, // BJL Africa/Banjul
    454, // BJM Africa/Lubumbashi
    std::numeric_limits<uint16_t>::max(), // BJO
    2759, // BJP America/Sao_Paulo
    28, // BJR Africa/Addis_Ababa
    std::numeric_limits<uint16_t>::max(), // BJT
    3518, // BJU Asia/Kathmandu
    4686, // BJV Europe/Istanbul
    3620, // BJW Asia/Makassar
    2226, // BJX America/Mexico_City
    4823, // BJZ Europe/Madrid
    4880, // BKA Europe/Moscow
    3547, // BKB Asia/Kolkata
    749, // BKC America/Anchorage
    2054, // BKE America/Los_Angeles
    749, // BKF America/Anchorage
    1405, // BKG America/Chicago
    5584, // BKH Pacific/Honolulu
    std::numeric_limits<uint16_t>::max(), // BKI
    179, // BKJ Africa/Conakry
    3243, // BKK Asia/Barnaul
    2350, // BKL America/New_York
    3595, // BKM Asia/Kuwait
    3181, // BKN Asia/Ashgabat
    76, // BKO Africa/Bamako
    4281, // BKQ Australia/Brisbane
    591, // BKR Africa/Ndjamena
    3450, // BKS Asia/Jayapura
    2350, // BKV America/New_York
    2350, // BKW America/New_York
    1405, // BKX America/Chicago
    454, // BKY Africa/Lubumbashi
    207, // BKZ Africa/Dar_es_Salaam
    1358, // BLA America/Caracas
    2440, // BLB America/Panama
    244, // BLC Africa/Douala
    2054, // BLD America/Los_Angeles
    5064, // BLE Europe/Stockholm
    2350, // BLF America/New_York
    3595, // BLG Asia/Kuwait
    2054, // BLH America/Los_Angeles
    47, // BLJ Africa/Algiers
    4791, // BLK Europe/London
    4603, // BLL Europe/Copenhagen
    2350, // BLM America/New_York
    4389, // BLN Australia/Melbourne
    4207, // BLO Atlantic/Reykjavik
    4962, // BLQ Europe/Rome
    3547, // BLR Asia/Kolkata
    4281, // BLT Australia/Brisbane
    2054, // BLU America/Los_Angeles
    4962, // BLX Europe/Rome
    4621, // BLY Europe/Dublin
    118, // BLZ Africa/Blantyre
    5064, // BMA Europe/Stockholm
    381, // BMB Africa/Kinshasa
    1547, // BMC America/Denver
    5233, // BMD Indian/Antananarivo
    std::numeric_limits<uint16_t>::max(), // BME
    90, // BMF Africa/Banjul
    1858, // BMG America/Indiana/Knox
    1405, // BMI America/Chicago
    1793, // BMJ America/Guyana
    4506, // BMK Europe/Berlin
    2350, // BML America/New_York
    486, // BMM Africa/Malabo
    4062, // BMO Asia/Yangon
    3547, // BMP Asia/Kolkata
    576, // BMQ Africa/Nairobi
    4506, // BMR Europe/Berlin
    1149, // BMS America/Bahia
    1405, // BMT America/Chicago
    3620, // BMU Asia/Makassar
    3410, // BMV Asia/Ho_Chi_Minh
    47, // BMW Africa/Algiers
    5699, // BMY Pacific/Noumea
    1405, // BNA America/Chicago
    381, // BNB Africa/Kinshasa
    454, // BNC Africa/Lubumbashi
    3927, // BND Asia/Tehran
    4281, // BNE Australia/Brisbane
    2054, // BNG America/Los_Angeles
    397, // BNI Africa/Lagos
    4506, // BNJ Europe/Berlin
    4425, // BNK Australia/Sydney
    2350, // BNL America/New_York
    4894, // BNN Europe/Oslo
    2054, // BNO America/Los_Angeles
    3505, // BNP Asia/Karachi
    639, // BNR Africa/Ouagadougou
    1358, // BNS America/Caracas
    2759, // BNU America/Sao_Paulo
    1405, // BNW America/Chicago
    4988, // BNX Europe/Sarajevo
    std::numeric_limits<uint16_t>::max(), // BNY
    381, // BOA Africa/Kinshasa
    5802, // BOB Pacific/Tahiti
    2440, // BOC America/Panama
    4906, // BOD Europe/Paris
    134, // BOE Africa/Brazzaville
    1271, // BOG America/Bogota
    4791, // BOH Europe/London
    1286, // BOI America/Boise
    5051, // BOJ Europe/Sofia
    2054, // BOK America/Los_Angeles
    3547, // BOM Asia/Kolkata
    2007, // BON America/Kralendijk
    4894, // BOO Europe/Oslo
    90, // BOP Africa/Banjul
    2350, // BOS America/New_York
    3450, // BOT Asia/Jayapura
    4906, // BOU Europe/Paris
    2350, // BOW America/New_York
    4339, // BOX Australia/Darwin
    639, // BOY Africa/Ouagadougou
    90, // BOZ Africa/Banjul
    244, // BPC Africa/Douala
    3840, // BPE Asia/Shanghai
    5551, // BPF Pacific/Guadalcanal
    1474, // BPG America/Cuiaba
    3634, // BPH Asia/Manila
    1547, // BPI America/Denver
    5748, // BPK Pacific/Port_Moresby
    3991, // BPL Asia/Urumqi
    3547, // BPM Asia/Kolkata
    3620, // BPN Asia/Makassar
    3634, // BPR Asia/Manila
    1149, // BPS America/Bahia
    1405, // BPT America/Chicago
    3840, // BPX Asia/Shanghai
    5233, // BPY Indian/Antananarivo
    3634, // BQA Asia/Manila
    4409, // BQB Australia/Perth
    104, // BQE Africa/Bissau
    4032, // BQG Asia/Vladivostok
    4791, // BQH Europe/London
    4032, // BQJ Asia/Vladivostok
    2350, // BQK America/New_York
    4281, // BQL Australia/Brisbane
    2575, // BQN America/Puerto_Rico
    0, // BQO Africa/Abidjan
    1149, // BQQ America/Bahia
    2350, // BQR America/New_York
    3840, // BQS Asia/Shanghai
    4867, // BQT Europe/Minsk
    2882, // BQU America/St_Vincent
    4409, // BQW Australia/Perth
    1149, // BRA America/Bahia
    1669, // BRB America/Fortaleza
    971, // BRC America/Argentina/Salta
    1405, // BRD America/Chicago
    4506, // BRE Europe/Berlin
    4962, // BRI Europe/Rome
    4425, // BRK Australia/Sydney
    1405, // BRL America/Chicago
    1358, // BRM America/Caracas
    5219, // BRN Europe/Zurich
    1405, // BRO America/Chicago
    4936, // BRQ Europe/Prague
    4791, // BRR Europe/London
    4791, // BRS Europe/London
    4339, // BRT Australia/Darwin
    4538, // BRU Europe/Brussels
    4554, // BRV Europe/Bucharest
    749, // BRW America/Anchorage
    2737, // BRX America/Santo_Domingo
    2350, // BRY America/New_York
    543, // BSA Africa/Mogadishu
    2759, // BSB America/Sao_Paulo
    1271, // BSC America/Bogota
    3840, // BSD Asia/Shanghai
    3732, // BSE Asia/Pontianak
    486, // BSG Africa/Malabo
    4389, // BSJ Australia/Melbourne
    47, // BSK Africa/Algiers
    4906, // EAP Europe/Paris
    90, // BSN Africa/Banjul
    3634, // BSO Asia/Manila
    3450, // BSP Asia/Jayapura
    2494, // BSQ America/Phoenix
    3207, // BSR Asia/Baghdad
    1669, // BSS America/Fortaleza
    3479, // BST Asia/Kabul
    381, // BSU Africa/Kinshasa
    749, // BSW America/Anchorage
    4062, // BSX Asia/Yangon
    543, // BSY Africa/Mogadishu
    244, // BTA Africa/Douala
    134, // BTB Africa/Brazzaville
    274, // BTE Africa/Freetown
    1547, // BTF America/Denver
    90, // BTG Africa/Banjul
    3854, // BTH Asia/Singapore
    749, // BTI America/Anchorage
    3450, // BTJ Asia/Jayapura
    3437, // BTK Asia/Irkutsk
    1562, // BTL America/Detroit
    1547, // BTM America/Denver
    2350, // BTN America/New_York
    2475, // BTO America/Paramaribo
    2350, // BTP America/New_York
    367, // BTQ Africa/Kigali
    1405, // BTR America/Chicago
    4520, // BTS Europe/Bratislava
    749, // BTT America/Anchorage
    3595, // BTU Asia/Kuwait
    2350, // BTV America/New_York
    3620, // BTW Asia/Makassar
    2054, // BTY America/Los_Angeles
    5389, // BUA Pacific/Bougainville
    4281, // BUC Australia/Brisbane
    4571, // BUD Europe/Budapest
    2350, // BUF America/New_York
    440, // BUG Africa/Luanda
    3450, // BUI Asia/Jayapura
    47, // BUJ Africa/Algiers
    3113, // BUK Asia/Aden
    5748, // BUL Pacific/Port_Moresby
    1271, // BUN America/Bogota
    543, // BUO Africa/Mogadishu
    3547, // BUP Asia/Kolkata
    306, // BUQ Africa/Harare
    2054, // BUR America/Los_Angeles
    3914, // BUS Asia/Tbilisi
    3939, // BUT Asia/Thimphu
    1405, // BUU America/Chicago
    861, // BUV America/Argentina/Cordoba
    3620, // BUW Asia/Makassar
    454, // BUX Africa/Lubumbashi
    4409, // BUY Australia/Perth
    3927, // BUZ Asia/Tehran
    4906, // BVA Europe/Paris
    1253, // BVB America/Boa_Vista
    4155, // BVC Atlantic/Cape_Verde
    4906, // BVE Europe/Paris
    4894, // BVG Europe/Oslo
    2555, // BVH America/Porto_Velho
    4281, // BVI Australia/Brisbane
    2026, // BVK America/La_Paz
    2026, // BVL America/La_Paz
    1405, // BVN America/Chicago
    1405, // BVO America/Chicago
    4155, // BVR Atlantic/Cape_Verde
    749, // BVU America/Anchorage
    4003, // BVV Asia/Ust-Nera
    4281, // BVW Australia/Brisbane
    1405, // BVX America/Chicago
    2350, // BVY America/New_York
    3518, // BWA Asia/Kathmandu
    4409, // BWB Australia/Perth
    2054, // BWC America/Los_Angeles
    1405, // BWD America/Chicago
    4506, // BWE Europe/Berlin
    4791, // BWF Europe/London
    1405, // BWG America/Chicago
    3577, // BWH Asia/Kuala_Lumpur
    2350, // BWI America/New_York
    5187, // BWK Europe/Zagreb
    1405, // BWL America/Chicago
    1547, // BWM America/Denver
    std::numeric_limits<uint16_t>::max(), // BWN
    5004, // BWO Europe/Saratov
    4425, // BWQ Australia/Sydney
    3003, // BWS America/Vancouver
    4372, // BWT Australia/Hobart
    4425, // BWU Australia/Sydney
    1824, // BWW America/Havana
    3450, // BWX Asia/Jayapura
    3450, // BXB Asia/Jayapura
    3450, // BXD Asia/Jayapura
    194, // BXE Africa/Dakar
    4389, // BXG Australia/Melbourne
    3123, // BXH Asia/Almaty
    0, // BXI Africa/Abidjan
    3123, // BXJ Asia/Almaty
    2494, // BXK America/Phoenix
    3450, // BXM Asia/Jayapura
    4686, // BXN Europe/Istanbul
    5219, // BXO Europe/Zurich
    5173, // BXP Europe/Warsaw
    3927, // BXR Asia/Tehran
    2054, // BXS America/Los_Angeles
    3620, // BXT Asia/Makassar
    3634, // BXU Asia/Manila
    4207, // BXV Atlantic/Reykjavik
    3450, // BXW Asia/Jayapura
    28, // BXX Africa/Addis_Ababa
    3358, // BYB Asia/Dubai
    2026, // BYC America/La_Paz
    3113, // BYD Asia/Aden
    4906, // BYF Europe/Paris
    1405, // BYH America/Chicago
    1286, // BYI America/Boise
    4760, // BYJ Europe/Lisbon
    0, // BYK Africa/Abidjan
    1824, // BYM America/Havana
    3974, // BYN Asia/Ulaanbaatar
    1322, // BYO America/Campo_Grande
    4409, // BYP Australia/Perth
    3620, // BYQ Asia/Makassar
    4603, // BYR Europe/Copenhagen
    4621, // BYT Europe/Dublin
    2089, // BZA America/Managua
    500, // BZB Africa/Maputo
    2759, // BZC America/Sao_Paulo
    4425, // BZD Australia/Sydney
    1217, // BZE America/Belize
    2054, // BZF America/Los_Angeles
    5173, // BZG Europe/Warsaw
    4880, // BZK Europe/Moscow
    3347, // BZL Asia/Dhaka
    1547, // BZN America/Denver
    4962, // BZO Europe/Rome
    4906, // BZR Europe/Paris
    454, // BZU Africa/Lubumbashi
    134, // BZV Africa/Brazzaville
    4587, // BZY Europe/Chisinau
    2901, // CAA America/Tegucigalpa
    440, // CAB Africa/Luanda
    2759, // CAC America/Sao_Paulo
    1562, // CAD America/Detroit
    2350, // CAE America/New_York
    2105, // CAF America/Manaus
    4962, // CAG Europe/Rome
    3410, // CAH Asia/Ho_Chi_Minh
    153, // CAI Africa/Cairo
    1358, // CAJ America/Caracas
    2350, // CAK America/New_York
    4791, // CAL Europe/London
    2026, // CAM America/La_Paz
    3840, // CAN Asia/Shanghai
    1547, // CAO America/Denver
    2510, // CAP America/Port-au-Prince
    1271, // CAQ America/Bogota
    2350, // CAR America/New_York
    166, // CAS Africa/Ceuta
    4760, // CAT Europe/Lisbon
    2637, // CAU America/Recife
    440, // CAV Africa/Luanda
    2759, // CAW America/Sao_Paulo
    4791, // CAX Europe/London
    1374, // CAY America/Cayenne
    4425, // CAZ Australia/Sydney
    228, // CBA Africa/Djibouti
    2026, // CBB America/La_Paz
    2350, // CBE America/New_York
    1405, // CBF America/Chicago
    4791, // CBG Europe/London
    47, // CBH Africa/Algiers
    2737, // CBJ America/Santo_Domingo
    1405, // CBK America/Chicago
    1358, // CBL America/Caracas
    3450, // CBN Asia/Jayapura
    3634, // CBO Asia/Manila
    4760, // CBP Europe/Lisbon
    397, // CBQ Africa/Lagos
    4425, // CBR Australia/Sydney
    1358, // CBS America/Caracas
    440, // CBT Africa/Luanda
    4506, // CBU Europe/Berlin
    1775, // CBV America/Guatemala
    2759, // CBW America/Sao_Paulo
    4425, // CBX Australia/Sydney
    2026, // CCA America/La_Paz
    2054, // CCB America/Los_Angeles
    1824, // CCC America/Havana
    4906, // CCF Europe/Paris
    2720, // CCH America/Santiago
    2759, // CCI America/Sao_Paulo
    3547, // CCJ Asia/Kolkata
    std::numeric_limits<uint16_t>::max(), // CCK
    4281, // CCL Australia/Brisbane
    2759, // CCM America/Sao_Paulo
    3479, // CCN Asia/Kabul
    1271, // CCO America/Bogota
    2720, // CCP America/Santiago
    2054, // CCR America/Los_Angeles
    1358, // CCS America/Caracas
    971, // CCT America/Argentina/Salta
    3547, // CCU Asia/Kolkata
    5455, // CCV Pacific/Efate
    4262, // CCW Australia/Adelaide
    1474, // CCX America/Cuiaba
    1405, // CCY America/Chicago
    2335, // CCZ America/Nassau
    2367, // CDB America/Nome
    1547, // CDC America/Denver
    2901, // CDD America/Tegucigalpa
    3840, // CDE Asia/Shanghai
    4962, // CDF Europe/Rome
    4906, // CDG Europe/Paris
    1405, // CDH America/Chicago
    2759, // CDI America/Sao_Paulo
    1203, // CDJ America/Belem
    2350, // CDK America/New_York
    2350, // CDN America/New_York
    3547, // CDP Asia/Kolkata
    1547, // CDR America/Denver
    1405, // CDS America/Chicago
    4823, // CDT Europe/Madrid
    4425, // CDU Australia/Sydney
    749, // CDV America/Anchorage
    2350, // CDW America/New_York
    3634, // CDY Asia/Manila
    1405, // CEA America/Chicago
    3634, // CEB Asia/Manila
    2054, // CEC America/Los_Angeles
    4262, // CED Australia/Adelaide
    4880, // CEE Europe/Moscow
    2350, // CEF America/New_York
    4791, // CEG Europe/London
    472, // CEH Africa/Lusaka
    3243, // CEI Asia/Barnaul
    4735, // CEJ Europe/Kiev
    4074, // CEK Asia/Yekaterinburg
    2335, // CEL America/Nassau
    749, // CEM America/Anchorage
    1839, // CEN America/Hermosillo
    440, // CEO Africa/Luanda
    2026, // CEP America/La_Paz
    4906, // CEQ Europe/Paris
    4906, // CER Europe/Paris
    4425, // CES Australia/Sydney
    4906, // CET Europe/Paris
    2350, // CEU America/New_York
    1858, // CEV America/Indiana/Knox
    1405, // CEW America/Chicago
    1405, // CEY America/Chicago
    1547, // CEZ America/Denver
    2759, // CFB America/Sao_Paulo
    2759, // CFC America/Sao_Paulo
    1405, // CFD America/Chicago
    4906, // CFE Europe/Paris
    440, // CFF Africa/Luanda
    1824, // CFG America/Havana
    4621, // CFN Europe/Dublin
    1474, // CFO America/Cuiaba
    1458, // CFQ America/Creston
    4906, // CFR Europe/Paris
    4425, // CFS Australia/Sydney
    2494, // CFT America/Phoenix
    4476, // CFU Europe/Athens
    1405, // CFV America/Chicago
    2777, // CGA America/Sitka
    1474, // CGB America/Cuiaba
    5748, // CGC Pacific/Port_Moresby
    3840, // CGD Asia/Shanghai
    2350, // CGE America/New_York
    2350, // CGF America/New_York
    2759, // CGH America/Sao_Paulo
    1405, // CGI America/Chicago
    472, // CGJ Africa/Lusaka
    3450, // CGK Asia/Jayapura
    3634, // CGM Asia/Manila
    4506, // CGN Europe/Berlin
    3840, // CGO Asia/Shanghai
    std::numeric_limits<uint16_t>::max(), // CGP
    3840, // CGQ Asia/Shanghai
    1322, // CGR America/Campo_Grande
    2350, // CGS America/New_York
    3634, // CGY Asia/Manila
    2494, // CGZ America/Phoenix
    2350, // CHA America/New_York
    3505, // CHB Asia/Karachi
    5372, // CHC Pacific/Auckland
    2494, // CHD America/Phoenix
    3829, // CHF Asia/Seoul
    3840, // CHG Asia/Shanghai
    2041, // CHH America/Lima
    306, // CHJ Africa/Harare
    1405, // CHK America/Chicago
    1286, // CHL America/Boise
    2041, // CHM America/Lima
    3829, // CHN Asia/Seoul
    2350, // CHO America/New_York
    749, // CHP America/Anchorage
    4476, // CHQ Europe/Athens
    4906, // CHR Europe/Paris
    2350, // CHS America/New_York
    5410, // CHT Pacific/Chatham
    749, // CHU America/Anchorage
    4760, // CHV Europe/Lisbon
    1439, // CHX America/Costa_Rica
    5551, // CHY Pacific/Guadalcanal
    2054, // CHZ America/Los_Angeles
    4962, // CIA Europe/Rome
    2054, // CIC America/Los_Angeles
    1405, // CID America/Chicago
    3840, // CIF Asia/Shanghai
    1547, // CIG America/Denver
    3840, // CIH Asia/Shanghai
    1547, // CII America/Denver
    2684, // CIJ America/Rio_Branco
    749, // CIK America/Anchorage
    2367, // CIL America/Nome
    1271, // CIM America/Bogota
    1405, // CIN America/Chicago
    1115, // CIO America/Asuncion
    472, // CIP Africa/Lusaka
    1775, // CIQ America/Guatemala
    5469, // CIS Pacific/Enderbury
    3123, // CIT Asia/Almaty
    1562, // CIU America/Detroit
    2882, // CIW America/St_Vincent
    2041, // CIX America/Lima
    4962, // CIY Europe/Rome
    2105, // CIZ America/Manaus
    2041, // CJA America/Lima
    3547, // CJB Asia/Kolkata
    2720, // CJC America/Santiago
    4409, // CJF Australia/Perth
    3003, // CJH America/Vancouver
    3829, // CJJ Asia/Seoul
    3505, // CJL Asia/Karachi
    3243, // CJM Asia/Barnaul
    3450, // CJN Asia/Jayapura
    2350, // CJR America/New_York
    2424, // CJS America/Ojinaga
    2226, // CJT America/Mexico_City
    3829, // CJU Asia/Seoul
    1669, // CJZ America/Fortaleza
    2350, // CKB America/New_York
    4735, // CKC Europe/Kiev
    749, // CKD America/Anchorage
    2054, // CKE America/Los_Angeles
    2350, // CKF America/New_York
    3840, // CKG Asia/Shanghai
    3869, // CKH Asia/Srednekolymsk
    4339, // CKI Australia/Darwin
    4880, // CKL Europe/Moscow
    1405, // CKM America/Chicago
    1405, // CKN America/Chicago
    2759, // CKO America/Sao_Paulo
    1203, // CKS America/Belem
    3927, // CKT Asia/Tehran
    749, // CKU America/Anchorage
    1405, // CKV America/Chicago
    4409, // CKW Australia/Perth
    749, // CKX America/Anchorage
    179, // CKY Africa/Conakry
    2350, // CKZ America/New_York
    3347, // CLA Asia/Dhaka
    2054, // CLD America/Los_Angeles
    2350, // CLE America/New_York
    2054, // CLG America/Los_Angeles
    4425, // CLH Australia/Sydney
    1405, // CLI America/Chicago
    4554, // CLJ Europe/Bucharest
    1405, // CLK America/Chicago
    1405, // CLL America/Chicago
    2054, // CLM America/Los_Angeles
    1669, // CLN America/Fortaleza
    1271, // CLO America/Bogota
    749, // CLP America/Anchorage
    2226, // CLQ America/Mexico_City
    2054, // CLR America/Los_Angeles
    2054, // CLS America/Los_Angeles
    1858, // CLU America/Indiana/Knox
    2759, // CLV America/Sao_Paulo
    2350, // CLW America/New_York
    861, // CLX America/Argentina/Cordoba
    4906, // CLY Europe/Paris
    1358, // CLZ America/Caracas
    4281, // CMA Australia/Brisbane
    3320, // CMB Asia/Colombo
    4425, // CMD Australia/Sydney
    2192, // CME America/Merida
    4906, // CMF Europe/Paris
    2026, // CMG America/La_Paz
    2350, // CMH America/New_York
    1405, // CMI America/Chicago
    3888, // CMJ Asia/Taipei
    118, // CMK Africa/Blantyre
    4339, // CML Australia/Darwin
    1775, // CMM America/Guatemala
    166, // CMN Africa/Ceuta
    543, // CMO Africa/Mogadishu
    1203, // CMP America/Belem
    4281, // CMQ Australia/Brisbane
    4906, // CMR Europe/Paris
    543, // CMS Africa/Mogadishu
    5748, // CMU Pacific/Port_Moresby
    5372, // CMV Pacific/Auckland
    1824, // CMW America/Havana
    1562, // CMX America/Detroit
    1405, // CMY America/Chicago
    1839, // CNA America/Hermosillo
    4425, // CNB Australia/Sydney
    4281, // CNC Australia/Brisbane
    4554, // CND Europe/Bucharest
    2759, // CNF America/Sao_Paulo
    2350, // CNH America/New_York
    3840, // CNI Asia/Shanghai
    4281, // CNJ Australia/Brisbane
    1405, // CNK America/Chicago
    4603, // CNL Europe/Copenhagen
    1547, // CNM America/Denver
    2054, // CNO America/Los_Angeles
    1505, // CNP America/Danmarkshavn
    861, // CNQ America/Argentina/Cordoba
    2720, // CNR America/Santiago
    4281, // CNS Australia/Brisbane
    1405, // CNU America/Chicago
    1405, // CNW America/Chicago
    3243, // CNX Asia/Barnaul
    1547, // CNY America/Denver
    440, // CNZ Africa/Luanda
    2054, // COA America/Los_Angeles
    861, // COC America/Argentina/Cordoba
    1547, // COD America/Denver
    2054, // COE America/Los_Angeles
    1271, // COG America/Bogota
    3547, // COH Asia/Kolkata
    2350, // COI America/New_York
    4425, // COJ Australia/Sydney
    3547, // COK Asia/Kolkata
    4791, // COL Europe/London
    1405, // COM America/Chicago
    2350, // CON America/New_York
    658, // COO Africa/Porto-Novo
    2350, // COP America/New_York
    3304, // COQ Asia/Choibalsan
    861, // COR America/Argentina/Cordoba
    1547, // COS America/Denver
    1405, // COT America/Chicago
    1405, // COU America/Chicago
    4760, // COV Europe/Lisbon
    2335, // COX America/Nassau
    4409, // COY Australia/Perth
    2737, // COZ America/Santo_Domingo
    560, // CPA Africa/Monrovia
    2440, // CPB America/Panama
    971, // CPC America/Argentina/Salta
    4262, // CPD Australia/Adelaide
    2192, // CPE America/Merida
    3450, // CPF Asia/Jayapura
    4603, // CPH Europe/Copenhagen
    2350, // CPK America/New_York
    1271, // CPL America/Bogota
    2054, // CPM America/Los_Angeles
    2720, // CPO America/Santiago
    2759, // CPQ America/Sao_Paulo
    1547, // CPR America/Denver
    1405, // CPS America/Chicago
    320, // CPT Africa/Johannesburg
    1669, // CPU America/Fortaleza
    1669, // CPV America/Fortaleza
    2575, // CPX America/Puerto_Rico
    1474, // CQA America/Cuiaba
    1405, // CQB America/Chicago
    3927, // CQD Asia/Tehran
    4906, // CQF Europe/Paris
    4823, // CQM Europe/Madrid
    2350, // CQX America/New_York
    4554, // CRA Europe/Bucharest
    4425, // CRB Australia/Sydney
    1271, // CRC America/Bogota
    833, // CRD America/Argentina/Catamarca
    2350, // CRE America/New_York
    90, // CRF Africa/Banjul
    2350, // CRG America/New_York
    2335, // CRI America/Nassau
    3634, // CRK Asia/Manila
    std::numeric_limits<uint16_t>::max(), // CRL
    3634, // CRM Asia/Manila
    2054, // CRO America/Los_Angeles
    1405, // CRP America/Chicago
    1149, // CRQ America/Bahia
    861, // CRR America/Argentina/Cordoba
    1405, // CRS America/Chicago
    1405, // CRT America/Chicago
    1740, // CRU America/Grenada
    4962, // CRV Europe/Rome
    2350, // CRW America/New_York
    1405, // CRX America/Chicago
    3181, // CRZ Asia/Ashgabat
    4791, // CSA Europe/London
    4554, // CSB Europe/Bucharest
    1439, // CSC America/Costa_Rica
    2350, // CSG America/New_York
    4880, // CSH Europe/Moscow
    4425, // CSI Australia/Sydney
    194, // CSK Africa/Dakar
    2157, // CSL America/Mazatlan
    1405, // CSM America/Chicago
    2054, // CSN America/Los_Angeles
    4506, // CSO Europe/Berlin
    1405, // CSQ America/Chicago
    2759, // CSS America/Sao_Paulo
    2759, // CSU America/Sao_Paulo
    3840, // CSX Asia/Shanghai
    4880, // CSY Europe/Moscow
    4962, // CTA Europe/Rome
    1547, // CTB America/Denver
    833, // CTC America/Argentina/Catamarca
    2440, // CTD America/Panama
    2440, // CTE America/Panama
    1775, // CTF America/Guatemala
    1271, // CTG America/Bogota
    2350, // CTH America/New_York
    440, // CTI Africa/Luanda
    2350, // CTJ America/New_York
    1405, // CTK America/Chicago
    4281, // CTL Australia/Brisbane
    1343, // CTM America/Cancun
    4281, // CTN Australia/Brisbane
    2350, // CTO America/New_York
    2759, // CTQ America/Sao_Paulo
    3952, // CTS Asia/Tokyo
    4906, // CTT Europe/Paris
    3840, // CTU Asia/Shanghai
    2955, // CTV America/Tijuana
    2350, // CTX America/New_York
    2350, // CTY America/New_York
    2350, // CTZ America/New_York
    2157, // CUA America/Mazatlan
    2350, // CUB America/New_York
    1271, // CUC America/Bogota
    4281, // CUD Australia/Brisbane
    1793, // CUE America/Guyana
    4962, // CUF Europe/Rome
    1405, // CUH America/Chicago
    1217, // CUK America/Belize
    2157, // CUL America/Mazatlan
    1358, // CUM America/Caracas
    1343, // CUN America/Cancun
    1271, // CUO America/Bogota
    1358, // CUP America/Caracas
    4281, // CUQ Australia/Brisbane
    1489, // CUR America/Curacao
    1547, // CUS America/Denver
    971, // CUT America/Argentina/Salta
    1421, // CUU America/Chihuahua
    1358, // CUV America/Caracas
    4409, // CUY Australia/Perth
    2041, // CUZ America/Lima
    4262, // CVC Australia/Adelaide
    1271, // CVE America/Bogota
    4906, // CVF Europe/Paris
    2350, // CVG America/New_York
    971, // CVH America/Argentina/Salta
    2226, // CVJ America/Mexico_City
    1405, // CVK America/Chicago
    2279, // CVM America/Monterrey
    1547, // CVN America/Denver
    2054, // CVO America/Los_Angeles
    4409, // CVQ Australia/Perth
    4791, // CVT Europe/London
    4106, // CVU Atlantic/Azores
    1562, // CVX America/Detroit
    1405, // CWA America/Chicago
    2759, // CWB America/Sao_Paulo
    4735, // CWC Europe/Kiev
    1405, // CWF America/Chicago
    1405, // CWI America/Chicago
    3840, // CWJ Asia/Shanghai
    4791, // CWL Europe/London
    2054, // CWS America/Los_Angeles
    4425, // CWT Australia/Sydney
    4425, // CWW Australia/Sydney
    2494, // CWX America/Phoenix
    1358, // CXA America/Caracas
    3347, // CXB Asia/Dhaka
    749, // CXF America/Anchorage
    3003, // CXH America/Vancouver
    5601, // CXI Pacific/Kiritimati
    2759, // CXJ America/Sao_Paulo
    2054, // CXL America/Los_Angeles
    440, // CXM Africa/Luanda
    543, // CXN Africa/Mogadishu
    1405, // CXO America/Chicago
    3450, // CXP Asia/Jayapura
    4409, // CXQ Australia/Perth
    3410, // CXR Asia/Ho_Chi_Minh
    4281, // CXT Australia/Brisbane
    1405, // CXW America/Chicago
    2335, // CXY America/Nassau
    2510, // CYA America/Port-au-Prince
    1390, // CYB America/Cayman
    1217, // CYC America/Belize
    2367, // CYF America/Nome
    4389, // CYG Australia/Melbourne
    3888, // CYI Asia/Taipei
    2901, // CYL America/Tegucigalpa
    2777, // CYM America/Sitka
    1824, // CYO America/Havana
    3634, // CYP Asia/Manila
    2297, // CYR America/Montevideo
    1547, // CYS America/Denver
    749, // CYT America/Anchorage
    3634, // CYU Asia/Manila
    2226, // CYW America/Mexico_City
    3869, // CYX Asia/Srednekolymsk
    3634, // CYZ Asia/Manila
    2192, // CZA America/Merida
    749, // CZC America/Anchorage
    1358, // CZE America/Caracas
    2367, // CZF America/Nome
    2350, // CZG America/New_York
    1217, // CZH America/Belize
    2440, // CZJ America/Panama
    2054, // CZK America/Los_Angeles
    47, // CZL Africa/Algiers
    1343, // CZM America/Cancun
    749, // CZN America/Anchorage
    2684, // CZS America/Rio_Branco
    1271, // CZU America/Bogota
    5173, // CZW Europe/Warsaw
    3840, // CZX Asia/Shanghai
    2350, // DAB America/New_York
    3347, // DAC Asia/Dhaka
    3410, // DAD Asia/Ho_Chi_Minh
    2054, // DAG America/Los_Angeles
    153, // DAK Africa/Cairo
    1405, // DAL America/Chicago
    3333, // DAM Asia/Damascus
    2350, // DAN America/New_York
    207, // DAR Africa/Dar_es_Salaam
    3073, // DAS America/Yellowknife
    3840, // DAT Asia/Shanghai
    5748, // DAU Pacific/Port_Moresby
    2440, // DAV America/Panama
    2350, // DAW America/New_York
    3840, // DAX Asia/Shanghai
    2350, // DAY America/New_York
    3369, // DAZ Asia/Dushanbe
    3505, // DBA Asia/Karachi
    153, // DBB Africa/Cairo
    3840, // DBC Asia/Shanghai
    3547, // DBD Asia/Kolkata
    28, // DBM Africa/Addis_Ababa
    2350, // DBN America/New_York
    4425, // DBO Australia/Sydney
    1405, // DBQ America/Chicago
    28, // DBT Africa/Addis_Ababa
    5187, // DBV Europe/Zagreb
    4281, // DBY Australia/Brisbane
    2350, // DCA America/New_York
    1578, // DCF America/Dominica
    749, // DCK America/Anchorage
    4906, // DCM Europe/Paris
    1858, // DCR America/Indiana/Knox
    2335, // DCT America/Nassau
    1405, // DCU America/Chicago
    3840, // DCY Asia/Shanghai
    1405, // DDC America/Chicago
    3840, // DDG Asia/Shanghai
    2350, // DDH America/New_York
    2575, // DDP America/Puerto_Rico
    3505, // DEA Asia/Karachi
    4571, // DEB Europe/Budapest
    1405, // DEC America/Chicago
    3547, // DED Asia/Kolkata
    4003, // DEE Asia/Ust-Nera
    3927, // DEF Asia/Tehran
    1405, // DEH America/Chicago
    std::numeric_limits<uint16_t>::max(), // DEI
    3547, // DEL Asia/Kolkata
    28, // DEM Africa/Addis_Ababa
    1547, // DEN America/Denver
    3547, // DEP Asia/Kolkata
    1405, // DEQ America/Chicago
    5284, // DES Indian/Mahe
    1562, // DET America/Detroit
    2054, // DEW America/Los_Angeles
    3333, // DEZ Asia/Damascus
    2350, // DFI America/New_York
    1405, // DFW America/Chicago
    1217, // DGA America/Belize
    4425, // DGE Australia/Sydney
    3003, // DGF America/Vancouver
    2494, // DGL America/Phoenix
    2279, // DGO America/Monterrey
    4950, // DGP Europe/Riga
    5372, // DGR Pacific/Auckland
    3634, // DGT Asia/Manila
    639, // DGU Africa/Ouagadougou
    1547, // DGW America/Denver
    4791, // DGX Europe/London
    3788, // DHA Asia/Riyadh
    3518, // DHI Asia/Kathmandu
    3547, // DHM Asia/Kolkata
    3547, // DHN Asia/Kolkata
    4442, // DHR Europe/Amsterdam
    1405, // DHT America/Chicago
    3547, // DIB Asia/Kolkata
    5233, // DIE Indian/Antananarivo
    3840, // DIG Asia/Shanghai
    1286, // DIJ America/Boise
    1547, // DIK America/Denver
    3358, // DIL Asia/Dubai
    0, // DIM Africa/Abidjan
    4017, // DIN Asia/Vientiane
    639, // DIP Africa/Ouagadougou
    2759, // DIQ America/Sao_Paulo
    28, // DIR Africa/Addis_Ababa
    134, // DIS Africa/Brazzaville
    3547, // DIU Asia/Kolkata
    0, // DIV Africa/Abidjan
    4686, // DIY Europe/Istanbul
    658, // DJA Africa/Porto-Novo
    3450, // DJB Asia/Jayapura
    707, // DJE Africa/Tunis
    47, // DJG Africa/Algiers
    3450, // DJJ Asia/Jayapura
    134, // DJM Africa/Brazzaville
    749, // DJN America/Anchorage
    0, // DJO Africa/Abidjan
    4207, // DJU Atlantic/Reykjavik
    397, // DKA Africa/Lagos
    4281, // DKI Australia/Brisbane
    2350, // DKK America/New_York
    194, // DKR Africa/Dakar
    3560, // DKS Asia/Krasnoyarsk
    2350, // DKX America/New_York
    244, // DLA Africa/Douala
    3840, // DLC Asia/Shanghai
    4894, // DLD Europe/Oslo
    4906, // DLE Europe/Paris
    749, // DLG America/Anchorage
    1405, // DLH America/Chicago
    3410, // DLI Asia/Ho_Chi_Minh
    2350, // DLL America/New_York
    4686, // DLM Europe/Istanbul
    1547, // DLN America/Denver
    2054, // DLO America/Los_Angeles
    2054, // DLS America/Los_Angeles
    3840, // DLU Asia/Shanghai
    5455, // DLY Pacific/Efate
    3974, // DLZ Asia/Ulaanbaatar
    3123, // DMB Asia/Almaty
    4281, // DMD Australia/Brisbane
    4880, // DME Europe/Moscow
    3243, // DMK Asia/Barnaul
    3788, // DMM Asia/Riyadh
    1547, // DMN America/Denver
    1405, // DMO America/Chicago
    1474, // DMT America/Cuiaba
    3547, // DMU Asia/Kolkata
    2350, // DMW America/New_York
    4791, // DND Europe/London
    3840, // DNH Asia/Shanghai
    367, // DNI Africa/Kigali
    4735, // DNK Europe/Kiev
    2350, // DNL America/New_York
    2350, // DNN America/New_York
    3518, // DNP Asia/Kathmandu
    4425, // DNQ Australia/Sydney
    4906, // DNR Europe/Paris
    1405, // DNS America/Chicago
    1405, // DNV America/Chicago
    367, // DNX Africa/Kigali
    3450, // DOB Asia/Jayapura
    207, // DOD Africa/Dar_es_Salaam
    2475, // DOE America/Paramaribo
    367, // DOG Africa/Kigali
    3762, // DOH Asia/Qatar
    4735, // DOK Europe/Kiev
    4906, // DOL Europe/Paris
    1578, // DOM America/Dominica
    1775, // DON America/Guatemala
    3518, // DOP Asia/Kathmandu
    639, // DOR Africa/Ouagadougou
    1322, // DOU America/Campo_Grande
    3840, // DOY Asia/Shanghai
    1405, // DPA America/Chicago
    4906, // DPE Europe/Paris
    3634, // DPL Asia/Manila
    4372, // DPO Australia/Hobart
    3620, // DPS Asia/Makassar
    4032, // DPT Asia/Vladivostok
    3840, // DQA Asia/Shanghai
    749, // DQH America/Anchorage
    2054, // DRA America/Los_Angeles
    4409, // DRB Australia/Perth
    440, // DRC Africa/Luanda
    1562, // DRE America/Detroit
    2367, // DRG America/Nome
    3450, // DRH Asia/Jayapura
    1405, // DRI America/Chicago
    2475, // DRJ America/Paramaribo
    1439, // DRK America/Costa_Rica
    4281, // DRN Australia/Brisbane
    1547, // DRO America/Denver
    4506, // DRS Europe/Berlin
    1405, // DRT America/Chicago
    5296, // DRV Indian/Maldives
    4791, // DSA Europe/London
    244, // DSC Africa/Douala
    1756, // DSD America/Guadeloupe
    28, // DSE Africa/Addis_Ababa
    1405, // DSI America/Chicago
    3505, // DSK Asia/Karachi
    1405, // DSM America/Chicago
    3840, // DSN Asia/Shanghai
    3747, // DSO Asia/Pyongyang
    4409, // DSR Australia/Perth
    194, // DSS Africa/Dakar
    2350, // DSV America/New_York
    std::numeric_limits<uint16_t>::max(), // DSX
    1547, // DTA America/Denver
    3450, // DTB Asia/Jayapura
    3620, // DTD Asia/Makassar
    3634, // DTE Asia/Manila
    2054, // DTH America/Los_Angeles
    2759, // DTI America/Sao_Paulo
    1405, // DTL America/Chicago
    4506, // DTM Europe/Berlin
    1405, // DTN America/Chicago
    1405, // DTO America/Chicago
    1562, // DTW America/Detroit
    1405, // DUA America/Chicago
    4621, // DUB Europe/Dublin
    1405, // DUC America/Chicago
    5372, // DUD Pacific/Auckland
    440, // DUE Africa/Luanda
    2350, // DUF America/New_York
    2494, // DUG America/Phoenix
    1562, // DUH America/Detroit
    2350, // DUJ America/New_York
    3450, // DUM Asia/Jayapura
    3003, // DUQ America/Vancouver
    320, // DUR Africa/Johannesburg
    4506, // DUS Europe/Berlin
    2367, // DUT America/Nome
    5233, // DVD Indian/Antananarivo
    3073, // DVK America/Yellowknife
    1405, // DVL America/Chicago
    1405, // DVN America/Chicago
    3634, // DVO Asia/Manila
    2494, // DVT America/Phoenix
    118, // DWA Africa/Blantyre
    5233, // DWB Indian/Antananarivo
    3358, // DWC Asia/Dubai
    3788, // DWD Asia/Riyadh
    1405, // DWH America/Chicago
    2350, // DWS America/New_York
    2350, // DWU America/New_York
    3358, // DXB Asia/Dubai
    1405, // DXE America/Chicago
    2350, // DXR America/New_York
    4281, // DYA Australia/Brisbane
    3840, // DYG Asia/Shanghai
    2350, // DYL America/New_York
    3146, // DYR Asia/Anadyr
    1405, // DYT America/Chicago
    3369, // DYU Asia/Dushanbe
    5329, // DZA Indian/Mayotte
    2350, // DZJ America/New_York
    3123, // DZN Asia/Almaty
    2297, // DZO America/Montevideo
    749, // EAA America/Anchorage
    3113, // EAB Asia/Aden
    5455, // EAE Pacific/Efate
    5620, // EAL Pacific/Kwajalein
    3788, // EAM Asia/Riyadh
    4906, // EAP Europe/Paris
    1405, // EAR America/Chicago
    4823, // EAS Europe/Madrid
    2054, // EAT America/Los_Angeles
    1405, // EAU America/Chicago
    4962, // EBA Europe/Rome
    352, // EBB Africa/Kampala
    367, // EBD Africa/Kigali
    1271, // EBG America/Bogota
    4603, // EBJ Europe/Copenhagen
    3207, // EBL Asia/Baghdad
    5638, // EBO Pacific/Majuro
    1405, // EBS America/Chicago
    4906, // EBU Europe/Paris
    244, // EBW Africa/Douala
    2350, // ECG America/New_York
    4389, // ECH Australia/Melbourne
    2089, // ECI America/Managua
    3383, // ECN Asia/Famagusta
    1405, // ECP America/Chicago
    1271, // ECR America/Bogota
    4823, // ECV Europe/Madrid
    367, // EDB Africa/Kigali
    1405, // EDC America/Chicago
    2350, // EDE America/New_York
    4791, // EDI Europe/London
    2350, // EDJ America/New_York
    1405, // EDK America/Chicago
    576, // EDL Africa/Nairobi
    4906, // EDM Europe/Paris
    4686, // EDO Europe/Istanbul
    2901, // EDQ America/Tegucigalpa
    std::numeric_limits<uint16_t>::max(), // EDR
    2054, // EDU America/Los_Angeles
    2054, // EED America/Los_Angeles
    2367, // EEK America/Nome
    2350, // EEN America/New_York
    1405, // EET America/Chicago
    1405, // EFD America/Chicago
    5748, // EFG Pacific/Port_Moresby
    2350, // EFK America/New_York
    4476, // EFL Europe/Athens
    4906, // EGC Europe/Paris
    1547, // EGE America/Denver
    153, // EGH Africa/Cairo
    1405, // EGI America/Chicago
    28, // EGL Africa/Addis_Ababa
    5551, // EGM Pacific/Guadalcanal
    367, // EGN Africa/Kigali
    4880, // EGO Europe/Moscow
    1405, // EGP America/Chicago
    4207, // EGS Atlantic/Reykjavik
    1405, // EGT America/Chicago
    1405, // EGV America/Chicago
    749, // EGX America/Anchorage
    1405, // EHA America/Chicago
    971, // EHL America/Argentina/Salta
    2367, // EHM America/Nome
    2350, // EHO America/New_York
    1405, // EHR America/Chicago
    4506, // EIB Europe/Berlin
    3560, // EIE Asia/Krasnoyarsk
    4880, // EIK Europe/Moscow
    4442, // EIN Europe/Amsterdam
    2987, // EIS America/Tortola
    3464, // EIY Asia/Jerusalem
    1271, // EJA America/Bogota
    3788, // EJH Asia/Riyadh
    3840, // EJN Asia/Shanghai
    5638, // EJT Pacific/Majuro
    2054, // EKA America/Los_Angeles
    3123, // EKB Asia/Almaty
    std::numeric_limits<uint16_t>::max(), // EKI
    2054, // EKO America/Los_Angeles
    1979, // EKQ America/Kentucky/Monticello
    1547, // EKS America/Denver
    5064, // EKT Europe/Stockholm
    2350, // EKX America/New_York
    1405, // EKY America/Chicago
    1271, // ELB America/Bogota
    4339, // ELC Australia/Darwin
    1405, // ELD America/Chicago
    2440, // ELE America/Panama
    367, // ELF Africa/Kigali
    47, // ELG Africa/Algiers
    2335, // ELH America/Nassau
    2367, // ELI America/Nome
    1405, // ELK America/Chicago
    2350, // ELM America/New_York
    2054, // ELN America/Los_Angeles
    1115, // ELO America/Asuncion
    1547, // ELP America/Denver
    3788, // ELQ Asia/Riyadh
    320, // ELS Africa/Johannesburg
    153, // ELT Africa/Cairo
    47, // ELU Africa/Algiers
    1936, // ELV America/Juneau
    1358, // ELX America/Caracas
    2054, // ELY America/Los_Angeles
    2350, // ELZ America/New_York
    4791, // EMA Europe/London
    4281, // EMD Australia/Brisbane
    4506, // EME Europe/Berlin
    5748, // EMI Pacific/Port_Moresby
    2367, // EMK America/Nome
    1547, // EMM America/Denver
    621, // EMN Africa/Nouakchott
    1405, // EMP America/Chicago
    2054, // EMT America/Los_Angeles
    833, // EMX America/Argentina/Catamarca
    749, // ENA America/Anchorage
    4906, // ENC Europe/Paris
    3620, // ENE Asia/Makassar
    4651, // ENF Europe/Helsinki
    3840, // ENH Asia/Shanghai
    3634, // ENI Asia/Manila
    1775, // ENJ America/Guatemala
    4791, // ENK Europe/London
    1405, // ENL America/Chicago
    749, // ENN America/Anchorage
    1115, // ENO America/Asuncion
    4442, // ENS Europe/Amsterdam
    5638, // ENT Pacific/Majuro
    397, // ENU Africa/Lagos
    2054, // ENV America/Los_Angeles
    1405, // ENW America/Chicago
    3840, // ENY Asia/Shanghai
    2350, // EOE America/New_York
    1271, // EOH America/Bogota
    4791, // EOI Europe/London
    1405, // EOK America/Chicago
    2350, // EOP America/New_York
    1358, // EOR America/Caracas
    1405, // EOS America/Chicago
    1358, // EOZ America/Caracas
    802, // EPA America/Argentina/Buenos_Aires
    2054, // EPH America/Los_Angeles
    4906, // EPL Europe/Paris
    2350, // EPM America/New_York
    4409, // EPR Australia/Perth
    2737, // EPS America/Santo_Domingo
    5081, // EPU Europe/Tallinn
    833, // EQS America/Argentina/Catamarca
    2350, // EQY America/New_York
    543, // ERA Africa/Mogadishu
    4686, // ERC Europe/Istanbul
    5201, // ERD Europe/Zaporozhye
    4506, // ERF Europe/Berlin
    3437, // ERG Asia/Irkutsk
    166, // ERH Africa/Ceuta
    2350, // ERI America/New_York
    3840, // ERL Asia/Shanghai
    2759, // ERM America/Sao_Paulo
    1612, // ERN America/Eirunepe
    4281, // ERQ Australia/Brisbane
    2350, // ERR America/New_York
    720, // ERS Africa/Windhoek
    1405, // ERV America/Chicago
    1562, // ERY America/Detroit
    4686, // ERZ Europe/Istanbul
    4686, // ESB Europe/Istanbul
    1562, // ESC America/Detroit
    2054, // ESD America/Los_Angeles
    2955, // ESE America/Tijuana
    1115, // ESG America/Asuncion
    4791, // ESH Europe/London
    4686, // ESK Europe/Istanbul
    4880, // ESL Europe/Moscow
    1793, // ESM America/Guyana
    2350, // ESN America/New_York
    1547, // ESO America/Denver
    2350, // ESP America/New_York
    2720, // ESR America/Santiago
    4506, // ESS Europe/Berlin
    166, // ESU Africa/Ceuta
    2054, // ESW America/Los_Angeles
    1405, // ETB America/Chicago
    153, // ETH Africa/Cairo
    1793, // ETR America/Guyana
    1405, // ETS America/Chicago
    4906, // ETZ Europe/Paris
    5832, // EUA Pacific/Tongatapu
    4356, // EUC Australia/Eucla
    2054, // EUE America/Los_Angeles
    1405, // EUF America/Chicago
    2054, // EUG America/Los_Angeles
    1286, // EUL America/Boise
    258, // EUN Africa/El_Aaiun
    3634, // EUQ Asia/Manila
    2007, // EUX America/Kralendijk
    2350, // EVB America/New_York
    4894, // EVE Europe/Oslo
    5064, // EVG Europe/Stockholm
    4425, // EVH Australia/Sydney
    4093, // EVN Asia/Yerevan
    1405, // EVU America/Chicago
    1405, // EVV America/Chicago
    2350, // EVY America/New_York
    2350, // EWB America/New_York
    3450, // EWE Asia/Jayapura
    3450, // EWI Asia/Jayapura
    1405, // EWK America/Chicago
    2350, // EWN America/New_York
    134, // EWO Africa/Brazzaville
    2350, // EWR America/New_York
    1936, // EXI America/Juneau
    4791, // EXT Europe/London
    2350, // EXX America/New_York
    2350, // EYF America/New_York
    4074, // EYK Asia/Yekaterinburg
    76, // EYL Africa/Bamako
    1271, // EYP America/Bogota
    1405, // EYQ America/Chicago
    2054, // EYR America/Los_Angeles
    576, // EYS Africa/Nairobi
    2350, // EYW America/New_York
    802, // EZE America/Argentina/Buenos_Aires
    4686, // EZS Europe/Istanbul
    4791, // FAA Europe/London
    4791, // FAB Europe/London
    5802, // FAC Pacific/Tahiti
    4175, // FAE Atlantic/Faroe
    4207, // FAG Atlantic/Reykjavik
    3479, // FAH Asia/Kabul
    749, // FAI America/Anchorage
    2575, // FAJ America/Puerto_Rico
    4894, // FAN Europe/Oslo
    4760, // FAO Europe/Lisbon
    5748, // FAQ Pacific/Port_Moresby
    1405, // FAR America/Chicago
    4207, // FAS Atlantic/Reykjavik
    2054, // FAT America/Los_Angeles
    3646, // FAU Asia/Muscat
    5802, // FAV Pacific/Tahiti
    2350, // FAY America/New_York
    3927, // FAZ Asia/Tehran
    2105, // FBA America/Manaus
    3479, // FBD Asia/Kabul
    2759, // FBE America/Sao_Paulo
    454, // FBM Africa/Lubumbashi
    2054, // FBS America/Los_Angeles
    1547, // FCA America/Denver
    320, // FCB Africa/Johannesburg
    2054, // FCH America/Los_Angeles
    2350, // FCI America/New_York
    1405, // FCM America/Chicago
    4506, // FCN Europe/Berlin
    4962, // FCO Europe/Rome
    1405, // FCY America/Chicago
    4894, // FDE Europe/Oslo
    2120, // FDF America/Martinique
    4506, // FDH Europe/Berlin
    2350, // FDK America/New_York
    802, // FDO America/Argentina/Buenos_Aires
    1405, // FDR America/Chicago
    381, // FDU Africa/Kinshasa
    2350, // FDW America/New_York
    2350, // FDY America/New_York
    3518, // FEB Asia/Kathmandu
    1149, // FEC America/Bahia
    3900, // FEG Asia/Tashkent
    2684, // FEJ America/Rio_Branco
    0, // FEK Africa/Abidjan
    2380, // FEN America/Noronha
    1405, // FEP America/Chicago
    1405, // FET America/Chicago
    166, // FEZ Africa/Ceuta
    2350, // FFA America/New_York
    2350, // FFC America/New_York
    1405, // FFL America/Chicago
    1405, // FFM America/Chicago
    2350, // FFT America/New_York
    std::numeric_limits<uint16_t>::max(), // FFU
    1562, // FFX America/Detroit
    621, // FGD Africa/Nouakchott
    5359, // FGI Pacific/Apia
    5372, // FGL Pacific/Auckland
    5802, // FGU Pacific/Tahiti
    2350, // FGX America/New_York
    2350, // FHB America/New_York
    2494, // FHU America/Phoenix
    2350, // FID America/New_York
    4791, // FIE Europe/London
    179, // FIG Africa/Conakry
    134, // FIH Africa/Brazzaville
    1547, // FIL America/Denver
    5748, // FIN Pacific/Port_Moresby
    2350, // FIT America/New_York
    4409, // FIZ Australia/Perth
    3358, // FJR Asia/Dubai
    1405, // FKA America/Chicago
    4906, // FKB Europe/Paris
    454, // FKI Africa/Lubumbashi
    3952, // FKJ Asia/Tokyo
    2350, // FKL America/New_York
    2350, // FKN America/New_York
    3450, // FKQ Asia/Jayapura
    3952, // FKS Asia/Tokyo
    1271, // FLA America/Bogota
    1669, // FLB America/Fortaleza
    1405, // FLD America/Chicago
    4506, // FLF Europe/Berlin
    2494, // FLG America/Phoenix
    2350, // FLL America/New_York
    1115, // FLM America/Asuncion
    2759, // FLN America/Sao_Paulo
    2350, // FLO America/New_York
    1405, // FLP America/Chicago
    4962, // FLR Europe/Rome
    4372, // FLS Australia/Hobart
    2510, // FLT America/Port-au-Prince
    2350, // FLU America/New_York
    4106, // FLW Atlantic/Azores
    2054, // FLX America/Los_Angeles
    1547, // FLY America/Denver
    861, // FMA America/Argentina/Cordoba
    749, // FMC America/Anchorage
    2350, // FME America/New_York
    454, // FMI Africa/Lubumbashi
    4506, // FMM Europe/Berlin
    1547, // FMN America/Denver
    4506, // FMO Europe/Berlin
    2054, // FMU America/Los_Angeles
    2350, // FMY America/New_York
    1405, // FMZ America/Chicago
    274, // FNA Africa/Freetown
    4506, // FNB Europe/Berlin
    4190, // FNC Atlantic/Madeira
    5748, // FNE Pacific/Port_Moresby
    639, // FNG Africa/Ouagadougou
    28, // FNH Africa/Addis_Ababa
    4906, // FNI Europe/Paris
    3747, // FNJ Asia/Pyongyang
    1547, // FNL America/Denver
    1936, // FNR America/Juneau
    1562, // FNT America/Detroit
    4962, // FNU Europe/Rome
    4791, // FOA Europe/London
    3840, // FOC Asia/Shanghai
    1405, // FOD America/Chicago
    1405, // FOE America/Chicago
    4962, // FOG Europe/Rome
    2350, // FOK America/New_York
    244, // FOM Africa/Douala
    1439, // FON America/Costa_Rica
    3450, // FOO Asia/Jayapura
    1669, // FOR America/Fortaleza
    4409, // FOS Australia/Perth
    std::numeric_limits<uint16_t>::max(), // FOT
    410, // FOU Africa/Libreville
    274, // FOY Africa/Freetown
    1562, // FPK America/Detroit
    2335, // FPO America/Nassau
    2350, // FPR America/New_York
    2350, // FPY America/New_York
    4506, // FRA Europe/Berlin
    4425, // FRB Australia/Sydney
    2759, // FRC America/Sao_Paulo
    2054, // FRD America/Los_Angeles
    5551, // FRE Pacific/Guadalcanal
    2350, // FRG America/New_York
    1879, // FRH America/Indiana/Vincennes
    4906, // FRJ Europe/Paris
    5284, // FRK Indian/Mahe
    4962, // FRL Europe/Rome
    1405, // FRM America/Chicago
    4894, // FRO Europe/Oslo
    2350, // FRR America/New_York
    1775, // FRS America/Guatemala
    2720, // FRT America/Santiago
    3268, // FRU Asia/Bishkek
    290, // FRW Africa/Gaborone
    2350, // FRY America/New_York
    4906, // FSC Europe/Paris
    1405, // FSD America/Chicago
    1405, // FSK America/Chicago
    1405, // FSM America/Chicago
    2350, // FSO America/New_York
    2246, // FSP America/Miquelon
    1405, // FST America/Chicago
    1547, // FSU America/Denver
    3952, // FSZ Asia/Tokyo
    5455, // FTA Pacific/Efate
    940, // FTE America/Argentina/Rio_Gallegos
    1547, // FTG America/Denver
    5714, // FTI Pacific/Pago_Pago
    5233, // FTU Indian/Antananarivo
    1405, // FTW America/Chicago
    134, // FTX Africa/Brazzaville
    2350, // FTY America/New_York
    4139, // FUE Atlantic/Canary
    3840, // FUG Asia/Shanghai
    3952, // FUJ Asia/Tokyo
    3952, // FUK Asia/Tokyo
    2054, // FUL America/Los_Angeles
    5500, // FUN Pacific/Funafuti
    3840, // FUO Asia/Shanghai
    5850, // FUT Pacific/Wallis
    5296, // FVM Indian/Maldives
    1858, // FWA America/Indiana/Knox
    1405, // FWB America/Chicago
    1405, // FWC America/Chicago
    2350, // FWN America/New_York
    2350, // FWQ America/New_York
    1405, // FWS America/Chicago
    2350, // FXE America/New_York
    500, // FXO Africa/Maputo
    1405, // FXY America/Chicago
    1405, // FYE America/Chicago
    3840, // FYJ Asia/Shanghai
    1405, // FYM America/Chicago
    3991, // FYN Asia/Urumqi
    591, // FYT Africa/Ndjamena
    749, // FYU America/Anchorage
    1405, // FYV America/Chicago
    2350, // FZI America/New_York
    4791, // FZO Europe/London
    454, // FZU Africa/Lubumbashi
    2350, // FZY America/New_York
    1271, // GAA America/Bogota
    2054, // GAB America/Los_Angeles
    2901, // GAC America/Tegucigalpa
    1405, // GAD America/Chicago
    707, // GAE Africa/Tunis
    707, // GAF Africa/Tunis
    1405, // GAG America/Chicago
    4281, // GAH Australia/Brisbane
    2350, // GAI America/New_York
    3952, // GAJ Asia/Tokyo
    749, // GAL America/Anchorage
    2367, // GAM America/Nome
    5296, // GAN Indian/Maldives
    1824, // GAO America/Havana
    5748, // GAP Pacific/Port_Moresby
    76, // GAQ Africa/Bamako
    576, // GAS Africa/Nairobi
    4906, // GAT Europe/Paris
    3547, // GAU Asia/Kolkata
    4262, // GAW Australia/Adelaide
    410, // GAX Africa/Libreville
    3547, // GAY Asia/Kolkata
    5748, // GAZ Pacific/Port_Moresby
    4791, // GBA Europe/London
    3233, // GBB Asia/Baku
    1405, // GBD America/Chicago
    290, // GBE Africa/Gaborone
    1405, // GBG America/Chicago
    749, // GBH America/Anchorage
    2335, // GBI America/Nassau
    1756, // GBJ America/Guadeloupe
    274, // GBK Africa/Freetown
    4339, // GBL Australia/Darwin
    543, // GBM Africa/Mogadishu
    2350, // GBR America/New_York
    3927, // GBT Asia/Tehran
    367, // GBU Africa/Kigali
    4409, // GBV Australia/Perth
    5372, // GBZ Pacific/Auckland
    1547, // GCC America/Denver
    3927, // GCH Asia/Tehran
    4635, // GCI Europe/Guernsey
    320, // GCJ Africa/Johannesburg
    1405, // GCK America/Chicago
    1390, // GCM America/Cayman
    2494, // GCN America/Phoenix
    2494, // GCT America/Phoenix
    2494, // GCW America/Phoenix
    2350, // GCY America/New_York
    90, // GDA Africa/Banjul
    1405, // GDB America/Chicago
    2350, // GDC America/New_York
    28, // GDE Africa/Addis_Ababa
    4049, // GDG Asia/Yakutsk
    90, // GDI Africa/Banjul
    454, // GDJ Africa/Lubumbashi
    2226, // GDL America/Mexico_City
    2350, // GDM America/New_York
    5173, // GDN Europe/Warsaw
    1358, // GDO America/Caracas
    1669, // GDP America/Fortaleza
    28, // GDQ Africa/Addis_Ababa
    1721, // GDT America/Grand_Turk
    1547, // GDV America/Denver
    1562, // GDW America/Detroit
    3607, // GDX Asia/Magadan
    2350, // GDY America/New_York
    4880, // GDZ Europe/Moscow
    5699, // GEA Pacific/Noumea
    2350, // GED America/New_York
    4372, // GEE Australia/Hobart
    2759, // GEL America/Sao_Paulo
    1793, // GEO America/Guyana
    1824, // GER America/Havana
    3634, // GES Asia/Manila
    4409, // GET Australia/Perth
    2494, // GEU America/Phoenix
    5064, // GEV Europe/Stockholm
    4389, // GEX Australia/Melbourne
    1858, // GEZ America/Indiana/Knox
    1858, // GFD America/Indiana/Knox
    4425, // GFF Australia/Sydney
    1405, // GFK America/Chicago
    2350, // GFL America/New_York
    4425, // GFN Australia/Sydney
    1793, // GFO America/Guyana
    4906, // GFR Europe/Paris
    720, // GFY Africa/Windhoek
    440, // GGC Africa/Luanda
    2350, // GGE America/New_York
    1547, // GGF America/Denver
    1405, // GGG America/Chicago
    576, // GGM Africa/Nairobi
    0, // GGN Africa/Abidjan
    0, // GGO Africa/Abidjan
    543, // GGR Africa/Mogadishu
    940, // GGS America/Argentina/Rio_Gallegos
    2335, // GGT America/Nassau
    1547, // GGW America/Denver
    47, // GHA Africa/Algiers
    2335, // GHB America/Nassau
    2335, // GHC America/Nassau
    2440, // GHE America/Panama
    2350, // GHG America/New_York
    153, // GHK Africa/Cairo
    1405, // GHM America/Chicago
    3840, // GHN Asia/Shanghai
    47, // GHT Africa/Algiers
    861, // GHU America/Argentina/Cordoba
    4823, // GIB Europe/Madrid
    5748, // GIC Pacific/Port_Moresby
    454, // GID Africa/Lubumbashi
    2350, // GIF America/New_York
    2759, // GIG America/Sao_Paulo
    179, // GII Africa/Conakry
    3505, // GIL Asia/Karachi
    1271, // GIR America/Bogota
    5372, // GIS Pacific/Auckland
    3320, // GIU Asia/Colombo
    3788, // GIZ Asia/Riyadh
    2901, // GJA America/Tegucigalpa
    47, // GJL Africa/Algiers
    2026, // GJM America/La_Paz
    4207, // GJR Atlantic/Reykjavik
    1547, // GJT America/Denver
    5748, // GKA Pacific/Port_Moresby
    4476, // GKD Europe/Athens
    5296, // GKK Indian/Maldives
    749, // GKN America/Anchorage
    2350, // GKT America/New_York
    1405, // GKY America/Chicago
    4791, // GLA Europe/London
    2494, // GLB America/Phoenix
    1547, // GLD America/Denver
    1405, // GLE America/Chicago
    1439, // GLF America/Costa_Rica
    1405, // GLH America/Chicago
    4425, // GLI Australia/Sydney
    543, // GLK Africa/Mogadishu
    4894, // GLL Europe/Oslo
    166, // GLN Africa/Ceuta
    4791, // GLO Europe/London
    1562, // GLR America/Detroit
    1405, // GLS America/Chicago
    4281, // GLT Australia/Brisbane
    3939, // GLU Asia/Thimphu
    2367, // GLV America/Nome
    1405, // GLW America/Chicago
    3450, // GLX Asia/Jayapura
    381, // GMA Africa/Kinshasa
    28, // GMB Africa/Addis_Ababa
    166, // GMD Africa/Ceuta
    4867, // GME Europe/Minsk
    5748, // GMI Pacific/Port_Moresby
    1405, // GMJ America/Chicago
    4735, // GML Europe/Kiev
    134, // GMM Africa/Brazzaville
    std::numeric_limits<uint16_t>::max(), // GMN
    397, // GMO Africa/Lagos
    3829, // GMP Asia/Seoul
    3840, // GMQ Asia/Shanghai
    5535, // GMR Pacific/Gambier
    2350, // GMU America/New_York
    4139, // GMZ Atlantic/Canary
    4867, // GNA Europe/Minsk
    4906, // GNB Europe/Paris
    1740, // GND America/Grenada
    2054, // GNF America/Los_Angeles
    3888, // GNI Asia/Taipei
    4538, // GNK Europe/Brussels
    1149, // GNM America/Bahia
    28, // GNN Africa/Addis_Ababa
    971, // GNR America/Argentina/Salta
    3450, // GNS Asia/Jayapura
    1547, // GNT America/Denver
    749, // GNU America/Anchorage
    2350, // GNV America/New_York
    4686, // GNY Europe/Istanbul
    290, // GNZ Africa/Gaborone
    4962, // GOA Europe/Rome
    28, // GOB Africa/Addis_Ababa
    720, // GOG Africa/Windhoek
    1705, // GOH America/Godthab
    3547, // GOI Asia/Kolkata
    4880, // GOJ Europe/Moscow
    1405, // GOK America/Chicago
    2054, // GOL America/Los_Angeles
    454, // GOM Africa/Lubumbashi
    4281, // GOO Australia/Brisbane
    3547, // GOP Asia/Kolkata
    3840, // GOQ Asia/Shanghai
    28, // GOR Africa/Addis_Ababa
    5064, // GOT Europe/Stockholm
    244, // GOU Africa/Douala
    4339, // GOV Australia/Darwin
    5051, // GOZ Europe/Sofia
    4476, // GPA Europe/Athens
    2759, // GPB America/Sao_Paulo
    4281, // GPD Australia/Brisbane
    1405, // GPH America/Chicago
    1271, // GPI America/Bogota
    1439, // GPL America/Costa_Rica
    1405, // GPM America/Chicago
    4339, // GPN Australia/Darwin
    971, // GPO America/Argentina/Salta
    5517, // GPS Pacific/Galapagos
    1405, // GPT America/Chicago
    1405, // GPZ America/Chicago
    2350, // GQQ America/New_York
    1405, // GRB America/Chicago
    2350, // GRD America/New_York
    1405, // GRE America/Chicago
    3479, // GRG Asia/Kabul
    1405, // GRI America/Chicago
    320, // GRJ Africa/Johannesburg
    1405, // GRK America/Chicago
    1405, // GRM America/Chicago
    4823, // GRO Europe/Madrid
    784, // GRP America/Araguaina
    4442, // GRQ Europe/Amsterdam
    1562, // GRR America/Detroit
    4962, // GRS Europe/Rome
    2759, // GRU America/Sao_Paulo
    4880, // GRV Europe/Moscow
    4106, // GRW Atlantic/Azores
    4823, // GRX Europe/Madrid
    4207, // GRY Atlantic/Reykjavik
    5127, // GRZ Europe/Vienna
    3595, // GSA Asia/Kuwait
    5064, // GSE Europe/Stockholm
    1858, // GSH America/Indiana/Knox
    2475, // GSI America/Paramaribo
    1775, // GSJ America/Guatemala
    3073, // GSL America/Yellowknife
    3927, // GSM Asia/Tehran
    2350, // GSO America/New_York
    2350, // GSP America/New_York
    153, // GSQ Africa/Cairo
    543, // GSR Africa/Mogadishu
    1936, // GST America/Juneau
    367, // GSU Africa/Kigali
    1405, // GSW America/Chicago
    5551, // GTA Pacific/Guadalcanal
    3595, // GTB Asia/Kuwait
    4339, // GTE Australia/Darwin
    1547, // GTF America/Denver
    1405, // GTG America/Chicago
    5372, // GTN Pacific/Auckland
    3620, // GTO Asia/Makassar
    2054, // GTP America/Los_Angeles
    1405, // GTR America/Chicago
    4339, // GTS Australia/Darwin
    4281, // GTT Australia/Brisbane
    1405, // GTU America/Chicago
    4936, // GTW Europe/Prague
    2350, // GTY America/New_York
    1775, // GUA America/Guatemala
    2955, // GUB America/Tijuana
    1547, // GUC America/Denver
    76, // GUD Africa/Bamako
    1405, // GUF America/Chicago
    4425, // GUH Australia/Sydney
    1358, // GUI America/Caracas
    2759, // GUJ America/Sao_Paulo
    4425, // GUL Australia/Sydney
    5571, // GUM Pacific/Guam
    2901, // GUO America/Tegucigalpa
    1547, // GUP America/Denver
    1358, // GUQ America/Caracas
    5748, // GUR Pacific/Port_Moresby
    1858, // GUS America/Indiana/Knox
    4207, // GUU Atlantic/Reykjavik
    3195, // GUW Asia/Atyrau
    1405, // GUY America/Chicago
    2759, // GUZ America/Sao_Paulo
    4906, // GVA Europe/Paris
    2350, // GVL America/New_York
    2350, // GVQ America/New_York
    2759, // GVR America/Sao_Paulo
    1405, // GVT America/Chicago
    std::numeric_limits<uint16_t>::max(), // GVW
    5064, // GVX Europe/Stockholm
    3505, // GWD Asia/Karachi
    3547, // GWL Asia/Kolkata
    1405, // GWO America/Chicago
    4506, // GWT Europe/Berlin
    2350, // GWW America/New_York
    4621, // GWY Europe/Dublin
    3113, // GXF Asia/Aden
    440, // GXG Africa/Luanda
    3840, // GXH Asia/Shanghai
    2720, // GXQ America/Santiago
    244, // GXX Africa/Douala
    1547, // GXY America/Denver
    2026, // GYA America/La_Paz
    1405, // GYB America/Chicago
    3233, // GYD Asia/Baku
    1793, // GYE America/Guyana
    4049, // GYG Asia/Yakutsk
    454, // GYI Africa/Lubumbashi
    4409, // GYL Australia/Perth
    1839, // GYM America/Hermosillo
    2759, // GYN America/Sao_Paulo
    4281, // GYP Australia/Brisbane
    2494, // GYR America/Phoenix
    3840, // GYS Asia/Shanghai
    3840, // GYU Asia/Shanghai
    1405, // GYY America/Chicago
    153, // GZA Africa/Cairo
    1405, // GZH America/Chicago
    3479, // GZI Asia/Kabul
    1405, // GZL America/Chicago
    5551, // GZO Pacific/Guadalcanal
    std::numeric_limits<uint16_t>::max(), // GZP
    1405, // GZS America/Chicago
    4686, // GZT Europe/Istanbul
    3927, // GZW Asia/Tehran
    4894, // HAA Europe/Oslo
    1405, // HAB America/Chicago
    3952, // HAC Asia/Tokyo
    5064, // HAD Europe/Stockholm
    3747, // HAE Asia/Pyongyang
    2054, // HAF America/Los_Angeles
    5270, // HAH Indian/Comoro
    4506, // HAJ Europe/Berlin
    3840, // HAK Asia/Shanghai
    720, // HAL Africa/Windhoek
    4506, // HAM Europe/Berlin
    3410, // HAN Asia/Ho_Chi_Minh
    2350, // HAO America/New_York
    5296, // HAQ Indian/Maldives
    2350, // HAR America/New_York
    3788, // HAS Asia/Riyadh
    4894, // HAU Europe/Oslo
    1824, // HAV America/Havana
    4791, // HAW Europe/London
    1405, // HAX America/Chicago
    749, // HAY America/Anchorage
    4372, // HBA Australia/Hobart
    153, // HBE Africa/Cairo
    1405, // HBG America/Chicago
    2350, // HBI America/New_York
    2494, // HBK America/Phoenix
    1405, // HBR America/Chicago
    3427, // HBU Asia/Hovd
    3547, // HBX Asia/Kolkata
    1405, // HCA America/Chicago
    2350, // HCC America/New_York
    1405, // HCD America/Chicago
    3840, // HCJ Asia/Shanghai
    543, // HCM Africa/Mogadishu
    3888, // HCN Asia/Taipei
    4409, // HCQ Australia/Perth
    749, // HCR America/Anchorage
    2350, // HCW America/New_York
    3464, // HDA Asia/Jerusalem
    1405, // HDC America/Chicago
    3505, // HDD Asia/Karachi
    4506, // HDF Europe/Berlin
    3840, // HDG Asia/Shanghai
    2350, // HDI America/New_York
    3927, // HDM Asia/Tehran
    1547, // HDN America/Denver
    1405, // HDO America/Chicago
    3243, // HDY Asia/Barnaul
    3479, // HEA Asia/Kabul
    1405, // HEE America/Chicago
    2350, // HEG America/New_York
    4062, // HEH Asia/Yangon
    1547, // HEI America/Denver
    3840, // HEK Asia/Shanghai
    4651, // HEL Europe/Helsinki
    4651, // HEN Europe/Helsinki
    5748, // HEO Pacific/Port_Moresby
    4476, // HER Europe/Athens
    2054, // HES America/Los_Angeles
    3840, // HET Asia/Shanghai
    4476, // HEW Europe/Athens
    2737, // HEX America/Santo_Domingo
    1405, // HEZ America/Chicago
    3464, // HFA Asia/Jerusalem
    2350, // HFD America/New_York
    3840, // HFE Asia/Shanghai
    2350, // HFF America/New_York
    4207, // HFN Atlantic/Reykjavik
    5064, // HFS Europe/Stockholm
    4894, // HFT Europe/Oslo
    543, // HGA Africa/Mogadishu
    4281, // HGD Australia/Brisbane
    1358, // HGE America/Caracas
    3840, // HGH Asia/Shanghai
    340, // HGI Africa/Juba
    4506, // HGL Europe/Berlin
    4062, // HGN Asia/Yangon
    0, // HGO Africa/Abidjan
    2350, // HGR America/New_York
    274, // HGS Africa/Freetown
    5748, // HGU Pacific/Port_Moresby
    2350, // HHH America/New_York
    4506, // HHN Europe/Berlin
    3243, // HHQ Asia/Barnaul
    2054, // HHR America/Los_Angeles
    5802, // HHZ Pacific/Tahiti
    3840, // HIA Asia/Shanghai
    1405, // HIB America/Chicago
    4281, // HID Australia/Brisbane
    2350, // HIE America/New_York
    2494, // HII America/Phoenix
    3952, // HIJ Asia/Tokyo
    28, // HIL Africa/Addis_Ababa
    3829, // HIN Asia/Seoul
    2054, // HIO America/Los_Angeles
    5551, // HIR Pacific/Guadalcanal
    3952, // HIW Asia/Tokyo
    3840, // HJJ Asia/Shanghai
    2054, // HJO America/Los_Angeles
    3547, // HJR Asia/Kolkata
    3974, // HJT Asia/Ulaanbaatar
    1405, // HKA America/Chicago
    749, // HKB America/Anchorage
    3952, // HKD Asia/Tokyo
    3840, // HKG Asia/Shanghai
    std::numeric_limits<uint16_t>::max(), // HKK
    5748, // HKN Pacific/Port_Moresby
    std::numeric_limits<uint16_t>::max(), // HKO
    5584, // HKP Pacific/Honolulu
    1405, // HKS America/Chicago
    std::numeric_limits<uint16_t>::max(), // HKT
    2350, // HKY America/New_York
    320, // HLA Africa/Johannesburg
    1405, // HLC America/Chicago
    3840, // HLD Asia/Shanghai
    4226, // HLE Atlantic/St_Helena
    5064, // HLF Europe/Stockholm
    2350, // HLG America/New_York
    3840, // HLH Asia/Shanghai
    2054, // HLI America/Los_Angeles
    5141, // HLJ Europe/Vilnius
    1562, // HLM America/Detroit
    1547, // HLN America/Denver
    3450, // HLP Asia/Jayapura
    4372, // HLS Australia/Hobart
    4389, // HLT Australia/Melbourne
    320, // HLW Africa/Johannesburg
    5372, // HLZ Pacific/Auckland
    4074, // HMA Asia/Yekaterinburg
    153, // HMB Africa/Cairo
    47, // HME Africa/Algiers
    3991, // HMI Asia/Urumqi
    4735, // HMJ Europe/Kiev
    1839, // HMO America/Hermosillo
    4894, // HMR Europe/Oslo
    2054, // HMT America/Los_Angeles
    3952, // HNA Asia/Tokyo
    1879, // HNB America/Indiana/Vincennes
    2350, // HNC America/New_York
    3952, // HND Asia/Tokyo
    1936, // HNH America/Juneau
    5584, // HNL Pacific/Honolulu
    5584, // HNM Pacific/Honolulu
    1936, // HNS America/Juneau
    3840, // HNY Asia/Shanghai
    2350, // HNZ America/New_York
    576, // HOA Africa/Nairobi
    1547, // HOB America/Denver
    3113, // HOD Asia/Aden
    4017, // HOE Asia/Vientiane
    3788, // HOF Asia/Riyadh
    1824, // HOG America/Havana
    5219, // HOH Europe/Zurich
    5802, // HOI Pacific/Tahiti
    4339, // HOK Australia/Darwin
    749, // HOM America/Anchorage
    1405, // HON America/Chicago
    4017, // HOO Asia/Vientiane
    4106, // HOR Atlantic/Azores
    971, // HOS America/Argentina/Salta
    1405, // HOT America/Chicago
    1405, // HOU America/Chicago
    4894, // HOV Europe/Oslo
    5832, // HPA Pacific/Tongatapu
    2367, // HPB America/Nome
    3840, // HPG Asia/Shanghai
    3410, // HPH Asia/Ho_Chi_Minh
    2350, // HPN America/New_York
    5584, // HPV Pacific/Honolulu
    1474, // HPX America/Cuiaba
    1405, // HPY America/Chicago
    1405, // HQG America/Chicago
    2054, // HQM America/Los_Angeles
    1405, // HQZ America/Chicago
    3840, // HRB Asia/Shanghai
    306, // HRE Africa/Harare
    153, // HRG Africa/Cairo
    3320, // HRI Asia/Colombo
    3518, // HRJ Asia/Kathmandu
    4735, // HRK Europe/Kiev
    1405, // HRL America/Chicago
    47, // HRM Africa/Algiers
    1405, // HRO America/Chicago
    320, // HRS Africa/Johannesburg
    1405, // HRU America/Chicago
    3464, // HRZ Asia/Jerusalem
    1405, // HSA America/Chicago
    3840, // HSC Asia/Shanghai
    1405, // HSD America/Chicago
    3952, // HSG Asia/Tokyo
    2054, // HSH America/Los_Angeles
    1405, // HSI America/Chicago
    4823, // HSK Europe/Madrid
    749, // HSL America/Anchorage
    4389, // HSM Australia/Melbourne
    3840, // HSN Asia/Shanghai
    1547, // HSR America/Denver
    3547, // HSS Asia/Kolkata
    1405, // HSV America/Chicago
    3293, // HTA Asia/Chita
    4791, // HTF Europe/London
    3560, // HTG Asia/Krasnoyarsk
    2054, // HTH America/Los_Angeles
    4281, // HTI Australia/Brisbane
    1562, // HTL America/Detroit
    3974, // HTM Asia/Ulaanbaatar
    3991, // HTN Asia/Urumqi
    2350, // HTO America/New_York
    3952, // HTR Asia/Tokyo
    2350, // HTS America/New_York
    3840, // HTT Asia/Shanghai
    4389, // HTU Australia/Melbourne
    1405, // HTV America/Chicago
    2350, // HTW America/New_York
    4686, // HTY Europe/Istanbul
    1271, // HTZ America/Bogota
    4339, // HUB Australia/Darwin
    2575, // HUC America/Puerto_Rico
    1405, // HUD America/Chicago
    28, // HUE Africa/Addis_Ababa
    1858, // HUF America/Indiana/Knox
    1775, // HUG America/Guatemala
    5802, // HUH Pacific/Tahiti
    3410, // HUI Asia/Ho_Chi_Minh
    1405, // HUJ America/Chicago
    290, // HUK Africa/Gaborone
    2350, // HUL America/New_York
    1405, // HUM America/Chicago
    3888, // HUN Asia/Taipei
    692, // HUQ Africa/Tripoli
    749, // HUS America/Anchorage
    1405, // HUT America/Chicago
    2041, // HUU America/Lima
    5064, // HUV Europe/Stockholm
    2105, // HUW America/Manaus
    2226, // HUX America/Mexico_City
    4791, // HUY Europe/London
    3840, // HUZ Asia/Shanghai
    5233, // HVA Indian/Antananarivo
    4281, // HVB Australia/Brisbane
    1405, // HVC America/Chicago
    3427, // HVD Asia/Hovd
    4894, // HVG Europe/Oslo
    4207, // HVK Atlantic/Reykjavik
    2350, // HVN America/New_York
    1547, // HVR America/Denver
    2350, // HVS America/New_York
    4281, // HWM Australia/Brisbane
    306, // HWN Africa/Harare
    2350, // HWO America/New_York
    1547, // HWQ America/Denver
    2350, // HWY America/New_York
    3840, // HXD Asia/Shanghai
    4425, // HXX Australia/Sydney
    2350, // HYA America/New_York
    4791, // HYC Europe/London
    3547, // HYD Asia/Kolkata
    2777, // HYG America/Sitka
    1405, // HYI America/Chicago
    2777, // HYL America/Sitka
    3840, // HYN Asia/Shanghai
    1405, // HYR America/Chicago
    1405, // HYS America/Chicago
    2350, // HYW America/New_York
    1562, // HYX America/Detroit
    4906, // HZB Europe/Paris
    1405, // HZD America/Chicago
    2396, // HZE America/North_Dakota/Beulah
    3840, // HZG Asia/Shanghai
    3840, // HZH Asia/Shanghai
    4207, // HZK Atlantic/Reykjavik
    2350, // HZL America/New_York
    1595, // HZP America/Edmonton
    1405, // HZR America/Chicago
    3560, // IAA Asia/Krasnoyarsk
    2350, // IAD America/New_York
    std::numeric_limits<uint16_t>::max(), // IAG
    1405, // IAH America/Chicago
    47, // IAM Africa/Algiers
    749, // IAN America/Anchorage
    3634, // IAO Asia/Manila
    3927, // IAQ Asia/Tehran
    4880, // IAR Europe/Moscow
    4554, // IAS Europe/Bucharest
    397, // IBA Africa/Lagos
    1271, // IBE America/Bogota
    500, // IBL Africa/Maputo
    2041, // IBP America/Lima
    4823, // IBZ Europe/Madrid
    1358, // ICA America/Caracas
    1358, // ICC America/Caracas
    5487, // ICI Pacific/Fiji
    1793, // ICK America/Guyana
    3829, // ICN Asia/Seoul
    1824, // ICR America/Havana
    1405, // ICT America/Chicago
    749, // ICY America/Anchorage
    1286, // IDA America/Boise
    381, // IDF Africa/Kinshasa
    2054, // IDH America/Los_Angeles
    2350, // IDI America/New_York
    1405, // IDL America/Chicago
    1405, // IDP America/Chicago
    3547, // IDR Asia/Kolkata
    4906, // IDY Europe/Paris
    5173, // IEG Europe/Warsaw
    std::numeric_limits<uint16_t>::max(), // IEJ
    1405, // IER America/Chicago
    4506, // IES Europe/Berlin
    4735, // IEV Europe/Kiev
    4207, // IFJ Atlantic/Reykjavik
    4281, // IFL Australia/Brisbane
    3927, // IFN Asia/Tehran
    4735, // IFO Europe/Kiev
    2054, // IFP America/Los_Angeles
    2335, // IGA America/Nassau
    971, // IGB America/Argentina/Salta
    4686, // IGD Europe/Istanbul
    410, // IGE Africa/Libreville
    749, // IGG America/Anchorage
    4281, // IGH Australia/Brisbane
    2494, // IGM America/Phoenix
    3634, // IGN Asia/Manila
    1271, // IGO America/Bogota
    1405, // IGQ America/Chicago
    861, // IGR America/Argentina/Cordoba
    4506, // IGS Europe/Berlin
    4880, // IGT Europe/Moscow
    std::numeric_limits<uint16_t>::max(), // IGU
    2350, // IGX America/New_York
    500, // IHC Africa/Maputo
    std::numeric_limits<uint16_t>::max(), // IHO
    3927, // IHR Asia/Tehran
    5748, // IHU Pacific/Port_Moresby
    4621, // IIA Europe/Dublin
    1405, // IIB America/Chicago
    3927, // IIL Asia/Tehran
    5389, // IIS Pacific/Bougainville
    2350, // IJD America/New_York
    4974, // IJK Europe/Samara
    2759, // IJU America/Sao_Paulo
    3927, // IKA Asia/Tehran
    2350, // IKB America/New_York
    1405, // IKG America/Chicago
    3952, // IKI Asia/Tokyo
    1405, // IKK America/Chicago
    381, // IKL Africa/Kinshasa
    4049, // IKS Asia/Yakutsk
    3437, // IKT Asia/Irkutsk
    3268, // IKU Asia/Bishkek
    1405, // IKV America/Chicago
    1562, // IKW America/Detroit
    1322, // ILB America/Campo_Grande
    4823, // ILD Europe/Madrid
    1405, // ILE America/Chicago
    3040, // ILF America/Winnipeg
    2350, // ILG America/New_York
    749, // ILI America/Anchorage
    std::numeric_limits<uint16_t>::max(), // ILK
    1405, // ILL America/Chicago
    2350, // ILM America/New_York
    2350, // ILN America/New_York
    3634, // ILO Asia/Manila
    5699, // ILP Pacific/Noumea
    2041, // ILQ America/Lima
    397, // ILR Africa/Lagos
    1629, // ILS America/El_Salvador
    576, // ILU Africa/Nairobi
    4791, // ILY Europe/London
    4520, // ILZ Europe/Bratislava
    1793, // IMB America/Guyana
    5638, // IMI Pacific/Majuro
    3518, // IMK Asia/Kathmandu
    2350, // IMM America/New_York
    90, // IMO Africa/Banjul
    1669, // IMP America/Fortaleza
    1405, // IMT America/Chicago
    4880, // INA Europe/Moscow
    1217, // INB America/Belize
    3840, // INC Asia/Shanghai
    1858, // IND America/Indiana/Knox
    47, // INF Africa/Algiers
    940, // ING America/Argentina/Rio_Gallegos
    500, // INH Africa/Maputo
    4490, // INI Europe/Belgrade
    1405, // INJ America/Chicago
    1405, // INK America/Chicago
    3040, // INL America/Winnipeg
    5127, // INN Europe/Vienna
    381, // INO Africa/Kinshasa
    4621, // INQ Europe/Dublin
    2350, // INT America/New_York
    std::numeric_limits<uint16_t>::max(), // INU
    4791, // INV Europe/London
    2494, // INW America/Phoenix
    47, // INZ Africa/Algiers
    4476, // IOA Europe/Athens
    4667, // IOM Europe/Isle_of_Man
    134, // ION Africa/Brazzaville
    4621, // IOR Europe/Dublin
    1149, // IOS America/Bahia
    1405, // IOW America/Chicago
    5455, // IPA Pacific/Efate
    5440, // IPC Pacific/Easter
    3634, // IPE Asia/Manila
    1271, // IPG America/Bogota
    3577, // IPH Asia/Kuala_Lumpur
    1271, // IPI America/Bogota
    2350, // IPJ America/New_York
    2054, // IPL America/Los_Angeles
    2759, // IPN America/Sao_Paulo
    2350, // IPT America/New_York
    3840, // IQN Asia/Shanghai
    2720, // IQQ America/Santiago
    2041, // IQT America/Lima
    5551, // IRA Pacific/Guadalcanal
    749, // IRC America/Anchorage
    3347, // IRD Asia/Dhaka
    4281, // IRG Australia/Brisbane
    207, // IRI Africa/Dar_es_Salaam
    887, // IRJ America/Argentina/La_Rioja
    1405, // IRK America/Chicago
    90, // IRO Africa/Banjul
    454, // IRP Africa/Lubumbashi
    2105, // IRZ America/Manaus
    4281, // ISA Australia/Brisbane
    3505, // ISB Asia/Karachi
    4791, // ISC Europe/London
    4686, // ISE Europe/Istanbul
    3952, // ISG Asia/Tokyo
    4281, // ISI Australia/Brisbane
    1343, // ISJ America/Cancun
    3547, // ISK Asia/Kolkata
    2350, // ISM America/New_York
    1405, // ISN America/Chicago
    2350, // ISO America/New_York
    2350, // ISP America/New_York
    1562, // ISQ America/Detroit
    2350, // ISS America/New_York
    4686, // IST Europe/Istanbul
    3207, // ISU Asia/Baghdad
    1405, // ISW America/Chicago
    2350, // ISZ America/New_York
    2105, // ITA America/Manaus
    2703, // ITB America/Santarem
    2350, // ITH America/New_York
    3952, // ITM Asia/Tokyo
    5584, // ITO Pacific/Honolulu
    2759, // ITP America/Sao_Paulo
    861, // ITQ America/Argentina/Cordoba
    2759, // ITR America/Sao_Paulo
    4003, // ITU Asia/Ust-Nera
    5686, // IUE Pacific/Niue
    5389, // IUS Pacific/Bougainville
    5233, // IVA Indian/Antananarivo
    5372, // IVC Pacific/Auckland
    4919, // IVG Europe/Podgorica
    4651, // IVL Europe/Helsinki
    4425, // IVR Australia/Sydney
    4880, // IWA Europe/Moscow
    2174, // IWD America/Menominee
    3952, // IWJ Asia/Tokyo
    1405, // IWS America/Chicago
    3347, // IXA Asia/Dhaka
    3518, // IXB Asia/Kathmandu
    3547, // IXC Asia/Kolkata
    3547, // IXD Asia/Kolkata
    3547, // IXE Asia/Kolkata
    3547, // IXG Asia/Kolkata
    3347, // IXH Asia/Dhaka
    3547, // IXI Asia/Kolkata
    3505, // IXJ Asia/Karachi
    3547, // IXK Asia/Kolkata
    3547, // IXL Asia/Kolkata
    3547, // IXM Asia/Kolkata
    3347, // IXN Asia/Dhaka
    3547, // IXP Asia/Kolkata
    3347, // IXQ Asia/Dhaka
    3547, // IXR Asia/Kolkata
    3547, // IXS Asia/Kolkata
    3547, // IXT Asia/Kolkata
    3547, // IXU Asia/Kolkata
    3547, // IXV Asia/Kolkata
    3547, // IXW Asia/Kolkata
    3547, // IXY Asia/Kolkata
    3547, // IXZ Asia/Kolkata
    1405, // IYA America/Chicago
    2054, // IYK America/Los_Angeles
    2759, // IZA America/Sao_Paulo
    3952, // IZO Asia/Tokyo
    2226, // IZT America/Mexico_City
    3479, // JAA Asia/Kabul
    4339, // JAB Australia/Darwin
    1547, // JAC America/Denver
    4409, // JAD Australia/Perth
    2041, // JAE America/Lima
    3547, // JAI Asia/Kolkata
    2510, // JAK America/Port-au-Prince
    2226, // JAL America/Mexico_City
    1405, // JAN America/Chicago
    4490, // JAO Europe/Belgrade
    1439, // JAP America/Costa_Rica
    5748, // JAQ Pacific/Port_Moresby
    3927, // JAR Asia/Tehran
    std::numeric_limits<uint16_t>::max(), // JAT
    2041, // JAU America/Lima
    1705, // JAV America/Godthab
    2350, // JAX America/New_York
    3450, // JBB Asia/Jayapura
    2737, // JBQ America/Santo_Domingo
    1405, // JBR America/Chicago
    749, // JBT America/Anchorage
    2759, // JCB America/Sao_Paulo
    1705, // JCH America/Godthab
    1405, // JCI America/Chicago
    4281, // JCK Australia/Brisbane
    2703, // JCR America/Santarem
    2054, // JDA America/Los_Angeles
    1405, // JDD America/Chicago
    2759, // JDF America/Sao_Paulo
    3829, // JDG Asia/Seoul
    3547, // JDH Asia/Kolkata
    1547, // JDN America/Denver
    1669, // JDO America/Fortaleza
    2759, // JDR America/Sao_Paulo
    3840, // JDZ Asia/Shanghai
    3788, // JED Asia/Riyadh
    2510, // JEE America/Port-au-Prince
    1405, // JEF America/Chicago
    1705, // JEG America/Godthab
    5638, // JEJ Pacific/Majuro
    1149, // JEQ America/Bahia
    4702, // JER Europe/Jersey
    2350, // JES America/New_York
    2350, // JFK America/New_York
    2350, // JFN America/New_York
    1705, // JFR America/Godthab
    1405, // JFX America/Chicago
    3547, // JGA Asia/Kolkata
    3547, // JGB Asia/Kolkata
    3840, // JGD Asia/Shanghai
    3840, // JGN Asia/Shanghai
    1705, // JGO America/Godthab
    3840, // JGS Asia/Shanghai
    3577, // JHB Asia/Kuala_Lumpur
    3840, // JHG Asia/Shanghai
    1595, // JHL America/Edmonton
    5584, // JHM Pacific/Honolulu
    1405, // JHN America/Chicago
    4281, // JHQ Australia/Brisbane
    1705, // JHS America/Godthab
    2350, // JHW America/New_York
    1474, // JIA America/Cuiaba
    228, // JIB Africa/Djibouti
    3840, // JIC Asia/Shanghai
    28, // JIJ Africa/Addis_Ababa
    4476, // JIK Europe/Athens
    3840, // JIL Asia/Shanghai
    28, // JIM Africa/Addis_Ababa
    352, // JIN Africa/Kampala
    3450, // JIO Asia/Jayapura
    3840, // JIQ Asia/Shanghai
    3840, // JIU Asia/Shanghai
    3927, // JIW Asia/Tehran
    2226, // JJC America/Mexico_City
    2759, // JJG America/Sao_Paulo
    2041, // JJI America/Lima
    576, // JJM Africa/Nairobi
    3840, // JJN Asia/Shanghai
    5064, // JKG Europe/Stockholm
    4476, // JKH Europe/Athens
    4476, // JKL Europe/Athens
    3547, // JKR Asia/Kolkata
    1405, // JKV America/Chicago
    1405, // JLN America/Chicago
    3547, // JLR Asia/Kolkata
    440, // JMB Africa/Luanda
    3840, // JMJ Asia/Shanghai
    4476, // JMK Europe/Athens
    3518, // JMO Asia/Kathmandu
    1405, // JMS America/Chicago
    3840, // JMU Asia/Shanghai
    2759, // JNA America/Sao_Paulo
    320, // JNB Africa/Johannesburg
    3840, // JNG Asia/Shanghai
    802, // JNI America/Argentina/Buenos_Aires
    3646, // JNJ Asia/Muscat
    1936, // JNU America/Juneau
    4476, // JNX Europe/Athens
    3840, // JNZ Asia/Shanghai
    4651, // JOE Europe/Helsinki
    3450, // JOG Asia/Jayapura
    2759, // JOI America/Sao_Paulo
    1300, // JOJ America/Cambridge_Bay
    4880, // JOK Europe/Moscow
    3634, // JOL Asia/Manila
    5584, // JON Pacific/Honolulu
    397, // JOS Africa/Lagos
    1405, // JOT America/Chicago
    1669, // JPA America/Fortaleza
    2555, // JPR America/Porto_Velho
    1705, // JQA America/Godthab
    2440, // JQE America/Panama
    2350, // JQF America/New_York
    5584, // JRF Pacific/Honolulu
    3547, // JRH Asia/Kolkata
    1474, // JRN America/Cuiaba
    207, // JRO Africa/Dar_es_Salaam
    802, // JRZ America/Argentina/Buenos_Aires
    3547, // JSA Asia/Kolkata
    4476, // JSH Europe/Athens
    4476, // JSI Europe/Athens
    std::numeric_limits<uint16_t>::max(), // JSJ
    833, // JSM America/Argentina/Catamarca
    3347, // JSR Asia/Dhaka
    2350, // JST America/New_York
    1705, // JSU America/Godthab
    1405, // JSV America/Chicago
    4476, // JSY Europe/Athens
    2759, // JTC America/Sao_Paulo
    2759, // JTI America/Sao_Paulo
    4476, // JTR Europe/Athens
    4476, // JTY Europe/Athens
    1474, // JUA America/Cuiaba
    340, // JUB Africa/Juba
    3840, // JUH Asia/Shanghai
    4506, // JUI Europe/Berlin
    887, // JUJ America/Argentina/La_Rioja
    2041, // JUL America/Lima
    3518, // JUM Asia/Kathmandu
    4409, // JUR Australia/Perth
    802, // JUS America/Argentina/Buenos_Aires
    1705, // JUV America/Godthab
    3840, // JUZ Asia/Shanghai
    5233, // JVA Indian/Antananarivo
    2350, // JVI America/New_York
    1405, // JVL America/Chicago
    749, // JVM America/Anchorage
    1405, // JVW America/Chicago
    1951, // JVY America/Kentucky/Louisville
    290, // JWA Africa/Gaborone
    1405, // JWG America/Chicago
    3927, // JWN Asia/Tehran
    3840, // JXA Asia/Shanghai
    1562, // JXN America/Detroit
    3840, // JXS Asia/Shanghai
    1562, // JYM America/Detroit
    2350, // JYO America/New_York
    3927, // JYR Asia/Tehran
    4651, // JYV Europe/Helsinki
    3840, // JZH Asia/Shanghai
    2350, // JZI America/New_York
    2350, // JZP America/New_York
    472, // KAA Africa/Lusaka
    472, // KAB Africa/Lusaka
    3333, // KAC Asia/Damascus
    397, // KAD Africa/Lagos
    2777, // KAE America/Sitka
    1793, // KAI America/Guyana
    4651, // KAJ Europe/Helsinki
    749, // KAL America/Anchorage
    3113, // KAM Asia/Aden
    397, // KAN Africa/Lagos
    4651, // KAO Europe/Helsinki
    454, // KAP Africa/Lubumbashi
    1793, // KAR America/Guyana
    720, // KAS Africa/Windhoek
    5372, // KAT Pacific/Auckland
    4062, // KAW Asia/Yangon
    4409, // KAX Australia/Perth
    274, // KBA Africa/Freetown
    749, // KBC America/Anchorage
    352, // KBG Africa/Kampala
    244, // KBI Africa/Douala
    3479, // KBL Asia/Kabul
    454, // KBN Africa/Lubumbashi
    454, // KBO Africa/Lubumbashi
    4735, // KBP Europe/Kiev
    118, // KBQ Africa/Blantyre
    3243, // KBR Asia/Barnaul
    274, // KBS Africa/Freetown
    3620, // KBU Asia/Makassar
    3243, // KBV Asia/Barnaul
    749, // KBW America/Anchorage
    4262, // KBY Australia/Adelaide
    5372, // KBZ Pacific/Auckland
    3991, // KCA Asia/Urumqi
    2475, // KCB America/Paramaribo
    2777, // KCC America/Sitka
    3505, // KCF Asia/Karachi
    749, // KCG America/Anchorage
    3595, // KCH Asia/Kuwait
    3437, // KCK Asia/Irkutsk
    749, // KCL America/Anchorage
    4686, // KCM Europe/Istanbul
    749, // KCQ America/Anchorage
    3320, // KCT Asia/Colombo
    352, // KCU Africa/Kampala
    3952, // KCZ Asia/Tokyo
    194, // KDA Africa/Dakar
    4409, // KDB Australia/Perth
    658, // KDC Africa/Porto-Novo
    3505, // KDD Asia/Karachi
    3479, // KDH Asia/Kabul
    3620, // KDI Asia/Makassar
    410, // KDJ Africa/Libreville
    749, // KDK America/Anchorage
    5081, // KDL Europe/Tallinn
    std::numeric_limits<uint16_t>::max(), // KDM
    410, // KDN Africa/Libreville
    5296, // KDO Indian/Maldives
    5748, // KDR Pacific/Port_Moresby
    3505, // KDU Asia/Karachi
    5487, // KDV Pacific/Fiji
    367, // KDX Africa/Kigali
    3533, // KDY Asia/Khandyga
    749, // KEB America/Anchorage
    621, // KED Africa/Nouakchott
    134, // KEE Africa/Brazzaville
    4207, // KEF Atlantic/Reykjavik
    2054, // KEH America/Los_Angeles
    3671, // KEJ Asia/Novokuznetsk
    749, // KEK America/Anchorage
    4651, // KEM Europe/Helsinki
    274, // KEN Africa/Freetown
    0, // KEO Africa/Abidjan
    std::numeric_limits<uint16_t>::max(), // KEP
    3927, // KER Asia/Tehran
    3040, // KES America/Winnipeg
    4062, // KET Asia/Yangon
    576, // KEU Africa/Nairobi
    3040, // KEW America/Winnipeg
    576, // KEY Africa/Nairobi
    621, // KFA Africa/Nouakchott
    4409, // KFE Australia/Perth
    4339, // KFG Australia/Darwin
    2367, // KFP America/Nome
    4686, // KFS Europe/Istanbul
    454, // KGA Africa/Lubumbashi
    4262, // KGC Australia/Adelaide
    4716, // KGD Europe/Kaliningrad
    5551, // KGE Pacific/Guadalcanal
    3123, // KGF Asia/Almaty
    194, // KGG Africa/Dakar
    4409, // KGI Australia/Perth
    118, // KGJ Africa/Blantyre
    749, // KGK America/Anchorage
    367, // KGL Africa/Kigali
    440, // KGN Africa/Luanda
    4074, // KGP Asia/Yekaterinburg
    4476, // KGS Europe/Athens
    3840, // KGT Asia/Shanghai
    3595, // KGU Asia/Kuwait
    749, // KGX America/Anchorage
    4281, // KGY Australia/Brisbane
    5019, // KHC Europe/Simferopol
    3927, // KHD Asia/Tehran
    4735, // KHE Europe/Kiev
    3991, // KHG Asia/Urumqi
    3888, // KHH Asia/Taipei
    3505, // KHI Asia/Karachi
    3927, // KHK Asia/Tehran
    4062, // KHM Asia/Yangon
    3840, // KHN Asia/Shanghai
    3974, // KHR Asia/Ulaanbaatar
    3646, // KHS Asia/Muscat
    3479, // KHT Asia/Kabul
    4735, // KHU Europe/Kiev
    4032, // KHV Asia/Vladivostok
    290, // KHW Africa/Gaborone
    3927, // KHY Asia/Tehran
    2054, // KIC America/Los_Angeles
    5064, // KID Europe/Stockholm
    5389, // KIE Pacific/Bougainville
    3040, // KIF America/Winnipeg
    3927, // KIH Asia/Tehran
    3952, // KIJ Asia/Tokyo
    320, // KIM Africa/Johannesburg
    1936, // KIN America/Juneau
    std::numeric_limits<uint16_t>::max(), // KIO
    1405, // KIP America/Chicago
    4621, // KIR Europe/Dublin
    576, // KIS Africa/Nairobi
    4476, // KIT Europe/Athens
    4587, // KIV Europe/Chisinau
    472, // KIW Africa/Lusaka
    3952, // KIX Asia/Tokyo
    207, // KIY Africa/Dar_es_Salaam
    3347, // KJA Asia/Dhaka
    3840, // KJH Asia/Shanghai
    3991, // KJI Asia/Urumqi
    4538, // KJK Europe/Brussels
    3952, // KJP Asia/Tokyo
    749, // KKA America/Anchorage
    749, // KKB America/Anchorage
    3243, // KKC Asia/Barnaul
    5748, // KKD Pacific/Port_Moresby
    5372, // KKE Pacific/Auckland
    2367, // KKH America/Nome
    749, // KKI America/Anchorage
    3952, // KKJ Asia/Tokyo
    3243, // KKM Asia/Barnaul
    4894, // KKN Europe/Oslo
    5372, // KKO Pacific/Auckland
    5802, // KKR Pacific/Tahiti
    1405, // KKT America/Chicago
    381, // KKW Africa/Kinshasa
    3952, // KKX Asia/Tokyo
    4621, // KKY Europe/Dublin
    3243, // KKZ Asia/Barnaul
    352, // KLA Africa/Kampala
    472, // KLB Africa/Lusaka
    194, // KLC Africa/Dakar
    4880, // KLD Europe/Moscow
    244, // KLE Africa/Douala
    4880, // KLF Europe/Moscow
    749, // KLG America/Anchorage
    3547, // KLH Asia/Kolkata
    5141, // KLJ Europe/Vilnius
    576, // KLK Africa/Nairobi
    749, // KLL America/Anchorage
    3927, // KLM Asia/Tehran
    749, // KLN America/Anchorage
    3634, // KLO Asia/Manila
    3732, // KLP Asia/Pontianak
    5064, // KLR Europe/Stockholm
    2054, // KLS America/Los_Angeles
    5127, // KLU Europe/Vienna
    4936, // KLV Europe/Prague
    2777, // KLW America/Sitka
    4476, // KLX Europe/Athens
    454, // KLY Africa/Lubumbashi
    320, // KLZ Africa/Johannesburg
    5748, // KMA Pacific/Port_Moresby
    3788, // KMC Asia/Riyadh
    454, // KME Africa/Lubumbashi
    3840, // KMG Asia/Shanghai
    320, // KMH Africa/Johannesburg
    3952, // KMI Asia/Tokyo
    3952, // KMJ Asia/Tokyo
    134, // KMK Africa/Brazzaville
    454, // KMN Africa/Lubumbashi
    749, // KMO America/Anchorage
    720, // KMP Africa/Windhoek
    3952, // KMQ Asia/Tokyo
    15, // KMS Africa/Accra
    3716, // KMT Asia/Phnom_Penh
    543, // KMU Africa/Mogadishu
    4062, // KMV Asia/Yangon
    4880, // KMW Europe/Moscow
    749, // KMY America/Anchorage
    472, // KMZ Africa/Lusaka
    2720, // KNA America/Santiago
    1547, // KNB America/Denver
    454, // KND Africa/Lubumbashi
    3450, // KNG Asia/Jayapura
    3840, // KNH Asia/Shanghai
    4409, // KNI Australia/Perth
    134, // KNJ Africa/Brazzaville
    749, // KNK America/Anchorage
    454, // KNM Africa/Lubumbashi
    179, // KNN Africa/Conakry
    3450, // KNO Asia/Jayapura
    440, // KNP Africa/Luanda
    5699, // KNQ Pacific/Noumea
    4322, // KNS Australia/Currie
    1405, // KNT America/Chicago
    3547, // KNU Asia/Kolkata
    749, // KNW America/Anchorage
    4409, // KNX Australia/Perth
    194, // KNZ Africa/Dakar
    5584, // KOA Pacific/Honolulu
    244, // FOM Africa/Douala
    5699, // KOC Pacific/Noumea
    3620, // KOE Asia/Makassar
    4791, // KOI Europe/London
    3952, // KOJ Asia/Tokyo
    4651, // KOK Europe/Helsinki
    90, // KOL Africa/Banjul
    454, // KOO Africa/Lubumbashi
    3243, // KOP Asia/Barnaul
    4506, // KOQ Europe/Berlin
    3716, // KOS Asia/Phnom_Penh
    2367, // KOT America/Nome
    410, // KOU Africa/Libreville
    3123, // KOV Asia/Almaty
    3840, // KOW Asia/Shanghai
    749, // KOY America/Anchorage
    749, // KOZ America/Anchorage
    2777, // KPB America/Sitka
    2367, // KPC America/Nome
    3595, // KPI Asia/Kuwait
    2367, // KPN America/Nome
    3829, // KPO Asia/Seoul
    749, // KPR America/Anchorage
    4425, // KPS Australia/Sydney
    1286, // KPT America/Boise
    749, // KPV America/Anchorage
    3146, // KPW Asia/Anadyr
    749, // KPY America/Anchorage
    2367, // KQA America/Nome
    4409, // KQR Australia/Perth
    3369, // KQT Asia/Dushanbe
    4389, // KRA Australia/Melbourne
    4281, // KRB Australia/Brisbane
    3450, // KRC Asia/Jayapura
    454, // KRE Africa/Lubumbashi
    5064, // KRF Europe/Stockholm
    1253, // KRG America/Boa_Vista
    4791, // KRH Europe/London
    5748, // KRI Pacific/Port_Moresby
    5173, // KRK Europe/Warsaw
    3991, // KRL Asia/Urumqi
    1793, // KRM America/Guyana
    5064, // KRN Europe/Stockholm
    4074, // KRO Asia/Yekaterinburg
    4603, // KRP Europe/Copenhagen
    4880, // KRR Europe/Moscow
    4894, // KRS Europe/Oslo
    367, // KRT Africa/Kigali
    576, // KRV Africa/Nairobi
    3181, // KRW Asia/Ashgabat
    3991, // KRY Asia/Urumqi
    381, // KRZ Africa/Kinshasa
    std::numeric_limits<uint16_t>::max(), // KSA
    4520, // KSC Europe/Bratislava
    5064, // KSD Europe/Stockholm
    352, // KSE Africa/Kampala
    4506, // KSF Europe/Berlin
    3927, // KSH Asia/Tehran
    179, // KSI Africa/Conakry
    4476, // KSJ Europe/Athens
    5064, // KSK Europe/Stockholm
    367, // KSL Africa/Kigali
    2367, // KSM America/Nome
    3773, // KSN Asia/Qyzylorda
    4476, // KSO Europe/Athens
    3814, // KSQ Asia/Samarkand
    3620, // KSR Asia/Makassar
    76, // KSS Africa/Bamako
    367, // KST Africa/Kigali
    4894, // KSU Europe/Oslo
    4281, // KSV Australia/Brisbane
    4686, // KSY Europe/Istanbul
    4880, // KSZ Europe/Moscow
    4409, // KTA Australia/Perth
    2777, // KTB America/Sitka
    0, // KTC Africa/Abidjan
    3952, // KTD Asia/Tokyo
    3577, // KTE Asia/Kuala_Lumpur
    5372, // KTF Pacific/Auckland
    3732, // KTG Asia/Pontianak
    3716, // KTI Asia/Phnom_Penh
    576, // KTL Africa/Nairobi
    3518, // KTM Asia/Kathmandu
    2777, // KTN America/Sitka
    1793, // KTO America/Guyana
    1936, // KTP America/Juneau
    2367, // KTS America/Nome
    4651, // KTT Europe/Helsinki
    3547, // KTU Asia/Kolkata
    1358, // KTV America/Caracas
    5173, // KTW Europe/Warsaw
    76, // KTX Africa/Bamako
    3577, // KUA Asia/Kuala_Lumpur
    std::numeric_limits<uint16_t>::max(), // KUC
    3595, // KUD Asia/Kuwait
    std::numeric_limits<uint16_t>::max(), // KUE
    4974, // KUF Europe/Samara
    4281, // KUG Australia/Brisbane
    3952, // KUH Asia/Tokyo
    2367, // KUK America/Nome
    3577, // KUL Asia/Kuala_Lumpur
    3952, // KUM Asia/Tokyo
    5141, // KUN Europe/Vilnius
    4651, // KUO Europe/Helsinki
    3479, // KUR Asia/Kabul
    1705, // KUS America/Godthab
    3914, // KUT Asia/Tbilisi
    3547, // KUU Asia/Kolkata
    3829, // KUV Asia/Seoul
    5748, // KUY Pacific/Port_Moresby
    4476, // KVA Europe/Athens
    5064, // KVB Europe/Stockholm
    2367, // KVC America/Nome
    3233, // KVD Asia/Baku
    5748, // KVG Pacific/Port_Moresby
    4880, // KVK Europe/Moscow
    2367, // KVL America/Nome
    3146, // KVM Asia/Anadyr
    4490, // KVO Europe/Belgrade
    4490, // KVS Europe/Belgrade
    4747, // KVX Europe/Kirov
    3450, // KWB Asia/Jayapura
    3840, // KWE Asia/Shanghai
    2777, // KWF America/Sitka
    4735, // KWG Europe/Kiev
    3369, // KWH Asia/Dushanbe
    3595, // KWI Asia/Kuwait
    3829, // KWJ Asia/Seoul
    2367, // KWK America/Nome
    3840, // KWL Asia/Shanghai
    749, // KWN America/Anchorage
    749, // KWP America/Anchorage
    3256, // KWS Asia/Beirut
    749, // KWT America/Anchorage
    576, // KWY Africa/Nairobi
    454, // KWZ Africa/Lubumbashi
    4074, // KXD Asia/Yekaterinburg
    5487, // KXF Pacific/Fiji
    4032, // KXK Asia/Vladivostok
    3888, // KYD Asia/Taipei
    749, // KYK America/Anchorage
    4062, // KYP Asia/Yangon
    76, // KYS Africa/Bamako
    749, // KYU America/Anchorage
    3560, // KYZ Asia/Krasnoyarsk
    749, // KZB America/Anchorage
    4490, // KZC Europe/Belgrade
    3716, // KZD Asia/Phnom_Penh
    4476, // KZI Europe/Athens
    3716, // KZK Asia/Phnom_Penh
    4880, // KZN Europe/Moscow
    3773, // KZO Asia/Qyzylorda
    4686, // KZR Europe/Istanbul
    4686, // KZS Europe/Istanbul
    1547, // LAA America/Denver
    std::numeric_limits<uint16_t>::max(), // LAC
    440, // LAD Africa/Luanda
    5748, // LAE Pacific/Port_Moresby
    1858, // LAF America/Indiana/Knox
    3450, // LAH Asia/Jayapura
    4906, // LAI Europe/Paris
    2759, // LAJ America/Sao_Paulo
    3073, // LAK America/Yellowknife
    2350, // LAL America/New_York
    1547, // LAM America/Denver
    1562, // LAN America/Detroit
    std::numeric_limits<uint16_t>::max(), // LAO
    2157, // LAP America/Mazatlan
    692, // LAQ Africa/Tripoli
    1547, // LAR America/Denver
    2054, // LAS America/Los_Angeles
    576, // LAU Africa/Nairobi
    1405, // LAW America/Chicago
    2054, // LAX America/Los_Angeles
    320, // LAY Africa/Johannesburg
    1149, // LAZ America/Bahia
    4791, // LBA Europe/London
    1405, // LBB America/Chicago
    4506, // LBC Europe/Berlin
    3369, // LBD Asia/Dushanbe
    2350, // LBE America/New_York
    1405, // LBF America/Chicago
    4906, // LBG Europe/Paris
    3620, // LBJ Asia/Makassar
    576, // LBK Africa/Nairobi
    1405, // LBL America/Chicago
    576, // LBN Africa/Nairobi
    454, // LBO Africa/Lubumbashi
    3595, // LBP Asia/Kuwait
    410, // LBQ Africa/Libreville
    2105, // LBR America/Manaus
    5487, // LBS Pacific/Fiji
    2350, // LBT America/New_York
    std::numeric_limits<uint16_t>::max(), // LBU
    410, // LBV Africa/Libreville
    3595, // LBW Asia/Kuwait
    3634, // LBX Asia/Manila
    440, // LBZ Africa/Luanda
    3658, // LCA Asia/Nicosia
    1474, // LCB America/Cuiaba
    4962, // LCC Europe/Rome
    2901, // LCE America/Tegucigalpa
    1775, // LCF America/Guatemala
    4823, // LCG Europe/Madrid
    1405, // LCH America/Chicago
    2350, // LCI America/New_York
    5173, // LCJ Europe/Warsaw
    2350, // LCK America/New_York
    1824, // LCL America/Havana
    861, // LCM America/Argentina/Cordoba
    134, // LCO Africa/Brazzaville
    2350, // LCQ America/New_York
    1271, // LCR America/Bogota
    4962, // LCV Europe/Rome
    3840, // LCX Asia/Shanghai
    4791, // LCY Europe/London
    3547, // LDA Asia/Kolkata
    2759, // LDB America/Sao_Paulo
    4906, // LDE Europe/Paris
    4880, // LDG Europe/Moscow
    std::numeric_limits<uint16_t>::max(), // LDH
    207, // LDI Africa/Dar_es_Salaam
    2350, // LDJ America/New_York
    5064, // LDK Europe/Stockholm
    1562, // LDM America/Detroit
    3518, // LDN Asia/Kathmandu
    2475, // LDO America/Paramaribo
    3840, // LDS Asia/Shanghai
    3595, // LDU Asia/Kuwait
    2475, // LDX America/Paramaribo
    4621, // LDY Europe/Dublin
    2350, // LEB America/New_York
    1149, // LEC America/Bahia
    4880, // LED Europe/Moscow
    2350, // LEE America/New_York
    514, // LEF Africa/Maseru
    4906, // LEH Europe/Paris
    4823, // LEI Europe/Madrid
    4506, // LEJ Europe/Berlin
    179, // LEK Africa/Conakry
    4339, // LEL Australia/Darwin
    4823, // LEN Europe/Madrid
    2759, // LEP America/Sao_Paulo
    4791, // LEQ Europe/London
    4409, // LER Australia/Perth
    4490, // LES Europe/Belgrade
    1271, // LET America/Bogota
    4823, // LEU Europe/Madrid
    5487, // LEV Pacific/Fiji
    2350, // LEW America/New_York
    2350, // LEX America/New_York
    4442, // LEY Europe/Amsterdam
    2901, // LEZ America/Tegucigalpa
    500, // LFB Africa/Maputo
    1405, // LFK America/Chicago
    3927, // LFM Asia/Tehran
    2350, // LFN America/New_York
    3840, // LFQ Asia/Shanghai
    1358, // LFR America/Caracas
    1405, // LFT America/Chicago
    428, // LFW Africa/Lome
    2350, // LGA America/New_York
    2054, // LGB America/Los_Angeles
    2350, // LGC America/New_York
    2054, // LGD America/Los_Angeles
    4409, // LGE Australia/Perth
    4538, // LGG Europe/Brussels
    4262, // LGH Australia/Adelaide
    2335, // LGI America/Nassau
    std::numeric_limits<uint16_t>::max(), // LGK
    3595, // LGL Asia/Kuwait
    833, // LGM America/Argentina/Catamarca
    4506, // LGO Europe/Berlin
    3634, // LGP Asia/Manila
    1793, // LGQ America/Guyana
    2720, // LGR America/Santiago
    914, // LGS America/Argentina/Mendoza
    1271, // LGT America/Bogota
    1547, // LGU America/Denver
    4791, // LGW Europe/London
    543, // LGX Africa/Mogadishu
    4791, // LHB Europe/London
    1271, // LHC America/Bogota
    749, // LHD America/Anchorage
    3505, // LHE Asia/Karachi
    4425, // LHG Australia/Sydney
    2054, // LHM America/Los_Angeles
    4791, // LHR Europe/London
    940, // LHS America/Argentina/Rio_Gallegos
    2350, // LHV America/New_York
    3840, // LHW Asia/Shanghai
    1547, // LHX America/Denver
    3840, // LIA Asia/Shanghai
    90, // LIE Africa/Banjul
    5699, // LIF Pacific/Noumea
    4906, // LIG Europe/Paris
    5584, // LIH Pacific/Honolulu
    5638, // LIK Pacific/Majuro
    4906, // LIL Europe/Paris
    2041, // LIM America/Lima
    4962, // LIN Europe/Rome
    1439, // LIO America/Costa_Rica
    2759, // LIP America/Sao_Paulo
    381, // LIQ Africa/Kinshasa
    1439, // LIR America/Costa_Rica
    4760, // LIS Europe/Lisbon
    1405, // LIT America/Chicago
    1405, // LIU America/Chicago
    4062, // LIW Asia/Yangon
    500, // LIX Africa/Maputo
    2350, // LIZ America/New_York
    454, // LJA Africa/Lubumbashi
    3840, // LJG Asia/Shanghai
    1405, // LJN America/Chicago
    4774, // LJU Europe/Ljubljana
    3620, // LKA Asia/Makassar
    5487, // LKB Pacific/Fiji
    2054, // LKE America/Los_Angeles
    576, // LKG Africa/Nairobi
    3595, // LKH Asia/Kuwait
    749, // LKK America/Anchorage
    4894, // LKL Europe/Oslo
    4894, // LKN Europe/Oslo
    3547, // LKO Asia/Kolkata
    2350, // LKP America/New_York
    2350, // LKR America/New_York
    2054, // LKV America/Los_Angeles
    3358, // LKW Asia/Dubai
    207, // LKY Africa/Dar_es_Salaam
    5064, // LLA Europe/Stockholm
    3840, // LLB Asia/Shanghai
    320, // LLE Africa/Johannesburg
    3840, // LLF Asia/Shanghai
    3450, // LLG Asia/Jayapura
    2901, // LLH America/Tegucigalpa
    28, // LLI Africa/Addis_Ababa
    3347, // LLJ Asia/Dhaka
    3233, // LLK Asia/Baku
    3620, // LLO Asia/Makassar
    1405, // LLQ America/Chicago
    2054, // LLR America/Los_Angeles
    861, // LLS America/Argentina/Cordoba
    440, // LLT Africa/Luanda
    1405, // LLU America/Chicago
    3840, // LLV Asia/Shanghai
    118, // LLW Africa/Blantyre
    2350, // LLX America/New_York
    2350, // LLY America/New_York
    118, // LMB Africa/Blantyre
    1271, // LMC America/Bogota
    4906, // LME Europe/Paris
    5638, // LML Pacific/Majuro
    2157, // LMM America/Mazatlan
    3281, // LMN Asia/Brunei
    4962, // LMP Europe/Rome
    692, // LMQ Africa/Tripoli
    320, // LMR Africa/Johannesburg
    1405, // LMS America/Chicago
    2054, // LMT America/Los_Angeles
    5748, // LMY Pacific/Port_Moresby
    2350, // LNA America/New_York
    5455, // LNB Pacific/Efate
    1405, // LNC America/Chicago
    1547, // LND America/Denver
    5455, // LNE Pacific/Efate
    749, // LNI America/Anchorage
    3840, // LNJ Asia/Shanghai
    2174, // LNL America/Menominee
    2350, // LNN America/New_York
    4409, // LNO Australia/Perth
    2350, // LNP America/New_York
    1405, // LNR America/Chicago
    2350, // LNS America/New_York
    5748, // LNV Pacific/Port_Moresby
    4880, // LNX Europe/Moscow
    5584, // LNY Pacific/Honolulu
    5127, // LNZ Europe/Vienna
    2720, // LOB America/Santiago
    5455, // LOD Pacific/Efate
    3243, // LOE Asia/Barnaul
    1793, // LOH America/Guyana
    2759, // LOI America/Sao_Paulo
    576, // LOK Africa/Nairobi
    2054, // LOL America/Los_Angeles
    2226, // LOM America/Mexico_City
    3410, // LON Asia/Ho_Chi_Minh
    47, // LOO Africa/Algiers
    3620, // LOP Asia/Makassar
    290, // LOQ Africa/Gaborone
    397, // LOS Africa/Lagos
    1405, // LOT America/Chicago
    1951, // LOU America/Kentucky/Louisville
    2279, // LOV America/Monterrey
    2350, // LOW America/New_York
    576, // LOY Africa/Nairobi
    2350, // LOZ America/New_York
    4139, // LPA Atlantic/Canary
    2026, // LPB America/La_Paz
    2054, // LPC America/Los_Angeles
    1271, // LPD America/Bogota
    1271, // LPE America/Bogota
    3840, // LPF Asia/Shanghai
    802, // LPG America/Argentina/Buenos_Aires
    5064, // LPI Europe/Stockholm
    4880, // LPK Europe/Moscow
    4791, // LPL Europe/London
    5455, // LPM Pacific/Efate
    1405, // LPO America/Chicago
    4651, // LPP Europe/Helsinki
    4017, // LPQ Asia/Vientiane
    2350, // LPR America/New_York
    2054, // LPS America/Los_Angeles
    3243, // LPT Asia/Barnaul
    std::numeric_limits<uint16_t>::max(), // LPU
    4950, // LPX Europe/Riga
    4906, // LPY Europe/Paris
    2350, // LQK America/New_York
    1271, // LQM America/Bogota
    3479, // LQN Asia/Kabul
    4476, // LRA Europe/Athens
    320, // LRB Africa/Johannesburg
    std::numeric_limits<uint16_t>::max(), // LRD
    4281, // LRE Australia/Brisbane
    2350, // LRG America/New_York
    4906, // LRH Europe/Paris
    1405, // LRJ America/Chicago
    428, // LRL Africa/Lome
    2737, // LRM America/Santo_Domingo
    2350, // LRO America/New_York
    3040, // LRQ America/Winnipeg
    3927, // LRR Asia/Tehran
    4476, // LRS Europe/Athens
    4906, // LRT Europe/Paris
    1547, // LRU America/Denver
    1358, // LRV America/Caracas
    5748, // LSA Pacific/Port_Moresby
    2720, // LSC America/Santiago
    1405, // LSE America/Chicago
    4062, // LSH Asia/Yangon
    4791, // LSI Europe/London
    2089, // LSL America/Managua
    std::numeric_limits<uint16_t>::max(), // LSM
    2054, // LSN America/Los_Angeles
    4906, // LSO Europe/Paris
    1358, // LSP America/Caracas
    2720, // LSQ America/Santiago
    2367, // LSR America/Nome
    1756, // LSS America/Guadeloupe
    4372, // LST Australia/Hobart
    3281, // LSU Asia/Brunei
    3450, // LSW Asia/Jayapura
    4425, // LSY Australia/Sydney
    5187, // LSZ Europe/Zagreb
    320, // LTA Africa/Johannesburg
    591, // LTC Africa/Ndjamena
    692, // LTD Africa/Tripoli
    3427, // LTI Asia/Hovd
    3333, // LTK Asia/Damascus
    410, // LTL Africa/Libreville
    1253, // LTM America/Boa_Vista
    4791, // LTN Europe/London
    2157, // LTO America/Mazatlan
    4906, // LTQ Europe/Paris
    4906, // LTT Europe/Paris
    3547, // LTU Asia/Kolkata
    2350, // LTW America/New_York
    1793, // LTX America/Guyana
    1547, // LTY America/Denver
    3518, // LUA Asia/Kathmandu
    1793, // LUB America/Guyana
    5487, // LUC Pacific/Fiji
    720, // LUD Africa/Windhoek
    4962, // LUG Europe/Rome
    3547, // LUH Asia/Kolkata
    2901, // LUI America/Tegucigalpa
    2350, // LUK America/New_York
    1405, // LUL America/Chicago
    3840, // LUM Asia/Shanghai
    472, // LUN Africa/Lusaka
    440, // LUO Africa/Luanda
    5584, // LUP Pacific/Honolulu
    1022, // LUQ America/Argentina/San_Luis
    2367, // LUR America/Nome
    381, // LUS Africa/Kinshasa
    4281, // LUU Australia/Brisbane
    3450, // LUV Asia/Jayapura
    3620, // LUW Asia/Makassar
    4805, // LUX Europe/Luxembourg
    5173, // LUZ Europe/Warsaw
    4906, // LVA Europe/Paris
    2759, // LVB America/Sao_Paulo
    472, // LVI Africa/Lusaka
    2054, // LVK America/Los_Angeles
    1547, // LVM America/Denver
    1405, // LVN America/Chicago
    4409, // LVO Australia/Perth
    3927, // LVP Asia/Tehran
    1474, // LVR America/Cuiaba
    1547, // LVS America/Denver
    2350, // LWB America/New_York
    1405, // LWC America/Chicago
    3620, // LWE Asia/Makassar
    4791, // LWK Europe/London
    2054, // LWL America/Los_Angeles
    2350, // LWM America/New_York
    4686, // LWN Europe/Istanbul
    4735, // LWO Europe/Kiev
    2054, // LWS America/Los_Angeles
    1547, // LWT America/Denver
    1405, // LWV America/Chicago
    3595, // LWY Asia/Kuwait
    3840, // LXA Asia/Shanghai
    4017, // LXG Asia/Vientiane
    1405, // LXL America/Chicago
    1405, // LXN America/Chicago
    153, // LXR Africa/Cairo
    4476, // LXS Europe/Athens
    472, // LXU Africa/Lusaka
    1547, // LXV America/Denver
    3840, // LYA Asia/Shanghai
    1390, // LYB America/Cayman
    5064, // LYC Europe/Stockholm
    3840, // LYG Asia/Shanghai
    2350, // LYH America/New_York
    3840, // LYI Asia/Shanghai
    4791, // LYM Europe/London
    4906, // LYN Europe/Paris
    3505, // LYP Asia/Karachi
    3093, // LYR Arctic/Longyearbyen
    4906, // LYS Europe/Paris
    1405, // LYU America/Chicago
    4791, // LYX Europe/London
    454, // LZA Africa/Lubumbashi
    2226, // LZC America/Mexico_City
    2350, // LZD America/New_York
    3840, // LZH Asia/Shanghai
    440, // LZM Africa/Luanda
    3840, // LZN Asia/Shanghai
    3840, // LZO Asia/Shanghai
    4281, // LZR Australia/Brisbane
    2350, // LZU America/New_York
    3840, // LZY Asia/Shanghai
    3547, // MAA Asia/Kolkata
    1203, // MAB America/Belem
    2350, // MAC America/New_York
    4823, // MAD Europe/Madrid
    2054, // MAE America/Los_Angeles
    1405, // MAF America/Chicago
    5748, // MAG Pacific/Port_Moresby
    4823, // MAH Europe/Madrid
    118, // MAI Africa/Blantyre
    5638, // MAJ Pacific/Majuro
    340, // MAK Africa/Juba
    2350, // MAL America/New_York
    2139, // MAM America/Matamoros
    4791, // MAN Europe/London
    2105, // MAO America/Manaus
    4062, // MAQ Asia/Yangon
    1358, // MAR America/Caracas
    5748, // MAS Pacific/Port_Moresby
    381, // MAT Africa/Kinshasa
    5802, // MAU Pacific/Tahiti
    5638, // MAV Pacific/Majuro
    1405, // MAW America/Chicago
    194, // MAX Africa/Dakar
    2335, // MAY America/Nassau
    2575, // MAZ America/Puerto_Rico
    576, // MBA Africa/Nairobi
    410, // MBC Africa/Libreville
    290, // MBD Africa/Gaborone
    3952, // MBE Asia/Tokyo
    1547, // MBG America/Denver
    4281, // MBH Australia/Brisbane
    207, // MBI Africa/Dar_es_Salaam
    1936, // MBJ America/Juneau
    1474, // MBK America/Cuiaba
    1562, // MBL America/Detroit
    3634, // MBO Asia/Manila
    2041, // MBP America/Lima
    352, // MBQ Africa/Kampala
    1562, // MBS America/Detroit
    3634, // MBT Asia/Manila
    5551, // MBU Pacific/Guadalcanal
    4389, // MBW Australia/Melbourne
    4774, // MBX Europe/Ljubljana
    3634, // MBY Asia/Manila
    2105, // MBZ America/Manaus
    179, // MCA Africa/Conakry
    1405, // MCB America/Chicago
    2054, // MCC America/Los_Angeles
    1562, // MCD America/Detroit
    2054, // MCE America/Los_Angeles
    749, // MCG America/Anchorage
    1793, // MCH America/Guyana
    1405, // MCI America/Chicago
    1271, // MCJ America/Bogota
    1405, // MCK America/Chicago
    749, // MCL America/Anchorage
    2350, // MCN America/New_York
    2350, // MCO America/New_York
    1203, // MCP America/Belem
    4571, // MCQ Europe/Budapest
    861, // MCS America/Argentina/Cordoba
    3646, // MCT Asia/Muscat
    4906, // MCU Europe/Paris
    4339, // MCV Australia/Darwin
    1405, // MCW America/Chicago
    4880, // MCX Europe/Moscow
    4281, // MCY Australia/Brisbane
    2074, // MCZ America/Maceio
    1217, // MDB America/Belize
    3620, // MDC Asia/Makassar
    1405, // MDD America/Chicago
    1271, // MDE America/Bogota
    1405, // MDF America/Chicago
    3840, // MDG Asia/Shanghai
    1405, // MDH America/Chicago
    397, // MDI Africa/Lagos
    2054, // MDJ America/Los_Angeles
    381, // MDK Africa/Kinshasa
    4062, // MDL Asia/Yangon
    1858, // MDN America/Indiana/Knox
    749, // MDO America/Anchorage
    802, // MDQ America/Argentina/Buenos_Aires
    1721, // MDS America/Grand_Turk
    2350, // MDT America/New_York
    5748, // MDU Pacific/Port_Moresby
    486, // MDV Africa/Malabo
    1405, // MDW America/Chicago
    861, // MDX America/Argentina/Cordoba
    5671, // MDY Pacific/Midway
    914, // MDZ America/Argentina/Mendoza
    2759, // MEA America/Sao_Paulo
    4389, // MEB Australia/Melbourne
    1793, // MEC America/Guyana
    3788, // MED Asia/Riyadh
    5699, // MEE Pacific/Noumea
    591, // MEF Africa/Ndjamena
    440, // MEG Africa/Luanda
    4894, // MEH Europe/Oslo
    1405, // MEI America/Chicago
    2350, // MEJ America/New_York
    4389, // MEL Australia/Melbourne
    1405, // MEM America/Chicago
    4906, // MEN Europe/Paris
    2350, // MEO America/New_York
    3577, // MEP Asia/Kuala_Lumpur
    3450, // MEQ Asia/Jayapura
    2054, // MER America/Los_Angeles
    2703, // MEU America/Santarem
    2054, // MEV America/Los_Angeles
    454, // MEW Africa/Lubumbashi
    2226, // MEX America/Mexico_City
    3518, // MEY Asia/Kathmandu
    1405, // MEZ America/Chicago
    207, // MFA Africa/Dar_es_Salaam
    std::numeric_limits<uint16_t>::max(), // MFC
    2350, // MFD America/New_York
    1405, // MFE America/Chicago
    410, // MFF Africa/Libreville
    3505, // MFG Asia/Karachi
    2054, // MFH America/Los_Angeles
    1405, // MFI America/Chicago
    5487, // MFJ Pacific/Fiji
    3840, // MFK Asia/Shanghai
    3840, // MFM Asia/Shanghai
    5372, // MFN Pacific/Auckland
    5748, // MFO Pacific/Port_Moresby
    607, // MFQ Africa/Niamey
    2054, // MFR America/Los_Angeles
    1271, // MFS America/Bogota
    472, // MFU Africa/Lusaka
    2350, // MFV America/New_York
    4906, // MFX Europe/Paris
    2089, // MGA America/Managua
    4262, // MGB Australia/Adelaide
    1405, // MGC America/Chicago
    2026, // MGD America/La_Paz
    1271, // MGE America/Bogota
    2759, // MGF America/Sao_Paulo
    1405, // MGG America/Chicago
    320, // MGH Africa/Johannesburg
    802, // MGI America/Argentina/Buenos_Aires
    2350, // MGJ America/New_York
    4506, // MGL Europe/Berlin
    1405, // MGM America/Chicago
    1271, // MGN America/Bogota
    543, // MGQ Africa/Mogadishu
    2350, // MGR America/New_York
    4339, // MGT Australia/Darwin
    4409, // MGV Australia/Perth
    2350, // MGW America/New_York
    410, // MGX Africa/Libreville
    2350, // MGY America/New_York
    4062, // MGZ Asia/Yangon
    1793, // MHA America/Guyana
    2720, // MHC America/Santiago
    3927, // MHD Asia/Tehran
    1405, // MHE America/Chicago
    2335, // MHH America/Nassau
    228, // MHI Africa/Djibouti
    1405, // MHK America/Chicago
    1405, // MHL America/Chicago
    749, // MHM America/Anchorage
    4867, // MHP Europe/Minsk
    4850, // MHQ Europe/Mariehamn
    2054, // MHR America/Los_Angeles
    2054, // MHS America/Los_Angeles
    2350, // MHT America/New_York
    4389, // MHU Australia/Melbourne
    2054, // MHV America/Los_Angeles
    2026, // MHW America/La_Paz
    5769, // MHX Pacific/Rarotonga
    2350, // MIA America/New_York
    1405, // MIC America/Chicago
    2192, // MID America/Merida
    1858, // MIE America/Indiana/Knox
    3840, // MIG Asia/Shanghai
    2759, // MII America/Sao_Paulo
    std::numeric_limits<uint16_t>::max(), // MIJ
    4651, // MIK Europe/Helsinki
    4425, // MIM Australia/Sydney
    1405, // MIO America/Chicago
    3464, // MIP Asia/Jerusalem
    1405, // MIQ America/Chicago
    707, // MIR Africa/Tunis
    5748, // MIS Pacific/Port_Moresby
    2054, // MIT America/Los_Angeles
    397, // MIU Africa/Lagos
    2350, // MIV America/New_York
    5233, // MJA Indian/Antananarivo
    std::numeric_limits<uint16_t>::max(), // MJB
    0, // MJC Africa/Abidjan
    3505, // MJD Asia/Karachi
    std::numeric_limits<uint16_t>::max(), // MJE
    4894, // MJF Europe/Oslo
    692, // MJI Africa/Tripoli
    4409, // MJK Australia/Perth
    410, // MJL Africa/Libreville
    454, // MJM Africa/Lubumbashi
    5233, // MJN Indian/Antananarivo
    720, // MJO Africa/Windhoek
    4409, // MJP Australia/Perth
    1405, // MJQ America/Chicago
    802, // MJR America/Argentina/Buenos_Aires
    4476, // MJT Europe/Athens
    3620, // MJU Asia/Makassar
    4823, // MJV Europe/Madrid
    2350, // MJX America/New_York
    4049, // MJZ Asia/Yakutsk
    4936, // MKA Europe/Prague
    410, // MKB Africa/Libreville
    1405, // MKC America/Chicago
    1405, // MKE America/Chicago
    1562, // MKG America/Detroit
    514, // MKH Africa/Maseru
    90, // MKI Africa/Banjul
    134, // MKJ Africa/Brazzaville
    5584, // MKK Pacific/Honolulu
    1405, // MKL America/Chicago
    3595, // MKM Asia/Kuwait
    1405, // MKN America/Chicago
    1405, // MKO America/Chicago
    3450, // MKQ Asia/Jayapura
    4409, // MKR Australia/Perth
    28, // MKS Africa/Addis_Ababa
    1405, // MKT America/Chicago
    410, // MKU Africa/Libreville
    3450, // MKW Asia/Jayapura
    4281, // MKY Australia/Brisbane
    3577, // MKZ Asia/Kuala_Lumpur
    4837, // MLA Europe/Malta
    2350, // MLB America/New_York
    1405, // MLC America/Chicago
    5296, // MLE Indian/Maldives
    3450, // MLG Asia/Jayapura
    4906, // EAP Europe/Paris
    1405, // MLI America/Chicago
    2350, // MLJ America/New_York
    1547, // MLK America/Denver
    2367, // MLL America/Nome
    2226, // MLM America/Mexico_City
    166, // MLN Africa/Ceuta
    4476, // MLO Europe/Athens
    3634, // MLP Asia/Manila
    1547, // MLS America/Denver
    2350, // MLT America/New_York
    1405, // MLU America/Chicago
    560, // MLW Africa/Monrovia
    749, // MLY America/Anchorage
    2297, // MLZ America/Montevideo
    std::numeric_limits<uint16_t>::max(), // MMA
    3952, // MMB Asia/Tokyo
    2279, // MMC America/Monterrey
    std::numeric_limits<uint16_t>::max(), // MMD
    4791, // MME Europe/London
    244, // MMF Africa/Douala
    4409, // MMG Australia/Perth
    2054, // MMH America/Los_Angeles
    2350, // MMI America/New_York
    3952, // MMJ Asia/Tokyo
    4880, // MMK Europe/Moscow
    1405, // MML America/Chicago
    4281, // MMM Australia/Brisbane
    2350, // MMN America/New_York
    4155, // MMO Atlantic/Cape_Verde
    1271, // MMP America/Bogota
    472, // MMQ Africa/Lusaka
    2350, // MMT America/New_York
    2350, // MMU America/New_York
    2054, // MMV America/Los_Angeles
    5064, // MMX Europe/Stockholm
    3952, // MMY Asia/Tokyo
    3479, // MMZ Asia/Kabul
    3620, // MNA Asia/Makassar
    381, // MNB Africa/Kinshasa
    500, // MNC Africa/Maputo
    5487, // MNF Pacific/Fiji
    4339, // MNG Australia/Darwin
    3320, // MNH Asia/Colombo
    2316, // MNI America/Montserrat
    5233, // MNJ Indian/Antananarivo
    std::numeric_limits<uint16_t>::max(), // MNK
    3634, // MNL Asia/Manila
    2174, // MNM America/Menominee
    2350, // MNN America/New_York
    4281, // MNQ Australia/Brisbane
    472, // MNR Africa/Lusaka
    472, // MNS Africa/Lusaka
    749, // MNT America/Anchorage
    4062, // MNU Asia/Yangon
    2350, // MNV America/New_York
    2105, // MNX America/Manaus
    std::numeric_limits<uint16_t>::max(), // MNY
    2350, // MNZ America/New_York
    1824, // MOA America/Havana
    1405, // MOB America/Chicago
    2759, // MOC America/Sao_Paulo
    2054, // MOD America/Los_Angeles
    4062, // MOE Asia/Yangon
    3620, // MOF Asia/Makassar
    4062, // MOG Asia/Yangon
    5769, // MOI Pacific/Rarotonga
    2475, // MOJ America/Paramaribo
    4894, // MOL Europe/Oslo
    621, // MOM Africa/Nouakchott
    5372, // MON Pacific/Auckland
    4262, // MOO Australia/Adelaide
    1562, // MOP America/Detroit
    5233, // MOQ Indian/Antananarivo
    2350, // MOR America/New_York
    2367, // MOS America/Nome
    1405, // MOT America/Chicago
    2367, // MOU America/Nome
    4281, // MOV Australia/Brisbane
    5802, // MOZ Pacific/Tahiti
    472, // MPA Africa/Lusaka
    2350, // MPB America/New_York
    3505, // MPD Asia/Karachi
    2350, // MPE America/New_York
    2350, // MPG America/New_York
    3634, // MPH Asia/Manila
    1405, // MPJ America/Chicago
    3829, // MPK Asia/Seoul
    4906, // MPL Europe/Paris
    500, // MPM Africa/Maputo
    2350, // MPO America/New_York
    2440, // MPP America/Panama
    1405, // MPS America/Chicago
    2350, // MPV America/New_York
    4735, // MPW Europe/Kiev
    2475, // MPY America/Paramaribo
    1405, // MPZ America/Chicago
    1405, // MQB America/Chicago
    2246, // MQC America/Miquelon
    971, // MQD America/Argentina/Salta
    4074, // MQF Asia/Yekaterinburg
    2759, // MQH America/Sao_Paulo
    3869, // MQJ Asia/Srednekolymsk
    1474, // MQK America/Cuiaba
    4425, // MQL Australia/Sydney
    4686, // MQM Europe/Istanbul
    4894, // MQN Europe/Oslo
    320, // MQP Africa/Johannesburg
    591, // MQQ Africa/Ndjamena
    2882, // MQS America/St_Vincent
    1562, // MQT America/Detroit
    1271, // MQU America/Bogota
    47, // MQV Africa/Algiers
    2350, // MQW America/New_York
    28, // MQX Africa/Addis_Ababa
    1405, // MQY America/Chicago
    4409, // MQZ Australia/Perth
    692, // MRA Africa/Tripoli
    2350, // MRB America/New_York
    1405, // MRC America/Chicago
    1358, // MRD America/Caracas
    576, // MRE Africa/Nairobi
    1405, // MRF America/Chicago
    4281, // MRG Australia/Brisbane
    2350, // MRH America/New_York
    749, // MRI America/Anchorage
    2901, // MRJ America/Tegucigalpa
    2350, // MRK America/New_York
    2350, // MRN America/New_York
    5372, // MRO Pacific/Auckland
    3634, // MRQ Asia/Manila
    1793, // MRR America/Guyana
    4906, // MRS Europe/Paris
    2350, // MRT America/New_York
    5312, // MRU Indian/Mauritius
    4880, // MRV Europe/Moscow
    4603, // MRW Europe/Copenhagen
    3927, // MRX Asia/Tehran
    2054, // MRY America/Los_Angeles
    4425, // MRZ Australia/Sydney
    3040, // MSA America/Winnipeg
    2494, // MSC America/Phoenix
    1547, // MSD America/Denver
    4791, // MSE Europe/London
    4339, // MSF Australia/Darwin
    514, // MSG Africa/Maseru
    3952, // MSJ Asia/Tokyo
    1405, // MSL America/Chicago
    381, // MSM Africa/Kinshasa
    3634, // MSN Asia/Manila
    1547, // MSO America/Denver
    1405, // MSP America/Chicago
    4867, // MSQ Europe/Minsk
    std::numeric_limits<uint16_t>::max(), // MSS
    4538, // MST Europe/Brussels
    320, // MSU Africa/Johannesburg
    2350, // MSV America/New_York
    62, // MSW Africa/Asmara
    134, // MSX Africa/Brazzaville
    1405, // MSY America/Chicago
    440, // MSZ Africa/Luanda
    5372, // MTA Pacific/Auckland
    1271, // MTB America/Bogota
    28, // MTF Africa/Addis_Ababa
    1474, // MTG America/Cuiaba
    2350, // MTH America/New_York
    4155, // MTI Atlantic/Cape_Verde
    1547, // MTJ America/Denver
    5817, // MTK Pacific/Tarawa
    4425, // MTL Australia/Sydney
    std::numeric_limits<uint16_t>::max(), // MTM
    2350, // MTN America/New_York
    1405, // MTO America/Chicago
    2350, // MTP America/New_York
    4281, // MTQ Australia/Brisbane
    1271, // MTR America/Bogota
    528, // MTS Africa/Mbabane
    2226, // MTT America/Mexico_City
    5455, // MTV Pacific/Efate
    1405, // MTW America/Chicago
    2279, // MTY America/Monterrey
    3398, // MTZ Asia/Hebron
    5551, // MUA Pacific/Guadalcanal
    290, // MUB Africa/Gaborone
    4506, // MUC Europe/Berlin
    500, // MUD Africa/Maputo
    5584, // MUE Pacific/Honolulu
    2157, // MUG America/Mazatlan
    153, // MUH Africa/Cairo
    28, // MUJ Africa/Addis_Ababa
    2350, // MUL America/New_York
    1358, // MUN America/Caracas
    3595, // MUR Asia/Kuwait
    std::numeric_limits<uint16_t>::max(), // MUS
    1405, // MUT America/Chicago
    47, // MUW Africa/Algiers
    3505, // MUX Asia/Karachi
    134, // MUY Africa/Brazzaville
    207, // MUZ Africa/Dar_es_Salaam
    4207, // MVA Atlantic/Reykjavik
    410, // MVB Africa/Libreville
    1405, // MVC America/Chicago
    2297, // MVD America/Montevideo
    1405, // MVE America/Chicago
    1669, // MVF America/Fortaleza
    2350, // MVL America/New_York
    1547, // MVM America/Denver
    1405, // MVN America/Chicago
    591, // MVO Africa/Ndjamena
    1271, // MVP America/Bogota
    4867, // MVQ Europe/Minsk
    244, // MVR Africa/Douala
    1149, // MVS America/Bahia
    4906, // MVV Europe/Paris
    2054, // MVW America/Los_Angeles
    410, // MVX Africa/Libreville
    2350, // MVY America/New_York
    306, // MVZ Africa/Harare
    1405, // MWA America/Chicago
    4409, // MWB Australia/Perth
    1405, // MWC America/Chicago
    367, // MWE Africa/Kigali
    5455, // MWF Pacific/Efate
    2054, // MWH America/Los_Angeles
    3450, // MWK Asia/Jayapura
    1405, // MWL America/Chicago
    207, // MWN Africa/Dar_es_Salaam
    2350, // MWO America/New_York
    4062, // MWQ Asia/Yangon
    3716, // MWV Asia/Phnom_Penh
    3829, // MWX Asia/Seoul
    207, // MWZ Africa/Dar_es_Salaam
    1405, // MXA America/Chicago
    3620, // MXB Asia/Makassar
    1547, // MXC America/Denver
    2350, // MXE America/New_York
    2350, // MXG America/New_York
    5748, // MXH Pacific/Port_Moresby
    3634, // MXI Asia/Manila
    397, // MXJ Africa/Lagos
    std::numeric_limits<uint16_t>::max(), // MXL
    5233, // MXM Indian/Antananarivo
    4906, // MXN Europe/Paris
    1405, // MXO America/Chicago
    4962, // MXP Europe/Rome
    591, // MXR Africa/Ndjamena
    5359, // MXS Pacific/Apia
    5233, // MXT Indian/Antananarivo
    4409, // MXU Australia/Perth
    3974, // MXV Asia/Ulaanbaatar
    3974, // MXW Asia/Ulaanbaatar
    5064, // MXX Europe/Stockholm
    749, // MXY America/Anchorage
    3840, // MXZ Asia/Shanghai
    4425, // MYA Australia/Sydney
    410, // MYB Africa/Libreville
    591, // MYC Africa/Ndjamena
    576, // MYD Africa/Nairobi
    3952, // MYE Asia/Tokyo
    2054, // MYF America/Los_Angeles
    2335, // MYG America/Nassau
    2494, // MYH America/Phoenix
    4281, // MYI Australia/Brisbane
    3952, // MYJ Asia/Tokyo
    749, // MYK America/Anchorage
    1286, // MYL America/Boise
    1793, // MYM America/Guyana
    3113, // MYN Asia/Aden
    3181, // MYP Asia/Ashgabat
    3547, // MYQ Asia/Kolkata
    2350, // MYR America/New_York
    4062, // MYT Asia/Yangon
    2367, // MYU America/Nome
    2054, // MYV America/Los_Angeles
    207, // MYW Africa/Dar_es_Salaam
    2335, // MYX America/Nassau
    3595, // MYY Asia/Kuwait
    118, // MYZ Africa/Blantyre
    2041, // MZA America/Lima
    500, // MZB Africa/Maputo
    410, // MZC Africa/Libreville
    1217, // MZE America/Belize
    76, // MZI Africa/Bamako
    2494, // MZJ America/Phoenix
    5817, // MZK Pacific/Tarawa
    1271, // MZL America/Bogota
    1824, // MZO America/Havana
    5372, // MZP Pacific/Auckland
    3479, // MZR Asia/Kabul
    2157, // MZT America/Mazatlan
    3547, // MZU Asia/Kolkata
    std::numeric_limits<uint16_t>::max(), // MZV
    47, // MZW Africa/Algiers
    1858, // MZZ America/Indiana/Knox
    4425, // NAA Australia/Sydney
    4262, // NAC Australia/Adelaide
    658, // NAE Africa/Porto-Novo
    3547, // NAG Asia/Kolkata
    3620, // NAH Asia/Makassar
    1793, // NAI America/Guyana
    3233, // NAJ Asia/Baku
    3243, // NAK Asia/Barnaul
    4880, // NAL Europe/Moscow
    3450, // NAM Asia/Jayapura
    5487, // NAN Pacific/Fiji
    3840, // NAO Asia/Shanghai
    4962, // NAP Europe/Rome
    2921, // NAQ America/Thule
    1271, // NAR America/Bogota
    2335, // NAS America/Nassau
    1669, // NAT America/Fortaleza
    5802, // NAU Pacific/Tahiti
    4686, // NAV Europe/Istanbul
    3243, // NAW Asia/Barnaul
    3840, // NAY Asia/Shanghai
    1271, // NBB America/Bogota
    4880, // NBC Europe/Moscow
    707, // NBE Africa/Tunis
    2440, // NBL America/Panama
    486, // NBN Africa/Malabo
    576, // NBO Africa/Nairobi
    3840, // NBS Asia/Shanghai
    1824, // NBW America/Havana
    3450, // NBX Asia/Jayapura
    1721, // NCA America/Grand_Turk
    4906, // NCE Europe/Paris
    1421, // NCG America/Chihuahua
    207, // NCH Africa/Dar_es_Salaam
    1271, // NCI America/Bogota
    861, // NCJ America/Argentina/Cordoba
    4791, // NCL Europe/London
    749, // NCN America/Anchorage
    2089, // NCR America/Managua
    320, // NCS Africa/Johannesburg
    1439, // NCT America/Costa_Rica
    3814, // NCU Asia/Samarkand
    4906, // NCY Europe/Paris
    3450, // NDA Asia/Jayapura
    258, // NDB Africa/El_Aaiun
    3547, // NDC Asia/Kolkata
    440, // NDD Africa/Luanda
    28, // NDE Africa/Addis_Ababa
    440, // NDF Africa/Luanda
    3840, // NDG Asia/Shanghai
    244, // NDJ Africa/Douala
    std::numeric_limits<uint16_t>::max(), // NDK
    90, // NDL Africa/Banjul
    166, // NDR Africa/Ceuta
    440, // NDU Africa/Luanda
    4791, // NDY Europe/London
    802, // NEC America/Argentina/Buenos_Aires
    std::numeric_limits<uint16_t>::max(), // NEF
    1936, // NEG America/Juneau
    28, // NEJ Africa/Addis_Ababa
    28, // NEK Africa/Addis_Ababa
    4049, // NER Asia/Yakutsk
    2830, // NEV America/St_Kitts
    4074, // NFG Asia/Yekaterinburg
    5832, // NFO Pacific/Tongatapu
    4425, // NGA Australia/Sydney
    3840, // NGB Asia/Shanghai
    2987, // NGD America/Tortola
    244, // NGE Africa/Douala
    5487, // NGI Pacific/Fiji
    3800, // NGK Asia/Sakhalin
    3952, // NGO Asia/Tokyo
    3840, // NGQ Asia/Shanghai
    3952, // NGS Asia/Tokyo
    1405, // NGT America/Chicago
    3518, // NGX Asia/Kathmandu
    367, // NHF Africa/Kigali
    2350, // NHZ America/New_York
    179, // NIA Africa/Conakry
    749, // NIB America/Anchorage
    3383, // NIC Asia/Famagusta
    4409, // NIF Australia/Perth
    5817, // NIG Pacific/Tarawa
    194, // NIK Africa/Dakar
    607, // NIM Africa/Niamey
    381, // NIO Africa/Kinshasa
    4906, // NIT Europe/Paris
    5802, // NIU Pacific/Tahiti
    76, // NIX Africa/Bamako
    4074, // NJC Asia/Yekaterinburg
    3207, // NJF Asia/Baghdad
    621, // NKC Africa/Nouakchott
    3840, // NKG Asia/Shanghai
    381, // NKL Africa/Kinshasa
    3952, // NKM Asia/Tokyo
    244, // NKS Africa/Douala
    4686, // NKT Europe/Istanbul
    514, // NKU Africa/Maseru
    134, // NKY Africa/Brazzaville
    472, // NLA Africa/Lusaka
    2139, // NLD America/Matamoros
    1562, // NLE America/Detroit
    4281, // NLF Australia/Brisbane
    749, // NLG America/Anchorage
    3840, // NLH Asia/Shanghai
    4032, // NLI Asia/Vladivostok
    std::numeric_limits<uint16_t>::max(), // NLK
    2054, // NLN America/Los_Angeles
    134, // NLO Africa/Brazzaville
    320, // NLP Africa/Johannesburg
    3991, // NLT Asia/Urumqi
    4735, // NLV Europe/Kiev
    3900, // NMA Asia/Tashkent
    3547, // NMB Asia/Kolkata
    2335, // NMC America/Nassau
    2367, // NME America/Nome
    2440, // NMG America/Panama
    1595, // NML America/Edmonton
    4062, // NMS Asia/Yangon
    166, // NNA Africa/Ceuta
    5551, // NNB Pacific/Guadalcanal
    3840, // NNG Asia/Shanghai
    720, // NNI Africa/Windhoek
    749, // NNK America/Anchorage
    749, // NNL America/Anchorage
    4880, // NNM Europe/Moscow
    4735, // NNN Europe/Kiev
    4621, // NNR Europe/Dublin
    3243, // NNT Asia/Barnaul
    2759, // NNU America/Sao_Paulo
    3620, // NNX Asia/Makassar
    3840, // NNY Asia/Shanghai
    1439, // NOB America/Costa_Rica
    4621, // NOC Europe/Dublin
    4506, // NOD Europe/Berlin
    1839, // NOG America/Hermosillo
    4074, // NOJ Asia/Yekaterinburg
    1474, // NOK America/Cuiaba
    5817, // NON Pacific/Tarawa
    4686, // NOP Europe/Istanbul
    4207, // NOR Atlantic/Reykjavik
    5233, // NOS Indian/Antananarivo
    2054, // NOT America/Los_Angeles
    5699, // NOU Pacific/Noumea
    440, // NOV Africa/Luanda
    3671, // NOZ Asia/Novokuznetsk
    5372, // NPE Pacific/Auckland
    5372, // NPL Pacific/Auckland
    3732, // NPO Asia/Pontianak
    2703, // NPR America/Santarem
    2350, // NPT America/New_York
    1405, // NQA America/Chicago
    2759, // NQL America/Sao_Paulo
    971, // NQN America/Argentina/Salta
    1271, // NQU America/Bogota
    4791, // NQY Europe/London
    4425, // NRA Australia/Sydney
    2054, // NRC America/Los_Angeles
    4506, // NRD Europe/Berlin
    3450, // NRE Asia/Jayapura
    4409, // NRG Australia/Perth
    1405, // NRI America/Chicago
    5064, // NRK Europe/Stockholm
    4791, // NRL Europe/London
    76, // NRM Africa/Bamako
    4442, // NRN Europe/Amsterdam
    2575, // NRR America/Puerto_Rico
    3952, // NRT Asia/Tokyo
    2335, // NSB America/Nassau
    3927, // NSH Asia/Tehran
    244, // NSI Africa/Douala
    3560, // NSK Asia/Krasnoyarsk
    4409, // NSM Australia/Perth
    5372, // NSN Pacific/Auckland
    4425, // NSO Australia/Sydney
    3243, // NST Asia/Barnaul
    4894, // NTB Europe/Oslo
    4906, // NTE Europe/Paris
    3840, // NTG Asia/Shanghai
    4281, // NTN Australia/Brisbane
    3952, // NTQ Asia/Tokyo
    2279, // NTR America/Monterrey
    5832, // NTT Pacific/Tongatapu
    3450, // NTX Asia/Jayapura
    320, // NTY Africa/Johannesburg
    4339, // NUB Australia/Darwin
    367, // NUD Africa/Kigali
    4506, // NUE Europe/Berlin
    749, // NUI America/Anchorage
    5802, // NUK Pacific/Tahiti
    749, // NUL America/Anchorage
    1405, // NUN America/Chicago
    2367, // NUP America/Nome
    2054, // NUQ America/Los_Angeles
    5455, // NUS Pacific/Efate
    576, // NUU Africa/Nairobi
    4074, // NUX Asia/Yekaterinburg
    1271, // NVA America/Bogota
    2089, // NVG America/Managua
    3814, // NVI Asia/Samarkand
    1839, // NVJ America/Hermosillo
    4894, // NVK Europe/Oslo
    2054, // NVN America/Los_Angeles
    4880, // NVR Europe/Moscow
    4906, // NVS Europe/Paris
    2759, // NVT America/Sao_Paulo
    5270, // NWA Indian/Comoro
    2350, // NWH America/New_York
    4791, // NWI Europe/London
    2054, // NXP America/Los_Angeles
    4074, // NYA Asia/Yekaterinburg
    576, // NYE Africa/Nairobi
    15, // NYI Africa/Accra
    576, // NYK Africa/Nairobi
    4074, // NYM Asia/Yekaterinburg
    4425, // NYN Australia/Sydney
    5064, // NYO Europe/Stockholm
    4049, // NYR Asia/Yakutsk
    4062, // NYT Asia/Yangon
    4062, // NYU Asia/Yangon
    440, // NZA Africa/Luanda
    2041, // NZC America/Lima
    179, // NZE Africa/Conakry
    3840, // NZH Asia/Shanghai
    std::numeric_limits<uint16_t>::max(), // NZK
    3840, // NZL Asia/Shanghai
    4425, // OAG Australia/Sydney
    2350, // OAJ America/New_York
    2054, // OAK America/Los_Angeles
    2555, // OAL America/Porto_Velho
    5372, // OAM Pacific/Auckland
    2901, // OAN America/Tegucigalpa
    2054, // OAR America/Los_Angeles
    3479, // OAS Asia/Kabul
    2226, // OAX America/Mexico_City
    228, // OBC Africa/Djibouti
    2350, // OBE America/New_York
    4506, // OBF Europe/Berlin
    2703, // OBI America/Santarem
    4791, // OBN Europe/London
    3952, // OBO Asia/Tokyo
    4906, // OBS Europe/Paris
    749, // OBU America/Anchorage
    5748, // OBX Pacific/Port_Moresby
    2350, // OCA America/New_York
    1793, // OCC America/Guyana
    2350, // OCE America/New_York
    2350, // OCF America/New_York
    1936, // OCJ America/Juneau
    4409, // OCM Australia/Perth
    2054, // OCN America/Los_Angeles
    486, // OCS Africa/Malabo
    1271, // OCV America/Bogota
    90, // ODA Africa/Banjul
    4823, // ODB Europe/Madrid
    2054, // ODC America/Los_Angeles
    4603, // ODE Europe/Copenhagen
    90, // ODJ Africa/Banjul
    2350, // ODM America/New_York
    3595, // ODN Asia/Kuwait
    3437, // ODO Asia/Irkutsk
    4735, // ODS Europe/Kiev
    2054, // ODW America/Los_Angeles
    4017, // ODY Asia/Vientiane
    1405, // OEA America/Chicago
    1562, // OEB America/Detroit
    3620, // OEC Asia/Makassar
    4880, // OEL Europe/Moscow
    2475, // OEM America/Paramaribo
    1405, // OEO America/Chicago
    5064, // OER Europe/Stockholm
    971, // OES America/Argentina/Salta
    3788, // OET Asia/Riyadh
    0, // OFI Africa/Abidjan
    4207, // OFJ Atlantic/Reykjavik
    1405, // OFK America/Chicago
    2350, // OFP America/New_York
    5714, // OFU Pacific/Pago_Pago
    2350, // OGB America/New_York
    1547, // OGD America/Denver
    5584, // OGG Pacific/Honolulu
    1793, // OGL America/Guyana
    2440, // OGM America/Panama
    std::numeric_limits<uint16_t>::max(), // OGN
    0, // OGO Africa/Abidjan
    244, // OGR Africa/Douala
    2971, // OGS America/Toronto
    4686, // OGU Europe/Istanbul
    47, // OGX Africa/Algiers
    4880, // OGZ Europe/Moscow
    5372, // OHA Pacific/Auckland
    5037, // OHD Europe/Skopje
    3840, // OHE Asia/Shanghai
    3800, // OHH Asia/Sakhalin
    720, // OHI Africa/Windhoek
    3646, // OHS Asia/Muscat
    1203, // OIA America/Belem
    2350, // OIC America/New_York
    3952, // OIM Asia/Tokyo
    3952, // OIR Asia/Tokyo
    3952, // OIT Asia/Tokyo
    1405, // OJA America/Chicago
    1405, // OJC America/Chicago
    3952, // OKA Asia/Tokyo
    1405, // OKC America/Chicago
    3952, // OKD Asia/Tokyo
    3952, // OKE Asia/Tokyo
    720, // OKF Africa/Windhoek
    134, // OKG Africa/Brazzaville
    3952, // OKI Asia/Tokyo
    3952, // OKJ Asia/Tokyo
    1858, // OKK America/Indiana/Knox
    3450, // OKL Asia/Jayapura
    1405, // OKM America/Chicago
    410, // OKN Africa/Libreville
    4281, // OKR Australia/Brisbane
    3952, // OKS Asia/Tokyo
    4880, // OKT Europe/Moscow
    720, // OKU Africa/Windhoek
    4894, // OLA Europe/Oslo
    4962, // OLB Europe/Rome
    2105, // OLC America/Manaus
    2350, // OLD America/New_York
    2350, // OLE America/New_York
    1547, // OLF America/Denver
    749, // OLH America/Anchorage
    4207, // OLI Atlantic/Reykjavik
    std::numeric_limits<uint16_t>::max(), // OLJ
    134, // OLL Africa/Brazzaville
    2054, // OLM America/Los_Angeles
    833, // OLN America/Argentina/Catamarca
    4936, // OLO Europe/Prague
    4262, // OLP Australia/Adelaide
    2494, // OLS America/Phoenix
    1405, // OLU America/Chicago
    1405, // OLV America/Chicago
    4049, // OLZ Asia/Yakutsk
    1405, // OMA America/Chicago
    410, // OMB Africa/Libreville
    3634, // OMC Asia/Manila
    720, // OMD Africa/Windhoek
    2367, // OME America/Nome
    std::numeric_limits<uint16_t>::max(), // OMG
    3927, // OMH Asia/Tehran
    2054, // OMK America/Los_Angeles
    3646, // OMM Asia/Muscat
    3547, // OMN Asia/Kolkata
    4988, // OMO Europe/Sarajevo
    4554, // OMR Europe/Bucharest
    3706, // OMS Asia/Oral
    3716, // OMY Asia/Phnom_Penh
    1405, // ONA America/Chicago
    720, // OND Africa/Windhoek
    4281, // ONG Australia/Brisbane
    2350, // ONH America/New_York
    3952, // ONJ Asia/Tokyo
    4049, // ONK Asia/Yakutsk
    1405, // ONL America/Chicago
    1286, // ONO America/Boise
    2054, // ONP America/Los_Angeles
    4686, // ONQ Europe/Istanbul
    4409, // ONS Australia/Perth
    2054, // ONT America/Los_Angeles
    2440, // ONX America/Panama
    1562, // ONZ America/Detroit
    4262, // OOD Australia/Adelaide
    2367, // OOK America/Nome
    4281, // OOL Australia/Brisbane
    4425, // OOM Australia/Sydney
    std::numeric_limits<uint16_t>::max(), // OOT
    4207, // OPA Atlantic/Reykjavik
    2350, // OPF America/New_York
    4339, // OPI Australia/Darwin
    1405, // OPL America/Chicago
    4760, // OPO Europe/Lisbon
    1474, // OPS America/Cuiaba
    5748, // OPU Pacific/Port_Moresby
    720, // OPW Africa/Windhoek
    2350, // OQN America/New_York
    2350, // OQU America/New_York
    971, // ORA America/Argentina/Salta
    5064, // ORB Europe/Stockholm
    1271, // ORC America/Bogota
    1405, // ORD America/Chicago
    4906, // ORE Europe/Paris
    2350, // ORF America/New_York
    2475, // ORG America/Paramaribo
    2350, // ORH America/New_York
    749, // ORI America/Anchorage
    1253, // ORJ America/Boa_Vista
    4621, // ORK Europe/Dublin
    2350, // ORL America/New_York
    4791, // ORM Europe/London
    47, // ORN Africa/Algiers
    2901, // ORO America/Tegucigalpa
    290, // ORP Africa/Gaborone
    749, // ORT America/Anchorage
    2026, // ORU America/La_Paz
    749, // ORV America/Anchorage
    3505, // ORW Asia/Karachi
    2703, // ORX America/Santarem
    4906, // ORY Europe/Paris
    1217, // ORZ America/Belize
    1562, // OSC America/Detroit
    5064, // OSD Europe/Stockholm
    4880, // OSF Europe/Moscow
    1405, // OSH America/Chicago
    5187, // OSI Europe/Zagreb
    4894, // OSL Europe/Oslo
    3207, // OSM Asia/Baghdad
    4281, // OSO Australia/Brisbane
    5173, // OSP Europe/Warsaw
    4936, // OSR Europe/Prague
    3900, // OSS Asia/Tashkent
    4538, // OST Europe/Brussels
    2350, // OSU America/New_York
    4074, // OSW Asia/Yekaterinburg
    4894, // OSY Europe/Oslo
    5173, // OSZ Europe/Warsaw
    591, // OTC Africa/Ndjamena
    2440, // OTD America/Panama
    2054, // OTH America/Los_Angeles
    3450, // OTI Asia/Jayapura
    720, // OTJ Africa/Windhoek
    621, // OTL Africa/Nouakchott
    1405, // OTM America/Chicago
    1405, // OTN America/Chicago
    4554, // OTP Europe/Bucharest
    1439, // OTR America/Costa_Rica
    2054, // OTS America/Los_Angeles
    1271, // OTU America/Bogota
    2367, // OTZ America/Nome
    639, // OUA Africa/Ouagadougou
    166, // OUD Africa/Ceuta
    134, // OUE Africa/Brazzaville
    639, // OUG Africa/Ouagadougou
    4651, // OUL Europe/Helsinki
    591, // OUM Africa/Ndjamena
    1405, // OUN America/Chicago
    244, // OUR Africa/Douala
    2759, // OUS America/Sao_Paulo
    591, // OUT Africa/Ndjamena
    621, // OUZ Africa/Nouakchott
    3689, // OVB Asia/Novosibirsk
    4823, // OVD Europe/Madrid
    2054, // OVE America/Los_Angeles
    2720, // OVL America/Santiago
    802, // OVR America/Argentina/Buenos_Aires
    1405, // OVS America/Chicago
    1405, // OWB America/Chicago
    2350, // OWD America/New_York
    1405, // OWI America/Chicago
    2350, // OWK America/New_York
    1405, // OWP America/Chicago
    104, // OXB Africa/Bissau
    2350, // OXC America/New_York
    1858, // OXD America/Indiana/Knox
    4791, // OXF Europe/London
    861, // OYA America/Argentina/Cordoba
    410, // OYE Africa/Libreville
    340, // OYG Africa/Juba
    1374, // OYK America/Cayenne
    28, // OYL Africa/Addis_Ababa
    802, // OYO America/Argentina/Buenos_Aires
    1374, // OYP America/Cayenne
    3634, // OZC Asia/Manila
    166, // OZG Africa/Ceuta
    5201, // OZH Europe/Zaporozhye
    1405, // OZS America/Chicago
    1562, // OZW America/Detroit
    166, // OZZ Africa/Ceuta
    4062, // PAA Asia/Yangon
    3547, // PAB Asia/Kolkata
    2440, // PAC America/Panama
    4506, // PAD Europe/Berlin
    2054, // PAE America/Los_Angeles
    352, // PAF Africa/Kampala
    3634, // PAG Asia/Manila
    1405, // PAH America/Chicago
    std::numeric_limits<uint16_t>::max(), // PAJ
    5584, // PAK Pacific/Honolulu
    1271, // PAL America/Bogota
    3243, // PAN Asia/Barnaul
    2054, // PAO America/Los_Angeles
    2510, // PAP America/Port-au-Prince
    749, // PAQ America/Anchorage
    4476, // PAS Europe/Athens
    3547, // PAT Asia/Kolkata
    1149, // PAV America/Bahia
    2510, // PAX America/Port-au-Prince
    2226, // PAZ America/Mexico_City
    2226, // PBC America/Mexico_City
    3547, // PBD Asia/Kolkata
    1271, // PBE America/Bogota
    1405, // PBF America/Chicago
    2350, // PBG America/New_York
    3939, // PBH Asia/Thimphu
    2350, // PBI America/New_York
    5455, // PBJ Pacific/Efate
    1358, // PBL America/Caracas
    2475, // PBM America/Paramaribo
    440, // PBN Africa/Luanda
    4409, // PBO Australia/Perth
    1439, // PBP America/Costa_Rica
    2555, // PBQ America/Porto_Velho
    1775, // PBR America/Guatemala
    4062, // PBU Asia/Yangon
    1474, // PBV America/Cuiaba
    320, // PBZ Africa/Johannesburg
    749, // PCA America/Anchorage
    3450, // PCB Asia/Jayapura
    1405, // PCD America/Chicago
    2901, // PCH America/Tegucigalpa
    2041, // PCL America/Lima
    2350, // PCM America/New_York
    5372, // PCN Pacific/Auckland
    2157, // PCO America/Mazatlan
    676, // PCP Africa/Sao_Tome
    std::numeric_limits<uint16_t>::max(), // PCR
    1669, // PCS America/Fortaleza
    2350, // PCT America/New_York
    2350, // PCW America/New_York
    1405, // PCZ America/Chicago
    1271, // PDA America/Bogota
    749, // PDB America/Anchorage
    500, // PDD Africa/Maputo
    3450, // PDG Asia/Jayapura
    2350, // PDK America/New_York
    4106, // PDL Atlantic/Azores
    3450, // PDO Asia/Jayapura
    2297, // PDP America/Montevideo
    2139, // PDS America/Matamoros
    861, // PDU America/Argentina/Cordoba
    2054, // PDX America/Los_Angeles
    1358, // PDZ America/Caracas
    1936, // PEC America/Juneau
    4936, // PED Europe/Prague
    4074, // PEE Asia/Yekaterinburg
    4506, // PEF Europe/Berlin
    4962, // PEG Europe/Rome
    802, // PEH America/Argentina/Buenos_Aires
    1271, // PEI America/Bogota
    3840, // PEK Asia/Shanghai
    514, // PEL Africa/Maseru
    2041, // PEM America/Lima
    3577, // PEN Asia/Kuala_Lumpur
    2350, // PEO America/New_York
    1405, // PEQ America/Chicago
    4409, // PER Australia/Perth
    4880, // PES Europe/Moscow
    2759, // PET America/Sao_Paulo
    2901, // PEU America/Tegucigalpa
    3505, // PEW Asia/Karachi
    4880, // PEX Europe/Moscow
    4880, // PEZ Europe/Moscow
    2759, // PFB America/Sao_Paulo
    2054, // PFC America/Los_Angeles
    4207, // PFJ Atlantic/Reykjavik
    1405, // PFN America/Chicago
    3658, // PFO Asia/Nicosia
    3233, // PFQ Asia/Baku
    381, // PFR Africa/Kinshasa
    2494, // PGA America/Phoenix
    4490, // PGB Europe/Belgrade
    2350, // PGC America/New_York
    2350, // PGD America/New_York
    4906, // PGF Europe/Paris
    3547, // PGH Asia/Kolkata
    454, // PGI Africa/Lubumbashi
    3450, // PGK Asia/Jayapura
    1405, // PGL America/Chicago
    749, // PGM America/Anchorage
    2510, // PGN America/Port-au-Prince
    676, // PGP Africa/Sao_Tome
    1405, // PGR America/Chicago
    2494, // PGS America/Phoenix
    3927, // PGU Asia/Tehran
    2350, // PGV America/New_York
    4906, // PGX Europe/Paris
    2759, // PGZ America/Sao_Paulo
    1669, // PHB America/Fortaleza
    397, // PHC Africa/Lagos
    2350, // PHD America/New_York
    4409, // PHE Australia/Perth
    2350, // PHF America/New_York
    397, // PHG Africa/Lagos
    1669, // PHI America/Fortaleza
    2350, // PHK America/New_York
    2350, // PHL America/New_York
    4506, // PHM Europe/Berlin
    1562, // PHN America/Detroit
    2367, // PHO America/Nome
    4281, // PHQ Australia/Brisbane
    3243, // PHS Asia/Barnaul
    1405, // PHT America/Chicago
    320, // PHW Africa/Johannesburg
    2494, // PHX America/Phoenix
    3243, // PHY Asia/Barnaul
    1405, // PIA America/Chicago
    1405, // PIB America/Chicago
    1721, // PIC America/Grand_Turk
    2335, // PID America/Nassau
    2350, // PIE America/New_York
    3888, // PIF Asia/Taipei
    802, // PIG America/Argentina/Buenos_Aires
    1286, // PIH America/Boise
    4791, // PIK Europe/London
    861, // PIL America/Argentina/Cordoba
    2350, // PIM America/New_York
    2105, // PIN America/Manaus
    2041, // PIO America/Lima
    749, // PIP America/Anchorage
    1405, // PIR America/Chicago
    4906, // PIS Europe/Paris
    2350, // PIT America/New_York
    2041, // PIU America/Lima
    3040, // PIW America/Winnipeg
    4106, // PIX Atlantic/Azores
    2367, // PIZ America/Nome
    5064, // PJA Europe/Stockholm
    2494, // PJB America/Phoenix
    1115, // PJC America/Asuncion
    3505, // PJG Asia/Karachi
    1439, // PJM America/Costa_Rica
    749, // PKA America/Anchorage
    2350, // PKB America/New_York
    3490, // PKC Asia/Kamchatka
    4425, // PKE Australia/Sydney
    1405, // PKF America/Chicago
    std::numeric_limits<uint16_t>::max(), // PKG
    4476, // PKH Europe/Athens
    1775, // PKJ America/Guatemala
    4062, // PKK Asia/Yangon
    3732, // PKN Asia/Pontianak
    658, // PKO Africa/Porto-Novo
    5802, // PKP Pacific/Tahiti
    3518, // PKR Asia/Kathmandu
    4339, // PKT Australia/Darwin
    3450, // PKU Asia/Jayapura
    4880, // PKV Europe/Moscow
    290, // PKW Africa/Gaborone
    3732, // PKY Asia/Pontianak
    4017, // PKZ Asia/Vientiane
    2350, // PLB America/New_York
    1439, // PLD America/Costa_Rica
    591, // PLF Africa/Ndjamena
    4791, // PLH Europe/London
    1217, // PLJ America/Belize
    1405, // PLK America/Chicago
    2105, // PLL America/Manaus
    3450, // PLM Asia/Jayapura
    1562, // PLN America/Detroit
    4262, // PLO Australia/Adelaide
    5141, // PLQ Europe/Vilnius
    1405, // PLR America/Chicago
    1721, // PLS America/Grand_Turk
    1271, // PLT America/Bogota
    2759, // PLU America/Sao_Paulo
    4735, // PLV Europe/Kiev
    3620, // PLW Asia/Makassar
    3123, // PLX Asia/Almaty
    1858, // PLY America/Indiana/Knox
    320, // PLZ Africa/Johannesburg
    207, // PMA Africa/Dar_es_Salaam
    1405, // PMB America/Chicago
    2720, // PMC America/Santiago
    2054, // PMD America/Los_Angeles
    4962, // PMF Europe/Rome
    1115, // PMG America/Asuncion
    2350, // PMH America/New_York
    4823, // PMI Europe/Madrid
    4281, // PMK Australia/Brisbane
    749, // PML America/Anchorage
    4962, // PMO Europe/Rome
    940, // PMQ America/Argentina/Rio_Gallegos
    5372, // PMR Pacific/Auckland
    3333, // PMS Asia/Damascus
    1358, // PMV America/Caracas
    784, // PMW America/Araguaina
    2350, // PMX America/New_York
    833, // PMY America/Argentina/Catamarca
    1439, // PMZ America/Costa_Rica
    4823, // PNA Europe/Madrid
    784, // PNB America/Araguaina
    1405, // PNC America/Chicago
    1217, // PND America/Belize
    2350, // PNE America/New_York
    2759, // PNG America/Sao_Paulo
    3716, // PNH Asia/Phnom_Penh
    5732, // PNI Pacific/Pohnpei
    3732, // PNK Asia/Pontianak
    4962, // PNL Europe/Rome
    1405, // PNM America/Chicago
    2350, // PNN America/New_York
    5748, // PNP Pacific/Port_Moresby
    3547, // PNQ Asia/Kolkata
    134, // PNR Africa/Brazzaville
    1405, // PNS America/Chicago
    2595, // PNT America/Punta_Arenas
    1547, // PNU America/Denver
    1405, // PNX America/Chicago
    3547, // PNY Asia/Kolkata
    1149, // PNZ America/Bahia
    2759, // POA America/Sao_Paulo
    2054, // POC America/Los_Angeles
    621, // POD Africa/Nouakchott
    410, // POG Africa/Libreville
    2026, // POI America/La_Paz
    2759, // POJ America/Sao_Paulo
    500, // POL Africa/Maputo
    5748, // POM Pacific/Port_Moresby
    1775, // PON America/Guatemala
    2759, // POO America/Sao_Paulo
    2737, // POP America/Santo_Domingo
    4651, // POR Europe/Helsinki
    2533, // POS America/Port_of_Spain
    1936, // POT America/Juneau
    2350, // POU America/New_York
    2350, // POV America/New_York
    5187, // POW Europe/Zagreb
    4906, // POX Europe/Paris
    5173, // POZ Europe/Warsaw
    2759, // PPB America/Sao_Paulo
    749, // PPC America/Anchorage
    1839, // PPE America/Hermosillo
    1405, // PPF America/Chicago
    5714, // PPG Pacific/Pago_Pago
    1358, // PPH America/Caracas
    4262, // PPI Australia/Adelaide
    3123, // PPK Asia/Almaty
    3518, // PPL Asia/Kathmandu
    2350, // PPM America/New_York
    1271, // PPN America/Bogota
    4281, // PPP Australia/Brisbane
    5372, // PPQ Pacific/Auckland
    3450, // PPR Asia/Jayapura
    3634, // PPS Asia/Manila
    5802, // PPT Pacific/Tahiti
    2777, // PPV America/Sitka
    4791, // PPW Europe/London
    2759, // PPY America/Sao_Paulo
    1358, // PPZ America/Caracas
    3716, // PQC Asia/Phnom_Penh
    2350, // PQI America/New_York
    2226, // PQM America/Mexico_City
    4425, // PQQ Australia/Sydney
    2367, // PQS America/Nome
    861, // PRA America/Argentina/Cordoba
    2054, // PRB America/Los_Angeles
    2494, // PRC America/Phoenix
    4936, // PRG Europe/Prague
    3243, // PRH Asia/Barnaul
    5284, // PRI Indian/Mahe
    4760, // PRM Europe/Lisbon
    4490, // PRN Europe/Belgrade
    1405, // PRO America/Chicago
    4906, // PRP Europe/Paris
    861, // PRQ America/Argentina/Cordoba
    1793, // PRR America/Guyana
    4936, // PRV Europe/Prague
    1405, // PRW America/Chicago
    1405, // PRX America/Chicago
    320, // PRY Africa/Johannesburg
    2054, // PRZ America/Los_Angeles
    4962, // PSA Europe/Rome
    2350, // PSB America/New_York
    2054, // PSC America/Los_Angeles
    153, // PSD Africa/Cairo
    2575, // PSE America/Puerto_Rico
    2350, // PSF America/New_York
    2777, // PSG America/Sitka
    3505, // PSI Asia/Karachi
    3620, // PSJ Asia/Makassar
    2350, // PSK America/New_York
    4791, // PSL Europe/London
    2350, // PSM America/New_York
    1271, // PSO America/Bogota
    2054, // PSP America/Los_Angeles
    2350, // PSQ America/New_York
    4962, // PSR Europe/Rome
    1115, // PSS America/Asuncion
    1824, // PST America/Havana
    3732, // PSU Asia/Pontianak
    std::numeric_limits<uint16_t>::max(), // PSV
    1405, // PSX America/Chicago
    4245, // PSY Atlantic/Stanley
    2026, // PSZ America/La_Paz
    749, // PTA America/Anchorage
    2777, // PTD America/Sitka
    5487, // PTF Pacific/Fiji
    320, // PTG Africa/Johannesburg
    749, // PTH America/Anchorage
    4389, // PTJ Australia/Melbourne
    1562, // PTK America/Detroit
    1358, // PTM America/Caracas
    1405, // PTN America/Chicago
    2759, // PTO America/Sao_Paulo
    1756, // PTP America/Guadeloupe
    1405, // PTS America/Chicago
    1405, // PTT America/Chicago
    749, // PTU America/Anchorage
    2054, // PTV America/Los_Angeles
    2350, // PTW America/New_York
    1271, // PTX America/Bogota
    2440, // PTY America/Panama
    1793, // PTZ America/Guyana
    1547, // PUB America/Denver
    940, // PUD America/Argentina/Rio_Gallegos
    2440, // PUE America/Panama
    4906, // PUF Europe/Paris
    4262, // PUG Australia/Adelaide
    2737, // PUJ America/Santo_Domingo
    5802, // PUK Pacific/Tahiti
    3620, // PUM Asia/Makassar
    454, // PUN Africa/Lubumbashi
    639, // PUP Africa/Ouagadougou
    2595, // PUQ America/Punta_Arenas
    2026, // PUR America/La_Paz
    3829, // PUS Asia/Seoul
    3547, // PUT Asia/Kolkata
    1271, // PUU America/Bogota
    2054, // PUW America/Los_Angeles
    2720, // PUX America/Santiago
    5187, // PUY Europe/Zagreb
    2089, // PUZ America/Managua
    1271, // PVA America/Bogota
    1405, // PVB America/Chicago
    2350, // PVC America/New_York
    2350, // PVD America/New_York
    2440, // PVE America/Panama
    2054, // PVF America/Los_Angeles
    3840, // PVG Asia/Shanghai
    2105, // PVH America/Manaus
    2759, // PVI America/Sao_Paulo
    4476, // PVK Europe/Athens
    2350, // PVL America/New_York
    1793, // PVO America/Guyana
    2157, // PVP America/Mazatlan
    1163, // PVR America/Bahia_Banderas
    3146, // PVS Asia/Anadyr
    1547, // PVU America/Denver
    1405, // PVW America/Chicago
    1405, // PWA America/Chicago
    1547, // PWD America/Denver
    3146, // PWE Asia/Anadyr
    1405, // PWK America/Chicago
    3450, // PWL Asia/Jayapura
    2350, // PWM America/New_York
    2335, // PWN America/Nassau
    454, // PWO Africa/Lubumbashi
    3123, // PWQ Asia/Almaty
    2054, // PWT America/Los_Angeles
    1547, // PWY America/Denver
    3450, // PXA Asia/Jayapura
    2350, // PXE America/New_York
    4262, // PXH Australia/Adelaide
    2494, // PXL America/Phoenix
    2226, // PXM America/Mexico_City
    4190, // PXO Atlantic/Madeira
    3243, // PXR Asia/Barnaul
    3410, // PXU Asia/Ho_Chi_Minh
    1271, // PYA America/Bogota
    3547, // PYB Asia/Kolkata
    2440, // PYC America/Panama
    5769, // PYE Pacific/Rarotonga
    1271, // PYH America/Bogota
    4049, // PYJ Asia/Yakutsk
    3927, // PYK Asia/Tehran
    2350, // PYM America/New_York
    1793, // PYO America/Guyana
    1405, // PYP America/Chicago
    2054, // PYS America/Los_Angeles
    3243, // PYY Asia/Barnaul
    1271, // PZA America/Bogota
    320, // PZB Africa/Johannesburg
    3505, // PZH Asia/Karachi
    3840, // PZI Asia/Shanghai
    1358, // PZO America/Caracas
    2720, // PZS America/Santiago
    367, // PZU Africa/Kigali
    4520, // PZY Europe/Bratislava
    3358, // QAJ Asia/Dubai
    2759, // QAK America/Sao_Paulo
    4906, // QAM Europe/Paris
    4962, // QAQ Europe/Rome
    47, // QAS Africa/Algiers
    3003, // QBC America/Vancouver
    4490, // QBG Europe/Belgrade
    4906, // QBQ Europe/Paris
    4962, // QBS Europe/Rome
    2759, // QCN America/Sao_Paulo
    2759, // QCP America/Sao_Paulo
    2759, // QDC America/Sao_Paulo
    2759, // QDF America/Sao_Paulo
    47, // QDJ Africa/Algiers
    2759, // QDV America/Sao_Paulo
    47, // QFD Africa/Algiers
    1705, // QFG America/Godthab
    1705, // QFN America/Godthab
    4791, // QFO Europe/London
    4962, // QFR Europe/Rome
    2759, // QGF America/Sao_Paulo
    2637, // QGP America/Recife
    3952, // QGU Asia/Tokyo
    4571, // QGY Europe/Budapest
    2759, // QHB America/Sao_Paulo
    2759, // QHP America/Sao_Paulo
    28, // QHR Africa/Addis_Ababa
    3788, // QJB Asia/Riyadh
    1705, // QJH America/Godthab
    4894, // QJL Europe/Oslo
    472, // QKE Africa/Lusaka
    4894, // QKX Europe/Oslo
    4506, // QKZ Europe/Berlin
    4791, // QLA Europe/London
    47, // QLD Africa/Algiers
    2759, // QMF America/Sao_Paulo
    47, // QMH Africa/Algiers
    3927, // QMJ Asia/Tehran
    4962, // QMM Europe/Rome
    4506, // QMZ Europe/Berlin
    5219, // QNC Europe/Zurich
    4490, // QND Europe/Belgrade
    5219, // QNJ Europe/Zurich
    4538, // QNM Europe/Brussels
    2759, // QNV America/Sao_Paulo
    4906, // QNX Europe/Paris
    2350, // QNY America/New_York
    861, // QOJ America/Argentina/Cordoba
    397, // QOW Africa/Lagos
    4962, // QPA Europe/Rome
    1824, // QPD America/Havana
    290, // QPH Africa/Gaborone
    4571, // QPJ Europe/Budapest
    2759, // QPS America/Sao_Paulo
    320, // QRA Africa/Johannesburg
    2720, // QRC America/Santiago
    2759, // QRE America/Sao_Paulo
    4425, // QRM Australia/Sydney
    2226, // QRO America/Mexico_City
    4425, // QRR Australia/Sydney
    4962, // QRT Europe/Rome
    4906, // QRV Europe/Paris
    397, // QRW Africa/Lagos
    4823, // QSA Europe/Madrid
    2759, // QSC America/Sao_Paulo
    47, // QSF Africa/Algiers
    207, // QSI Africa/Dar_es_Salaam
    1824, // QSN America/Havana
    4962, // QSR Europe/Rome
    1793, // QSX America/Guyana
    4506, // QTK Europe/Berlin
    692, // QUB Africa/Tripoli
    4791, // QUG Europe/London
    397, // QUO Africa/Lagos
    397, // QUS Africa/Lagos
    3952, // QUT Asia/Tokyo
    4962, // QVA Europe/Rome
    2759, // QVP America/Sao_Paulo
    2350, // QWG America/New_York
    4490, // QWV Europe/Belgrade
    4906, // QXB Europe/Paris
    5173, // QYO Europe/Warsaw
    4906, // QYR Europe/Paris
    5173, // QYY Europe/Warsaw
    47, // QZN Africa/Algiers
    5748, // RAB Pacific/Port_Moresby
    1405, // RAC America/Chicago
    3788, // RAE Asia/Riyadh
    861, // RAF America/Argentina/Cordoba
    3788, // RAH Asia/Riyadh
    4155, // RAI Atlantic/Cape_Verde
    3547, // RAJ Asia/Kolkata
    166, // RAK Africa/Ceuta
    2054, // RAL America/Los_Angeles
    4339, // RAM Australia/Darwin
    4962, // RAN Europe/Rome
    2759, // RAO America/Sao_Paulo
    1547, // RAP America/Denver
    3620, // RAQ Asia/Makassar
    5769, // RAR Pacific/Rarotonga
    3927, // RAS Asia/Tehran
    4074, // RAT Asia/Yekaterinburg
    1271, // RAV America/Bogota
    1405, // RAW America/Chicago
    3505, // RAZ Asia/Karachi
    166, // RBA Africa/Ceuta
    2105, // RBB America/Manaus
    4389, // RBC Australia/Melbourne
    1405, // RBD America/Chicago
    3716, // RBE Asia/Phnom_Penh
    2054, // RBF America/Los_Angeles
    2054, // RBG America/Los_Angeles
    3952, // RBJ Asia/Tokyo
    2054, // RBK America/Los_Angeles
    2054, // RBL America/Los_Angeles
    4506, // RBM Europe/Berlin
    2026, // RBO America/La_Paz
    2026, // RBQ America/La_Paz
    2684, // RBR America/Rio_Branco
    4389, // RBS Australia/Melbourne
    576, // RBT Africa/Nairobi
    5551, // RBV Pacific/Guadalcanal
    2350, // RBW America/New_York
    340, // RBX Africa/Juba
    749, // RBY America/Anchorage
    320, // RCB Africa/Johannesburg
    2054, // RCE America/Los_Angeles
    1271, // RCH America/Bogota
    5455, // RCL Pacific/Efate
    4281, // RCM Australia/Brisbane
    1405, // RCP America/Chicago
    861, // RCQ America/Argentina/Cordoba
    1858, // RCR America/Indiana/Knox
    4791, // RCS Europe/London
    1562, // RCT America/Detroit
    861, // RCU America/Argentina/Cordoba
    1405, // RCX America/Chicago
    2335, // RCY America/Nassau
    2350, // RCZ America/New_York
    2367, // RDB America/Nome
    1203, // RDC America/Belem
    2054, // RDD America/Los_Angeles
    2350, // RDG America/New_York
    1405, // RDK America/Chicago
    2054, // RDM America/Los_Angeles
    3577, // RDN Asia/Kuala_Lumpur
    5173, // RDO Europe/Warsaw
    3547, // RDP Asia/Kolkata
    914, // RDS America/Argentina/Mendoza
    621, // RDT Africa/Nouakchott
    2350, // RDU America/New_York
    749, // RDV America/Anchorage
    4906, // RDZ Europe/Paris
    5802, // REA Pacific/Tahiti
    4506, // REB Europe/Berlin
    2637, // REC America/Recife
    2350, // RED America/New_York
    4962, // REG Europe/Rome
    1374, // REI America/Cayenne
    833, // REL America/Argentina/Catamarca
    4074, // REN Asia/Yekaterinburg
    1286, // REO America/Boise
    3716, // REP Asia/Phnom_Penh
    1775, // RER America/Guatemala
    861, // RES America/Argentina/Cordoba
    4894, // RET Europe/Oslo
    4823, // REU Europe/Madrid
    2139, // REX America/Matamoros
    2026, // REY America/La_Paz
    2759, // REZ America/Sao_Paulo
    90, // RFA Africa/Banjul
    1405, // RFD America/Chicago
    1405, // RFI America/Chicago
    4207, // RFN Atlantic/Reykjavik
    5802, // RFP Pacific/Tahiti
    2089, // RFS America/Managua
    1075, // RGA America/Argentina/Ushuaia
    3547, // RGH Asia/Kolkata
    5802, // RGI Pacific/Tahiti
    3243, // RGK Asia/Barnaul
    940, // RGL America/Argentina/Rio_Gallegos
    4062, // RGN Asia/Yangon
    3747, // RGO Asia/Pyongyang
    4823, // RGS Europe/Madrid
    3450, // RGT Asia/Jayapura
    1049, // RHD America/Argentina/Tucuman
    454, // RHG Africa/Lubumbashi
    1405, // RHI America/Chicago
    4476, // RHO Europe/Athens
    3518, // RHP Asia/Kathmandu
    3840, // RHT Asia/Shanghai
    2054, // RHV America/Los_Angeles
    2759, // RIA America/Sao_Paulo
    2026, // RIB America/La_Paz
    2350, // RIC America/New_York
    1858, // RID America/Indiana/Knox
    1405, // RIE America/Chicago
    2759, // RIG America/Sao_Paulo
    2440, // RIH America/Panama
    2041, // RIJ America/Lima
    1547, // RIL America/Denver
    5551, // RIN Pacific/Guadalcanal
    2054, // RIR America/Los_Angeles
    3952, // RIS Asia/Tokyo
    2054, // RIU America/Los_Angeles
    1547, // RIW America/Denver
    4950, // RIX Europe/Riga
    3113, // RIY Asia/Aden
    3840, // RIZ Asia/Shanghai
    3547, // RJA Asia/Kolkata
    3347, // RJH Asia/Dhaka
    5187, // RJK Europe/Zagreb
    4823, // RJL Europe/Madrid
    3927, // RJN Asia/Tehran
    2054, // RKC America/Los_Angeles
    2350, // RKD America/New_York
    4603, // RKE Europe/Copenhagen
    2350, // RKH America/New_York
    3450, // RKI Asia/Jayapura
    1405, // RKP America/Chicago
    1405, // RKR America/Chicago
    1547, // RKS America/Denver
    3358, // RKT Asia/Dubai
    4207, // RKV Atlantic/Reykjavik
    1405, // RKW America/Chicago
    3840, // RKZ Asia/Shanghai
    2054, // RLD America/Los_Angeles
    4506, // RLG Europe/Berlin
    3840, // RLK Asia/Shanghai
    1022, // RLO America/Argentina/San_Luis
    607, // RLT Africa/Niamey
    4281, // RMA Australia/Brisbane
    3358, // RMB Asia/Dubai
    3547, // RMD Asia/Kolkata
    2350, // RME America/New_York
    153, // RMF Africa/Cairo
    2350, // RMG America/New_York
    4962, // RMI Europe/Rome
    4262, // RMK Australia/Adelaide
    3320, // RML Asia/Colombo
    2350, // RMN America/New_York
    749, // RMP America/Anchorage
    5802, // RMT Pacific/Tahiti
    4823, // RMU Europe/Madrid
    2054, // RMY America/Los_Angeles
    5551, // RNA Pacific/Guadalcanal
    5064, // RNB Europe/Stockholm
    1405, // RNC America/Chicago
    4906, // RNE Europe/Paris
    1405, // RNH America/Chicago
    2089, // RNI America/Managua
    3952, // RNJ Asia/Tokyo
    5551, // RNL Pacific/Guadalcanal
    3646, // RNM Asia/Muscat
    4603, // RNN Europe/Copenhagen
    2054, // RNO America/Los_Angeles
    5638, // RNP Pacific/Majuro
    4906, // RNS Europe/Paris
    2054, // RNT America/Los_Angeles
    1405, // RNV America/Chicago
    1405, // RNZ America/Chicago
    2350, // ROA America/New_York
    560, // ROB Africa/Monrovia
    2350, // ROC America/New_York
    320, // ROD Africa/Johannesburg
    1405, // ROG America/Chicago
    3243, // ROI Asia/Barnaul
    4281, // ROK Australia/Brisbane
    1271, // RON America/Bogota
    2026, // ROO America/La_Paz
    5787, // ROP Pacific/Saipan
    std::numeric_limits<uint16_t>::max(), // ROR
    861, // ROS America/Argentina/Cordoba
    5372, // ROT Pacific/Auckland
    4880, // ROV Europe/Moscow
    1547, // ROW America/Denver
    940, // ROY America/Argentina/Rio_Gallegos
    1405, // RPB America/Chicago
    1405, // RPJ America/Chicago
    4906, // RPK Europe/Paris
    4339, // RPM Australia/Darwin
    3464, // RPN Asia/Jerusalem
    3547, // RPR Asia/Kolkata
    1547, // RPX America/Denver
    1547, // RQE America/Denver
    1405, // RQO America/Chicago
    5312, // RRG Indian/Mauritius
    3547, // RRK Asia/Kolkata
    1405, // RRL America/Chicago
    5802, // RRR Pacific/Tahiti
    4894, // RRS Europe/Oslo
    1405, // RRT America/Chicago
    971, // RSA America/Argentina/Salta
    2335, // RSD America/Nassau
    4425, // RSE Australia/Sydney
    749, // RSH America/Anchorage
    2054, // RSJ America/Los_Angeles
    1405, // RSN America/Chicago
    367, // RSS Africa/Kigali
    1405, // RST America/Chicago
    3829, // RSU Asia/Seoul
    1405, // RSV America/Chicago
    2350, // RSW America/New_York
    5487, // RTA Pacific/Fiji
    2901, // RTB America/Tegucigalpa
    3547, // RTC Asia/Kolkata
    std::numeric_limits<uint16_t>::max(), // RTG
    1405, // RTL America/Chicago
    4442, // RTM Europe/Amsterdam
    1547, // RTN America/Denver
    4409, // RTS Australia/Perth
    5004, // RTW Europe/Saratov
    454, // RUA Africa/Lubumbashi
    3927, // RUD Asia/Tehran
    1405, // RUE America/Chicago
    1405, // RUG America/Chicago
    3788, // RUH Asia/Riyadh
    1547, // RUI America/Denver
    3518, // RUK Asia/Kathmandu
    3518, // RUM Asia/Kathmandu
    5344, // RUN Indian/Reunion
    3347, // RUP Asia/Dhaka
    5802, // RUR Pacific/Tahiti
    5551, // RUS Pacific/Guadalcanal
    2350, // RUT America/New_York
    1775, // RUV America/Guatemala
    2901, // RUY America/Tegucigalpa
    5233, // RVA Indian/Antananarivo
    2759, // RVD America/Sao_Paulo
    1271, // RVE America/Bogota
    4880, // RVH Europe/Moscow
    4880, // RVI Europe/Moscow
    4894, // RVK Europe/Oslo
    4651, // RVN Europe/Helsinki
    1547, // RVR America/Denver
    1405, // RVS America/Chicago
    4409, // RVT Australia/Perth
    5802, // RVV Pacific/Tahiti
    2297, // RVY America/Montevideo
    2350, // RWI America/New_York
    1547, // RWL America/Denver
    4735, // RWN Europe/Kiev
    1405, // RWV America/Chicago
    1286, // RXE America/Boise
    3634, // RXS Asia/Manila
    4880, // RYB Europe/Moscow
    4894, // RYG Europe/Oslo
    3505, // RYK Asia/Karachi
    2494, // RYN America/Phoenix
    940, // RYO America/Argentina/Rio_Gallegos
    1405, // RYV America/Chicago
    2350, // RYY America/New_York
    940, // RZA America/Argentina/Rio_Gallegos
    5173, // RZE Europe/Warsaw
    4880, // RZN Europe/Moscow
    3634, // RZP Asia/Manila
    3927, // RZR Asia/Tehran
    3505, // RZS Asia/Karachi
    2350, // RZZ America/New_York
    1547, // SAA America/Denver
    2007, // SAB America/Kralendijk
    2054, // SAC America/Los_Angeles
    2494, // SAD America/Phoenix
    1547, // SAF America/Denver
    3547, // SAG Asia/Kolkata
    3113, // SAH Asia/Aden
    4207, // SAK Atlantic/Reykjavik
    1629, // SAL America/El_Salvador
    5748, // SAM Pacific/Port_Moresby
    2054, // SAN America/Los_Angeles
    2901, // SAP America/Tegucigalpa
    2335, // SAQ America/Nassau
    2054, // SAS America/Los_Angeles
    1405, // SAT America/Chicago
    3620, // SAU Asia/Makassar
    2350, // SAV America/New_York
    4686, // SAW Europe/Istanbul
    4962, // SAY Europe/Rome
    560, // SAZ Africa/Monrovia
    2054, // SBA America/Los_Angeles
    1358, // SBB America/Caracas
    2054, // SBD America/Los_Angeles
    3479, // SBF Asia/Kabul
    3450, // SBG Asia/Jayapura
    2791, // SBH America/St_Barthelemy
    179, // SBI Africa/Conakry
    2759, // SBJ America/Sao_Paulo
    4906, // SBK Europe/Paris
    2026, // SBL America/La_Paz
    1405, // SBM America/Chicago
    std::numeric_limits<uint16_t>::max(), // SBN
    1547, // SBO America/Denver
    2054, // SBP America/Los_Angeles
    3505, // SBQ Asia/Karachi
    4281, // SBR Australia/Brisbane
    1547, // SBS America/Denver
    4074, // SBT Asia/Yekaterinburg
    3595, // SBW Asia/Kuwait
    1547, // SBX America/Denver
    2350, // SBY America/New_York
    4554, // SBZ Europe/Bucharest
    1405, // SCB America/Chicago
    749, // SCC America/Anchorage
    1405, // SCD America/Chicago
    2350, // SCE America/New_York
    2494, // SCF America/Phoenix
    2350, // SCH America/New_York
    1358, // SCI America/Caracas
    2054, // SCK America/Los_Angeles
    2720, // SCL America/Santiago
    2367, // SCM America/Nome
    4506, // SCN Europe/Berlin
    3158, // SCO Asia/Aqtau
    4906, // SCP Europe/Paris
    4823, // SCQ Europe/Madrid
    4791, // SCS Europe/London
    3113, // SCT Asia/Aden
    1824, // SCU America/Havana
    4554, // SCV Europe/Bucharest
    4880, // SCW Europe/Moscow
    2226, // SCX America/Mexico_City
    5517, // SCY Pacific/Galapagos
    std::numeric_limits<uint16_t>::max(), // SCZ
    2350, // SDC America/New_York
    440, // SDD Africa/Luanda
    861, // SDE America/Argentina/Cordoba
    1951, // SDF America/Kentucky/Louisville
    3927, // SDG Asia/Tehran
    2901, // SDH America/Tegucigalpa
    5748, // SDI Pacific/Port_Moresby
    3952, // SDJ Asia/Tokyo
    3595, // SDK Asia/Kuwait
    5064, // SDL Europe/Stockholm
    2054, // SDM America/Los_Angeles
    4894, // SDN Europe/Oslo
    4490, // SDO Europe/Belgrade
    749, // SDP America/Anchorage
    2737, // SDQ America/Santo_Domingo
    4823, // SDR Europe/Madrid
    3952, // SDS Asia/Tokyo
    3505, // SDT Asia/Karachi
    2759, // SDU America/Sao_Paulo
    3464, // SDV Asia/Jerusalem
    2494, // SDX America/Phoenix
    1547, // SDY America/Denver
    2054, // SEA America/Los_Angeles
    692, // SEB Africa/Tripoli
    2054, // SEE America/Los_Angeles
    2350, // SEF America/New_York
    2350, // SEG America/New_York
    3869, // SEK Asia/Srednekolymsk
    1405, // SEM America/Chicago
    4791, // SEN Europe/London
    0, // SEO Africa/Abidjan
    3450, // SEQ Asia/Jayapura
    1858, // SER America/Indiana/Knox
    1405, // SES America/Chicago
    207, // SEU Africa/Dar_es_Salaam
    153, // SEW Africa/Cairo
    621, // SEY Africa/Nouakchott
    5284, // SEZ Indian/Mahe
    707, // SFA Africa/Tunis
    2350, // SFB America/New_York
    1756, // SFC America/Guadeloupe
    1358, // SFD America/Caracas
    3634, // SFE Asia/Manila
    2054, // SFF America/Los_Angeles
    767, // SFG America/Anguilla
    2955, // SFH America/Tijuana
    1705, // SFJ America/Godthab
    4571, // SFK Europe/Budapest
    4155, // SFL Atlantic/Cape_Verde
    2350, // SFM America/New_York
    861, // SFN America/Argentina/Cordoba
    2054, // SFO America/Los_Angeles
    4686, // SFQ Europe/Istanbul
    3634, // SFS Asia/Manila
    5064, // SFT Europe/Stockholm
    2350, // SFZ America/New_York
    3479, // SGA Asia/Kabul
    4074, // SGC Asia/Yekaterinburg
    4603, // SGD Europe/Copenhagen
    4506, // SGE Europe/Berlin
    1405, // SGF America/Chicago
    2350, // SGH America/New_York
    5748, // SGK Pacific/Port_Moresby
    1271, // SGL America/Bogota
    2157, // SGM America/Mazatlan
    3410, // SGN Asia/Ho_Chi_Minh
    4281, // SGO Australia/Brisbane
    4409, // SGP Australia/Perth
    1405, // SGR America/Chicago
    3634, // SGS Asia/Manila
    1405, // SGT America/Chicago
    1547, // SGU America/Denver
    971, // SGV America/Argentina/Salta
    2777, // SGW America/Sitka
    207, // SGX Africa/Dar_es_Salaam
    1936, // SGY America/Juneau
    3243, // SGZ Asia/Barnaul
    3840, // SHA Asia/Shanghai
    3952, // SHB Asia/Tokyo
    28, // SHC Africa/Addis_Ababa
    2350, // SHD America/New_York
    3840, // SHE Asia/Shanghai
    3991, // SHF Asia/Urumqi
    749, // SHG America/Anchorage
    2367, // SHH America/Nome
    3952, // SHI Asia/Tokyo
    3358, // SHJ Asia/Dubai
    514, // SHK Africa/Maseru
    3547, // SHL Asia/Kolkata
    3952, // SHM Asia/Tokyo
    2054, // SHN America/Los_Angeles
    3829, // SHO Asia/Seoul
    4281, // SHQ Australia/Brisbane
    1547, // SHR America/Denver
    3840, // SHS Asia/Shanghai
    4389, // SHT Australia/Melbourne
    4339, // SHU Australia/Darwin
    1405, // SHV America/Chicago
    3788, // SHW Asia/Riyadh
    749, // SHX America/Anchorage
    207, // SHY Africa/Dar_es_Salaam
    514, // SHZ Africa/Maseru
    3840, // SIA Asia/Shanghai
    134, // SIB Africa/Brazzaville
    2440, // SIC America/Panama
    4155, // SID Atlantic/Cape_Verde
    3518, // SIF Asia/Kathmandu
    2575, // SIG America/Puerto_Rico
    166, // SII Africa/Ceuta
    4207, // SIJ Atlantic/Reykjavik
    1405, // SIK America/Chicago
    3854, // SIN Asia/Singapore
    4372, // SIO Australia/Hobart
    5019, // SIP Europe/Simferopol
    3450, // SIQ Asia/Jayapura
    5219, // SIR Europe/Zurich
    320, // SIS Africa/Johannesburg
    2777, // SIT America/Sitka
    2089, // SIU America/Managua
    1858, // SIV America/Indiana/Knox
    3450, // SIW Asia/Jayapura
    3450, // SIX Asia/Jayapura
    2054, // SIY America/Los_Angeles
    2026, // SJB America/La_Paz
    2054, // SJC America/Los_Angeles
    2157, // SJD America/Mazatlan
    1271, // SJE America/Bogota
    3634, // SJI Asia/Manila
    4988, // SJJ Europe/Sarajevo
    2759, // SJK America/Sao_Paulo
    2105, // SJL America/Manaus
    2737, // SJM America/Santo_Domingo
    2494, // SJN America/Phoenix
    1439, // SJO America/Costa_Rica
    2759, // SJP America/Sao_Paulo
    2759, // SJQ America/Sao_Paulo
    2026, // SJS America/La_Paz
    1405, // SJT America/Chicago
    2575, // SJU America/Puerto_Rico
    2026, // SJV America/La_Paz
    3840, // SJW Asia/Shanghai
    1343, // SJX America/Cancun
    4651, // SJY Europe/Helsinki
    4106, // SJZ Atlantic/Azores
    2830, // SKB America/St_Kitts
    5748, // SKC Pacific/Port_Moresby
    3814, // SKD Asia/Samarkand
    4894, // SKE Europe/Oslo
    1405, // SKF America/Chicago
    4476, // SKG Europe/Athens
    3518, // SKH Asia/Kathmandu
    47, // SKI Africa/Algiers
    749, // SKK America/Anchorage
    4791, // SKL Europe/London
    4894, // SKN Europe/Oslo
    397, // SKO Africa/Lagos
    5037, // SKP Europe/Skopje
    514, // SKQ Africa/Maseru
    28, // SKR Africa/Addis_Ababa
    4603, // SKS Europe/Copenhagen
    3505, // SKT Asia/Karachi
    4476, // SKU Europe/Athens
    153, // SKV Africa/Cairo
    749, // SKW America/Anchorage
    4880, // SKX Europe/Moscow
    2350, // SKY America/New_York
    3505, // SKZ Asia/Karachi
    971, // SLA America/Argentina/Salta
    1405, // SLB America/Chicago
    1547, // SLC America/Denver
    4520, // SLD Europe/Bratislava
    2054, // SLE America/Los_Angeles
    1405, // SLG America/Chicago
    5455, // SLH Pacific/Efate
    472, // SLI Africa/Lusaka
    4409, // SLJ Australia/Perth
    2350, // SLK America/New_York
    3646, // SLL Asia/Muscat
    4823, // SLM Europe/Madrid
    1405, // SLN America/Chicago
    1405, // SLO America/Chicago
    2226, // SLP America/Mexico_City
    749, // SLQ America/Anchorage
    1405, // SLR America/Chicago
    5051, // SLS Europe/Sofia
    1547, // SLT America/Denver
    2847, // SLU America/St_Lucia
    3547, // SLV Asia/Kolkata
    2279, // SLW America/Monterrey
    1721, // SLX America/Grand_Turk
    4074, // SLY Asia/Yekaterinburg
    1669, // SLZ America/Fortaleza
    4106, // SMA Atlantic/Azores
    2595, // SMB America/Punta_Arenas
    4490, // SMC Europe/Belgrade
    1858, // SMD America/Indiana/Knox
    2350, // SME America/New_York
    2054, // SMF America/Los_Angeles
    2041, // SMG America/Lima
    4476, // SMI Europe/Athens
    2367, // SMK America/Nome
    2335, // SML America/Nassau
    3595, // SMM Asia/Kuwait
    1286, // SMN America/Boise
    2054, // SMO America/Los_Angeles
    5748, // SMP Pacific/Port_Moresby
    3732, // SMQ Asia/Pontianak
    1271, // SMR America/Bogota
    5233, // SMS Indian/Antananarivo
    1474, // SMT America/Cuiaba
    5219, // SMV Europe/Zurich
    258, // SMW Africa/El_Aaiun
    2054, // SMX America/Los_Angeles
    194, // SMY Africa/Dakar
    2475, // SMZ America/Paramaribo
    2054, // SNA America/Los_Angeles
    4339, // SNB Australia/Darwin
    1793, // SNC America/Guyana
    4155, // SNE Atlantic/Cape_Verde
    1358, // SNF America/Caracas
    2026, // SNG America/La_Paz
    4281, // SNH Australia/Brisbane
    560, // SNI Africa/Monrovia
    1405, // SNK America/Chicago
    1405, // SNL America/Chicago
    2026, // SNM America/La_Paz
    4621, // SNN Europe/Dublin
    3243, // SNO Asia/Barnaul
    2367, // SNP America/Nome
    4906, // SNR Europe/Paris
    2054, // SNS America/Los_Angeles
    1271, // SNT America/Bogota
    1824, // SNU America/Havana
    1358, // SNV America/Caracas
    4062, // SNW Asia/Yangon
    2737, // SNX America/Santo_Domingo
    1547, // SNY America/Denver
    2759, // SNZ America/Sao_Paulo
    4571, // SOB Europe/Budapest
    3450, // SOC Asia/Jayapura
    2759, // SOD America/Sao_Paulo
    134, // SOE Africa/Brazzaville
    5051, // SOF Europe/Sofia
    4894, // SOG Europe/Oslo
    4894, // SOJ Europe/Oslo
    514, // SOK Africa/Maseru
    1358, // SOM America/Caracas
    5455, // SON Pacific/Efate
    5064, // SOO Europe/Stockholm
    2350, // SOP America/New_York
    3450, // SOQ Asia/Jayapura
    4791, // SOU Europe/London
    749, // SOV America/Anchorage
    2494, // SOW America/Phoenix
    1271, // SOX America/Bogota
    4791, // SOY Europe/London
    2350, // SPA America/New_York
    2864, // SPB America/St_Thomas
    4139, // SPC Atlantic/Canary
    3347, // SPD Asia/Dhaka
    1547, // SPF America/Denver
    2350, // SPG America/New_York
    1405, // SPI America/Chicago
    4476, // SPJ Europe/Athens
    4490, // SPL Europe/Belgrade
    2737, // SPM America/Santo_Domingo
    5787, // SPN Pacific/Saipan
    440, // SPP Africa/Luanda
    1217, // SPR America/Belize
    1405, // SPS America/Chicago
    5187, // SPU Europe/Zagreb
    4490, // SPV Europe/Belgrade
    1405, // SPW America/Chicago
    153, // SPX Africa/Cairo
    0, // SPY Africa/Abidjan
    1405, // SPZ America/Chicago
    2054, // SQA America/Los_Angeles
    4409, // SQC Australia/Perth
    3840, // SQD Asia/Shanghai
    3732, // SQG Asia/Pontianak
    3410, // SQH Asia/Ho_Chi_Minh
    3840, // SQJ Asia/Shanghai
    2054, // SQL America/Los_Angeles
    5064, // SQO Europe/Stockholm
    5141, // SQQ Europe/Vilnius
    3620, // SQR Asia/Makassar
    1217, // SQS America/Belize
    2054, // SQV America/Los_Angeles
    4603, // SQW Europe/Copenhagen
    2759, // SQX America/Sao_Paulo
    2759, // SQY America/Sao_Paulo
    2759, // SRA America/Sao_Paulo
    2026, // SRB America/La_Paz
    1405, // SRC America/Chicago
    2026, // SRD America/La_Paz
    2026, // SRE America/La_Paz
    3450, // SRG Asia/Jayapura
    591, // SRH Africa/Ndjamena
    3620, // SRI Asia/Makassar
    2026, // SRJ America/La_Paz
    4372, // SRN Australia/Hobart
    4894, // SRP Europe/Oslo
    2350, // SRQ America/New_York
    352, // SRT Africa/Kampala
    749, // SRV America/Anchorage
    2350, // SRW America/New_York
    3927, // SRY Asia/Tehran
    2026, // SRZ America/La_Paz
    1149, // SSA America/Bahia
    2864, // SSB America/St_Thomas
    2720, // SSD America/Santiago
    3547, // SSE Asia/Kolkata
    1405, // SSF America/Chicago
    486, // SSG Africa/Malabo
    153, // SSH Africa/Cairo
    2350, // SSI America/New_York
    4894, // SSJ Europe/Oslo
    1271, // SSL America/Bogota
    2971, // SSM America/Toronto
    2759, // SSO America/Sao_Paulo
    2971, // SSQ America/Toronto
    5455, // SSR Pacific/Efate
    802, // SST America/Argentina/Buenos_Aires
    440, // SSY Africa/Luanda
    4603, // STA Europe/Copenhagen
    1358, // STB America/Caracas
    1405, // STC America/Chicago
    1358, // STD America/Caracas
    1405, // STE America/Chicago
    1405, // STF America/Chicago
    2367, // STG America/Nome
    1595, // STH America/Edmonton
    2737, // STI America/Santo_Domingo
    1405, // STJ America/Chicago
    2703, // STM America/Santarem
    4791, // STN Europe/London
    1405, // STP America/Chicago
    2350, // STQ America/New_York
    4506, // STR Europe/Berlin
    2864, // STT America/St_Thomas
    3547, // STV Asia/Kolkata
    4880, // STW Europe/Moscow
    2864, // STX America/St_Thomas
    861, // STY America/Argentina/Cordoba
    1474, // STZ America/Cuiaba
    2350, // SUA America/New_York
    3450, // SUB Asia/Jayapura
    1405, // SUD America/Chicago
    1405, // SUE America/Chicago
    4962, // SUF Europe/Rome
    3634, // SUG Asia/Manila
    3646, // SUH Asia/Muscat
    3914, // SUI Asia/Tbilisi
    4554, // SUJ Europe/Bucharest
    4049, // SUK Asia/Yakutsk
    3505, // SUL Asia/Karachi
    2350, // SUM America/New_York
    1286, // SUN America/Boise
    2054, // SUO America/Los_Angeles
    3450, // SUP Asia/Jayapura
    1793, // SUQ America/Guyana
    2971, // SUR America/Toronto
    1405, // SUS America/Chicago
    207, // SUT Africa/Dar_es_Salaam
    5487, // SUV Pacific/Fiji
    1405, // SUW America/Chicago
    1405, // SUX America/Chicago
    4049, // SUY Asia/Yakutsk
    802, // SUZ America/Argentina/Buenos_Aires
    2367, // SVA America/Nome
    5233, // SVB Indian/Antananarivo
    1547, // SVC America/Denver
    2882, // SVD America/St_Vincent
    2054, // SVE America/Los_Angeles
    658, // SVF Africa/Porto-Novo
    4894, // SVG Europe/Oslo
    1271, // SVI America/Bogota
    4894, // SVJ Europe/Oslo
    1217, // SVK America/Belize
    4651, // SVL Europe/Helsinki
    4880, // SVO Europe/Moscow
    440, // SVP Africa/Luanda
    4823, // SVQ Europe/Madrid
    749, // SVS America/Anchorage
    290, // SVT Africa/Gaborone
    5487, // SVU Pacific/Fiji
    749, // SVW America/Anchorage
    4074, // SVX Asia/Yekaterinburg
    1271, // SVZ America/Bogota
    3840, // SWA Asia/Shanghai
    4389, // SWC Australia/Melbourne
    749, // SWD America/Anchorage
    5748, // SWE Pacific/Port_Moresby
    2350, // SWF America/New_York
    4389, // SWH Australia/Melbourne
    1405, // SWI America/Chicago
    5455, // SWJ Pacific/Efate
    1405, // SWO America/Chicago
    720, // SWP Africa/Windhoek
    3620, // SWQ Asia/Makassar
    4791, // SWS Europe/London
    3963, // SWT Asia/Tomsk
    3607, // SWV Asia/Magadan
    1405, // SWW America/Chicago
    720, // SWX Africa/Windhoek
    3577, // SWY Asia/Kuala_Lumpur
    4906, // SXB Europe/Paris
    4389, // SXE Australia/Melbourne
    4506, // SXF Europe/Berlin
    472, // SXG Africa/Lusaka
    3927, // SXI Asia/Tehran
    4621, // SXL Europe/Dublin
    767, // SXM America/Anguilla
    290, // SXN Africa/Gaborone
    1474, // SXO America/Cuiaba
    2367, // SXP America/Nome
    749, // SXQ America/Anchorage
    3547, // SXR Asia/Kolkata
    28, // SXU Africa/Addis_Ababa
    3547, // SXV Asia/Kolkata
    1203, // SXX America/Belem
    2350, // SXY America/New_York
    4686, // SXZ Europe/Istanbul
    749, // SYB America/Anchorage
    4425, // SYD Australia/Sydney
    3113, // SYE Asia/Aden
    3518, // SYH Asia/Kathmandu
    1405, // SYI America/Chicago
    3927, // SYJ Asia/Tehran
    4207, // SYK Atlantic/Reykjavik
    3840, // SYM Asia/Shanghai
    1405, // SYN America/Chicago
    3952, // SYO Asia/Tokyo
    2440, // SYP America/Panama
    1439, // SYQ America/Costa_Rica
    2350, // SYR America/New_York
    4049, // SYS Asia/Yakutsk
    4906, // SYT Europe/Paris
    4281, // SYU Australia/Brisbane
    3505, // SYW Asia/Karachi
    3840, // SYX Asia/Shanghai
    4791, // SYY Europe/London
    3927, // SYZ Asia/Tehran
    440, // SZA Africa/Luanda
    3577, // SZB Asia/Kuala_Lumpur
    28, // SZE Africa/Addis_Ababa
    4686, // SZF Europe/Istanbul
    4506, // SZG Europe/Berlin
    3123, // SZI Asia/Almaty
    1824, // SZJ America/Havana
    320, // SZK Africa/Johannesburg
    2054, // SZN America/Los_Angeles
    2054, // SZP America/Los_Angeles
    5051, // SZR Europe/Sofia
    5372, // SZS Pacific/Auckland
    2226, // SZT America/Mexico_City
    3840, // SZV Asia/Shanghai
    4506, // SZW Europe/Berlin
    3840, // SZX Asia/Shanghai
    5173, // SZY Europe/Warsaw
    5173, // SZZ Europe/Warsaw
    2533, // TAB America/Port_of_Spain
    3634, // TAC Asia/Manila
    1547, // TAD America/Denver
    3829, // TAE Asia/Seoul
    47, // TAF Africa/Algiers
    3634, // TAG Asia/Manila
    std::numeric_limits<uint16_t>::max(), // TAH
    3113, // TAI Asia/Aden
    5748, // TAJ Pacific/Port_Moresby
    3952, // TAK Asia/Tokyo
    749, // TAL America/Anchorage
    2279, // TAM America/Monterrey
    2350, // TAN America/New_York
    3840, // TAO Asia/Shanghai
    2226, // TAP America/Mexico_City
    4962, // TAR Europe/Rome
    3900, // TAS Asia/Tashkent
    4520, // TAT Europe/Bratislava
    5714, // TAV Pacific/Pago_Pago
    2297, // TAW America/Montevideo
    5081, // TAY Europe/Tallinn
    3181, // TAZ Asia/Ashgabat
    3320, // TBA Asia/Colombo
    3410, // TBB Asia/Ho_Chi_Minh
    1547, // TBC America/Denver
    5817, // TBF Pacific/Tarawa
    3450, // TBG Asia/Jayapura
    3634, // TBH Asia/Manila
    2335, // TBI America/Nassau
    707, // TBJ Africa/Tunis
    1405, // TBN America/Chicago
    207, // TBO Africa/Dar_es_Salaam
    2041, // TBP America/Lima
    2350, // TBR America/New_York
    3914, // TBS Asia/Tbilisi
    2041, // TBT America/Lima
    5832, // TBU Pacific/Tongatapu
    4880, // TBW Europe/Moscow
    290, // TBY Africa/Gaborone
    3927, // TBZ Asia/Tehran
    4339, // TCA Australia/Darwin
    2335, // TCB America/Nassau
    1547, // TCC America/Denver
    1271, // TCD America/Bogota
    4554, // TCE Europe/Bucharest
    3991, // TCG Asia/Urumqi
    410, // TCH Africa/Libreville
    1405, // TCL America/Chicago
    2226, // TCN America/Mexico_City
    1271, // TCO America/Bogota
    153, // TCP Africa/Cairo
    2041, // TCQ America/Lima
    3547, // TCR Asia/Kolkata
    1547, // TCS America/Denver
    749, // TCT America/Anchorage
    4425, // TCW Australia/Sydney
    3927, // TCX Asia/Tehran
    2054, // TCY America/Los_Angeles
    3840, // TCZ Asia/Shanghai
    1271, // TDA America/Bogota
    2026, // TDD America/La_Paz
    2350, // TDF America/New_York
    3634, // TDG Asia/Manila
    228, // TDJ Africa/Djibouti
    802, // TDL America/Argentina/Buenos_Aires
    2054, // TDO America/Los_Angeles
    5748, // TDS Pacific/Port_Moresby
    1405, // TDW America/Chicago
    3243, // TDX Asia/Barnaul
    2350, // TDZ America/New_York
    2901, // TEA America/Tegucigalpa
    2350, // TEB America/New_York
    2759, // TEC America/Sao_Paulo
    4603, // TED Europe/Copenhagen
    47, // TEE Africa/Algiers
    4409, // TEF Australia/Perth
    639, // TEG Africa/Ouagadougou
    3547, // TEI Asia/Kolkata
    749, // TEK America/Anchorage
    3595, // TEL Asia/Kuwait
    4425, // TEM Australia/Sydney
    3840, // TEN Asia/Shanghai
    4106, // TER Atlantic/Azores
    62, // TES Africa/Asmara
    500, // TET Africa/Maputo
    5372, // TEU Pacific/Auckland
    4823, // TEV Europe/Madrid
    1562, // TEW America/Detroit
    1547, // TEX America/Denver
    4207, // TEY Atlantic/Reykjavik
    3547, // TEZ Asia/Kolkata
    2105, // TFF America/Manaus
    5748, // TFI Pacific/Port_Moresby
    2759, // TFL America/Sao_Paulo
    5748, // TFM Pacific/Port_Moresby
    4139, // TFN Atlantic/Canary
    4139, // TFS Atlantic/Canary
    3595, // TGC Asia/Kuwait
    4919, // TGD Europe/Podgorica
    1405, // TGE America/Chicago
    3577, // TGG Asia/Kuala_Lumpur
    5455, // TGH Pacific/Efate
    2041, // TGI America/Lima
    5699, // TGJ Pacific/Noumea
    4554, // TGM Europe/Bucharest
    4389, // TGN Australia/Melbourne
    3840, // TGO Asia/Shanghai
    3560, // TGP Asia/Krasnoyarsk
    1474, // TGQ America/Cuiaba
    47, // TGR Africa/Algiers
    500, // TGS Africa/Maputo
    207, // TGT Africa/Dar_es_Salaam
    2901, // TGU America/Tegucigalpa
    5051, // TGV Europe/Sofia
    2226, // TGZ America/Mexico_City
    1405, // THA America/Chicago
    514, // THB Africa/Maseru
    560, // THC Africa/Monrovia
    3410, // THD Asia/Ho_Chi_Minh
    1669, // THE America/Fortaleza
    4281, // THG Australia/Brisbane
    621, // THI Africa/Nouakchott
    4062, // THL Asia/Yangon
    1547, // THM America/Denver
    5064, // THN Europe/Stockholm
    4207, // THO Atlantic/Reykjavik
    1547, // THP America/Denver
    3840, // THQ Asia/Shanghai
    3927, // THR Asia/Tehran
    3243, // THS Asia/Barnaul
    621, // THT Africa/Nouakchott
    2350, // THV America/New_York
    3560, // THX Asia/Krasnoyarsk
    607, // THZ Africa/Niamey
    5096, // TIA Europe/Tirane
    1271, // TIB America/Bogota
    5638, // TIC Pacific/Majuro
    47, // TID Africa/Algiers
    28, // TIE Africa/Addis_Ababa
    3788, // TIF Asia/Riyadh
    5802, // TIH Pacific/Tahiti
    3479, // TII Asia/Kabul
    2054, // TIJ America/Los_Angeles
    1595, // TIL America/Edmonton
    3450, // TIM Asia/Jayapura
    47, // TIN Africa/Algiers
    692, // TIP Africa/Tripoli
    std::numeric_limits<uint16_t>::max(), // TIQ
    3547, // TIR Asia/Kolkata
    5372, // TIU Pacific/Auckland
    4919, // TIV Europe/Podgorica
    2054, // TIW America/Los_Angeles
    2350, // TIX America/New_York
    621, // TIY Africa/Nouakchott
    5748, // TIZ Pacific/Port_Moresby
    2026, // TJA America/La_Paz
    3450, // TJB Asia/Jayapura
    3732, // TJG Asia/Pontianak
    3952, // TJH Asia/Tokyo
    2901, // TJI America/Tegucigalpa
    4686, // TJK Europe/Istanbul
    1322, // TJL America/Campo_Grande
    4074, // TJM Asia/Yekaterinburg
    3450, // TJQ Asia/Jayapura
    3620, // TJS Asia/Makassar
    3369, // TJU Asia/Dushanbe
    749, // TKA America/Anchorage
    244, // TKC Africa/Douala
    15, // TKD Africa/Accra
    1936, // TKE America/Juneau
    2054, // TKF America/Los_Angeles
    3450, // TKG Asia/Jayapura
    3243, // TKH Asia/Barnaul
    2777, // TKI America/Sitka
    749, // TKJ America/Anchorage
    5426, // TKK Pacific/Chuuk
    std::numeric_limits<uint16_t>::max(), // TKN
    514, // TKO Africa/Maseru
    207, // TKQ Africa/Dar_es_Salaam
    std::numeric_limits<uint16_t>::max(), // TKR
    3952, // TKS Asia/Tokyo
    3243, // TKT Asia/Barnaul
    4651, // TKU Europe/Helsinki
    5802, // TKV Pacific/Tahiti
    std::numeric_limits<uint16_t>::max(), // TKW
    5802, // TKX Pacific/Tahiti
    5372, // TKZ Pacific/Auckland
    2367, // TLA America/Nome
    3505, // TLB Asia/Karachi
    2226, // TLC America/Mexico_City
    290, // TLD Africa/Gaborone
    5233, // TLE Indian/Antananarivo
    749, // TLF America/Anchorage
    2350, // TLH America/New_York
    3620, // TLI Asia/Makassar
    749, // TLJ America/Anchorage
    4049, // TLK Asia/Yakutsk
    5081, // TLL Europe/Tallinn
    47, // TLM Africa/Algiers
    4906, // TLN Europe/Paris
    3991, // TLQ Asia/Urumqi
    2054, // TLR America/Los_Angeles
    4906, // TLS Europe/Paris
    749, // TLT America/Anchorage
    1271, // TLU America/Bogota
    3464, // TLV Asia/Jerusalem
    2720, // TLX America/Santiago
    2759, // TLZ America/Sao_Paulo
    2350, // TMA America/New_York
    2350, // TMB America/New_York
    3620, // TMC Asia/Makassar
    621, // TMD Africa/Nouakchott
    1271, // TME America/Bogota
    5296, // TMF Indian/Maldives
    3595, // TMG Asia/Kuwait
    3518, // TMI Asia/Kathmandu
    std::numeric_limits<uint16_t>::max(), // TMJ
    2054, // TMK America/Los_Angeles
    15, // TML Africa/Accra
    5233, // TMM Indian/Antananarivo
    std::numeric_limits<uint16_t>::max(), // TMN
    1358, // TMO America/Caracas
    4651, // TMP Europe/Helsinki
    639, // TMQ Africa/Ouagadougou
    47, // TMR Africa/Algiers
    676, // TMS Africa/Sao_Tome
    2703, // TMT America/Santarem
    1439, // TMU America/Costa_Rica
    4425, // TMW Australia/Sydney
    47, // TMX Africa/Algiers
    5372, // TMZ Pacific/Auckland
    3840, // TNA Asia/Shanghai
    2367, // TNC America/Nome
    1824, // TND America/Havana
    3952, // TNE Asia/Tokyo
    4906, // TNF Europe/Paris
    166, // TNG Africa/Ceuta
    3840, // TNH Asia/Shanghai
    3547, // TNI Asia/Kolkata
    3450, // TNJ Asia/Jayapura
    2367, // TNK America/Nome
    4735, // TNL Europe/Kiev
    3888, // TNN Asia/Taipei
    1439, // TNO America/Costa_Rica
    2054, // TNP America/Los_Angeles
    5233, // TNR Indian/Antananarivo
    3073, // TNS America/Yellowknife
    2350, // TNT America/New_York
    1405, // TNU America/Chicago
    1793, // TNW America/Guyana
    3716, // TNX Asia/Phnom_Penh
    2054, // TOA America/Los_Angeles
    692, // TOB Africa/Tripoli
    2350, // TOC America/New_York
    3577, // TOD Asia/Kuala_Lumpur
    707, // TOE Africa/Tunis
    3963, // TOF Asia/Tomsk
    749, // TOG America/Anchorage
    5455, // TOH Pacific/Efate
    1405, // TOI America/Chicago
    2350, // TOL America/New_York
    76, // TOM Africa/Bamako
    1439, // TOO America/Costa_Rica
    1405, // TOP America/Chicago
    2720, // TOQ America/Santiago
    1547, // TOR America/Denver
    4894, // TOS Europe/Oslo
    2475, // TOT America/Paramaribo
    5699, // TOU Pacific/Noumea
    2759, // TOW America/Sao_Paulo
    3952, // TOY Asia/Tokyo
    0, // TOZ Africa/Abidjan
    2350, // TPA America/New_York
    1793, // TPC America/Guyana
    3888, // TPE Asia/Taipei
    2350, // TPF America/New_York
    3577, // TPG Asia/Kuala_Lumpur
    2054, // TPH America/Los_Angeles
    5748, // TPI Pacific/Port_Moresby
    3518, // TPJ Asia/Kathmandu
    1405, // TPL America/Chicago
    1793, // TPN America/Guyana
    2041, // TPP America/Lima
    2157, // TPQ America/Mazatlan
    4409, // TPR Australia/Perth
    4962, // TPS Europe/Rome
    3518, // TPU Asia/Kathmandu
    1405, // TQH America/Chicago
    802, // TQL America/Argentina/Buenos_Aires
    3479, // TQN Asia/Kabul
    4281, // TQP Australia/Brisbane
    3952, // TRA Asia/Tokyo
    1271, // TRB America/Bogota
    2279, // TRC America/Monterrey
    4894, // TRD Europe/Oslo
    4791, // TRE Europe/London
    4894, // TRF Europe/Oslo
    5372, // TRG Pacific/Auckland
    2054, // TRH America/Los_Angeles
    2350, // TRI America/New_York
    3620, // TRK Asia/Makassar
    1405, // TRL America/Chicago
    2054, // TRM America/Los_Angeles
    4962, // TRN Europe/Rome
    4425, // TRO Australia/Sydney
    2684, // TRQ America/Rio_Branco
    4962, // TRS Europe/Rome
    2041, // TRU America/Lima
    3547, // TRV Asia/Kolkata
    5817, // TRW Pacific/Tarawa
    1405, // TRX America/Chicago
    352, // TRY Africa/Kampala
    3547, // TRZ Asia/Kolkata
    720, // TSB Africa/Windhoek
    1793, // TSC America/Guyana
    3123, // TSE Asia/Almaty
    4962, // TSF Europe/Rome
    749, // TSG America/Anchorage
    454, // TSH Africa/Lubumbashi
    std::numeric_limits<uint16_t>::max(), // TSJ
    2226, // TSL America/Mexico_City
    1547, // TSM America/Denver
    3840, // TSN Asia/Shanghai
    4791, // TSO Europe/London
    2054, // TSP America/Los_Angeles
    2759, // TSQ America/Sao_Paulo
    4554, // TSR Europe/Bucharest
    2350, // TSS America/New_York
    3243, // TST Asia/Barnaul
    5817, // TSU Pacific/Tarawa
    4281, // TSV Australia/Brisbane
    3450, // TSY Asia/Jayapura
    166, // TTA Africa/Ceuta
    4962, // TTB Europe/Rome
    2720, // TTC America/Santiago
    2054, // TTD America/Los_Angeles
    3450, // TTE Asia/Jayapura
    971, // TTG America/Argentina/Salta
    3952, // TTJ Asia/Tokyo
    1271, // TTM America/Bogota
    2350, // TTN America/New_York
    1405, // TTO America/Chicago
    1439, // TTQ America/Costa_Rica
    3620, // TTR Asia/Makassar
    5233, // TTS Indian/Antananarivo
    3888, // TTT Asia/Taipei
    166, // TTU Africa/Ceuta
    1271, // TUA America/Bogota
    5802, // TUB Pacific/Tahiti
    1049, // TUC America/Argentina/Tucuman
    194, // TUD Africa/Dakar
    4906, // TUF Europe/Paris
    3634, // TUG Asia/Manila
    3788, // TUI Asia/Riyadh
    28, // TUJ Africa/Addis_Ababa
    3505, // TUK Asia/Karachi
    1405, // TUL America/Chicago
    4425, // TUM Australia/Sydney
    707, // TUN Africa/Tunis
    5372, // TUO Pacific/Auckland
    1405, // TUP America/Chicago
    639, // TUQ Africa/Ouagadougou
    1203, // TUR America/Belem
    2494, // TUS America/Phoenix
    3788, // TUU Asia/Riyadh
    1358, // TUV America/Caracas
    1526, // TUX America/Dawson_Creek
    5233, // TVA Indian/Antananarivo
    1562, // TVC America/Detroit
    1405, // TVF America/Chicago
    2350, // TVI America/New_York
    1405, // TVK America/Chicago
    2054, // TVL America/Los_Angeles
    3840, // TVS Asia/Shanghai
    5487, // TVU Pacific/Fiji
    4062, // TVY Asia/Yangon
    749, // TWA America/Anchorage
    4281, // TWB Australia/Brisbane
    2054, // TWD America/Los_Angeles
    1286, // TWF America/Boise
    3595, // TWU Asia/Kuwait
    5372, // TWZ Pacific/Auckland
    3450, // TXE Asia/Jayapura
    1149, // TXF America/Bahia
    3888, // TXG Asia/Taipei
    1405, // TXK America/Chicago
    4506, // TXL Europe/Berlin
    3840, // TXN Asia/Shanghai
    0, // TXU Africa/Abidjan
    4880, // TYA Europe/Moscow
    4425, // TYB Australia/Sydney
    4049, // TYD Asia/Yakutsk
    749, // TYE America/Anchorage
    5064, // TYF Europe/Stockholm
    2041, // TYL America/Lima
    2335, // TYM America/Nassau
    3840, // TYN Asia/Shanghai
    1858, // TYQ America/Indiana/Knox
    1405, // TYR America/Chicago
    2350, // TYS America/New_York
    2297, // TYT America/Montevideo
    2494, // TYZ America/Phoenix
    1217, // TZA America/Belize
    1562, // TZC America/Detroit
    4988, // TZL Europe/Sarajevo
    2350, // TZR America/New_York
    4686, // TZX Europe/Istanbul
    2955, // UAC America/Tijuana
    3358, // UAI Asia/Dubai
    1705, // UAK America/Godthab
    440, // UAL Africa/Luanda
    2054, // UAO America/Los_Angeles
    995, // UAQ America/Argentina/San_Juan
    166, // UAR Africa/Ceuta
    576, // UAS Africa/Nairobi
    1775, // UAX America/Guatemala
    2759, // UBA America/Sao_Paulo
    4281, // UBB Australia/Brisbane
    4962, // UBE Europe/Rome
    5389, // UBI Pacific/Bougainville
    3952, // UBJ Asia/Tokyo
    3243, // UBP Asia/Barnaul
    1405, // UBS America/Chicago
    2759, // UBT America/Sao_Paulo
    2350, // UCA America/New_York
    3840, // UCB Asia/Shanghai
    2054, // UCC America/Los_Angeles
    4735, // UCK Europe/Kiev
    std::numeric_limits<uint16_t>::max(), // UCN
    2350, // UCP America/New_York
    4880, // UCT Europe/Moscow
    1405, // UCY America/Chicago
    2041, // UCZ America/Lima
    2054, // UDD America/Los_Angeles
    2350, // UDG America/New_York
    2759, // UDI America/Sao_Paulo
    4520, // UDJ Europe/Bratislava
    3620, // UDL Asia/Makassar
    4962, // UDN Europe/Rome
    3547, // UDR Asia/Kolkata
    4372, // UEE Australia/Hobart
    500, // UEL Africa/Maputo
    std::numeric_limits<uint16_t>::max(), // UEO
    1405, // UES America/Chicago
    3505, // UET Asia/Karachi
    4074, // UFA Asia/Yekaterinburg
    3974, // UGA Asia/Ulaanbaatar
    749, // UGB America/Anchorage
    3814, // UGC Asia/Samarkand
    1405, // UGN America/Chicago
    440, // UGO Africa/Luanda
    749, // UGS America/Anchorage
    4936, // UHE Europe/Prague
    1271, // UIB America/Bogota
    3410, // UIH Asia/Ho_Chi_Minh
    2901, // UII America/Tegucigalpa
    3437, // UIK Asia/Irkutsk
    2054, // UIL America/Los_Angeles
    1405, // UIN America/Chicago
    1793, // UIO America/Guyana
    4906, // UIP Europe/Paris
    4425, // UIR Australia/Sydney
    5638, // UIT Pacific/Majuro
    5638, // UJE Pacific/Majuro
    3840, // UJU Asia/Shanghai
    576, // UKA Africa/Nairobi
    3952, // UKB Asia/Tokyo
    4032, // UKG Asia/Vladivostok
    2054, // UKI America/Los_Angeles
    3123, // UKK Asia/Almaty
    1405, // UKL America/Chicago
    3113, // UKR Asia/Aden
    5019, // UKS Europe/Simferopol
    2350, // UKT America/New_York
    3437, // UKX Asia/Irkutsk
    940, // ULA America/Argentina/Rio_Gallegos
    5455, // ULB Pacific/Efate
    2720, // ULC America/Santiago
    320, // ULD Africa/Johannesburg
    3427, // ULG Asia/Hovd
    3788, // ULH Asia/Riyadh
    4049, // ULK Asia/Yakutsk
    1405, // ULM America/Chicago
    3974, // ULN Asia/Ulaanbaatar
    3427, // ULO Asia/Hovd
    4281, // ULP Australia/Brisbane
    1271, // ULQ America/Bogota
    352, // ULU Africa/Kampala
    5110, // ULV Europe/Ulyanovsk
    5110, // ULY Europe/Ulyanovsk
    3427, // ULZ Asia/Hovd
    1824, // UMA America/Havana
    5064, // UME Europe/Stockholm
    749, // UMM America/Anchorage
    1858, // UMP America/Indiana/Knox
    3533, // UMS Asia/Khandyga
    749, // UMT America/Anchorage
    2759, // UMU America/Sao_Paulo
    4735, // UMY Europe/Kiev
    1149, // UNA America/Bahia
    3479, // UND Asia/Kabul
    514, // UNE Africa/Maseru
    std::numeric_limits<uint16_t>::max(), // UNG
    2882, // UNI America/St_Vincent
    749, // UNK America/Anchorage
    3243, // UNN Asia/Barnaul
    1405, // UNO America/Chicago
    1405, // UNU America/Chicago
    1405, // UOS America/Chicago
    1405, // UOX America/Chicago
    1824, // UPB America/Havana
    3620, // UPG Asia/Makassar
    1439, // UPL America/Costa_Rica
    2226, // UPN America/Mexico_City
    5584, // UPP Pacific/Honolulu
    3706, // URA Asia/Oral
    1322, // URB America/Campo_Grande
    3991, // URC Asia/Urumqi
    5081, // URE Europe/Tallinn
    861, // URG America/Argentina/Cordoba
    4074, // URJ Asia/Yekaterinburg
    4906, // URO Europe/Paris
    1271, // URR America/Bogota
    4880, // URS Europe/Moscow
    3243, // URT Asia/Barnaul
    3788, // URY Asia/Riyadh
    1075, // USH America/Argentina/Ushuaia
    1358, // USI America/Caracas
    4880, // USK Europe/Moscow
    3243, // USM Asia/Barnaul
    3829, // USN Asia/Seoul
    4686, // USQ Europe/Istanbul
    4003, // USR Asia/Ust-Nera
    1824, // USS America/Havana
    2350, // UST America/New_York
    3634, // USU Asia/Manila
    306, // UTA Africa/Harare
    4281, // UTB Australia/Brisbane
    514, // UTG Africa/Maseru
    3243, // UTH Asia/Barnaul
    5638, // UTK Pacific/Majuro
    1405, // UTM America/Chicago
    320, // UTN Africa/Johannesburg
    749, // UTO America/Anchorage
    3243, // UTP Asia/Barnaul
    4880, // UTS Europe/Moscow
    320, // UTT Africa/Johannesburg
    4880, // UUA Europe/Moscow
    3437, // UUD Asia/Irkutsk
    749, // UUK America/Anchorage
    3304, // UUN Asia/Choibalsan
    3800, // UUS Asia/Sakhalin
    1405, // UVA America/Chicago
    5699, // UVE Pacific/Noumea
    2847, // UVF America/St_Lucia
    153, // UVL Africa/Cairo
    2350, // UWA America/New_York
    1405, // UXL America/Chicago
    2350, // UYF America/New_York
    367, // UYL Africa/Kigali
    3840, // UYN Asia/Shanghai
    2026, // UYU America/La_Paz
    4490, // UZC Europe/Belgrade
    1300, // UZM America/Cambridge_Bay
    861, // UZU America/Argentina/Cordoba
    4651, // VAA Europe/Helsinki
    4906, // VAF Europe/Paris
    2759, // VAG America/Sao_Paulo
    2026, // VAH America/La_Paz
    5748, // VAI Pacific/Port_Moresby
    2367, // VAK America/Nome
    1149, // VAL America/Bahia
    5296, // VAM Indian/Maldives
    4686, // VAN Europe/Istanbul
    5551, // VAO Pacific/Guadalcanal
    2720, // VAP America/Santiago
    5051, // VAR Europe/Sofia
    4686, // VAS Europe/Istanbul
    std::numeric_limits<uint16_t>::max(), // VAT
    5832, // VAV Pacific/Tongatapu
    4894, // VAW Europe/Oslo
    4062, // VBC Asia/Yangon
    4962, // VBS Europe/Rome
    1405, // VBT America/Chicago
    5487, // VBV Pacific/Fiji
    5064, // VBY Europe/Stockholm
    3410, // VCA Asia/Ho_Chi_Minh
    2054, // VCB America/Los_Angeles
    244, // VCC Africa/Douala
    4339, // VCD Australia/Darwin
    4962, // VCE Europe/Rome
    971, // VCF America/Argentina/Salta
    2297, // VCH America/Montevideo
    3410, // VCL Asia/Ho_Chi_Minh
    2759, // VCP America/Sao_Paulo
    1358, // VCR America/Caracas
    3410, // VCS Asia/Ho_Chi_Minh
    1405, // VCT America/Chicago
    2054, // VCV America/Los_Angeles
    std::numeric_limits<uint16_t>::max(), // VDA
    4894, // VDB Europe/Oslo
    1149, // VDC America/Bahia
    4139, // VDE Atlantic/Canary
    2350, // VDF America/New_York
    3410, // VDH Asia/Ho_Chi_Minh
    2350, // VDI America/New_York
    833, // VDM America/Argentina/Catamarca
    1358, // VDP America/Caracas
    861, // VDR America/Argentina/Cordoba
    4894, // VDS Europe/Oslo
    3547, // VDY Asia/Kolkata
    749, // VDZ America/Anchorage
    749, // VEE America/Anchorage
    1547, // VEL America/Denver
    2226, // VER America/Mexico_City
    2350, // VES America/New_York
    4207, // VEY Atlantic/Reykjavik
    306, // VFA Africa/Harare
    3547, // VGA Asia/Kolkata
    2350, // VGC America/New_York
    4880, // VGD Europe/Moscow
    std::numeric_limits<uint16_t>::max(), // VGN
    4823, // VGO Europe/Madrid
    2054, // VGT America/Los_Angeles
    1271, // VGZ America/Bogota
    440, // VHC Africa/Luanda
    5064, // VHM Europe/Stockholm
    1405, // VHN America/Chicago
    4049, // VHV Asia/Yakutsk
    4906, // VHY Europe/Paris
    5802, // VHZ Pacific/Tahiti
    2759, // VIA America/Sao_Paulo
    2157, // VIB America/Mazatlan
    5051, // VID Europe/Sofia
    5127, // VIE Europe/Vienna
    1358, // VIG America/Caracas
    1405, // VIH America/Chicago
    3410, // VII Asia/Ho_Chi_Minh
    2987, // VIJ America/Tortola
    258, // VIL Africa/El_Aaiun
    4735, // VIN Europe/Kiev
    320, // VIR Africa/Johannesburg
    2054, // VIS America/Los_Angeles
    4823, // VIT Europe/Madrid
    5748, // VIV Pacific/Port_Moresby
    2759, // VIX America/Sao_Paulo
    2350, // VJI America/New_York
    3410, // VKG Asia/Ho_Chi_Minh
    4880, // VKO Europe/Moscow
    4880, // VKT Europe/Moscow
    2350, // VKX America/New_York
    4823, // VLC Europe/Madrid
    2350, // VLD America/New_York
    2494, // VLE America/Phoenix
    802, // VLG America/Argentina/Buenos_Aires
    5455, // VLI Pacific/Efate
    4823, // VLL Europe/Madrid
    2026, // VLM America/La_Paz
    1358, // VLN America/Caracas
    1474, // VLP America/Cuiaba
    2720, // VLR America/Santiago
    5455, // VLS Pacific/Efate
    4880, // VLU Europe/Moscow
    1358, // VLV America/Caracas
    4791, // VLY Europe/London
    1022, // VME America/Argentina/San_Luis
    1115, // VMI America/Asuncion
    861, // VMR America/Argentina/Cordoba
    5748, // VMU Pacific/Port_Moresby
    2350, // VNC America/New_York
    std::numeric_limits<uint16_t>::max(), // VND
    4906, // VNE Europe/Paris
    5141, // VNO Europe/Vilnius
    3547, // VNS Asia/Kolkata
    4950, // VNT Europe/Riga
    500, // VNX Africa/Maputo
    2054, // VNY America/Los_Angeles
    4936, // VOD Europe/Prague
    5156, // VOG Europe/Volgograd
    5233, // VOH Indian/Antananarivo
    560, // VOI Africa/Monrovia
    4476, // VOL Europe/Athens
    2759, // VOT America/Sao_Paulo
    4880, // VOZ Europe/Moscow
    2720, // VPA America/Santiago
    2350, // VPC America/New_York
    440, // VPE Africa/Luanda
    4207, // VPN Atlantic/Reykjavik
    1405, // VPS America/Chicago
    500, // VPY Africa/Maputo
    1405, // VPZ America/Chicago
    2350, // VQQ America/New_York
    2575, // VQS America/Puerto_Rico
    1824, // VRA America/Havana
    2350, // VRB America/New_York
    3634, // VRC Asia/Manila
    320, // VRE Africa/Johannesburg
    4880, // VRI Europe/Moscow
    4760, // VRL Europe/Lisbon
    4962, // VRN Europe/Rome
    1824, // VRO America/Havana
    320, // VRU Africa/Johannesburg
    4894, // VRY Europe/Oslo
    2226, // VSA America/Mexico_City
    4760, // VSE Europe/Lisbon
    2350, // VSF America/New_York
    4735, // VSG Europe/Kiev
    2054, // VSK America/Los_Angeles
    4867, // VTB Europe/Minsk
    4017, // VTE Asia/Vientiane
    3410, // VTG Asia/Ho_Chi_Minh
    1405, // VTN America/Chicago
    4962, // VTR Europe/Rome
    1824, // VTU America/Havana
    3547, // VTZ Asia/Kolkata
    4339, // VUE Australia/Darwin
    2350, // VUJ America/New_York
    2054, // VUO America/Los_Angeles
    1271, // VUP America/Bogota
    4880, // VUS Europe/Moscow
    1271, // VVC America/Bogota
    2026, // VVI America/La_Paz
    4032, // VVO Asia/Vladivostok
    47, // VVZ Africa/Algiers
    500, // VXC Africa/Maputo
    4155, // VXE Atlantic/Cape_Verde
    5064, // VXO Europe/Stockholm
    4049, // VYI Asia/Yakutsk
    1405, // VYS America/Chicago
    2367, // WAA America/Nome
    3788, // WAE Asia/Riyadh
    5372, // WAG Pacific/Auckland
    1405, // WAH America/Chicago
    5233, // WAI Indian/Antananarivo
    5233, // WAK Indian/Antananarivo
    5233, // WAM Indian/Antananarivo
    2720, // WAP America/Santiago
    5233, // WAQ Indian/Antananarivo
    4621, // WAT Europe/Dublin
    5173, // WAW Europe/Warsaw
    692, // WAX Africa/Tripoli
    2350, // WAY America/New_York
    4281, // WAZ Australia/Brisbane
    2367, // WBB America/Nome
    5748, // WBM Pacific/Port_Moresby
    std::numeric_limits<uint16_t>::max(), // WBO
    749, // WBQ America/Anchorage
    1562, // WBR America/Detroit
    1547, // WBU America/Denver
    2350, // WBW America/New_York
    2720, // WCA America/Santiago
    2720, // WCH America/Santiago
    749, // WCR America/Anchorage
    1405, // WDG America/Chicago
    720, // WDH Africa/Windhoek
    2350, // WDR America/New_York
    3840, // WDS Asia/Shanghai
    3840, // WEF Asia/Shanghai
    3840, // WEH Asia/Shanghai
    4281, // WEI Australia/Brisbane
    320, // WEL Africa/Johannesburg
    2777, // WFB America/Sitka
    5233, // WFI Indian/Antananarivo
    2263, // WFK America/Moncton
    3547, // WGC Asia/Kolkata
    4425, // WGE Australia/Sydney
    3840, // WGN Asia/Shanghai
    2350, // WGO America/New_York
    3620, // WGP Asia/Makassar
    4389, // WGT Australia/Melbourne
    2777, // WHD America/Sitka
    367, // WHF Africa/Kigali
    5372, // WHK Pacific/Auckland
    2054, // WHP America/Los_Angeles
    4791, // WHS Europe/London
    1405, // WHT America/Chicago
    1405, // WIB America/Chicago
    4791, // WIC Europe/London
    5372, // WIK Pacific/Auckland
    576, // WIL Africa/Nairobi
    4281, // WIN Australia/Brisbane
    4425, // WIO Australia/Sydney
    5372, // WIR Pacific/Auckland
    std::numeric_limits<uint16_t>::max(), // WJA
    2054, // WJF America/Los_Angeles
    576, // WJR Africa/Nairobi
    3829, // WJU Asia/Seoul
    5372, // WKA Pacific/Auckland
    4389, // WKB Australia/Melbourne
    306, // WKI Africa/Harare
    3952, // WKJ Asia/Tokyo
    749, // WKK America/Anchorage
    5389, // WKN Pacific/Bougainville
    2335, // WKR America/Nassau
    1405, // WLD America/Chicago
    4281, // WLE Australia/Brisbane
    5372, // WLG Pacific/Auckland
    5455, // WLH Pacific/Efate
    749, // WLK America/Anchorage
    5850, // WLS Pacific/Wallis
    2054, // WLW America/Los_Angeles
    5233, // WMA Indian/Antananarivo
    4389, // WMB Australia/Melbourne
    2054, // WMC America/Los_Angeles
    std::numeric_limits<uint16_t>::max(), // WMD
    4409, // WME Australia/Perth
    1405, // WMH America/Chicago
    5173, // WMI Europe/Warsaw
    5372, // WML Pacific/Auckland
    5233, // WMN Indian/Antananarivo
    2367, // WMO America/Nome
    5233, // WMP Indian/Antananarivo
    5233, // WMR Indian/Antananarivo
    3450, // WMX Asia/Jayapura
    749, // WNA America/Anchorage
    2777, // WNC America/Sitka
    3840, // WNH Asia/Shanghai
    3040, // WNN America/Winnipeg
    3634, // WNP Asia/Manila
    4281, // WNR Australia/Brisbane
    3505, // WNS Asia/Karachi
    3840, // WNZ Asia/Shanghai
    4425, // WOL Australia/Sydney
    std::numeric_limits<uint16_t>::max(), // WON
    3747, // WOS Asia/Pyongyang
    3888, // WOT Asia/Taipei
    749, // WOW America/Anchorage
    2720, // WPA America/Santiago
    5233, // WPB Indian/Antananarivo
    1595, // WPC America/Edmonton
    3003, // WPL America/Vancouver
    2595, // WPR America/Punta_Arenas
    1075, // WPU America/Argentina/Ushuaia
    5372, // WRE Pacific/Auckland
    2777, // WRG America/Sitka
    1547, // WRL America/Denver
    4409, // WRN Australia/Perth
    5173, // WRO Europe/Warsaw
    3450, // WRR Asia/Jayapura
    4791, // WRT Europe/London
    4791, // WRY Europe/London
    1793, // WSE America/Guyana
    2367, // WSF America/Nome
    2350, // WSG America/New_York
    2350, // WSH America/New_York
    749, // WSJ America/Anchorage
    3450, // WSN Asia/Jayapura
    2475, // WSO America/Paramaribo
    2901, // WSP America/Tegucigalpa
    2350, // WST America/New_York
    2054, // WSX America/Los_Angeles
    5372, // WSZ Pacific/Auckland
    5233, // WTA Indian/Antananarivo
    4281, // WTB Australia/Brisbane
    2335, // WTD America/Nassau
    5638, // WTE Pacific/Majuro
    2367, // WTK America/Nome
    2367, // WTL America/Nome
    std::numeric_limits<uint16_t>::max(), // WTO
    5748, // WTP Pacific/Port_Moresby
    2494, // WTR America/Phoenix
    5233, // WTS Indian/Antananarivo
    5372, // WTZ Pacific/Auckland
    3840, // WUA Asia/Shanghai
    3450, // WUB Asia/Jayapura
    4262, // WUD Australia/Adelaide
    5748, // WUG Pacific/Port_Moresby
    3840, // WUH Asia/Shanghai
    4409, // WUI Australia/Perth
    4409, // WUN Australia/Perth
    3840, // WUS Asia/Shanghai
    3840, // WUT Asia/Shanghai
    340, // WUU Africa/Juba
    3840, // WUX Asia/Shanghai
    3840, // WUZ Asia/Shanghai
    720, // WVB Africa/Windhoek
    2054, // WVI America/Los_Angeles
    5233, // WVK Indian/Antananarivo
    2350, // WVL America/New_York
    749, // WWA America/Anchorage
    2350, // WWD America/New_York
    5748, // WWK Pacific/Port_Moresby
    2777, // WWP America/Sitka
    1405, // WWR America/Chicago
    2367, // WWT America/Nome
    4425, // WWY Australia/Sydney
    3840, // WXN Asia/Shanghai
    4262, // WYA Australia/Adelaide
    274, // WYE Africa/Freetown
    4409, // WYN Australia/Perth
    1547, // WYS America/Denver
    4906, // XAB Europe/Paris
    2759, // XAP America/Sao_Paulo
    639, // XAR Africa/Ouagadougou
    1374, // XAU America/Cayenne
    3040, // XBE America/Winnipeg
    639, // XBG Africa/Ouagadougou
    3927, // XBJ Asia/Tehran
    4906, // XBK Europe/Paris
    639, // XBO Africa/Ouagadougou
    1405, // XBP America/Chicago
    4906, // XBQ Europe/Paris
    2971, // XBR America/Toronto
    4906, // XCD Europe/Paris
    5253, // XCH Indian/Christmas
    2652, // XCL America/Regina
    2971, // XCM America/Toronto
    4906, // XCR Europe/Paris
    4906, // XCY Europe/Paris
    4906, // XCZ Europe/Paris
    639, // XDE Africa/Ouagadougou
    639, // XDJ Africa/Ouagadougou
    4906, // XDR Europe/Paris
    4906, // XEP Europe/Paris
    1405, // XES America/Chicago
    3840, // XFN Asia/Shanghai
    639, // XGA Africa/Ouagadougou
    639, // XGG Africa/Ouagadougou
    440, // XGN Africa/Luanda
    2971, // XGR America/Toronto
    3840, // XIC Asia/Shanghai
    1203, // XIG America/Belem
    3840, // XIL Asia/Shanghai
    3840, // XIY Asia/Shanghai
    3505, // XJM Asia/Karachi
    639, // XKA Africa/Ouagadougou
    4017, // XKH Asia/Vientiane
    3040, // XKS America/Winnipeg
    639, // XKY Africa/Ouagadougou
    3040, // XLB America/Winnipeg
    4906, // XLG Europe/Paris
    2350, // XLL America/New_York
    621, // XLS Africa/Nouakchott
    639, // XLU Africa/Ouagadougou
    4389, // XMC Australia/Melbourne
    1405, // XMD America/Chicago
    std::numeric_limits<uint16_t>::max(), // XME
    4906, // XMF Europe/Paris
    3547, // XMG Asia/Kolkata
    5802, // XMH Pacific/Tahiti
    207, // XMI Africa/Dar_es_Salaam
    3840, // XMN Asia/Shanghai
    3021, // XMP America/Whitehorse
    1793, // XMS America/Guyana
    4906, // XMU Europe/Paris
    4906, // XMW Europe/Paris
    4281, // XMY Australia/Brisbane
    1405, // XNA America/Chicago
    3840, // XNN Asia/Shanghai
    2350, // XNO America/New_York
    3840, // XNT Asia/Shanghai
    639, // XNU Africa/Ouagadougou
    639, // XPA Africa/Ouagadougou
    3040, // XPK America/Winnipeg
    3040, // XPP America/Winnipeg
    1547, // XPR America/Denver
    1439, // XQP America/Costa_Rica
    3003, // XQU America/Vancouver
    3021, // XRR America/Whitehorse
    4823, // XRY Europe/Madrid
    2350, // XSA America/New_York
    3358, // XSB Asia/Dubai
    1721, // XSC America/Grand_Turk
    2054, // XSD America/Los_Angeles
    639, // XSE Africa/Ouagadougou
    3040, // XSI America/Winnipeg
    4906, // XSJ Europe/Paris
    4906, // XSN Europe/Paris
    3577, // XSP Asia/Kuala_Lumpur
    4906, // XSU Europe/Paris
    4281, // XTG Australia/Brisbane
    3040, // XTL America/Winnipeg
    4281, // XTO Australia/Brisbane
    4791, // XUD Europe/London
    3840, // XUZ Asia/Shanghai
    4906, // XVF Europe/Paris
    1405, // XVG America/Chicago
    4906, // XVN Europe/Paris
    4906, // XVO Europe/Paris
    4906, // XVS Europe/Paris
    1405, // XWA America/Chicago
    5551, // XYA Pacific/Guadalcanal
    4906, // XYP Europe/Paris
    639, // XZA Africa/Ouagadougou
    4906, // XZB Europe/Paris
    4906, // XZX Europe/Paris
    3003, // YAA America/Vancouver
    2616, // YAB America/Rankin_Inlet
    3040, // YAC America/Winnipeg
    3040, // YAG America/Winnipeg
    2971, // YAH America/Toronto
    2720, // YAI America/Santiago
    3057, // YAK America/Yakutat
    3003, // YAL America/Vancouver
    2971, // YAM America/Toronto
    454, // YAN Africa/Lubumbashi
    244, // YAO Africa/Douala
    std::numeric_limits<uint16_t>::max(), // YAP
    2971, // YAR America/Toronto
    2335, // YAS America/Nassau
    2971, // YAT America/Toronto
    2971, // YAU America/Toronto
    3003, // YAV America/Vancouver
    3040, // YAX America/Winnipeg
    2813, // YAY America/St_Johns
    3003, // YAZ America/Vancouver
    1595, // YBA America/Edmonton
    1300, // YBB America/Cambridge_Bay
    2971, // YBC America/Toronto
    2652, // YBE America/Regina
    3003, // YBF America/Vancouver
    1721, // YBI America/Grand_Turk
    2971, // YBJ America/Toronto
    2616, // YBK America/Rankin_Inlet
    3003, // YBL America/Vancouver
    3003, // YBM America/Vancouver
    3003, // YBO America/Vancouver
    3840, // YBP Asia/Shanghai
    3040, // YBR America/Winnipeg
    3040, // YBS America/Winnipeg
    3040, // YBT America/Winnipeg
    2652, // YBU America/Regina
    3040, // YBV America/Winnipeg
    3003, // YBW America/Vancouver
    1232, // YBX America/Blanc-Sablon
    1595, // YBY America/Edmonton
    3003, // YCA America/Vancouver
    1300, // YCB America/Cambridge_Bay
    2971, // YCC America/Toronto
    3003, // YCD America/Vancouver
    2971, // YCE America/Toronto
    3003, // YCF America/Vancouver
    3003, // YCG America/Vancouver
    2263, // YCH America/Moncton
    3073, // YCK America/Yellowknife
    2263, // YCL America/Moncton
    2971, // YCM America/Toronto
    2971, // YCN America/Toronto
    1300, // YCO America/Cambridge_Bay
    3003, // YCP America/Vancouver
    1526, // YCQ America/Dawson_Creek
    3040, // YCR America/Winnipeg
    2616, // YCS America/Rankin_Inlet
    1595, // YCT America/Edmonton
    3840, // YCU Asia/Shanghai
    3003, // YCW America/Vancouver
    1920, // YCY America/Iqaluit
    1595, // YCZ America/Edmonton
    3021, // YDA America/Whitehorse
    3021, // YDB America/Whitehorse
    1595, // YDC America/Edmonton
    1721, // YDE America/Grand_Turk
    2813, // YDF America/St_Johns
    1808, // YDG America/Halifax
    2652, // YDJ America/Regina
    3003, // YDL America/Vancouver
    3040, // YDN America/Winnipeg
    2971, // YDO America/Toronto
    1721, // YDP America/Grand_Turk
    1526, // YDQ America/Dawson_Creek
    3003, // YDT America/Vancouver
    3073, // YDU America/Yellowknife
    3040, // YDV America/Winnipeg
    3073, // YDW America/Yellowknife
    1595, // YEA America/Edmonton
    1562, // YEB America/Detroit
    2971, // YEE America/Toronto
    1595, // YEG America/Edmonton
    3927, // YEH Asia/Tehran
    2616, // YEK America/Rankin_Inlet
    2971, // YEL America/Toronto
    2971, // YEM America/Toronto
    2652, // YEN America/Regina
    2971, // YER America/Toronto
    3927, // YES Asia/Tehran
    1595, // YET America/Edmonton
    2616, // YEU America/Rankin_Inlet
    1905, // YEV America/Inuvik
    2971, // YEY America/Toronto
    2971, // YFA America/Toronto
    1920, // YFB America/Iqaluit
    2263, // YFC America/Moncton
    2971, // YFD America/Toronto
    2971, // YFE America/Toronto
    2971, // YFG America/Toronto
    2971, // YFH America/Toronto
    1595, // YFI America/Edmonton
    3073, // YFJ America/Yellowknife
    3073, // YFL America/Yellowknife
    3040, // YFO America/Winnipeg
    3073, // YFR America/Yellowknife
    3073, // YFS America/Yellowknife
    2813, // YFX America/St_Johns
    2971, // YGA America/Toronto
    3003, // YGB America/Vancouver
    1595, // YGC America/Edmonton
    2971, // YGD America/Toronto
    1595, // YGE America/Edmonton
    3003, // YGG America/Vancouver
    3073, // YGH America/Yellowknife
    3952, // YGJ Asia/Tokyo
    2971, // YGK America/Toronto
    2971, // YGL America/Toronto
    3040, // YGM America/Winnipeg
    3040, // YGO America/Winnipeg
    2971, // YGP America/Toronto
    2971, // YGQ America/Toronto
    1808, // YGR America/Halifax
    1920, // YGT America/Iqaluit
    2971, // YGV America/Toronto
    1920, // YGW America/Iqaluit
    3040, // YGX America/Winnipeg
    1920, // YGZ America/Iqaluit
    2813, // YHA America/St_Johns
    2652, // YHB America/Regina
    3040, // YHD America/Winnipeg
    3003, // YHE America/Vancouver
    2971, // YHF America/Toronto
    2813, // YHG America/St_Johns
    3003, // YHH America/Vancouver
    3073, // YHI America/Yellowknife
    1300, // YHK America/Cambridge_Bay
    2971, // YHM America/Toronto
    2971, // YHN America/Toronto
    1721, // YHO America/Grand_Turk
    3040, // YHP America/Winnipeg
    1232, // YHR America/Blanc-Sablon
    3003, // YHS America/Vancouver
    3021, // YHT America/Whitehorse
    2971, // YHU America/Toronto
    3073, // YHY America/Yellowknife
    1808, // YHZ America/Halifax
    1132, // YIB America/Atikokan
    3840, // YIC Asia/Shanghai
    3840, // YIE Asia/Shanghai
    1232, // YIF America/Blanc-Sablon
    3003, // YIG America/Vancouver
    3840, // YIH Asia/Shanghai
    1920, // YIK America/Iqaluit
    3991, // YIN Asia/Urumqi
    1920, // YIO America/Iqaluit
    1562, // YIP America/Detroit
    3040, // YIV America/Winnipeg
    3840, // YIW Asia/Shanghai
    1595, // YJA America/Edmonton
    3073, // YJF America/Yellowknife
    3003, // YJM America/Vancouver
    2971, // YJN America/Toronto
    1595, // YJP America/Edmonton
    3747, // YJS Asia/Pyongyang
    2813, // YJT America/St_Johns
    3003, // YKA America/Vancouver
    2652, // YKC America/Regina
    2971, // YKD America/Toronto
    3040, // YKE America/Winnipeg
    2971, // YKF America/Toronto
    2971, // YKG America/Toronto
    3840, // YKH Asia/Shanghai
    2652, // YKJ America/Regina
    3003, // YKK America/Vancouver
    2971, // YKL America/Toronto
    2054, // YKM America/Los_Angeles
    1405, // YKN America/Chicago
    4686, // YKO Europe/Istanbul
    1920, // YKQ America/Iqaluit
    4049, // YKS Asia/Yakutsk
    1920, // YKU America/Iqaluit
    2971, // YKX America/Toronto
    2652, // YKY America/Regina
    2971, // YKZ America/Toronto
    1595, // YLB America/Edmonton
    1920, // YLC America/Iqaluit
    2971, // YLD America/Toronto
    3073, // YLE America/Yellowknife
    2971, // YLH America/Toronto
    2652, // YLJ America/Regina
    2971, // YLK America/Toronto
    1595, // YLL America/Edmonton
    2971, // YLQ America/Toronto
    3040, // YLR America/Winnipeg
    2971, // YLS America/Toronto
    2455, // YLT America/Pangnirtung
    3233, // YLV Asia/Baku
    3003, // YLW America/Vancouver
    3003, // YLY America/Vancouver
    3021, // YMA America/Whitehorse
    3003, // YMB America/Vancouver
    3073, // YMD America/Yellowknife
    2971, // YME America/Toronto
    2971, // YMG America/Toronto
    2813, // YMH America/St_Johns
    2971, // YML America/Toronto
    1595, // YMM America/Edmonton
    1721, // YMN America/Grand_Turk
    2971, // YMO America/Toronto
    3003, // YMP America/Vancouver
    2041, // YMS America/Lima
    2971, // YMT America/Toronto
    3003, // YMU America/Vancouver
    1920, // YMV America/Iqaluit
    2971, // YMW America/Toronto
    2971, // YMX America/Toronto
    2971, // YMY America/Toronto
    2971, // YNA America/Toronto
    3788, // YNB Asia/Riyadh
    2971, // YNC America/Toronto
    2971, // YND America/Toronto
    3040, // YNE America/Winnipeg
    2350, // YNG America/New_York
    1526, // YNH America/Dawson_Creek
    3840, // YNJ Asia/Shanghai
    2652, // YNL America/Regina
    2971, // YNM America/Toronto
    3040, // YNO America/Winnipeg
    1721, // YNP America/Grand_Turk
    3040, // YNR America/Winnipeg
    2971, // YNS America/Toronto
    3840, // YNT Asia/Shanghai
    3073, // YNX America/Yellowknife
    3829, // YNY Asia/Seoul
    3840, // YNZ Asia/Shanghai
    3073, // YOA America/Yellowknife
    3021, // YOC America/Whitehorse
    1595, // YOE America/Edmonton
    2971, // YOG America/Toronto
    3040, // YOH America/Winnipeg
    2971, // YOI America/Toronto
    1595, // YOJ America/Edmonton
    397, // YOL Africa/Lagos
    3939, // YON Asia/Thimphu
    2971, // YOO America/Toronto
    1595, // YOP America/Edmonton
    2971, // YOS America/Toronto
    3464, // YOT Asia/Jerusalem
    2971, // YOW America/Toronto
    2652, // YPA America/Regina
    3003, // YPB America/Vancouver
    3073, // YPC America/Yellowknife
    2971, // YPD America/Toronto
    1595, // YPE America/Edmonton
    3003, // YPF America/Vancouver
    3040, // YPG America/Winnipeg
    2971, // YPH America/Toronto
    3003, // YPI America/Vancouver
    2971, // YPJ America/Toronto
    3003, // YPK America/Vancouver
    2971, // YPL America/Toronto
    3040, // YPM America/Winnipeg
    2971, // YPN America/Toronto
    2971, // YPO America/Toronto
    2971, // YPQ America/Toronto
    3003, // YPR America/Vancouver
    1808, // YPS America/Halifax
    3003, // YPT America/Vancouver
    3003, // YPW America/Vancouver
    2971, // YPX America/Toronto
    1595, // YPY America/Edmonton
    3003, // YPZ America/Vancouver
    2971, // YQA America/Toronto
    2971, // YQB America/Toronto
    1920, // YQC America/Iqaluit
    3040, // YQD America/Winnipeg
    1595, // YQF America/Edmonton
    std::numeric_limits<uint16_t>::max(), // YQG
    3021, // YQH America/Whitehorse
    1808, // YQI America/Halifax
    3040, // YQK America/Winnipeg
    1595, // YQL America/Edmonton
    2263, // YQM America/Moncton
    2971, // YQN America/Toronto
    2652, // YQR America/Regina
    2971, // YQS America/Toronto
    2935, // YQT America/Thunder_Bay
    1595, // YQU America/Edmonton
    2652, // YQV America/Regina
    2652, // YQW America/Regina
    2813, // YQX America/St_Johns
    1687, // YQY America/Glace_Bay
    3003, // YQZ America/Vancouver
    3073, // YRA America/Yellowknife
    2667, // YRB America/Resolute
    2971, // YRC America/Toronto
    1721, // YRF America/Grand_Turk
    1721, // YRG America/Grand_Turk
    2971, // YRI America/Toronto
    2971, // YRJ America/Toronto
    3040, // YRL America/Winnipeg
    1595, // YRM America/Edmonton
    3003, // YRN America/Vancouver
    2971, // YRO America/Toronto
    2971, // YRP America/Toronto
    2971, // YRQ America/Toronto
    3040, // YRS America/Winnipeg
    2616, // YRT America/Rankin_Inlet
    3003, // YRV America/Vancouver
    1808, // YSA America/Halifax
    2971, // YSB America/Toronto
    2971, // YSC America/Toronto
    3003, // YSE America/Vancouver
    2652, // YSF America/Regina
    3073, // YSG America/Yellowknife
    2971, // YSH America/Toronto
    2971, // YSI America/Toronto
    2263, // YSJ America/Moncton
    1920, // YSK America/Iqaluit
    2263, // YSL America/Moncton
    3073, // YSM America/Yellowknife
    3003, // YSN America/Vancouver
    1721, // YSO America/Grand_Turk
    2971, // YSP America/Toronto
    3840, // YSQ Asia/Shanghai
    1920, // YSR America/Iqaluit
    3040, // YST America/Winnipeg
    1808, // YSU America/Halifax
    1721, // YSV America/Grand_Turk
    3003, // YSX America/Vancouver
    3073, // YSY America/Yellowknife
    2971, // YTA America/Toronto
    3003, // YTB America/Vancouver
    3040, // YTD America/Winnipeg
    1920, // YTE America/Iqaluit
    2971, // YTF America/Toronto
    3003, // YTG America/Vancouver
    3040, // YTH America/Winnipeg
    2971, // YTJ America/Toronto
    3040, // YTL America/Winnipeg
    2971, // YTM America/Toronto
    1808, // YTN America/Halifax
    3003, // YTP America/Vancouver
    2971, // YTQ America/Toronto
    2971, // YTS America/Toronto
    2652, // YTT America/Regina
    3003, // YTU America/Vancouver
    3003, // YTX America/Vancouver
    3840, // YTY Asia/Shanghai
    2971, // YTZ America/Toronto
    3073, // YUB America/Yellowknife
    1920, // YUD America/Iqaluit
    4339, // YUE Australia/Darwin
    2971, // YUL America/Toronto
    2494, // YUM America/Phoenix
    3840, // YUS Asia/Shanghai
    2616, // YUT America/Rankin_Inlet
    1920, // YUX America/Iqaluit
    2971, // YUY America/Toronto
    std::numeric_limits<uint16_t>::max(), // YVA
    2971, // YVB America/Toronto
    2652, // YVC America/Regina
    3003, // YVE America/Vancouver
    1595, // YVG America/Edmonton
    2455, // YVM America/Pangnirtung
    2971, // YVO America/Toronto
    2971, // YVP America/Toronto
    3073, // YVQ America/Yellowknife
    3003, // YVR America/Vancouver
    2652, // YVT America/Regina
    2971, // YVV America/Toronto
    3040, // YVZ America/Winnipeg
    2971, // YWA America/Toronto
    2971, // YWB America/Toronto
    3040, // YWG America/Winnipeg
    3003, // YWH America/Vancouver
    3073, // YWJ America/Yellowknife
    1721, // YWK America/Grand_Turk
    3003, // YWL America/Vancouver
    2813, // YWM America/St_Johns
    1300, // YWO America/Cambridge_Bay
    2971, // YWP America/Toronto
    2971, // YWQ America/Toronto
    2971, // YWR America/Toronto
    3003, // YWS America/Vancouver
    1595, // YWV America/Edmonton
    3073, // YWY America/Yellowknife
    1595, // YXC America/Edmonton
    1595, // YXD America/Edmonton
    2652, // YXE America/Regina
    1595, // YXH America/Edmonton
    2971, // YXI America/Toronto
    1526, // YXJ America/Dawson_Creek
    2971, // YXK America/Toronto
    3040, // YXL America/Winnipeg
    2616, // YXN America/Rankin_Inlet
    2455, // YXP America/Pangnirtung
    3021, // YXQ America/Whitehorse
    2971, // YXR America/Toronto
    3003, // YXS America/Vancouver
    3003, // YXT America/Vancouver
    2971, // YXU America/Toronto
    3003, // YXX America/Vancouver
    3021, // YXY America/Whitehorse
    2971, // YXZ America/Toronto
    2971, // YYB America/Toronto
    1595, // YYC America/Edmonton
    3003, // YYD America/Vancouver
    1649, // YYE America/Fort_Nelson
    3003, // YYF America/Vancouver
    1808, // YYG America/Halifax
    1300, // YYH America/Cambridge_Bay
    3003, // YYJ America/Vancouver
    3040, // YYL America/Winnipeg
    1595, // YYM America/Edmonton
    2652, // YYN America/Regina
    2652, // YYO America/Regina
    3040, // YYQ America/Winnipeg
    2813, // YYT America/St_Johns
    2971, // YYU America/Toronto
    2971, // YYW America/Toronto
    2971, // YYY America/Toronto
    2971, // YYZ America/Toronto
    3003, // YZA America/Vancouver
    2971, // YZD America/Toronto
    2971, // YZE America/Toronto
    3073, // YZF America/Yellowknife
    2971, // YZG America/Toronto
    1595, // YZH America/Edmonton
    3003, // YZP America/Vancouver
    std::numeric_limits<uint16_t>::max(), // YZR
    1132, // YZS America/Atikokan
    3003, // YZT America/Vancouver
    1595, // YZU America/Edmonton
    2971, // YZV America/Toronto
    3021, // YZW America/Whitehorse
    3840, // YZY Asia/Shanghai
    3003, // YZZ America/Vancouver
    3003, // ZAA America/Vancouver
    3040, // ZAC America/Winnipeg
    5187, // ZAD Europe/Zagreb
    5187, // ZAG Europe/Zagreb
    3927, // ZAH Asia/Tehran
    3927, // ZAJ Asia/Tehran
    2720, // ZAL America/Santiago
    3634, // ZAM Asia/Manila
    2226, // ZAP America/Mexico_City
    397, // ZAR Africa/Lagos
    3840, // ZAT Asia/Shanghai
    4823, // ZAZ Europe/Madrid
    2263, // ZBF America/Moncton
    4919, // ZBK Europe/Podgorica
    4281, // ZBL Australia/Brisbane
    2971, // ZBM America/Toronto
    4281, // ZBO Australia/Brisbane
    3927, // ZBR Asia/Tehran
    4017, // ZBY Asia/Vientiane
    4506, // ZCA Europe/Berlin
    4906, // ZCC Europe/Paris
    2226, // ZCL America/Mexico_City
    2720, // ZCO America/Santiago
    2720, // ZCQ America/Santiago
    3358, // ZDY Asia/Dubai
    2350, // ZEF America/New_York
    3003, // ZEL America/Vancouver
    1920, // ZEM America/Iqaluit
    3547, // ZER Asia/Kolkata
    3021, // ZFA America/Whitehorse
    2652, // ZFD America/Regina
    3073, // ZFM America/Yellowknife
    3073, // ZFN America/Yellowknife
    1595, // ZFW America/Edmonton
    3003, // ZGF America/Vancouver
    3040, // ZGI America/Winnipeg
    472, // ZGM Africa/Lusaka
    3040, // ZGR America/Winnipeg
    1232, // ZGS America/Blanc-Sablon
    5455, // ZGU Pacific/Efate
    3840, // ZHA Asia/Shanghai
    3347, // ZHM Asia/Dhaka
    1595, // ZHP America/Edmonton
    4906, // ZHV Europe/Paris
    3840, // ZHY Asia/Shanghai
    4880, // ZIA Europe/Moscow
    2720, // ZIC America/Santiago
    194, // ZIG Africa/Dakar
    2226, // ZIH America/Mexico_City
    5219, // ZIN Europe/Zurich
    692, // ZIS Africa/Tripoli
    4049, // ZIX Asia/Yakutsk
    3040, // ZJG America/Winnipeg
    5219, // ZJI Europe/Zurich
    3040, // ZJN America/Winnipeg
    472, // ZKB Africa/Lusaka
    2971, // ZKE America/Toronto
    2971, // ZKG America/Toronto
    410, // ZKM Africa/Libreville
    3869, // ZKP Asia/Srednekolymsk
    258, // ZLG Africa/El_Aaiun
    2226, // ZLO America/Mexico_City
    2720, // ZLR America/Santiago
    1232, // ZLT America/Blanc-Sablon
    367, // ZLX Africa/Kigali
    4506, // ZMG Europe/Berlin
    3003, // ZMH America/Vancouver
    2226, // ZMM America/Mexico_City
    4962, // ZMO Europe/Rome
    3003, // ZMT America/Vancouver
    3003, // ZNA America/Vancouver
    749, // ZNC America/Anchorage
    607, // ZND Africa/Niamey
    4409, // ZNE Australia/Perth
    320, // ZNJ Africa/Johannesburg
    3003, // ZNL America/Vancouver
    207, // ZNZ Africa/Dar_es_Salaam
    3003, // ZOF America/Vancouver
    2720, // ZOS America/Santiago
    3040, // ZPB America/Winnipeg
    2720, // ZPC America/Santiago
    2350, // ZPH America/New_York
    2652, // ZPO America/Regina
    4506, // ZQF Europe/Berlin
    5372, // ZQN Pacific/Auckland
    3003, // ZQS America/Vancouver
    4506, // ZQV Europe/Berlin
    4506, // ZQW Europe/Berlin
    3840, // ZQZ Asia/Shanghai
    4490, // ZRE Europe/Belgrade
    5219, // ZRH Europe/Zurich
    std::numeric_limits<uint16_t>::max(), // ZRI
    3040, // ZRJ America/Winnipeg
    4962, // ZRO Europe/Rome
    2335, // ZSA America/Nassau
    5344, // ZSE Indian/Reunion
    3040, // ZSJ America/Winnipeg
    1595, // ZSP America/Edmonton
    0, // ZSS Africa/Abidjan
    2777, // ZST America/Sitka
    4506, // ZSU Europe/Berlin
    3003, // ZSW America/Vancouver
    5802, // ZTA Pacific/Tahiti
    1232, // ZTB America/Blanc-Sablon
    4476, // ZTH Europe/Athens
    3040, // ZTM America/Winnipeg
    4735, // ZTR Europe/Kiev
    3003, // ZTS America/Vancouver
    3233, // ZTU Asia/Baku
    3040, // ZUC America/Winnipeg
    2720, // ZUD America/Santiago
    3840, // ZUH Asia/Shanghai
    802, // ZUL America/Argentina/Buenos_Aires
    1721, // ZUM America/Grand_Turk
    1547, // ZUN America/Denver
    5233, // ZVA Indian/Antananarivo
    4409, // ZVG Australia/Perth
    3243, // ZVK Asia/Barnaul
    1595, // ZVL America/Edmonton
    5233, // ZWA Indian/Antananarivo
    2652, // ZWL America/Regina
    3093, // ZXB Arctic/Longyearbyen
    3233, // ZXT Asia/Baku
    3840, // ZYI Asia/Shanghai
    3347, // ZYL Asia/Dhaka
    3800, // ZZO Asia/Sakhalin
    118, // ZZU Africa/Blantyre
    2350, // ZZV America/New_York
};

// reverse name lookup string table for unique strings
static const char name1_string_table[] =
    "aachen" // MST
    "aalborg" // AAL
    "aarhus" // AAR
    "aasiaat" // JEG
    "ababa" // ADD
    "abadan" // ABD
    "abaiang" // ABF
    "abakan" // ABA
    "abane" // BJA
    "abau" // ABW
    "abbass" // BND
    "abbaye" // BGH
    "abbes" // BFW
    "abbotsford" // YXX
    "abbotsinch" // GLA
    "abbottabad" // AAW
    "abbs" // EAB
    "abbès" // BFW
    "abdelhafid" // TID
    "abdullahi" // GLK
    "abeche" // AEH
    "abeid" // ZNZ
    "abel" // SNU
    "abelardo" // TIJ
    "abemama" // AEA
    "abengourou" // OGO
    "abensur" // PCL
    "abernathy" // GZS
    "abha" // AHB
    "abilene" // ABI
    "abingdon" // ABG
    "aboisso" // ABO
    "abou" // AOD
    "abraq" // LAQ
    "abreojos" // AJS
    "abruzzo" // PSR
    "abubakar" // SKO
    "abumusa" // AEU
    "abéché" // AEH
    "acadiana" // ARA
    "acapulco" // ACA
    "accomack" // MFV
    "achinsk" // ACS
    "achmad" // SRG
    "achutupo" // ACU
    "acosta" // MOA
    "acres" // LMR
    "adak" // ADK
    "adam" // AOM
    "adana" // ADA
    "adde" // MGQ
    "addington" // EKX
    "addis" // ADD
    "addison" // ADS
    "adelaide" // ADL
    "adem" // PRN
    "adhair" // TRE
    "adirondack" // SLK
    "adisucipto" // JOG
    "adisumarmo" // SOC
    "adnan" // ADB
    "adolf" // PBM
    "adolino" // SMT
    "adrar" // AZR
    "advanced" // LBG
    "adıyaman" // ADF
    "aek" // AEG
    "aen" // AID
    "aerodromo" // LEN
    "aeron" // COR
    "aeronautico" // COR
    "aeronáutico" // COR
    "aeroparque" // AEP
    "aeropelican" // BEO
    "aeroplex" // GUS
    "aerospace" // MHV
    "afld" // CIS
    "afrika" // NCS
    "afton" // AFO
    "afutara" // AFT
    "afyon" // AFY
    "agadir" // AGA
    "agartala" // IXA
    "agatti" // AGX
    "agaun" // AUP
    "agde" // BZR
    "agen" // AGF
    "aggeneys" // AGZ
    "aghajari" // AKW
    "agnew" // AGW
    "agoncillo" // RJL
    "agramonte" // CMW
    "agrinion" // AGQ
    "agrio" // LGQ
    "agua" // LSQ
    "aguacate" // CAA
    "aguaclara" // ACL
    "aguas" // OCV
    "aguenar" // TMR
    "aguiar" // VIX
    "aguni" // AGJ
    "ahart" // OPL
    "ahilyabai" // IDR
    "ahmad" // KUA
    "ahmedabad" // AMD
    "ahsa" // HOF
    "ahuas" // AHS
    "ahwaz" // AWZ
    "aiambak" // AIH
    "aihui" // HEK
    "aiken" // AIK
    "ailigandí" // AIL
    "ailuk" // AIM
    "aime" // FDF
    "aimé" // FDF
    "ainsworth" // ANW
    "aiome" // AIE
    "aioun" // AEO
    "airborne" // ILN
    "aircenter" // JCI
    "aircraft" // CEA
    "airlake" // LVN
    "airlines" // OVD
    "airok" // AIC
    "aishalton" // AHL
    "aitape" // ATP
    "aitutaki" // AIT
    "aiyura" // AYU
    "ajaccio" // AJA
    "aji" // BPN
    "ajman" // QAJ
    "ajoncs" // EDM
    "akah" // LKH
    "akanu" // ENU
    "akhamok" // TMR
    "akhiok" // AKK
    "akiachak" // KKI
    "akiak" // AKI
    "akieni" // AKE
    "akita" // AXT
    "akjoujt" // AJJ
    "aklavik" // LAK
    "akola" // AKD
    "aksu" // AKU
    "aktau" // SCO
    "aktion" // PVK
    "aktobe" // AKX
    "aktyubinsk" // AKX
    "akulivik" // AKV
    "akure" // AKR
    "akureyri" // AEY
    "akwa" // QUO
    "alacant" // ALC
    "alakanuk" // AUK
    "alamein" // DBB
    "alamogordo" // ALM
    "alamos" // LAM
    "alanya" // GZP
    "alashankou" // BPL
    "albacete" // ABC
    "albano" // NOV
    "albemarle" // CHO
    "albenga" // ALL
    "alberni" // YPB
    "albertus" // FEP
    "albian" // JHL
    "albina" // ABN
    "albino" // TGZ
    "albion" // BVN
    "albrook" // PAC
    "albuq" // BUK
    "albuquerque" // ABQ
    "albury" // ABX
    "alc" // SRE
    "alcala" // HSK
    "alcantari" // SRE
    "alcaravan" // EYP
    "alcaraván" // EYP
    "alcides" // ACD
    "aldamiz" // PEM
    "aldan" // ADH
    "aldergrove" // BFS
    "alderney" // ACI
    "alegrete" // ALQ
    "aleknagik" // WKK
    "alene" // COE
    "aleppo" // ALP
    "alerta" // ALD
    "ales" // FNI
    "alexandra" // ALR
    "alexandroupolis" // AXD
    "alexeyevka" // TBS
    "alfaro" // MEC
    "algeciras" // AEI
    "alghero" // AHO
    "algiers" // ALG
    "algona" // AXG
    "alguaire" // ILD
    "alia" // AMM
    "alicante" // ALC
    "aliqatchialuk" // YPC
    "alitak" // ALZ
    "aliyev" // GYD
    "allah" // AAV
    "allahabad" // IXD
    "allakaket" // AET
    "allama" // LHE
    "alldays" // ADY
    "allegheny" // AGC
    "allentown" // ABE
    "allgau" // FMM
    "alma" // YTF
    "almandos" // IRJ
    "almaty" // ALA
    "almeria" // LEI
    "almería" // LEI
    "almiros" // VOL
    "almonacid" // IRJ
    "along" // IXV
    "alonso" // CTD
    "alor" // ARD
    "alpe" // AHZ
    "alpena" // APN
    "alpha" // ABH
    "alsworth" // PTA
    "altai" // LTI
    "altamira" // ATM
    "altay" // AAT
    "altaysk" // RGK
    "altenrhein" // ACH
    "altet" // ALC
    "altiport" // AHZ
    "altoona" // AOO
    "altos" // AAZ
    "altus" // AXS
    "alvarez" // ACA
    "alykel" // NSK
    "alzintan" // ZIS
    "alès" // FNI
    "amabatolahy" // AHY
    "amahai" // AHI
    "amakusa" // AXJ
    "amalie" // SPB
    "amami" // ASJ
    "amanat" // CGP
    "amani" // ZNZ
    "amarais" // CPQ
    "amarillo" // AMA
    "amazonas" // PTZ
    "ambalabe" // WAI
    "ambanja" // IVA
    "ambatomainty" // AMY
    "ambatondrazaka" // WAM
    "ambedkar" // NAG
    "ambilobe" // AMB
    "ambler" // ABL
    "ambodedjo" // MZI
    "amboim" // PBN
    "amborovy" // MJN
    "amboseli" // ASV
    "ambouli" // JIB
    "ambriz" // AZZ
    "ambrosio" // COR
    "amderma" // AMV
    "ameijeiras" // VTU
    "amenas" // IAM
    "america" // LBL
    "americas" // SDQ
    "amery" // AHH
    "ames" // AMW
    "amiens" // QAM
    "amin" // ENO
    "aminu" // KAN
    "aminuddin" // LUW
    "amook" // AOS
    "amory" // NEV
    "amos" // YEY
    "amotu" // TBU
    "ampampamena" // IVA
    "ampanihy" // AMP
    "ampapamena" // IVA
    "ampara" // ADP
    "amparai" // ADP
    "ampugnano" // SAY
    "amsei" // BAT
    "aménas" // IAM
    "américas" // SDQ
    "amílcar" // SID
    "anaa" // AAA
    "anacleto" // FRS
    "anaco" // AAO
    "anacortes" // OTS
    "anadolu" // AOE
    "anahim" // YAA
    "anaktuvuk" // AKP
    "analalava" // HVA
    "anapa" // AAQ
    "anapolis" // APS
    "anatom" // AUY
    "anau" // INU
    "anchialos" // VOL
    "anchorage" // ANC
    "ancona" // AOI
    "anda" // SDN
    "andahuaylas" // ANS
    "andakombe" // ADC
    "andamooka" // ADO
    "andapa" // ZWA
    "andavadoaka" // DVD
    "anders" // HEZ
    "andersen" // ODE
    "andi" // MXB
    "andina" // UYU
    "andizhan" // AZN
    "andorra" // ALV
    "andrade" // PLU
    "andrau" // AAP
    "andreini" // HAF
    "andrews" // GFK
    "andré" // GRU
    "andulo" // ANL
    "andøya" // ANX
    "anfa" // CAS
    "angads" // OUD
    "angara" // BQA
    "angelina" // LFK
    "angers" // ANE
    "anggi" // AGD
    "angiqsualujjuaq" // XGR
    "anglesey" // VLY
    "anglet" // BIQ
    "angling" // YAX
    "angoche" // ANO
    "angoon" // AGN
    "angoulême" // ANG
    "anguilla" // AXA
    "aniak" // ANI
    "anibal" // CIJ
    "animas" // AMK
    "aniwa" // AWD
    "ankang" // AKA
    "ankavandra" // JVA
    "ankazoabo" // WAK
    "ankeny" // IKV
    "ann" // ARB
    "anna" // MAA
    "annaba" // AAE
    "annai" // NAI
    "annapolis" // YDG
    "annecy" // NCY
    "annemasse" // QNJ
    "annette" // ANN
    "annex" // SKF
    "anniston" // ANB
    "annobon" // NBN
    "anqing" // AQG
    "anshan" // AOG
    "anshun" // AVA
    "anson" // AFP
    "antique" // EUQ
    "antlers" // ATE
    "antofagasta" // ANF
    "antrim" // ACB
    "antsalova" // WAQ
    "antsirabato" // ANM
    "antsirabe" // ATJ
    "antsoa" // WBO
    "antwerp" // ANR
    "anua" // BNY
    "anuradhapura" // ACJ
    "anvik" // ANV
    "anyang" // AYN
    "anying" // PZI
    "anzoategui" // BLA
    "anzoátegui" // BLA
    "anápolis" // APS
    "aníbal" // CIJ
    "aomori" // AOJ
    "aosta" // AOT
    "apache" // GLB
    "apai" // HPA
    "apalachicola" // AAF
    "apalapsili" // AAS
    "apataki" // APK
    "apatity" // KVK
    "apiaguaiki" // MHW
    "apolo" // APB
    "aponte" // NRR
    "apostle" // OHD
    "apple" // APV
    "appleton" // ATW
    "apucarana" // APU
    "apung" // LPU
    "aquila" // QAQ
    "aquino" // MNL
    "aracena" // IQQ
    "arad" // ARW
    "arafat" // GZA
    "aragon" // CLO
    "aragones" // SDE
    "aragonés" // SDE
    "araguaiana" // AUX
    "araguaina" // AUX
    "araguaína" // AUX
    "aragón" // CLO
    "arak" // AJK
    "aramac" // AXC
    "aramare" // PYH
    "arandis" // ADI
    "arandu" // QVP
    "aransas" // RKP
    "aranuka" // AAK
    "arapahoe" // AHF
    "arapiraca" // APQ
    "arapongas" // APX
    "arapoti" // AAG
    "arar" // RAE
    "araracuara" // ACR
    "araraquara" // AQA
    "ararat" // ARY
    "araucanía" // ZCO
    "arauz" // TDD
    "araxa" // AAX
    "araxos" // GPA
    "araxá" // AAX
    "araçatuba" // ARU
    "arba" // AMH
    "arbil" // EBL
    "arbor" // ARB
    "arcata" // ACV
    "ardabil" // ADU
    "ardeche" // OBS
    "arealva" // JTC
    "argana" // ESG
    "argaña" // ESG
    "argentinas" // USH
    "aribinda" // XAR
    "aripuanã" // AIR
    "arish" // AAC
    "aristarchos" // SMI
    "aristides" // BVC
    "aristotelis" // KSO
    "aristotelous" // KIT
    "arizona" // MSC
    "arka" // KGF
    "arkalyk" // AYK
    "arlanda" // ARN
    "arlit" // RLT
    "arly" // ARL
    "armação" // BZC
    "armidale" // ARM
    "armor" // SBK
    "army" // EWR
    "arnage" // LME
    "arnat" // QSF
    "arnes" // YNR
    "arnold" // LBE
    "arnsberg" // ZCA
    "arnulfo" // SAL
    "aro" // MOL
    "aroeboesman" // ENE
    "aroeppala" // KSR
    "aroostook" // WFK
    "aropa" // KIE
    "arorae" // AIS
    "aroui" // NDR
    "arrabury" // AAB
    "arrachart" // DIE
    "arraias" // AAI
    "arras" // QRV
    "arrayán" // OAN
    "arriaga" // SLP
    "arroyo" // EPS
    "arroyos" // OYO
    "arsizio" // MXP
    "arso" // ARJ
    "art" // BMY
    "artesia" // ATS
    "artigas" // ATI
    "artunduaga" // FLA
    "arua" // RUA
    "arusha" // ARK
    "arvaikheer" // AVK
    "arviat" // YEK
    "arvidsjaur" // AJR
    "arxan" // YIE
    "asaba" // ABB
    "asahikawa" // AKJ
    "asalouyeh" // YEH
    "asaloyeh" // YEH
    "asau" // AAU
    "ascencion" // ASC
    "ascención" // ASC
    "ash" // ISZ
    "ashaig" // SKL
    "ashburton" // ASG
    "asheboro" // HBI
    "asheville" // AVL
    "ashgabat" // ASB
    "ashley" // ASY
    "ashrafi" // KSH
    "ashtabula" // JFN
    "aslito" // SPN
    "asmara" // ASM
    "asosa" // ASO
    "aspen" // ASE
    "assab" // ASA
    "assad" // LTK
    "assisi" // PEG
    "assiut" // ATZ
    "ast" // CUZ
    "astana" // TSE
    "astete" // CUZ
    "astor" // MDQ
    "astoria" // AST
    "asturias" // OVD
    "astypalaia" // JTY
    "asuncion" // ASU
    "aswan" // ASW
    "asyaee" // QMJ
    "ata" // DMB
    "atacama" // CPO
    "ataq" // AXK
    "atar" // ATR
    "ataturk" // IST
    "atatürk" // IST
    "atbara" // ATB
    "atbasar" // ATX
    "athan" // DGX
    "ati" // ATV
    "atikokan" // YIB
    "atizapan" // JJC
    "atka" // AKB
    "atkamba" // ABP
    "atlantique" // NTE
    "atmautluak" // ATT
    "atoifi" // ATD
    "atqasuk" // ATK
    "atrouss" // AEO
    "atsinanana" // ILK
    "attapeu" // AOU
    "attawapiskat" // YAT
    "atuona" // AUQ
    "atyrau" // GUW
    "aubenas" // OBS
    "aubin" // DPE
    "auckland" // AKL
    "auguste" // NGD
    "augustin" // YIF
    "auki" // AKS
    "aulie" // DMB
    "aupaluk" // YPJ
    "aur" // AUL
    "aurangabad" // IXU
    "aurel" // BBU
    "aurillac" // AUR
    "aurukun" // AUU
    "auvergne" // CFE
    "aux" // GBI
    "auxerre" // AUF
    "avalon" // AVV
    "avaratra" // WMR
    "avare" // QVP
    "avaré" // QVP
    "avenger" // SWW
    "avent" // BTN
    "aveyron" // RDZ
    "aviacao" // QHP
    "aviador" // CPC
    "avignon" // AVN
    "avon" // AVO
    "awaba" // AWB
    "awan" // MSN
    "awang" // CBO
    "awasa" // AWA
    "axum" // AXU
    "ayapel" // AYA
    "ayawasi" // AYW
    "aydın" // CII
    "ayers" // AYQ
    "ayms" // MIS
    "ayolas" // AYO
    "ayub" // ENO
    "azahar" // CDT
    "azam" // KHI
    "azezo" // GDQ
    "azikiwe" // ABV
    "azlan" // IPH
    "azul" // ZUL
    "azur" // NCE
    "ağrı" // AJI
    "babanakira" // MBU
    "babasaheb" // NAG
    "babimost" // IEG
    "babo" // BXB
    "babullah" // TTE
    "babushara" // SUI
    "bacacheri" // BFH
    "bacau" // BCM
    "bacha" // PEW
    "bachigualato" // CUL
    "baco" // BCO
    "bacolod" // BCD
    "bacău" // BCM
    "badajoz" // BJZ
    "badanjilin" // RHT
    "badaruddin" // PLM
    "bade" // BXD
    "baden" // FKB
    "bader" // AIY
    "badu" // BDD
    "bafoussam" // BFX
    "bagan" // NYU
    "bagasbas" // DTE
    "bagdad" // BGT
    "bagdogra" // IXB
    "bage" // BGX
    "baghdad" // BGW
    "baghdogra" // IXB
    "bagre" // EBG
    "baguio" // BAG
    "baha" // ABT
    "bahadur" // VNS
    "bahawalpur" // BHV
    "bahia" // BHL
    "bahias" // HUX
    "bahir" // BJR
    "bahrain" // BAH
    "bahías" // HUX
    "baicheng" // DBC
    "baidoa" // BIB
    "bailey" // KPY
    "bailian" // LZH
    "baillif" // BBR
    "baimuru" // VMU
    "bain" // MAY
    "bains" // CMF
    "bairnsdale" // BSJ
    "baise" // AEB
    "baita" // HET
    "baiyun" // CAN
    "bajawa" // BJW
    "bajhang" // BJH
    "bajio" // BJX
    "bajpe" // IXE
    "bajura" // BJU
    "bajío" // BJX
    "bakel" // BXE
    "bakkafjörður" // BJD
    "bakouma" // BMF
    "baku" // GYD
    "bakula" // IXL
    "balakovo" // BWO
    "balalae" // BAS
    "baleine" // ZTB
    "baler" // BQA
    "balgo" // BQW
    "bali" // BLC
    "balice" // KRK
    "balimo" // OPU
    "balkanabat" // BKN
    "balkhash" // BXH
    "ballera" // BBL
    "ballina" // BNK
    "ballon" // AQP
    "ballón" // AQP
    "balmaceda" // BBA
    "balranald" // BZD
    "balsas" // BSS
    "balti" // BZY
    "baltimore" // BWI
    "baltrum" // BMR
    "balurghat" // RGH
    "balıkesir" // EDO
    "bam" // BXR
    "bama" // AEB
    "bamako" // BKO
    "bambari" // BBY
    "bamburi" // BMQ
    "bamda" // BPX
    "bamenda" // BPC
    "bamfield" // YBF
    "bamiyan" // BIN
    "bamyan" // BIN
    "ban" // HOE
    "bancasi" // BXU
    "band" // SBF
    "bandanaira" // NDA
    "bandaranaike" // CMB
    "bandeirinhas" // QDF
    "bandon" // BDY
    "bandundu" // FDU
    "baneasa" // BBU
    "banff" // YBA
    "banfora" // BNR
    "banga" // LBP
    "bangassou" // BGU
    "bangda" // BPX
    "bangoka" // FKI
    "bangor" // BGR
    "bangoy" // DVO
    "bani" // XSB
    "banja" // BNX
    "banjul" // BJL
    "bank" // CTB
    "bankstown" // BWU
    "banmaw" // BMO
    "banning" // BNG
    "bannu" // BNP
    "banos" // LSN
    "bantilan" // TLI
    "bantry" // BYT
    "banza" // SSY
    "baoshan" // BSD
    "baotou" // BAV
    "barajas" // MAD
    "baralande" // BKJ
    "baramita" // BMJ
    "barapani" // SHL
    "baratayevka" // ULV
    "barbara" // SBA
    "barber" // YVC
    "barberey" // QYR
    "barbuda" // BBQ
    "barcaldine" // BCI
    "barcelona" // BCN
    "barcelonnette" // BAE
    "barcelos" // BAZ
    "bardera" // BSY
    "bardufoss" // BDU
    "bareilly" // BEK
    "bariloche" // BRC
    "barimunya" // BYP
    "baringo" // LBN
    "bario" // BBN
    "barisal" // BZL
    "barker" // YDN
    "barkley" // PAH
    "barnaul" // BAX
    "barnes" // BAF
    "barnstable" // HYA
    "barnwell" // BNL
    "barranco" // NBB
    "barreiras" // BRA
    "barreirinhas" // BRB
    "barretos" // BAT
    "barril" // EPS
    "barriles" // TOQ
    "barrios" // PBR
    "barron" // DBN
    "barter" // BTI
    "barth" // BBH
    "barthelemy" // SBH
    "barthélemy" // SBH
    "bartlesville" // BVO
    "bartolome" // MDQ
    "bartow" // BOW
    "baruun" // UUN
    "barysiai" // HLJ
    "basango" // KRZ
    "basankusu" // BSU
    "basco" // BSO
    "basel" // EAP
    "basongo" // BAN
    "basra" // BSR
    "bassel" // LTK
    "bassillac" // PGX
    "bastak" // IAQ
    "bastia" // BIA
    "batagay" // BQJ
    "batang" // YUS
    "batangafo" // BTG
    "batavia" // BVW
    "bateen" // AZI
    "batesville" // BVX
    "bathinda" // BUP
    "bathpalathang" // BUT
    "bati" // TJB
    "batna" // BLJ
    "batom" // BXM
    "baton" // BTR
    "batouri" // OUR
    "batsfjord" // BJF
    "battambang" // BBM
    "batten" // RAC
    "battouta" // TNG
    "batu" // BTW
    "batumi" // BUS
    "batuna" // BPF
    "baubau" // BUW
    "baucau" // BCH
    "bauchi" // BCU
    "baudette" // BDE
    "bauer" // AOP
    "bauerfield" // VLI
    "baures" // BVL
    "baver" // AOP
    "bawean" // BXW
    "baxter" // WMH
    "bayanhot" // AXF
    "bayankhongor" // BYN
    "bayannur" // RLK
    "bayda" // BYD
    "bayonne" // BIQ
    "baytown" // HPY
    "bazar" // CXB
    "bazaruto" // BZB
    "beaches" // ECP
    "bearskin" // XBE
    "beatrix" // AUA
    "beatty" // BTY
    "beaufort" // BFT
    "beauregard" // DRI
    "beauvais" // BVA
    "beckley" // SGH
    "bedford" // EWB
    "bedin" // SMT
    "bedourie" // BEU
    "bedwell" // YBW
    "beech" // BEC
    "beef" // EIS
    "beetz" // YBJ
    "begishevo" // NBC
    "begumpet" // BPM
    "behar" // COH
    "beheshti" // IFN
    "beica" // BEI
    "beida" // OGX
    "beidaihe" // BPE
    "beigan" // MFK
    "beihai" // BHY
    "beihan" // BHN
    "beijiao" // LYA
    "beira" // BEW
    "beirut" // BEY
    "beja" // BYJ
    "bejaia" // BJA
    "bel" // BFW
    "belaga" // BLG
    "belagavi" // IXG
    "belaya" // BGN
    "belbek" // UKS
    "beldringe" // ODE
    "belgorod" // EGO
    "belgrade" // BEG
    "belkacem" // HME
    "belkebir" // AZR
    "bell" // JVW
    "bellary" // BEP
    "belleau" // XCY
    "bellefontaine" // EDJ
    "bellegarde" // LIG
    "belleville" // RPB
    "bellinger" // HCW
    "bellona" // BNY
    "belluno" // BLX
    "belmont" // BEO
    "belmullet" // BLY
    "beloyarsk" // EYK
    "beltrao" // FBE
    "beltrão" // FBE
    "beluga" // BVU
    "bembridge" // BBP
    "bemidji" // BJI
    "benalla" // BLN
    "benazir" // ISB
    "benbecula" // BEB
    "bender" // BSA
    "bendigo" // BXG
    "bengaluru" // BLR
    "bengbu" // BFU
    "benguela" // BUG
    "benguera" // BCW
    "benin" // BNI
    "benina" // BEN
    "benitez" // SCL
    "benjina" // BJK
    "bennett" // GFL
    "benniu" // CZX
    "bensbach" // BSP
    "benson" // BBB
    "bentley" // MVP
    "bento" // BGV
    "benton" // BZF
    "bentonville" // VBT
    "bentota" // BJT
    "benzaquen" // YMS
    "benzaquén" // YMS
    "benítez" // SCL
    "berau" // BEJ
    "berbera" // BBO
    "berberati" // BBT
    "berbérati" // BBT
    "berdyansk" // ERD
    "berens" // YBV
    "bergamo" // BGY
    "berge" // WPB
    "bergen" // BGO
    "bergerac" // EGC
    "bergman" // ALS
    "bergstrom" // AUS
    "bergé" // WPB
    "berhampur" // BMP
    "berim" // OTC
    "berisso" // MVD
    "berlevag" // BVG
    "berlevåg" // BVG
    "bermejo" // BJO
    "bermudez" // CUP
    "bermúdez" // CUP
    "bern" // BRN
    "bernardina" // DZO
    "bernardino" // SBD
    "bert" // BTM
    "berta" // URG
    "bertoua" // BTA
    "beru" // BEZ
    "besalampy" // BPY
    "besançon" // QBQ
    "beslan" // OGZ
    "bessemer" // EKY
    "best" // BHD
    "betancourt" // APO
    "betancur" // IGO
    "bethlehem" // ABE
    "betoambari" // BUW
    "betou" // BTB
    "betsworth" // ALO
    "bettles" // BTT
    "bevill" // JFX
    "bey" // TMR
    "bhadrapur" // BDP
    "bhamo" // BMO
    "bharatpur" // BHR
    "bhatinda" // BUP
    "bhavnagar" // BHU
    "bhn" // EAB
    "bhoj" // BHO
    "bhojpur" // BHP
    "bhopal" // BHO
    "bhubaneshwar" // BBI
    "bhuj" // BHJ
    "bhuntar" // KUU
    "bhutto" // ISB
    "bial" // BLR
    "bianco" // SMB
    "biangabip" // BPK
    "biard" // PIS
    "biarritz" // BIQ
    "biała" // BXP
    "białystok" // QYY
    "biche" // YLB
    "bie" // SVP
    "bien" // DIN
    "biggin" // BQH
    "bight" // TBI
    "bijie" // BFJ
    "biju" // BBI
    "bikini" // BII
    "bilaspur" // PAB
    "bilbao" // BIO
    "bildudalur" // BIU
    "billard" // TOP
    "billings" // BIL
    "billund" // BLL
    "biloela" // ZBL
    "biloxi" // GPT
    "bima" // BMU
    "binaka" // GNS
    "binghamton" // BGM
    "bingöl" // BGG
    "binhai" // TSN
    "bintulu" // BTU
    "birao" // IRO
    "biratnagar" // BIR
    "birch" // KBC
    "birdsville" // BVI
    "birgi" // TPS
    "birjand" // XBJ
    "birsa" // IXR
    "bisha" // BHH
    "bisho" // BIY
    "biskra" // BSK
    "bislig" // BPH
    "bismarck" // BIS
    "bitam" // BMM
    "bitat" // AAE
    "bittencourt" // BMS
    "bié" // SVP
    "blackall" // BKQ
    "blackbushe" // BBS
    "blacker" // MBL
    "blackpool" // BLK
    "blacksburg" // ROA
    "blackwater" // BLT
    "blackwell" // BWL
    "blagnac" // TLS
    "blaine" // BWS
    "blairsville" // DZJ
    "blaise" // DSS
    "blanca" // RUI
    "blancas" // COR
    "blanco" // REX
    "blanding" // BDG
    "blankensee" // LBC
    "blatchford" // YXD
    "blida" // QLD
    "blimbingsari" // BWX
    "block" // BID
    "blodgett" // HTL
    "bloemfontein" // BFN
    "blois" // XBQ
    "blonduos" // BLO
    "bloodvein" // YDV
    "bloomington" // BMI
    "bloominton" // BMI
    "blosser" // CNK
    "bluefields" // BEF
    "bluethenthal" // ILM
    "bluff" // RBL
    "bluffs" // CBF
    "blumenau" // BNU
    "blythe" // BLH
    "blytheville" // HKA
    "blönduós" // BLO
    "boardman" // HYA
    "bobby" // HBG
    "bobo" // BOY
    "boca" // BCT
    "bocas" // BOC
    "boccadifalco" // PMO
    "bodaybo" // ODO
    "bodden" // LYB
    "bodo" // BOO
    "bodø" // BOO
    "boeing" // BFI
    "boende" // BNB
    "bogande" // XBG
    "bogashevo" // TOF
    "bogorodskoye" // BQG
    "bogue" // BGH
    "boigny" // ABJ
    "boigu" // GIC
    "boire" // ASH
    "boise" // BOI
    "bojnord" // BJB
    "boke" // BKJ
    "boki" // MKI
    "bokondini" // BUI
    "bokoro" // BKR
    "boké" // BKJ
    "bolaang" // BJG
    "bolaños" // SYQ
    "bolivia" // SJV
    "bologna" // BLQ
    "bolshoye" // PEE
    "bolson" // EHL
    "bolt" // EVB
    "bolton" // TZR
    "bolzano" // BZO
    "bom" // LAZ
    "boma" // BOA
    "bomar" // SYI
    "bombay" // BOM
    "bonaire" // BON
    "bonanza" // BZA
    "bonaparte" // AJA
    "bonaventure" // YVB
    "bonet" // SBO
    "bong" // SUW
    "bongo" // MVB
    "bongor" // OGR
    "bonilla" // CLO
    "bonito" // BYO
    "bonnechere" // YXI
    "bonnyville" // YBY
    "bonomo" // SBJ
    "bonriki" // TRW
    "bontang" // BXT
    "bonthe" // BTE
    "booker" // HYC
    "boolgeeda" // OCM
    "boorama" // BXX
    "booué" // BGB
    "bora" // BOB
    "boraldai" // BXJ
    "boram" // WWK
    "bordeaux" // BOD
    "bordj" // BMW
    "bordoloi" // GAU
    "borg" // HBE
    "borgo" // BLQ
    "borja" // QOJ
    "borjhar" // GAU
    "borkum" // BMK
    "bornholm" // RNN
    "borongan" // BPR
    "borrego" // BXS
    "borroloola" // BOX
    "borsellino" // PMO
    "boryspil" // KBP
    "bosaso" // BSA
    "boscomantico" // QBS
    "bose" // CCU
    "bossangoa" // BSN
    "bossembele" // BEM
    "bossembélé" // BEM
    "bosset" // BOT
    "bost" // BST
    "boswell" // BSW
    "botopasi" // BTO
    "botopassi" // BTO
    "botucatu" // QCP
    "bou" // TID
    "bouaghi" // QMH
    "bouake" // BYK
    "bouaké" // BYK
    "bouar" // BOP
    "bouarfa" // UAR
    "bouca" // BCF
    "boudghene" // CBH
    "boudiaf" // CZL
    "bouet" // ABJ
    "boufarik" // QFD
    "boulaid" // BLJ
    "boulia" // BQL
    "boulsa" // XBO
    "boumediene" // ALG
    "boundary" // YDT
    "boundiali" // BXI
    "boundji" // BOE
    "bourg" // XBK
    "bourges" // BOU
    "bourget" // LBG
    "bourguiba" // MIR
    "bourke" // BRK
    "bournemouth" // BOH
    "bousso" // OUT
    "boussouf" // TID
    "boutheon" // EBU
    "bouthéon" // EBU
    "boutilimit" // OTL
    "bow" // BBW
    "bowen" // ZBO
    "bowerman" // HQM
    "bowers" // ELN
    "bowling" // BWG
    "boyington" // COE
    "bozeman" // BZN
    "bozoum" // BOZ
    "brackett" // POC
    "bradenton" // SRQ
    "bradley" // BDL
    "bradshaw" // SKB
    "braga" // BGZ
    "braganca" // BGC
    "brainard" // HFD
    "brainerd" // BRD
    "brak" // BCQ
    "bram" // BFN
    "branches" // AUF
    "brandenburg" // BER
    "brandon" // YBR
    "brandywine" // OQN
    "brangbiji" // SWQ
    "brantford" // YFD
    "brasilia" // BSB
    "bratsk" // BTK
    "braunschweig" // BWE
    "brava" // GRO
    "brawley" // BWC
    "brač" // BWK
    "braşov" // BRV
    "breas" // TTC
    "brega" // LMQ
    "breiðdalsvík" // BXV
    "bremen" // BRE
    "bremerton" // PWT
    "brenoux" // MEN
    "brescia" // VBS
    "bretagne" // BES
    "breuil" // XBQ
    "brevig" // KTS
    "brewarrina" // BWQ
    "bria" // BIV
    "briceño" // VLV
    "bridgeport" // XBP
    "brie" // ANG
    "brieuc" // SBK
    "brig" // QAK
    "brigham" // BMC
    "brighton" // ESH
    "brindisi" // BDS
    "bringeland" // FDE
    "briscoe" // LZU
    "brittany" // LRT
    "britton" // TTO
    "brive" // BVE
    "brno" // BRQ
    "broadford" // SKL
    "broadus" // BDX
    "brockville" // XBR
    "bromma" // BMA
    "bron" // LYN
    "bronnoy" // BNN
    "bronson" // YBM
    "brookhaven" // WSH
    "brooksville" // BKV
    "broome" // BME
    "brothers" // MGY
    "browne" // HYX
    "brownsville" // BRO
    "brownwood" // BWD
    "bruce" // DXE
    "bruges" // OST
    "brumado" // BMS
    "brunei" // BWN
    "bruntingthorpe" // LHB
    "brus" // BHG
    "brussel" // BRU
    "bryan" // STF
    "bryansk" // BZK
    "bryce" // BCE
    "brønnøy" // BNN
    "brønnøysund" // BNN
    "bsb" // SRI
    "bsm" // AUS
    "bubaque" // BQE
    "bubung" // LUW
    "buckanan" // UCN
    "buckeye" // BXK
    "buckland" // BKC
    "budapest" // BUD
    "buddha" // BWA
    "buelna" // MZT
    "bueno" // PBQ
    "bugulma" // UUA
    "buin" // UBI
    "bujumbura" // BJM
    "buka" // BUA
    "bukhara" // BHK
    "bukoba" // BKZ
    "buli" // WUB
    "bullfrog" // BFG
    "bullhead" // IFP
    "bulloch" // TBR
    "bulltofta" // MMA
    "bulolo" // BUL
    "buluh" // TJQ
    "bumba" // BMB
    "bunbury" // BUY
    "bundaberg" // BDB
    "bunia" // BUX
    "bunyu" // BYQ
    "buochs" // BXO
    "buol" // UDL
    "buon" // BMV
    "buraimi" // RMB
    "burao" // BUO
    "burbank" // BUR
    "burevestnik" // BVV
    "burgas" // BOJ
    "burgos" // RGS
    "buri" // BFV
    "buriram" // BFV
    "burke" // BKL
    "burketown" // BUC
    "burley" // BYI
    "burnell" // ATK
    "burnie" // BWT
    "burwash" // YDB
    "bushehr" // BUZ
    "business" // ELK
    "busselton" // BQB
    "busto" // MXP
    "buta" // BZU
    "butare" // BTQ
    "butaritari" // BBG
    "buthelezi" // ULD
    "butmir" // SJJ
    "butte" // GUC
    "butterworth" // BWH
    "buttonville" // YKZ
    "butuan" // BXU
    "buzios" // BZC
    "bydgoszcz" // BZG
    "bykovo" // BKA
    "byron" // BNK
    "bárbara" // SBB
    "båtsfjord" // BJF
    "bérim" // OTC
    "bétou" // BTB
    "béziers" // BZR
    "bíldudalur" // BIU
    "böblingen" // PHM
    "búzios" // BZC
    "bălți" // BZY
    "caballero" // PJC
    "caballococha" // LHC
    "cabe" // PCB
    "cabezas" // PUZ
    "cabinda" // CAB
    "cable" // CCB
    "cabos" // SJD
    "cabrera" // GER
    "caceres" // CCX
    "cachoeira" // SJL
    "cachoeiro" // CDI
    "cacique" // PYH
    "cacoal" // OAL
    "cad" // TPP
    "cadjehoun" // COO
    "caen" // CFR
    "caerdydd" // CWL
    "cafe" // PAL
    "cafunfo" // CFF
    "café" // PAL
    "cagayan" // CDY
    "cagliari" // CAG
    "caguan" // SVI
    "caiba" // YBP
    "cairns" // CNS
    "cairo" // CAI
    "cajazeiras" // CJZ
    "cakung" // BCH
    "calabozo" // CLZ
    "calabria" // REG
    "calafate" // FTE
    "calais" // CQF
    "calbayog" // CYP
    "calden" // KSF
    "caledonia" // LLX
    "calexico" // CXL
    "calgary" // YYC
    "calhoun" // TAL
    "calicut" // CCJ
    "callaway" // LGC
    "calloway" // CEY
    "calonne" // HZB
    "caloundra" // CUD
    "calverton" // CTO
    "calvi" // CLY
    "cam" // CXR
    "cama" // ZKM
    "camabatela" // CBT
    "camargue" // FNI
    "camaxilo" // CXM
    "cambria" // JST
    "camden" // CDU
    "camdenton" // OZS
    "camejo" // LSP
    "cameron" // YQW
    "camiguin" // CGM
    "camiri" // CAM
    "camooweal" // CML
    "camp" // HFF
    "campbeltown" // CAL
    "campina" // CPV
    "campoformido" // UDN
    "can" // VCA
    "cana" // PUJ
    "canadian" // YXC
    "canaima" // CAJ
    "canal" // ZOS
    "canales" // MAM
    "cananea" // CNA
    "canarana" // CQA
    "canaria" // LPA
    "canberra" // CBR
    "cancun" // CUN
    "cancún" // CUN
    "candala" // CXN
    "candelaria" // BRC
    "canefield" // DCF
    "canela" // QCN
    "canga" // TBP
    "cangamba" // CNZ
    "cangapara" // FLB
    "cangyuan" // CWJ
    "cannes" // CEQ
    "canouan" // CIW
    "cans" // BEL
    "cantrell" // CXW
    "cantu" // SYP
    "cantung" // TNS
    "cantú" // JJC
    "canyonlands" // CNY
    "caojiabao" // XNN
    "capac" // JUL
    "capodichino" // NAP
    "capurgana" // CPB
    "capurganá" // CPB
    "carajas" // CKS
    "carajás" // CKS
    "carano" // UIB
    "caransebes" // CSB
    "caransebeș" // CSB
    "carauari" // CAF
    "caravaggio" // BGY
    "caravelas" // CRQ
    "carazinho" // QRE
    "caraño" // UIB
    "carcassonne" // CCF
    "cardenas" // LZC
    "caribe" // PMV
    "cariboo" // ZMH
    "caribou" // CAR
    "carimagua" // CCO
    "carle" // JAU
    "carlisle" // CAX
    "carmelita" // CMM
    "carmelo" // CIO
    "carmen" // CME
    "carmichael" // LAK
    "carnarvon" // CVQ
    "carnevalli" // MRD
    "carnot" // CRF
    "carora" // VCR
    "carp" // YRP
    "carpiquet" // CFR
    "carr" // SNY
    "carranza" // LOV
    "carrasco" // MVD
    "carriel" // CCP
    "carrillo" // PLD
    "carsamba" // SZF
    "carson" // CSN
    "cartersville" // VPC
    "carthage" // TUN
    "cartier" // YOW
    "cartwright" // YRF
    "cartí" // CTE
    "caruaru" // CAU
    "carurú" // CUO
    "carvajal" // XMS
    "casablanca" // CAS
    "casale" // BDS
    "cascade" // CZK
    "cascais" // CAT
    "cascavel" // CAC
    "casco" // ATU
    "case" // SFG
    "caselle" // TRN
    "caseros" // MCS
    "casiano" // GPI
    "casimiro" // ARR
    "casino" // CSI
    "casparis" // ALE
    "casper" // CPR
    "cassidy" // CXI
    "cassilândia" // CSS
    "castellanos" // FRS
    "castellet" // CTT
    "castello" // VDM
    "castres" // DCM
    "catalao" // TLZ
    "catalina" // AVX
    "cataloi" // TCE
    "catalão" // TLZ
    "catamarca" // CTC
    "catamayo" // LOH
    "catania" // CTA
    "cataratas" // IGR
    "catarina" // FNC
    "catarman" // CRM
    "catey" // AZS
    "catharines" // YCM
    "caticlan" // MPH
    "catriel" // CCT
    "cattaraugus" // OLE
    "catullo" // VRN
    "catumbela" // CBT
    "cauayan" // CYZ
    "caucasia" // CAQ
    "caucaya" // LQM
    "caucayá" // LQM
    "caulker" // CUK
    "caumont" // AVN
    "cauquira" // CDD
    "cavern" // CNM
    "caverns" // PGS
    "caviahue" // CVH
    "caxias" // CXJ
    "cayana" // AAJ
    "caycuma" // ONQ
    "cayenne" // CAY
    "cayes" // CYA
    "cazombo" // CAV
    "caçador" // CFC
    "cañal" // ZOS
    "cca" // YWM
    "cebu" // CEB
    "cecil" // VQQ
    "cecilia" // WSE
    "cedar" // CDC
    "ceduna" // CED
    "celaque" // GAC
    "celaya" // CYW
    "celestino" // BSC
    "centennial" // APA
    "centrair" // NGO
    "century" // JCI
    "cephalonia" // EFL
    "ceres" // CRR
    "cerrillos" // ULC
    "cesaire" // FDF
    "cesar" // LUQ
    "cespedes" // BYM
    "cessna" // CEA
    "cessnock" // CES
    "cesáreo" // MVD
    "cevennes" // FNI
    "ceyzériat" // XBK
    "cfs" // TZC
    "chabelley" // CBA
    "chabeuil" // VAF
    "chacalluta" // ARI
    "chacarita" // JAP
    "chachapoyas" // CHH
    "chachoan" // ATF
    "chadron" // CDR
    "chafei" // BAT
    "chaganhu" // YSQ
    "chaghcharan" // CCN
    "chain" // HBG
    "chaiten" // WCH
    "chaitén" // WCH
    "chakeri" // KNU
    "chalkyitsik" // CIK
    "challis" // CHL
    "chalon" // XCD
    "chalons" // XCR
    "cham" // KZK
    "chamberlain" // MSP
    "chambery" // CMF
    "chambéry" // CMF
    "champforgeuil" // XCD
    "champniers" // ANG
    "chan" // YKN
    "chanama" // IXG
    "chanaral" // CNR
    "chandalar" // WCR
    "chandigarh" // IXC
    "chandra" // CCU
    "chang" // DBC
    "changbaishan" // NBS
    "changbei" // KHN
    "changchun" // CGQ
    "changde" // CGD
    "changhai" // CNI
    "changi" // SIN
    "changle" // FOC
    "changsha" // CSX
    "changshui" // KMG
    "changuinola" // CHX
    "changzhi" // CIH
    "changzhou" // CZX
    "changzhoudao" // WUZ
    "chania" // CHQ
    "chanmyathazi" // VBC
    "chanute" // CNU
    "chaoshan" // SWA
    "chaoshui" // YNT
    "chaoyang" // CHG
    "chaoyangchuan" // YNJ
    "chapais" // YMT
    "chapeco" // XAP
    "chapecó" // XAP
    "chapel" // CYC
    "chapleau" // YLD
    "charan" // LKO
    "charco" // ECR
    "charleroi" // CRL
    "charlie" // FTY
    "charlo" // YCL
    "charlottesville" // CHO
    "charmeil" // VHY
    "charnay" // QNX
    "charters" // CXT
    "chattanooga" // CHA
    "chaudhary" // LKO
    "chaurjhari" // HRJ
    "chavenay" // XZX
    "chañaral" // CNR
    "chd" // AZA
    "cheadle" // TIL
    "cheboksary" // CSY
    "cheddi" // GEO
    "chefornak" // CYF
    "chehalis" // CLS
    "chek" // HKG
    "chekif" // TID
    "cheli" // PKH
    "cheliff" // QAS
    "chelinda" // CEH
    "chelyabinsk" // CEK
    "chenega" // NCN
    "chengde" // CDE
    "chengdu" // CTU
    "chenggu" // HZG
    "chennai" // MAA
    "chennault" // CWF
    "cheongju" // CJJ
    "cheraw" // HCW
    "cherbourg" // CER
    "cheremshanka" // CER
    "cherepovets" // CEE
    "cherkasy" // CKC
    "chernihiv" // CEJ
    "chernivtsi" // CWC
    "cherry" // TVC
    "cherryland" // SUE
    "chersky" // CYX
    "chesapeake" // CPK
    "chess" // FKL
    "chester" // CTH
    "chetumal" // CTM
    "chetwynd" // YCQ
    "chevak" // VAK
    "chevery" // YHR
    "cheyenne" // CYS
    "chhatrapati" // BOM
    "chhnang" // KZC
    "chiayi" // CYI
    "chibougamau" // YMT
    "chichen" // CZA
    "chichester" // QUG
    "chickasaw" // CHK
    "chickasha" // CHK
    "chicken" // CKX
    "chicoutimi" // YRC
    "chien" // PCD
    "chifeng" // CIF
    "chilas" // CHB
    "childress" // CDS
    "chileka" // BLZ
    "chiles" // LSL
    "chilko" // CJH
    "chillagoe" // LLG
    "chilliwack" // YCW
    "chiloquin" // CHZ
    "chimbu" // CMU
    "chimoio" // VPY
    "chimore" // CCA
    "chinchilla" // CCL
    "chinggis" // ULN
    "chingozi" // TET
    "chinita" // MAR
    "chino" // CNO
    "chios" // JKH
    "chipata" // CIP
    "chipewyan" // YPY
    "chipinge" // CHJ
    "chiquimula" // CIQ
    "chiquitos" // SJS
    "chirino" // CZE
    "chisana" // CZN
    "chisasibi" // YKU
    "chitato" // PGI
    "chitose" // CTS
    "chitral" // CJL
    "chitré" // CTD
    "chizhou" // JUH
    "chișinău" // KIV
    "chkalovsky" // CKL
    "chlef" // QAS
    "chm" // MZA
    "choibalsan" // COQ
    "choiseul" // CHY
    "chokurdakh" // CKH
    "cholet" // CET
    "chongjin" // RGO
    "chongqing" // CKG
    "chopin" // WAW
    "chorrera" // LCR
    "chos" // HOS
    "choteau" // CII
    "christchurch" // CHC
    "christi" // CRP
    "christiansted" // SSB
    "chu" // VCL
    "chuathbaluk" // CHU
    "chub" // CCZ
    "chubu" // NGO
    "chulman" // NER
    "chumphon" // CJM
    "chutes" // YWQ
    "chuuk" // TKK
    "châlons" // XCR
    "château" // XCY
    "châteauroux" // CHR
    "chókwè" // TGS
    "chūbu" // NGO
    "ciampino" // CIA
    "cib" // AVX
    "cibao" // STI
    "cicia" // ICI
    "cildir" // CII
    "cimitarra" // CIM
    "cinquale" // QMM
    "cira" // BMI
    "ciriani" // TCQ
    "civic" // ALN
    "civilian" // MHV
    "clara" // PAO
    "claras" // OCV
    "claremont" // CNH
    "clarion" // AXQ
    "clarks" // CLP
    "clarksville" // CKV
    "claros" // MOC
    "cleve" // CVC
    "clever" // PHD
    "cliff" // CLR
    "clintonville" // CLI
    "cloncurry" // CNJ
    "clorinda" // CLX
    "clovis" // CVN
    "cluff" // XCL
    "cluj" // CLJ
    "cmte" // BGX
    "coalinga" // CLG
    "coandă" // OTP
    "coari" // CIZ
    "coatepeque" // CTF
    "coatzacoalcos" // MTT
    "coban" // CBV
    "cobar" // CAZ
    "cobb" // RYY
    "cobo" // LET
    "cobán" // CBV
    "cochamanidis" // SNG
    "cochin" // COK
    "cochise" // CWX
    "cochran" // TRM
    "cochstedt" // CSO
    "coconut" // CNC
    "cocos" // CCK
    "codela" // CSC
    "codrington" // BBQ
    "coen" // CUQ
    "coeur" // COE
    "coff" // CFS
    "coffey" // UKL
    "coffeyville" // CFV
    "coffman" // KCC
    "coffs" // CFS
    "coimbatore" // CJB
    "coimbra" // CBP
    "colby" // CBK
    "cold" // CDB
    "coldfoot" // CXF
    "coles" // MTO
    "colima" // CLQ
    "colina" // MDQ
    "coll" // COL
    "collarenebri" // CRB
    "college" // CGS
    "collier" // TNT
    "colmar" // CMR
    "cologne" // CGN
    "coloma" // LCL
    "colonizadores" // RVE
    "colonsay" // CSA
    "colorada" // PCO
    "colville" // YCK
    "colón" // BOC
    "comalapa" // SAL
    "comanche" // MKN
    "comandatuba" // UNA
    "combolcha" // DSE
    "comeau" // YBC
    "comilla" // CLA
    "comiso" // CIY
    "comitan" // CJT
    "comitán" // CJT
    "complex" // PNP
    "compostela" // SCQ
    "compton" // CPM
    "comte" // DLE
    "comté" // DLE
    "con" // VCS
    "conakry" // CKY
    "conceicao" // CDJ
    "conceição" // CDJ
    "concepcion" // CEP
    "concepción" // CEP
    "conch" // MDS
    "concordia" // CCI
    "concórdia" // CCI
    "condobolin" // CBX
    "confresa" // CFO
    "congonhas" // CGH
    "conlara" // RLO
    "connaught" // NOC
    "connel" // OBN
    "connellan" // AYQ
    "connemara" // NNR
    "conquista" // VDC
    "conrad" // ONA
    "conselheiro" // QDF
    "consequences" // TCS
    "constable" // CNP
    "constanta" // CND
    "constanza" // COZ
    "contadora" // OTD
    "continent" // ICT
    "converse" // DGW
    "coober" // CPD
    "cooch" // COH
    "cooktown" // CTN
    "coola" // QBC
    "coolah" // CLH
    "coolangatta" // OOL
    "coolawanyah" // COY
    "cooma" // OOM
    "coonabarabran" // COJ
    "coonamble" // CNB
    "coondewanna" // CJF
    "cooperstown" // COP
    "cootamundra" // CMD
    "copenhagen" // CPH
    "copernicus" // WRO
    "copper" // CZC
    "coral" // YZS
    "corazón" // CZJ
    "corbeta" // PDP
    "corbin" // LOZ
    "corcoran" // CRO
    "corda" // BDC
    "cordele" // CKF
    "corfu" // CFU
    "corisco" // OCS
    "cork" // ORK
    "cormeilles" // POX
    "corn" // RNI
    "cornelio" // CKO
    "corners" // FMN
    "corning" // ELM
    "cornouaille" // UIP
    "cornélio" // CKO
    "coromandel" // CMV
    "corona" // AJO
    "coronation" // YCT
    "coronus" // MNY
    "corowa" // CWW
    "corpus" // CRP
    "correia" // OGL
    "corrientes" // CNQ
    "corryong" // CYG
    "corse" // FSC
    "cortez" // CEZ
    "cortina" // CDF
    "cortissoz" // BAQ
    "cortland" // CTX
    "cortés" // PPE
    "corumba" // CMG
    "corumbá" // CMG
    "coruna" // LCG
    "coruña" // LCG
    "corvallis" // CVO
    "corvera" // RMU
    "corvo" // CVU
    "corzo" // TGZ
    "costilla" // GDL
    "cotabato" // CBO
    "coto" // OTR
    "cotonou" // COO
    "cotopaxi" // LTX
    "cotswold" // GBA
    "cottbus" // CBU
    "cotulla" // COT
    "coulter" // CFD
    "courcelles" // XMF
    "courchevel" // CVF
    "courtenay" // YCA
    "covenas" // CVE
    "coventry" // CVT
    "coveñas" // CVE
    "covilha" // COV
    "covilhã" // COV
    "cowell" // CCW
    "cowley" // YYM
    "cowra" // CWT
    "coyoles" // CYL
    "cozumel" // CZM
    "craiova" // CRA
    "cranbrook" // YXC
    "cranfield" // XUD
    "cravo" // RAV
    "crawford" // RSV
    "crepin" // SCP
    "crescencio" // MID
    "crested" // GUC
    "crews" // RTN
    "crisp" // CKF
    "cristiano" // FNC
    "cristina" // IGN
    "cristoforo" // GOA
    "crkva" // BCR
    "croix" // SSB
    "croker" // CKI
    "crooked" // CKD
    "crookston" // CKN
    "crosse" // LSE
    "crossing" // FIZ
    "crotone" // CRV
    "crow" // YOC
    "crows" // NRC
    "crusta" // IYA
    "cruzeiro" // CZS
    "crystal" // MIC
    "crépin" // SCP
    "csia" // BOM
    "cuamba" // FXO
    "cuanavale" // CTI
    "cuarto" // RCU
    "cuatia" // UZU
    "cuatiá" // UZU
    "cuatro" // ECV
    "cubo" // CUV
    "cuddapah" // CDP
    "cue" // CUY
    "cueva" // SPM
    "cuito" // CTI
    "culberson" // VHN
    "culiacan" // CUL
    "culpeper" // CJR
    "cumbica" // GRU
    "cumbre" // LCM
    "cuneo" // CUF
    "cunha" // SLZ
    "cunnamulla" // CMA
    "curbelo" // PDP
    "current" // YYN
    "curtiss" // CPS
    "cururupu" // CPU
    "curuzu" // UZU
    "curuzú" // UZU
    "cushing" // CUH
    "cutral" // CUT
    "cuxhaven" // FCN
    "cuyahoga" // CGF
    "cuyo" // CYU
    "cyangugu" // KME
    "cyr" // XZB
    "cyril" // STT
    "częstochowa" // CZW
    "cáceres" // CCX
    "cápac" // JUL
    "cárdenas" // LZC
    "césaire" // FDF
    "césar" // LUQ
    "céspedes" // BYM
    "cévennes" // FNI
    "córdoba" // ODB
    "córdova" // MDE
    "dabo" // SIQ
    "dabolim" // GOI
    "dabra" // DRH
    "dade" // TNT
    "daegu" // TAE
    "daein" // ADV
    "daet" // DTE
    "dafangshen" // CGQ
    "dagali" // DLD
    "dagana" // RDT
    "daggett" // DAG
    "dahaniya" // GZA
    "dahara" // TMD
    "dahl" // DCK
    "daito" // MMD
    "dajtki" // QYO
    "dala" // BLE
    "dalaman" // DLM
    "dalanzadgad" // DLZ
    "dalatando" // NDF
    "dalbandin" // DBA
    "dalby" // DBY
    "dalhart" // DHT
    "dali" // DLU
    "dalles" // DLS
    "dalma" // ZDY
    "daloa" // DJO
    "dalton" // DNN
    "daman" // NMB
    "damascus" // DAM
    "damazin" // RSS
    "danbury" // DXR
    "dandong" // DDG
    "dane" // MSN
    "dangriga" // DGA
    "danielson" // LZD
    "dannelly" // MGM
    "dansville" // DSV
    "danville" // DAN
    "danylo" // LWO
    "dao" // VCS
    "daocheng" // DCY
    "daparijo" // DEP
    "daporijo" // DEP
    "daqing" // DQA
    "dare" // MEO
    "dargaville" // DGR
    "darke" // VES
    "darnley" // NLF
    "daru" // DAU
    "darwaz" // DAZ
    "dasht" // SRY
    "dashuibo" // WEH
    "daskalogiannis" // CHQ
    "dass" // ATQ
    "dassault" // CHR
    "dastghaib" // SYZ
    "datadawai" // DTD
    "datong" // DAT
    "datu" // LDU
    "daugavpils" // DGP
    "daugherty" // LGB
    "dauphin" // SCP
    "dave" // KFE
    "davenport" // DVN
    "davidson" // EXX
    "daviess" // OWB
    "dawadmi" // DWD
    "dawasir" // WAE
    "dawei" // TVY
    "day" // SUX
    "dayak" // AJY
    "dayrestan" // GSM
    "daytona" // DAB
    "daza" // CUC
    "dazhou" // DAX
    "daşoguz" // TAZ
    "dbo" // DBD
    "deadhorse" // SCC
    "deadman" // LGI
    "deadmans" // LGI
    "dease" // YDL
    "deauville" // DOL
    "debba" // EDB
    "debrecen" // DEB
    "decorah" // DEH
    "dedougou" // DGU
    "deering" // DRG
    "defence" // NKM
    "defiance" // DFI
    "dehong" // LUM
    "dehradun" // DED
    "dei" // TRS
    "deir" // DEZ
    "dejazmach" // DIR
    "dekalb" // PDK
    "delano" // DLO
    "dele" // NDL
    "delhi" // DEL
    "deline" // YWJ
    "delingha" // HXD
    "dembidolo" // DEM
    "deming" // DMN
    "demirel" // ISE
    "denain" // XVS
    "deniliquin" // DNQ
    "denison" // DNS
    "denpasar" // DPS
    "denton" // DTO
    "denver" // DEN
    "deols" // CHR
    "deputado" // SSA
    "deputatsky" // DPT
    "deqen" // DIG
    "derik" // FGD
    "derry" // LDY
    "deseado" // PUD
    "desierto" // CPO
    "desourdy" // ZBM
    "desroches" // DES
    "dessau" // ZSU
    "destinationen" // OVD
    "deurne" // ANR
    "devanahalli" // BLR
    "devi" // IDR
    "devil" // RDV
    "devils" // DVL
    "devonport" // DPO
    "dewadaru" // KWB
    "dewitt" // OLD
    "dezful" // DEF
    "deïa" // AOD
    "dhabi" // AUH
    "dhahran" // DHA
    "dhanbad" // DBD
    "dhangadhi" // DHI
    "dharavandhoo" // DRV
    "dhien" // MEQ
    "diagne" // DSS
    "diagoras" // RHO
    "diamantina" // DTI
    "diamantino" // DMT
    "diapaga" // DIP
    "diavik" // DVK
    "diaz" // PVR
    "dibba" // BYB
    "dibrugarh" // DIB
    "diebougou" // XDE
    "diefenbaker" // YXE
    "dien" // DIN
    "dieppe" // DPE
    "digby" // YDG
    "dikson" // DKS
    "dillant" // EEN
    "dillingham" // DLG
    "dimapur" // DMU
    "dimbokro" // DIM
    "dimokritos" // AXD
    "dinard" // DNR
    "diomicio" // CCM
    "diomício" // CCM
    "diori" // NIM
    "dioulasso" // BOY
    "dipolog" // DPL
    "dirico" // DRC
    "dirranbandi" // DRN
    "disney" // DWS
    "div" // CUU
    "divinopolis" // DIQ
    "divinópolis" // DIQ
    "divo" // DIV
    "diwopu" // URC
    "dix" // MVF
    "diyarbakir" // DIY
    "diyarbakır" // DIY
    "diébougou" // XDE
    "djalle" // ODJ
    "djallé" // ODJ
    "djambala" // DJM
    "djamena" // NDJ
    "djanet" // DJG
    "djerba" // DJE
    "djibo" // XDJ
    "djibouti" // JIB
    "djili" // FIH
    "djoemoe" // DOE
    "djougou" // DJA
    "djúpivogur" // DJU
    "dnipropetrovsk" // DNK
    "dobo" // DOB
    "dobodura" // PNP
    "doctor" // CNQ
    "dodoma" // DOD
    "dog" // RDB
    "doha" // DOH
    "dolac" // IVG
    "dolbeau" // YDO
    "dole" // DLE
    "dolisie" // DIS
    "dolo" // NLO
    "dolpa" // DOP
    "dominicci" // SIG
    "domodedovo" // DME
    "doncaster" // DSA
    "donegal" // CFN
    "donetsk" // DOK
    "dong" // VDH
    "dongji" // FYJ
    "dongjiao" // JMU
    "dongola" // DOG
    "dongsha" // DSX
    "dongshan" // HLD
    "dongying" // DOY
    "donnelly" // YOE
    "donoi" // ULZ
    "donskoye" // TBW
    "doomadgee" // DMD
    "door" // SUE
    "doorgal" // QAK
    "dorchester" // CGE
    "dordogne" // EGC
    "dori" // DOR
    "doris" // JOJ
    "dornbirn" // HOH
    "dorset" // YTE
    "dortmund" // DTM
    "dorval" // YUL
    "dothan" // DHN
    "douala" // DLA
    "dourado" // MEU
    "dourados" // DOU
    "dov" // SDV
    "downer" // AIV
    "downing" // PIA
    "downsview" // YZD
    "doylestown" // DYL
    "dracena" // QDC
    "draham" // TBJ
    "draughon" // TPL
    "drayton" // YDC
    "dresden" // DRS
    "drewitz" // CBU
    "drietabbetje" // DRJ
    "driggs" // DIJ
    "drive" // BUR
    "drome" // POM
    "dryden" // YHD
    "dschang" // DSC
    "duarte" // AYP
    "dubbo" // DBO
    "dublin" // DUB
    "dubois" // DUJ
    "dubrovnik" // DBV
    "dubuque" // DBQ
    "duene" // HGL
    "dufort" // MAL
    "duke" // EGI
    "dulce" // LCF
    "dulles" // IAD
    "duluth" // DLH
    "dumaguete" // DGT
    "dumont" // SDU
    "dundee" // DND
    "dundo" // DUE
    "dunedin" // DUD
    "dunes" // UDD
    "dunhuang" // DNH
    "dunk" // DKI
    "dunkerque" // CQF
    "dunkirk" // DKK
    "dunsfold" // FAA
    "dunsmuir" // MHS
    "dupage" // DPA
    "duqm" // JNJ
    "durant" // DUA
    "dushanbe" // DYU
    "dutchess" // POU
    "duval" // RRG
    "duxford" // QFO
    "dwanga" // DWA
    "dwangwa" // DWA
    "dwight" // ICT
    "dysart" // DYA
    "dzaoudzi" // DZA
    "dédougou" // DGU
    "déline" // YWJ
    "délé" // NDL
    "désirade" // DSD
    "désourdy" // ZBM
    "dêqên" // DIG
    "díaz" // PVR
    "düne" // HGL
    "eaker" // DUA
    "ear" // YMY
    "earlton" // YXR
    "easterwood" // CLL
    "eastmain" // ZEM
    "eastport" // EPM
    "eaton" // OIC
    "ebolowa" // EBW
    "ebon" // EBO
    "eboué" // CAY
    "ech" // QAS
    "echuca" // ECH
    "eck" // PHW
    "ecole" // XZB
    "ecuador" // GYE
    "eday" // EOI
    "eddie" // HAF
    "eddis" // BUJ
    "eden" // AXM
    "edgardo" // VDM
    "edinburgh" // EDI
    "edmond" // GOK
    "edmundo" // XMS
    "edremit" // EDO
    "edson" // YET
    "edvard" // MBX
    "edwards" // GUF
    "edwin" // BGM
    "edén" // AXM
    "eelde" // GRQ
    "efogi" // EFG
    "egal" // HGA
    "egegik" // EGX
    "egidio" // PEG
    "egilsstadir" // EGS
    "egilsstaðir" // EGS
    "eia" // YEG
    "eil" // HCM
    "eiland" // SMZ
    "eilat" // ETH
    "einar" // FFM
    "eindhoven" // EIN
    "eirunepe" // ERN
    "eirunepé" // ERN
    "eisenach" // EIB
    "eisenberg" // ODW
    "eisenhower" // ICT
    "eisk" // EIK
    "ekati" // YOA
    "ekibastuz" // EKB
    "ekpo" // CBQ
    "ekwok" // KEK
    "elazig" // EZS
    "elazığ" // EZS
    "elche" // ALC
    "elcho" // ELC
    "eldorado" // ELO
    "eldoret" // EDL
    "eleftherios" // ATH
    "elena" // SNV
    "elenak" // EAL
    "elesmes" // XME
    "elfin" // ELV
    "elias" // PIO
    "elim" // ELI
    "elisabethville" // FBM
    "elista" // ESL
    "eliye" // EYS
    "elizabethtown" // EKX
    "elkin" // ZEF
    "elko" // EKO
    "ellington" // EFD
    "ellinikon" // ATH
    "elliot" // YEL
    "elliott" // YUL
    "elmas" // CAG
    "elmira" // ELM
    "elorza" // EOZ
    "eloy" // MEC
    "elrose" // ERQ
    "elx" // ALC
    "ely" // LYU
    "elytis" // MJT
    "elías" // PIO
    "embrujo" // PVA
    "emden" // EME
    "emerainville" // XLG
    "emerald" // EMD
    "emilia" // ZRO
    "emirau" // EMI
    "emmonak" // EMK
    "emporia" // EMP
    "empress" // YEA
    "enarotali" // EWI
    "enejit" // EJT
    "enewetak" // ENT
    "enfidha" // NBE
    "enid" // WDG
    "enniskillen" // ENK
    "enontekio" // ENF
    "enontekiö" // ENF
    "enrico" // LIN
    "enriquez" // LOH
    "enríquez" // LOH
    "enschede" // ENS
    "ensenada" // ESE
    "enshi" // ENH
    "entebbe" // EBB
    "enterprise" // ETS
    "entrammes" // LVA
    "enua" // AIU
    "enyu" // BII
    "eoligarry" // BRR
    "epernay" // XEP
    "ephrata" // EPH
    "eplatures" // ZHV
    "eppley" // OMA
    "epps" // AHN
    "eqalugaarsuit" // QFG
    "erandique" // EDQ
    "erbil" // EBL
    "erbogachen" // ERG
    "ercan" // ECN
    "erechim" // ERM
    "erenhot" // ERL
    "erfurt" // ERF
    "erigavo" // ERA
    "erik" // YXY
    "erkilet" // ASR
    "erliban" // BAV
    "ernest" // PRC
    "eros" // ERS
    "errol" // ERR
    "ershi" // YIE
    "ershilipu" // ENY
    "ertaizi" // JIL
    "erzincan" // ERC
    "erzurum" // ERZ
    "esbjerg" // EBJ
    "escobedo" // MTY
    "escondido" // PXM
    "eseka" // MVR
    "esenboğa" // ESB
    "esfahani" // KSH
    "eskilstuna" // EKT
    "eskisehir" // ESK
    "eskişehir" // ESK
    "eslam" // NWA
    "esmeralda" // ECI
    "esperadinha" // BVR
    "esperance" // EPR
    "esperanza" // LEZ
    "espinosa" // MBT
    "espora" // BHI
    "espérance" // SFG
    "esquel" // EQS
    "esquimalt" // YPF
    "essen" // ESS
    "essendon" // MEB
    "essey" // ENC
    "estero" // SDE
    "estevan" // YEN
    "estigarribia" // ESG
    "estrees" // XSJ
    "estrées" // XSJ
    "etjo" // MJO
    "eucla" // EUC
    "eugenio" // MAZ
    "eunice" // OLC
    "eurico" // VIX
    "euroairport" // EAP
    "evans" // EVH
    "evansville" // EVV
    "evelio" // EUQ
    "evella" // LEL
    "evenes" // EVE
    "evensk" // SWV
    "everett" // UCY
    "evers" // JAN
    "ewer" // EWE
    "excursion" // EXI
    "exeter" // EXT
    "expeditionary" // NXP
    "exuma" // GGT
    "eyl" // HCM
    "eylandt" // GTE
    "ezeiza" // EZE
    "faa" // PPT
    "faaite" // FAC
    "fabio" // MVP
    "facility" // BKH
    "factory" // BEC
    "fada" // FNG
    "fagali" // FGI
    "fagernes" // VDB
    "fagurhólsmýri" // FAG
    "fah" // CEI
    "fahd" // DMM
    "fahud" // FAU
    "faiks" // OEM
    "fair" // FIE
    "fairbanks" // FAI
    "fairchild" // CLM
    "fairview" // ZFW
    "faisalabad" // LYP
    "faison" // LRO
    "fajardo" // FAJ
    "fakarava" // FAV
    "fakfak" // FKQ
    "falcone" // PMO
    "faleolo" // APW
    "falla" // SVI
    "fallon" // FLX
    "falster" // MRW
    "famingo" // BON
    "fane" // FNE
    "fangatau" // FGU
    "fannin" // PFN
    "farafangana" // RVA
    "farah" // FAH
    "faranah" // FAA
    "fare" // HUH
    "farfan" // ULQ
    "faria" // GPB
    "farnborough" // FAB
    "farsund" // FAN
    "fasa" // FAZ
    "fascene" // NOS
    "fasher" // ELF
    "fashir" // ELF
    "fatmawati" // BKS
    "fauquier" // HWY
    "faustino" // UAQ
    "faya" // FYT
    "fayette" // FYE
    "fayks" // OEM
    "fayzabad" // FBD
    "fderik" // FGD
    "february" // LAD
    "feijó" // FEJ
    "feira" // FEC
    "feixiong" // BFJ
    "felicien" // YDO
    "fellini" // RMI
    "felts" // SFF
    "fenghuang" // TEN
    "fengnin" // TTT
    "fenosu" // FNU
    "fera" // FRE
    "ferdinand" // SIX
    "ferenc" // BUD
    "fergana" // FEG
    "fergus" // FFM
    "ferhat" // GJL
    "ferihegy" // BUD
    "ferit" // VAN
    "ferkessedougou" // FEK
    "ferkessédougou" // FEK
    "fernandes" // ICK
    "fernandina" // FHB
    "fernandini" // HUU
    "ferrand" // CFE
    "fertilia" // AHO
    "fes" // FEZ
    "fevereiro" // LAD
    "feyzabad" // FBD
    "fianarantsoa" // WFI
    "ficksburg" // FCB
    "fierro" // CUU
    "figari" // FSC
    "figueroa" // HUU
    "filadelfia" // FLM
    "filipe" // SFL
    "filippos" // KZI
    "filton" // FZO
    "fincha" // FNH
    "findel" // LUX
    "findlay" // FDY
    "fine" // AIZ
    "finsch" // LMR
    "finschhafen" // FIN
    "finthen" // QMZ
    "fiord" // YGZ
    "firebag" // YFI
    "first" // FFA
    "fisabilillah" // TNJ
    "fischer" // BFN
    "fisheries" // KCG
    "fishermans" // LPS
    "fitch" // FPK
    "fitchburg" // FIT
    "fite" // HAB
    "fiti" // FTI
    "fitini" // OFI
    "fitiuta" // FTI
    "fitzroy" // FIZ
    "fiumicino" // FCO
    "five" // FMC
    "flabob" // RIR
    "flagstaff" // FLG
    "flamingo" // BON
    "flecheras" // SFD
    "flensburg" // FLF
    "flesland" // BGO
    "fletcher" // CKM
    "fliegerhorst" // BRU
    "flin" // YFO
    "flinders" // FLS
    "flint" // FNT
    "flli" // LVI
    "flon" // YFO
    "florent" // XSU
    "floresta" // AFL
    "floriano" // FLB
    "florio" // TPS
    "floro" // FRO
    "florø" // FRO
    "floyd" // GFL
    "flushing" // FLU
    "foggia" // FOG
    "fohren" // ZQF
    "foley" // FPY
    "fonseca" // STM
    "fontages" // YFG
    "fontaine" // YHF
    "fontanarossa" // CTA
    "fontanges" // YFG
    "fonte" // FBA
    "fontenelle" // QPS
    "foothills" // MRN
    "fora" // JDF
    "force" // NKM
    "forest" // FXY
    "forestville" // YFE
    "forge" // GKT
    "forlanini" // LIN
    "forli" // FRL
    "forlì" // FRL
    "formosa" // FMA
    "forney" // TBN
    "foronda" // VIT
    "forquilhinha" // CCM
    "forster" // FOT
    "fortaleza" // FOR
    "fortescue" // KFE
    "fortuna" // FON
    "foshan" // FUO
    "foss" // FSD
    "fostoria" // FZI
    "fougamou" // FOU
    "foula" // FOA
    "foumban" // FOM
    "four" // FMN
    "fourchambault" // NVS
    "foya" // FOY
    "foz" // IGU
    "framnes" // NVK
    "franca" // FRC
    "frances" // YAG
    "francesco" // PEG
    "franche" // DLE
    "francis" // FOK
    "francistown" // FRW
    "frankivsk" // IFO
    "françois" // SFC
    "freddie" // LAK
    "fredericton" // YFC
    "freeland" // MBS
    "fregate" // FRK
    "freiburg" // EAP
    "freire" // ZCQ
    "frejus" // FRJ
    "fresh" // ASD
    "freyre" // REC
    "frieda" // FAQ
    "friedman" // SUN
    "friedrichshafen" // FDH
    "frio" // CFB
    "friuli" // TRS
    "frosinone" // QFR
    "frotey" // XVO
    "frutillar" // FRT
    "fryeburg" // FRY
    "frying" // YSI
    "fryklanda" // TYF
    "frégate" // FRK
    "fría" // LFR
    "fua" // TBU
    "fuaʻamotu" // TBU
    "fucheng" // BHY
    "fuentes" // WPR
    "fuerte" // LMM
    "fuerteventura" // FUE
    "fuhlsbüttel" // HAM
    "fujairah" // FJR
    "fukue" // FUJ
    "fukui" // FKJ
    "fukuoka" // FUK
    "fukushima" // FKS
    "fullerton" // FUL
    "fuma" // NKL
    "funafuti" // FUN
    "funchal" // FNC
    "funciona" // GGS
    "funter" // FNR
    "furnace" // DTH
    "fuster" // PJC
    "futaleufu" // FFU
    "futaleufú" // FFU
    "futuna" // FTA
    "fuvahmulah" // FVM
    "fuyang" // FUG
    "fuyuan" // FYJ
    "fuyun" // FYN
    "fuzhou" // FOC
    "fáskrúðsfjörður" // FAS
    "félicien" // YDO
    "föhren" // ZQF
    "gabbs" // GAB
    "gabes" // GAE
    "gabreski" // FOK
    "gabrielli" // MDZ
    "gabès" // GAE
    "gachsaran" // GCH
    "gadsden" // GAD
    "gafsa" // GAF
    "gage" // GA