/*
 * This file is part of LibKGAPI library
 *
 * Copyright (C) 2013  Daniel Vrátil <dvratil@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) version 3, or any
 * later version accepted by the membership of KDE e.V. (or its
 * successor approved by the membership of KDE e.V.), which shall
 * act as a proxy defined in Section 6 of version 3 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef KGAPI2_DRIVEFILECREATEJOB_H
#define KGAPI2_DRIVEFILECREATEJOB_H

#include "fileabstractuploadjob.h"
#include "kgapidrive_export.h"

namespace KGAPI2
{

namespace Drive
{

class KGAPIDRIVE_EXPORT FileCreateJob : public KGAPI2::Drive::FileAbstractUploadJob
{
    Q_OBJECT

  public:
    explicit FileCreateJob(const FilePtr &metadata, const AccountPtr &account,
                           QObject *parent = 0);
    explicit FileCreateJob(const FilesList &metadata, const AccountPtr &account,
                           QObject *parent = 0);
    explicit FileCreateJob(const QString &filePath,
                           const AccountPtr &account, QObject *parent = 0);
    explicit FileCreateJob(const QString &filePath,
                           const FilePtr &metaData,
                           const AccountPtr &account, QObject *parent = 0);
    explicit FileCreateJob(const QStringList &filePaths,
                           const AccountPtr &account, QObject *parent = 0);
    explicit FileCreateJob(const QMap < QString /* filepath */, FilePtr /* metadata */ > &files,
                           const AccountPtr &account, QObject *parent = 0);
    virtual ~FileCreateJob();

  protected:
    QNetworkReply *dispatch(QNetworkAccessManager *accessManager,
                                    const QNetworkRequest &request,
                                    const QByteArray &data) Q_DECL_OVERRIDE;

    QUrl createUrl(const QString &filePath,
                           const FilePtr &metaData) Q_DECL_OVERRIDE;

  private:
    class Private;
    Private *const d;
    friend class Private;

};

} // namespace Drive

} // namespace KGAPI2

#endif // KGAPI2_DRIVEFILECREATEJOB_H
