/* -*- c++ -*-
 *
 * friendpage.h
 *
 * Copyright (C) 2003 Petter Stokke <ummo@hellokitty.com>
 * Copyright (C) 2003,2004,2007 Sebastian Sauer <mail@dipe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef __kmldonkey_friendpage_h__
#define __kmldonkey_friendpage_h__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QObject>
#include <QSplitter>
#include <QTextBrowser>
#include <KVBox>
#include <q3dict.h>
#include <q3intdict.h>
#include <QList>
#include <Q3PtrList>

#include <searchinfo.h>

#include "clipboard.h"
#include "page.h"

#include <kdeversion.h>

class KActionCollection;
class KLineEdit;

class KMLDonkeyPreferences;
class InfoList;
class ClientFile;

class KTabWidget;

class FriendShares
{
public:
    QMap<QString,QList<int> > dirs;
};

class ChatWidget : public QWidget
{
    Q_OBJECT
public:
    ChatWidget(int client, QWidget* parent = 0);

public slots:
    void messageFromClient(int client, const QString& message);

protected slots:
    void messageEntered(const QString& message);

private:
    void setupChatWidget(int client);

    int clno;
    QTextBrowser* output;
    KLineEdit* input;
};

class FriendPage : public KVBox, public KMLDonkeyPage, public ClipboardHelper
{
    Q_OBJECT
public:
    FriendPage(QWidget* parent = 0);

    virtual void setupActions(KActionCollection*);
    virtual QStringList supportedGenericActions();
    virtual void handleGenericAction(const QString&);
    virtual void plugGenericActions(QObject*, const char*);
    virtual void deactivatePageActions();

    virtual void applyPreferences(KMLDonkeyPreferences* prefs = 0);
    virtual void saveState(KSharedConfigPtr);
    virtual void restoreState(KSharedConfigPtr);

    virtual void clear();

signals:
    void genericActionsChanged(KMLDonkeyPage*);

public slots:
    void friendUpdated(int client);
    void friendRemoved(int client);

protected slots:
    void closeAllFileLists();
    void openFileList(int client);
    void closeFileList(QWidget*);

    void openFriendFiles(Q3ListViewItem* item);

    void contextFriend(K3ListView*,Q3ListViewItem*,const QPoint&);
    void contextFile(K3ListView*,Q3ListViewItem*,const QPoint&);

    void actionAddFriend();
    void actionRemoveFriend();
    void actionRemoveAllFriends();
    void actionConnectFriend();
    void actionOpenChat();

    void fileDoubleClick(Q3ListViewItem*);
    void actionDownload();
    void actionForceDownload();
    void actionDownloadAs();

    void actionActivatePage();

    void receiveShare(int clno, const QString& dir, int result);

    void mightUpdateShareList();

    void pleaseUpdateActions();

    void messageReceived(int client, const QString& message);
    void closeChat(QWidget*);

private:
    void constructFileList(int clno);
    Q3PtrList<Q3ListViewItem> currentFileListSelection();
    void downloadSelected(bool force, bool ask);
    void copyFileToClipboard(ClipFormat format);

    QSplitter *friendVSplitter, *friendHSplitter;
    InfoList *friendView;
    KTabWidget* fileTab;
    KTabWidget* chatTab;

    Q3IntDict<ChatWidget> chats;
    Q3IntDict<InfoList> fileViews;

    Q3IntDict<ClientItem> friendList;
    Q3IntDict<FriendShares> shares;

    QMap<int,bool> pleaseUpdateShareList;

    Q3PtrList<KAction> friendActions, shareActions;
    KAction* m_removeAllAction;
    KAction* m_chatAction;
};

#endif
