//Auto-generated by kalyptus. DO NOT EDIT.
namespace KTextEditor {
    using Kimono;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  \brief Command extension interface for the Editor.
    ///  \ingroup kte_group_editor_extensions
    ///  \section cmdiface_intro Introduction
    ///  The CommandInterface extends the Editor to support command line commands.
    ///  An application or a Plugin can register new commands by using
    ///  registerCommand(). To unregister a command call unregisterCommand(). To
    ///  check, whether a command with a given name exists use queryCommand().
    ///  \section cmdiface_access Accessing the CommandInterface
    ///  The CommandInterface is supposed to be an extension interface for the
    ///  Editor, i.e. the Editor inherits the interface \e provided that the
    ///  used KTextEditor library implements the interface. Use qobject_cast to
    ///  access the interface:
    ///  <pre>
    ///  // editor is of type KTextEditor.Editor
    ///  KTextEditor.CommandInterface iface =
    ///      qobject_cast<KTextEditor.CommandInterface>( editor );
    ///  if( iface ) {
    ///      // the implementation supports the interface
    ///      // do stuff
    ///  }
    ///  </pre>
    ///  \see KTextEditor.Editor, KTextEditor.Command,
    ///       KTextEditor.CommandExtension
    ///  \author Christoph Cullmann \<cullmann@kde.org\>
    ///  </remarks>        <short>    \brief Command extension interface for the Editor.</short>
    [SmokeClass("KTextEditor::CommandInterface")]
    public class CommandInterface : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected CommandInterface(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(CommandInterface), this);
        }
        /// <remarks>
        ///  Register a the new command <pre>cmd</pre>. The command will be registered for
        ///  all documents, i.e. every command is global.
        ///  \param cmd command to register
        ///  \return \e true on success, otherwise \e false
        ///  \see unregisterCommand()
        ///      </remarks>        <short>    Register a the new command \p cmd.</short>
        [SmokeMethod("registerCommand(KTextEditor::Command*)")]
        public virtual bool RegisterCommand(KTextEditor.Command cmd) {
            return (bool) interceptor.Invoke("registerCommand#", "registerCommand(KTextEditor::Command*)", typeof(bool), typeof(KTextEditor.Command), cmd);
        }
        /// <remarks>
        ///  Unregister the command <pre>cmd</pre>. The command will be unregistered for
        ///  all documents.
        ///  \param cmd command to unregister
        ///  \return \e true on success, otherwise \e false
        ///  \see registerCommand()
        ///      </remarks>        <short>    Unregister the command \p cmd.</short>
        [SmokeMethod("unregisterCommand(KTextEditor::Command*)")]
        public virtual bool UnregisterCommand(KTextEditor.Command cmd) {
            return (bool) interceptor.Invoke("unregisterCommand#", "unregisterCommand(KTextEditor::Command*)", typeof(bool), typeof(KTextEditor.Command), cmd);
        }
        /// <remarks>
        ///  Query for the command <pre>cmd</pre>.
        ///  If the command <pre>cmd</pre> does not exist the return value is NULL.
        ///  \param cmd name of command to query for
        ///  \return the found command or NULL if no such command exists
        ///      </remarks>        <short>    Query for the command \p cmd.</short>
        [SmokeMethod("queryCommand(const QString&) const")]
        public virtual KTextEditor.Command QueryCommand(string cmd) {
            return (KTextEditor.Command) interceptor.Invoke("queryCommand$", "queryCommand(const QString&) const", typeof(KTextEditor.Command), typeof(string), cmd);
        }
        /// <remarks>
        ///  Get a list of all registered commands.
        ///  \return list of all commands
        ///  \see queryCommand(), commandList()
        ///      </remarks>        <short>    Get a list of all registered commands.</short>
        [SmokeMethod("commands() const")]
        public virtual List<KTextEditor.Command> Commands() {
            return (List<KTextEditor.Command>) interceptor.Invoke("commands", "commands() const", typeof(List<KTextEditor.Command>));
        }
        /// <remarks>
        ///  Get a list of available command line strings.
        ///  \return command line strings
        ///  \see commands()
        ///      </remarks>        <short>    Get a list of available command line strings.</short>
        [SmokeMethod("commandList() const")]
        public virtual List<string> CommandList() {
            return (List<string>) interceptor.Invoke("commandList", "commandList() const", typeof(List<string>));
        }
        public CommandInterface() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("CommandInterface", "CommandInterface()", typeof(void));
        }
        ~CommandInterface() {
            interceptor.Invoke("~CommandInterface", "~CommandInterface()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~CommandInterface", "~CommandInterface()", typeof(void));
        }
    }
}
