/*
    kopetelviprops.h

    Kopete Contactlist Properties GUI for Groups and MetaContacts

    Copyright (c) 2002-2003 by Stefan Gehn            <metz@gehn.net>

    Kopete    (c) 2002-2003 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef KOPETELVIPROPS_H
#define KOPETELVIPROPS_H

#include <kdialog.h>
#include <kabc/sound.h>

#include "kopetemetacontact.h"

#include "ui_kopetemetalvipropswidget.h"
#include "ui_kopetegvipropswidget.h"

class AddressBookLinkWidget;
class CustomNotificationProps;
class KopeteGroupViewItem;
class KopeteMetaContactLVI;
class KopeteAddressBookExport;
class KUrlRequester;

namespace KABC { class Addressee; }
namespace Kopete { class Contact; }

class KopeteGVIProps: public KDialog
{
	Q_OBJECT

	public:
		KopeteGVIProps(KopeteGroupViewItem *gvi, QWidget *parent);
		~KopeteGVIProps();

	private:
		CustomNotificationProps * mNotificationProps;
		QWidget *mainWidget;
		Ui::KopeteGVIPropsWidget *ui_mainWidget;
		KopeteGroupViewItem *item;
		bool m_dirty;

	private slots:
		void slotOkClicked();
		void slotUseCustomIconsToggled(bool on);
		void slotIconChanged();
};


class KopeteMetaLVIProps: public KDialog
{
	Q_OBJECT

	public:
		KopeteMetaLVIProps(KopeteMetaContactLVI *gvi, QWidget *parent);
		~KopeteMetaLVIProps();

	private:
		CustomNotificationProps * mNotificationProps;
		QPushButton *mFromKABC;
		QWidget* mainWidget;
		Ui::KopeteMetaLVIPropsWidget *ui_mainWidget;
		AddressBookLinkWidget *linkWidget;
		KopeteMetaContactLVI *item;
		KopeteAddressBookExport *mExport;
		KABC::Sound mSound;
		int m_countPhotoCapable;
		QMap<int, Kopete::Contact *> m_withPhotoContacts;
		QString mAddressBookUid; // the currently selected addressbook UID
		QString m_photoPath;
		
		Kopete::MetaContact::PropertySource selectedNameSource() const;
		Kopete::MetaContact::PropertySource selectedPhotoSource() const;
		Kopete::Contact* selectedNameSourceContact() const;
		Kopete::Contact* selectedPhotoSourceContact() const;
	private slots:
		void slotOkClicked();
		void slotUseCustomIconsToggled( bool on );
		void slotClearPhotoClicked();
		void slotAddresseeChanged( const KABC::Addressee & );
		void slotExportClicked();
		void slotImportClicked();
		void slotFromKABCClicked();
		void slotOpenSoundDialog( KUrlRequester *requester );
		void slotLoadNameSources();
		void slotLoadPhotoSources();
		void slotSelectPhoto();
		void slotEnableAndDisableWidgets();
};

#endif
