//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    using System.Text;
    using System.Collections.Generic;
    /// <remarks>
    ///  Provides information about I/O (Internet, etc.) settings chosen/set
    ///  by the end user.
    ///  KProtocolManager has a heap of static functions that allows only read
    ///  access to KDE's IO related settings. These include proxy, cache, file
    ///  transfer resumption, timeout and user-agent related settings.
    ///  The information provided by this class is generic enough to be applicable
    ///  to any application that makes use of KDE's IO sub-system.  Note that this
    ///  mean the proxy, timeout etc. settings are saved in a separate user-specific
    ///  config file and not in the config file of the application.
    ///  Original author:
    ///  Revised by:
    /// </remarks>        <author> Dawit Alemayehu <adawit@kde.org>
    /// </author>
    ///         <short>    Provides information about I/O (Internet, etc.</short>
    ///         <see> KPAC</see>
    [SmokeClass("KProtocolManager")]
    public class KProtocolManager : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected KProtocolManager(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KProtocolManager), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static KProtocolManager() {
            staticInterceptor = new SmokeInvocation(typeof(KProtocolManager), null);
        }
        /// <remarks>
        ///  Types of proxy configuration
        /// 
        /// <li>
        /// NoProxy     - No proxy is used
        /// </li>
        /// 
        /// <li>
        /// ManualProxy - Proxies are manually configured
        /// </li>
        /// 
        /// <li>
        /// PACProxy    - A Proxy configuration URL has been given
        /// </li>
        /// 
        /// <li>
        /// WPADProxy   - A proxy should be automatically discovered
        /// </li>
        /// 
        /// <li>
        /// EnvVarProxy - Use the proxy values set through environment variables.
        ///    
        /// </li></remarks>        <short>    Types of proxy configuration </short>
        public enum ProxyType {
            NoProxy = 0,
            ManualProxy = 1,
            PACProxy = 2,
            WPADProxy = 3,
            EnvVarProxy = 4,
        }
        /// <remarks>
        ///  Proxy authorization modes.
        /// 
        /// <li>
        /// Prompt     - Ask for authorization as needed
        /// </li>
        /// 
        /// <li>
        /// Automatic  - Use auto login as defined in kionetrc files.
        ///    
        /// </li></remarks>        <short>    Proxy authorization modes.</short>
        public enum ProxyAuthMode {
            Prompt = 0,
            Automatic = 1,
        }
        // KProtocolInfo::FileNameUsedForCopying fileNameUsedForCopying(const KUrl& arg1); >>>> NOT CONVERTED
        public KProtocolManager() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KProtocolManager", "KProtocolManager()", typeof(void));
        }
        ~KProtocolManager() {
            interceptor.Invoke("~KProtocolManager", "~KProtocolManager()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~KProtocolManager", "~KProtocolManager()", typeof(void));
        }
        /// <remarks>
        ///  Returns the default user-agent string used for web browsing.
        /// </remarks>        <return> the default user-agent string
        ///    </return>
        ///         <short>    Returns the default user-agent string used for web browsing.</short>
        public static string DefaultUserAgent() {
            return (string) staticInterceptor.Invoke("defaultUserAgent", "defaultUserAgent()", typeof(string));
        }
        /// <remarks>
        ///  Returns the default user-agent value used for web browsing, for example
        ///  "Mozilla/5.0 (compatible; Konqueror/4.0; Linux; X11; i686; en_US) KHTML/4.0.1 (like Gecko)"
        /// <param> name="keys" can be any of the following:
        /// </param>
        /// <li>
        /// 'o'	Show OS
        /// </li>
        /// 
        /// <li>
        /// 'v'	Show OS Version
        /// </li>
        /// 
        /// <li>
        /// 'p'	Show platform (only for X11)
        /// </li>
        /// 
        /// <li>
        /// 'm'	Show machine architecture
        /// </li>
        /// 
        /// <li>
        /// 'l'	Show language
        /// </li>
        /// </remarks>        <return> the default user-agent value with the given <code>keys</code>
        ///    </return>
        ///         <short>    Returns the default user-agent value used for web browsing, for example  "Mozilla/5.</short>
        public static string DefaultUserAgent(string keys) {
            return (string) staticInterceptor.Invoke("defaultUserAgent$", "defaultUserAgent(const QString&)", typeof(string), typeof(string), keys);
        }
        /// <remarks>
        ///  Returns the application's user-agent string.
        ///  Example string is "KMail/1.9.50 (Windows/6.0; KDE/3.97.1; i686; svn-762186; 2008-01-15)",
        ///  where "KMail" is the <code>appName</code> parameter, "1.9.50" is the <code>appVersion</code> parameter,
        ///  "Windows/6.0; KDE/3.97.1; i686" part is added automatically and "svn-762186; 2008-01-15"
        ///  is provided by <code>extraInfo</code> list.
        /// <param> name="appName" name of the application
        /// </param><param> name="appVersion" name of the application
        /// </param><param> name="extraInfo" a list of elements that will be appended to the string as extra information
        /// </param></remarks>        <return> the application's user-agent string
        /// </return>
        ///         <short>    Returns the application's user-agent string.</short>
        public static string UserAgentForApplication(string appName, string appVersion, List<string> extraInfo) {
            return (string) staticInterceptor.Invoke("userAgentForApplication$$?", "userAgentForApplication(const QString&, const QString&, const QStringList&)", typeof(string), typeof(string), appName, typeof(string), appVersion, typeof(List<string>), extraInfo);
        }
        public static string UserAgentForApplication(string appName, string appVersion) {
            return (string) staticInterceptor.Invoke("userAgentForApplication$$", "userAgentForApplication(const QString&, const QString&)", typeof(string), typeof(string), appName, typeof(string), appVersion);
        }
        /// <remarks>
        ///  Returns the user-agent string configured for the
        ///  specified host.
        ///  If hostname is not found or is empty (i.e. "" or
        ///  string()) this function will return the default
        ///  user agent.
        /// <param> name="hostname" name of the host
        /// </param></remarks>        <return> specified user-agent string
        ///    </return>
        ///         <short>    Returns the user-agent string configured for the  specified host.</short>
        public static string UserAgentForHost(string hostname) {
            return (string) staticInterceptor.Invoke("userAgentForHost$", "userAgentForHost(const QString&)", typeof(string), typeof(string), hostname);
        }
        public static bool GetSystemNameVersionAndMachine(StringBuilder systemName, StringBuilder systemVersion, StringBuilder machine) {
            return (bool) staticInterceptor.Invoke("getSystemNameVersionAndMachine$$$", "getSystemNameVersionAndMachine(QString&, QString&, QString&)", typeof(bool), typeof(StringBuilder), systemName, typeof(StringBuilder), systemVersion, typeof(StringBuilder), machine);
        }
        /// <remarks>
        ///  Returns the preferred timeout value for reading from
        ///  remote connections in seconds.
        /// </remarks>        <return> timeout value for remote connection in secs.
        ///    </return>
        ///         <short>    Returns the preferred timeout value for reading from  remote connections in seconds.</short>
        public static int ReadTimeout() {
            return (int) staticInterceptor.Invoke("readTimeout", "readTimeout()", typeof(int));
        }
        /// <remarks>
        ///  Returns the preferred timeout value for remote connections
        ///  in seconds.
        /// </remarks>        <return> timeout value for remote connection in secs.
        ///    </return>
        ///         <short>    Returns the preferred timeout value for remote connections  in seconds.</short>
        public static int ConnectTimeout() {
            return (int) staticInterceptor.Invoke("connectTimeout", "connectTimeout()", typeof(int));
        }
        /// <remarks>
        ///  Returns the preferred timeout value for proxy connections
        ///  in seconds.
        /// </remarks>        <return> timeout value for proxy connection in secs.
        ///    </return>
        ///         <short>    Returns the preferred timeout value for proxy connections  in seconds.</short>
        public static int ProxyConnectTimeout() {
            return (int) staticInterceptor.Invoke("proxyConnectTimeout", "proxyConnectTimeout()", typeof(int));
        }
        /// <remarks>
        ///  Returns the preferred response timeout value for
        ///  remote connecting in seconds.
        /// </remarks>        <return> timeout value for remote connection in seconds.
        ///    </return>
        ///         <short>    Returns the preferred response timeout value for  remote connecting in seconds.</short>
        public static int ResponseTimeout() {
            return (int) staticInterceptor.Invoke("responseTimeout", "responseTimeout()", typeof(int));
        }
        /// <remarks>
        ///  Returns whether or not the user specified the
        ///  use of proxy server to make connections.
        /// </remarks>        <return> true to use a proxy
        ///    </return>
        ///         <short>    Returns whether or not the user specified the  use of proxy server to make connections.</short>
        public static bool UseProxy() {
            return (bool) staticInterceptor.Invoke("useProxy", "useProxy()", typeof(bool));
        }
        /// <remarks>
        ///  Returns whether or not the the proxy server
        ///  lookup should be reversed or not.
        /// </remarks>        <return> true to use a reversed proxy
        ///    </return>
        ///         <short>    Returns whether or not the the proxy server  lookup should be reversed or not.</short>
        public static bool UseReverseProxy() {
            return (bool) staticInterceptor.Invoke("useReverseProxy", "useReverseProxy()", typeof(bool));
        }
        /// <remarks>
        ///  Returns the type of proxy configuration that is used.
        /// </remarks>        <return> the proxy type
        ///    </return>
        ///         <short>    Returns the type of proxy configuration that is used.</short>
        public static KProtocolManager.ProxyType proxyType() {
            return (KProtocolManager.ProxyType) staticInterceptor.Invoke("proxyType", "proxyType()", typeof(KProtocolManager.ProxyType));
        }
        /// <remarks>
        ///  Returns the way proxy authorization should be handled.
        /// </remarks>        <return> the proxy authorization mode
        /// </return>
        ///         <short>    Returns the way proxy authorization should be handled.</short>
        ///         <see> ProxyAuthMode</see>
        public static KProtocolManager.ProxyAuthMode proxyAuthMode() {
            return (KProtocolManager.ProxyAuthMode) staticInterceptor.Invoke("proxyAuthMode", "proxyAuthMode()", typeof(KProtocolManager.ProxyAuthMode));
        }
        /// <remarks>
        ///  Returns the strings for hosts that should contacted
        ///  DIRECTLY, bypassing any proxy settings.
        /// </remarks>        <return> a list of (comma-separated) hostnames or partial host
        ///          names
        ///    </return>
        ///         <short>    Returns the strings for hosts that should contacted  DIRECTLY, bypassing any proxy settings.</short>
        public static string NoProxyFor() {
            return (string) staticInterceptor.Invoke("noProxyFor", "noProxyFor()", typeof(string));
        }
        /// <remarks>
        ///  Returns the proxy server address for a given
        ///  protocol.
        /// <param> name="protocol" the protocol whose proxy info is needed
        /// </param></remarks>        <return> the proxy server address if one is available,
        ///           or string() if not available
        ///    </return>
        ///         <short>    Returns the proxy server address for a given  protocol.</short>
        public static string ProxyFor(string protocol) {
            return (string) staticInterceptor.Invoke("proxyFor$", "proxyFor(const QString&)", typeof(string), typeof(string), protocol);
        }
        /// <remarks>
        ///  Returns the Proxy server address for a given URL
        ///  If automatic proxy configuration is configured, KPAC
        ///  is used to determine the proxy server, otherwise the return
        ///  value of proxyFor for the URL's protocol is used.
        ///  If an empty string is returned, the request is to be aborted,
        ///  a return value of "DIRECT" requests a direct connection.
        /// <param> name="url" the URL whose proxy info is needed
        /// </param></remarks>        <return> the proxy server address if one is available
        ///           or string() otherwise
        ///    </return>
        ///         <short>    Returns the Proxy server address for a given URL  If automatic proxy configuration is configured, KPAC  is used to determine the proxy server, otherwise the return  value of proxyFor for the URL's protocol is used.</short>
        public static string ProxyForUrl(KUrl url) {
            return (string) staticInterceptor.Invoke("proxyForUrl#", "proxyForUrl(const KUrl&)", typeof(string), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Marks this proxy as bad (down). It will not be used for the
        ///  next 30 minutes. (The script may supply an alternate proxy)
        /// <param> name="proxy" the proxy to mark as bad (as URL)
        ///    </param></remarks>        <short>    Marks this proxy as bad (down).</short>
        public static void BadProxy(string proxy) {
            staticInterceptor.Invoke("badProxy$", "badProxy(const QString&)", typeof(void), typeof(string), proxy);
        }
        /// <remarks>
        ///  Returns the URL of the script for automatic proxy configuration.
        /// </remarks>        <return> the proxy configuration script
        ///    </return>
        ///         <short>    Returns the URL of the script for automatic proxy configuration.</short>
        public static string ProxyConfigScript() {
            return (string) staticInterceptor.Invoke("proxyConfigScript", "proxyConfigScript()", typeof(string));
        }
        /// <remarks>
        ///  Returns true/false to indicate whether a cache
        ///  should be used
        /// </remarks>        <return> true to use the cache, false otherwisea
        ///    </return>
        ///         <short>    Returns true/false to indicate whether a cache  should be used </short>
        public static bool UseCache() {
            return (bool) staticInterceptor.Invoke("useCache", "useCache()", typeof(bool));
        }
        /// <remarks>
        ///  Returns the maximum age in seconds cached files should be
        ///  kept before they are deleted as necessary.
        /// </remarks>        <return> the maximum cache age in seconds
        ///    </return>
        ///         <short>    Returns the maximum age in seconds cached files should be  kept before they are deleted as necessary.</short>
        public static int MaxCacheAge() {
            return (int) staticInterceptor.Invoke("maxCacheAge", "maxCacheAge()", typeof(int));
        }
        /// <remarks>
        ///  Returns the maximum size that can be used for caching.
        ///  By default this function returns the DEFAULT_MAX_CACHE_SIZE
        ///  value as defined in http_slave_defaults.h.  Not that the
        ///  value returned is in bytes, hence a value of 5120 would mean
        ///  5 Kb.
        /// </remarks>        <return> the maximum cache size in bytes
        ///    </return>
        ///         <short>    Returns the maximum size that can be used for caching.</short>
        public static int MaxCacheSize() {
            return (int) staticInterceptor.Invoke("maxCacheSize", "maxCacheSize()", typeof(int));
        }
        /// <remarks>
        ///  The directory which contains the cache files.
        /// </remarks>        <return> the directory that contains the cache files
        ///    </return>
        ///         <short>    The directory which contains the cache files.</short>
        public static string CacheDir() {
            return (string) staticInterceptor.Invoke("cacheDir", "cacheDir()", typeof(string));
        }
        /// <remarks>
        ///  Returns the Cache control directive to be used.
        /// </remarks>        <return> the cache control value
        ///    </return>
        ///         <short>    Returns the Cache control directive to be used.</short>
        public static KIO.CacheControl CacheControl() {
            return (KIO.CacheControl) staticInterceptor.Invoke("cacheControl", "cacheControl()", typeof(KIO.CacheControl));
        }
        /// <remarks>
        ///  Returns true if partial downloads should be
        ///  automatically resumed.
        /// </remarks>        <return> true to resume partial downloads
        ///    </return>
        ///         <short>    Returns true if partial downloads should be  automatically resumed.</short>
        public static bool AutoResume() {
            return (bool) staticInterceptor.Invoke("autoResume", "autoResume()", typeof(bool));
        }
        /// <remarks>
        ///  Returns true if partial downloads should be marked
        ///  with a ".part" extension.
        /// </remarks>        <return> true if partial downloads should get an ".part" extension
        ///    </return>
        ///         <short>    Returns true if partial downloads should be marked  with a ".</short>
        public static bool MarkPartial() {
            return (bool) staticInterceptor.Invoke("markPartial", "markPartial()", typeof(bool));
        }
        /// <remarks>
        ///  Returns the minimum file size for keeping aborted
        ///  downloads.
        ///  Any data downloaded that does not meet this minimum
        ///  requirement will simply be discarded. The default size
        ///  is 5 KB.
        /// </remarks>        <return> the minimum keep size for aborted downloads in bytes
        ///    </return>
        ///         <short>    Returns the minimum file size for keeping aborted  downloads.</short>
        public static int MinimumKeepSize() {
            return (int) staticInterceptor.Invoke("minimumKeepSize", "minimumKeepSize()", typeof(int));
        }
        /// <remarks>
        ///  Returns true if proxy connections should be persistent.
        /// </remarks>        <return> true if proxy connections should be persistent
        ///    </return>
        ///         <short>    Returns true if proxy connections should be persistent.</short>
        public static bool PersistentProxyConnection() {
            return (bool) staticInterceptor.Invoke("persistentProxyConnection", "persistentProxyConnection()", typeof(bool));
        }
        /// <remarks>
        ///  Returns true if connections should be persistent
        /// </remarks>        <return> true if the connections should be persistent
        ///    </return>
        ///         <short>    Returns true if connections should be persistent </short>
        public static bool PersistentConnections() {
            return (bool) staticInterceptor.Invoke("persistentConnections", "persistentConnections()", typeof(bool));
        }
        /// <remarks>
        ///  Returns whether the protocol can list files/objects.
        ///  If a protocol supports listing it can be browsed in e.g. file-dialogs
        ///  and konqueror.
        ///  Whether a protocol supports listing is determined by the "listing="
        ///  field in the protocol description file.
        ///  If the protocol support listing it should list the fields it provides in
        ///  this field. If the protocol does not support listing this field should
        ///  remain empty (default.)
        /// <param> name="url" the url to check
        /// </param></remarks>        <return> true if the protocol support listing
        /// </return>
        ///         <short>    Returns whether the protocol can list files/objects.</short>
        ///         <see> listing</see>
        public static bool SupportsListing(KUrl url) {
            return (bool) staticInterceptor.Invoke("supportsListing#", "supportsListing(const KUrl&)", typeof(bool), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Returns whether the protocol can retrieve data from URLs.
        ///  This corresponds to the "reading=" field in the protocol description file.
        ///  Valid values for this field are "true" or "false" (default).
        /// <param> name="url" the url to check
        /// </param></remarks>        <return> true if it is possible to read from the URL
        ///    </return>
        ///         <short>    Returns whether the protocol can retrieve data from URLs.</short>
        public static bool SupportsReading(KUrl url) {
            return (bool) staticInterceptor.Invoke("supportsReading#", "supportsReading(const KUrl&)", typeof(bool), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Returns whether the protocol can store data to URLs.
        ///  This corresponds to the "writing=" field in the protocol description file.
        ///  Valid values for this field are "true" or "false" (default).
        /// <param> name="url" the url to check
        /// </param></remarks>        <return> true if the protocol supports writing
        ///    </return>
        ///         <short>    Returns whether the protocol can store data to URLs.</short>
        public static bool SupportsWriting(KUrl url) {
            return (bool) staticInterceptor.Invoke("supportsWriting#", "supportsWriting(const KUrl&)", typeof(bool), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Returns whether the protocol can create directories/folders.
        ///  This corresponds to the "makedir=" field in the protocol description file.
        ///  Valid values for this field are "true" or "false" (default).
        /// <param> name="url" the url to check
        /// </param></remarks>        <return> true if the protocol can create directories
        ///    </return>
        ///         <short>    Returns whether the protocol can create directories/folders.</short>
        public static bool SupportsMakeDir(KUrl url) {
            return (bool) staticInterceptor.Invoke("supportsMakeDir#", "supportsMakeDir(const KUrl&)", typeof(bool), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Returns whether the protocol can delete files/objects.
        ///  This corresponds to the "deleting=" field in the protocol description file.
        ///  Valid values for this field are "true" or "false" (default).
        /// <param> name="url" the url to check
        /// </param></remarks>        <return> true if the protocol supports deleting
        ///    </return>
        ///         <short>    Returns whether the protocol can delete files/objects.</short>
        public static bool SupportsDeleting(KUrl url) {
            return (bool) staticInterceptor.Invoke("supportsDeleting#", "supportsDeleting(const KUrl&)", typeof(bool), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Returns whether the protocol can create links between files/objects.
        ///  This corresponds to the "linking=" field in the protocol description file.
        ///  Valid values for this field are "true" or "false" (default).
        /// <param> name="url" the url to check
        /// </param></remarks>        <return> true if the protocol supports linking
        ///    </return>
        ///         <short>    Returns whether the protocol can create links between files/objects.</short>
        public static bool SupportsLinking(KUrl url) {
            return (bool) staticInterceptor.Invoke("supportsLinking#", "supportsLinking(const KUrl&)", typeof(bool), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Returns whether the protocol can move files/objects between different
        ///  locations.
        ///  This corresponds to the "moving=" field in the protocol description file.
        ///  Valid values for this field are "true" or "false" (default).
        /// <param> name="url" the url to check
        /// </param></remarks>        <return> true if the protocol supports moving
        ///    </return>
        ///         <short>    Returns whether the protocol can move files/objects between different  locations.</short>
        public static bool SupportsMoving(KUrl url) {
            return (bool) staticInterceptor.Invoke("supportsMoving#", "supportsMoving(const KUrl&)", typeof(bool), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Returns whether the protocol can be opened using KIO.Open(KUrl).
        ///  This corresponds to the "opening=" field in the protocol description file.
        ///  Valid values for this field are "true" or "false" (default).
        /// <param> name="url" the url to check
        /// </param></remarks>        <return> true if the protocol supports opening
        ///    </return>
        ///         <short>    Returns whether the protocol can be opened using KIO.Open(KUrl).</short>
        public static bool SupportsOpening(KUrl url) {
            return (bool) staticInterceptor.Invoke("supportsOpening#", "supportsOpening(const KUrl&)", typeof(bool), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Returns whether the protocol can copy files/objects directly from the
        ///  filesystem itself. If not, the application will read files from the
        ///  filesystem using the file-protocol and pass the data on to the destination
        ///  protocol.
        ///  This corresponds to the "copyFromFile=" field in the protocol description file.
        ///  Valid values for this field are "true" or "false" (default).
        /// <param> name="url" the url to check
        /// </param></remarks>        <return> true if the protocol can copy files from the local file system
        ///    </return>
        ///         <short>    Returns whether the protocol can copy files/objects directly from the  filesystem itself.</short>
        public static bool CanCopyFromFile(KUrl url) {
            return (bool) staticInterceptor.Invoke("canCopyFromFile#", "canCopyFromFile(const KUrl&)", typeof(bool), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Returns whether the protocol can copy files/objects directly to the
        ///  filesystem itself. If not, the application will receive the data from
        ///  the source protocol and store it in the filesystem using the
        ///  file-protocol.
        ///  This corresponds to the "copyToFile=" field in the protocol description file.
        ///  Valid values for this field are "true" or "false" (default).
        /// <param> name="url" the url to check
        /// </param></remarks>        <return> true if the protocol can copy files to the local file system
        ///    </return>
        ///         <short>    Returns whether the protocol can copy files/objects directly to the  filesystem itself.</short>
        public static bool CanCopyToFile(KUrl url) {
            return (bool) staticInterceptor.Invoke("canCopyToFile#", "canCopyToFile(const KUrl&)", typeof(bool), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Returns whether the protocol can rename (i.e. move fast) files/objects
        ///  directly from the filesystem itself. If not, the application will read
        ///  files from the filesystem using the file-protocol and pass the data on
        ///  to the destination protocol.
        ///  This corresponds to the "renameFromFile=" field in the protocol description file.
        ///  Valid values for this field are "true" or "false" (default).
        /// <param> name="url" the url to check
        /// </param></remarks>        <return> true if the protocol can rename/move files from the local file system
        ///    </return>
        ///         <short>    Returns whether the protocol can rename (i.</short>
        public static bool CanRenameFromFile(KUrl url) {
            return (bool) staticInterceptor.Invoke("canRenameFromFile#", "canRenameFromFile(const KUrl&)", typeof(bool), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Returns whether the protocol can rename (i.e. move fast) files/objects
        ///  directly to the filesystem itself. If not, the application will receive
        ///  the data from the source protocol and store it in the filesystem using the
        ///  file-protocol.
        ///  This corresponds to the "renameToFile=" field in the protocol description file.
        ///  Valid values for this field are "true" or "false" (default).
        /// <param> name="url" the url to check
        /// </param></remarks>        <return> true if the protocol can rename files to the local file system
        ///    </return>
        ///         <short>    Returns whether the protocol can rename (i.</short>
        public static bool CanRenameToFile(KUrl url) {
            return (bool) staticInterceptor.Invoke("canRenameToFile#", "canRenameToFile(const KUrl&)", typeof(bool), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Returns whether the protocol can recursively delete directories by itself.
        ///  If not (the usual case) then KIO will list the directory and delete files
        ///  and empty directories one by one.
        ///  This corresponds to the "deleteRecursive=" field in the protocol description file.
        ///  Valid values for this field are "true" or "false" (default).
        /// <param> name="url" the url to check
        /// </param></remarks>        <return> true if the protocol can delete non-empty directories by itself.
        ///    </return>
        ///         <short>    Returns whether the protocol can recursively delete directories by itself.</short>
        public static bool CanDeleteRecursive(KUrl url) {
            return (bool) staticInterceptor.Invoke("canDeleteRecursive#", "canDeleteRecursive(const KUrl&)", typeof(bool), typeof(KUrl), url);
        }
        /// <remarks>
        ///  This setting defines the strategy to use for generating a filename, when
        ///  copying a file or directory to another directory. By default the destination
        ///  filename is made out of the filename in the source URL. However if the
        ///  ioslave displays names that are different from the filename of the URL
        ///  (e.g. kio_fonts shows Arial for arial.ttf, or kio_trash shows foo.txt and
        ///  uses some internal URL), using Name means that the display name (UDS_NAME)
        ///  will be used to as the filename in the destination directory.
        ///  This corresponds to the "fileNameUsedForCopying=" field in the protocol description file.
        ///  Valid values for this field are "Name" or "FromURL" (default).
        /// <param> name="url" the url to check
        /// </param></remarks>        <return> how to generate the filename in the destination directory when copying/moving
        ///    </return>
        ///         <short>    This setting defines the strategy to use for generating a filename, when  copying a file or directory to another directory.</short>
        /// <remarks>
        ///  Returns default mimetype for this URL based on the protocol.
        ///  This corresponds to the "defaultMimetype=" field in the protocol description file.
        /// <param> name="url" the url to check
        /// </param></remarks>        <return> the default mime type of the protocol, or null if unknown
        ///    </return>
        ///         <short>    Returns default mimetype for this URL based on the protocol.</short>
        public static string DefaultMimetype(KUrl url) {
            return (string) staticInterceptor.Invoke("defaultMimetype#", "defaultMimetype(const KUrl&)", typeof(string), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Returns whether the protocol should be treated as a filesystem
        ///  or as a stream when reading from it.
        ///  This corresponds to the "input=" field in the protocol description file.
        ///  Valid values for this field are "filesystem", "stream" or "none" (default).
        /// <param> name="url" the url to check
        /// </param></remarks>        <return> the input type of the given <code>url</code>
        ///    </return>
        ///         <short>    Returns whether the protocol should be treated as a filesystem  or as a stream when reading from it.</short>
        public static KProtocolInfo.TypeOf InputType(KUrl url) {
            return (KProtocolInfo.TypeOf) staticInterceptor.Invoke("inputType#", "inputType(const KUrl&)", typeof(KProtocolInfo.TypeOf), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Returns whether the protocol should be treated as a filesystem
        ///  or as a stream when writing to it.
        ///  This corresponds to the "output=" field in the protocol description file.
        ///  Valid values for this field are "filesystem", "stream" or "none" (default).
        /// <param> name="url" the url to check
        /// </param></remarks>        <return> the output type of the given <code>url</code>
        ///    </return>
        ///         <short>    Returns whether the protocol should be treated as a filesystem  or as a stream when writing to it.</short>
        public static KProtocolInfo.TypeOf OutputType(KUrl url) {
            return (KProtocolInfo.TypeOf) staticInterceptor.Invoke("outputType#", "outputType(const KUrl&)", typeof(KProtocolInfo.TypeOf), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Returns the list of fields this protocol returns when listing
        ///  The current possibilities are
        ///  Name, Type, Size, Date, AccessDate, Access, Owner, Group, Link, URL, MimeType
        ///  as well as Extra1, Extra2 etc. for extra fields (see extraFields).
        ///  This corresponds to the "listing=" field in the protocol description file.
        ///  The supported fields should be separated with ',' in the protocol description file.
        /// <param> name="url" the url to check
        /// </param></remarks>        <return> a list of field names
        ///    </return>
        ///         <short>    Returns the list of fields this protocol returns when listing  The current possibilities are  Name, Type, Size, Date, AccessDate, Access, Owner, Group, Link, URL, MimeType  as well as Extra1, Extra2 etc.</short>
        public static List<string> Listing(KUrl url) {
            return (List<string>) staticInterceptor.Invoke("listing#", "listing(const KUrl&)", typeof(List<string>), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Returns whether the protocol can act as a source protocol.
        ///  A source protocol retrieves data from or stores data to the
        ///  location specified by a URL.
        ///  A source protocol is the opposite of a filter protocol.
        ///  The "source=" field in the protocol description file determines
        ///  whether a protocol is a source protocol or a filter protocol.
        /// <param> name="url" the url to check
        /// </param></remarks>        <return> true if the protocol is a source of data (e.g. http), false if the
        ///          protocol is a filter (e.g. gzip)
        ///    </return>
        ///         <short>    Returns whether the protocol can act as a source protocol.</short>
        public static bool IsSourceProtocol(KUrl url) {
            return (bool) staticInterceptor.Invoke("isSourceProtocol#", "isSourceProtocol(const KUrl&)", typeof(bool), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Returns which protocol handles this mimetype, if it's an archive mimetype.
        ///  For instance zip:/ handles application/x-zip.
        ///  This is defined in the protocol description file using an entry like
        ///  "archiveMimetype=application/x-zip"
        /// <param> name="mimetype" the mimetype to check
        /// </param></remarks>        <return> the protocol that can handle this archive mimetype, for instance "zip".
        /// </return>
        ///         <short>    Returns which protocol handles this mimetype, if it's an archive mimetype.</short>
        public static string ProtocolForArchiveMimetype(string mimeType) {
            return (string) staticInterceptor.Invoke("protocolForArchiveMimetype$", "protocolForArchiveMimetype(const QString&)", typeof(string), typeof(string), mimeType);
        }
        /// <remarks>
        ///  Force a reload of the general config file of
        ///  io-slaves ( kioslaverc).
        ///    </remarks>        <short>    Force a reload of the general config file of  io-slaves ( kioslaverc).</short>
        public static void ReparseConfiguration() {
            staticInterceptor.Invoke("reparseConfiguration", "reparseConfiguration()", typeof(void));
        }
        /// <remarks>
        ///  Return the protocol to use in order to handle the given <code>url</code>
        ///  It's usually the same, except that FTP, when handled by a proxy,
        ///  needs an HTTP ioslave.
        ///  When a proxy is to be used, proxy contains the URL for the proxy.
        /// <param> name="url" the url to check
        /// </param><param> name="proxy" the URL of the proxy to use
        /// </param></remarks>        <return> the slave protocol (e.g. 'http'), can be null if unknown
        ///    </return>
        ///         <short>    Return the protocol to use in order to handle the given <code>url</code>  It's usually the same, except that FTP, when handled by a proxy,  needs an HTTP ioslave.</short>
        public static string SlaveProtocol(KUrl url, StringBuilder proxy) {
            return (string) staticInterceptor.Invoke("slaveProtocol#$", "slaveProtocol(const KUrl&, QString&)", typeof(string), typeof(KUrl), url, typeof(StringBuilder), proxy);
        }
        /// <remarks>
        ///  Return Accept-Languages header built up according to user's desktop
        ///  language settings.
        /// </remarks>        <return> Accept-Languages header string
        ///    </return>
        ///         <short>    Return Accept-Languages header built up according to user's desktop  language settings.</short>
        public static string AcceptLanguagesHeader() {
            return (string) staticInterceptor.Invoke("acceptLanguagesHeader", "acceptLanguagesHeader()", typeof(string));
        }
    }
}
