/***************************************************************************
* $Id: Main.java 142206 2002-03-10 16:08:04Z rdale $
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/
import org.kde.qt.*;

public class Main {

/*
  The program starts here. It parses the command line and builds a message
  string to be displayed by the Hello widget.
*/

public static void main( String[] args )
{
    QApplication a = new QApplication(args);
    String s = "";
    for ( int i=1; i<args.length; i++ ) {
	s += args[i];
	if ( i<args.length-1 )
	    s += " ";
    }
    if ( s.equals("") )
	s = "Hello, World";
    Hello h = new Hello( s );
    h.setCaption( "Qt says hello" );
    QObject.connect( h, Qt.SIGNAL("clicked()"), a, Qt.SLOT("quit()") );
    h.setFont( new QFont("times",32,QFont.Bold) );		// default font
    h.setBackgroundColor( Qt.white() );			// default bg color
    a.setMainWidget( h );
    h.show();
    a.exec();
	return;
}

static {
	qtjava.initialize();
}

}
