"""
Copyright 2003 Jim Bublitz

Terms and Conditions

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

Except as contained in this notice, the name of the copyright holder shall
not be used in advertising or otherwise to promote the sale, use or other
dealings in this Software without prior written authorization from the
copyright holder.
"""

import sys

from qt import QWidget, SIGNAL
from kdecore import KApplication, KIconLoader
from kdeui import  KSystemTray

"""
Typically an application's "main window" will be a KMainWindow or
a subclass of KMainWindow (KMainWindow provides simple mechanisms
for constructing mens, toolbars, statusbars, etc). The problem with
using KMainWindow in a System Tray application is that when
KMainWindow is closed, it also shuts down KApplication and the
program terminates.

One way around that (not necessarily the best way - see systray1.py)
is to make the "main window" a QWidget or other QWidget subclass
that's not KMainWindow.
"""

class MainWin (QWidget):
    def __init__ (self, *args):
        apply (QWidget.__init__, (self,) + args)

#-------------------- main ------------------------------------------------

# This slot receives the "quitSelected ()" signal that's emitted
# when the user right clicks the icon in the system tray and
# selects "Quit" from the popup menu
def slotQuitSelected ():
    KApplication.kApplication ().quit ()

# The usual stuff
appName = "template"
app = KApplication (sys.argv, appName)
mainWindow = MainWin (None, "main window")

# System tray apps need an icon
icons = KIconLoader ()

# The KSystemTray widget shows or hides it's parent widget
# when clicked, so parent needs to be the main window
systray = KSystemTray (mainWindow)

systray.setPixmap (icons.loadIcon("stop", 0))
systray.connect (systray, SIGNAL ("quitSelected ()"), slotQuitSelected)
systray.show ()

# Comment this out if you don't want the main window to show
# immediately when the application loads
mainWindow.show()
app.exec_loop()


