/***************************************************************************
                          qtjava.cpp  -  description
                             -------------------
    begin                : Tue Oct 31 2000
    copyright            : (C) 2000 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    written by           : Richard Dale.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   Lost Highway Ltd reserves the right to issue additional license types *
 *   compatible with the Trolltech AS Qt commercial license.               *
 ***************************************************************************/

#include <qtjava/qtjava.h>
#include <qtjava/QtSupport.h>
#include <qtjava/JavaSlot.h>

#include <qobject.h>

JNIEXPORT jobject JNICALL
Java_org_kde_qt_qtjava_allocateInstance(JNIEnv * env, jclass cls, jclass targetClass)
{
	return (jobject) env->AllocObject(targetClass);
}


JNIEXPORT jclass JNICALL
Java_org_kde_qt_qtjava_classFromQtMetaData(JNIEnv * env, jclass cls, jclass approximateClass, jstring approximateClassName, jlong qt)
{
	jclass			exactClass;
	const char *	className;
static char fullyQualifiedClassName[200];

	className = (const char *)((QObject*) qt)->className();
	
	if (className[0] == 'Q') {
		(void) sprintf(fullyQualifiedClassName, "org/kde/qt/%s", className);
	} else if (className[0] == 'K') {
		(void) sprintf(fullyQualifiedClassName, "org/kde/koala/%s", className);
	} else {
		(void) strcpy(fullyQualifiedClassName, className);
		exactClass = env->FindClass(fullyQualifiedClassName);
	
		if (exactClass != 0) {
			// An unqualified classname, with no package, has been found
			return exactClass;
		}
		
		// Assume that any classes are part of org.kde.koala if they don't start with 'K' or 'Q',
		// but haven't just been found without a package qualifier.
		env->ExceptionClear();
		(void) sprintf(fullyQualifiedClassName, "org/kde/koala/%s", className);
	}
	
	exactClass = env->FindClass(fullyQualifiedClassName);
	
	if (exactClass == 0) {
		env->ExceptionClear();
		return approximateClass;
	}
	
	return exactClass;
}

JNIEXPORT void JNICALL
Java_org_kde_qt_qtjava_registerJVM(JNIEnv * env, jclass cls)
{
	QtSupport::registerJVM(env);	
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_qt_qtjava_setAllocatedInJavaWorld(JNIEnv * env, jclass cls, jobject obj, jboolean yn)
{
	QtSupport::setAllocatedInJavaWorld(env, obj, (bool) yn);
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_qt_qtjava_setQt(JNIEnv * env, jclass cls, jobject obj, jlong qt)
{
	QtSupport::setQt(env, obj, (void *) qt);
	return;
}

JNIEXPORT jlong JNICALL
Java_org_kde_qt_qtjava_newJavaSignal(JNIEnv * env, jclass cls)
{
	return (jlong) new JavaSignal();
}

JNIEXPORT void JNICALL
Java_org_kde_qt_qtjava_setJavaSlotFactory(JNIEnv * env, jclass cls)
{
	JavaSlot::setJavaSlotFactory(new JavaSlotFactory());
	return;
}

JNIEXPORT jlong JNICALL
Java_org_kde_qt_qtjava_newJavaSlot(JNIEnv * env, jclass cls, jobject receiver, jstring member)
{
	return (jlong) JavaSlot::createJavaSlot(receiver, member);
}
