class Q_EXPORT QRect					// rectangle class
{
public:
    QRect();
    QRect( const QRect& );
    QRect( const QPoint &topleft, const QPoint &bottomright );
    QRect( const QPoint &topleft, const QSize &size );
    QRect( int left, int top, int width, int height );

    bool   isNull()	const;
    bool   isEmpty()	const;
    bool   isValid()	const;
    QRect  normalize()	const;

    int	   left()	const prop(left);
    int	   top()	const prop(top);
    int	   right()	const prop(right);
    int	   bottom()	const prop(bottom);
	
    int	   x()		const prop(x);
    int	   y()		const prop(y);
    void   setLeft( int pos ) prop(left);
    void   setTop( int pos ) prop(top);
    void   setRight( int pos ) prop(right);
    void   setBottom( int pos ) prop( bottom);
    void   setX( int x ) prop(x);
    void   setY( int y ) prop(y);

    QPoint topLeft()	 const prop(topLeft);
    QPoint bottomRight() const prop(bottomRight);
    QPoint topRight()	 const prop(topRight);
    QPoint bottomLeft()	 const prop(bottomLeft);
    QPoint center()	 const prop(center);

    void   rect( int *x, int *y, int *w, int *h ) const;
    void   coords( int *x1, int *y1, int *x2, int *y2 ) const;

    void   moveTopLeft( const QPoint &p );
    void   moveBottomRight( const QPoint &p );
    void   moveTopRight( const QPoint &p );
    void   moveBottomLeft( const QPoint &p );
    void   moveCenter( const QPoint &p );
    void   moveBy( int dx, int dy );

    void   setRect( int x, int y, int w, int h );
    void   setCoords( int x1, int y1, int x2, int y2 );

    QSize  size()	const prop(size);
    int	   width()	const prop(width);
    int	   height()	const prop(height);
    void   setWidth( int w ) prop(width);
    void   setHeight( int h ) prop(height);
    void   setSize( const QSize &s ) prop(size);

    QRect  operator|(const QRect &r) const;
    QRect  operator&(const QRect &r) const;
    QRect&  operator|=(const QRect &r);
    QRect&  operator&=(const QRect &r);

    bool   contains( const QPoint &p, bool proper=FALSE ) const;
    bool   contains( const QRect &r, bool proper=FALSE ) const;
    QRect  unite( const QRect &r ) const;
    QRect  intersect( const QRect &r ) const;
    bool   intersects( const QRect &r ) const;

    friend Q_EXPORT bool operator==( const QRect &, const QRect & );
    friend Q_EXPORT bool operator!=( const QRect &, const QRect & );
};

